// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/* parser generated by jison 0.4.17 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
import SqlParseSupport from 'parse/sql/phoenix/sqlParseSupport';

var phoenixSyntaxParser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[4,8,12,16,162,174,241,271,321,337,340,344],$V1=[2,624],$V2=[340,344],$V3=[2,625],$V4=[1,35],$V5=[1,27],$V6=[1,28],$V7=[1,18],$V8=[1,36],$V9=[1,33],$Va=[1,34],$Vb=[1,29],$Vc=[1,32],$Vd=[1,30],$Ve=[1,45],$Vf=[1,47],$Vg=[1,43],$Vh=[1,46],$Vi=[1,42],$Vj=[81,340,344],$Vk=[2,451],$Vl=[1,53],$Vm=[1,61],$Vn=[1,62],$Vo=[1,75],$Vp=[2,413],$Vq=[1,80],$Vr=[1,81],$Vs=[32,267],$Vt=[16,32,43,50,54,55,63,77,79,81,85,95,107,108,109,112,113,120,125,129,140,142,154,182,190,201,214,215,216,217,218,219,220,221,222,226,228,232,239,240,253,262,264,267,340,344,348,349,352,356,357,358,359,360,361,363,366,367,368,369,371,374,375,376,377,379,380,382,384,385,386,387,388,391,392,405,439],$Vu=[81,262,340,344],$Vv=[63,113,228,340,344,348,349],$Vw=[2,781],$Vx=[1,95],$Vy=[63,113,228,348,349,358],$Vz=[63,113,228,306,340,344,348,349,358],$VA=[2,778],$VB=[1,100],$VC=[55,63,113,228,348,349,358],$VD=[16,63,113,228,348,349,358],$VE=[79,85,241],$VF=[1,166],$VG=[1,167],$VH=[1,122],$VI=[1,117],$VJ=[1,128],$VK=[1,130],$VL=[1,132],$VM=[1,115],$VN=[1,164],$VO=[1,168],$VP=[1,169],$VQ=[1,133],$VR=[1,155],$VS=[1,156],$VT=[1,157],$VU=[1,158],$VV=[1,159],$VW=[1,160],$VX=[1,161],$VY=[1,162],$VZ=[1,148],$V_=[1,149],$V$=[1,142],$V01=[1,131],$V11=[1,143],$V21=[1,118],$V31=[1,120],$V41=[1,119],$V51=[1,123],$V61=[1,121],$V71=[1,163],$V81=[1,165],$V91=[54,55,63,79,81,95,96,107,112,113,228,241,253,267,269,270,271,294,295,296,297,298,299,300,301,302,303,304,306,307,348,349,351,352,355,358,362,370,389,390],$Va1=[81,85,182,262,340,344],$Vb1=[2,1102],$Vc1=[1,222],$Vd1=[1,237],$Ve1=[1,238],$Vf1=[1,226],$Vg1=[1,223],$Vh1=[1,224],$Vi1=[1,225],$Vj1=[1,232],$Vk1=[1,231],$Vl1=[1,230],$Vm1=[1,233],$Vn1=[1,228],$Vo1=[1,227],$Vp1=[1,221],$Vq1=[1,229],$Vr1=[1,240],$Vs1=[1,239],$Vt1=[32,43,54,55,63,77,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,253,262,264,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$Vu1=[1,246],$Vv1=[1,252],$Vw1=[1,254],$Vx1=[32,43,54,55,63,77,79,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,253,262,264,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$Vy1=[1,259],$Vz1=[32,43,50,54,55,63,77,79,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,253,262,264,267,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$VA1=[32,43,54,55,63,77,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,253,262,264,318,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$VB1=[43,54,55,63,81,85,113,125,140,154,190,201,214,215,216,217,218,219,220,221,222,226,228,232,262,264,340,344,348,349,358],$VC1=[43,50,81,85,95,96,109,182,190,201,214,215,216,217,218,219,220,221,222,226,232,262,264,340,344],$VD1=[81,85],$VE1=[2,46],$VF1=[1,288],$VG1=[43,340,344],$VH1=[43,125,340,344],$VI1=[43,50,77,79,125,340,344],$VJ1=[43,50],$VK1=[264,340,344],$VL1=[85,182,264,340,344],$VM1=[32,50,81,85],$VN1=[174,241],$VO1=[2,1080],$VP1=[81,190,201,226,232,262,340,344],$VQ1=[2,464],$VR1=[1,316],$VS1=[96,247,269,270],$VT1=[81,85,182,190,201,214,215,216,217,218,219,220,221,222,226,232,262,264,340,344],$VU1=[43,54,55,63,81,85,95,113,129,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,262,264,340,344,348,349,356,358,359,368,369,377,382,386,392,439],$VV1=[32,43,54,55,63,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,253,262,264,340,344,348,349,352,356,357,358,359,368,369,377,382,386,392,439],$VW1=[368,369,392],$VX1=[54,55,63,79,95,96,107,112,113,228,267,269,270,271,294,295,296,297,298,299,300,301,302,303,304,306,307,348,349,351,352,355,358,362,370,389,390],$VY1=[32,43,50,54,55,63,77,81,85,95,96,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,222,226,228,232,239,240,253,262,264,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$VZ1=[32,43,50,54,55,63,77,81,85,95,96,108,109,113,125,129,140,142,154,182,190,201,214,215,216,217,218,219,220,221,222,226,228,232,239,240,253,262,264,267,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$V_1=[81,201,226,232,262,340,344],$V$1=[81,85,190,201,226,232,262,264,340,344],$V02=[1,418],$V12=[1,421],$V22=[1,419],$V32=[1,423],$V42=[1,420],$V52=[1,422],$V62=[1,425],$V72=[1,424],$V82=[81,85,190,201,214,215,216,217,218,219,220,221,222,226,232,262,264,340,344],$V92=[43,54,55,63,81,85,113,190,201,214,215,216,217,218,219,220,221,222,226,228,232,262,264,340,344,348,349,358],$Va2=[32,43,54,55,63,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,262,264,340,344,348,349,356,358,359,368,369,377,382,386,392,439],$Vb2=[43,54,55,63,81,85,113,129,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,262,264,340,344,348,349,356,358,368,369,377,382,386,392,439],$Vc2=[1,443],$Vd2=[81,232],$Ve2=[1,457],$Vf2=[1,483],$Vg2=[1,484],$Vh2=[1,485],$Vi2=[1,471],$Vj2=[1,472],$Vk2=[1,473],$Vl2=[1,474],$Vm2=[1,475],$Vn2=[1,476],$Vo2=[1,477],$Vp2=[1,478],$Vq2=[1,479],$Vr2=[1,480],$Vs2=[1,481],$Vt2=[1,482],$Vu2=[81,226,232,262,340,344],$Vv2=[55,63,79,113,228,348,349,358],$Vw2=[1,517],$Vx2=[81,85,232],$Vy2=[32,43,54,55,63,77,81,85,95,108,109,113,129,142,182,190,201,214,215,216,217,218,219,220,221,222,226,228,232,239,240,253,262,264,340,344,348,349,352,356,357,358,359,368,369,374,376,377,379,380,382,386,392,439],$Vz2=[1,525],$VA2=[85,340,344],$VB2=[1,541],$VC2=[1,542],$VD2=[50,81,85,95,96,109],$VE2=[2,892],$VF2=[1,545],$VG2=[81,226,262,340,344],$VH2=[81,85,190,201,214,215,216,217,218,219,220,221,226,232,262,264,340,344],$VI2=[2,372],$VJ2=[1,561],$VK2=[50,81,85,95,96],$VL2=[81,85,201,226,232,262,340,344],$VM2=[359,494],$VN2=[1,617],$VO2=[85,109],$VP2=[81,356,364,389,494],$VQ2=[2,1138],$VR2=[81,85,129,226,262,340,344,382],$VS2=[81,356],$VT2=[2,1148],$VU2=[1,650],$VV2=[1,651],$VW2=[1,652],$VX2=[1,660],$VY2=[1,661],$VZ2=[2,1153],$V_2=[1,668],$V$2=[372,378],$V03=[2,196],$V13=[2,197];
var parser = {trace: function trace () { },
yy: {},
symbols_: {"error":2,"DataDefinition_EDIT":3,"ALTER":4,"CURSOR":5,"AlterTable_EDIT":6,"AlterView_EDIT":7,"CREATE":8,"DatabaseDefinition_EDIT":9,"TableDefinition_EDIT":10,"ViewDefinition_EDIT":11,"DROP":12,"DropDatabaseStatement_EDIT":13,"DropTableStatement_EDIT":14,"DropViewStatement_EDIT":15,"SET":16,"TruncateTableStatement_EDIT":17,"UseStatement_EDIT":18,"DataDefinition":19,"AlterTable":20,"AlterView":21,"DatabaseDefinition":22,"RoleDefinition":23,"TableDefinition":24,"ViewDefinition":25,"DropDatabaseStatement":26,"DropRoleStatement":27,"DropTableStatement":28,"DropViewStatement":29,"ALL":30,"SetOption":31,"=":32,"SetValue":33,"TruncateTableStatement":34,"UseStatement":35,"AlterTableLeftSide":36,"PartitionSpec":37,"AlterTableLeftSide_EDIT":38,"TABLE":39,"SchemaQualifiedTableIdentifier":40,"SchemaQualifiedTableIdentifier_EDIT":41,"AlterViewLeftSide":42,"AS":43,"QuerySpecification":44,"AlterViewLeftSide_EDIT":45,"QuerySpecification_EDIT":46,"VIEW":47,"OptionalComment":48,"Comment":49,"COMMENT":50,"QuotedValue":51,"OptionalComment_INVALID":52,"Comment_INVALID":53,"SINGLE_QUOTE":54,"DOUBLE_QUOTE":55,"VALUE":56,"DatabaseOrSchema":57,"OptionalIfNotExists":58,"RegularIdentifier":59,"DatabaseDefinitionOptionals":60,"OptionalIfNotExists_EDIT":61,"DatabaseDefinitionOptionals_EDIT":62,"ROLE":63,"TableDefinitionRightPart":64,"TableDefinitionRightPart_EDIT":65,"TableIdentifierAndOptionalColumnSpecification":66,"OptionalPartitionedBy":67,"OptionalAsSelectStatement":68,"TableIdentifierAndOptionalColumnSpecification_EDIT":69,"PartitionedBy_EDIT":70,"OptionalAsSelectStatement_EDIT":71,"SchemaQualifiedIdentifier":72,"OptionalColumnSpecificationsOrLike":73,"OptionalColumnSpecificationsOrLike_EDIT":74,"SchemaQualifiedIdentifier_EDIT":75,"ParenthesizedColumnSpecificationList":76,"LIKE":77,"ParenthesizedColumnSpecificationList_EDIT":78,"(":79,"ColumnSpecificationList":80,")":81,"ColumnSpecificationList_EDIT":82,"RightParenthesisOrError":83,"ColumnSpecification":84,",":85,"ColumnSpecification_EDIT":86,"ColumnIdentifier":87,"ColumnDataType":88,"OptionalColumnOptions":89,"ColumnDataType_EDIT":90,"ColumnOptions_EDIT":91,"ColumnOptions":92,"ColumnOption":93,"ColumnOption_EDIT":94,"NOT":95,"NULL":96,"PrimitiveType":97,"ArrayType":98,"MapType":99,"StructType":100,"ArrayType_INVALID":101,"MapType_INVALID":102,"StructType_INVALID":103,"ArrayType_EDIT":104,"MapType_EDIT":105,"StructType_EDIT":106,"ARRAY":107,"<":108,">":109,"AnyCursor":110,"GreaterThanOrError":111,"MAP":112,"STRUCT":113,"StructDefinitionList":114,"StructDefinitionList_EDIT":115,"StructDefinition":116,"StructDefinition_EDIT":117,"Commas":118,"RegularOrBacktickedIdentifier":119,":":120,"ColumnDataTypeList":121,"ColumnDataTypeList_EDIT":122,"ColumnDataTypeListInner_EDIT":123,"PartitionedBy":124,"PARTITION":125,"BY":126,"RangeClause":127,"RangeClause_EDIT":128,"RANGE":129,"ParenthesizedColumnList":130,"ParenthesizedPartitionValuesList":131,"ParenthesizedColumnList_EDIT":132,"ParenthesizedPartitionValuesList_EDIT":133,"PartitionValueList":134,"PartitionValueList_EDIT":135,"PartitionValue":136,"PartitionValue_EDIT":137,"ValueExpression":138,"LessThanOrEqualTo":139,"VALUES":140,"ValueExpression_EDIT":141,"COMPARISON_OPERATOR":142,"CommitLocations":143,"OptionalParenthesizedViewColumnList":144,"ParenthesizedViewColumnList_EDIT":145,"ParenthesizedViewColumnList":146,"ViewColumnList":147,"ViewColumnList_EDIT":148,"ColumnReference":149,"OptionalIfExists":150,"OptionalCascade":151,"OptionalIfExists_EDIT":152,"OptionalPurge":153,"PURGE":154,"DataManipulation":155,"InsertStatement":156,"UpdateStatement":157,"InsertValuesStatement":158,"DataManipulation_EDIT":159,"InsertValuesStatement_EDIT":160,"UpdateStatement_EDIT":161,"INSERT":162,"INTO":163,"OptionalTable":164,"InsertValuesList":165,"ParenthesizedRowValuesList":166,"InValueList":167,"CommonTableExpression":168,"SelectStatement":169,"OptionalUnions":170,"SelectStatement_EDIT":171,"OptionalUnions_EDIT":172,"CommonTableExpression_EDIT":173,"WITH":174,"WithQueries":175,"WithQueries_EDIT":176,"WithQuery":177,"WithQuery_EDIT":178,"TableSubQueryInner":179,"TableSubQueryInner_EDIT":180,"FromClause":181,"FROM":182,"TableReferenceList":183,"FromClause_EDIT":184,"TableReferenceList_EDIT":185,"TableReference":186,"TableReference_EDIT":187,"OptionalGroupByClause":188,"GroupByClause":189,"GROUP":190,"GroupByColumnList":191,"GroupByClause_EDIT":192,"GroupByColumnList_EDIT":193,"ColumnGroupingSets":194,"ColumnGroupingSets_EDIT":195,"ColumnGroupingSet_EDIT":196,"ColumnReference_EDIT":197,"GroupByColumnListPartTwo_EDIT":198,"OptionalHavingClause":199,"HavingClause":200,"HAVING":201,"HavingClause_EDIT":202,"OptionalJoins":203,"Joins":204,"Joins_INVALID":205,"JoinType":206,"TablePrimary":207,"OptionalJoinCondition":208,"Join_EDIT":209,"JoinType_EDIT":210,"TablePrimary_EDIT":211,"JoinCondition_EDIT":212,"Joins_EDIT":213,"CROSS":214,"JOIN":215,"FULL":216,"OUTER":217,"INNER":218,"LEFT":219,"SEMI":220,"RIGHT":221,"ON":222,"UsingColList":223,"OptionalLimitClause":224,"LimitClause":225,"LIMIT":226,"UnsignedNumericLiteral":227,"VARIABLE_REFERENCE":228,"LimitClause_EDIT":229,"OptionalOrderByClause":230,"OrderByClause":231,"ORDER":232,"OrderByColumnList":233,"OrderByClause_EDIT":234,"OrderByColumnList_EDIT":235,"OrderByIdentifier":236,"OrderByIdentifier_EDIT":237,"OptionalAscOrDesc":238,"ASC":239,"DESC":240,"SELECT":241,"OptionalAllOrDistinct":242,"SelectList":243,"TableExpression":244,"SelectList_EDIT":245,"TableExpression_EDIT":246,"DISTINCT":247,"OptionalSelectConditions":248,"OptionalSelectConditions_EDIT":249,"SelectSpecification":250,"SelectSpecification_EDIT":251,"OptionalCorrelationName":252,"*":253,"OptionalCorrelationName_EDIT":254,"OptionalWhereClause":255,"WhereClause_EDIT":256,"WhereClause":257,"Unions":258,"Unions_EDIT":259,"UnionClause":260,"UnionClause_EDIT":261,"UNION":262,"NewStatement":263,"WHERE":264,"SearchCondition":265,"SearchCondition_EDIT":266,".":267,"SignedInteger":268,"TRUE":269,"FALSE":270,"TRUNCATE":271,"OptionalPartitionSpec":272,"UserDefinedFunction":273,"AggregateFunction":274,"OptionalOverClause":275,"AnalyticFunction":276,"OverClause":277,"CastFunction":278,"UserDefinedFunction_EDIT":279,"AggregateFunction_EDIT":280,"OptionalOverClause_EDIT":281,"AnalyticFunction_EDIT":282,"OverClause_EDIT":283,"CastFunction_EDIT":284,"OtherAggregateFunction":285,"CountFunction":286,"SumFunction":287,"OtherAggregateFunction_EDIT":288,"CountFunction_EDIT":289,"SumFunction_EDIT":290,"OtherAggregateFunction_Type":291,"UdfArgumentList":292,"UdfArgumentList_EDIT":293,"AVG":294,"MAX":295,"MIN":296,"STDDEV_POP":297,"STDDEV_SAMP":298,"VAR_POP":299,"VAR_SAMP":300,"VARIANCE":301,"COUNT":302,"SUM":303,"ANALYTIC":304,"ArbitraryFunctionName":305,"IF":306,"CAST":307,"NonParenthesizedValueExpressionPrimary":308,"ColumnOrArbitraryFunctionRef":309,"ArbitraryFunctionRightPart":310,"UnsignedValueSpecification":311,"NonParenthesizedValueExpressionPrimary_EDIT":312,"ArbitraryFunctionRightPart_EDIT":313,"UnsignedValueSpecification_EDIT":314,"ColumnOrArbitraryFunctionRef_EDIT":315,"ArbitraryFunction":316,"ArbitraryFunction_EDIT":317,"OVER":318,"WindowExpression":319,"WindowExpression_EDIT":320,"UPDATE":321,"TargetTable":322,"SetClauseList":323,"OptionalFromJoinedTable":324,"TargetTable_EDIT":325,"SetClauseList_EDIT":326,"FromJoinedTable_EDIT":327,"TableName":328,"TableName_EDIT":329,"LocalOrSchemaQualifiedName":330,"LocalOrSchemaQualifiedName_EDIT":331,"SetClause":332,"SetClause_EDIT":333,"SetTarget":334,"UpdateSource":335,"UpdateSource_EDIT":336,"USE":337,"SqlSyntax":338,"SqlStatements":339,"EOF":340,"SqlAutocomplete":341,"SqlStatements_EDIT":342,"SqlStatement":343,";":344,"SqlStatement_EDIT":345,"SetSpecification_EDIT":346,"NonReservedKeyword":347,"OPTION":348,"REGULAR_IDENTIFIER":349,"NonStartingToken":350,"!":351,"-":352,"[":353,"]":354,"~":355,"AND":356,"ARITHMETIC_OPERATOR":357,"BACKTICK":358,"BETWEEN":359,"BIGINT":360,"BOOLEAN":361,"CASE":362,"CHAR":363,"CURRENT":364,"DATABASE":365,"DECIMAL":366,"DOUBLE":367,"ELSE":368,"END":369,"EXISTS":370,"FLOAT":371,"FOLLOWING":372,"HDFS_START_QUOTE":373,"IN":374,"INT":375,"IS":376,"OR":377,"PRECEDING":378,"REGEXP":379,"RLIKE":380,"ROW":381,"ROWS":382,"SCHEMA":383,"SMALLINT":384,"STRING":385,"THEN":386,"TIMESTAMP":387,"TINYINT":388,"UNSIGNED_INTEGER":389,"UNSIGNED_INTEGER_E":390,"VARCHAR":391,"WHEN":392,"PARTIAL_CURSOR":393,"FromOrIn":394,"SingleQuotedValue":395,"SingleQuotedValue_EDIT":396,"PARTIAL_VALUE":397,"DoubleQuotedValue":398,"DoubleQuotedValue_EDIT":399,"QuotedValue_EDIT":400,"OptionalFromDatabase":401,"DatabaseIdentifier":402,"OptionalFromDatabase_EDIT":403,"DatabaseIdentifier_EDIT":404,"CASCADE":405,"OptionalInDatabase":406,"OptionalPartitionSpec_EDIT":407,"PartitionSpec_EDIT":408,"PartitionSpecList":409,"PartitionSpecList_EDIT":410,"RangePartitionSpec":411,"RangePartitionComparisonOperator":412,"RangePartitionSpec_EDIT":413,"ConfigurationName":414,"PartialBacktickedOrAnyCursor":415,"PartialBacktickedIdentifier":416,"PartialBacktickedOrCursor":417,"PartialBacktickedOrPartialCursor":418,"OptionalParenthesizedColumnList":419,"OptionalParenthesizedColumnList_EDIT":420,"ColumnList":421,"ColumnList_EDIT":422,"ParenthesizedSimpleValueList":423,"SimpleValueList":424,"PartitionExpression":425,"PartitionExpression_EDIT":426,"RegularOrBackTickedSchemaQualifiedName":427,"RegularOrBackTickedSchemaQualifiedName_EDIT":428,"BasicIdentifierChain":429,"BasicIdentifierChain_EDIT":430,"DerivedColumnChain":431,"DerivedColumnChain_EDIT":432,"PartialBacktickedIdentifierOrPartialCursor":433,"OptionalTypeLength":434,"OptionalTypePrecision":435,"OptionalNot":436,"TableSubQuery":437,"ValueExpressionList":438,"BETWEEN_AND":439,"LikeRightPart":440,"CaseRightPart":441,"TableSubQuery_EDIT":442,"ValueExpressionInSecondPart_EDIT":443,"LikeRightPart_EDIT":444,"CaseRightPart_EDIT":445,"EndOrError":446,"ValueExpressionList_EDIT":447,"+":448,"UnsignedLiteral":449,"UnsignedLiteral_EDIT":450,"GeneralLiteral":451,"GeneralLiteral_EDIT":452,"ExactNumericLiteral":453,"ApproximateNumericLiteral":454,"TruthValue":455,"TablePrimaryOrJoinedTable":456,"TablePrimaryOrJoinedTable_EDIT":457,"JoinedTable":458,"JoinedTable_EDIT":459,"TableOrQueryName":460,"DerivedTable":461,"TableOrQueryName_EDIT":462,"DerivedTable_EDIT":463,"OptionalOnColumn":464,"OptionalOnColumn_EDIT":465,"PushQueryState":466,"PopQueryState":467,"SubQuery":468,"SubQuery_EDIT":469,"QueryExpression":470,"QueryExpression_EDIT":471,"QueryExpressionBody":472,"QueryExpressionBody_EDIT":473,"NonJoinQueryExpression":474,"NonJoinQueryExpression_EDIT":475,"NonJoinQueryTerm":476,"NonJoinQueryTerm_EDIT":477,"NonJoinQueryPrimary":478,"NonJoinQueryPrimary_EDIT":479,"SimpleTable":480,"SimpleTable_EDIT":481,"OptionalPartitionBy":482,"OptionalOrderByAndWindow":483,"PartitionBy_EDIT":484,"OptionalOrderByAndWindow_EDIT":485,"PartitionBy":486,"OptionalWindowSpec":487,"WindowSpec_EDIT":488,"WindowSpec":489,"RowsOrRange":490,"PopLexerState":491,"OptionalCurrentOrPreceding":492,"OptionalAndFollowing":493,"UNBOUNDED":494,"OptionalCurrentOrPreceding_EDIT":495,"OptionalAndFollowing_EDIT":496,"PushHdfsLexerState":497,"HdfsPath":498,"HDFS_PATH":499,"HDFS_END_QUOTE":500,"HdfsPath_EDIT":501,"IntegerOrUnbounded":502,"CaseWhenThenList":503,"CaseWhenThenList_EDIT":504,"CaseWhenThenListPartTwo":505,"CaseWhenThenListPartTwo_EDIT":506,"$accept":0,"$end":1},
terminals_: {2:"error",4:"ALTER",5:"CURSOR",8:"CREATE",12:"DROP",16:"SET",30:"ALL",32:"=",39:"TABLE",43:"AS",47:"VIEW",50:"COMMENT",54:"SINGLE_QUOTE",55:"DOUBLE_QUOTE",56:"VALUE",63:"ROLE",77:"LIKE",79:"(",81:")",85:",",95:"NOT",96:"NULL",107:"ARRAY",108:"<",109:">",112:"MAP",113:"STRUCT",120:":",125:"PARTITION",126:"BY",129:"RANGE",140:"VALUES",142:"COMPARISON_OPERATOR",154:"PURGE",162:"INSERT",163:"INTO",174:"WITH",182:"FROM",190:"GROUP",201:"HAVING",214:"CROSS",215:"JOIN",216:"FULL",217:"OUTER",218:"INNER",219:"LEFT",220:"SEMI",221:"RIGHT",222:"ON",226:"LIMIT",228:"VARIABLE_REFERENCE",232:"ORDER",239:"ASC",240:"DESC",241:"SELECT",247:"DISTINCT",253:"*",262:"UNION",264:"WHERE",267:".",269:"TRUE",270:"FALSE",271:"TRUNCATE",294:"AVG",295:"MAX",296:"MIN",297:"STDDEV_POP",298:"STDDEV_SAMP",299:"VAR_POP",300:"VAR_SAMP",301:"VARIANCE",302:"COUNT",303:"SUM",304:"ANALYTIC",306:"IF",307:"CAST",318:"OVER",321:"UPDATE",337:"USE",340:"EOF",344:";",346:"SetSpecification_EDIT",348:"OPTION",349:"REGULAR_IDENTIFIER",351:"!",352:"-",353:"[",354:"]",355:"~",356:"AND",357:"ARITHMETIC_OPERATOR",358:"BACKTICK",359:"BETWEEN",360:"BIGINT",361:"BOOLEAN",362:"CASE",363:"CHAR",364:"CURRENT",365:"DATABASE",366:"DECIMAL",367:"DOUBLE",368:"ELSE",369:"END",370:"EXISTS",371:"FLOAT",372:"FOLLOWING",373:"HDFS_START_QUOTE",374:"IN",375:"INT",376:"IS",377:"OR",378:"PRECEDING",379:"REGEXP",380:"RLIKE",381:"ROW",382:"ROWS",383:"SCHEMA",384:"SMALLINT",385:"STRING",386:"THEN",387:"TIMESTAMP",388:"TINYINT",389:"UNSIGNED_INTEGER",390:"UNSIGNED_INTEGER_E",391:"VARCHAR",392:"WHEN",393:"PARTIAL_CURSOR",397:"PARTIAL_VALUE",405:"CASCADE",439:"BETWEEN_AND",448:"+",494:"UNBOUNDED",499:"HDFS_PATH",500:"HDFS_END_QUOTE"},
productions_: [0,[3,2],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[19,1],[19,1],[19,1],[19,1],[19,1],[19,1],[19,1],[19,1],[19,1],[19,1],[19,2],[19,4],[19,1],[19,1],[20,2],[6,1],[6,2],[6,2],[6,3],[36,3],[38,3],[38,3],[21,3],[7,1],[7,2],[7,3],[7,3],[7,3],[42,3],[45,3],[45,3],[48,0],[48,1],[49,2],[52,1],[53,2],[53,2],[53,3],[53,3],[22,3],[22,5],[9,4],[9,3],[9,5],[9,4],[9,6],[60,1],[62,1],[23,3],[24,4],[10,4],[10,4],[10,3],[64,3],[65,3],[65,3],[65,3],[65,3],[66,2],[69,2],[69,2],[73,0],[73,1],[73,2],[74,1],[74,2],[74,2],[76,3],[78,3],[80,1],[80,3],[82,1],[82,3],[82,3],[82,5],[82,2],[82,4],[82,4],[82,6],[84,3],[86,3],[86,3],[86,3],[89,0],[89,1],[92,1],[92,2],[91,1],[91,2],[91,2],[91,3],[93,2],[93,1],[93,1],[94,2],[88,1],[88,1],[88,1],[88,1],[88,1],[88,1],[88,1],[90,1],[90,1],[90,1],[98,4],[101,3],[104,4],[104,4],[99,6],[102,3],[105,6],[105,4],[105,6],[105,5],[100,4],[103,3],[106,4],[114,1],[114,3],[115,1],[115,2],[115,3],[115,3],[115,5],[116,4],[117,5],[117,4],[117,4],[117,4],[117,3],[117,3],[121,1],[121,3],[122,1],[122,2],[122,3],[122,3],[122,5],[123,2],[123,2],[123,1],[123,1],[111,1],[111,1],[67,0],[67,1],[124,3],[70,2],[70,3],[70,3],[127,3],[128,2],[128,2],[128,3],[128,3],[128,3],[131,3],[133,3],[133,3],[134,1],[134,3],[135,1],[135,3],[135,5],[135,3],[135,5],[136,6],[136,4],[136,4],[137,2],[137,2],[137,3],[137,4],[137,4],[137,5],[137,6],[137,6],[137,3],[137,4],[137,4],[139,1],[139,1],[68,0],[68,3],[71,3],[71,3],[143,0],[25,8],[11,4],[11,9],[11,3],[11,6],[11,7],[11,8],[11,8],[11,8],[144,0],[144,1],[146,3],[145,3],[147,2],[147,4],[148,3],[148,5],[148,5],[148,7],[26,5],[13,3],[13,3],[13,4],[13,5],[13,5],[13,6],[27,3],[28,5],[14,3],[14,4],[14,5],[14,5],[14,6],[153,0],[153,1],[29,4],[15,4],[15,5],[15,3],[15,4],[15,4],[155,1],[155,1],[156,1],[159,1],[159,1],[158,6],[160,2],[160,4],[160,4],[160,5],[160,6],[165,1],[165,3],[166,3],[164,0],[164,1],[44,3],[44,5],[44,2],[46,4],[46,3],[46,3],[46,1],[46,4],[46,3],[46,2],[46,2],[168,2],[173,2],[175,1],[175,3],[176,1],[176,3],[176,3],[176,5],[177,5],[178,2],[178,5],[178,5],[181,2],[184,2],[184,2],[183,1],[183,3],[185,1],[185,3],[185,3],[185,5],[185,3],[188,0],[188,1],[189,3],[192,3],[192,3],[192,2],[194,0],[194,1],[194,3],[194,3],[195,1],[195,3],[195,3],[195,5],[195,3],[196,1],[196,1],[191,1],[191,3],[193,1],[193,2],[193,3],[193,3],[193,3],[193,4],[193,5],[198,1],[198,2],[198,1],[199,0],[199,1],[200,2],[202,2],[202,2],[203,0],[203,1],[203,1],[204,3],[204,4],[205,1],[205,2],[209,3],[209,1],[209,3],[209,3],[209,3],[213,1],[213,2],[213,2],[213,3],[206,2],[206,2],[206,3],[206,2],[206,1],[206,3],[206,2],[206,3],[206,3],[206,2],[206,3],[206,2],[206,3],[206,3],[206,2],[210,2],[210,3],[210,3],[210,2],[210,3],[210,3],[210,3],[210,3],[210,2],[210,3],[210,3],[210,3],[210,3],[210,2],[208,0],[208,2],[223,1],[223,3],[212,2],[212,2],[224,0],[224,1],[225,2],[225,4],[225,2],[225,4],[229,2],[230,0],[230,1],[231,3],[234,3],[234,2],[233,1],[233,3],[235,1],[235,2],[235,3],[235,4],[235,5],[236,2],[237,2],[237,2],[238,0],[238,1],[238,1],[169,3],[169,4],[171,3],[171,3],[171,4],[171,4],[171,4],[171,5],[171,6],[171,4],[242,0],[242,1],[242,1],[244,2],[246,2],[246,4],[246,3],[243,1],[243,3],[245,1],[245,2],[245,3],[245,3],[245,3],[245,4],[245,3],[245,3],[245,4],[245,4],[245,4],[245,5],[245,5],[250,2],[250,1],[251,2],[251,3],[251,2],[248,5],[249,5],[249,5],[249,5],[249,5],[249,5],[249,6],[249,6],[249,6],[249,6],[249,6],[170,0],[170,1],[172,1],[258,1],[258,2],[259,1],[259,2],[259,2],[259,3],[260,4],[261,3],[261,4],[261,4],[255,0],[255,1],[257,2],[256,2],[256,2],[265,1],[266,1],[31,1],[31,3],[33,1],[33,1],[33,2],[33,1],[33,1],[33,1],[33,1],[34,4],[17,2],[17,4],[17,3],[17,4],[17,5],[17,5],[17,5],[273,2],[273,2],[273,1],[279,1],[279,2],[279,1],[279,2],[279,2],[279,2],[279,1],[274,1],[274,1],[274,1],[280,1],[280,1],[280,1],[285,4],[285,5],[288,5],[288,6],[288,5],[291,1],[291,1],[291,1],[291,1],[291,1],[291,1],[291,1],[291,1],[286,4],[286,3],[286,5],[289,5],[289,6],[289,5],[287,5],[287,3],[290,5],[290,6],[290,5],[276,3],[276,4],[282,4],[282,5],[282,4],[305,1],[305,1],[305,1],[305,1],[278,6],[278,3],[284,6],[284,5],[284,4],[284,6],[284,5],[284,4],[284,6],[284,5],[284,6],[284,5],[308,2],[308,2],[308,1],[308,1],[308,1],[308,1],[312,2],[312,2],[312,1],[312,1],[312,1],[316,2],[316,2],[317,2],[317,2],[310,2],[310,3],[313,3],[313,4],[313,3],[292,1],[292,3],[293,1],[293,3],[293,3],[293,5],[293,3],[293,5],[293,4],[293,3],[293,2],[293,2],[293,4],[275,0],[275,1],[281,1],[277,2],[277,2],[283,2],[157,6],[161,6],[161,6],[161,6],[161,6],[161,7],[161,3],[161,2],[161,2],[161,2],[322,1],[325,1],[328,1],[329,1],[323,1],[323,3],[326,1],[326,3],[326,3],[326,5],[332,3],[333,3],[333,2],[333,1],[334,1],[335,1],[336,1],[324,0],[324,2],[327,2],[327,2],[35,2],[18,2],[338,3],[341,3],[341,3],[263,0],[339,0],[339,1],[339,4],[342,1],[342,4],[342,4],[342,7],[343,1],[343,1],[343,1],[345,1],[345,2],[345,1],[345,1],[345,1],[345,1],[347,1],[347,1],[347,1],[59,1],[59,1],[59,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[350,1],[118,1],[118,2],[110,1],[110,1],[394,1],[394,1],[57,1],[57,1],[395,3],[395,2],[396,2],[398,3],[398,2],[399,2],[51,1],[51,1],[400,1],[400,1],[401,0],[401,2],[403,2],[151,0],[151,1],[150,0],[150,2],[152,2],[58,0],[58,3],[61,2],[61,3],[406,0],[406,2],[406,2],[272,0],[272,1],[407,1],[37,4],[408,4],[411,5],[413,2],[413,3],[413,4],[413,5],[413,5],[413,5],[412,1],[412,1],[412,1],[412,1],[414,1],[414,1],[415,1],[415,1],[417,1],[417,1],[418,1],[418,1],[416,2],[83,1],[83,1],[419,0],[419,1],[420,1],[130,3],[132,3],[132,3],[421,1],[421,3],[422,3],[422,5],[423,3],[424,1],[424,3],[40,1],[40,3],[40,1],[40,3],[41,1],[41,3],[41,3],[72,1],[72,3],[75,1],[75,3],[75,3],[402,1],[404,1],[409,1],[409,3],[410,1],[410,3],[410,3],[410,5],[425,3],[426,3],[426,3],[426,3],[426,1],[119,1],[119,3],[119,2],[427,1],[427,3],[428,1],[428,3],[330,1],[330,2],[331,1],[331,2],[149,1],[149,3],[197,1],[429,1],[429,3],[430,3],[430,5],[431,1],[431,3],[432,1],[432,3],[432,5],[432,3],[87,1],[433,1],[433,1],[97,1],[97,1],[97,2],[97,2],[97,1],[97,1],[97,1],[97,1],[97,1],[97,1],[97,1],[97,2],[434,0],[434,3],[435,0],[435,3],[435,5],[138,1],[138,2],[138,2],[138,2],[138,2],[138,4],[138,4],[138,4],[138,6],[138,2],[138,3],[138,3],[138,3],[138,3],[138,3],[138,6],[138,6],[138,5],[138,5],[138,6],[138,5],[138,3],[138,3],[138,3],[138,3],[138,3],[138,2],[138,3],[138,2],[138,3],[141,1],[141,3],[141,2],[141,2],[141,2],[141,2],[141,2],[141,2],[141,2],[141,2],[141,3],[141,4],[141,5],[141,4],[141,4],[141,4],[141,6],[141,6],[141,2],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,4],[141,3],[141,6],[141,6],[141,5],[141,5],[141,6],[141,6],[141,6],[141,6],[141,5],[141,4],[141,5],[141,5],[141,5],[141,5],[141,4],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,3],[141,2],[141,3],[141,2],[141,3],[141,2],[141,3],[141,2],[141,3],[141,3],[141,4],[141,3],[141,3],[141,3],[438,1],[438,3],[447,1],[447,3],[447,3],[447,5],[447,3],[447,5],[447,4],[447,3],[447,2],[447,2],[447,4],[167,1],[167,3],[309,1],[309,3],[315,1],[268,1],[268,2],[268,2],[311,1],[314,1],[449,1],[449,1],[450,1],[227,1],[227,1],[453,1],[453,2],[453,3],[453,2],[454,2],[454,3],[454,4],[451,1],[451,1],[451,1],[452,1],[452,1],[455,1],[455,1],[436,0],[436,1],[186,1],[187,1],[456,1],[456,1],[457,1],[457,1],[458,2],[459,2],[459,2],[207,2],[207,2],[211,2],[211,2],[211,2],[460,1],[462,1],[461,1],[463,1],[464,0],[464,2],[465,2],[465,2],[466,0],[467,0],[437,3],[437,4],[442,3],[442,3],[179,2],[180,3],[468,1],[469,1],[470,1],[471,1],[472,1],[473,1],[474,1],[475,1],[476,1],[477,1],[478,1],[479,1],[480,1],[481,1],[252,0],[252,1],[252,1],[252,2],[252,2],[254,1],[254,1],[254,2],[254,2],[254,2],[319,4],[320,4],[320,4],[320,5],[320,7],[482,0],[482,1],[486,3],[484,2],[484,3],[484,3],[483,0],[483,2],[485,1],[485,3],[485,2],[487,0],[487,1],[489,5],[489,5],[488,2],[488,6],[488,5],[488,5],[488,5],[488,4],[491,0],[497,0],[498,3],[501,5],[501,4],[501,3],[501,3],[501,2],[490,1],[490,1],[492,0],[492,2],[492,2],[495,2],[495,2],[493,0],[493,3],[493,3],[496,2],[496,3],[496,3],[502,1],[502,1],[443,3],[443,3],[443,3],[440,2],[440,2],[440,2],[444,2],[444,2],[444,2],[444,2],[444,2],[444,2],[441,2],[441,4],[445,2],[445,4],[445,4],[445,3],[445,4],[445,3],[445,4],[445,4],[445,3],[445,4],[445,3],[446,1],[446,1],[503,1],[503,2],[504,1],[504,2],[504,3],[504,3],[504,2],[505,4],[506,2],[506,3],[506,4],[506,4],[506,3],[506,3],[506,4],[506,2],[506,3],[506,2],[506,3],[506,3],[506,4],[506,3],[506,4],[506,4],[506,5],[506,4],[506,3]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:

     parser.suggestKeywords(['TABLE', 'VIEW']);
   
break;
case 4: case 8:

     parser.suggestKeywords(['DATABASE', 'ROLE', 'SCHEMA', 'TABLE', 'VIEW']);
   
break;
case 12:

     parser.suggestSetOptions();
   
break;
case 34: case 43: case 238: case 242: case 480: case 600:

     parser.addTablePrimary($$[$0]);
   
break;
case 35: case 233:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyTables = true;
     }
   
break;
case 36:

     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 39: case 280:

     parser.suggestKeywords(['AS']);
   
break;
case 41: case 200: case 209: case 281: case 636: case 1085:

     parser.suggestKeywords(['SELECT']);
   
break;
case 44: case 243:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyViews = true;
     }
   
break;
case 45:

     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 55:

     parser.addNewDatabaseLocation(_$[$0-1], [{ name: $$[$0-1] }]);
   
break;
case 56: case 66:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 58:

     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 59:

     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 60:

     parser.addNewDatabaseLocation(_$[$0-2], [{ name: $$[$0-2] }]);
   
break;
case 61:

     if (!$$[$0]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 72:

     var keywords = [];
     if (!$$[$0-2] && !$$[$0-1]) {
       keywords.push({ value: 'LIKE', weight: 1 });
     } else {
       if (!$$[$0-1]) {
         keywords.push({ value: 'PARTITIONED BY', weight: 12 });
       }
       keywords.push({ value: 'AS', weight: 1 });
     }

     if (keywords.length > 0) {
       parser.suggestKeywords(keywords);
     }
   
break;
case 73:

     parser.addNewTableLocation(_$[$0-1], $$[$0-1], $$[$0]);
     this.$ = $$[$0];
   
break;
case 78:
this.$ = [];
break;
case 80: case 597: case 617: case 832:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 82: case 218: case 220: case 262: case 432: case 565: case 568: case 763: case 766: case 854: case 907: case 1082:
this.$ = $$[$0-1];
break;
case 84: case 273:
this.$ = [$$[$0]];
break;
case 85:
this.$ = $$[$0-2].concat($$[$0]);
break;
case 90: case 92:

     parser.checkForKeywords($$[$0-1]);
   
break;
case 91: case 93:

     parser.checkForKeywords($$[$0-3]);
   
break;
case 94:

     this.$ = $$[$0-2];
     this.$.type = $$[$0-1];
     var keywords = [];
     if (!$$[$0]['comment']) {
       keywords.push('COMMENT');
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 95: case 122: case 128: case 129: case 142: case 145: case 154: case 156:

     parser.suggestKeywords(parser.getColumnDataTypeKeywords());
   
break;
case 98:
this.$ = {};
break;
case 100:

     this.$ = {};
     this.$[$$[$0]] = true;
   
break;
case 101:

     $$[$0-1][$$[$0]] = true;
   
break;
case 106: case 107:
this.$ = 'null';
break;
case 108:
this.$ = 'comment';
break;
case 109:

     parser.suggestKeywords(['NULL']);
   
break;
case 127:

     parser.suggestKeywords(parser.getTypeKeywords());
   
break;
case 141: case 144:

     parser.suggestKeywords(['COMMENT']);
   
break;
case 163: case 1120:

     parser.suggestKeywords(['BY']);
   
break;
case 164:

     parser.suggestKeywords(['RANGE']);
   
break;
case 173: case 178: case 179:

     parser.suggestKeywords(['PARTITION']);
   
break;
case 185:

     parser.suggestKeywords(['VALUE', 'VALUES']);
   
break;
case 186:

     if ($$[$0].endsWithLessThanOrEqual) {
      parser.suggestKeywords(['VALUES']);
     }
   
break;
case 187: case 190: case 193:

     parser.suggestKeywords(['<', '<=']);
   
break;
case 188: case 795: case 798:

     parser.suggestKeywords(['VALUES']);
   
break;
case 191: case 194:

     parser.suggestFunctions();
   
break;
case 202:

     parser.commitLocations();
   
break;
case 204:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.suggestDatabases({ appendDot: true });
   
break;
case 205:

     if (!$$[$0-6]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 208:

     var keywords = [{value: 'AS', weight: 1 }];
     if (!$$[$0-1]) {
       keywords.push({ value: 'COMMENT', weight: 3 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 215:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 219: case 221:
this.$ = $$[$0-3];
break;
case 225:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestDatabases();
   
break;
case 226:

     parser.suggestKeywords(['CASCADE']);
   
break;
case 228:

     if (!$$[$0-3]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 230: case 485:

     parser.addTablePrimary($$[$0-1]);
   
break;
case 232:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 235:

     parser.addTablePrimary($$[$0-2]);
     if (!$$[$0-1]) {
       parser.suggestKeywords(['PURGE']);
     }
   
break;
case 239:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 240:

     parser.addTablePrimary($$[$0]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 249:

     $$[$0-2].owner = 'insert';
     parser.addTablePrimary($$[$0-2]);
   
break;
case 250:

     parser.suggestKeywords(['INTO']);
   
break;
case 251:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['TABLE']);
     }
     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 253:

     $$[$0-1].owner = 'insert';
     parser.addTablePrimary($$[$0-1]);
     parser.suggestKeywords(['VALUES']);
   
break;
case 261: case 434:
this.$ = $$[$0-2];
break;
case 263:

     parser.addCommonTableExpressions($$[$0-3]);
   
break;
case 264: case 265: case 276:

     parser.addCommonTableExpressions($$[$0-2]);
   
break;
case 271: case 287: case 311: case 387: case 391: case 429: case 439: case 466: case 616: case 1007: case 1009: case 1064: case 1119: case 1194:
this.$ = $$[$0];
break;
case 274:
this.$ = $$[$0-2].concat([$$[$0]]);
break;
case 278:

     parser.addCommonTableExpressions($$[$0-4]);
   
break;
case 279:

     parser.addCteAliasLocation(_$[$0-4], $$[$0-4]);
     $$[$0-1].alias = $$[$0-4];
     this.$ = $$[$0-1];
   
break;
case 283:

     this.$ = { tableReferenceList : $$[$0] }
   
break;
case 284: case 292:

       parser.suggestTables();
       parser.suggestDatabases({ appendDot: true });
   
break;
case 295:

     this.$ = { valueExpression: $$[$0] };
   
break;
case 296: case 398:

     parser.suggestSelectListAliases();
   
break;
case 297:

     parser.valueExpressionSuggest();
     parser.suggestSelectListAliases();
     parser.suggestGroupBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 298:

     parser.suggestKeywords(['BY']);
     parser.suggestGroupBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 308: case 611: case 820: case 823: case 824: case 851: case 852: case 873: case 876:

     parser.suggestColumns();
   
break;
case 313: case 314: case 320: case 321: case 850: case 1078: case 1121:

     parser.valueExpressionSuggest();
   
break;
case 325:

     parser.valueExpressionSuggest();
     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 326:

     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 330:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-2];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
        parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 331:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-3];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
       parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 332:
this.$ = { joinType: $$[$0] };
break;
case 333:
this.$ = { joinType: $$[$0-1] };
break;
case 334:

     if ($$[$0-2].suggestKeywords) {
       parser.suggestKeywords($$[$0-2].suggestKeywords);
     }
   
break;
case 335:

     if ($$[$0].suggestKeywords) {
       parser.suggestKeywords($$[$0].suggestKeywords);
     }
   
break;
case 338:

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         parser.suggestJoins({
           prependJoin: false,
           joinType: $$[$0-2],
           tables: tables
         })
       }
     }
     parser.suggestTables();
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 343:
this.$ = 'CROSS JOIN';
break;
case 344:
this.$ = 'FULL JOIN';
break;
case 345:
this.$ = 'FULL OUTER JOIN';
break;
case 346:
this.$ = 'INNER JOIN';
break;
case 347:
this.$ = 'JOIN';
break;
case 348:
this.$ = 'LEFT INNER JOIN';
break;
case 349:
this.$ = 'LEFT JOIN';
break;
case 350:
this.$ = 'LEFT OUTER JOIN';
break;
case 351:
this.$ = 'LEFT SEMI JOIN';
break;
case 352:
this.$ = 'OUTER JOIN';
break;
case 353: case 355:
this.$ = 'RIGHT OUTER JOIN';
break;
case 354:
this.$ = 'RIGHT JOIN';
break;
case 356:
this.$ = 'RIGHT SEMI JOIN';
break;
case 357:
this.$ = 'SEMI JOIN';
break;
case 358: case 360: case 361: case 363: case 364: case 365: case 366: case 368: case 369: case 370: case 371:
this.$ = { suggestKeywords: ['JOIN'] };
break;
case 359: case 362: case 367:
this.$ = { suggestKeywords: ['OUTER'] };
break;
case 372:
this.$ = { noJoinCondition: true, suggestKeywords: ['ON'] };
break;
case 373:
this.$ = { valueExpression: $$[$0] };
break;
case 377:

     parser.valueExpressionSuggest();
     parser.suggestJoinConditions({ prependOn: false });
   
break;
case 384:

     parser.suggestKeywords([{ value: '10', weight: 10000 }, { value: '100', weight: 10000 }, { value: '1000', weight: 10000 }, { value: '5000', weight: 10000 }, { value: '10000', weight: 10000 }])
   
break;
case 388:

     if ($$[$0].emptyOrderBy) {
       parser.suggestOrderBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 389:

     parser.suggestKeywords(['BY']);
     parser.suggestOrderBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 393:

     this.$ = { emptyOrderBy: false }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 394: case 395: case 396:
this.$ = { emptyOrderBy: false };
break;
case 397:
this.$ = parser.mergeSuggestKeywords($$[$0]);
break;
case 399:

     this.$ = { emptyOrderBy: true }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 400:
this.$ = { suggestKeywords: ['ASC', 'DESC'] };;
break;
case 403:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     this.$ = { selectList: $$[$0] };
   
break;
case 404:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     this.$ = { selectList: $$[$0-1], tableExpression: $$[$0] }
   
break;
case 405:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     if ($$[$0].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-1]) {
         keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
       }
       parser.suggestKeywords(keywords);
     } else {
       parser.checkForSelectListKeywords($$[$0]);
     }
     if ($$[$0].suggestFunctions) {
       parser.suggestFunctions();
     }
     if ($$[$0].suggestColumns) {
       parser.suggestColumns({ identifierChain: [], source: 'select' });
     }
     if ($$[$0].suggestTables) {
       parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     }
     if ($$[$0].suggestDatabases) {
       parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
     }
     if ($$[$0].suggestAggregateFunctions && (!$$[$0-1] || $$[$0-1] === 'ALL')) {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
   
break;
case 406:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-1] || $$[$0-1] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-1]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 407:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
   
break;
case 408:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.selectListNoTableSuggest($$[$0-1], $$[$0-2]);
     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'select';
     }
   
break;
case 409:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2] || $$[$0-2] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-2]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 410:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]), _$[$0-2]);
     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 411:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]), _$[$0-3]);
     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 412:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.checkForSelectListKeywords($$[$0-1]);
     var keywords = ['FROM'];
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.suggestTables({ prependFrom: true });
     parser.suggestDatabases({ prependFrom: true, appendDot: true });
   
break;
case 416: case 417:

     parser.addClauseLocation('whereClause', _$[$0-1], $$[$0].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0].limitClausePreceding || _$[$0-1], $$[$0].limitClauseLocation);
   
break;
case 418:

     var keywords = [];

     parser.addClauseLocation('whereClause', _$[$0-3], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-2].limitClausePreceding || _$[$0-3], $$[$0-2].limitClauseLocation);

     if ($$[$0-3]) {
       if (typeof $$[$0-3].tableReferenceList.hasJoinCondition !== 'undefined' && !$$[$0-3].tableReferenceList.hasJoinCondition) {
         keywords.push({ value: 'ON', weight: 3 });
       }
       if ($$[$0-3].suggestKeywords) {
         keywords = parser.createWeightedKeywords($$[$0-3].suggestKeywords, 3);
       }
       if ($$[$0-3].tableReferenceList.suggestJoinConditions) {
         parser.suggestJoinConditions($$[$0-3].tableReferenceList.suggestJoinConditions);
       }
       if ($$[$0-3].tableReferenceList.suggestJoins) {
         parser.suggestJoins($$[$0-3].tableReferenceList.suggestJoins);
       }
       if ($$[$0-3].tableReferenceList.suggestKeywords) {
         keywords = keywords.concat(parser.createWeightedKeywords($$[$0-3].tableReferenceList.suggestKeywords, 3));
       }

       // Lower the weights for 'TABLESAMPLE'
       keywords.forEach(function (keyword) {
         if (keyword.value === 'TABLESAMPLE') {
           keyword.weight = 1.1;
         }
       });

       if ($$[$0-3].tableReferenceList.types) {
         var veKeywords = parser.getValueExpressionKeywords($$[$0-3].tableReferenceList);
         keywords = keywords.concat(veKeywords.suggestKeywords);
         if (veKeywords.suggestColRefKeywords) {
           parser.suggestColRefKeywords(veKeywords.suggestColRefKeywords);
           parser.addColRefIfExists($$[$0-3].tableReferenceList);
         }
       }
     }

     if ($$[$0-1].empty && $$[$0] && $$[$0].joinType.toUpperCase() === 'JOIN') {
       keywords = keywords.concat(['FULL', 'FULL OUTER', 'INNER', 'LEFT', 'LEFT OUTER', 'RIGHT', 'RIGHT OUTER']);
       parser.suggestKeywords(keywords);
       return;
     }

     if ($$[$0-1].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].suggestFilters) {
       parser.suggestFilters($$[$0-1].suggestFilters);
     }
     if ($$[$0-1].suggestGroupBys) {
       parser.suggestGroupBys($$[$0-1].suggestGroupBys);
     }
     if ($$[$0-1].suggestOrderBys) {
       parser.suggestOrderBys($$[$0-1].suggestOrderBys);
     }

     if ($$[$0-1].empty) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }

     keywords = keywords.concat([
       { value: 'FULL JOIN', weight: 1 },
       { value: 'FULL OUTER JOIN', weight: 1 },
       { value: 'INNER JOIN', weight: 1 },
       { value: 'JOIN', weight: 1 },
       { value: 'LEFT JOIN', weight: 1 },
       { value: 'LEFT OUTER JOIN', weight: 1 },
       { value: 'RIGHT JOIN', weight: 1 },
       { value: 'RIGHT OUTER JOIN', weight: 1 }
     ]);
     parser.suggestKeywords(keywords);
  
break;
case 419:

     // A couple of things are going on here:
     // - If there are no SelectConditions (WHERE, GROUP BY, etc.) we should suggest complete join options
     // - If there's an OptionalJoin at the end, i.e. 'SELECT * FROM foo | JOIN ...' we should suggest
     //   different join types
     // - The FromClause could end with a valueExpression, in which case we should suggest keywords like '='
     //   or 'AND' based on type

     if (!$$[$0-1]) {
       parser.addClauseLocation('whereClause', _$[$0-2]);
       parser.addClauseLocation('limitClause', _$[$0-2]);
       return;
     }
     parser.addClauseLocation('whereClause', _$[$0-2], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-1].limitClausePreceding || _$[$0-2], $$[$0-1].limitClauseLocation);
     var keywords = [];

     if ($$[$0-1].suggestColRefKeywords) {
       parser.suggestColRefKeywords($$[$0-1].suggestColRefKeywords);
       parser.addColRefIfExists($$[$0-1]);
     }

     if ($$[$0-1].suggestKeywords && $$[$0-1].suggestKeywords.length) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].cursorAtEnd) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 420:
this.$ = [ $$[$0] ];
break;
case 421:

     $$[$0-2].push($$[$0]);
   
break;
case 423: case 424:

     this.$ = { cursorAtStart : true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 426:

     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 427:

     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 428:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestTables: true, suggestDatabases: true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 430: case 431: case 433:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true,  };
   
break;
case 435:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
       this.$ = { valueExpression: $$[$0-1], alias: $$[$0].alias };
       if (!parser.yy.selectListAliases) {
         parser.yy.selectListAliases = [];
       }
       parser.yy.selectListAliases.push($$[$0-1].function && $$[$0-1].types && $$[$0-1].types.length && $$[$0-1].types[0] === 'UDFREF' ? { name: $$[$0].alias, udfRef: $$[$0-1].function, types: $$[$0-1].types } : { name: $$[$0].alias, types: $$[$0-1].types || ['T'] });
     } else {
       this.$ = { valueExpression: $$[$0-1] }
     }
   
break;
case 436:

     parser.addAsteriskLocation(_$[$0], [{ asterisk: true }]);
     this.$ = { asterisk: true }
   
break;
case 437:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
     }
   
break;
case 438:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.addColumnAliasLocation(_$[$0], $$[$0], _$[$0-2]);
     this.$ = { suggestAggregateFunctions: true };
   
break;
case 440:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'WHERE', weight: 7 }, { value: 'GROUP BY', weight: 6 }, { value: 'HAVING', weight: 5 }, { value: 'ORDER BY', weight: 4 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true, true]);

     if (keywords.length > 0) {
       this.$ = { suggestKeywords: keywords, empty: !$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0] };
     } else {
       this.$ = {};
     }

     this.$.whereClauseLocation = $$[$0-4] ? _$[$0-4] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;

     if (!$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestFilters = { prefix: 'WHERE', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestGroupBys = { prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-1] && !$$[$0]) {
       this.$.suggestOrderBys = { prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
   
break;
case 441:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'where';
     }
   
break;
case 442:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'group by';
     }
   
break;
case 444:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'order by';
     }
   
break;
case 446:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'GROUP BY', weight: 8 }, { value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true]);
     if ($$[$0-5].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-5].suggestKeywords, 1));
     }
     this.$ = parser.getValueExpressionKeywords($$[$0-5], keywords);
     this.$.cursorAtEnd = !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if ($$[$0-5].columnReference) {
       this.$.columnReference = $$[$0-5].columnReference;
     }
     if (!$$[$0-3]) {
       parser.suggestGroupBys({ prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 447:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true]);
     if ($$[$0-4].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-4].suggestKeywords, 8));
     }
     if ($$[$0-4].valueExpression) {
       this.$ = parser.getValueExpressionKeywords($$[$0-4].valueExpression, keywords);
       if ($$[$0-4].valueExpression.columnReference) {
         this.$.columnReference = $$[$0-4].valueExpression.columnReference;
       }
     } else {
       this.$ = { suggestKeywords: keywords };
     }
     this.$.cursorAtEnd = !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 448:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-1], $$[$0]],
       [{ value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true]);
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0-1] && !$$[$0] };
     if (!$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-3], _$[$0-3]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 449:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0]],
       [{ value: 'LIMIT', weight: 3 }],
       [true]);
     if ($$[$0-2].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-2].suggestKeywords, 4));
     }
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0] };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 450:

     this.$ = { suggestKeywords: [], cursorAtEnd: true };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = _$[$0-1];
   
break;
case 461:

     parser.suggestKeywords(['ALL', 'DISTINCT', 'SELECT']);
   
break;
case 462:

     parser.suggestKeywords(['ALL', 'DISTINCT']);
   
break;
case 467:

     if ($$[$0].suggestFilters) {
       parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 468:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS', 'NOT EXISTS']);
     parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 481:

     parser.suggestKeywords(['TABLE']);
   
break;
case 482:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 486:

     parser.addTablePrimary($$[$0-1]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 488:

     if (!$$[$0]) {
       $$[$0-1].suggestKeywords = ['OVER'];
     }
   
break;
case 495:

     parser.suggestKeywords(['OVER']);
   
break;
case 504:

     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 505: case 523:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 506:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       if ($$[$0-4].toLowerCase() === 'group_concat') {
         keywords.push('ALL');
       } else {
         keywords.push('DISTINCT');
       }
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 507: case 521:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 508:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords(true);
       if (!$$[$0-2]) {
         if ($$[$0-4].toLowerCase() === 'group_concat') {
           keywords.push('ALL');
         } else {
           keywords.push('DISTINCT');
         }
       }
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
       parser.suggestKeywords(keywords);
     }
     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], $$[$0-1].activePosition);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 517:

     parser.addFunctionArgumentLocations($$[$0-3], [{
       expression: { text: $$[$0-1] },
       location: _$[$0-1]
     }]);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] }
   
break;
case 518: case 524:

     this.$ = { function: $$[$0-2], types: ['UDFREF'] }
   
break;
case 519:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] }
   
break;
case 520:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 522:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-2]) {
         keywords.push('DISTINCT');
       }
       parser.suggestKeywords(keywords);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 525:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 526:

     parser.suggestValueExpressionKeywords($$[$0-2]);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 527:

     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 528:

    this.$ = { function: $$[$0-2], types: ['UDFREF'] }
  
break;
case 529:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     this.$ = {
       function: $$[$0-3],
       expression: $$[$0-1].expressions[$$[$0-1].expressions.length - 1].expression,
       types: ['UDFREF']
     }
   
break;
case 530:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-3], 1);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 531:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-2].expressions);
     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 532:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     parser.applyArgumentTypesToSuggestions($$[$0-3], $$[$0-1].activePosition);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 537:

     var expression = $$[$0-3];
     parser.extractExpressionText(expression, $$[$0-3], $$[$0-2], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-5], [{
       expression: expression,
       location: {
         first_line: _$[$0-3].first_line,
         last_line: _$[$0-1].last_line,
         first_column: _$[$0-3].first_column,
         last_column: _$[$0-1].last_column
       }
     }]);
     this.$ = { types: [ $$[$0-1].toUpperCase() ] }
   
break;
case 538: case 543: case 544: case 1013:
this.$ = { types: [ 'T' ] };
break;
case 539:

     parser.valueExpressionSuggest();
     this.$ = { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 540: case 541:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ] };
   
break;
case 542:
this.$ = { types: [ $$[$0-1].toUpperCase() ] };
break;
case 545:

     parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'AS', weight: 2 }]);
     this.$ =  { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 546:

     parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'AS', weight: 2 }]);
     this.$ = { types: [ 'T' ] };
   
break;
case 547: case 548:

     parser.suggestKeywords(parser.getTypeKeywords());
     this.$ = { types: [ 'T' ] };
   
break;
case 549:

     // We need to handle arbitrary UDFs here instead of inside UserDefinedFunction or there will be a conflict
     // with columnReference for functions like: db.udf(foo)
     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     if ($$[$0-1].lastLoc && $$[$0-1].lastLoc.location) {
       $$[$0-1].lastLoc.type = 'function';
       $$[$0-1].lastLoc.function = fn;
       $$[$0-1].lastLoc.location = {
         first_line: $$[$0-1].lastLoc.location.first_line,
         last_line: $$[$0-1].lastLoc.location.last_line,
         first_column: $$[$0-1].lastLoc.location.first_column,
         last_column: $$[$0-1].lastLoc.location.last_column - 1
       }
       if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
          $$[$0-1].firstLoc.type = 'database';
       } else {
         delete $$[$0-1].lastLoc.identifierChain;
       }
     }
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: fn, expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: fn, types: ['UDFREF'] }
     }
   
break;
case 550:

    parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
    if ($$[$0].expressions && $$[$0].expressions.length) {
      this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
    } else {
      this.$ = { function: $$[$0-1], types: ['UDFREF'] }
    }
  
break;
case 553:
this.$ = { types: ['COLREF'], columnReference: $$[$0].chain };
break;
case 554:
this.$ = { types: [ 'NULL' ], text: $$[$0] };
break;
case 555:

     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     $$[$0-1].lastLoc.type = 'function';
     $$[$0-1].lastLoc.function = fn;
     $$[$0-1].lastLoc.location = {
       first_line: $$[$0-1].lastLoc.location.first_line,
       last_line: $$[$0-1].lastLoc.location.last_line,
       first_column: $$[$0-1].lastLoc.location.first_column,
       last_column: $$[$0-1].lastLoc.location.last_column - 1
     }
     if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
        $$[$0-1].firstLoc.type = 'database';
     } else {
       delete $$[$0-1].lastLoc.identifierChain;
     }
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions(fn, $$[$0].activePosition);
     }
     this.$ = { function: fn, types: ['UDFREF'] };
   
break;
case 556: case 562: case 563:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions($$[$0-1], $$[$0].activePosition);
     }
     this.$ = { function: $$[$0-1], types: ['UDFREF'] };
   
break;
case 559:

     if ($$[$0].suggestKeywords) {
       this.$ = { types: ['COLREF'], columnReference: $$[$0], suggestKeywords: $$[$0].suggestKeywords };
     } else {
       this.$ = { types: ['COLREF'], columnReference: $$[$0] };
     }
   
break;
case 560: case 561:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: $$[$0-1], types: ['UDFREF'] }
     }
   
break;
case 566:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }]
     }
   
break;
case 567:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = $$[$0-3];
   
break;
case 569: case 571:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0], location: _$[$0] }]
     }
   
break;
case 570: case 572:

     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: $$[$0], location: _$[$0] }])
     }
   
break;
case 573:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0-2], location: _$[$0-2] }].concat($$[$0].expressions)
     }
   
break;
case 574:

     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: $$[$0-2], location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 575:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: { text: '' }, location: _$[$0] }])
     }
   
break;
case 576:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: { text: '' }, location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 577:

     parser.suggestValueExpressionKeywords($$[$0-3].expressions[$$[$0-3].expressions.length - 1].expression);
     this.$ = {
       activePosition: $$[$0-3].activePosition,
       expressions: $$[$0-3].expressions.concat($$[$0].expressions)
     }
   
break;
case 578:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 579:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 580:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 581:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-3] }, { expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 593:

     parser.suggestKeywords([ 'WHERE' ]);
   
break;
case 594:

     parser.suggestKeywords([ 'SET' ]);
   
break;
case 610:

     parser.suggestKeywords([ '=' ]);
   
break;
case 619:

     if (! parser.yy.cursorFound) {
       parser.yy.result.useDatabase = $$[$0];
     }
   
break;
case 620: case 841:

     parser.suggestDatabases();
   
break;
case 622: case 623:

     return parser.yy.result;
   
break;
case 624:

     parser.prepareNewStatement();
   
break;
case 626: case 628: case 630:

     parser.addStatementLocation(_$[$0]);
   
break;
case 629: case 631:

     parser.addStatementLocation(_$[$0-3]);
   
break;
case 635:

     parser.suggestDdlAndDmlKeywords();
   
break;
case 764: case 767: case 855:
this.$ = '';
break;
case 779: case 782:

     parser.yy.correlatedSubQuery = false;
   
break;
case 780: case 784:

     parser.suggestKeywords(['EXISTS']);
   
break;
case 783:

     parser.suggestKeywords(['NOT EXISTS']);
   
break;
case 794: case 796: case 797: case 799:

     parser.suggestKeywords(['<', '<=', '<>', '=', '>', '>=']);
   
break;
case 828: case 830: case 856:

     parser.addTableLocation(_$[$0], [ { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0] } ] };
   
break;
case 829: case 831: case 857:

     parser.addDatabaseLocation(_$[$0-2], [ { name: $$[$0-2] } ]);
     parser.addTableLocation(_$[$0], [ { name: $$[$0-2] }, { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0-2] }, { name: $$[$0] } ] };
   
break;
case 833: case 838:

     parser.suggestDatabases();
     this.$ = { identifierChain: [{ name: $$[$0-2] }] };
   
break;
case 834: case 859:

     parser.suggestTablesOrColumns($$[$0-2]);
   
break;
case 835:
this.$ = [{ name: $$[$0] }];
break;
case 836:
this.$ = [{ name: $$[$0-2] }, { name: $$[$0-1] }];
break;
case 837:

     parser.suggestDatabases({ appendDot: true });
   
break;
case 858:

     parser.suggestTables();
     parser.suggestDatabases({ prependDot: true });
   
break;
case 861:
this.$ = { identifierChain: $$[$0-1].identifierChain, alias: $$[$0] };
break;
case 864:

     parser.yy.locations[parser.yy.locations.length - 1].type = 'column';
   
break;
case 865: case 1030:

     parser.addAsteriskLocation(_$[$0], $$[$0-2].concat({ asterisk: true }));
   
break;
case 867:

     this.$ = [ $$[$0].identifier ];
     parser.yy.firstChainLocation = parser.addUnknownLocation($$[$0].location, [ $$[$0].identifier ]);
   
break;
case 868:

     if (parser.yy.firstChainLocation) {
       parser.yy.firstChainLocation.firstInChain = true;
       delete parser.yy.firstChainLocation;
     }
     $$[$0-2].push($$[$0].identifier);
     parser.addUnknownLocation($$[$0].location, $$[$0-2].concat());
   
break;
case 869:

     parser.suggestColumns({
       identifierChain: $$[$0-2]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 870:

     parser.suggestColumns({
       identifierChain: $$[$0-4]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 871:
this.$ = [ $$[$0].identifier ];
break;
case 872:

     $$[$0-2].push($$[$0].identifier);
   
break;
case 874:

     parser.suggestColumns({ identifierChain: $$[$0-2] });
   
break;
case 875:

     parser.suggestColumns({ identifierChain: $$[$0-4] });
   
break;
case 877:
this.$ = { identifier: { name: $$[$0] }, location: _$[$0] };
break;
case 898: case 899:

     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 900: case 925:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 901:

     // verifyType($$[$0], 'NUMBER');
     this.$ = $$[$0];
     $$[$0].types = ['NUMBER'];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 902: case 903: case 904:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 905:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 906:

     this.$ = { types: [ 'BOOLEAN' ] };
     // clear correlated flag after completed sub-query (set by lexer)
     parser.yy.correlatedSubQuery = false;
   
break;
case 908: case 909: case 910: case 911:

     parser.addColRefToVariableIfExists($$[$0-2], $$[$0]);
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 912: case 913: case 914: case 915: case 945: case 1003: case 1004:
this.$ = { types: [ 'BOOLEAN' ] };
break;
case 916:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 917:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 918: case 919:

     // verifyType($$[$0-2], 'BOOLEAN');
     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 920: case 921: case 922:

     // verifyType($$[$0-2], 'NUMBER');
     // verifyType($$[$0], 'NUMBER');
     this.$ = { types: [ 'NUMBER' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 923:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 924:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 926:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 928:

     parser.suggestKeywords(['BETWEEN', 'EXISTS', 'IN', 'LIKE', 'REGEXP', 'RLIKE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 929: case 931:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
break;
case 930:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 932:

     parser.suggestFunctions({ types: [ 'BOOLEAN' ] });
     parser.suggestColumns({ types: [ 'BOOLEAN' ] });
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 933:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0].suggestFilters };
break;
case 934:

     parser.suggestFunctions();
     parser.suggestColumns();
     this.$ = { types: [ 'T' ] };
   
break;
case 935:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 936:

     parser.suggestFunctions({ types: [ 'NUMBER' ] });
     parser.suggestColumns({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ] };
   
break;
case 937:

     parser.suggestKeywords(['FALSE', 'NOT NULL', 'NOT TRUE', 'NOT FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 938:

     parser.suggestKeywords(['FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 939:

     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 940: case 941: case 942:

     parser.suggestKeywords(['NOT']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 943:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-3] ? 'IS NOT DISTINCT FROM' : 'IS DISTINCT FROM');
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 944:

     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 946:

     this.$ = $$[$0-1];
   
break;
case 947:

     parser.valueExpressionSuggest();
     this.$ = { types: ['T'], typeSet: true };
   
break;
case 948:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 949: case 950: case 951:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 952: case 953: case 954: case 955:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0]);
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 956: case 958:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 957:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ] , typeSet: true, endsWithLessThanOrEqual: true };
   
break;
case 959:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, endsWithLessThanOrEqual: $$[$0-1] === '<='  };
   
break;
case 960: case 961: case 962: case 963:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 964:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-3]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 965:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 966: case 967:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
break;
case 968: case 969:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
break;
case 970:

     if ($$[$0-2].types[0] === $$[$0].types[0] && !$$[$0-5].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
   
break;
case 971:

     if ($$[$0-5].types[0] === $$[$0].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 972:

     if ($$[$0-5].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 973:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 974: case 980:

     parser.suggestValueExpressionKeywords($$[$0-1], ['AND']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 975:

     parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 976:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-4].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
   
break;
case 977:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 978:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 979:

     parser.valueExpressionSuggest($$[$0-4], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-4]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 981:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 982: case 984: case 986: case 988:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, suggestFilters: true };
   
break;
case 983: case 987:

     parser.addColRefIfExists($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 985: case 989:

     parser.addColRefIfExists($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 990: case 991:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 992: case 993: case 994:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 995: case 996: case 997:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 998: case 999: case 1000:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 1001:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1002:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1005:

     parser.valueExpressionSuggest(undefined, $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 1006:

     parser.valueExpressionSuggest(undefined, $$[$0-1] + ' ' + $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 1008:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1010:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1011:

      this.$ = $$[$0];
      this.$.suggestFilters = $$[$0-1].suggestFilters;
    
break;
case 1012:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1014: case 1016:

     $$[$0].position = 1;
   
break;
case 1015:

     $$[$0].position = $$[$0-2].position + 1;
     this.$ = $$[$0];
   
break;
case 1017:

     $$[$0-2].position += 1;
   
break;
case 1018:

     $$[$0-2].position = 1;
   
break;
case 1019:

     $$[$0-4].position += 1;
   
break;
case 1020:

     parser.valueExpressionSuggest();
     $$[$0-2].position += 1;
   
break;
case 1021:

     parser.valueExpressionSuggest();
     $$[$0-4].position += 1;
   
break;
case 1022:

     parser.suggestValueExpressionKeywords($$[$0-3]);
   
break;
case 1023: case 1024:

     parser.valueExpressionSuggest();
     this.$ = { cursorAtStart : true, position: 1 };
   
break;
case 1025: case 1026:

     parser.valueExpressionSuggest();
     this.$ = { position: 2 };
   
break;
case 1029:

     var lastLoc = parser.yy.locations[parser.yy.locations.length - 1];
     if (lastLoc.type !== 'variable') {
       lastLoc.type = 'column';
     }
     // used for function references with db prefix
     var firstLoc = parser.yy.locations[parser.yy.locations.length - $$[$0].length];
     this.$ = { chain: $$[$0], firstLoc: firstLoc, lastLoc: lastLoc }
   
break;
case 1036:

     parser.suggestValues($$[$0]);
   
break;
case 1037:
this.$ = { types: [ 'NUMBER' ], text: $$[$0] };
break;
case 1043: case 1045: case 1046:
this.$ = $$[$0-1] + $$[$0];
break;
case 1044: case 1047:
this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 1048:
this.$ = $$[$0-3] + $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 1049:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: "'" + $$[$0] + "'" }
     } else {
       this.$ = { types: [ 'STRING' ] }
     }
   
break;
case 1050:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: '"' + $$[$0] + '"' }
     } else {
       this.$ = { types: [ 'STRING' ], text: '"' + $$[$0] + '"' }
     }
   
break;
case 1051:
this.$ = { types: [ 'BOOLEAN' ], text: $$[$0] };
break;
case 1052:

    this.$ = { partialQuote: '\'', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 1053:

    this.$ = { partialQuote: '"', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 1060:

     this.$ = $$[$0];

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         this.$.suggestJoins = {
           prependJoin: true,
           tables: tables
         };
       }
      }
   
break;
case 1067:

     this.$ = {
       primary: $$[$0-1]
     }
     if ($$[$0-1].identifierChain) {
       if ($$[$0]) {
         $$[$0-1].alias = $$[$0].alias
         parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
       }
       parser.addTablePrimary($$[$0-1]);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     } else if ($$[$0].suggestKeywords) {
       keywords = $$[$0].suggestKeywords;
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 1068:

     this.$ = {
       primary: $$[$0-1]
     };

     if ($$[$0]) {
       this.$.primary.alias = $$[$0].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 1069:

     if ($$[$0]) {
       parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }
   
break;
case 1070:

     if ($$[$0]) {
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias);
     }
   
break;
case 1080:

     parser.pushQueryState();
   
break;
case 1081:

     parser.popQueryState();
   
break;
case 1083:

     if ($$[$0-1]) {
       $$[$0-2].alias = $$[$0-1].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0-1].alias });
       parser.addSubqueryAliasLocation($$[$0-1].location, $$[$0-1].alias, $$[$0-2].identifierChain);
     }
     this.$ = $$[$0-2];
   
break;
case 1086:

     var subQuery = parser.getSubQuery($$[$0]);
     subQuery.columns.forEach(function (column) {
       parser.expandIdentifierChain({ wrapper: column });
       delete column.linked;
     });
     parser.popQueryState(subQuery);
     this.$ = subQuery;
   
break;
case 1103: case 1104: case 1105: case 1106:
this.$ = { alias: $$[$0], location: _$[$0] };
break;
case 1113: case 1114:

     if (parser.yy.result.suggestFunctions) {
       parser.suggestAggregateFunctions();
     }
   
break;
case 1115:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords([{ value: 'PARTITION BY', weight: 2 }, { value: 'ORDER BY', weight: 1 }]);
     } else if (!$$[$0-2]) {
       parser.suggestKeywords(['PARTITION BY']);
     }
   
break;
case 1116:

      if (!$$[$0-1]) {
        parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ORDER BY', weight: 2 }]);
      } else {
        parser.suggestValueExpressionKeywords($$[$0-3]);
      }
    
break;
case 1125:

      // Only allowed in last order by
      delete parser.yy.result.suggestAnalyticFunctions;
    
break;
case 1126:

      var keywords = [];
      if ($$[$0-2].suggestKeywords) {
        keywords = parser.createWeightedKeywords($$[$0-2].suggestKeywords, 2);
      }
      if (!$$[$0]) {
        keywords = keywords.concat([{ value: 'RANGE BETWEEN', weight: 1 }, { value: 'ROWS BETWEEN', weight: 1 }]);
      }
      parser.suggestKeywords(keywords);
    
break;
case 1132:

     parser.suggestKeywords(['BETWEEN']);
   
break;
case 1133:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED PRECEDING']);
     } else if (!$$[$0-1]) {
       parser.suggestKeywords(['AND']);
     }
   
break;
case 1138:

    lexer.popState();
  
break;
case 1139:

    lexer.begin('hdfs');
  
break;
case 1141:

      parser.suggestHdfs({ path: $$[$0-3] });
    
break;
case 1142:

     parser.suggestHdfs({ path: $$[$0-2] });
   
break;
case 1143:

      parser.suggestHdfs({ path: $$[$0-1] });
    
break;
case 1144:

     parser.suggestHdfs({ path: '' });
   
break;
case 1145:

      parser.suggestHdfs({ path: '' });
    
break;
case 1151:

     parser.suggestKeywords(['PRECEDING']);
   
break;
case 1152: case 1157:

     parser.suggestKeywords(['ROW']);
   
break;
case 1156:

     parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED FOLLOWING']);
   
break;
case 1158:

     parser.suggestKeywords(['FOLLOWING']);
   
break;
case 1162:
this.$ = { inValueEdit: true };
break;
case 1163:
this.$ = { inValueEdit: true, cursorAtStart: true };
break;
case 1164: case 1165: case 1166:

     this.$ = { suggestKeywords: ['NOT'] }
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1170: case 1171: case 1172:

     parser.suggestFunctions({ types: [ 'STRING' ] });
     parser.suggestColumns({ types: [ 'STRING' ] });
     this.$ = { types: ['BOOLEAN'] }
   
break;
case 1173:

     this.$ = parser.findCaseType($$[$0-1])
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1174:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1175:
this.$ = parser.findCaseType($$[$0-1]);
break;
case 1176:

     parser.suggestValueExpressionKeywords($$[$0-1], ['END']);
     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1177:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1178:
this.$ = parser.findCaseType($$[$0-2]);
break;
case 1179:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1180:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-2]);
   
break;
case 1181:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     this.$.suggestFilters = $$[$0-1].suggestFilters
   
break;
case 1182:

     parser.valueExpressionSuggest();
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1183:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1184:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = $$[$0-1];
   
break;
case 1185:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ] };
   
break;
case 1188:

     this.$ = { caseTypes: [ $$[$0] ], lastType: $$[$0] }
     parser.extractExpressionText(this.$, $$[$0]);
   
break;
case 1189:

     $$[$0-1].caseTypes.push($$[$0]);
     this.$ = { caseTypes: $$[$0-1].caseTypes, lastType: $$[$0] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1193:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
   
break;
case 1195:

     this.$ = $$[$0]
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1196:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0].suggestFilters };
break;
case 1197:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1198:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1199: case 1200:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0].suggestFilters };
break;
case 1201:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1202:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [$$[$0]] };
   
break;
case 1203:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1204:

      parser.valueExpressionSuggest();
      parser.suggestKeywords(['WHEN']);
      this.$ = { caseTypes: [{ types: ['T'] }] };
    
break;
case 1205: case 1207:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1206:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1208:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [$$[$0]], suggestFilters: true };
   
break;
case 1209:

     parser.suggestValueExpressionKeywords($$[$0-1], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1210:

     parser.suggestValueExpressionKeywords($$[$0-2], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1211: case 1212: case 1213: case 1214:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
}
},
table: [o($V0,$V1,{338:1,263:2}),{1:[3]},o($V2,$V3,{339:3,343:4,19:5,155:6,44:7,20:8,21:9,22:10,23:11,24:12,25:13,26:14,27:15,28:16,29:17,34:19,35:20,156:21,157:22,168:23,169:24,36:25,42:26,158:31,4:$V4,8:$V5,12:$V6,16:$V7,162:$V8,174:$V9,241:$Va,271:$Vb,321:$Vc,337:$Vd}),{340:[1,37],344:[1,38]},o($V2,[2,626]),o($V2,[2,632]),o($V2,[2,633]),o($V2,[2,634]),o($V2,[2,15]),o($V2,[2,16]),o($V2,[2,17]),o($V2,[2,18]),o($V2,[2,19]),o($V2,[2,20]),o($V2,[2,21]),o($V2,[2,22]),o($V2,[2,23]),o($V2,[2,24]),{30:[1,39],31:40,59:41,63:$Ve,113:$Vf,228:$Vg,347:44,348:$Vh,349:$Vi},o($V2,[2,27]),o($V2,[2,28]),o($V2,[2,244]),o($V2,[2,245]),{79:[1,49],169:48,241:$Va},o($Vj,$Vk,{170:50,258:51,260:52,262:$Vl}),{37:54,125:[1,55]},{43:[1,56]},{39:[1,59],47:[1,60],57:57,63:[1,58],365:$Vm,383:$Vn},{39:[1,65],47:[1,66],57:63,63:[1,64],365:$Vm,383:$Vn},{39:[1,67]},{59:68,63:$Ve,113:$Vf,228:$Vg,347:44,348:$Vh,349:$Vi},o($V2,[2,246]),{59:74,63:$Ve,113:$Vf,119:73,228:$Vg,322:69,328:70,330:71,347:44,348:$Vh,349:$Vi,358:$Vo,427:72},{59:74,63:$Ve,113:$Vf,119:78,175:76,177:77,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},o([54,55,63,79,95,96,107,112,113,228,253,267,269,270,271,294,295,296,297,298,299,300,301,302,303,304,306,307,348,349,351,352,355,358,362,370,389,390],$Vp,{242:79,30:$Vq,247:$Vr}),{39:[1,82],47:[1,83]},{163:[1,84]},{1:[2,621]},o($V0,$V1,{263:85}),o($V2,[2,25]),{32:[1,86],267:[1,87]},o($Vs,[2,471]),o($Vt,[2,644]),o($Vt,[2,645]),o($Vt,[2,646]),o($Vt,[2,641]),o($Vt,[2,642]),o($Vt,[2,643]),o($Vj,$Vk,{258:51,260:52,170:88,262:$Vl}),{44:89,168:23,169:24,174:$V9,241:$Va},o($Vj,[2,262]),o($Vj,[2,452],{260:90,262:$Vl}),o($Vu,[2,454]),o([30,241,247],$V1,{263:91}),o($V2,[2,29]),{79:[1,92]},{44:93,168:23,169:24,174:$V9,241:$Va},o($Vv,$Vw,{58:94,306:$Vx}),{59:96,63:$Ve,113:$Vf,228:$Vg,347:44,348:$Vh,349:$Vi},o($Vy,$Vw,{58:97,306:$Vx}),o($Vy,$Vw,{58:98,306:$Vx}),o($Vz,[2,761]),o($Vz,[2,762]),o($Vy,$VA,{150:99,306:$VB}),{59:101,63:$Ve,113:$Vf,228:$Vg,347:44,348:$Vh,349:$Vi},o($VC,$VA,{150:102,306:$VB}),o($VC,$VA,{150:103,306:$VB}),o($VC,$VA,{150:104,306:$VB}),o($V2,[2,619]),{16:[1,105]},{16:[2,598]},{16:[2,600]},{16:[2,860],59:74,63:$Ve,113:$Vf,119:106,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},o($VD,[2,856],{267:[1,107]}),o($Vt,[2,853]),{56:[1,108],358:[1,109]},o([79,241],[2,271],{85:[1,110]}),o($VE,[2,273]),{43:[1,111]},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:114,227:144,228:$Vg,243:112,250:113,253:$VM,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($V91,[2,414]),o($V91,[2,415]),{40:170,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},{40:173,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},o($VC,[2,258],{164:174,39:[1,175]}),o($V2,$V3,{343:4,19:5,155:6,44:7,20:8,21:9,22:10,23:11,24:12,25:13,26:14,27:15,28:16,29:17,34:19,35:20,156:21,157:22,168:23,169:24,36:25,42:26,158:31,339:176,4:$V4,8:$V5,12:$V6,16:$V7,162:$V8,174:$V9,241:$Va,271:$Vb,321:$Vc,337:$Vd}),{33:177,51:180,54:$VF,55:$VG,59:178,63:$Ve,96:[1,183],113:$Vf,227:184,228:$Vg,267:$VN,268:179,269:[1,181],270:[1,182],347:44,348:$Vh,349:$Vi,352:[1,185],389:$V71,390:$V81,395:187,398:188,448:[1,186],453:150,454:151},{59:189,63:$Ve,113:$Vf,228:$Vg,347:44,348:$Vh,349:$Vi},o($Vj,[2,260]),{81:[1,190]},o($Vu,[2,455]),{30:$Vq,241:$Vp,242:191,247:$Vr},{59:74,63:$Ve,87:194,113:$Vf,119:146,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,409:192,425:193},o($V2,[2,37]),o($V2,[2,54],{347:44,59:195,63:$Ve,113:$Vf,228:$Vg,348:$Vh,349:$Vi}),{95:[1,196]},o($V2,[2,63]),{59:74,63:$Ve,64:197,66:198,72:199,113:$Vf,119:200,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{59:74,63:$Ve,72:201,113:$Vf,119:200,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{59:74,63:$Ve,113:$Vf,119:202,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{370:[1,203]},o($V2,[2,229]),{40:204,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},{40:205,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},{40:206,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},{59:74,63:$Ve,87:138,113:$Vf,119:146,149:210,228:$Vg,323:207,332:208,334:209,347:44,348:$Vh,349:$Vi,358:$Vo,429:211},{16:[2,861]},{59:74,63:$Ve,113:$Vf,119:212,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{358:[1,213]},o($Vt,[2,855]),{59:74,63:$Ve,113:$Vf,119:78,177:214,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{79:[1,215]},o($Vu,[2,403],{244:216,181:218,85:[1,217],182:[1,219]}),o($Va1,[2,420]),o($Va1,$Vb1,{347:44,59:74,395:187,398:188,252:220,440:234,119:235,51:236,32:$Vc1,43:$Vd1,54:$VF,55:$VG,63:$Ve,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,113:$Vf,142:$Vi1,228:$Vg,253:$Vj1,348:$Vh,349:$Vi,352:$Vk1,356:$Vl1,357:$Vm1,358:$Vo,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($Va1,[2,436]),o($Vt1,[2,897]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:241,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:242,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:243,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:244,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{79:$Vu1,437:245},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:247,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:249,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,392:$Vv1,395:152,398:153,429:129,441:248,449:137,451:145,453:150,454:151,455:154,503:250,505:251},o($Vt1,[2,553],{310:253,79:$Vw1}),{79:$Vw1,310:255},o($Vt1,[2,551]),o($Vt1,[2,552]),o($Vt1,[2,554]),o($Vx1,[2,1029],{267:[1,256]}),{79:[2,533]},{79:[2,534]},{79:[2,535]},{79:[2,536]},o($Vt1,[2,582],{275:257,277:258,318:$Vy1}),{277:260,318:$Vy1},o($Vt1,[2,490]),o($Vt1,[2,1035]),o($Vz1,[2,867]),o($VA1,[2,498]),o($VA1,[2,499]),o($VA1,[2,500]),{79:[1,261]},{79:[1,262]},o($Vt1,[2,1037]),o($Vt1,[2,1038]),o([32,43,50,54,55,63,77,79,81,85,95,107,108,109,112,113,129,142,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,253,262,264,267,340,344,348,349,352,356,357,358,359,360,361,363,366,367,368,369,371,374,375,376,377,379,380,382,384,385,386,387,388,391,392,439],[2,877]),{79:[1,263]},{79:[1,264]},{79:[1,265]},o($Vt1,[2,1040]),o($Vt1,[2,1041]),o($Vt1,[2,1049]),o($Vt1,[2,1050]),o($Vt1,[2,1051]),{79:[2,509]},{79:[2,510]},{79:[2,511]},{79:[2,512]},{79:[2,513]},{79:[2,514]},{79:[2,515]},{79:[2,516]},o($Vt1,[2,1042],{267:[1,266]}),{389:[1,267],390:[1,268]},{389:[1,269]},{54:[1,271],56:[1,270]},{55:[1,273],56:[1,272]},o($Vt1,[2,1054]),o($Vt1,[2,1055]),{125:[2,34]},o($VB1,[2,828],{267:[1,274]}),o($VB1,[2,830],{267:[1,275]}),{43:[2,43]},{40:276,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},o($VC,[2,259]),o($V2,[2,627]),o($V2,[2,26]),o($V2,[2,473]),o($V2,[2,474],{347:44,59:277,63:$Ve,113:$Vf,228:$Vg,348:$Vh,349:$Vi}),o($V2,[2,476]),o($V2,[2,477]),o($V2,[2,478]),o($V2,[2,479]),o($Vv,[2,1032]),{227:278,267:$VN,389:$V71,390:$V81,453:150,454:151},{227:279,267:$VN,389:$V71,390:$V81,453:150,454:151},o($VC1,[2,769]),o($VC1,[2,770]),o($Vs,[2,472]),o($Vj,$Vk,{258:51,260:52,170:280,262:$Vl}),{169:281,241:$Va},{81:[1,282],85:[1,283]},o($VD1,[2,842]),{32:[1,284]},o($V2,$VE1,{60:285,48:286,49:287,50:$VF1}),{370:[1,289]},o($V2,[2,64]),o($VG1,[2,160],{67:290,124:291,125:[1,292]}),o($VH1,[2,76],{73:293,76:294,77:[1,295],79:[1,296]}),o($VI1,[2,835],{267:[1,297]}),o($VJ1,[2,212],{144:298,146:299,79:[1,300]}),o($V2,[2,776],{151:301,405:[1,302]}),o($VC,[2,779]),o($V2,[2,236],{153:303,154:[1,304]}),o($V2,[2,238]),o($V2,[2,480]),o($VK1,[2,615],{324:305,85:[1,306],182:[1,307]}),o($VL1,[2,602]),{32:[1,308]},{32:[2,612]},o($VM1,[2,864],{267:[1,309]}),o($VD,[2,857]),o($Vt,[2,854]),o($VE,[2,274]),o($VN1,$VO1,{179:310,466:311}),o($Vu,[2,404]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:114,227:144,228:$Vg,250:312,253:$VM,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VP1,$VQ1,{248:313,255:314,257:315,264:$VR1}),{40:324,55:$VG,59:74,63:$Ve,79:$Vu1,113:$Vf,119:171,183:317,186:318,207:320,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172,437:325,456:319,458:321,460:322,461:323},o($Va1,[2,435]),o($VS1,[2,1056],{436:326,95:[1,327]}),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:328,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:329,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:330,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:331,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{77:$Ve1,359:[1,333],374:[1,332],379:$Vr1,380:$Vs1,440:334},{79:[1,335]},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:336,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:337,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:338,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:339,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:340,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:341,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vt1,[2,923]),o($VT1,[2,1103]),o($VT1,[2,1104]),{51:343,54:$VF,55:$VG,59:74,63:$Ve,113:$Vf,119:342,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,395:187,398:188},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:344,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:345,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:346,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VU1,[2,898],{440:234,32:$Vc1,77:$Ve1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VU1,[2,899],{440:234,32:$Vc1,77:$Ve1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VU1,[2,900],{440:234,32:$Vc1,77:$Ve1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VV1,[2,901],{440:234}),o($Vt1,[2,906]),o($VN1,$VO1,{466:311,437:325,179:347,461:348,79:$Vu1}),{32:$Vc1,77:$Ve1,81:[1,349],95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,440:234},o($Vt1,[2,925]),{32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,392:$Vv1,440:234,441:350,503:250,505:251},{368:[1,352],369:[1,351],392:$Vv1,505:353},o($VW1,[2,1188]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:354,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vt1,[2,549]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,81:[1,355],87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:357,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,292:356,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vt1,[2,550]),{59:74,63:$Ve,87:359,113:$Vf,119:146,228:$Vg,253:[1,358],347:44,348:$Vh,349:$Vi,358:$Vo},o($Vt1,[2,488]),o($Vt1,[2,583]),{59:74,63:$Ve,79:[1,362],113:$Vf,119:360,228:$Vg,319:361,347:44,348:$Vh,349:$Vi,358:$Vo},o($Vt1,[2,489]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,81:[1,363],87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:357,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,292:364,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,81:[1,366],87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:365,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o([54,55,63,79,81,95,96,107,112,113,228,267,269,270,271,294,295,296,297,298,299,300,301,302,303,304,306,307,348,349,351,352,355,358,362,370,389,390],$Vp,{242:367,30:$Vq,247:$Vr}),o($VX1,$Vp,{242:370,30:$Vq,81:[1,369],247:$Vr,253:[1,368]}),o($VX1,$Vp,{242:371,30:$Vq,81:[1,372],247:$Vr}),o($Vt1,[2,1043],{389:[1,373],390:[1,374]}),o($Vt1,[2,1045]),{389:[1,375]},o($Vt1,[2,1046]),{54:[1,376]},o($VY1,[2,764]),{55:[1,377]},o($VZ1,[2,767]),{59:74,63:$Ve,113:$Vf,119:378,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{55:$VG,398:379},{140:[1,380]},o($V2,[2,475]),o($Vv,[2,1033]),o($Vv,[2,1034]),o($Vj,[2,261]),o($Vu,[2,460]),o($V2,[2,791]),{59:74,63:$Ve,87:194,113:$Vf,119:146,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,425:381},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:382,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($V2,[2,55]),o($V2,[2,61]),o([43,81,85,109,340,344],[2,47]),{51:383,54:$VF,55:$VG,395:187,398:188},o([63,113,228,340,344,348,349,358],[2,782]),o($V2,[2,198],{68:384,43:[1,385]}),o($VG1,[2,161]),{126:[1,386]},o($VH1,[2,73]),o($VH1,[2,77]),{40:387,55:$VG,59:74,63:$Ve,113:$Vf,119:171,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172},{59:74,63:$Ve,80:388,84:389,87:390,113:$Vf,119:146,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{59:74,63:$Ve,113:$Vf,119:391,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{43:$VE1,48:392,49:287,50:$VF1},o($VJ1,[2,213]),{59:74,63:$Ve,87:138,113:$Vf,119:146,147:393,149:394,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,429:211},o($V2,[2,222]),o($V2,[2,777]),o($V2,[2,230]),o($V2,[2,237]),o($V2,$VQ1,{257:315,255:395,264:$VR1}),{59:74,63:$Ve,87:138,113:$Vf,119:146,149:210,228:$Vg,332:396,334:209,347:44,348:$Vh,349:$Vi,358:$Vo,429:211},{40:324,55:$VG,59:74,63:$Ve,79:$Vu1,113:$Vf,119:171,186:397,207:320,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172,437:325,456:319,458:321,460:322,461:323},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:399,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,335:398,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{59:74,63:$Ve,87:359,113:$Vf,119:146,228:$Vg,253:[1,400],347:44,348:$Vh,349:$Vi,358:$Vo},{81:[1,401]},{44:409,168:23,169:24,174:$V9,241:$Va,468:402,470:403,472:404,474:405,476:406,478:407,480:408},o($Va1,[2,421]),o($Vu,[2,416]),o($V_1,[2,293],{188:410,189:411,190:[1,412]}),o($VP1,[2,465]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:414,227:144,228:$Vg,265:413,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o([81,190,201,226,232,262,264,340,344],[2,283],{85:[1,415]}),o($V$1,[2,286]),o($V$1,[2,1058]),o($V$1,[2,1060],{204:416,206:417,214:$V02,215:$V12,216:$V22,217:$V32,218:$V42,219:$V52,220:$V62,221:$V72}),o($V$1,[2,1061]),o($V82,$Vb1,{347:44,59:74,395:187,398:188,119:235,51:236,252:426,43:$Vd1,54:$VF,55:$VG,63:$Ve,113:$Vf,228:$Vg,348:$Vh,349:$Vi,358:$Vo}),o($V82,$Vb1,{347:44,59:74,395:187,398:188,119:235,51:236,252:427,43:$Vd1,54:$VF,55:$VG,63:$Ve,113:$Vf,228:$Vg,348:$Vh,349:$Vi,358:$Vo}),o($V92,[2,1072]),o($V92,[2,1074]),{96:[1,428],247:[1,431],269:[1,429],270:[1,430]},o($VS1,[2,1057]),o($Va2,[2,908],{440:234,77:$Ve1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($Va2,[2,909],{440:234,77:$Ve1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($Va2,[2,910],{440:234,77:$Ve1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($Va2,[2,911],{440:234,77:$Ve1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),{79:[1,432]},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:433,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vt1,[2,924]),o($VN1,$VO1,{347:44,59:74,308:116,309:124,305:125,273:126,311:127,429:129,274:134,276:135,278:136,449:137,87:138,285:139,286:140,287:141,227:144,451:145,119:146,291:147,453:150,454:151,395:152,398:153,455:154,466:311,179:434,438:435,138:436,54:$VF,55:$VG,63:$Ve,79:$VH,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,306:$V01,307:$V11,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81}),{32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,439:[1,437],440:234},o($Vb2,[2,918],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($Vb2,[2,919],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VV1,[2,920],{440:234,77:$Ve1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VV1,[2,921],{440:234,77:$Ve1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VV1,[2,922],{440:234,77:$Ve1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($VT1,[2,1105]),o($VT1,[2,1106]),o($VV1,[2,1164],{440:234}),o($VV1,[2,1165],{440:234}),o($VV1,[2,1166],{440:234}),{81:[1,438]},{43:$Vd1,51:236,54:$VF,55:$VG,59:74,63:$Ve,81:$Vb1,113:$Vf,119:235,228:$Vg,252:439,347:44,348:$Vh,349:$Vi,358:$Vo,395:187,398:188},o($Vt1,[2,907]),o($Vt1,[2,926]),o($Vt1,[2,1173]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:440,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VW1,[2,1189]),{32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,386:[1,441],440:234},o($Vt1,[2,564]),{81:[1,442],85:$Vc2},o($VD1,[2,569],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($Vx1,[2,1030]),o($Vz1,[2,868]),o($Vt1,[2,585]),o($Vt1,[2,586]),o($Vd2,[2,1117],{482:444,486:445,125:[1,446]}),{318:[2,528]},{81:[1,447],85:$Vc2},{32:$Vc1,43:[1,448],77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,440:234},o($Vt1,[2,538]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,81:[1,449],87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:357,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,292:450,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{81:[1,451]},o($VA1,[2,518]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:357,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,292:452,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:453,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VA1,[2,524]),o($Vt1,[2,1044]),{389:[1,454]},o($Vt1,[2,1047]),o($VY1,[2,763]),o($VZ1,[2,766]),o($VB1,[2,829]),o($VB1,[2,831]),{79:$Ve2,165:455,166:456},o($VD1,[2,843]),o($VD1,[2,848],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o([43,50,81,85,95,96,109,340,344],[2,48]),o($V2,[2,68]),o($VN1,[2,202],{143:458}),{127:459,129:[1,460]},o($VH1,[2,78]),{81:[1,461],85:[1,462]},o($VD1,[2,84]),{88:463,97:464,98:465,99:466,100:467,101:468,102:469,103:470,107:$Vf2,112:$Vg2,113:$Vh2,360:$Vi2,361:$Vj2,363:$Vk2,366:$Vl2,367:$Vm2,371:$Vn2,375:$Vo2,384:$Vp2,385:$Vq2,387:$Vr2,388:$Vs2,391:$Vt2},o($VI1,[2,836]),{43:[1,486]},{81:[1,487],85:[1,488]},o($VD1,$VE1,{49:287,48:489,50:$VF1}),o($V2,[2,588]),o($VL1,[2,603]),o($VK1,[2,616]),o($VL1,[2,608]),o($VL1,[2,613],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($VM1,[2,865]),o($VE,[2,279]),{81:[2,1086]},{81:[2,1088]},{81:[2,1090]},{81:[2,1092]},{81:[2,1094]},{81:[2,1096]},{81:[2,1098]},{81:[2,1100]},o($Vu2,[2,322],{199:490,200:491,201:[1,492]}),o($V_1,[2,294]),{126:[1,493]},o($VP1,[2,466]),o($VP1,[2,469],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),{40:324,55:$VG,59:74,63:$Ve,79:$Vu1,113:$Vf,119:171,186:494,207:320,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172,437:325,456:319,458:321,460:322,461:323},o($V$1,[2,1064],{206:495,214:$V02,215:$V12,216:$V22,217:$V32,218:$V42,219:$V52,220:$V62,221:$V72}),{40:324,55:$VG,59:74,63:$Ve,79:$Vu1,113:$Vf,119:171,207:496,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172,437:325,460:322,461:323},{215:[1,497]},{215:[1,498],217:[1,499]},{215:[1,500]},o($Vv2,[2,347]),{215:[1,502],217:[1,503],218:[1,501],220:[1,504]},{215:[1,505]},{215:[1,507],217:[1,508],218:[1,506],220:[1,509]},{215:[1,510]},o($V82,[2,1067]),o($V82,[2,1068]),o($Vt1,[2,902]),o($Vt1,[2,903]),o($Vt1,[2,904]),{182:[1,511]},o($VN1,$VO1,{347:44,59:74,308:116,309:124,305:125,273:126,311:127,429:129,274:134,276:135,278:136,449:137,87:138,285:139,286:140,287:141,227:144,451:145,119:146,291:147,453:150,454:151,395:152,398:153,455:154,466:311,138:436,179:512,438:513,54:$VF,55:$VG,63:$Ve,79:$VH,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,306:$V01,307:$V11,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81}),{32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,439:[1,514],440:234},{81:[1,515]},{81:[1,516],85:$Vw2},o($Vx2,[2,1014],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:518,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vy2,[2,1082]),{81:[1,519]},{32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,369:[1,520],374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,440:234},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:521,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vt1,[2,565]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:522,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{81:[2,1123],231:524,232:$Vz2,483:523},o($Vd2,[2,1118]),{126:[1,526]},{318:[2,529]},{97:527,360:$Vi2,361:$Vj2,363:$Vk2,366:$Vl2,367:$Vm2,371:$Vn2,375:$Vo2,384:$Vp2,385:$Vq2,387:$Vr2,388:$Vs2,391:$Vt2},o($VA1,[2,504]),{81:[1,528],85:$Vc2},o($VA1,[2,517]),{81:[1,529],85:$Vc2},{32:$Vc1,77:$Ve1,81:[1,530],95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,440:234},o($Vt1,[2,1048]),o($V2,[2,249],{85:[1,531]}),o($VA2,[2,255]),{54:$VF,55:$VG,59:74,63:$Ve,87:138,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,167:532,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:533,309:124,311:127,347:44,348:$Vh,349:$Vi,358:$Vo,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{44:534,168:23,169:24,174:$V9,241:$Va},o($VG1,[2,162]),{79:[1,536],130:535},o($VH1,[2,82]),{59:74,63:$Ve,84:537,87:390,113:$Vf,119:146,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},o($VD1,[2,98],{89:538,92:539,93:540,49:543,50:$VF1,95:$VB2,96:$VC2}),o($VD2,[2,110]),o($VD2,[2,111]),o($VD2,[2,112]),o($VD2,[2,113]),o($VD2,[2,114]),o($VD2,[2,115]),o($VD2,[2,116]),o($VD2,[2,880]),o($VD2,[2,881]),o($VD2,$VE2,{434:544,79:$VF2}),o($VD2,[2,894],{435:546,79:[1,547]}),o($VD2,[2,884]),o($VD2,[2,885]),o($VD2,[2,886]),o($VD2,[2,887]),o($VD2,[2,888]),o($VD2,[2,889]),o($VD2,[2,890]),o($VD2,$VE2,{434:548,79:$VF2}),{108:[1,549]},{108:[1,550]},{108:[1,551]},{44:552,168:23,169:24,174:$V9,241:$Va},o($VJ1,[2,214]),{59:74,63:$Ve,87:138,113:$Vf,119:146,149:553,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,429:211},o($VD1,[2,216]),o($VG2,[2,385],{230:554,231:555,232:$Vz2}),o($Vu2,[2,323]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:556,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:558,191:557,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($V$1,[2,287]),{40:324,55:$VG,59:74,63:$Ve,79:$Vu1,113:$Vf,119:171,207:559,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,398:172,437:325,460:322,461:323},o($VH2,$VI2,{208:560,222:$VJ2}),o($Vv2,[2,343]),o($Vv2,[2,344]),{215:[1,562]},o($Vv2,[2,346]),{215:[1,563]},o($Vv2,[2,349]),{215:[1,564]},{215:[1,565]},o($Vv2,[2,352]),{215:[1,566]},o($Vv2,[2,354]),{215:[1,567]},{215:[1,568]},o($Vv2,[2,357]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:569,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{81:[1,570]},{81:[1,571],85:$Vw2},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:572,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vt1,[2,914]),o($Vt1,[2,915]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:573,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o([43,54,55,63,81,85,113,129,182,190,201,214,215,216,217,218,219,220,221,226,228,232,239,240,262,264,340,344,348,349,356,358,359,368,369,377,382,386,392,439],[2,917],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($Vy2,[2,1083]),o($Vt1,[2,1174]),o($VW1,[2,1195],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($VD1,[2,570],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),{81:[1,574]},{81:[2,1128],129:[1,579],382:[1,578],487:575,489:576,490:577},{126:[1,580]},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:436,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,438:581,449:137,451:145,453:150,454:151,455:154},{81:[1,582]},o($VA1,[2,505]),o($VA1,[2,519]),o($VA1,[2,523]),{79:$Ve2,166:583},{81:[1,584],85:[1,585]},o($VD1,[2,1027]),o($V2,[2,199]),{79:[1,587],131:586},{59:74,63:$Ve,87:589,113:$Vf,119:146,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo,421:588},o($VD1,[2,85]),o($VD1,[2,94]),o($VD1,[2,99],{49:543,93:590,50:$VF1,95:$VB2,96:$VC2}),o($VK2,[2,100]),{96:[1,591]},o($VK2,[2,107]),o($VK2,[2,108]),o($VD2,[2,882]),{389:[1,592]},o($VD2,[2,883]),{389:[1,593]},o($VD2,[2,891]),{88:594,97:464,98:465,99:466,100:467,101:468,102:469,103:470,107:$Vf2,109:[1,595],112:$Vg2,113:$Vh2,360:$Vi2,361:$Vj2,363:$Vk2,366:$Vl2,367:$Vm2,371:$Vn2,375:$Vo2,384:$Vp2,385:$Vq2,387:$Vr2,388:$Vs2,391:$Vt2},{97:596,109:[1,597],360:$Vi2,361:$Vj2,363:$Vk2,366:$Vl2,367:$Vm2,371:$Vn2,375:$Vo2,384:$Vp2,385:$Vq2,387:$Vr2,388:$Vs2,391:$Vt2},{59:74,63:$Ve,109:[1,599],113:$Vf,114:598,116:600,119:601,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},o($V2,[2,203]),o($VD1,$VE1,{49:287,48:602,50:$VF1}),o($Vu,[2,378],{224:603,225:604,226:[1,605]}),o($VG2,[2,386]),o($Vu2,[2,324],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($V_1,[2,295],{85:[1,606]}),o($VL2,[2,310],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($VH2,$VI2,{208:607,222:$VJ2}),o($VH2,[2,330]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:608,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vv2,[2,345]),o($Vv2,[2,348]),o($Vv2,[2,350]),o($Vv2,[2,351]),o($Vv2,[2,353]),o($Vv2,[2,355]),o($Vv2,[2,356]),o($VV1,[2,905],{440:234}),o($Vt1,[2,912]),o($Vt1,[2,913]),o($VU1,[2,916],{440:234,32:$Vc1,77:$Ve1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,357:$Vm1,374:$Vo1,376:$Vp1,379:$Vr1,380:$Vs1}),o($Vx2,[2,1015],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($Vt1,[2,1112]),{81:[2,1124]},{81:[2,1129]},{359:[1,609],494:[1,610]},o($VM2,[2,1146]),o($VM2,[2,1147]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:613,227:144,228:$Vg,233:611,236:612,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($Vd2,[2,1119],{85:$Vw2}),o($Vt1,[2,537]),o($VA2,[2,256]),o($VA2,[2,257]),{54:$VF,55:$VG,59:74,63:$Ve,87:138,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:614,309:124,311:127,347:44,348:$Vh,349:$Vi,358:$Vo,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VG1,[2,166]),{125:$VN2,134:615,136:616},{81:[1,618],85:[1,619]},o($VD1,[2,821]),o($VK2,[2,101]),o($VK2,[2,106]),{81:[1,620]},{81:[1,621],85:[1,622]},{109:[1,623]},o($VD2,[2,121]),{85:[1,624]},o($VD2,[2,125]),{85:[1,626],109:[1,625]},o($VD2,[2,131]),o($VO2,[2,133]),{120:[1,627]},o($VD1,[2,217]),o($Vu,[2,440]),o($Vu,[2,379]),{227:628,228:[1,629],267:$VN,389:$V71,390:$V81,453:150,454:151},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:630,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VH2,[2,331]),o($VH2,[2,373],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($VP2,$VQ2,{491:631}),o($VP2,$VQ2,{491:632}),o([81,129,226,262,340,344,382],[2,387],{85:[1,633]}),o($VR2,[2,390]),o($VR2,[2,400],{440:234,238:634,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,239:[1,635],240:[1,636],253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($VD1,[2,1028]),{81:[1,637],85:[1,638]},o($VD1,[2,175]),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:639,140:[1,640],227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{79:[2,818]},{59:74,63:$Ve,87:641,113:$Vf,119:146,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},o($VD2,[2,893]),o($VD2,[2,895]),{389:[1,642]},o($VD2,[2,120]),{88:643,97:464,98:465,99:466,100:467,101:468,102:469,103:470,107:$Vf2,112:$Vg2,113:$Vh2,360:$Vi2,361:$Vj2,363:$Vk2,366:$Vl2,367:$Vm2,371:$Vn2,375:$Vo2,384:$Vp2,385:$Vq2,387:$Vr2,388:$Vs2,391:$Vt2},o($VD2,[2,130]),{59:74,63:$Ve,113:$Vf,116:644,119:601,228:$Vg,347:44,348:$Vh,349:$Vi,358:$Vo},{88:645,97:464,98:465,99:466,100:467,101:468,102:469,103:470,107:$Vf2,112:$Vg2,113:$Vh2,360:$Vi2,361:$Vj2,363:$Vk2,366:$Vl2,367:$Vm2,371:$Vn2,375:$Vo2,384:$Vp2,385:$Vq2,387:$Vr2,388:$Vs2,391:$Vt2},o($Vu,[2,380],{85:[1,646]}),o($Vu,[2,382],{85:[1,647]}),o($VL2,[2,311],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),o($VS2,$VT2,{492:648,502:649,364:$VU2,389:$VV2,494:$VW2}),o($VS2,$VT2,{502:649,492:653,364:$VU2,389:$VV2,494:$VW2}),{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:613,227:144,228:$Vg,236:654,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VR2,[2,397]),o($VR2,[2,401]),o($VR2,[2,402]),o($VG1,[2,172]),{125:$VN2,136:655},{32:$Vc1,77:$Ve1,95:$Vf1,108:[1,657],109:$Vh1,139:656,142:[1,658],253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1,440:234},{108:$VX2,139:659,142:$VY2},o($VD1,[2,822]),{81:[1,662]},{109:[1,663]},o($VO2,[2,134]),o($VO2,$VE1,{49:287,48:664,50:$VF1}),{227:665,267:$VN,389:$V71,390:$V81,453:150,454:151},{228:[1,666]},{81:$VZ2,356:$V_2,493:667},{378:[1,669]},{381:[1,670]},o($V$2,[2,1159]),o($V$2,[2,1160]),{81:$VZ2,356:$V_2,493:671},o($VR2,[2,391]),o($VD1,[2,176]),{140:[1,672]},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:329,140:$V03,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:331,140:$V13,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:673,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},o($VX1,$V03),o($VX1,$V13),o($VD2,[2,896]),o($VD2,[2,124]),o($VO2,[2,140]),o($Vu,[2,381]),o($Vu,[2,383]),{81:[2,1130]},{364:[1,674],389:$VV2,494:$VW2,502:675},o($VS2,[2,1149]),o($VS2,[2,1150]),{81:[2,1131]},o($VD1,[2,184],{139:676,108:$VX2,142:$VY2}),o($VD1,[2,183],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1}),{381:[1,677]},{372:[1,678]},{54:$VF,55:$VG,59:74,63:$Ve,79:$VH,87:138,95:$VI,96:$VJ,107:$VK,112:$VL,113:$Vf,119:146,138:679,227:144,228:$Vg,267:$VN,269:$VO,270:$VP,271:$VQ,273:126,274:134,276:135,278:136,285:139,286:140,287:141,291:147,294:$VR,295:$VS,296:$VT,297:$VU,298:$VV,299:$VW,300:$VX,301:$VY,302:$VZ,303:$V_,304:$V$,305:125,306:$V01,307:$V11,308:116,309:124,311:127,347:44,348:$Vh,349:$Vi,351:$V21,352:$V31,355:$V41,358:$Vo,362:$V51,370:$V61,389:$V71,390:$V81,395:152,398:153,429:129,449:137,451:145,453:150,454:151,455:154},{81:[2,1154]},{81:[2,1155]},o($VD1,[2,182],{440:234,32:$Vc1,77:$Ve1,95:$Vf1,108:$Vg1,109:$Vh1,142:$Vi1,253:$Vj1,352:$Vk1,356:$Vl1,357:$Vm1,359:$Vn1,374:$Vo1,376:$Vp1,377:$Vq1,379:$Vr1,380:$Vs1})],
defaultActions: {37:[2,621],70:[2,598],71:[2,600],106:[2,861],130:[2,533],131:[2,534],132:[2,535],133:[2,536],155:[2,509],156:[2,510],157:[2,511],158:[2,512],159:[2,513],160:[2,514],161:[2,515],162:[2,516],170:[2,34],173:[2,43],210:[2,612],363:[2,528],402:[2,1086],403:[2,1088],404:[2,1090],405:[2,1092],406:[2,1094],407:[2,1096],408:[2,1098],409:[2,1100],447:[2,529],575:[2,1124],576:[2,1129],618:[2,818],667:[2,1130],671:[2,1131],677:[2,1154],678:[2,1155]},
parseError: function parseError (str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
    }
},
parse: function parse (input) {
    var self = this,
        stack = [0],
        tstack = [], // token stack
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    var args = lstack.slice.call(arguments, 1);

    //this.reductionCount = this.shiftCount = 0;

    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    // copy state
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }

    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);

    var ranges = lexer.options && lexer.options.ranges;

    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }

    function popStack (n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

_token_stack:
    var lex = function () {
        var token;
        token = lexer.lex() || EOF;
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length - 1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

_handle_error:
        // handle parse error
        if (typeof action === 'undefined' || !action.length || !action[0]) {
            var error_rule_depth;
            var errStr = '';

            // Return the rule stack depth where the nearest error rule can be found.
            // Return FALSE when no error recovery rule was found.
            function locateNearestErrorRecoveryRule(state) {
                var stack_probe = stack.length - 1;
                var depth = 0;

                // try to recover from error
                for(;;) {
                    // check for error recovery rule in this state
                    if ((TERROR.toString()) in table[state]) {
                        return depth;
                    }
                    if (state === 0 || stack_probe < 2) {
                        return false; // No suitable error recovery rule available.
                    }
                    stack_probe -= 2; // popStack(1): [symbol, action]
                    state = stack[stack_probe];
                    ++depth;
                }
            }

            if (!recovering) {
                // first see if there's any chance at hitting an error recovery rule:
                error_rule_depth = locateNearestErrorRecoveryRule(state);

                // Report error
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push("'"+this.terminals_[p]+"'");
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol)+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == EOF ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: lexer.yylloc,
                    ruleId: stack.slice(stack.length - 2, stack.length).join('_'),
                    expected: expected,
                    recoverable: (error_rule_depth !== false)
                });
            } else if (preErrorSymbol !== EOF) {
                error_rule_depth = locateNearestErrorRecoveryRule(state);
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol === EOF || preErrorSymbol === EOF) {
                    throw new Error(errStr || 'Parsing halted while starting to recover from another error.');
                }

                // discard current lookahead and grab another
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            if (error_rule_depth === false) {
                throw new Error(errStr || 'Parsing halted. No suitable error recovery rule available.');
            }
            popStack(error_rule_depth);

            preErrorSymbol = (symbol == TERROR ? null : symbol); // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {
            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(lexer.yytext);
                lstack.push(lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = lexer.yyleng;
                    yytext = lexer.yytext;
                    yylineno = lexer.yylineno;
                    yyloc = lexer.yylloc;
                    if (recovering > 0) {
                        recovering--;
                    }
                } else {
                    // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2:
                // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                if (ranges) {
                  yyval._$.range = [lstack[lstack.length-(len||1)].range[0], lstack[lstack.length-1].range[1]];
                }
                r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3:
                // accept
                return true;
        }

    }

    return true;
}};


SqlParseSupport.initSyntaxParser(parser);/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function(match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex () {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin (condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState () {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules () {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState (n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState (condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {"case-insensitive":true,"flex":true},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: /* skip whitespace */ 
break;
case 1: /* skip comments */ 
break;
case 2: /* skip comments */ 
break;
case 3: parser.yy.partialCursor = false; parser.yy.cursorFound = yy_.yylloc; return 5; 
break;
case 4: parser.yy.partialCursor = true; parser.yy.cursorFound = yy_.yylloc; return 393; 
break;
case 5: this.popState(); return 439; 
break;
case 6: return 30; 
break;
case 7: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('ALTER', yy_.yylloc, yy.lexer.upcomingInput()); return 4; 
break;
case 8: return 356; 
break;
case 9: return 43; 
break;
case 10: return 239; 
break;
case 11: this.begin('between'); return 359; 
break;
case 12: return 360; 
break;
case 13: return 361; 
break;
case 14: return 126; 
break;
case 15: return 405; 
break;
case 16: return 362; 
break;
case 17: return 363; 
break;
case 18: return 50; 
break;
case 19: parser.determineCase(yy_.yytext); return 8; 
break;
case 20: return 214; 
break;
case 21: return 364; 
break;
case 22: return 365; 
break;
case 23: return 366; 
break;
case 24: return 240; 
break;
case 25: return 247; 
break;
case 26: return 357; 
break;
case 27: return 367; 
break;
case 28: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('DROP', yy_.yylloc, yy.lexer.upcomingInput()); return 12; 
break;
case 29: return 368; 
break;
case 30: return 369; 
break;
case 31: parser.yy.correlatedSubQuery = true; return 370; 
break;
case 32: return 270; 
break;
case 33: return 371; 
break;
case 34: return 372; 
break;
case 35: parser.determineCase(yy_.yytext); return 182; 
break;
case 36: return 216; 
break;
case 37: return 190; 
break;
case 38: return 201; 
break;
case 39: return 306; 
break;
case 40: return 374; 
break;
case 41: return 218; 
break;
case 42: return 162; 
break;
case 43: return 375; 
break;
case 44: return 163; 
break;
case 45: return 376; 
break;
case 46: return 215; 
break;
case 47: return 219; 
break;
case 48: return 77; 
break;
case 49: return 226; 
break;
case 50: return 95; 
break;
case 51: return 96; 
break;
case 52: return 222; 
break;
case 53: return 348; 
break;
case 54: return 377; 
break;
case 55: return 232; 
break;
case 56: return 217; 
break;
case 57: return 125; 
break;
case 58: return 378; 
break;
case 59: return 154; 
break;
case 60: return 129; 
break;
case 61: return 379; 
break;
case 62: return 221; 
break;
case 63: return 380; 
break;
case 64: return 381; 
break;
case 65: return 63; 
break;
case 66: return 382; 
break;
case 67: return 383; 
break;
case 68: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SELECT', yy_.yylloc); return 241; 
break;
case 69: return 220; 
break;
case 70: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SET', yy_.yylloc); return 16; 
break;
case 71: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SHOW', yy_.yylloc); return 'SHOW'; 
break;
case 72: return 384; 
break;
case 73: return 385; 
break;
case 74: return 39; 
break;
case 75: return 386; 
break;
case 76: return 387; 
break;
case 77: return 388; 
break;
case 78: return 'TO'; 
break;
case 79: return 269; 
break;
case 80: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('TRUNCATE', yy_.yylloc, yy.lexer.upcomingInput()); return 271; 
break;
case 81: return 494; 
break;
case 82: return 262; 
break;
case 83: parser.determineCase(yy_.yytext); return 321; 
break;
case 84: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('USE', yy_.yylloc); return 337; 
break;
case 85: return 140; 
break;
case 86: return 391; 
break;
case 87: return 47; 
break;
case 88: return 392; 
break;
case 89: return 264; 
break;
case 90: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('WITH', yy_.yylloc); return 174; 
break;
case 91: return 318; 
break;
case 92: return 63; 
break;
case 93: yy.lexer.unput('('); yy_.yytext = 'avg'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 294; 
break;
case 94: yy.lexer.unput('('); yy_.yytext = 'cast'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 95: yy.lexer.unput('('); yy_.yytext = 'count'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 302; 
break;
case 96: yy.lexer.unput('('); yy_.yytext = 'max'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 295; 
break;
case 97: yy.lexer.unput('('); yy_.yytext = 'min'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 296; 
break;
case 98: yy.lexer.unput('('); yy_.yytext = 'stddev_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 297; 
break;
case 99: yy.lexer.unput('('); yy_.yytext = 'stddev_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 298; 
break;
case 100: yy.lexer.unput('('); yy_.yytext = 'sum'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 303; 
break;
case 101: yy.lexer.unput('('); yy_.yytext = 'var_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 299; 
break;
case 102: yy.lexer.unput('('); yy_.yytext = 'var_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 300; 
break;
case 103: yy.lexer.unput('('); yy_.yytext = 'variance'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 301; 
break;
case 104: yy.lexer.unput('('); yy_.yytext = 'cume_dist'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 105: yy.lexer.unput('('); yy_.yytext = 'dense_rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 106: yy.lexer.unput('('); yy_.yytext = 'first_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 107: yy.lexer.unput('('); yy_.yytext = 'lag'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 108: yy.lexer.unput('('); yy_.yytext = 'last_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 109: yy.lexer.unput('('); yy_.yytext = 'lead'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 110: yy.lexer.unput('('); yy_.yytext = 'rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 111: yy.lexer.unput('('); yy_.yytext = 'row_number'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 112: return 389; 
break;
case 113: return 389; 
break;
case 114: return 390; 
break;
case 115: return 349; 
break;
case 116: parser.yy.cursorFound = true; return 5; 
break;
case 117: parser.yy.cursorFound = true; return 393; 
break;
case 118: return 373; 
break;
case 119: parser.addFileLocation(yy_.yylloc, yy_.yytext); return 499; 
break;
case 120: this.popState(); return 500; 
break;
case 121: return 340; 
break;
case 122: return 356; 
break;
case 123: return 377; 
break;
case 124: return 32; 
break;
case 125: return 108; 
break;
case 126: return 109; 
break;
case 127: return 142; 
break;
case 128: return 142; 
break;
case 129: return 142; 
break;
case 130: return 142; 
break;
case 131: return 142; 
break;
case 132: return 352; 
break;
case 133: return 253; 
break;
case 134: return 357; 
break;
case 135: return 357; 
break;
case 136: return 357; 
break;
case 137: return 357; 
break;
case 138: return 357; 
break;
case 139: return 357; 
break;
case 140: return 85; 
break;
case 141: return 267; 
break;
case 142: return 120; 
break;
case 143: return 344; 
break;
case 144: return 355; 
break;
case 145: return 351; 
break;
case 146: return 79; 
break;
case 147: return 81; 
break;
case 148: return 353; 
break;
case 149: return 354; 
break;
case 150: return 228; 
break;
case 151: this.begin('backtickedValue'); return 358; 
break;
case 152:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '`')) {
                                               return 397;
                                             }
                                             return 56;
                                           
break;
case 153: this.popState(); return 358; 
break;
case 154: this.begin('singleQuotedValue'); return 54; 
break;
case 155:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '\'')) {
                                               return 397;
                                             }
                                             return 56;
                                           
break;
case 156: this.popState(); return 54; 
break;
case 157: this.begin('doubleQuotedValue'); return 55; 
break;
case 158:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '"')) {
                                               return 397;
                                             }
                                             return 56;
                                           
break;
case 159: this.popState(); return 55; 
break;
case 160: return 340; 
break;
case 161: /* To prevent console logging of unknown chars */ 
break;
case 162: 
break;
case 163: 
break;
case 164: 
break;
case 165: 
break;
case 166: 
break;
case 167:console.log(yy_.yytext);
break;
}
},
rules: [/^(?:\s)/i,/^(?:--.*)/i,/^(?:[/][*][^*]*[*]+([^/*][^*]*[*]+)*[/])/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:AND)/i,/^(?:ALL)/i,/^(?:ALTER)/i,/^(?:AND)/i,/^(?:AS)/i,/^(?:ASC)/i,/^(?:BETWEEN)/i,/^(?:BIGINT)/i,/^(?:BOOLEAN)/i,/^(?:BY)/i,/^(?:CASCADE)/i,/^(?:CASE)/i,/^(?:CHAR)/i,/^(?:COMMENT)/i,/^(?:CREATE)/i,/^(?:CROSS)/i,/^(?:CURRENT)/i,/^(?:DATABASE)/i,/^(?:DECIMAL)/i,/^(?:DESC)/i,/^(?:DISTINCT)/i,/^(?:DIV)/i,/^(?:DOUBLE)/i,/^(?:DROP)/i,/^(?:ELSE)/i,/^(?:END)/i,/^(?:EXISTS)/i,/^(?:FALSE)/i,/^(?:FLOAT)/i,/^(?:FOLLOWING)/i,/^(?:FROM)/i,/^(?:FULL)/i,/^(?:GROUP)/i,/^(?:HAVING)/i,/^(?:IF)/i,/^(?:IN)/i,/^(?:INNER)/i,/^(?:INSERT)/i,/^(?:INT)/i,/^(?:INTO)/i,/^(?:IS)/i,/^(?:JOIN)/i,/^(?:LEFT)/i,/^(?:LIKE)/i,/^(?:LIMIT)/i,/^(?:NOT)/i,/^(?:NULL)/i,/^(?:ON)/i,/^(?:OPTION)/i,/^(?:OR)/i,/^(?:ORDER)/i,/^(?:OUTER)/i,/^(?:PARTITION)/i,/^(?:PRECEDING)/i,/^(?:PURGE)/i,/^(?:RANGE)/i,/^(?:REGEXP)/i,/^(?:RIGHT)/i,/^(?:RLIKE)/i,/^(?:ROW)/i,/^(?:ROLE)/i,/^(?:ROWS)/i,/^(?:SCHEMA)/i,/^(?:SELECT)/i,/^(?:SEMI)/i,/^(?:SET)/i,/^(?:SHOW)/i,/^(?:SMALLINT)/i,/^(?:STRING)/i,/^(?:TABLE)/i,/^(?:THEN)/i,/^(?:TIMESTAMP)/i,/^(?:TINYINT)/i,/^(?:TO)/i,/^(?:TRUE)/i,/^(?:TRUNCATE)/i,/^(?:UNBOUNDED)/i,/^(?:UNION)/i,/^(?:UPDATE)/i,/^(?:USE)/i,/^(?:VALUES)/i,/^(?:VARCHAR)/i,/^(?:VIEW)/i,/^(?:WHEN)/i,/^(?:WHERE)/i,/^(?:WITH)/i,/^(?:OVER)/i,/^(?:ROLE)/i,/^(?:AVG\s*\()/i,/^(?:CAST\s*\()/i,/^(?:COUNT\s*\()/i,/^(?:MAX\s*\()/i,/^(?:MIN\s*\()/i,/^(?:STDDEV_POP\s*\()/i,/^(?:STDDEV_SAMP\s*\()/i,/^(?:SUM\s*\()/i,/^(?:VAR_POP\s*\()/i,/^(?:VAR_SAMP\s*\()/i,/^(?:VARIANCE\s*\()/i,/^(?:CUME_DIST\s*\()/i,/^(?:DENSE_RANK\s*\()/i,/^(?:FIRST_VALUE\s*\()/i,/^(?:LAG\s*\()/i,/^(?:LAST_VALUE\s*\()/i,/^(?:LEAD\s*\()/i,/^(?:RANK\s*\()/i,/^(?:ROW_NUMBER\s*\()/i,/^(?:[0-9]+)/i,/^(?:[0-9]+(?:[YSL]|BD)?)/i,/^(?:[0-9]+E)/i,/^(?:[A-Za-z0-9_]+)/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:\s+['"])/i,/^(?:[^'"\u2020\u2021]+)/i,/^(?:['"])/i,/^(?:$)/i,/^(?:&&)/i,/^(?:\|\|)/i,/^(?:=)/i,/^(?:<)/i,/^(?:>)/i,/^(?:!=)/i,/^(?:<=)/i,/^(?:>=)/i,/^(?:<>)/i,/^(?:<=>)/i,/^(?:-)/i,/^(?:\*)/i,/^(?:\+)/i,/^(?:\/)/i,/^(?:%)/i,/^(?:\|)/i,/^(?:\^)/i,/^(?:&)/i,/^(?:,)/i,/^(?:\.)/i,/^(?::)/i,/^(?:;)/i,/^(?:~)/i,/^(?:!)/i,/^(?:\()/i,/^(?:\))/i,/^(?:\[)/i,/^(?:\])/i,/^(?:\$\{[^}]*\})/i,/^(?:`)/i,/^(?:[^`]+)/i,/^(?:`)/i,/^(?:')/i,/^(?:(?:\\\\|\\[']|[^'])+)/i,/^(?:')/i,/^(?:")/i,/^(?:(?:\\\\|\\["]|[^"])+)/i,/^(?:")/i,/^(?:$)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i],
conditions: {"hdfs":{"rules":[116,117,118,119,120,121,163],"inclusive":false},"doubleQuotedValue":{"rules":[158,159,166],"inclusive":false},"singleQuotedValue":{"rules":[155,156,165],"inclusive":false},"backtickedValue":{"rules":[152,153,164],"inclusive":false},"between":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,154,157,160,161,162,167],"inclusive":true},"INITIAL":{"rules":[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,154,157,160,161,167],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
export default phoenixSyntaxParser;
