// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/* parser generated by jison 0.4.17 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
import SqlParseSupport from 'parse/sql/ksql/sqlParseSupport';

var ksqlSyntaxParser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[4,9,15,36,42,149,156,168,172,406,419],$V1=[2,253],$V2=[168,172],$V3=[2,254],$V4=[1,23],$V5=[1,24],$V6=[1,18],$V7=[1,17],$V8=[1,19],$V9=[1,25],$Va=[1,29],$Vb=[1,27],$Vc=[1,28],$Vd=[1,42],$Ve=[1,44],$Vf=[1,43],$Vg=[1,39],$Vh=[1,40],$Vi=[71,168,172],$Vj=[2,990],$Vk=[1,54],$Vl=[1,61],$Vm=[1,62],$Vn=[2,820],$Vo=[1,69],$Vp=[1,70],$Vq=[1,75],$Vr=[40,184],$Vs=[19,23,24,40,50,65,69,71,75,85,97,98,99,102,103,110,115,119,130,132,133,148,168,172,177,178,179,182,183,184,189,190,191,193,194,195,196,199,201,204,205,207,208,209,212,214,215,216,217,220,221,222,223,224,225,226,229,230,231,232,235,236,237,239,241,242,245,247,248,249,251,256,258,259,272,313],$Vt=[71,168,172,251],$Vu=[50,103,168,172,177,178,179],$Vv=[2,410],$Vw=[1,85],$Vx=[50,103,177,178,179,193],$Vy=[50,103,168,172,177,178,179,193,219],$Vz=[2,407],$VA=[1,90],$VB=[1,141],$VC=[1,142],$VD=[1,105],$VE=[1,100],$VF=[1,109],$VG=[1,114],$VH=[1,116],$VI=[1,117],$VJ=[1,101],$VK=[1,98],$VL=[1,103],$VM=[1,139],$VN=[1,102],$VO=[1,127],$VP=[1,145],$VQ=[1,106],$VR=[1,128],$VS=[1,136],$VT=[1,104],$VU=[1,144],$VV=[1,115],$VW=[1,146],$VX=[1,147],$VY=[1,148],$VZ=[1,149],$V_=[1,137],$V$=[1,143],$V01=[1,138],$V11=[1,140],$V21=[1,150],$V31=[1,151],$V41=[1,152],$V51=[23,24,50,69,71,85,86,97,102,103,149,177,178,179,181,182,183,184,187,188,192,193,197,198,200,210,211,219,227,228,243,244,246,250,252,253,254,255,257,406],$V61=[69,75,406],$V71=[71,75,168,172,214,251],$V81=[2,740],$V91=[1,194],$Va1=[1,210],$Vb1=[1,198],$Vc1=[1,195],$Vd1=[1,196],$Ve1=[1,197],$Vf1=[1,209],$Vg1=[1,204],$Vh1=[1,203],$Vi1=[1,202],$Vj1=[1,205],$Vk1=[1,200],$Vl1=[1,199],$Vm1=[1,193],$Vn1=[1,201],$Vo1=[1,212],$Vp1=[1,211],$Vq1=[23,24,40,50,65,71,75,85,98,99,103,119,132,133,168,172,177,178,179,182,183,189,190,191,193,194,201,205,208,209,214,215,216,217,220,221,223,224,225,226,230,231,232,235,236,237,239,241,247,251,258,259,313],$Vr1=[1,218],$Vs1=[1,224],$Vt1=[1,226],$Vu1=[23,24,40,50,65,69,71,75,85,98,99,103,119,132,133,168,172,177,178,179,182,183,189,190,191,193,194,201,205,208,209,214,215,216,217,220,221,223,224,225,226,230,231,232,235,236,237,239,241,247,251,258,259,313],$Vv1=[1,231],$Vw1=[19,23,24,40,50,65,69,71,75,85,98,99,103,119,132,133,168,172,177,178,179,182,183,184,189,190,191,193,194,201,205,208,209,214,215,216,217,220,221,223,224,225,226,230,231,232,235,236,237,239,241,247,251,258,259,313],$Vx1=[23,24,40,50,65,71,75,85,98,99,103,119,132,133,168,172,177,178,179,182,183,189,190,191,193,194,201,205,208,209,214,215,216,217,220,221,223,224,225,226,230,231,232,233,235,236,237,239,241,247,251,258,259,313],$Vy1=[19,71,75,85,86,99,133,168,172,201,214,215,216,217,221,224,225,226,229,231,232,236,241,251,259],$Vz1=[2,13],$VA1=[1,258],$VB1=[133,168,172],$VC1=[115,133,168,172],$VD1=[19,65,69,115,133,168,172],$VE1=[19,133],$VF1=[23,24,50,71,75,103,115,130,133,148,168,172,177,178,179,193,201,215,216,217,221,224,225,226,229,231,232,236,241,251,259],$VG1=[71,168,172,216,217,226,231,251],$VH1=[86,206,211,250],$VI1=[71,75,168,172,201,214,215,216,217,221,224,225,226,229,231,232,236,241,251,259],$VJ1=[23,24,50,71,75,85,103,119,133,168,172,177,178,179,189,191,193,194,201,205,208,209,214,215,216,217,221,224,225,226,230,231,232,236,239,241,247,251,258,259,313],$VK1=[23,24,40,50,71,75,85,98,99,103,119,132,133,168,172,177,178,179,182,183,189,190,191,193,194,201,205,208,209,214,215,216,217,221,224,225,226,230,231,232,236,239,241,247,251,258,259,313],$VL1=[406,419],$VM1=[2,718],$VN1=[208,209,258],$VO1=[23,24,50,69,85,86,97,102,103,149,177,178,179,181,183,184,187,188,192,193,197,198,200,210,211,219,227,228,243,244,246,250,252,253,254,255,257],$VP1=[19,23,24,40,50,65,71,75,85,86,98,99,103,119,132,133,168,172,177,178,179,182,183,189,190,191,193,194,201,205,208,209,214,215,216,217,220,221,223,224,225,226,229,230,231,232,235,236,237,239,241,247,251,258,259,313],$VQ1=[71,168,172,217,226,231,251],$VR1=[71,75,168,172,216,217,226,231,251,259],$VS1=[1,367],$VT1=[1,368],$VU1=[1,369],$VV1=[1,370],$VW1=[1,371],$VX1=[1,372],$VY1=[1,373],$VZ1=[1,374],$V_1=[71,75,168,172,201,215,216,217,221,224,225,226,229,231,232,236,241,251,259],$V$1=[23,24,50,71,75,103,133,168,172,177,178,179,193,201,215,216,217,221,224,225,226,229,231,232,236,241,251,259],$V02=[23,24,40,50,71,75,85,98,99,103,119,132,133,168,172,177,178,179,189,191,193,194,201,205,208,209,214,215,216,217,221,224,225,226,230,231,232,236,239,241,247,251,258,259,313],$V12=[23,24,50,71,75,103,119,133,168,172,177,178,179,189,191,193,201,205,208,209,214,215,216,217,221,224,225,226,230,231,232,236,239,241,247,251,258,259,313],$V22=[1,400],$V32=[71,75],$V42=[71,231],$V52=[1,415],$V62=[1,441],$V72=[1,442],$V82=[1,443],$V92=[1,429],$Va2=[1,430],$Vb2=[1,431],$Vc2=[1,432],$Vd2=[1,433],$Ve2=[1,434],$Vf2=[1,435],$Vg2=[1,436],$Vh2=[1,437],$Vi2=[1,438],$Vj2=[1,439],$Vk2=[1,440],$Vl2=[19,71,75],$Vm2=[71,168,172,226,231,251],$Vn2=[50,69,103,177,178,179,193],$Vo2=[1,476],$Vp2=[71,75,231],$Vq2=[23,24,40,50,65,71,75,85,98,99,103,119,132,133,168,172,177,178,179,182,183,189,190,191,193,194,201,205,208,209,214,215,216,217,220,221,223,224,225,226,229,230,231,232,235,236,237,239,241,247,251,258,259,313],$Vr2=[1,484],$Vs2=[75,168,172],$Vt2=[1,500],$Vu2=[1,501],$Vv2=[19,71,75,85,86,99],$Vw2=[2,519],$Vx2=[1,504],$Vy2=[71,168,172,226,251],$Vz2=[71,75,168,172,201,215,216,217,221,224,225,226,231,232,236,241,251,259],$VA2=[2,948],$VB2=[1,521],$VC2=[19,71,75,85,86],$VD2=[71,75,168,172,217,226,231,251],$VE2=[194,392],$VF2=[1,577],$VG2=[75,99],$VH2=[71,189,202,252,392],$VI2=[2,776],$VJ2=[71,75,119,168,172,226,239,251],$VK2=[71,189],$VL2=[2,786],$VM2=[1,610],$VN2=[1,611],$VO2=[1,612],$VP2=[1,620],$VQ2=[1,621],$VR2=[2,791],$VS2=[1,628],$VT2=[213,234],$VU2=[2,176],$VV2=[2,177];
var parser = {trace: function trace () { },
yy: {},
symbols_: {"error":2,"DataDefinition_EDIT":3,"CREATE":4,"CURSOR":5,"DatabaseDefinition_EDIT":6,"TableDefinition_EDIT":7,"ViewDefinition_EDIT":8,"DROP":9,"DropDatabaseStatement_EDIT":10,"DropTableStatement_EDIT":11,"DropViewStatement_EDIT":12,"TruncateTableStatement_EDIT":13,"ListStatement_EDIT":14,"SET":15,"ShowStatement_EDIT":16,"OptionalComment":17,"Comment":18,"COMMENT":19,"QuotedValue":20,"OptionalComment_INVALID":21,"Comment_INVALID":22,"SINGLE_QUOTE":23,"DOUBLE_QUOTE":24,"VALUE":25,"DataDefinition":26,"DatabaseDefinition":27,"RoleDefinition":28,"TableDefinition":29,"ViewDefinition":30,"DropDatabaseStatement":31,"DropRoleStatement":32,"DropTableStatement":33,"DropViewStatement":34,"TruncateTableStatement":35,"LIST":36,"ListStatement":37,"ALL":38,"SetOption":39,"=":40,"SetValue":41,"SHOW":42,"ShowStatement":43,"DatabaseOrSchema":44,"OptionalIfNotExists":45,"RegularIdentifier":46,"DatabaseDefinitionOptionals":47,"OptionalIfNotExists_EDIT":48,"DatabaseDefinitionOptionals_EDIT":49,"ROLE":50,"TABLE":51,"TableDefinitionRightPart":52,"TableDefinitionRightPart_EDIT":53,"TableIdentifierAndOptionalColumnSpecification":54,"OptionalPartitionedBy":55,"OptionalAsSelectStatement":56,"TableIdentifierAndOptionalColumnSpecification_EDIT":57,"PartitionedBy_EDIT":58,"OptionalAsSelectStatement_EDIT":59,"SchemaQualifiedIdentifier":60,"OptionalColumnSpecificationsOrLike":61,"OptionalColumnSpecificationsOrLike_EDIT":62,"SchemaQualifiedIdentifier_EDIT":63,"ParenthesizedColumnSpecificationList":64,"LIKE":65,"SchemaQualifiedTableIdentifier":66,"ParenthesizedColumnSpecificationList_EDIT":67,"SchemaQualifiedTableIdentifier_EDIT":68,"(":69,"ColumnSpecificationList":70,")":71,"ColumnSpecificationList_EDIT":72,"RightParenthesisOrError":73,"ColumnSpecification":74,",":75,"ColumnSpecification_EDIT":76,"ColumnIdentifier":77,"ColumnDataType":78,"OptionalColumnOptions":79,"ColumnDataType_EDIT":80,"ColumnOptions_EDIT":81,"ColumnOptions":82,"ColumnOption":83,"ColumnOption_EDIT":84,"NOT":85,"NULL":86,"PrimitiveType":87,"ArrayType":88,"MapType":89,"StructType":90,"ArrayType_INVALID":91,"MapType_INVALID":92,"StructType_INVALID":93,"ArrayType_EDIT":94,"MapType_EDIT":95,"StructType_EDIT":96,"ARRAY":97,"<":98,">":99,"AnyCursor":100,"GreaterThanOrError":101,"MAP":102,"STRUCT":103,"StructDefinitionList":104,"StructDefinitionList_EDIT":105,"StructDefinition":106,"StructDefinition_EDIT":107,"Commas":108,"RegularOrBacktickedIdentifier":109,":":110,"ColumnDataTypeList":111,"ColumnDataTypeList_EDIT":112,"ColumnDataTypeListInner_EDIT":113,"PartitionedBy":114,"PARTITION":115,"BY":116,"RangeClause":117,"RangeClause_EDIT":118,"RANGE":119,"ParenthesizedColumnList":120,"ParenthesizedPartitionValuesList":121,"ParenthesizedColumnList_EDIT":122,"ParenthesizedPartitionValuesList_EDIT":123,"PartitionValueList":124,"PartitionValueList_EDIT":125,"PartitionValue":126,"PartitionValue_EDIT":127,"ValueExpression":128,"LessThanOrEqualTo":129,"VALUES":130,"ValueExpression_EDIT":131,"COMPARISON_OPERATOR":132,"AS":133,"CommitLocations":134,"QuerySpecification":135,"QuerySpecification_EDIT":136,"VIEW":137,"OptionalParenthesizedViewColumnList":138,"ParenthesizedViewColumnList_EDIT":139,"ParenthesizedViewColumnList":140,"ViewColumnList":141,"ViewColumnList_EDIT":142,"ColumnReference":143,"OptionalIfExists":144,"OptionalCascade":145,"OptionalIfExists_EDIT":146,"OptionalPurge":147,"PURGE":148,"TRUNCATE":149,"OptionalPartitionSpec":150,"DataManipulation":151,"InsertStatement":152,"InsertValuesStatement":153,"DataManipulation_EDIT":154,"InsertValuesStatement_EDIT":155,"INSERT":156,"INTO":157,"OptionalTable":158,"InsertValuesList":159,"ParenthesizedRowValuesList":160,"InValueList":161,"TABLES":162,"STREAMS":163,"TOPICS":164,"SqlSyntax":165,"NewStatement":166,"SqlStatements":167,"EOF":168,"SqlAutocomplete":169,"SqlStatements_EDIT":170,"SqlStatement":171,";":172,"SqlStatement_EDIT":173,"CommonTableExpression":174,"SetSpecification_EDIT":175,"NonReservedKeyword":176,"OPTION":177,"REGULAR_IDENTIFIER":178,"VARIABLE_REFERENCE":179,"NonStartingToken":180,"!":181,"*":182,"-":183,".":184,"[":185,"]":186,"~":187,"ANALYTIC":188,"AND":189,"ARITHMETIC_OPERATOR":190,"ASC":191,"AVG":192,"BACKTICK":193,"BETWEEN":194,"BIGINT":195,"BOOLEAN":196,"CASE":197,"CAST":198,"CHAR":199,"COUNT":200,"CROSS":201,"CURRENT":202,"DATABASE":203,"DECIMAL":204,"DESC":205,"DISTINCT":206,"DOUBLE":207,"ELSE":208,"END":209,"EXISTS":210,"FALSE":211,"FLOAT":212,"FOLLOWING":213,"FROM":214,"FULL":215,"GROUP":216,"HAVING":217,"HDFS_START_QUOTE":218,"IF":219,"IN":220,"INNER":221,"INT":222,"IS":223,"JOIN":224,"LEFT":225,"LIMIT":226,"MAX":227,"MIN":228,"ON":229,"OR":230,"ORDER":231,"OUTER":232,"OVER":233,"PRECEDING":234,"REGEXP":235,"RIGHT":236,"RLIKE":237,"ROW":238,"ROWS":239,"SCHEMA":240,"SEMI":241,"SMALLINT":242,"STDDEV_POP":243,"STDDEV_SAMP":244,"STRING":245,"SUM":246,"THEN":247,"TIMESTAMP":248,"TINYINT":249,"TRUE":250,"UNION":251,"UNSIGNED_INTEGER":252,"UNSIGNED_INTEGER_E":253,"VAR_POP":254,"VAR_SAMP":255,"VARCHAR":256,"VARIANCE":257,"WHEN":258,"WHERE":259,"PARTIAL_CURSOR":260,"FromOrIn":261,"SingleQuotedValue":262,"SingleQuotedValue_EDIT":263,"PARTIAL_VALUE":264,"DoubleQuotedValue":265,"DoubleQuotedValue_EDIT":266,"QuotedValue_EDIT":267,"OptionalFromDatabase":268,"DatabaseIdentifier":269,"OptionalFromDatabase_EDIT":270,"DatabaseIdentifier_EDIT":271,"CASCADE":272,"OptionalInDatabase":273,"PartitionSpec":274,"OptionalPartitionSpec_EDIT":275,"PartitionSpec_EDIT":276,"PartitionSpecList":277,"PartitionSpecList_EDIT":278,"RangePartitionSpec":279,"UnsignedValueSpecification":280,"RangePartitionComparisonOperator":281,"RangePartitionSpec_EDIT":282,"ConfigurationName":283,"PartialBacktickedOrAnyCursor":284,"PartialBacktickedIdentifier":285,"PartialBacktickedOrCursor":286,"PartialBacktickedOrPartialCursor":287,"OptionalParenthesizedColumnList":288,"OptionalParenthesizedColumnList_EDIT":289,"ColumnList":290,"ColumnList_EDIT":291,"ParenthesizedSimpleValueList":292,"SimpleValueList":293,"PartitionExpression":294,"PartitionExpression_EDIT":295,"RegularOrBackTickedSchemaQualifiedName":296,"RegularOrBackTickedSchemaQualifiedName_EDIT":297,"LocalOrSchemaQualifiedName":298,"LocalOrSchemaQualifiedName_EDIT":299,"BasicIdentifierChain":300,"ColumnReference_EDIT":301,"BasicIdentifierChain_EDIT":302,"DerivedColumnChain":303,"DerivedColumnChain_EDIT":304,"PartialBacktickedIdentifierOrPartialCursor":305,"OptionalTypeLength":306,"OptionalTypePrecision":307,"NonParenthesizedValueExpressionPrimary":308,"OptionalNot":309,"TableSubQuery":310,"TableSubQueryInner":311,"ValueExpressionList":312,"BETWEEN_AND":313,"LikeRightPart":314,"CaseRightPart":315,"NonParenthesizedValueExpressionPrimary_EDIT":316,"TableSubQuery_EDIT":317,"ValueExpressionInSecondPart_EDIT":318,"LikeRightPart_EDIT":319,"CaseRightPart_EDIT":320,"EndOrError":321,"ValueExpressionList_EDIT":322,"ColumnOrArbitraryFunctionRef":323,"ArbitraryFunctionRightPart":324,"ArbitraryFunctionName":325,"UserDefinedFunction":326,"UnsignedValueSpecification_EDIT":327,"ColumnOrArbitraryFunctionRef_EDIT":328,"ArbitraryFunctionRightPart_EDIT":329,"UserDefinedFunction_EDIT":330,"SignedInteger":331,"UnsignedNumericLiteral":332,"+":333,"UnsignedLiteral":334,"UnsignedLiteral_EDIT":335,"GeneralLiteral":336,"GeneralLiteral_EDIT":337,"ExactNumericLiteral":338,"ApproximateNumericLiteral":339,"TruthValue":340,"TableReference":341,"TablePrimaryOrJoinedTable":342,"TableReference_EDIT":343,"TablePrimaryOrJoinedTable_EDIT":344,"TablePrimary":345,"JoinedTable":346,"TablePrimary_EDIT":347,"JoinedTable_EDIT":348,"Joins":349,"Joins_EDIT":350,"TableOrQueryName":351,"OptionalCorrelationName":352,"DerivedTable":353,"TableOrQueryName_EDIT":354,"DerivedTable_EDIT":355,"OptionalCorrelationName_EDIT":356,"OptionalOnColumn":357,"OptionalOnColumn_EDIT":358,"PushQueryState":359,"PopQueryState":360,"TableSubQueryInner_EDIT":361,"SubQuery":362,"SubQuery_EDIT":363,"QueryExpression":364,"QueryExpression_EDIT":365,"QueryExpressionBody":366,"QueryExpressionBody_EDIT":367,"NonJoinQueryExpression":368,"NonJoinQueryExpression_EDIT":369,"NonJoinQueryTerm":370,"NonJoinQueryTerm_EDIT":371,"NonJoinQueryPrimary":372,"NonJoinQueryPrimary_EDIT":373,"SimpleTable":374,"SimpleTable_EDIT":375,"WindowExpression":376,"OptionalPartitionBy":377,"OptionalOrderByAndWindow":378,"WindowExpression_EDIT":379,"PartitionBy_EDIT":380,"OptionalOrderByAndWindow_EDIT":381,"PartitionBy":382,"OrderByClause":383,"OptionalWindowSpec":384,"OrderByClause_EDIT":385,"WindowSpec_EDIT":386,"WindowSpec":387,"RowsOrRange":388,"PopLexerState":389,"OptionalCurrentOrPreceding":390,"OptionalAndFollowing":391,"UNBOUNDED":392,"OptionalCurrentOrPreceding_EDIT":393,"OptionalAndFollowing_EDIT":394,"PushHdfsLexerState":395,"HdfsPath":396,"HDFS_PATH":397,"HDFS_END_QUOTE":398,"HdfsPath_EDIT":399,"IntegerOrUnbounded":400,"SelectStatement":401,"OptionalUnions":402,"SelectStatement_EDIT":403,"OptionalUnions_EDIT":404,"CommonTableExpression_EDIT":405,"SELECT":406,"OptionalAllOrDistinct":407,"SelectList":408,"TableExpression":409,"SelectList_EDIT":410,"TableExpression_EDIT":411,"FromClause":412,"OptionalSelectConditions":413,"FromClause_EDIT":414,"OptionalJoins":415,"OptionalSelectConditions_EDIT":416,"SelectSpecification":417,"SelectSpecification_EDIT":418,"WITH":419,"WithQueries":420,"WithQueries_EDIT":421,"WithQuery":422,"WithQuery_EDIT":423,"TableReferenceList":424,"TableReferenceList_EDIT":425,"OptionalGroupByClause":426,"GroupByClause":427,"GroupByColumnList":428,"GroupByClause_EDIT":429,"GroupByColumnList_EDIT":430,"ColumnGroupingSets":431,"ColumnGroupingSets_EDIT":432,"ColumnGroupingSet_EDIT":433,"GroupByColumnListPartTwo_EDIT":434,"OptionalHavingClause":435,"HavingClause":436,"HavingClause_EDIT":437,"Joins_INVALID":438,"JoinType":439,"OptionalJoinCondition":440,"Join_EDIT":441,"JoinType_EDIT":442,"JoinCondition_EDIT":443,"UsingColList":444,"OptionalLimitClause":445,"LimitClause":446,"LimitClause_EDIT":447,"OptionalOrderByClause":448,"OrderByColumnList":449,"OrderByColumnList_EDIT":450,"OrderByIdentifier":451,"OrderByIdentifier_EDIT":452,"OptionalAscOrDesc":453,"OptionalWhereClause":454,"WhereClause_EDIT":455,"WhereClause":456,"Unions":457,"Unions_EDIT":458,"UnionClause":459,"UnionClause_EDIT":460,"SearchCondition":461,"SearchCondition_EDIT":462,"AggregateFunction":463,"OptionalOverClause":464,"AnalyticFunction":465,"OverClause":466,"CastFunction":467,"AggregateFunction_EDIT":468,"OptionalOverClause_EDIT":469,"AnalyticFunction_EDIT":470,"OverClause_EDIT":471,"CastFunction_EDIT":472,"OtherAggregateFunction":473,"CountFunction":474,"SumFunction":475,"OtherAggregateFunction_EDIT":476,"CountFunction_EDIT":477,"SumFunction_EDIT":478,"OtherAggregateFunction_Type":479,"UdfArgumentList":480,"UdfArgumentList_EDIT":481,"ArbitraryFunction":482,"ArbitraryFunction_EDIT":483,"QUERIES":484,"PROPERTIES":485,"CaseWhenThenList":486,"CaseWhenThenList_EDIT":487,"CaseWhenThenListPartTwo":488,"CaseWhenThenListPartTwo_EDIT":489,"$accept":0,"$end":1},
terminals_: {2:"error",4:"CREATE",5:"CURSOR",9:"DROP",15:"SET",19:"COMMENT",23:"SINGLE_QUOTE",24:"DOUBLE_QUOTE",25:"VALUE",36:"LIST",38:"ALL",40:"=",42:"SHOW",50:"ROLE",51:"TABLE",65:"LIKE",69:"(",71:")",75:",",85:"NOT",86:"NULL",97:"ARRAY",98:"<",99:">",102:"MAP",103:"STRUCT",110:":",115:"PARTITION",116:"BY",119:"RANGE",130:"VALUES",132:"COMPARISON_OPERATOR",133:"AS",137:"VIEW",148:"PURGE",149:"TRUNCATE",156:"INSERT",157:"INTO",162:"TABLES",163:"STREAMS",164:"TOPICS",168:"EOF",172:";",175:"SetSpecification_EDIT",177:"OPTION",178:"REGULAR_IDENTIFIER",179:"VARIABLE_REFERENCE",181:"!",182:"*",183:"-",184:".",185:"[",186:"]",187:"~",188:"ANALYTIC",189:"AND",190:"ARITHMETIC_OPERATOR",191:"ASC",192:"AVG",193:"BACKTICK",194:"BETWEEN",195:"BIGINT",196:"BOOLEAN",197:"CASE",198:"CAST",199:"CHAR",200:"COUNT",201:"CROSS",202:"CURRENT",203:"DATABASE",204:"DECIMAL",205:"DESC",206:"DISTINCT",207:"DOUBLE",208:"ELSE",209:"END",210:"EXISTS",211:"FALSE",212:"FLOAT",213:"FOLLOWING",214:"FROM",215:"FULL",216:"GROUP",217:"HAVING",218:"HDFS_START_QUOTE",219:"IF",220:"IN",221:"INNER",222:"INT",223:"IS",224:"JOIN",225:"LEFT",226:"LIMIT",227:"MAX",228:"MIN",229:"ON",230:"OR",231:"ORDER",232:"OUTER",233:"OVER",234:"PRECEDING",235:"REGEXP",236:"RIGHT",237:"RLIKE",238:"ROW",239:"ROWS",240:"SCHEMA",241:"SEMI",242:"SMALLINT",243:"STDDEV_POP",244:"STDDEV_SAMP",245:"STRING",246:"SUM",247:"THEN",248:"TIMESTAMP",249:"TINYINT",250:"TRUE",251:"UNION",252:"UNSIGNED_INTEGER",253:"UNSIGNED_INTEGER_E",254:"VAR_POP",255:"VAR_SAMP",256:"VARCHAR",257:"VARIANCE",258:"WHEN",259:"WHERE",260:"PARTIAL_CURSOR",264:"PARTIAL_VALUE",272:"CASCADE",313:"BETWEEN_AND",333:"+",392:"UNBOUNDED",397:"HDFS_PATH",398:"HDFS_END_QUOTE",406:"SELECT",419:"WITH",484:"QUERIES",485:"PROPERTIES"},
productions_: [0,[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,1],[3,1],[3,2],[3,1],[17,0],[17,1],[18,2],[21,1],[22,2],[22,2],[22,3],[22,3],[26,1],[26,1],[26,1],[26,1],[26,1],[26,1],[26,1],[26,1],[26,1],[26,2],[26,2],[26,4],[26,2],[27,3],[27,5],[6,4],[6,3],[6,5],[6,4],[6,6],[47,1],[49,1],[28,3],[29,4],[7,4],[7,4],[7,3],[52,3],[53,3],[53,3],[53,3],[53,3],[54,2],[57,2],[57,2],[61,0],[61,1],[61,2],[62,1],[62,2],[62,2],[64,3],[67,3],[70,1],[70,3],[72,1],[72,3],[72,3],[72,5],[72,2],[72,4],[72,4],[72,6],[74,3],[76,3],[76,3],[76,3],[79,0],[79,1],[82,1],[82,2],[81,1],[81,2],[81,2],[81,3],[83,2],[83,1],[83,1],[84,2],[78,1],[78,1],[78,1],[78,1],[78,1],[78,1],[78,1],[80,1],[80,1],[80,1],[88,4],[91,3],[94,4],[94,4],[89,6],[92,3],[95,6],[95,4],[95,6],[95,5],[90,4],[93,3],[96,4],[104,1],[104,3],[105,1],[105,2],[105,3],[105,3],[105,5],[106,4],[107,5],[107,4],[107,4],[107,4],[107,3],[107,3],[111,1],[111,3],[112,1],[112,2],[112,3],[112,3],[112,5],[113,2],[113,2],[113,1],[113,1],[101,1],[101,1],[55,0],[55,1],[114,3],[58,2],[58,3],[58,3],[117,3],[118,2],[118,2],[118,3],[118,3],[118,3],[121,3],[123,3],[123,3],[124,1],[124,3],[125,1],[125,3],[125,5],[125,3],[125,5],[126,6],[126,4],[126,4],[127,2],[127,2],[127,3],[127,4],[127,4],[127,5],[127,6],[127,6],[127,3],[127,4],[127,4],[129,1],[129,1],[56,0],[56,3],[59,3],[59,3],[134,0],[30,8],[8,4],[8,9],[8,3],[8,6],[8,7],[8,8],[8,8],[8,8],[138,0],[138,1],[140,3],[139,3],[141,2],[141,4],[142,3],[142,5],[142,5],[142,7],[31,5],[10,3],[10,3],[10,4],[10,5],[10,5],[10,6],[32,3],[33,5],[11,3],[11,4],[11,5],[11,5],[11,6],[147,0],[147,1],[34,4],[12,4],[12,5],[12,3],[12,4],[12,4],[35,4],[13,2],[13,4],[13,3],[13,4],[13,5],[13,5],[13,5],[151,1],[152,1],[154,1],[153,6],[155,2],[155,4],[155,4],[155,5],[155,6],[159,1],[159,3],[160,3],[158,0],[158,1],[37,1],[37,1],[37,1],[14,2],[165,3],[169,3],[169,3],[166,0],[167,0],[167,1],[167,4],[170,1],[170,4],[170,4],[170,7],[171,1],[171,1],[171,1],[173,1],[173,2],[173,1],[173,1],[173,1],[173,1],[176,1],[176,1],[176,1],[46,1],[46,1],[46,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[180,1],[108,1],[108,2],[100,1],[100,1],[261,1],[261,1],[44,1],[44,1],[262,3],[262,2],[263,2],[265,3],[265,2],[266,2],[20,1],[20,1],[267,1],[267,1],[268,0],[268,2],[270,2],[145,0],[145,1],[144,0],[144,2],[146,2],[45,0],[45,3],[48,2],[48,3],[273,0],[273,2],[273,2],[150,0],[150,1],[275,1],[274,4],[276,4],[279,5],[282,2],[282,3],[282,4],[282,5],[282,5],[282,5],[281,1],[281,1],[281,1],[281,1],[283,1],[283,1],[284,1],[284,1],[286,1],[286,1],[287,1],[287,1],[285,2],[73,1],[73,1],[288,0],[288,1],[289,1],[120,3],[122,3],[122,3],[290,1],[290,3],[291,3],[291,5],[292,3],[293,1],[293,3],[66,1],[66,3],[68,1],[68,3],[68,3],[60,1],[60,3],[63,1],[63,3],[63,3],[269,1],[271,1],[277,1],[277,3],[278,1],[278,3],[278,3],[278,5],[294,3],[295,3],[295,3],[295,3],[295,1],[109,1],[109,3],[109,2],[296,1],[296,3],[297,1],[297,3],[298,1],[298,2],[299,1],[299,2],[143,1],[143,3],[301,1],[300,1],[300,3],[302,3],[302,5],[303,1],[303,3],[304,1],[304,3],[304,5],[304,3],[77,1],[305,1],[305,1],[87,1],[87,1],[87,2],[87,2],[87,1],[87,1],[87,1],[87,1],[87,1],[87,1],[87,1],[87,2],[306,0],[306,3],[307,0],[307,3],[307,5],[128,1],[128,2],[128,2],[128,2],[128,2],[128,4],[128,4],[128,4],[128,6],[128,2],[128,3],[128,3],[128,3],[128,3],[128,3],[128,6],[128,6],[128,5],[128,5],[128,6],[128,5],[128,3],[128,3],[128,3],[128,3],[128,3],[128,2],[128,3],[128,2],[128,3],[131,1],[131,3],[131,2],[131,2],[131,2],[131,2],[131,2],[131,2],[131,2],[131,2],[131,3],[131,4],[131,5],[131,4],[131,4],[131,4],[131,6],[131,6],[131,2],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,4],[131,3],[131,6],[131,6],[131,5],[131,5],[131,6],[131,6],[131,6],[131,6],[131,5],[131,4],[131,5],[131,5],[131,5],[131,5],[131,4],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,3],[131,2],[131,3],[131,2],[131,3],[131,2],[131,3],[131,2],[131,3],[131,3],[131,4],[131,3],[131,3],[131,3],[312,1],[312,3],[322,1],[322,3],[322,3],[322,5],[322,3],[322,5],[322,4],[322,3],[322,2],[322,2],[322,4],[161,1],[161,3],[308,1],[308,1],[308,1],[308,2],[308,2],[308,1],[316,1],[316,1],[316,2],[316,2],[316,1],[323,1],[323,3],[328,1],[331,1],[331,2],[331,2],[280,1],[327,1],[334,1],[334,1],[335,1],[332,1],[332,1],[338,1],[338,2],[338,3],[338,2],[339,2],[339,3],[339,4],[336,1],[336,1],[336,1],[337,1],[337,1],[340,1],[340,1],[309,0],[309,1],[341,1],[343,1],[342,1],[342,1],[344,1],[344,1],[346,2],[348,2],[348,2],[345,2],[345,2],[347,2],[347,2],[347,2],[351,1],[354,1],[353,1],[355,1],[357,0],[357,2],[358,2],[358,2],[359,0],[360,0],[310,3],[310,4],[317,3],[317,3],[311,2],[361,3],[362,1],[363,1],[364,1],[365,1],[366,1],[367,1],[368,1],[369,1],[370,1],[371,1],[372,1],[373,1],[374,1],[375,1],[352,0],[352,1],[352,1],[352,2],[352,2],[356,1],[356,1],[356,2],[356,2],[356,2],[376,4],[379,4],[379,4],[379,5],[379,7],[377,0],[377,1],[382,3],[380,2],[380,3],[380,3],[378,0],[378,2],[381,1],[381,3],[381,2],[384,0],[384,1],[387,5],[387,5],[386,2],[386,6],[386,5],[386,5],[386,5],[386,4],[389,0],[395,0],[396,3],[399,5],[399,4],[399,3],[399,3],[399,2],[388,1],[388,1],[390,0],[390,2],[390,2],[393,2],[393,2],[391,0],[391,3],[391,3],[394,2],[394,3],[394,3],[400,1],[400,1],[135,2],[135,3],[135,5],[136,2],[136,2],[136,4],[136,3],[136,3],[136,1],[136,4],[136,3],[401,3],[401,4],[403,3],[403,3],[403,4],[403,4],[403,4],[403,5],[403,6],[403,4],[407,0],[407,1],[407,1],[409,2],[411,2],[411,4],[411,3],[408,1],[408,3],[410,1],[410,2],[410,3],[410,3],[410,3],[410,4],[410,3],[410,3],[410,4],[410,4],[410,4],[410,5],[410,5],[417,2],[417,1],[418,2],[418,3],[418,2],[174,2],[405,2],[420,1],[420,3],[421,1],[421,3],[421,3],[421,5],[422,5],[423,2],[423,5],[423,5],[412,2],[414,2],[414,2],[424,1],[424,3],[425,1],[425,3],[425,3],[425,5],[425,3],[426,0],[426,1],[427,3],[429,3],[429,3],[429,2],[431,0],[431,1],[431,3],[431,3],[432,1],[432,3],[432,3],[432,5],[432,3],[433,1],[433,1],[428,1],[428,3],[430,1],[430,2],[430,3],[430,3],[430,3],[430,4],[430,5],[434,1],[434,2],[434,1],[435,0],[435,1],[436,2],[437,2],[437,2],[415,0],[415,1],[415,1],[349,3],[349,4],[438,1],[438,2],[441,3],[441,1],[441,3],[441,3],[441,3],[350,1],[350,2],[350,2],[350,3],[439,2],[439,2],[439,3],[439,2],[439,1],[439,3],[439,2],[439,3],[439,3],[439,2],[439,3],[439,2],[439,3],[439,3],[439,2],[442,2],[442,3],[442,3],[442,2],[442,3],[442,3],[442,3],[442,3],[442,2],[442,3],[442,3],[442,3],[442,3],[442,2],[440,0],[440,2],[444,1],[444,3],[443,2],[443,2],[445,0],[445,1],[446,2],[446,4],[446,2],[446,4],[447,2],[448,0],[448,1],[383,3],[385,3],[385,2],[449,1],[449,3],[450,1],[450,2],[450,3],[450,4],[450,5],[451,2],[452,2],[452,2],[453,0],[453,1],[453,1],[413,5],[416,5],[416,5],[416,5],[416,5],[416,5],[416,6],[416,6],[416,6],[416,6],[416,6],[402,0],[402,1],[404,1],[457,1],[457,2],[458,1],[458,2],[458,2],[458,3],[459,4],[460,3],[460,4],[460,4],[454,0],[454,1],[456,2],[455,2],[455,2],[461,1],[462,1],[39,1],[39,3],[41,1],[41,1],[41,2],[41,1],[41,1],[41,1],[41,1],[326,2],[326,2],[326,1],[330,1],[330,2],[330,1],[330,2],[330,2],[330,2],[330,1],[463,1],[463,1],[463,1],[468,1],[468,1],[468,1],[473,4],[473,5],[476,5],[476,6],[476,5],[479,1],[479,1],[479,1],[479,1],[479,1],[479,1],[479,1],[479,1],[474,4],[474,3],[474,5],[477,5],[477,6],[477,5],[475,5],[475,3],[478,5],[478,6],[478,5],[465,3],[465,4],[470,4],[470,5],[470,4],[325,1],[325,1],[325,1],[325,1],[467,6],[467,3],[472,6],[472,5],[472,4],[472,6],[472,5],[472,4],[472,6],[472,5],[472,6],[472,5],[482,2],[482,2],[483,2],[483,2],[324,2],[324,3],[329,3],[329,4],[329,3],[480,1],[480,3],[481,1],[481,3],[481,3],[481,5],[481,3],[481,5],[481,4],[481,3],[481,2],[481,2],[481,4],[464,0],[464,1],[469,1],[466,2],[466,2],[471,2],[43,1],[43,1],[43,1],[43,1],[43,1],[16,2],[318,3],[318,3],[318,3],[314,2],[314,2],[314,2],[319,2],[319,2],[319,2],[319,2],[319,2],[319,2],[315,2],[315,4],[320,2],[320,4],[320,4],[320,3],[320,4],[320,3],[320,4],[320,4],[320,3],[320,4],[320,3],[321,1],[321,1],[486,1],[486,2],[487,1],[487,2],[487,3],[487,3],[487,2],[488,4],[489,2],[489,3],[489,4],[489,4],[489,3],[489,3],[489,4],[489,2],[489,3],[489,2],[489,3],[489,3],[489,4],[489,3],[489,4],[489,4],[489,5],[489,4],[489,3]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1: case 5:

     parser.suggestKeywords(['DATABASE', 'ROLE', 'SCHEMA', 'TABLE', 'VIEW']);
   
break;
case 11:

     parser.suggestSetOptions();
   
break;
case 35:

     parser.addNewDatabaseLocation(_$[$0-1], [{ name: $$[$0-1] }]);
   
break;
case 36: case 46:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 38:

     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 39:

     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 40:

     parser.addNewDatabaseLocation(_$[$0-2], [{ name: $$[$0-2] }]);
   
break;
case 41:

     if (!$$[$0]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 52:

     var keywords = [];
     if (!$$[$0-2] && !$$[$0-1]) {
       keywords.push({ value: 'LIKE', weight: 1 });
     } else {
       if (!$$[$0-1]) {
         keywords.push({ value: 'PARTITIONED BY', weight: 12 });
       }
       keywords.push({ value: 'AS', weight: 1 });
     }

     if (keywords.length > 0) {
       parser.suggestKeywords(keywords);
     }
   
break;
case 53:

     parser.addNewTableLocation(_$[$0-1], $$[$0-1], $$[$0]);
     this.$ = $$[$0];
   
break;
case 58:
this.$ = [];
break;
case 60: case 459:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 62: case 198: case 200: case 392: case 395: case 481: case 534: case 720: case 799: case 839: case 1085: case 1088:
this.$ = $$[$0-1];
break;
case 64: case 849:
this.$ = [$$[$0]];
break;
case 65:
this.$ = $$[$0-2].concat($$[$0]);
break;
case 70: case 72:

     parser.checkForKeywords($$[$0-1]);
   
break;
case 71: case 73:

     parser.checkForKeywords($$[$0-3]);
   
break;
case 74:

     this.$ = $$[$0-2];
     this.$.type = $$[$0-1];
     var keywords = [];
     if (!$$[$0]['comment']) {
       keywords.push('COMMENT');
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 75: case 102: case 108: case 109: case 122: case 125: case 134: case 136:

     parser.suggestKeywords(parser.getColumnDataTypeKeywords());
   
break;
case 78:
this.$ = {};
break;
case 80:

     this.$ = {};
     this.$[$$[$0]] = true;
   
break;
case 81:

     $$[$0-1][$$[$0]] = true;
   
break;
case 86: case 87:
this.$ = 'null';
break;
case 88:
this.$ = 'comment';
break;
case 89:

     parser.suggestKeywords(['NULL']);
   
break;
case 107:

     parser.suggestKeywords(parser.getTypeKeywords());
   
break;
case 121: case 124:

     parser.suggestKeywords(['COMMENT']);
   
break;
case 143: case 758:

     parser.suggestKeywords(['BY']);
   
break;
case 144:

     parser.suggestKeywords(['RANGE']);
   
break;
case 153: case 158: case 159:

     parser.suggestKeywords(['PARTITION']);
   
break;
case 165:

     parser.suggestKeywords(['VALUE', 'VALUES']);
   
break;
case 166:

     if ($$[$0].endsWithLessThanOrEqual) {
      parser.suggestKeywords(['VALUES']);
     }
   
break;
case 167: case 170: case 173:

     parser.suggestKeywords(['<', '<=']);
   
break;
case 168: case 424: case 427:

     parser.suggestKeywords(['VALUES']);
   
break;
case 171: case 174:

     parser.suggestFunctions();
   
break;
case 180: case 189: case 265: case 723: case 857:

     parser.suggestKeywords(['SELECT']);
   
break;
case 182:

     parser.commitLocations();
   
break;
case 184:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.suggestDatabases({ appendDot: true });
   
break;
case 185:

     if (!$$[$0-6]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 188:

     var keywords = [{value: 'AS', weight: 1 }];
     if (!$$[$0-1]) {
       keywords.push({ value: 'COMMENT', weight: 3 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 195:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 199: case 201:
this.$ = $$[$0-3];
break;
case 205:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestDatabases();
   
break;
case 206:

     parser.suggestKeywords(['CASCADE']);
   
break;
case 208:

     if (!$$[$0-3]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 210: case 229:

     parser.addTablePrimary($$[$0-1]);
   
break;
case 212:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 213:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyTables = true;
     }
   
break;
case 215:

     parser.addTablePrimary($$[$0-2]);
     if (!$$[$0-1]) {
       parser.suggestKeywords(['PURGE']);
     }
   
break;
case 218: case 222: case 224:

     parser.addTablePrimary($$[$0]);
   
break;
case 219:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 220:

     parser.addTablePrimary($$[$0]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 223:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyViews = true;
     }
   
break;
case 225:

     parser.suggestKeywords(['TABLE']);
   
break;
case 226:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 230:

     parser.addTablePrimary($$[$0-1]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 235:

     $$[$0-2].owner = 'insert';
     parser.addTablePrimary($$[$0-2]);
   
break;
case 236:

     parser.suggestKeywords(['INTO']);
   
break;
case 237:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['TABLE']);
     }
     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 239:

     $$[$0-1].owner = 'insert';
     parser.addTablePrimary($$[$0-1]);
     parser.suggestKeywords(['VALUES']);
   
break;
case 249:

     parser.suggestKeywords(['TABLES', 'STREAMS', 'TOPICS']);
   
break;
case 251: case 252:

     return parser.yy.result;
   
break;
case 253:

     parser.prepareNewStatement();
   
break;
case 255: case 257: case 259:

     parser.addStatementLocation(_$[$0]);
   
break;
case 258: case 260:

     parser.addStatementLocation(_$[$0-3]);
   
break;
case 264:

     parser.suggestDdlAndDmlKeywords();
   
break;
case 393: case 396: case 482:
this.$ = '';
break;
case 408: case 411:

     parser.yy.correlatedSubQuery = false;
   
break;
case 409: case 413:

     parser.suggestKeywords(['EXISTS']);
   
break;
case 412:

     parser.suggestKeywords(['NOT EXISTS']);
   
break;
case 423: case 425: case 426: case 428:

     parser.suggestKeywords(['<', '<=', '<>', '=', '>', '>=']);
   
break;
case 449: case 452: case 453: case 478: case 479: case 500: case 503: case 884:

     parser.suggestColumns();
   
break;
case 457: case 483:

     parser.addTableLocation(_$[$0], [ { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0] } ] };
   
break;
case 458: case 484:

     parser.addDatabaseLocation(_$[$0-2], [ { name: $$[$0-2] } ]);
     parser.addTableLocation(_$[$0], [ { name: $$[$0-2] }, { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0-2] }, { name: $$[$0] } ] };
   
break;
case 460: case 465:

     parser.suggestDatabases();
     this.$ = { identifierChain: [{ name: $$[$0-2] }] };
   
break;
case 461: case 486:

     parser.suggestTablesOrColumns($$[$0-2]);
   
break;
case 462:
this.$ = [{ name: $$[$0] }];
break;
case 463:
this.$ = [{ name: $$[$0-2] }, { name: $$[$0-1] }];
break;
case 464:

     parser.suggestDatabases({ appendDot: true });
   
break;
case 468:

     parser.suggestDatabases();
   
break;
case 477: case 716: case 759: case 889: case 890: case 896: case 897:

     parser.valueExpressionSuggest();
   
break;
case 485:

     parser.suggestTables();
     parser.suggestDatabases({ prependDot: true });
   
break;
case 488:
this.$ = { identifierChain: $$[$0-1].identifierChain, alias: $$[$0] };
break;
case 491:

     parser.yy.locations[parser.yy.locations.length - 1].type = 'column';
   
break;
case 492: case 668:

     parser.addAsteriskLocation(_$[$0], $$[$0-2].concat({ asterisk: true }));
   
break;
case 494:

     this.$ = [ $$[$0].identifier ];
     parser.yy.firstChainLocation = parser.addUnknownLocation($$[$0].location, [ $$[$0].identifier ]);
   
break;
case 495:

     if (parser.yy.firstChainLocation) {
       parser.yy.firstChainLocation.firstInChain = true;
       delete parser.yy.firstChainLocation;
     }
     $$[$0-2].push($$[$0].identifier);
     parser.addUnknownLocation($$[$0].location, $$[$0-2].concat());
   
break;
case 496:

     parser.suggestColumns({
       identifierChain: $$[$0-2]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 497:

     parser.suggestColumns({
       identifierChain: $$[$0-4]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 498:
this.$ = [ $$[$0].identifier ];
break;
case 499:

     $$[$0-2].push($$[$0].identifier);
   
break;
case 501:

     parser.suggestColumns({ identifierChain: $$[$0-2] });
   
break;
case 502:

     parser.suggestColumns({ identifierChain: $$[$0-4] });
   
break;
case 504:
this.$ = { identifier: { name: $$[$0] }, location: _$[$0] };
break;
case 525: case 526:

     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 527: case 552:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 528:

     // verifyType($$[$0], 'NUMBER');
     this.$ = $$[$0];
     $$[$0].types = ['NUMBER'];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 529: case 530: case 531:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 532:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 533:

     this.$ = { types: [ 'BOOLEAN' ] };
     // clear correlated flag after completed sub-query (set by lexer)
     parser.yy.correlatedSubQuery = false;
   
break;
case 535: case 536: case 537: case 538:

     parser.addColRefToVariableIfExists($$[$0-2], $$[$0]);
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 539: case 540: case 541: case 542: case 572: case 630: case 631:
this.$ = { types: [ 'BOOLEAN' ] };
break;
case 543:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 544:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 545: case 546:

     // verifyType($$[$0-2], 'BOOLEAN');
     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 547: case 548: case 549:

     // verifyType($$[$0-2], 'NUMBER');
     // verifyType($$[$0], 'NUMBER');
     this.$ = { types: [ 'NUMBER' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 550:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 551:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 553:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 555:

     parser.suggestKeywords(['BETWEEN', 'EXISTS', 'IN', 'LIKE', 'REGEXP', 'RLIKE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 556: case 558:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
break;
case 557:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 559:

     parser.suggestFunctions({ types: [ 'BOOLEAN' ] });
     parser.suggestColumns({ types: [ 'BOOLEAN' ] });
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 560:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0].suggestFilters };
break;
case 561:

     parser.suggestFunctions();
     parser.suggestColumns();
     this.$ = { types: [ 'T' ] };
   
break;
case 562:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 563:

     parser.suggestFunctions({ types: [ 'NUMBER' ] });
     parser.suggestColumns({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ] };
   
break;
case 564:

     parser.suggestKeywords(['FALSE', 'NOT NULL', 'NOT TRUE', 'NOT FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 565:

     parser.suggestKeywords(['FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 566:

     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 567: case 568: case 569:

     parser.suggestKeywords(['NOT']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 570:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-3] ? 'IS NOT DISTINCT FROM' : 'IS DISTINCT FROM');
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 571:

     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 573:

     this.$ = $$[$0-1];
   
break;
case 574:

     parser.valueExpressionSuggest();
     this.$ = { types: ['T'], typeSet: true };
   
break;
case 575:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 576: case 577: case 578:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 579: case 580: case 581: case 582:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0]);
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 583: case 585:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 584:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ] , typeSet: true, endsWithLessThanOrEqual: true };
   
break;
case 586:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, endsWithLessThanOrEqual: $$[$0-1] === '<='  };
   
break;
case 587: case 588: case 589: case 590:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 591:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-3]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 592:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 593: case 594:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
break;
case 595: case 596:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
break;
case 597:

     if ($$[$0-2].types[0] === $$[$0].types[0] && !$$[$0-5].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
   
break;
case 598:

     if ($$[$0-5].types[0] === $$[$0].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 599:

     if ($$[$0-5].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 600:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 601: case 607:

     parser.suggestValueExpressionKeywords($$[$0-1], ['AND']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 602:

     parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 603:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-4].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
   
break;
case 604:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 605:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 606:

     parser.valueExpressionSuggest($$[$0-4], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-4]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 608:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 609: case 611: case 613: case 615:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, suggestFilters: true };
   
break;
case 610: case 614:

     parser.addColRefIfExists($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 612: case 616:

     parser.addColRefIfExists($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 617: case 618:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 619: case 620: case 621:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 622: case 623: case 624:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 625: case 626: case 627:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 628:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 629:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
break;
case 632:

     parser.valueExpressionSuggest(undefined, $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 633:

     parser.valueExpressionSuggest(undefined, $$[$0-1] + ' ' + $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 634: case 636: case 702: case 757: case 836: case 846: case 847: case 863: case 887: case 963: case 967: case 1005: case 1147:
this.$ = $$[$0];
break;
case 635:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 637:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 638:

      this.$ = $$[$0];
      this.$.suggestFilters = $$[$0-1].suggestFilters;
    
break;
case 639:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 640: case 1069: case 1074: case 1075:
this.$ = { types: [ 'T' ] };
break;
case 641: case 643:

     $$[$0].position = 1;
   
break;
case 642:

     $$[$0].position = $$[$0-2].position + 1;
     this.$ = $$[$0];
   
break;
case 644:

     $$[$0-2].position += 1;
   
break;
case 645:

     $$[$0-2].position = 1;
   
break;
case 646:

     $$[$0-4].position += 1;
   
break;
case 647:

     parser.valueExpressionSuggest();
     $$[$0-2].position += 1;
   
break;
case 648:

     parser.valueExpressionSuggest();
     $$[$0-4].position += 1;
   
break;
case 649:

     parser.suggestValueExpressionKeywords($$[$0-3]);
   
break;
case 650: case 651:

     parser.valueExpressionSuggest();
     this.$ = { cursorAtStart : true, position: 1 };
   
break;
case 652: case 653:

     parser.valueExpressionSuggest();
     this.$ = { position: 2 };
   
break;
case 657:
this.$ = { types: ['COLREF'], columnReference: $$[$0].chain };
break;
case 658:
this.$ = { types: [ 'NULL' ], text: $$[$0] };
break;
case 659:

     // We need to handle arbitrary UDFs here instead of inside UserDefinedFunction or there will be a conflict
     // with columnReference for functions like: db.udf(foo)
     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     if ($$[$0-1].lastLoc && $$[$0-1].lastLoc.location) {
       $$[$0-1].lastLoc.type = 'function';
       $$[$0-1].lastLoc.function = fn;
       $$[$0-1].lastLoc.location = {
         first_line: $$[$0-1].lastLoc.location.first_line,
         last_line: $$[$0-1].lastLoc.location.last_line,
         first_column: $$[$0-1].lastLoc.location.first_column,
         last_column: $$[$0-1].lastLoc.location.last_column - 1
       }
       if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
          $$[$0-1].firstLoc.type = 'database';
       } else {
         delete $$[$0-1].lastLoc.identifierChain;
       }
     }
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: fn, expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: fn, types: ['UDFREF'] }
     }
   
break;
case 660:

    parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
    if ($$[$0].expressions && $$[$0].expressions.length) {
      this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
    } else {
      this.$ = { function: $$[$0-1], types: ['UDFREF'] }
    }
  
break;
case 663:

     if ($$[$0].suggestKeywords) {
       this.$ = { types: ['COLREF'], columnReference: $$[$0], suggestKeywords: $$[$0].suggestKeywords };
     } else {
       this.$ = { types: ['COLREF'], columnReference: $$[$0] };
     }
   
break;
case 664:

     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     $$[$0-1].lastLoc.type = 'function';
     $$[$0-1].lastLoc.function = fn;
     $$[$0-1].lastLoc.location = {
       first_line: $$[$0-1].lastLoc.location.first_line,
       last_line: $$[$0-1].lastLoc.location.last_line,
       first_column: $$[$0-1].lastLoc.location.first_column,
       last_column: $$[$0-1].lastLoc.location.last_column - 1
     }
     if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
        $$[$0-1].firstLoc.type = 'database';
     } else {
       delete $$[$0-1].lastLoc.identifierChain;
     }
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions(fn, $$[$0].activePosition);
     }
     this.$ = { function: fn, types: ['UDFREF'] };
   
break;
case 665: case 1082: case 1083:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions($$[$0-1], $$[$0].activePosition);
     }
     this.$ = { function: $$[$0-1], types: ['UDFREF'] };
   
break;
case 667:

     var lastLoc = parser.yy.locations[parser.yy.locations.length - 1];
     if (lastLoc.type !== 'variable') {
       lastLoc.type = 'column';
     }
     // used for function references with db prefix
     var firstLoc = parser.yy.locations[parser.yy.locations.length - $$[$0].length];
     this.$ = { chain: $$[$0], firstLoc: firstLoc, lastLoc: lastLoc }
   
break;
case 674:

     parser.suggestValues($$[$0]);
   
break;
case 675:
this.$ = { types: [ 'NUMBER' ], text: $$[$0] };
break;
case 681: case 683: case 684:
this.$ = $$[$0-1] + $$[$0];
break;
case 682: case 685:
this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 686:
this.$ = $$[$0-3] + $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 687:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: "'" + $$[$0] + "'" }
     } else {
       this.$ = { types: [ 'STRING' ] }
     }
   
break;
case 688:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: '"' + $$[$0] + '"' }
     } else {
       this.$ = { types: [ 'STRING' ], text: '"' + $$[$0] + '"' }
     }
   
break;
case 689:
this.$ = { types: [ 'BOOLEAN' ], text: $$[$0] };
break;
case 690:

    this.$ = { partialQuote: '\'', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 691:

    this.$ = { partialQuote: '"', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 698:

     this.$ = $$[$0];

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         this.$.suggestJoins = {
           prependJoin: true,
           tables: tables
         };
       }
      }
   
break;
case 705:

     this.$ = {
       primary: $$[$0-1]
     }
     if ($$[$0-1].identifierChain) {
       if ($$[$0]) {
         $$[$0-1].alias = $$[$0].alias
         parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
       }
       parser.addTablePrimary($$[$0-1]);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     } else if ($$[$0].suggestKeywords) {
       keywords = $$[$0].suggestKeywords;
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 706:

     this.$ = {
       primary: $$[$0-1]
     };

     if ($$[$0]) {
       this.$.primary.alias = $$[$0].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 707:

     if ($$[$0]) {
       parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }
   
break;
case 708:

     if ($$[$0]) {
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias);
     }
   
break;
case 718:

     parser.pushQueryState();
   
break;
case 719:

     parser.popQueryState();
   
break;
case 721:

     if ($$[$0-1]) {
       $$[$0-2].alias = $$[$0-1].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0-1].alias });
       parser.addSubqueryAliasLocation($$[$0-1].location, $$[$0-1].alias, $$[$0-2].identifierChain);
     }
     this.$ = $$[$0-2];
   
break;
case 724:

     var subQuery = parser.getSubQuery($$[$0]);
     subQuery.columns.forEach(function (column) {
       parser.expandIdentifierChain({ wrapper: column });
       delete column.linked;
     });
     parser.popQueryState(subQuery);
     this.$ = subQuery;
   
break;
case 741: case 742: case 743: case 744:
this.$ = { alias: $$[$0], location: _$[$0] };
break;
case 751: case 752:

     if (parser.yy.result.suggestFunctions) {
       parser.suggestAggregateFunctions();
     }
   
break;
case 753:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords([{ value: 'PARTITION BY', weight: 2 }, { value: 'ORDER BY', weight: 1 }]);
     } else if (!$$[$0-2]) {
       parser.suggestKeywords(['PARTITION BY']);
     }
   
break;
case 754:

      if (!$$[$0-1]) {
        parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ORDER BY', weight: 2 }]);
      } else {
        parser.suggestValueExpressionKeywords($$[$0-3]);
      }
    
break;
case 763:

      // Only allowed in last order by
      delete parser.yy.result.suggestAnalyticFunctions;
    
break;
case 764:

      var keywords = [];
      if ($$[$0-2].suggestKeywords) {
        keywords = parser.createWeightedKeywords($$[$0-2].suggestKeywords, 2);
      }
      if (!$$[$0]) {
        keywords = keywords.concat([{ value: 'RANGE BETWEEN', weight: 1 }, { value: 'ROWS BETWEEN', weight: 1 }]);
      }
      parser.suggestKeywords(keywords);
    
break;
case 770:

     parser.suggestKeywords(['BETWEEN']);
   
break;
case 771:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED PRECEDING']);
     } else if (!$$[$0-1]) {
       parser.suggestKeywords(['AND']);
     }
   
break;
case 776:

    lexer.popState();
  
break;
case 777:

    lexer.begin('hdfs');
  
break;
case 779:

      parser.suggestHdfs({ path: $$[$0-3] });
    
break;
case 780:

     parser.suggestHdfs({ path: $$[$0-2] });
   
break;
case 781:

      parser.suggestHdfs({ path: $$[$0-1] });
    
break;
case 782:

     parser.suggestHdfs({ path: '' });
   
break;
case 783:

      parser.suggestHdfs({ path: '' });
    
break;
case 789:

     parser.suggestKeywords(['PRECEDING']);
   
break;
case 790: case 795:

     parser.suggestKeywords(['ROW']);
   
break;
case 794:

     parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED FOLLOWING']);
   
break;
case 796:

     parser.suggestKeywords(['FOLLOWING']);
   
break;
case 801: case 841:
this.$ = $$[$0-2];
break;
case 804:

     parser.addCommonTableExpressions($$[$0-3]);
   
break;
case 805: case 806: case 852:

     parser.addCommonTableExpressions($$[$0-2]);
   
break;
case 810:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     this.$ = { selectList: $$[$0] };
   
break;
case 811:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     this.$ = { selectList: $$[$0-1], tableExpression: $$[$0] }
   
break;
case 812:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     if ($$[$0].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-1]) {
         keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
       }
       parser.suggestKeywords(keywords);
     } else {
       parser.checkForSelectListKeywords($$[$0]);
     }
     if ($$[$0].suggestFunctions) {
       parser.suggestFunctions();
     }
     if ($$[$0].suggestColumns) {
       parser.suggestColumns({ identifierChain: [], source: 'select' });
     }
     if ($$[$0].suggestTables) {
       parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     }
     if ($$[$0].suggestDatabases) {
       parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
     }
     if ($$[$0].suggestAggregateFunctions && (!$$[$0-1] || $$[$0-1] === 'ALL')) {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
   
break;
case 813:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-1] || $$[$0-1] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-1]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 814:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
   
break;
case 815:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.selectListNoTableSuggest($$[$0-1], $$[$0-2]);
     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'select';
     }
   
break;
case 816:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2] || $$[$0-2] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-2]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 817:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]), _$[$0-2]);
     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 818:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]), _$[$0-3]);
     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 819:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.checkForSelectListKeywords($$[$0-1]);
     var keywords = ['FROM'];
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.suggestTables({ prependFrom: true });
     parser.suggestDatabases({ prependFrom: true, appendDot: true });
   
break;
case 823: case 824:

     parser.addClauseLocation('whereClause', _$[$0-1], $$[$0].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0].limitClausePreceding || _$[$0-1], $$[$0].limitClauseLocation);
   
break;
case 825:

     var keywords = [];

     parser.addClauseLocation('whereClause', _$[$0-3], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-2].limitClausePreceding || _$[$0-3], $$[$0-2].limitClauseLocation);

     if ($$[$0-3]) {
       if (typeof $$[$0-3].tableReferenceList.hasJoinCondition !== 'undefined' && !$$[$0-3].tableReferenceList.hasJoinCondition) {
         keywords.push({ value: 'ON', weight: 3 });
       }
       if ($$[$0-3].suggestKeywords) {
         keywords = parser.createWeightedKeywords($$[$0-3].suggestKeywords, 3);
       }
       if ($$[$0-3].tableReferenceList.suggestJoinConditions) {
         parser.suggestJoinConditions($$[$0-3].tableReferenceList.suggestJoinConditions);
       }
       if ($$[$0-3].tableReferenceList.suggestJoins) {
         parser.suggestJoins($$[$0-3].tableReferenceList.suggestJoins);
       }
       if ($$[$0-3].tableReferenceList.suggestKeywords) {
         keywords = keywords.concat(parser.createWeightedKeywords($$[$0-3].tableReferenceList.suggestKeywords, 3));
       }

       // Lower the weights for 'TABLESAMPLE'
       keywords.forEach(function (keyword) {
         if (keyword.value === 'TABLESAMPLE') {
           keyword.weight = 1.1;
         }
       });

       if ($$[$0-3].tableReferenceList.types) {
         var veKeywords = parser.getValueExpressionKeywords($$[$0-3].tableReferenceList);
         keywords = keywords.concat(veKeywords.suggestKeywords);
         if (veKeywords.suggestColRefKeywords) {
           parser.suggestColRefKeywords(veKeywords.suggestColRefKeywords);
           parser.addColRefIfExists($$[$0-3].tableReferenceList);
         }
       }
     }

     if ($$[$0-1].empty && $$[$0] && $$[$0].joinType.toUpperCase() === 'JOIN') {
       keywords = keywords.concat(['FULL', 'FULL OUTER', 'INNER', 'LEFT', 'LEFT OUTER', 'RIGHT', 'RIGHT OUTER']);
       parser.suggestKeywords(keywords);
       return;
     }

     if ($$[$0-1].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].suggestFilters) {
       parser.suggestFilters($$[$0-1].suggestFilters);
     }
     if ($$[$0-1].suggestGroupBys) {
       parser.suggestGroupBys($$[$0-1].suggestGroupBys);
     }
     if ($$[$0-1].suggestOrderBys) {
       parser.suggestOrderBys($$[$0-1].suggestOrderBys);
     }

     if ($$[$0-1].empty) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }

     keywords = keywords.concat([
       { value: 'FULL JOIN', weight: 1 },
       { value: 'FULL OUTER JOIN', weight: 1 },
       { value: 'INNER JOIN', weight: 1 },
       { value: 'JOIN', weight: 1 },
       { value: 'LEFT JOIN', weight: 1 },
       { value: 'LEFT OUTER JOIN', weight: 1 },
       { value: 'RIGHT JOIN', weight: 1 },
       { value: 'RIGHT OUTER JOIN', weight: 1 }
     ]);
     parser.suggestKeywords(keywords);
  
break;
case 826:

     // A couple of things are going on here:
     // - If there are no SelectConditions (WHERE, GROUP BY, etc.) we should suggest complete join options
     // - If there's an OptionalJoin at the end, i.e. 'SELECT * FROM foo | JOIN ...' we should suggest
     //   different join types
     // - The FromClause could end with a valueExpression, in which case we should suggest keywords like '='
     //   or 'AND' based on type

     if (!$$[$0-1]) {
       parser.addClauseLocation('whereClause', _$[$0-2]);
       parser.addClauseLocation('limitClause', _$[$0-2]);
       return;
     }
     parser.addClauseLocation('whereClause', _$[$0-2], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-1].limitClausePreceding || _$[$0-2], $$[$0-1].limitClauseLocation);
     var keywords = [];

     if ($$[$0-1].suggestColRefKeywords) {
       parser.suggestColRefKeywords($$[$0-1].suggestColRefKeywords);
       parser.addColRefIfExists($$[$0-1]);
     }

     if ($$[$0-1].suggestKeywords && $$[$0-1].suggestKeywords.length) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].cursorAtEnd) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 827:
this.$ = [ $$[$0] ];
break;
case 828:

     $$[$0-2].push($$[$0]);
   
break;
case 830: case 831:

     this.$ = { cursorAtStart : true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 833:

     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 834:

     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 835:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestTables: true, suggestDatabases: true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 837: case 838: case 840:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true,  };
   
break;
case 842:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
       this.$ = { valueExpression: $$[$0-1], alias: $$[$0].alias };
       if (!parser.yy.selectListAliases) {
         parser.yy.selectListAliases = [];
       }
       parser.yy.selectListAliases.push($$[$0-1].function && $$[$0-1].types && $$[$0-1].types.length && $$[$0-1].types[0] === 'UDFREF' ? { name: $$[$0].alias, udfRef: $$[$0-1].function, types: $$[$0-1].types } : { name: $$[$0].alias, types: $$[$0-1].types || ['T'] });
     } else {
       this.$ = { valueExpression: $$[$0-1] }
     }
   
break;
case 843:

     parser.addAsteriskLocation(_$[$0], [{ asterisk: true }]);
     this.$ = { asterisk: true }
   
break;
case 844:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
     }
   
break;
case 845:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.addColumnAliasLocation(_$[$0], $$[$0], _$[$0-2]);
     this.$ = { suggestAggregateFunctions: true };
   
break;
case 850:
this.$ = $$[$0-2].concat([$$[$0]]);
break;
case 854:

     parser.addCommonTableExpressions($$[$0-4]);
   
break;
case 855:

     parser.addCteAliasLocation(_$[$0-4], $$[$0-4]);
     $$[$0-1].alias = $$[$0-4];
     this.$ = $$[$0-1];
   
break;
case 856:

     parser.suggestKeywords(['AS']);
   
break;
case 859:

     this.$ = { tableReferenceList : $$[$0] }
   
break;
case 860: case 868:

       parser.suggestTables();
       parser.suggestDatabases({ appendDot: true });
   
break;
case 871:

     this.$ = { valueExpression: $$[$0] };
   
break;
case 872: case 974:

     parser.suggestSelectListAliases();
   
break;
case 873:

     parser.valueExpressionSuggest();
     parser.suggestSelectListAliases();
     parser.suggestGroupBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 874:

     parser.suggestKeywords(['BY']);
     parser.suggestGroupBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 901:

     parser.valueExpressionSuggest();
     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 902:

     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 906:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-2];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
        parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 907:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-3];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
       parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 908:
this.$ = { joinType: $$[$0] };
break;
case 909:
this.$ = { joinType: $$[$0-1] };
break;
case 910:

     if ($$[$0-2].suggestKeywords) {
       parser.suggestKeywords($$[$0-2].suggestKeywords);
     }
   
break;
case 911:

     if ($$[$0].suggestKeywords) {
       parser.suggestKeywords($$[$0].suggestKeywords);
     }
   
break;
case 914:

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         parser.suggestJoins({
           prependJoin: false,
           joinType: $$[$0-2],
           tables: tables
         })
       }
     }
     parser.suggestTables();
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 919:
this.$ = 'CROSS JOIN';
break;
case 920:
this.$ = 'FULL JOIN';
break;
case 921:
this.$ = 'FULL OUTER JOIN';
break;
case 922:
this.$ = 'INNER JOIN';
break;
case 923:
this.$ = 'JOIN';
break;
case 924:
this.$ = 'LEFT INNER JOIN';
break;
case 925:
this.$ = 'LEFT JOIN';
break;
case 926:
this.$ = 'LEFT OUTER JOIN';
break;
case 927:
this.$ = 'LEFT SEMI JOIN';
break;
case 928:
this.$ = 'OUTER JOIN';
break;
case 929: case 931:
this.$ = 'RIGHT OUTER JOIN';
break;
case 930:
this.$ = 'RIGHT JOIN';
break;
case 932:
this.$ = 'RIGHT SEMI JOIN';
break;
case 933:
this.$ = 'SEMI JOIN';
break;
case 934: case 936: case 937: case 939: case 940: case 941: case 942: case 944: case 945: case 946: case 947:
this.$ = { suggestKeywords: ['JOIN'] };
break;
case 935: case 938: case 943:
this.$ = { suggestKeywords: ['OUTER'] };
break;
case 948:
this.$ = { noJoinCondition: true, suggestKeywords: ['ON'] };
break;
case 949:
this.$ = { valueExpression: $$[$0] };
break;
case 953:

     parser.valueExpressionSuggest();
     parser.suggestJoinConditions({ prependOn: false });
   
break;
case 960:

     parser.suggestKeywords([{ value: '10', weight: 10000 }, { value: '100', weight: 10000 }, { value: '1000', weight: 10000 }, { value: '5000', weight: 10000 }, { value: '10000', weight: 10000 }])
   
break;
case 964:

     if ($$[$0].emptyOrderBy) {
       parser.suggestOrderBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 965:

     parser.suggestKeywords(['BY']);
     parser.suggestOrderBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 969:

     this.$ = { emptyOrderBy: false }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 970: case 971: case 972:
this.$ = { emptyOrderBy: false };
break;
case 973:
this.$ = parser.mergeSuggestKeywords($$[$0]);
break;
case 975:

     this.$ = { emptyOrderBy: true }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 976:
this.$ = { suggestKeywords: ['ASC', 'DESC'] };;
break;
case 979:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'WHERE', weight: 7 }, { value: 'GROUP BY', weight: 6 }, { value: 'HAVING', weight: 5 }, { value: 'ORDER BY', weight: 4 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true, true]);

     if (keywords.length > 0) {
       this.$ = { suggestKeywords: keywords, empty: !$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0] };
     } else {
       this.$ = {};
     }

     this.$.whereClauseLocation = $$[$0-4] ? _$[$0-4] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;

     if (!$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestFilters = { prefix: 'WHERE', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestGroupBys = { prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-1] && !$$[$0]) {
       this.$.suggestOrderBys = { prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
   
break;
case 980:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'where';
     }
   
break;
case 981:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'group by';
     }
   
break;
case 983:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'order by';
     }
   
break;
case 985:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'GROUP BY', weight: 8 }, { value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true]);
     if ($$[$0-5].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-5].suggestKeywords, 1));
     }
     this.$ = parser.getValueExpressionKeywords($$[$0-5], keywords);
     this.$.cursorAtEnd = !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if ($$[$0-5].columnReference) {
       this.$.columnReference = $$[$0-5].columnReference;
     }
     if (!$$[$0-3]) {
       parser.suggestGroupBys({ prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 986:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true]);
     if ($$[$0-4].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-4].suggestKeywords, 8));
     }
     if ($$[$0-4].valueExpression) {
       this.$ = parser.getValueExpressionKeywords($$[$0-4].valueExpression, keywords);
       if ($$[$0-4].valueExpression.columnReference) {
         this.$.columnReference = $$[$0-4].valueExpression.columnReference;
       }
     } else {
       this.$ = { suggestKeywords: keywords };
     }
     this.$.cursorAtEnd = !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 987:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-1], $$[$0]],
       [{ value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true]);
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0-1] && !$$[$0] };
     if (!$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-3], _$[$0-3]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 988:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0]],
       [{ value: 'LIMIT', weight: 3 }],
       [true]);
     if ($$[$0-2].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-2].suggestKeywords, 4));
     }
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0] };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 989:

     this.$ = { suggestKeywords: [], cursorAtEnd: true };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = _$[$0-1];
   
break;
case 1000:

     parser.suggestKeywords(['ALL', 'DISTINCT', 'SELECT']);
   
break;
case 1001:

     parser.suggestKeywords(['ALL', 'DISTINCT']);
   
break;
case 1006:

     if ($$[$0].suggestFilters) {
       parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 1007:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS', 'NOT EXISTS']);
     parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 1019:

     if (!$$[$0]) {
       $$[$0-1].suggestKeywords = ['OVER'];
     }
   
break;
case 1026:

     parser.suggestKeywords(['OVER']);
   
break;
case 1035:

     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 1036: case 1054:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1037:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       if ($$[$0-4].toLowerCase() === 'group_concat') {
         keywords.push('ALL');
       } else {
         keywords.push('DISTINCT');
       }
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1038: case 1052:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 1039:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords(true);
       if (!$$[$0-2]) {
         if ($$[$0-4].toLowerCase() === 'group_concat') {
           keywords.push('ALL');
         } else {
           keywords.push('DISTINCT');
         }
       }
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
       parser.suggestKeywords(keywords);
     }
     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], $$[$0-1].activePosition);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1048:

     parser.addFunctionArgumentLocations($$[$0-3], [{
       expression: { text: $$[$0-1] },
       location: _$[$0-1]
     }]);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] }
   
break;
case 1049: case 1055:

     this.$ = { function: $$[$0-2], types: ['UDFREF'] }
   
break;
case 1050:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] }
   
break;
case 1051:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1053:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-2]) {
         keywords.push('DISTINCT');
       }
       parser.suggestKeywords(keywords);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1056:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1057:

     parser.suggestValueExpressionKeywords($$[$0-2]);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 1058:

     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1059:

    this.$ = { function: $$[$0-2], types: ['UDFREF'] }
  
break;
case 1060:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     this.$ = {
       function: $$[$0-3],
       expression: $$[$0-1].expressions[$$[$0-1].expressions.length - 1].expression,
       types: ['UDFREF']
     }
   
break;
case 1061:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-3], 1);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 1062:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-2].expressions);
     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 1063:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     parser.applyArgumentTypesToSuggestions($$[$0-3], $$[$0-1].activePosition);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 1068:

     var expression = $$[$0-3];
     parser.extractExpressionText(expression, $$[$0-3], $$[$0-2], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-5], [{
       expression: expression,
       location: {
         first_line: _$[$0-3].first_line,
         last_line: _$[$0-1].last_line,
         first_column: _$[$0-3].first_column,
         last_column: _$[$0-1].last_column
       }
     }]);
     this.$ = { types: [ $$[$0-1].toUpperCase() ] }
   
break;
case 1070:

     parser.valueExpressionSuggest();
     this.$ = { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 1071: case 1072:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ] };
   
break;
case 1073:
this.$ = { types: [ $$[$0-1].toUpperCase() ] };
break;
case 1076:

     parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'AS', weight: 2 }]);
     this.$ =  { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 1077:

     parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'AS', weight: 2 }]);
     this.$ = { types: [ 'T' ] };
   
break;
case 1078: case 1079:

     parser.suggestKeywords(parser.getTypeKeywords());
     this.$ = { types: [ 'T' ] };
   
break;
case 1080: case 1081:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: $$[$0-1], types: ['UDFREF'] }
     }
   
break;
case 1086:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }]
     }
   
break;
case 1087:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = $$[$0-3];
   
break;
case 1089: case 1091:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0], location: _$[$0] }]
     }
   
break;
case 1090: case 1092:

     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: $$[$0], location: _$[$0] }])
     }
   
break;
case 1093:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0-2], location: _$[$0-2] }].concat($$[$0].expressions)
     }
   
break;
case 1094:

     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: $$[$0-2], location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 1095:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: { text: '' }, location: _$[$0] }])
     }
   
break;
case 1096:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: { text: '' }, location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 1097:

     parser.suggestValueExpressionKeywords($$[$0-3].expressions[$$[$0-3].expressions.length - 1].expression);
     this.$ = {
       activePosition: $$[$0-3].activePosition,
       expressions: $$[$0-3].expressions.concat($$[$0].expressions)
     }
   
break;
case 1098:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 1099:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 1100:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 1101:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-3] }, { expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 1113:

     parser.suggestKeywords(['TABLES', 'STREAMS', 'TOPICS', 'QUERIES', 'PROPERTIES']);
   
break;
case 1115:
this.$ = { inValueEdit: true };
break;
case 1116:
this.$ = { inValueEdit: true, cursorAtStart: true };
break;
case 1117: case 1118: case 1119:

     this.$ = { suggestKeywords: ['NOT'] }
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1123: case 1124: case 1125:

     parser.suggestFunctions({ types: [ 'STRING' ] });
     parser.suggestColumns({ types: [ 'STRING' ] });
     this.$ = { types: ['BOOLEAN'] }
   
break;
case 1126:

     this.$ = parser.findCaseType($$[$0-1])
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1127:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1128:
this.$ = parser.findCaseType($$[$0-1]);
break;
case 1129:

     parser.suggestValueExpressionKeywords($$[$0-1], ['END']);
     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1130:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1131:
this.$ = parser.findCaseType($$[$0-2]);
break;
case 1132:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1133:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-2]);
   
break;
case 1134:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     this.$.suggestFilters = $$[$0-1].suggestFilters
   
break;
case 1135:

     parser.valueExpressionSuggest();
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1136:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1137:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = $$[$0-1];
   
break;
case 1138:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ] };
   
break;
case 1141:

     this.$ = { caseTypes: [ $$[$0] ], lastType: $$[$0] }
     parser.extractExpressionText(this.$, $$[$0]);
   
break;
case 1142:

     $$[$0-1].caseTypes.push($$[$0]);
     this.$ = { caseTypes: $$[$0-1].caseTypes, lastType: $$[$0] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1146:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
   
break;
case 1148:

     this.$ = $$[$0]
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1149:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0].suggestFilters };
break;
case 1150:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1151:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1152: case 1153:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0].suggestFilters };
break;
case 1154:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1155:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [$$[$0]] };
   
break;
case 1156:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1157:

      parser.valueExpressionSuggest();
      parser.suggestKeywords(['WHEN']);
      this.$ = { caseTypes: [{ types: ['T'] }] };
    
break;
case 1158: case 1160:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1159:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1161:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [$$[$0]], suggestFilters: true };
   
break;
case 1162:

     parser.suggestValueExpressionKeywords($$[$0-1], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1163:

     parser.suggestValueExpressionKeywords($$[$0-2], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1164: case 1165: case 1166: case 1167:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
}
},
table: [o($V0,$V1,{165:1,166:2}),{1:[3]},o($V2,$V3,{167:3,171:4,26:5,151:6,135:7,27:8,28:9,29:10,30:11,31:12,32:13,33:14,34:15,35:16,152:20,401:21,174:22,153:26,4:$V4,9:$V5,15:$V6,36:$V7,42:$V8,149:$V9,156:$Va,406:$Vb,419:$Vc}),{168:[1,30],172:[1,31]},o($V2,[2,255]),o($V2,[2,261]),o($V2,[2,262]),o($V2,[2,263]),o($V2,[2,21]),o($V2,[2,22]),o($V2,[2,23]),o($V2,[2,24]),o($V2,[2,25]),o($V2,[2,26]),o($V2,[2,27]),o($V2,[2,28]),o($V2,[2,29]),{37:32,162:[1,33],163:[1,34],164:[1,35]},{38:[1,36],39:37,46:38,50:$Vd,103:$Ve,176:41,177:$Vf,178:$Vg,179:$Vh},{43:45,162:[1,46],163:[1,47],164:[1,48],484:[1,49],485:[1,50]},o($V2,[2,232]),o($Vi,$Vj,{402:51,457:52,459:53,251:$Vk}),{69:[1,56],401:55,406:$Vb},{44:57,50:[1,58],51:[1,59],137:[1,60],203:$Vl,240:$Vm},{44:63,50:[1,64],51:[1,65],137:[1,66],203:$Vl,240:$Vm},{51:[1,67]},o($V2,[2,233]),o([23,24,50,69,85,86,97,102,103,149,177,178,179,181,182,183,184,187,188,192,193,197,198,200,210,211,219,227,228,243,244,246,250,252,253,254,255,257],$Vn,{407:68,38:$Vo,206:$Vp}),{46:74,50:$Vd,103:$Ve,109:73,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,420:71,422:72},{157:[1,76]},{1:[2,250]},o($V0,$V1,{166:77}),o($V2,[2,30]),o($V2,[2,246]),o($V2,[2,247]),o($V2,[2,248]),o($V2,[2,31]),{40:[1,78],184:[1,79]},o($Vr,[2,1010]),o($Vs,[2,273]),o($Vs,[2,274]),o($Vs,[2,275]),o($Vs,[2,270]),o($Vs,[2,271]),o($Vs,[2,272]),o($V2,[2,33]),o($V2,[2,1108]),o($V2,[2,1109]),o($V2,[2,1110]),o($V2,[2,1111]),o($V2,[2,1112]),o($Vi,[2,799]),o($Vi,[2,991],{459:80,251:$Vk}),o($Vt,[2,993]),o([38,206,406],$V1,{166:81}),o($Vi,$Vj,{457:52,459:53,402:82,251:$Vk}),{135:83,174:22,401:21,406:$Vb,419:$Vc},o($Vu,$Vv,{45:84,219:$Vw}),{46:86,50:$Vd,103:$Ve,176:41,177:$Vf,178:$Vg,179:$Vh},o($Vx,$Vv,{45:87,219:$Vw}),o($Vx,$Vv,{45:88,219:$Vw}),o($Vy,[2,390]),o($Vy,[2,391]),o($Vx,$Vz,{144:89,219:$VA}),{46:91,50:$Vd,103:$Ve,176:41,177:$Vf,178:$Vg,179:$Vh},o($Vx,$Vz,{144:92,219:$VA}),o($Vx,$Vz,{144:93,219:$VA}),o($Vx,$Vz,{144:94,219:$VA}),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:97,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,182:$VK,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,408:95,417:96,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($V51,[2,821]),o($V51,[2,822]),o([69,406],[2,847],{75:[1,153]}),o($V61,[2,849]),{133:[1,154]},o($Vs,[2,480]),{25:[1,155],193:[1,156]},o($Vx,[2,244],{158:157,51:[1,158]}),o($V2,$V3,{171:4,26:5,151:6,135:7,27:8,28:9,29:10,30:11,31:12,32:13,33:14,34:15,35:16,152:20,401:21,174:22,153:26,167:159,4:$V4,9:$V5,15:$V6,36:$V7,42:$V8,149:$V9,156:$Va,406:$Vb,419:$Vc}),{20:163,23:$VB,24:$VC,41:160,46:161,50:$Vd,86:[1,166],103:$Ve,176:41,177:$Vf,178:$Vg,179:$Vh,183:[1,168],184:$VM,211:[1,165],250:[1,164],252:$V01,253:$V11,262:170,265:171,331:162,332:167,333:[1,169],338:129,339:130},{46:172,50:$Vd,103:$Ve,176:41,177:$Vf,178:$Vg,179:$Vh},o($Vt,[2,994]),{38:$Vo,206:$Vp,406:$Vn,407:173},o($Vi,[2,800]),{71:[1,174]},o($V2,[2,34],{176:41,46:175,50:$Vd,103:$Ve,177:$Vf,178:$Vg,179:$Vh}),{85:[1,176]},o($V2,[2,43]),{46:74,50:$Vd,52:177,54:178,60:179,103:$Ve,109:180,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{46:74,50:$Vd,60:181,103:$Ve,109:180,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{46:74,50:$Vd,103:$Ve,109:182,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{210:[1,183]},o($V2,[2,209]),{46:74,50:$Vd,66:184,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{46:74,50:$Vd,66:186,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{46:74,50:$Vd,66:187,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},o($Vt,[2,810],{409:188,412:190,75:[1,189],214:[1,191]}),o($V71,[2,827]),o($V71,$V81,{176:41,46:74,262:170,265:171,352:192,314:206,109:207,20:208,23:$VB,24:$VC,40:$V91,50:$Vd,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,103:$Ve,132:$Ve1,133:$Vf1,177:$Vf,178:$Vg,179:$Vh,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,193:$Vq,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($V71,[2,843]),o($Vq1,[2,524]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:213,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:214,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:215,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:216,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{69:$Vr1,310:217},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:219,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:221,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,258:$Vs1,262:131,265:132,280:107,300:113,308:99,315:220,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135,486:222,488:223},o($Vq1,[2,656]),o($Vq1,[2,657],{324:225,69:$Vt1}),o($Vq1,[2,658]),{69:$Vt1,324:227},o($Vq1,[2,661]),o($Vq1,[2,673]),o($Vu1,[2,667],{184:[1,228]}),{69:[2,1064]},{69:[2,1065]},{69:[2,1066]},{69:[2,1067]},o($Vq1,[2,1102],{464:229,466:230,233:$Vv1}),{233:$Vv1,466:232},o($Vq1,[2,1021]),o($Vq1,[2,675]),o($Vq1,[2,676]),o($Vw1,[2,494]),o($Vx1,[2,1029]),o($Vx1,[2,1030]),o($Vx1,[2,1031]),{69:[1,233]},{69:[1,234]},o($Vq1,[2,678]),o($Vq1,[2,679]),o($Vq1,[2,687]),o($Vq1,[2,688]),o($Vq1,[2,689]),o([19,23,24,40,50,65,69,71,75,85,97,98,99,102,103,119,132,133,168,172,177,178,179,182,183,184,189,190,191,193,194,195,196,199,201,204,205,207,208,209,212,214,215,216,217,220,221,222,223,224,225,226,230,231,232,235,236,237,239,241,242,245,247,248,249,251,256,258,259,313],[2,504]),{69:[1,235]},{69:[1,236]},{69:[1,237]},o($Vq1,[2,680],{184:[1,238]}),{252:[1,239],253:[1,240]},{252:[1,241]},{23:[1,243],25:[1,242]},{24:[1,245],25:[1,244]},o($Vq1,[2,692]),o($Vq1,[2,693]),{69:[2,1040]},{69:[2,1041]},{69:[2,1042]},{69:[2,1043]},{69:[2,1044]},{69:[2,1045]},{69:[2,1046]},{69:[2,1047]},{46:74,50:$Vd,103:$Ve,109:73,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,422:246},{69:[1,247]},{193:[1,248]},o($Vs,[2,482]),{46:74,50:$Vd,66:249,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},o($Vx,[2,245]),o($V2,[2,256]),o($V2,[2,32]),o($V2,[2,1012]),o($V2,[2,1013],{176:41,46:250,50:$Vd,103:$Ve,177:$Vf,178:$Vg,179:$Vh}),o($V2,[2,1015]),o($V2,[2,1016]),o($V2,[2,1017]),o($V2,[2,1018]),o($Vu,[2,670]),{184:$VM,252:$V01,253:$V11,332:251,338:129,339:130},{184:$VM,252:$V01,253:$V11,332:252,338:129,339:130},o($Vy1,[2,398]),o($Vy1,[2,399]),o($Vr,[2,1011]),{401:253,406:$Vb},o($Vi,$Vj,{457:52,459:53,402:254,251:$Vk}),o($V2,$Vz1,{47:255,17:256,18:257,19:$VA1}),{210:[1,259]},o($V2,[2,44]),o($VB1,[2,140],{55:260,114:261,115:[1,262]}),o($VC1,[2,56],{61:263,64:264,65:[1,265],69:[1,266]}),o($VD1,[2,462],{184:[1,267]}),o($VE1,[2,192],{138:268,140:269,69:[1,270]}),o($V2,[2,405],{145:271,272:[1,272]}),o($Vx,[2,408]),o($V2,[2,216],{147:273,148:[1,274]}),o($VF1,[2,457],{184:[1,275]}),o($V2,[2,218]),o($V2,[2,224]),o($Vt,[2,811]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:97,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,182:$VK,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,417:276,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VG1,[2,1003],{413:277,454:278,456:279,259:[1,280]}),{46:74,50:$Vd,66:288,69:$Vr1,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,310:289,341:282,342:283,345:284,346:285,351:286,353:287,424:281},o($V71,[2,842]),o($VH1,[2,694],{309:290,85:[1,291]}),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:292,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:293,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:294,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:295,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{65:$Va1,194:[1,297],220:[1,296],235:$Vo1,237:$Vp1,314:298},{69:[1,299]},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:300,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:301,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:302,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:303,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:304,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:305,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vq1,[2,550]),o($VI1,[2,741]),o($VI1,[2,742]),{20:307,23:$VB,24:$VC,46:74,50:$Vd,103:$Ve,109:306,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,262:170,265:171},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:308,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:309,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:310,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VJ1,[2,525],{314:206,40:$V91,65:$Va1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VJ1,[2,526],{314:206,40:$V91,65:$Va1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VJ1,[2,527],{314:206,40:$V91,65:$Va1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VK1,[2,528],{314:206}),o($Vq1,[2,533]),o($VL1,$VM1,{310:289,311:311,353:312,359:313,69:$Vr1}),{40:$V91,65:$Va1,71:[1,314],85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,314:206},o($Vq1,[2,552]),{40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,258:$Vs1,314:206,315:315,486:222,488:223},{208:[1,317],209:[1,316],258:$Vs1,488:318},o($VN1,[2,1141]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:319,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vq1,[2,659]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,71:[1,320],77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:322,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135,480:321},o($Vq1,[2,660]),{46:74,50:$Vd,77:324,103:$Ve,109:134,176:41,177:$Vf,178:$Vg,179:$Vh,182:[1,323],193:$Vq},o($Vq1,[2,1019]),o($Vq1,[2,1103]),{46:74,50:$Vd,69:[1,327],103:$Ve,109:325,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,376:326},o($Vq1,[2,1020]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,71:[1,328],77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:322,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135,480:329},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,71:[1,331],77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:330,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o([23,24,50,69,71,85,86,97,102,103,149,177,178,179,181,183,184,187,188,192,193,197,198,200,210,211,219,227,228,243,244,246,250,252,253,254,255,257],$Vn,{407:332,38:$Vo,206:$Vp}),o($VO1,$Vn,{407:335,38:$Vo,71:[1,334],182:[1,333],206:$Vp}),o($VO1,$Vn,{407:336,38:$Vo,71:[1,337],206:$Vp}),o($Vq1,[2,681],{252:[1,338],253:[1,339]}),o($Vq1,[2,683]),{252:[1,340]},o($Vq1,[2,684]),{23:[1,341]},o($VP1,[2,393]),{24:[1,342]},o($VP1,[2,396]),o($V61,[2,850]),o($VL1,$VM1,{359:313,311:343}),o($Vs,[2,481]),{130:[1,344]},o($V2,[2,1014]),o($Vu,[2,671]),o($Vu,[2,672]),o($Vt,[2,999]),o($Vi,[2,801]),o($V2,[2,35]),o($V2,[2,41]),o([71,75,99,133,168,172],[2,14]),{20:345,23:$VB,24:$VC,262:170,265:171},o([50,103,168,172,177,178,179,193],[2,411]),o($V2,[2,178],{56:346,133:[1,347]}),o($VB1,[2,141]),{116:[1,348]},o($VC1,[2,53]),o($VC1,[2,57]),{46:74,50:$Vd,66:349,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{46:74,50:$Vd,70:350,74:351,77:352,103:$Ve,109:134,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{46:74,50:$Vd,103:$Ve,109:353,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{17:354,18:257,19:$VA1,133:$Vz1},o($VE1,[2,193]),{46:74,50:$Vd,77:123,103:$Ve,109:134,141:355,143:356,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,300:357},o($V2,[2,202]),o($V2,[2,406]),o($V2,[2,210]),o($V2,[2,217]),{46:74,50:$Vd,103:$Ve,109:358,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},o($V71,[2,828]),o($Vt,[2,823]),o($VQ1,[2,869],{426:359,427:360,216:[1,361]}),o($VG1,[2,1004]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:363,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,461:362,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o([71,168,172,216,217,226,231,251,259],[2,859],{75:[1,364]}),o($VR1,[2,862]),o($VR1,[2,696]),o($VR1,[2,698],{349:365,439:366,201:$VS1,215:$VT1,221:$VU1,224:$VV1,225:$VW1,232:$VX1,236:$VY1,241:$VZ1}),o($VR1,[2,699]),o($V_1,$V81,{176:41,46:74,262:170,265:171,109:207,20:208,352:375,23:$VB,24:$VC,50:$Vd,103:$Ve,133:$Vf1,177:$Vf,178:$Vg,179:$Vh,193:$Vq}),o($V_1,$V81,{176:41,46:74,262:170,265:171,109:207,20:208,352:376,23:$VB,24:$VC,50:$Vd,103:$Ve,133:$Vf1,177:$Vf,178:$Vg,179:$Vh,193:$Vq}),o($V$1,[2,710]),o($V$1,[2,712]),{86:[1,377],206:[1,380],211:[1,379],250:[1,378]},o($VH1,[2,695]),o($V02,[2,535],{314:206,65:$Va1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($V02,[2,536],{314:206,65:$Va1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($V02,[2,537],{314:206,65:$Va1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($V02,[2,538],{314:206,65:$Va1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),{69:[1,381]},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:382,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vq1,[2,551]),o($VL1,$VM1,{176:41,46:74,308:99,280:107,323:108,325:110,326:111,334:112,300:113,463:118,465:119,467:120,332:121,336:122,77:123,473:124,474:125,475:126,338:129,339:130,262:131,265:132,340:133,109:134,479:135,359:313,311:383,312:384,128:385,23:$VB,24:$VC,50:$Vd,69:$VD,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,149:$VI,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41}),{40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,313:[1,386],314:206},o($V12,[2,545],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($V12,[2,546],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VK1,[2,547],{314:206,65:$Va1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VK1,[2,548],{314:206,65:$Va1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VK1,[2,549],{314:206,65:$Va1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($VI1,[2,743]),o($VI1,[2,744]),o($VK1,[2,1117],{314:206}),o($VK1,[2,1118],{314:206}),o($VK1,[2,1119],{314:206}),{71:[1,387]},{20:208,23:$VB,24:$VC,46:74,50:$Vd,71:$V81,103:$Ve,109:207,133:$Vf1,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,262:170,265:171,352:388},{135:396,174:22,362:389,364:390,366:391,368:392,370:393,372:394,374:395,401:21,406:$Vb,419:$Vc},o($Vq1,[2,534]),o($Vq1,[2,553]),o($Vq1,[2,1126]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:397,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VN1,[2,1142]),{40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,247:[1,398],314:206},o($Vq1,[2,1084]),{71:[1,399],75:$V22},o($V32,[2,1089],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($Vu1,[2,668]),o($Vw1,[2,495]),o($Vq1,[2,1105]),o($Vq1,[2,1106]),o($V42,[2,755],{377:401,382:402,115:[1,403]}),{233:[2,1059]},{71:[1,404],75:$V22},{40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,133:[1,405],182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,314:206},o($Vq1,[2,1069]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,71:[1,406],77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:322,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135,480:407},{71:[1,408]},o($Vx1,[2,1049]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:322,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135,480:409},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:410,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vx1,[2,1055]),o($Vq1,[2,682]),{252:[1,411]},o($Vq1,[2,685]),o($VP1,[2,392]),o($VP1,[2,395]),{71:[1,412]},{69:$V52,159:413,160:414},o([19,71,75,85,86,99,133,168,172],[2,15]),o($V2,[2,48]),o($VL1,[2,182],{134:416}),{117:417,119:[1,418]},o($VC1,[2,58]),{71:[1,419],75:[1,420]},o($V32,[2,64]),{78:421,87:422,88:423,89:424,90:425,91:426,92:427,93:428,97:$V62,102:$V72,103:$V82,195:$V92,196:$Va2,199:$Vb2,204:$Vc2,207:$Vd2,212:$Ve2,222:$Vf2,242:$Vg2,245:$Vh2,248:$Vi2,249:$Vj2,256:$Vk2},o($VD1,[2,463]),{133:[1,444]},{71:[1,445],75:[1,446]},o($V32,$Vz1,{18:257,17:447,19:$VA1}),o($Vl2,[2,491],{184:[1,448]}),o($VF1,[2,458]),o($Vm2,[2,898],{435:449,436:450,217:[1,451]}),o($VQ1,[2,870]),{116:[1,452]},o($VG1,[2,1005]),o($VG1,[2,1008],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),{46:74,50:$Vd,66:288,69:$Vr1,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,310:289,341:453,342:283,345:284,346:285,351:286,353:287},o($VR1,[2,702],{439:454,201:$VS1,215:$VT1,221:$VU1,224:$VV1,225:$VW1,232:$VX1,236:$VY1,241:$VZ1}),{46:74,50:$Vd,66:288,69:$Vr1,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,310:289,345:455,351:286,353:287},{224:[1,456]},{224:[1,457],232:[1,458]},{224:[1,459]},o($Vn2,[2,923]),{221:[1,460],224:[1,461],232:[1,462],241:[1,463]},{224:[1,464]},{221:[1,465],224:[1,466],232:[1,467],241:[1,468]},{224:[1,469]},o($V_1,[2,705]),o($V_1,[2,706]),o($Vq1,[2,529]),o($Vq1,[2,530]),o($Vq1,[2,531]),{214:[1,470]},o($VL1,$VM1,{176:41,46:74,308:99,280:107,323:108,325:110,326:111,334:112,300:113,463:118,465:119,467:120,332:121,336:122,77:123,473:124,474:125,475:126,338:129,339:130,262:131,265:132,340:133,109:134,479:135,359:313,128:385,311:471,312:472,23:$VB,24:$VC,50:$Vd,69:$VD,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,149:$VI,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41}),{40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,313:[1,473],314:206},{71:[1,474]},{71:[1,475],75:$Vo2},o($Vp2,[2,641],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:477,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vq2,[2,720]),{71:[1,478]},{71:[2,724]},{71:[2,726]},{71:[2,728]},{71:[2,730]},{71:[2,732]},{71:[2,734]},{71:[2,736]},{71:[2,738]},{40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,209:[1,479],220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,314:206},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:480,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vq1,[2,1085]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:481,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{71:[2,761],231:$Vr2,378:482,383:483},o($V42,[2,756]),{116:[1,485]},{233:[2,1060]},{87:486,195:$V92,196:$Va2,199:$Vb2,204:$Vc2,207:$Vd2,212:$Ve2,222:$Vf2,242:$Vg2,245:$Vh2,248:$Vi2,249:$Vj2,256:$Vk2},o($Vx1,[2,1035]),{71:[1,487],75:$V22},o($Vx1,[2,1048]),{71:[1,488],75:$V22},{40:$V91,65:$Va1,71:[1,489],85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,314:206},o($Vq1,[2,686]),o($V61,[2,855]),o($V2,[2,235],{75:[1,490]}),o($Vs2,[2,241]),{23:$VB,24:$VC,46:74,50:$Vd,77:123,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,149:$VI,161:491,176:41,177:$Vf,178:$Vg,179:$Vh,184:$VM,188:$VO,192:$VP,193:$Vq,198:$VR,200:$VS,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:492,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{135:493,174:22,401:21,406:$Vb,419:$Vc},o($VB1,[2,142]),{69:[1,495],120:494},o($VC1,[2,62]),{46:74,50:$Vd,74:496,77:352,103:$Ve,109:134,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},o($V32,[2,78],{79:497,82:498,83:499,18:502,19:$VA1,85:$Vt2,86:$Vu2}),o($Vv2,[2,90]),o($Vv2,[2,91]),o($Vv2,[2,92]),o($Vv2,[2,93]),o($Vv2,[2,94]),o($Vv2,[2,95]),o($Vv2,[2,96]),o($Vv2,[2,507]),o($Vv2,[2,508]),o($Vv2,$Vw2,{306:503,69:$Vx2}),o($Vv2,[2,521],{307:505,69:[1,506]}),o($Vv2,[2,511]),o($Vv2,[2,512]),o($Vv2,[2,513]),o($Vv2,[2,514]),o($Vv2,[2,515]),o($Vv2,[2,516]),o($Vv2,[2,517]),o($Vv2,$Vw2,{306:507,69:$Vx2}),{98:[1,508]},{98:[1,509]},{98:[1,510]},{135:511,174:22,401:21,406:$Vb,419:$Vc},o($VE1,[2,194]),{46:74,50:$Vd,77:123,103:$Ve,109:134,143:512,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,300:357},o($V32,[2,196]),{46:74,50:$Vd,77:324,103:$Ve,109:134,176:41,177:$Vf,178:$Vg,179:$Vh,182:[1,513],193:$Vq},o($Vy2,[2,961],{448:514,383:515,231:$Vr2}),o($Vm2,[2,899]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:516,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:518,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,428:517,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VR1,[2,863]),{46:74,50:$Vd,66:288,69:$Vr1,103:$Ve,109:185,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,310:289,345:519,351:286,353:287},o($Vz2,$VA2,{440:520,229:$VB2}),o($Vn2,[2,919]),o($Vn2,[2,920]),{224:[1,522]},o($Vn2,[2,922]),{224:[1,523]},o($Vn2,[2,925]),{224:[1,524]},{224:[1,525]},o($Vn2,[2,928]),{224:[1,526]},o($Vn2,[2,930]),{224:[1,527]},{224:[1,528]},o($Vn2,[2,933]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:529,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{71:[1,530]},{71:[1,531],75:$Vo2},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:532,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vq1,[2,541]),o($Vq1,[2,542]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:533,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o([23,24,50,71,75,103,119,133,168,172,177,178,179,189,191,193,194,201,205,208,209,214,215,216,217,221,224,225,226,230,231,232,236,239,241,247,251,258,259,313],[2,544],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($Vq2,[2,721]),o($Vq1,[2,1127]),o($VN1,[2,1148],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($V32,[2,1090],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),{71:[1,534]},{71:[2,766],119:[1,539],239:[1,538],384:535,387:536,388:537},{116:[1,540]},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:385,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,312:541,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{71:[1,542]},o($Vx1,[2,1036]),o($Vx1,[2,1050]),o($Vx1,[2,1054]),{69:$V52,160:543},{71:[1,544],75:[1,545]},o($V32,[2,654]),o($V2,[2,179]),{69:[1,547],121:546},{46:74,50:$Vd,77:549,103:$Ve,109:134,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq,290:548},o($V32,[2,65]),o($V32,[2,74]),o($V32,[2,79],{18:502,83:550,19:$VA1,85:$Vt2,86:$Vu2}),o($VC2,[2,80]),{86:[1,551]},o($VC2,[2,87]),o($VC2,[2,88]),o($Vv2,[2,509]),{252:[1,552]},o($Vv2,[2,510]),{252:[1,553]},o($Vv2,[2,518]),{78:554,87:422,88:423,89:424,90:425,91:426,92:427,93:428,97:$V62,99:[1,555],102:$V72,103:$V82,195:$V92,196:$Va2,199:$Vb2,204:$Vc2,207:$Vd2,212:$Ve2,222:$Vf2,242:$Vg2,245:$Vh2,248:$Vi2,249:$Vj2,256:$Vk2},{87:556,99:[1,557],195:$V92,196:$Va2,199:$Vb2,204:$Vc2,207:$Vd2,212:$Ve2,222:$Vf2,242:$Vg2,245:$Vh2,248:$Vi2,249:$Vj2,256:$Vk2},{46:74,50:$Vd,99:[1,559],103:$Ve,104:558,106:560,109:561,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},o($V2,[2,183]),o($V32,$Vz1,{18:257,17:562,19:$VA1}),o($Vl2,[2,492]),o($Vt,[2,954],{445:563,446:564,226:[1,565]}),o($Vy2,[2,962]),o($Vm2,[2,900],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($VQ1,[2,871],{75:[1,566]}),o($VD2,[2,886],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($Vz2,$VA2,{440:567,229:$VB2}),o($Vz2,[2,906]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:568,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vn2,[2,921]),o($Vn2,[2,924]),o($Vn2,[2,926]),o($Vn2,[2,927]),o($Vn2,[2,929]),o($Vn2,[2,931]),o($Vn2,[2,932]),o($VK1,[2,532],{314:206}),o($Vq1,[2,539]),o($Vq1,[2,540]),o($VJ1,[2,543],{314:206,40:$V91,65:$Va1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,190:$Vj1,220:$Vl1,223:$Vm1,235:$Vo1,237:$Vp1}),o($Vp2,[2,642],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($Vq1,[2,750]),{71:[2,762]},{71:[2,767]},{194:[1,569],392:[1,570]},o($VE2,[2,784]),o($VE2,[2,785]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:573,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,449:571,451:572,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($V42,[2,757],{75:$Vo2}),o($Vq1,[2,1068]),o($Vs2,[2,242]),o($Vs2,[2,243]),{23:$VB,24:$VC,46:74,50:$Vd,77:123,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,184:$VM,188:$VO,192:$VP,193:$Vq,198:$VR,200:$VS,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:574,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VB1,[2,146]),{115:$VF2,124:575,126:576},{71:[1,578],75:[1,579]},o($V32,[2,450]),o($VC2,[2,81]),o($VC2,[2,86]),{71:[1,580]},{71:[1,581],75:[1,582]},{99:[1,583]},o($Vv2,[2,101]),{75:[1,584]},o($Vv2,[2,105]),{75:[1,586],99:[1,585]},o($Vv2,[2,111]),o($VG2,[2,113]),{110:[1,587]},o($V32,[2,197]),o($Vt,[2,979]),o($Vt,[2,955]),{179:[1,589],184:$VM,252:$V01,253:$V11,332:588,338:129,339:130},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:590,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($Vz2,[2,907]),o($Vz2,[2,949],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($VH2,$VI2,{389:591}),o($VH2,$VI2,{389:592}),o([71,119,168,172,226,239,251],[2,963],{75:[1,593]}),o($VJ2,[2,966]),o($VJ2,[2,976],{314:206,453:594,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,191:[1,595],194:$Vk1,205:[1,596],220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($V32,[2,655]),{71:[1,597],75:[1,598]},o($V32,[2,155]),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:599,130:[1,600],149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{69:[2,447]},{46:74,50:$Vd,77:601,103:$Ve,109:134,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},o($Vv2,[2,520]),o($Vv2,[2,522]),{252:[1,602]},o($Vv2,[2,100]),{78:603,87:422,88:423,89:424,90:425,91:426,92:427,93:428,97:$V62,102:$V72,103:$V82,195:$V92,196:$Va2,199:$Vb2,204:$Vc2,207:$Vd2,212:$Ve2,222:$Vf2,242:$Vg2,245:$Vh2,248:$Vi2,249:$Vj2,256:$Vk2},o($Vv2,[2,110]),{46:74,50:$Vd,103:$Ve,106:604,109:561,176:41,177:$Vf,178:$Vg,179:$Vh,193:$Vq},{78:605,87:422,88:423,89:424,90:425,91:426,92:427,93:428,97:$V62,102:$V72,103:$V82,195:$V92,196:$Va2,199:$Vb2,204:$Vc2,207:$Vd2,212:$Ve2,222:$Vf2,242:$Vg2,245:$Vh2,248:$Vi2,249:$Vj2,256:$Vk2},o($Vt,[2,956],{75:[1,606]}),o($Vt,[2,958],{75:[1,607]}),o($VD2,[2,887],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),o($VK2,$VL2,{390:608,400:609,202:$VM2,252:$VN2,392:$VO2}),o($VK2,$VL2,{400:609,390:613,202:$VM2,252:$VN2,392:$VO2}),{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:573,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,451:614,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VJ2,[2,973]),o($VJ2,[2,977]),o($VJ2,[2,978]),o($VB1,[2,152]),{115:$VF2,126:615},{40:$V91,65:$Va1,85:$Vb1,98:[1,617],99:$Vd1,129:616,132:[1,618],182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1,314:206},{98:$VP2,129:619,132:$VQ2},o($V32,[2,451]),{71:[1,622]},{99:[1,623]},o($VG2,[2,114]),o($VG2,$Vz1,{18:257,17:624,19:$VA1}),{184:$VM,252:$V01,253:$V11,332:625,338:129,339:130},{179:[1,626]},{71:$VR2,189:$VS2,391:627},{234:[1,629]},{238:[1,630]},o($VT2,[2,797]),o($VT2,[2,798]),{71:$VR2,189:$VS2,391:631},o($VJ2,[2,967]),o($V32,[2,156]),{130:[1,632]},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:293,130:$VU2,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:295,130:$VV2,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:633,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},o($VO1,$VU2),o($VO1,$VV2),o($Vv2,[2,523]),o($Vv2,[2,104]),o($VG2,[2,120]),o($Vt,[2,957]),o($Vt,[2,959]),{71:[2,768]},{202:[1,634],252:$VN2,392:$VO2,400:635},o($VK2,[2,787]),o($VK2,[2,788]),{71:[2,769]},o($V32,[2,164],{129:636,98:$VP2,132:$VQ2}),o($V32,[2,163],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1}),{238:[1,637]},{213:[1,638]},{23:$VB,24:$VC,46:74,50:$Vd,69:$VD,77:123,85:$VE,86:$VF,97:$VG,102:$VH,103:$Ve,109:134,128:639,149:$VI,176:41,177:$Vf,178:$Vg,179:$Vh,181:$VJ,183:$VL,184:$VM,187:$VN,188:$VO,192:$VP,193:$Vq,197:$VQ,198:$VR,200:$VS,210:$VT,211:$VU,219:$VV,227:$VW,228:$VX,243:$VY,244:$VZ,246:$V_,250:$V$,252:$V01,253:$V11,254:$V21,255:$V31,257:$V41,262:131,265:132,280:107,300:113,308:99,323:108,325:110,326:111,332:121,334:112,336:122,338:129,339:130,340:133,463:118,465:119,467:120,473:124,474:125,475:126,479:135},{71:[2,792]},{71:[2,793]},o($V32,[2,162],{314:206,40:$V91,65:$Va1,85:$Vb1,98:$Vc1,99:$Vd1,132:$Ve1,182:$Vg1,183:$Vh1,189:$Vi1,190:$Vj1,194:$Vk1,220:$Vl1,223:$Vm1,230:$Vn1,235:$Vo1,237:$Vp1})],
defaultActions: {30:[2,250],114:[2,1064],115:[2,1065],116:[2,1066],117:[2,1067],145:[2,1040],146:[2,1041],147:[2,1042],148:[2,1043],149:[2,1044],150:[2,1045],151:[2,1046],152:[2,1047],328:[2,1059],389:[2,724],390:[2,726],391:[2,728],392:[2,730],393:[2,732],394:[2,734],395:[2,736],396:[2,738],404:[2,1060],535:[2,762],536:[2,767],578:[2,447],627:[2,768],631:[2,769],637:[2,792],638:[2,793]},
parseError: function parseError (str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
    }
},
parse: function parse (input) {
    var self = this,
        stack = [0],
        tstack = [], // token stack
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    var args = lstack.slice.call(arguments, 1);

    //this.reductionCount = this.shiftCount = 0;

    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    // copy state
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }

    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);

    var ranges = lexer.options && lexer.options.ranges;

    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }

    function popStack (n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

_token_stack:
    var lex = function () {
        var token;
        token = lexer.lex() || EOF;
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length - 1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

_handle_error:
        // handle parse error
        if (typeof action === 'undefined' || !action.length || !action[0]) {
            var error_rule_depth;
            var errStr = '';

            // Return the rule stack depth where the nearest error rule can be found.
            // Return FALSE when no error recovery rule was found.
            function locateNearestErrorRecoveryRule(state) {
                var stack_probe = stack.length - 1;
                var depth = 0;

                // try to recover from error
                for(;;) {
                    // check for error recovery rule in this state
                    if ((TERROR.toString()) in table[state]) {
                        return depth;
                    }
                    if (state === 0 || stack_probe < 2) {
                        return false; // No suitable error recovery rule available.
                    }
                    stack_probe -= 2; // popStack(1): [symbol, action]
                    state = stack[stack_probe];
                    ++depth;
                }
            }

            if (!recovering) {
                // first see if there's any chance at hitting an error recovery rule:
                error_rule_depth = locateNearestErrorRecoveryRule(state);

                // Report error
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push("'"+this.terminals_[p]+"'");
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol)+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == EOF ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: lexer.yylloc,
                    ruleId: stack.slice(stack.length - 2, stack.length).join('_'),
                    expected: expected,
                    recoverable: (error_rule_depth !== false)
                });
            } else if (preErrorSymbol !== EOF) {
                error_rule_depth = locateNearestErrorRecoveryRule(state);
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol === EOF || preErrorSymbol === EOF) {
                    throw new Error(errStr || 'Parsing halted while starting to recover from another error.');
                }

                // discard current lookahead and grab another
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            if (error_rule_depth === false) {
                throw new Error(errStr || 'Parsing halted. No suitable error recovery rule available.');
            }
            popStack(error_rule_depth);

            preErrorSymbol = (symbol == TERROR ? null : symbol); // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {
            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(lexer.yytext);
                lstack.push(lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = lexer.yyleng;
                    yytext = lexer.yytext;
                    yylineno = lexer.yylineno;
                    yyloc = lexer.yylloc;
                    if (recovering > 0) {
                        recovering--;
                    }
                } else {
                    // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2:
                // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                if (ranges) {
                  yyval._$.range = [lstack[lstack.length-(len||1)].range[0], lstack[lstack.length-1].range[1]];
                }
                r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3:
                // accept
                return true;
        }

    }

    return true;
}};


SqlParseSupport.initSyntaxParser(parser);/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function(match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex () {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin (condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState () {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules () {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState (n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState (condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {"case-insensitive":true,"flex":true},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: /* skip whitespace */ 
break;
case 1: /* skip comments */ 
break;
case 2: /* skip comments */ 
break;
case 3: parser.yy.partialCursor = false; parser.yy.cursorFound = yy_.yylloc; return 5; 
break;
case 4: parser.yy.partialCursor = true; parser.yy.cursorFound = yy_.yylloc; return 260; 
break;
case 5: this.popState(); return 313; 
break;
case 6: return 'ADVANCE'; 
break;
case 7: return 'ANALYZE'; 
break;
case 8: return 189; 
break;
case 9: return 97; 
break;
case 10: return 133; 
break;
case 11: return 'AT'; 
break;
case 12: return 'BEGINNING' 
break;
case 13: this.begin('between'); return 194; 
break;
case 14: return 195; 
break;
case 15: return 196; 
break;
case 16: return 116; 
break;
case 17: return 197; 
break;
case 18: return 198; 
break;
case 19: return 'CATALOG'; 
break;
case 20: return 'CHANGES'; 
break;
case 21: return 'COLUMN'; 
break;
case 22: return 'COLUMNS'; 
break;
case 23: return 'CONNECTOR'; 
break;
case 24: return 'CONNECTORS'; 
break;
case 25: parser.determineCase(yy_.yytext); return 4; 
break;
case 26: return 'DATE'; 
break;
case 27: return 'DAY'; 
break;
case 28: return 204; 
break;
case 29: return 'DELETE'; 
break;
case 30: return 'DESCRIBE'; 
break;
case 31: return 206; 
break;
case 32: return 207; 
break;
case 33: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('DROP', yy_.yylloc, yy.lexer.upcomingInput()); return 9; 
break;
case 34: return 208; 
break;
case 35: return 'EMIT'; 
break;
case 36: return 209; 
break;
case 37: parser.yy.correlatedSubQuery = true; return 210; 
break;
case 38: parser.determineCase(yy_.yytext); return 'EXPLAIN'; 
break;
case 39: return 'EXPORT'; 
break;
case 40: return 'EXTENDED'; 
break;
case 41: parser.determineCase(yy_.yytext); return 214; 
break;
case 42: return 215; 
break;
case 43: return 'FUNCTION'; 
break;
case 44: return 'FUNCTIONS'; 
break;
case 45: return 216; 
break;
case 46: return 217; 
break;
case 47: return 'HOPPING'; 
break;
case 48: return 'HOUR'; 
break;
case 49: return 'HOURS'; 
break;
case 50: return 219; 
break;
case 51: return 220; 
break;
case 52: return 221; 
break;
case 53: return 156; 
break;
case 54: return 222; 
break;
case 55: return 'INTEGER'; 
break;
case 56: return 157; 
break;
case 57: return 223; 
break;
case 58: return 224; 
break;
case 59: return 'KEY'; 
break;
case 60: return 225; 
break;
case 61: return 65; 
break;
case 62: return 226; 
break;
case 63: return 36; 
break;
case 64: return 'LOAD'; 
break;
case 65: return 102; 
break;
case 66: return 'MILLISECOND'; 
break;
case 67: return 'MILLISECONDS'; 
break;
case 68: return 'MINUTE'; 
break;
case 69: return 'MINUTES'; 
break;
case 70: return 'MONTH'; 
break;
case 71: return 'MONTHS'; 
break;
case 72: return 85; 
break;
case 73: return 86; 
break;
case 74: return 229; 
break;
case 75: return 230; 
break;
case 76: return 232; 
break;
case 77: return 115; 
break;
case 78: return 'PARTITIONS'; 
break;
case 79: return 'PRINT'; 
break;
case 80: return 485; 
break;
case 81: return 484; 
break;
case 82: return 'QUERY'; 
break;
case 83: return 'RENAME'; 
break;
case 84: return 'RESET'; 
break;
case 85: return 236; 
break;
case 86: return 'RUN'; 
break;
case 87: return 'SAMPLE'; 
break;
case 88: return 'SCRIPT'; 
break;
case 89: return 'SECOND'; 
break;
case 90: return 'SECOND'; 
break;
case 91: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SELECT', yy_.yylloc); return 406; 
break;
case 92: return 'SESSION'; 
break;
case 93: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SET', yy_.yylloc); return 15; 
break;
case 94: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SHOW', yy_.yylloc); return 42; 
break;
case 95: return 'SINK'; 
break;
case 96: return 'SOURCE'; 
break;
case 97: return 'STREAM'; 
break;
case 98: return 163; 
break;
case 99: return 245; 
break;
case 100: return 103; 
break;
case 101: return 51; 
break;
case 102: return 162; 
break;
case 103: return 'TERMINATE'; 
break;
case 104: return 247; 
break;
case 105: return 'TIME'; 
break;
case 106: return 248; 
break;
case 107: return 'TO'; 
break;
case 108: return 250; 
break;
case 109: return 'TOPIC'; 
break;
case 110: return 164; 
break;
case 111: return 'TUMBLING'; 
break;
case 112: return 'TYPE'; 
break;
case 113: return 'TYPES'; 
break;
case 114: return 'UNSET'; 
break;
case 115: return 130; 
break;
case 116: return 256; 
break;
case 117: return 258; 
break;
case 118: return 259; 
break;
case 119: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('WITH', yy_.yylloc); return 419; 
break;
case 120: return 'WITHIN'; 
break;
case 121: return 'YEAR'; 
break;
case 122: return 'YEARS'; 
break;
case 123: return 'ZONE'; 
break;
case 124: yy.lexer.unput('('); yy_.yytext = 'abs'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'ABS'; 
break;
case 125: yy.lexer.unput('('); yy_.yytext = 'arraycontains'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'ARRAYCONTAINS'; 
break;
case 126: yy.lexer.unput('('); yy_.yytext = 'ceil'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'CEIL'; 
break;
case 127: yy.lexer.unput('('); yy_.yytext = 'concat'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'CONCAT'; 
break;
case 128: yy.lexer.unput('('); yy_.yytext = 'datetostring'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'DATETOSTRING'; 
break;
case 129: yy.lexer.unput('('); yy_.yytext = 'elt'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'ELT'; 
break;
case 130: yy.lexer.unput('('); yy_.yytext = 'extractjsonfield'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'EXTRACTJSONFIELD'; 
break;
case 131: yy.lexer.unput('('); yy_.yytext = 'field'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'FIELD'; 
break;
case 132: yy.lexer.unput('('); yy_.yytext = 'floor'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'FLOOR'; 
break;
case 133: yy.lexer.unput('('); yy_.yytext = 'geo_distance'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'GEO_DISTANCE'; 
break;
case 134: yy.lexer.unput('('); yy_.yytext = 'ifnull'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'IFNULL'; 
break;
case 135: yy.lexer.unput('('); yy_.yytext = 'lcase'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'LCASE'; 
break;
case 136: yy.lexer.unput('('); yy_.yytext = 'len'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'LEN'; 
break;
case 137: yy.lexer.unput('('); yy_.yytext = 'msk'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'MASK'; 
break;
case 138: yy.lexer.unput('('); yy_.yytext = 'mask_keep_left'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'MASK_KEEP_LEFT'; 
break;
case 139: yy.lexer.unput('('); yy_.yytext = 'mask_keep_right'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'MASK_KEEP_RIGHT'; 
break;
case 140: yy.lexer.unput('('); yy_.yytext = 'mask_left'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'MASK_LEFT'; 
break;
case 141: yy.lexer.unput('('); yy_.yytext = 'mask_right'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'MASK_RIGHT'; 
break;
case 142: yy.lexer.unput('('); yy_.yytext = 'random'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'RANDOM'; 
break;
case 143: yy.lexer.unput('('); yy_.yytext = 'round'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'ROUND'; 
break;
case 144: yy.lexer.unput('('); yy_.yytext = 'split'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'SPLIT'; 
break;
case 145: yy.lexer.unput('('); yy_.yytext = 'stringtodate'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'STRINGTODATE'; 
break;
case 146: yy.lexer.unput('('); yy_.yytext = 'stringtotimestamp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'STRINGTOTIMESTAMP'; 
break;
case 147: yy.lexer.unput('('); yy_.yytext = 'substring'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'SUBSTRING'; 
break;
case 148: yy.lexer.unput('('); yy_.yytext = 'timestamptostring'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'TIMESTAMPTOSTRING'; 
break;
case 149: yy.lexer.unput('('); yy_.yytext = 'trim'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'TRIM'; 
break;
case 150: yy.lexer.unput('('); yy_.yytext = 'ucase'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'UCASE'; 
break;
case 151: yy.lexer.unput('('); yy_.yytext = 'url_decode_param'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_DECODE_PARAM'; 
break;
case 152: yy.lexer.unput('('); yy_.yytext = 'urel_encode_param'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_ENCODE_PARAM'; 
break;
case 153: yy.lexer.unput('('); yy_.yytext = 'url_extract_fragment'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_FRAGMENT'; 
break;
case 154: yy.lexer.unput('('); yy_.yytext = 'url_extract_host'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_HOST'; 
break;
case 155: yy.lexer.unput('('); yy_.yytext = 'url_extract_parameter'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_PARAMETER'; 
break;
case 156: yy.lexer.unput('('); yy_.yytext = 'url_extrct_path'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_PATH'; 
break;
case 157: yy.lexer.unput('('); yy_.yytext = 'url_extract_port'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_PORT'; 
break;
case 158: yy.lexer.unput('('); yy_.yytext = 'url_extract_protocol'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_PROTOCOL'; 
break;
case 159: yy.lexer.unput('('); yy_.yytext = 'url_extract_query'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'URL_EXTRACT_QUERY'; 
break;
case 160: yy.lexer.unput('('); yy_.yytext = 'collect_list'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'COLLECT_LIST'; 
break;
case 161: yy.lexer.unput('('); yy_.yytext = 'collect_set'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'COLLECT_SET'; 
break;
case 162: yy.lexer.unput('('); yy_.yytext = 'count'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 200; 
break;
case 163: yy.lexer.unput('('); yy_.yytext = 'historgram'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'HISTOGRAM'; 
break;
case 164: yy.lexer.unput('('); yy_.yytext = 'max'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 227; 
break;
case 165: yy.lexer.unput('('); yy_.yytext = 'min'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 228; 
break;
case 166: yy.lexer.unput('('); yy_.yytext = 'sum'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 246; 
break;
case 167: yy.lexer.unput('('); yy_.yytext = 'topk'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'TOPK'; 
break;
case 168: yy.lexer.unput('('); yy_.yytext = 'topkdistinct'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'TOPKDISTINCT'; 
break;
case 169: yy.lexer.unput('('); yy_.yytext = 'windowstart'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'WindowStart'; 
break;
case 170: yy.lexer.unput('('); yy_.yytext = 'windowend'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 'WindowEnd'; 
break;
case 171: return 252; 
break;
case 172: return 252; 
break;
case 173: return 253; 
break;
case 174: return 178; 
break;
case 175: return 189; 
break;
case 176: return 230; 
break;
case 177: return 40; 
break;
case 178: return 98; 
break;
case 179: return 99; 
break;
case 180: return 132; 
break;
case 181: return 132; 
break;
case 182: return 132; 
break;
case 183: return 132; 
break;
case 184: return 132; 
break;
case 185: return 183; 
break;
case 186: return 182; 
break;
case 187: return 190; 
break;
case 188: return 190; 
break;
case 189: return 190; 
break;
case 190: return 190; 
break;
case 191: return 190; 
break;
case 192: return 190; 
break;
case 193: return 75; 
break;
case 194: return 184; 
break;
case 195: return 110; 
break;
case 196: return 172; 
break;
case 197: return 187; 
break;
case 198: return 181; 
break;
case 199: return 69; 
break;
case 200: return 71; 
break;
case 201: return 185; 
break;
case 202: return 186; 
break;
case 203: return 179; 
break;
case 204: this.begin('backtickedValue'); return 193; 
break;
case 205:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '`')) {
                                               return 264;
                                             }
                                             return 25;
                                           
break;
case 206: this.popState(); return 193; 
break;
case 207: this.begin('singleQuotedValue'); return 23; 
break;
case 208:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '\'')) {
                                               return 264;
                                             }
                                             return 25;
                                           
break;
case 209: this.popState(); return 23; 
break;
case 210: this.begin('doubleQuotedValue'); return 24; 
break;
case 211:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '"')) {
                                               return 264;
                                             }
                                             return 25;
                                           
break;
case 212: this.popState(); return 24; 
break;
case 213: return 168; 
break;
case 214: /* To prevent console logging of unknown chars */ 
break;
case 215: 
break;
case 216: 
break;
case 217: 
break;
case 218: 
break;
case 219: 
break;
case 220:console.log(yy_.yytext);
break;
}
},
rules: [/^(?:\s)/i,/^(?:--.*)/i,/^(?:[/][*][^*]*[*]+([^/*][^*]*[*]+)*[/])/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:AND)/i,/^(?:ADVANCE)/i,/^(?:ANALYZE)/i,/^(?:AND)/i,/^(?:ARRAY)/i,/^(?:AS)/i,/^(?:AT)/i,/^(?:BEGINNING)/i,/^(?:BETWEEN)/i,/^(?:BIGINT)/i,/^(?:BOOLEAN)/i,/^(?:BY)/i,/^(?:CASE)/i,/^(?:CAST)/i,/^(?:CATALOG)/i,/^(?:CHANGES)/i,/^(?:COLUMN)/i,/^(?:COLUMNS)/i,/^(?:CONNECTOR)/i,/^(?:CONNECTORS)/i,/^(?:CREATE)/i,/^(?:DATE)/i,/^(?:DAY)/i,/^(?:DECIMAL)/i,/^(?:DELETE)/i,/^(?:DESCRIBE)/i,/^(?:DISTINCT)/i,/^(?:DOUBLE)/i,/^(?:DROP)/i,/^(?:ELSE)/i,/^(?:EMIT)/i,/^(?:END)/i,/^(?:EXISTS)/i,/^(?:EXPLAIN)/i,/^(?:EXPORT)/i,/^(?:EXTENDED)/i,/^(?:FROM)/i,/^(?:FULL)/i,/^(?:FUNCTION)/i,/^(?:FUNCTIONS)/i,/^(?:GROUP)/i,/^(?:HAVING)/i,/^(?:HOPPING)/i,/^(?:HOUR)/i,/^(?:HOURS)/i,/^(?:IF)/i,/^(?:IN)/i,/^(?:INNER)/i,/^(?:INSERT)/i,/^(?:INT)/i,/^(?:INTEGER)/i,/^(?:INTO)/i,/^(?:IS)/i,/^(?:JOIN)/i,/^(?:KEY)/i,/^(?:LEFT)/i,/^(?:LIKE)/i,/^(?:LIMIT)/i,/^(?:LIST)/i,/^(?:LOAD)/i,/^(?:MAP)/i,/^(?:MILLISECOND)/i,/^(?:MILLISECONDS)/i,/^(?:MINUTE)/i,/^(?:MINUTES)/i,/^(?:MONTH)/i,/^(?:MONTHS)/i,/^(?:NOT)/i,/^(?:NULL)/i,/^(?:ON)/i,/^(?:OR)/i,/^(?:OUTER)/i,/^(?:PARTITION)/i,/^(?:PARTITIONS)/i,/^(?:PRINT)/i,/^(?:PROPERTIES)/i,/^(?:QUERIES)/i,/^(?:QUERY)/i,/^(?:RENAME)/i,/^(?:RESET)/i,/^(?:RIGHT)/i,/^(?:RUN)/i,/^(?:SAMPLE)/i,/^(?:SCRIPT)/i,/^(?:SECOND)/i,/^(?:SECOND)/i,/^(?:SELECT)/i,/^(?:SESSION)/i,/^(?:SET)/i,/^(?:SHOW)/i,/^(?:SINK)/i,/^(?:SOURCE)/i,/^(?:STREAM)/i,/^(?:STREAMS)/i,/^(?:STRING)/i,/^(?:STRUCT)/i,/^(?:TABLE)/i,/^(?:TABLES)/i,/^(?:TERMINATE)/i,/^(?:THEN)/i,/^(?:TIME)/i,/^(?:TIMESTAMP)/i,/^(?:TO)/i,/^(?:TRUE)/i,/^(?:TOPIC)/i,/^(?:TOPICS)/i,/^(?:TUMBLING)/i,/^(?:TYPE)/i,/^(?:TYPES)/i,/^(?:UNSET)/i,/^(?:VALUES)/i,/^(?:VARCHAR)/i,/^(?:WHEN)/i,/^(?:WHERE)/i,/^(?:WITH)/i,/^(?:WITHIN)/i,/^(?:YEAR)/i,/^(?:YEARS)/i,/^(?:ZONE)/i,/^(?:ABS\s*\()/i,/^(?:ARRAYCONTAINS\s*\()/i,/^(?:CEIL\s*\()/i,/^(?:CONCAT\s*\()/i,/^(?:DATETOSTRING\s*\()/i,/^(?:ELT\s*\()/i,/^(?:EXTRACTJSONFIELD\s*\()/i,/^(?:FIELD\s*\()/i,/^(?:FLOOR\s*\()/i,/^(?:GEO_DISTANCE\s*\()/i,/^(?:IFNULL\s*\()/i,/^(?:LCASE\s*\()/i,/^(?:LEN\s*\()/i,/^(?:MASK\s*\()/i,/^(?:MASK_KEEP_LEFT\s*\()/i,/^(?:MASK_KEEP_RIGHT\s*\()/i,/^(?:MASK_LEFT\s*\()/i,/^(?:MASK_RIGHT\s*\()/i,/^(?:RANDOM\s*\()/i,/^(?:ROUND\s*\()/i,/^(?:SPLIT\s*\()/i,/^(?:STRINGTODATE\s*\()/i,/^(?:STRINGTOTIMESTAMP\s*\()/i,/^(?:SUBSTRING\s*\()/i,/^(?:TIMESTAMPTOSTRING\s*\()/i,/^(?:TRIM\s*\()/i,/^(?:UCASE\s*\()/i,/^(?:URL_DECODE_PARAM\s*\()/i,/^(?:URL_ENCODE_PARAM\s*\()/i,/^(?:URL_EXTRACT_FRAGMENT\s*\()/i,/^(?:URL_EXTRACT_HOST\s*\()/i,/^(?:URL_EXTRACT_PARAMETER\s*\()/i,/^(?:URL_EXTRACT_PATH\s*\()/i,/^(?:URL_EXTRACT_PORT\s*\()/i,/^(?:URL_EXTRACT_PROTOCOL\s*\()/i,/^(?:URL_EXTRACT_QUERY\s*\()/i,/^(?:COLLECT_LIST\s*\()/i,/^(?:COLLECT_SET\s*\()/i,/^(?:COUNT\s*\()/i,/^(?:HISTOGRAM\s*\()/i,/^(?:MAX\s*\()/i,/^(?:MIN\s*\()/i,/^(?:SUM\s*\()/i,/^(?:TOPK\s*\()/i,/^(?:TOPKDISTINCT\s*\()/i,/^(?:WindowStart\s*\()/i,/^(?:WindowEnd\s*\()/i,/^(?:[0-9]+)/i,/^(?:[0-9]+(?:[YSL]|BD)?)/i,/^(?:[0-9]+E)/i,/^(?:[A-Za-z0-9_]+)/i,/^(?:&&)/i,/^(?:\|\|)/i,/^(?:=)/i,/^(?:<)/i,/^(?:>)/i,/^(?:!=)/i,/^(?:<=)/i,/^(?:>=)/i,/^(?:<>)/i,/^(?:<=>)/i,/^(?:-)/i,/^(?:\*)/i,/^(?:\+)/i,/^(?:\/)/i,/^(?:%)/i,/^(?:\|)/i,/^(?:\^)/i,/^(?:&)/i,/^(?:,)/i,/^(?:\.)/i,/^(?::)/i,/^(?:;)/i,/^(?:~)/i,/^(?:!)/i,/^(?:\()/i,/^(?:\))/i,/^(?:\[)/i,/^(?:\])/i,/^(?:\$\{[^}]*\})/i,/^(?:`)/i,/^(?:[^`]+)/i,/^(?:`)/i,/^(?:')/i,/^(?:(?:\\\\|\\[']|[^'])+)/i,/^(?:')/i,/^(?:")/i,/^(?:(?:\\\\|\\["]|[^"])+)/i,/^(?:")/i,/^(?:$)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i],
conditions: {"hdfs":{"rules":[216],"inclusive":false},"doubleQuotedValue":{"rules":[211,212,219],"inclusive":false},"singleQuotedValue":{"rules":[208,209,218],"inclusive":false},"backtickedValue":{"rules":[205,206,217],"inclusive":false},"between":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,207,210,213,214,215,220],"inclusive":true},"INITIAL":{"rules":[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,207,210,213,214,220],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
export default ksqlSyntaxParser;
