// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/* parser generated by jison 0.4.17 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
import SqlParseSupport from 'parse/sql/flink/sqlParseSupport';

var flinkSyntaxParser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[4,8,12,16,38,167,179,246,276,326,342,345,349,514],$V1=[2,628],$V2=[345,349],$V3=[2,629],$V4=[1,38],$V5=[1,29],$V6=[1,30],$V7=[1,18],$V8=[1,21],$V9=[1,39],$Va=[1,36],$Vb=[1,37],$Vc=[1,31],$Vd=[1,35],$Ve=[1,32],$Vf=[1,33],$Vg=[1,48],$Vh=[1,50],$Vi=[1,46],$Vj=[1,49],$Vk=[1,45],$Vl=[86,345,349],$Vm=[2,455],$Vn=[1,63],$Vo=[1,71],$Vp=[1,72],$Vq=[1,82],$Vr=[2,417],$Vs=[1,92],$Vt=[1,93],$Vu=[34,272],$Vv=[16,34,48,55,59,60,68,82,84,86,90,100,112,113,114,117,118,125,130,134,145,147,159,187,195,206,219,220,221,222,223,224,225,226,227,231,233,237,244,245,258,267,269,272,345,349,353,354,357,361,362,363,364,365,366,368,371,372,373,374,376,379,380,381,382,384,385,387,389,390,391,392,393,396,397,410,444],$Vw=[86,267,345,349],$Vx=[68,118,233,345,349,353,354],$Vy=[2,785],$Vz=[1,109],$VA=[68,118,233,353,354,363],$VB=[68,118,233,311,345,349,353,354,363],$VC=[2,782],$VD=[1,114],$VE=[2,832],$VF=[16,68,118,233,353,354,363],$VG=[84,90,246],$VH=[1,181],$VI=[1,182],$VJ=[1,137],$VK=[1,132],$VL=[1,143],$VM=[1,145],$VN=[1,147],$VO=[1,130],$VP=[1,179],$VQ=[1,183],$VR=[1,184],$VS=[1,148],$VT=[1,170],$VU=[1,171],$VV=[1,172],$VW=[1,173],$VX=[1,174],$VY=[1,175],$VZ=[1,176],$V_=[1,177],$V$=[1,163],$V01=[1,164],$V11=[1,157],$V21=[1,146],$V31=[1,158],$V41=[1,133],$V51=[1,135],$V61=[1,134],$V71=[1,138],$V81=[1,136],$V91=[1,178],$Va1=[1,180],$Vb1=[59,60,68,84,86,100,101,112,117,118,233,246,258,272,274,275,276,299,300,301,302,303,304,305,306,307,308,309,311,312,353,354,356,357,360,363,367,375,394,395],$Vc1=[86,90,187,267,345,349],$Vd1=[2,1104],$Ve1=[1,238],$Vf1=[1,253],$Vg1=[1,254],$Vh1=[1,242],$Vi1=[1,239],$Vj1=[1,240],$Vk1=[1,241],$Vl1=[1,248],$Vm1=[1,247],$Vn1=[1,246],$Vo1=[1,249],$Vp1=[1,244],$Vq1=[1,243],$Vr1=[1,237],$Vs1=[1,245],$Vt1=[1,256],$Vu1=[1,255],$Vv1=[34,48,59,60,68,82,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,258,267,269,345,349,353,354,357,361,362,363,364,373,374,379,381,382,384,385,387,391,397,444],$Vw1=[1,262],$Vx1=[1,268],$Vy1=[1,270],$Vz1=[34,48,59,60,68,82,84,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,258,267,269,345,349,353,354,357,361,362,363,364,373,374,379,381,382,384,385,387,391,397,444],$VA1=[1,275],$VB1=[34,48,55,59,60,68,82,84,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,258,267,269,272,345,349,353,354,357,361,362,363,364,373,374,379,381,382,384,385,387,391,397,444],$VC1=[34,48,59,60,68,82,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,258,267,269,323,345,349,353,354,357,361,362,363,364,373,374,379,381,382,384,385,387,391,397,444],$VD1=[48,59,60,68,86,90,118,130,145,159,195,206,219,220,221,222,223,224,225,226,227,231,233,237,267,269,345,349,353,354,363],$VE1=[1,290],$VF1=[48,55,86,90,100,101,114,187,195,206,219,220,221,222,223,224,225,226,227,231,237,267,269,345,349],$VG1=[86,90],$VH1=[2,50],$VI1=[1,303],$VJ1=[48,345,349],$VK1=[48,130,345,349],$VL1=[48,55,82,84,130,345,349],$VM1=[48,55],$VN1=[2,833],$VO1=[269,345,349],$VP1=[90,187,269,345,349],$VQ1=[34,55,86,90],$VR1=[179,246],$VS1=[2,1082],$VT1=[86,195,206,231,237,267,345,349],$VU1=[2,468],$VV1=[1,331],$VW1=[101,252,274,275],$VX1=[86,90,187,195,206,219,220,221,222,223,224,225,226,227,231,237,267,269,345,349],$VY1=[48,59,60,68,86,90,100,118,134,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,267,269,345,349,353,354,361,363,364,373,374,382,387,391,397,444],$VZ1=[34,48,59,60,68,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,258,267,269,345,349,353,354,357,361,362,363,364,373,374,382,387,391,397,444],$V_1=[373,374,397],$V$1=[59,60,68,84,100,101,112,117,118,233,272,274,275,276,299,300,301,302,303,304,305,306,307,308,309,311,312,353,354,356,357,360,363,367,375,394,395],$V02=[34,48,55,59,60,68,82,86,90,100,101,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,227,231,233,237,244,245,258,267,269,345,349,353,354,357,361,362,363,364,373,374,379,381,382,384,385,387,391,397,444],$V12=[86,206,231,237,267,345,349],$V22=[86,90,195,206,231,237,267,269,345,349],$V32=[1,432],$V42=[1,435],$V52=[1,433],$V62=[1,437],$V72=[1,434],$V82=[1,436],$V92=[1,439],$Va2=[1,438],$Vb2=[86,90,195,206,219,220,221,222,223,224,225,226,227,231,237,267,269,345,349],$Vc2=[48,59,60,68,86,90,118,195,206,219,220,221,222,223,224,225,226,227,231,233,237,267,269,345,349,353,354,363],$Vd2=[34,48,59,60,68,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,267,269,345,349,353,354,361,363,364,373,374,382,387,391,397,444],$Ve2=[48,59,60,68,86,90,118,134,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,267,269,345,349,353,354,361,363,373,374,382,387,391,397,444],$Vf2=[1,457],$Vg2=[86,237],$Vh2=[1,471],$Vi2=[1,497],$Vj2=[1,498],$Vk2=[1,499],$Vl2=[1,485],$Vm2=[1,486],$Vn2=[1,487],$Vo2=[1,488],$Vp2=[1,489],$Vq2=[1,490],$Vr2=[1,491],$Vs2=[1,492],$Vt2=[1,493],$Vu2=[1,494],$Vv2=[1,495],$Vw2=[1,496],$Vx2=[86,231,237,267,345,349],$Vy2=[68,84,118,233,353,354,363],$Vz2=[1,531],$VA2=[86,90,237],$VB2=[34,48,59,60,68,82,86,90,100,113,114,118,134,147,187,195,206,219,220,221,222,223,224,225,226,227,231,233,237,244,245,258,267,269,345,349,353,354,357,361,362,363,364,373,374,379,381,382,384,385,387,391,397,444],$VC2=[1,539],$VD2=[90,345,349],$VE2=[1,555],$VF2=[1,556],$VG2=[55,86,90,100,101,114],$VH2=[2,894],$VI2=[1,559],$VJ2=[86,231,267,345,349],$VK2=[86,90,195,206,219,220,221,222,223,224,225,226,231,237,267,269,345,349],$VL2=[2,376],$VM2=[1,575],$VN2=[55,86,90,100,101],$VO2=[86,90,206,231,237,267,345,349],$VP2=[364,499],$VQ2=[1,631],$VR2=[90,114],$VS2=[86,361,369,394,499],$VT2=[2,1140],$VU2=[86,90,134,231,267,345,349,387],$VV2=[86,361],$VW2=[2,1150],$VX2=[1,664],$VY2=[1,665],$VZ2=[1,666],$V_2=[1,674],$V$2=[1,675],$V03=[2,1155],$V13=[1,682],$V23=[377,383],$V33=[2,200],$V43=[2,201];
var parser = {trace: function trace () { },
yy: {},
symbols_: {"error":2,"DataDefinition_EDIT":3,"ALTER":4,"CURSOR":5,"AlterTable_EDIT":6,"AlterView_EDIT":7,"CREATE":8,"DatabaseDefinition_EDIT":9,"TableDefinition_EDIT":10,"ViewDefinition_EDIT":11,"DROP":12,"DropDatabaseStatement_EDIT":13,"DropTableStatement_EDIT":14,"DropViewStatement_EDIT":15,"SET":16,"TruncateTableStatement_EDIT":17,"UseStatement_EDIT":18,"ShowStatement_EDIT":19,"DescribeStatement_EDIT":20,"DataDefinition":21,"AlterTable":22,"AlterView":23,"DatabaseDefinition":24,"RoleDefinition":25,"TableDefinition":26,"ViewDefinition":27,"DropDatabaseStatement":28,"DropRoleStatement":29,"DropTableStatement":30,"DropViewStatement":31,"ALL":32,"SetOption":33,"=":34,"SetValue":35,"TruncateTableStatement":36,"UseStatement":37,"SHOW":38,"ShowStatement":39,"DescribeStatement":40,"AlterTableLeftSide":41,"PartitionSpec":42,"AlterTableLeftSide_EDIT":43,"TABLE":44,"SchemaQualifiedTableIdentifier":45,"SchemaQualifiedTableIdentifier_EDIT":46,"AlterViewLeftSide":47,"AS":48,"QuerySpecification":49,"AlterViewLeftSide_EDIT":50,"QuerySpecification_EDIT":51,"VIEW":52,"OptionalComment":53,"Comment":54,"COMMENT":55,"QuotedValue":56,"OptionalComment_INVALID":57,"Comment_INVALID":58,"SINGLE_QUOTE":59,"DOUBLE_QUOTE":60,"VALUE":61,"DatabaseOrSchema":62,"OptionalIfNotExists":63,"RegularIdentifier":64,"DatabaseDefinitionOptionals":65,"OptionalIfNotExists_EDIT":66,"DatabaseDefinitionOptionals_EDIT":67,"ROLE":68,"TableDefinitionRightPart":69,"TableDefinitionRightPart_EDIT":70,"TableIdentifierAndOptionalColumnSpecification":71,"OptionalPartitionedBy":72,"OptionalAsSelectStatement":73,"TableIdentifierAndOptionalColumnSpecification_EDIT":74,"PartitionedBy_EDIT":75,"OptionalAsSelectStatement_EDIT":76,"SchemaQualifiedIdentifier":77,"OptionalColumnSpecificationsOrLike":78,"OptionalColumnSpecificationsOrLike_EDIT":79,"SchemaQualifiedIdentifier_EDIT":80,"ParenthesizedColumnSpecificationList":81,"LIKE":82,"ParenthesizedColumnSpecificationList_EDIT":83,"(":84,"ColumnSpecificationList":85,")":86,"ColumnSpecificationList_EDIT":87,"RightParenthesisOrError":88,"ColumnSpecification":89,",":90,"ColumnSpecification_EDIT":91,"ColumnIdentifier":92,"ColumnDataType":93,"OptionalColumnOptions":94,"ColumnDataType_EDIT":95,"ColumnOptions_EDIT":96,"ColumnOptions":97,"ColumnOption":98,"ColumnOption_EDIT":99,"NOT":100,"NULL":101,"PrimitiveType":102,"ArrayType":103,"MapType":104,"StructType":105,"ArrayType_INVALID":106,"MapType_INVALID":107,"StructType_INVALID":108,"ArrayType_EDIT":109,"MapType_EDIT":110,"StructType_EDIT":111,"ARRAY":112,"<":113,">":114,"AnyCursor":115,"GreaterThanOrError":116,"MAP":117,"STRUCT":118,"StructDefinitionList":119,"StructDefinitionList_EDIT":120,"StructDefinition":121,"StructDefinition_EDIT":122,"Commas":123,"RegularOrBacktickedIdentifier":124,":":125,"ColumnDataTypeList":126,"ColumnDataTypeList_EDIT":127,"ColumnDataTypeListInner_EDIT":128,"PartitionedBy":129,"PARTITION":130,"BY":131,"RangeClause":132,"RangeClause_EDIT":133,"RANGE":134,"ParenthesizedColumnList":135,"ParenthesizedPartitionValuesList":136,"ParenthesizedColumnList_EDIT":137,"ParenthesizedPartitionValuesList_EDIT":138,"PartitionValueList":139,"PartitionValueList_EDIT":140,"PartitionValue":141,"PartitionValue_EDIT":142,"ValueExpression":143,"LessThanOrEqualTo":144,"VALUES":145,"ValueExpression_EDIT":146,"COMPARISON_OPERATOR":147,"CommitLocations":148,"OptionalParenthesizedViewColumnList":149,"ParenthesizedViewColumnList_EDIT":150,"ParenthesizedViewColumnList":151,"ViewColumnList":152,"ViewColumnList_EDIT":153,"ColumnReference":154,"OptionalIfExists":155,"OptionalCascade":156,"OptionalIfExists_EDIT":157,"OptionalPurge":158,"PURGE":159,"DataManipulation":160,"InsertStatement":161,"UpdateStatement":162,"InsertValuesStatement":163,"DataManipulation_EDIT":164,"InsertValuesStatement_EDIT":165,"UpdateStatement_EDIT":166,"INSERT":167,"INTO":168,"OptionalTable":169,"InsertValuesList":170,"ParenthesizedRowValuesList":171,"InValueList":172,"CommonTableExpression":173,"SelectStatement":174,"OptionalUnions":175,"SelectStatement_EDIT":176,"OptionalUnions_EDIT":177,"CommonTableExpression_EDIT":178,"WITH":179,"WithQueries":180,"WithQueries_EDIT":181,"WithQuery":182,"WithQuery_EDIT":183,"TableSubQueryInner":184,"TableSubQueryInner_EDIT":185,"FromClause":186,"FROM":187,"TableReferenceList":188,"FromClause_EDIT":189,"TableReferenceList_EDIT":190,"TableReference":191,"TableReference_EDIT":192,"OptionalGroupByClause":193,"GroupByClause":194,"GROUP":195,"GroupByColumnList":196,"GroupByClause_EDIT":197,"GroupByColumnList_EDIT":198,"ColumnGroupingSets":199,"ColumnGroupingSets_EDIT":200,"ColumnGroupingSet_EDIT":201,"ColumnReference_EDIT":202,"GroupByColumnListPartTwo_EDIT":203,"OptionalHavingClause":204,"HavingClause":205,"HAVING":206,"HavingClause_EDIT":207,"OptionalJoins":208,"Joins":209,"Joins_INVALID":210,"JoinType":211,"TablePrimary":212,"OptionalJoinCondition":213,"Join_EDIT":214,"JoinType_EDIT":215,"TablePrimary_EDIT":216,"JoinCondition_EDIT":217,"Joins_EDIT":218,"CROSS":219,"JOIN":220,"FULL":221,"OUTER":222,"INNER":223,"LEFT":224,"SEMI":225,"RIGHT":226,"ON":227,"UsingColList":228,"OptionalLimitClause":229,"LimitClause":230,"LIMIT":231,"UnsignedNumericLiteral":232,"VARIABLE_REFERENCE":233,"LimitClause_EDIT":234,"OptionalOrderByClause":235,"OrderByClause":236,"ORDER":237,"OrderByColumnList":238,"OrderByClause_EDIT":239,"OrderByColumnList_EDIT":240,"OrderByIdentifier":241,"OrderByIdentifier_EDIT":242,"OptionalAscOrDesc":243,"ASC":244,"DESC":245,"SELECT":246,"OptionalAllOrDistinct":247,"SelectList":248,"TableExpression":249,"SelectList_EDIT":250,"TableExpression_EDIT":251,"DISTINCT":252,"OptionalSelectConditions":253,"OptionalSelectConditions_EDIT":254,"SelectSpecification":255,"SelectSpecification_EDIT":256,"OptionalCorrelationName":257,"*":258,"OptionalCorrelationName_EDIT":259,"OptionalWhereClause":260,"WhereClause_EDIT":261,"WhereClause":262,"Unions":263,"Unions_EDIT":264,"UnionClause":265,"UnionClause_EDIT":266,"UNION":267,"NewStatement":268,"WHERE":269,"SearchCondition":270,"SearchCondition_EDIT":271,".":272,"SignedInteger":273,"TRUE":274,"FALSE":275,"TRUNCATE":276,"OptionalPartitionSpec":277,"UserDefinedFunction":278,"AggregateFunction":279,"OptionalOverClause":280,"AnalyticFunction":281,"OverClause":282,"CastFunction":283,"UserDefinedFunction_EDIT":284,"AggregateFunction_EDIT":285,"OptionalOverClause_EDIT":286,"AnalyticFunction_EDIT":287,"OverClause_EDIT":288,"CastFunction_EDIT":289,"OtherAggregateFunction":290,"CountFunction":291,"SumFunction":292,"OtherAggregateFunction_EDIT":293,"CountFunction_EDIT":294,"SumFunction_EDIT":295,"OtherAggregateFunction_Type":296,"UdfArgumentList":297,"UdfArgumentList_EDIT":298,"AVG":299,"MAX":300,"MIN":301,"STDDEV_POP":302,"STDDEV_SAMP":303,"VAR_POP":304,"VAR_SAMP":305,"VARIANCE":306,"COUNT":307,"SUM":308,"ANALYTIC":309,"ArbitraryFunctionName":310,"IF":311,"CAST":312,"NonParenthesizedValueExpressionPrimary":313,"ColumnOrArbitraryFunctionRef":314,"ArbitraryFunctionRightPart":315,"UnsignedValueSpecification":316,"NonParenthesizedValueExpressionPrimary_EDIT":317,"ArbitraryFunctionRightPart_EDIT":318,"UnsignedValueSpecification_EDIT":319,"ColumnOrArbitraryFunctionRef_EDIT":320,"ArbitraryFunction":321,"ArbitraryFunction_EDIT":322,"OVER":323,"WindowExpression":324,"WindowExpression_EDIT":325,"UPDATE":326,"TargetTable":327,"SetClauseList":328,"OptionalFromJoinedTable":329,"TargetTable_EDIT":330,"SetClauseList_EDIT":331,"FromJoinedTable_EDIT":332,"TableName":333,"TableName_EDIT":334,"LocalOrSchemaQualifiedName":335,"LocalOrSchemaQualifiedName_EDIT":336,"SetClause":337,"SetClause_EDIT":338,"SetTarget":339,"UpdateSource":340,"UpdateSource_EDIT":341,"USE":342,"SqlSyntax":343,"SqlStatements":344,"EOF":345,"SqlAutocomplete":346,"SqlStatements_EDIT":347,"SqlStatement":348,";":349,"SqlStatement_EDIT":350,"SetSpecification_EDIT":351,"NonReservedKeyword":352,"OPTION":353,"REGULAR_IDENTIFIER":354,"NonStartingToken":355,"!":356,"-":357,"[":358,"]":359,"~":360,"AND":361,"ARITHMETIC_OPERATOR":362,"BACKTICK":363,"BETWEEN":364,"BIGINT":365,"BOOLEAN":366,"CASE":367,"CHAR":368,"CURRENT":369,"DATABASE":370,"DECIMAL":371,"DOUBLE":372,"ELSE":373,"END":374,"EXISTS":375,"FLOAT":376,"FOLLOWING":377,"HDFS_START_QUOTE":378,"IN":379,"INT":380,"IS":381,"OR":382,"PRECEDING":383,"REGEXP":384,"RLIKE":385,"ROW":386,"ROWS":387,"SCHEMA":388,"SMALLINT":389,"STRING":390,"THEN":391,"TIMESTAMP":392,"TINYINT":393,"UNSIGNED_INTEGER":394,"UNSIGNED_INTEGER_E":395,"VARCHAR":396,"WHEN":397,"PARTIAL_CURSOR":398,"FromOrIn":399,"SingleQuotedValue":400,"SingleQuotedValue_EDIT":401,"PARTIAL_VALUE":402,"DoubleQuotedValue":403,"DoubleQuotedValue_EDIT":404,"QuotedValue_EDIT":405,"OptionalFromDatabase":406,"DatabaseIdentifier":407,"OptionalFromDatabase_EDIT":408,"DatabaseIdentifier_EDIT":409,"CASCADE":410,"OptionalInDatabase":411,"OptionalPartitionSpec_EDIT":412,"PartitionSpec_EDIT":413,"PartitionSpecList":414,"PartitionSpecList_EDIT":415,"RangePartitionSpec":416,"RangePartitionComparisonOperator":417,"RangePartitionSpec_EDIT":418,"ConfigurationName":419,"PartialBacktickedOrAnyCursor":420,"PartialBacktickedIdentifier":421,"PartialBacktickedOrCursor":422,"PartialBacktickedOrPartialCursor":423,"OptionalParenthesizedColumnList":424,"OptionalParenthesizedColumnList_EDIT":425,"ColumnList":426,"ColumnList_EDIT":427,"ParenthesizedSimpleValueList":428,"SimpleValueList":429,"PartitionExpression":430,"PartitionExpression_EDIT":431,"RegularOrBackTickedSchemaQualifiedName":432,"RegularOrBackTickedSchemaQualifiedName_EDIT":433,"BasicIdentifierChain":434,"BasicIdentifierChain_EDIT":435,"DerivedColumnChain":436,"DerivedColumnChain_EDIT":437,"PartialBacktickedIdentifierOrPartialCursor":438,"OptionalTypeLength":439,"OptionalTypePrecision":440,"OptionalNot":441,"TableSubQuery":442,"ValueExpressionList":443,"BETWEEN_AND":444,"LikeRightPart":445,"CaseRightPart":446,"TableSubQuery_EDIT":447,"ValueExpressionInSecondPart_EDIT":448,"LikeRightPart_EDIT":449,"CaseRightPart_EDIT":450,"EndOrError":451,"ValueExpressionList_EDIT":452,"+":453,"UnsignedLiteral":454,"UnsignedLiteral_EDIT":455,"GeneralLiteral":456,"GeneralLiteral_EDIT":457,"ExactNumericLiteral":458,"ApproximateNumericLiteral":459,"TruthValue":460,"TablePrimaryOrJoinedTable":461,"TablePrimaryOrJoinedTable_EDIT":462,"JoinedTable":463,"JoinedTable_EDIT":464,"TableOrQueryName":465,"DerivedTable":466,"TableOrQueryName_EDIT":467,"DerivedTable_EDIT":468,"OptionalOnColumn":469,"OptionalOnColumn_EDIT":470,"PushQueryState":471,"PopQueryState":472,"SubQuery":473,"SubQuery_EDIT":474,"QueryExpression":475,"QueryExpression_EDIT":476,"QueryExpressionBody":477,"QueryExpressionBody_EDIT":478,"NonJoinQueryExpression":479,"NonJoinQueryExpression_EDIT":480,"NonJoinQueryTerm":481,"NonJoinQueryTerm_EDIT":482,"NonJoinQueryPrimary":483,"NonJoinQueryPrimary_EDIT":484,"SimpleTable":485,"SimpleTable_EDIT":486,"OptionalPartitionBy":487,"OptionalOrderByAndWindow":488,"PartitionBy_EDIT":489,"OptionalOrderByAndWindow_EDIT":490,"PartitionBy":491,"OptionalWindowSpec":492,"WindowSpec_EDIT":493,"WindowSpec":494,"RowsOrRange":495,"PopLexerState":496,"OptionalCurrentOrPreceding":497,"OptionalAndFollowing":498,"UNBOUNDED":499,"OptionalCurrentOrPreceding_EDIT":500,"OptionalAndFollowing_EDIT":501,"PushHdfsLexerState":502,"HdfsPath":503,"HDFS_PATH":504,"HDFS_END_QUOTE":505,"HdfsPath_EDIT":506,"IntegerOrUnbounded":507,"TABLES":508,"CATALOGS":509,"CATALOG":510,"DATABASES":511,"VIEWS":512,"FUNCTIONS":513,"DESCRIBE":514,"CaseWhenThenList":515,"CaseWhenThenList_EDIT":516,"CaseWhenThenListPartTwo":517,"CaseWhenThenListPartTwo_EDIT":518,"$accept":0,"$end":1},
terminals_: {2:"error",4:"ALTER",5:"CURSOR",8:"CREATE",12:"DROP",16:"SET",32:"ALL",34:"=",38:"SHOW",44:"TABLE",48:"AS",52:"VIEW",55:"COMMENT",59:"SINGLE_QUOTE",60:"DOUBLE_QUOTE",61:"VALUE",68:"ROLE",82:"LIKE",84:"(",86:")",90:",",100:"NOT",101:"NULL",112:"ARRAY",113:"<",114:">",117:"MAP",118:"STRUCT",125:":",130:"PARTITION",131:"BY",134:"RANGE",145:"VALUES",147:"COMPARISON_OPERATOR",159:"PURGE",167:"INSERT",168:"INTO",179:"WITH",187:"FROM",195:"GROUP",206:"HAVING",219:"CROSS",220:"JOIN",221:"FULL",222:"OUTER",223:"INNER",224:"LEFT",225:"SEMI",226:"RIGHT",227:"ON",231:"LIMIT",233:"VARIABLE_REFERENCE",237:"ORDER",244:"ASC",245:"DESC",246:"SELECT",252:"DISTINCT",258:"*",267:"UNION",269:"WHERE",272:".",274:"TRUE",275:"FALSE",276:"TRUNCATE",299:"AVG",300:"MAX",301:"MIN",302:"STDDEV_POP",303:"STDDEV_SAMP",304:"VAR_POP",305:"VAR_SAMP",306:"VARIANCE",307:"COUNT",308:"SUM",309:"ANALYTIC",311:"IF",312:"CAST",323:"OVER",326:"UPDATE",342:"USE",345:"EOF",349:";",351:"SetSpecification_EDIT",353:"OPTION",354:"REGULAR_IDENTIFIER",356:"!",357:"-",358:"[",359:"]",360:"~",361:"AND",362:"ARITHMETIC_OPERATOR",363:"BACKTICK",364:"BETWEEN",365:"BIGINT",366:"BOOLEAN",367:"CASE",368:"CHAR",369:"CURRENT",370:"DATABASE",371:"DECIMAL",372:"DOUBLE",373:"ELSE",374:"END",375:"EXISTS",376:"FLOAT",377:"FOLLOWING",378:"HDFS_START_QUOTE",379:"IN",380:"INT",381:"IS",382:"OR",383:"PRECEDING",384:"REGEXP",385:"RLIKE",386:"ROW",387:"ROWS",388:"SCHEMA",389:"SMALLINT",390:"STRING",391:"THEN",392:"TIMESTAMP",393:"TINYINT",394:"UNSIGNED_INTEGER",395:"UNSIGNED_INTEGER_E",396:"VARCHAR",397:"WHEN",398:"PARTIAL_CURSOR",402:"PARTIAL_VALUE",410:"CASCADE",444:"BETWEEN_AND",453:"+",499:"UNBOUNDED",504:"HDFS_PATH",505:"HDFS_END_QUOTE",508:"TABLES",509:"CATALOGS",510:"CATALOG",511:"DATABASES",512:"VIEWS",513:"FUNCTIONS",514:"DESCRIBE"},
productions_: [0,[3,2],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,2],[3,1],[3,1],[3,1],[3,1],[21,1],[21,1],[21,1],[21,1],[21,1],[21,1],[21,1],[21,1],[21,1],[21,1],[21,2],[21,4],[21,1],[21,1],[21,2],[21,1],[22,2],[6,1],[6,2],[6,2],[6,3],[41,3],[43,3],[43,3],[23,3],[7,1],[7,2],[7,3],[7,3],[7,3],[47,3],[50,3],[50,3],[53,0],[53,1],[54,2],[57,1],[58,2],[58,2],[58,3],[58,3],[24,3],[24,5],[9,4],[9,3],[9,5],[9,4],[9,6],[65,1],[67,1],[25,3],[26,4],[10,4],[10,4],[10,3],[69,3],[70,3],[70,3],[70,3],[70,3],[71,2],[74,2],[74,2],[78,0],[78,1],[78,2],[79,1],[79,2],[79,2],[81,3],[83,3],[85,1],[85,3],[87,1],[87,3],[87,3],[87,5],[87,2],[87,4],[87,4],[87,6],[89,3],[91,3],[91,3],[91,3],[94,0],[94,1],[97,1],[97,2],[96,1],[96,2],[96,2],[96,3],[98,2],[98,1],[98,1],[99,2],[93,1],[93,1],[93,1],[93,1],[93,1],[93,1],[93,1],[95,1],[95,1],[95,1],[103,4],[106,3],[109,4],[109,4],[104,6],[107,3],[110,6],[110,4],[110,6],[110,5],[105,4],[108,3],[111,4],[119,1],[119,3],[120,1],[120,2],[120,3],[120,3],[120,5],[121,4],[122,5],[122,4],[122,4],[122,4],[122,3],[122,3],[126,1],[126,3],[127,1],[127,2],[127,3],[127,3],[127,5],[128,2],[128,2],[128,1],[128,1],[116,1],[116,1],[72,0],[72,1],[129,3],[75,2],[75,3],[75,3],[132,3],[133,2],[133,2],[133,3],[133,3],[133,3],[136,3],[138,3],[138,3],[139,1],[139,3],[140,1],[140,3],[140,5],[140,3],[140,5],[141,6],[141,4],[141,4],[142,2],[142,2],[142,3],[142,4],[142,4],[142,5],[142,6],[142,6],[142,3],[142,4],[142,4],[144,1],[144,1],[73,0],[73,3],[76,3],[76,3],[148,0],[27,8],[11,4],[11,9],[11,3],[11,6],[11,7],[11,8],[11,8],[11,8],[149,0],[149,1],[151,3],[150,3],[152,2],[152,4],[153,3],[153,5],[153,5],[153,7],[28,5],[13,3],[13,3],[13,4],[13,5],[13,5],[13,6],[29,3],[30,5],[14,3],[14,4],[14,5],[14,5],[14,6],[158,0],[158,1],[31,4],[15,4],[15,5],[15,3],[15,4],[15,4],[160,1],[160,1],[161,1],[164,1],[164,1],[163,6],[165,2],[165,4],[165,4],[165,5],[165,6],[170,1],[170,3],[171,3],[169,0],[169,1],[49,3],[49,5],[49,2],[51,4],[51,3],[51,3],[51,1],[51,4],[51,3],[51,2],[51,2],[173,2],[178,2],[180,1],[180,3],[181,1],[181,3],[181,3],[181,5],[182,5],[183,2],[183,5],[183,5],[186,2],[189,2],[189,2],[188,1],[188,3],[190,1],[190,3],[190,3],[190,5],[190,3],[193,0],[193,1],[194,3],[197,3],[197,3],[197,2],[199,0],[199,1],[199,3],[199,3],[200,1],[200,3],[200,3],[200,5],[200,3],[201,1],[201,1],[196,1],[196,3],[198,1],[198,2],[198,3],[198,3],[198,3],[198,4],[198,5],[203,1],[203,2],[203,1],[204,0],[204,1],[205,2],[207,2],[207,2],[208,0],[208,1],[208,1],[209,3],[209,4],[210,1],[210,2],[214,3],[214,1],[214,3],[214,3],[214,3],[218,1],[218,2],[218,2],[218,3],[211,2],[211,2],[211,3],[211,2],[211,1],[211,3],[211,2],[211,3],[211,3],[211,2],[211,3],[211,2],[211,3],[211,3],[211,2],[215,2],[215,3],[215,3],[215,2],[215,3],[215,3],[215,3],[215,3],[215,2],[215,3],[215,3],[215,3],[215,3],[215,2],[213,0],[213,2],[228,1],[228,3],[217,2],[217,2],[229,0],[229,1],[230,2],[230,4],[230,2],[230,4],[234,2],[235,0],[235,1],[236,3],[239,3],[239,2],[238,1],[238,3],[240,1],[240,2],[240,3],[240,4],[240,5],[241,2],[242,2],[242,2],[243,0],[243,1],[243,1],[174,3],[174,4],[176,3],[176,3],[176,4],[176,4],[176,4],[176,5],[176,6],[176,4],[247,0],[247,1],[247,1],[249,2],[251,2],[251,4],[251,3],[248,1],[248,3],[250,1],[250,2],[250,3],[250,3],[250,3],[250,4],[250,3],[250,3],[250,4],[250,4],[250,4],[250,5],[250,5],[255,2],[255,1],[256,2],[256,3],[256,2],[253,5],[254,5],[254,5],[254,5],[254,5],[254,5],[254,6],[254,6],[254,6],[254,6],[254,6],[175,0],[175,1],[177,1],[263,1],[263,2],[264,1],[264,2],[264,2],[264,3],[265,4],[266,3],[266,4],[266,4],[260,0],[260,1],[262,2],[261,2],[261,2],[270,1],[271,1],[33,1],[33,3],[35,1],[35,1],[35,2],[35,1],[35,1],[35,1],[35,1],[36,4],[17,2],[17,4],[17,3],[17,4],[17,5],[17,5],[17,5],[278,2],[278,2],[278,1],[284,1],[284,2],[284,1],[284,2],[284,2],[284,2],[284,1],[279,1],[279,1],[279,1],[285,1],[285,1],[285,1],[290,4],[290,5],[293,5],[293,6],[293,5],[296,1],[296,1],[296,1],[296,1],[296,1],[296,1],[296,1],[296,1],[291,4],[291,3],[291,5],[294,5],[294,6],[294,5],[292,5],[292,3],[295,5],[295,6],[295,5],[281,3],[281,4],[287,4],[287,5],[287,4],[310,1],[310,1],[310,1],[310,1],[283,6],[283,3],[289,6],[289,5],[289,4],[289,6],[289,5],[289,4],[289,6],[289,5],[289,6],[289,5],[313,2],[313,2],[313,1],[313,1],[313,1],[313,1],[317,2],[317,2],[317,1],[317,1],[317,1],[321,2],[321,2],[322,2],[322,2],[315,2],[315,3],[318,3],[318,4],[318,3],[297,1],[297,3],[298,1],[298,3],[298,3],[298,5],[298,3],[298,5],[298,4],[298,3],[298,2],[298,2],[298,4],[280,0],[280,1],[286,1],[282,2],[282,2],[288,2],[162,6],[166,6],[166,6],[166,6],[166,6],[166,7],[166,3],[166,2],[166,2],[166,2],[327,1],[330,1],[333,1],[334,1],[328,1],[328,3],[331,1],[331,3],[331,3],[331,5],[337,3],[338,3],[338,2],[338,1],[339,1],[340,1],[341,1],[329,0],[329,2],[332,2],[332,2],[37,2],[18,2],[343,3],[346,3],[346,3],[268,0],[344,0],[344,1],[344,4],[347,1],[347,4],[347,4],[347,7],[348,1],[348,1],[348,1],[350,1],[350,2],[350,1],[350,1],[350,1],[350,1],[352,1],[352,1],[352,1],[64,1],[64,1],[64,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[355,1],[123,1],[123,2],[115,1],[115,1],[399,1],[399,1],[62,1],[62,1],[400,3],[400,2],[401,2],[403,3],[403,2],[404,2],[56,1],[56,1],[405,1],[405,1],[406,0],[406,2],[408,2],[156,0],[156,1],[155,0],[155,2],[157,2],[63,0],[63,3],[66,2],[66,3],[411,0],[411,2],[411,2],[277,0],[277,1],[412,1],[42,4],[413,4],[416,5],[418,2],[418,3],[418,4],[418,5],[418,5],[418,5],[417,1],[417,1],[417,1],[417,1],[419,1],[419,1],[420,1],[420,1],[422,1],[422,1],[423,1],[423,1],[421,2],[88,1],[88,1],[424,0],[424,1],[425,1],[135,3],[137,3],[137,3],[426,1],[426,3],[427,3],[427,5],[428,3],[429,1],[429,3],[45,1],[45,3],[46,1],[46,3],[46,3],[77,1],[77,3],[80,1],[80,3],[80,3],[407,1],[409,1],[414,1],[414,3],[415,1],[415,3],[415,3],[415,5],[430,3],[431,3],[431,3],[431,3],[431,1],[124,1],[124,3],[124,2],[432,1],[432,3],[433,1],[433,3],[335,1],[335,2],[336,1],[336,2],[154,1],[154,3],[202,1],[434,1],[434,3],[435,3],[435,5],[436,1],[436,3],[437,1],[437,3],[437,5],[437,3],[92,1],[438,1],[438,1],[102,1],[102,1],[102,2],[102,2],[102,1],[102,1],[102,1],[102,1],[102,1],[102,1],[102,1],[102,2],[439,0],[439,3],[440,0],[440,3],[440,5],[143,1],[143,2],[143,2],[143,2],[143,2],[143,4],[143,4],[143,4],[143,6],[143,2],[143,3],[143,3],[143,3],[143,3],[143,3],[143,6],[143,6],[143,5],[143,5],[143,6],[143,5],[143,3],[143,3],[143,3],[143,3],[143,3],[143,2],[143,3],[143,2],[143,3],[146,1],[146,3],[146,2],[146,2],[146,2],[146,2],[146,2],[146,2],[146,2],[146,2],[146,3],[146,4],[146,5],[146,4],[146,4],[146,4],[146,6],[146,6],[146,2],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,4],[146,3],[146,6],[146,6],[146,5],[146,5],[146,6],[146,6],[146,6],[146,6],[146,5],[146,4],[146,5],[146,5],[146,5],[146,5],[146,4],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,3],[146,2],[146,3],[146,2],[146,3],[146,2],[146,3],[146,2],[146,3],[146,3],[146,4],[146,3],[146,3],[146,3],[443,1],[443,3],[452,1],[452,3],[452,3],[452,5],[452,3],[452,5],[452,4],[452,3],[452,2],[452,2],[452,4],[172,1],[172,3],[314,1],[314,3],[320,1],[273,1],[273,2],[273,2],[316,1],[319,1],[454,1],[454,1],[455,1],[232,1],[232,1],[458,1],[458,2],[458,3],[458,2],[459,2],[459,3],[459,4],[456,1],[456,1],[456,1],[457,1],[457,1],[460,1],[460,1],[441,0],[441,1],[191,1],[192,1],[461,1],[461,1],[462,1],[462,1],[463,2],[464,2],[464,2],[212,2],[212,2],[216,2],[216,2],[216,2],[465,1],[467,1],[466,1],[468,1],[469,0],[469,2],[470,2],[470,2],[471,0],[472,0],[442,3],[442,4],[447,3],[447,3],[184,2],[185,3],[473,1],[474,1],[475,1],[476,1],[477,1],[478,1],[479,1],[480,1],[481,1],[482,1],[483,1],[484,1],[485,1],[486,1],[257,0],[257,1],[257,1],[257,2],[257,2],[259,1],[259,1],[259,2],[259,2],[259,2],[324,4],[325,4],[325,4],[325,5],[325,7],[487,0],[487,1],[491,3],[489,2],[489,3],[489,3],[488,0],[488,2],[490,1],[490,3],[490,2],[492,0],[492,1],[494,5],[494,5],[493,2],[493,6],[493,5],[493,5],[493,5],[493,4],[496,0],[502,0],[503,3],[506,5],[506,4],[506,3],[506,3],[506,2],[495,1],[495,1],[497,0],[497,2],[497,2],[500,2],[500,2],[498,0],[498,3],[498,3],[501,2],[501,3],[501,3],[507,1],[507,1],[39,1],[39,1],[39,2],[39,1],[39,2],[39,1],[39,1],[39,1],[19,2],[40,2],[40,4],[20,2],[20,2],[20,3],[20,4],[448,3],[448,3],[448,3],[445,2],[445,2],[445,2],[449,2],[449,2],[449,2],[449,2],[449,2],[449,2],[446,2],[446,4],[450,2],[450,4],[450,4],[450,3],[450,4],[450,3],[450,4],[450,4],[450,3],[450,4],[450,3],[451,1],[451,1],[515,1],[515,2],[516,1],[516,2],[516,3],[516,3],[516,2],[517,4],[518,2],[518,3],[518,4],[518,4],[518,3],[518,3],[518,4],[518,2],[518,3],[518,2],[518,3],[518,3],[518,4],[518,3],[518,4],[518,4],[518,5],[518,4],[518,3]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:

     parser.suggestKeywords(['TABLE', 'VIEW']);
   
break;
case 4: case 8:

     parser.suggestKeywords(['DATABASE', 'ROLE', 'SCHEMA', 'TABLE', 'VIEW']);
   
break;
case 12:

     parser.suggestSetOptions();
   
break;
case 38: case 47: case 242: case 246: case 484: case 604: case 1172: case 1173: case 1176: case 1177:

     parser.addTablePrimary($$[$0]);
   
break;
case 39: case 237:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyTables = true;
     }
   
break;
case 40:

     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 43: case 284:

     parser.suggestKeywords(['AS']);
   
break;
case 45: case 204: case 213: case 285: case 640: case 1087:

     parser.suggestKeywords(['SELECT']);
   
break;
case 48: case 247:

     if (parser.yy.result.suggestTables) {
       parser.yy.result.suggestTables.onlyViews = true;
     }
   
break;
case 49:

     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 59:

     parser.addNewDatabaseLocation(_$[$0-1], [{ name: $$[$0-1] }]);
   
break;
case 60: case 70:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 62:

     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 63:

     parser.addNewDatabaseLocation(_$[$0], [{ name: $$[$0] }]);
   
break;
case 64:

     parser.addNewDatabaseLocation(_$[$0-2], [{ name: $$[$0-2] }]);
   
break;
case 65:

     if (!$$[$0]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 76:

     var keywords = [];
     if (!$$[$0-2] && !$$[$0-1]) {
       keywords.push({ value: 'LIKE', weight: 1 });
     } else {
       if (!$$[$0-1]) {
         keywords.push({ value: 'PARTITIONED BY', weight: 12 });
       }
       keywords.push({ value: 'AS', weight: 1 });
     }

     if (keywords.length > 0) {
       parser.suggestKeywords(keywords);
     }
   
break;
case 77:

     parser.addNewTableLocation(_$[$0-1], $$[$0-1], $$[$0]);
     this.$ = $$[$0];
   
break;
case 82:
this.$ = [];
break;
case 84: case 601: case 621: case 834: case 1174:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 86: case 222: case 224: case 266: case 436: case 569: case 572: case 767: case 770: case 856: case 909: case 1084:
this.$ = $$[$0-1];
break;
case 88: case 277:
this.$ = [$$[$0]];
break;
case 89:
this.$ = $$[$0-2].concat($$[$0]);
break;
case 94: case 96:

     parser.checkForKeywords($$[$0-1]);
   
break;
case 95: case 97:

     parser.checkForKeywords($$[$0-3]);
   
break;
case 98:

     this.$ = $$[$0-2];
     this.$.type = $$[$0-1];
     var keywords = [];
     if (!$$[$0]['comment']) {
       keywords.push('COMMENT');
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 99: case 126: case 132: case 133: case 146: case 149: case 158: case 160:

     parser.suggestKeywords(parser.getColumnDataTypeKeywords());
   
break;
case 102:
this.$ = {};
break;
case 104:

     this.$ = {};
     this.$[$$[$0]] = true;
   
break;
case 105:

     $$[$0-1][$$[$0]] = true;
   
break;
case 110: case 111:
this.$ = 'null';
break;
case 112:
this.$ = 'comment';
break;
case 113:

     parser.suggestKeywords(['NULL']);
   
break;
case 131:

     parser.suggestKeywords(parser.getTypeKeywords());
   
break;
case 145: case 148:

     parser.suggestKeywords(['COMMENT']);
   
break;
case 167: case 1122:

     parser.suggestKeywords(['BY']);
   
break;
case 168:

     parser.suggestKeywords(['RANGE']);
   
break;
case 177: case 182: case 183:

     parser.suggestKeywords(['PARTITION']);
   
break;
case 189:

     parser.suggestKeywords(['VALUE', 'VALUES']);
   
break;
case 190:

     if ($$[$0].endsWithLessThanOrEqual) {
      parser.suggestKeywords(['VALUES']);
     }
   
break;
case 191: case 194: case 197:

     parser.suggestKeywords(['<', '<=']);
   
break;
case 192: case 799: case 802:

     parser.suggestKeywords(['VALUES']);
   
break;
case 195: case 198:

     parser.suggestFunctions();
   
break;
case 206:

     parser.commitLocations();
   
break;
case 208:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
     parser.suggestDatabases({ appendDot: true });
   
break;
case 209:

     if (!$$[$0-6]) {
       parser.suggestKeywords(['IF NOT EXISTS']);
     }
   
break;
case 212:

     var keywords = [{value: 'AS', weight: 1 }];
     if (!$$[$0-1]) {
       keywords.push({ value: 'COMMENT', weight: 3 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 219:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['COMMENT']);
     }
   
break;
case 223: case 225:
this.$ = $$[$0-3];
break;
case 229:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestDatabases();
   
break;
case 230:

     parser.suggestKeywords(['CASCADE']);
   
break;
case 232:

     if (!$$[$0-3]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 234: case 489:

     parser.addTablePrimary($$[$0-1]);
   
break;
case 236:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyTables: true });
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 239:

     parser.addTablePrimary($$[$0-2]);
     if (!$$[$0-1]) {
       parser.suggestKeywords(['PURGE']);
     }
   
break;
case 243:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
     parser.suggestTables({ onlyViews: true });
     parser.suggestDatabases({ appendDot: true });
   
break;
case 244:

     parser.addTablePrimary($$[$0]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 253:

     $$[$0-2].owner = 'insert';
     parser.addTablePrimary($$[$0-2]);
   
break;
case 254:

     parser.suggestKeywords(['INTO']);
   
break;
case 255:

     if (!$$[$0-1]) {
       parser.suggestKeywords(['TABLE']);
     }
     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 257:

     $$[$0-1].owner = 'insert';
     parser.addTablePrimary($$[$0-1]);
     parser.suggestKeywords(['VALUES']);
   
break;
case 265: case 438:
this.$ = $$[$0-2];
break;
case 267:

     parser.addCommonTableExpressions($$[$0-3]);
   
break;
case 268: case 269: case 280:

     parser.addCommonTableExpressions($$[$0-2]);
   
break;
case 275: case 291: case 315: case 391: case 395: case 433: case 443: case 470: case 620: case 1009: case 1011: case 1066: case 1121: case 1211:
this.$ = $$[$0];
break;
case 278:
this.$ = $$[$0-2].concat([$$[$0]]);
break;
case 282:

     parser.addCommonTableExpressions($$[$0-4]);
   
break;
case 283:

     parser.addCteAliasLocation(_$[$0-4], $$[$0-4]);
     $$[$0-1].alias = $$[$0-4];
     this.$ = $$[$0-1];
   
break;
case 287:

     this.$ = { tableReferenceList : $$[$0] }
   
break;
case 288: case 296:

       parser.suggestTables();
       parser.suggestDatabases({ appendDot: true });
   
break;
case 299:

     this.$ = { valueExpression: $$[$0] };
   
break;
case 300: case 402:

     parser.suggestSelectListAliases();
   
break;
case 301:

     parser.valueExpressionSuggest();
     parser.suggestSelectListAliases();
     parser.suggestGroupBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 302:

     parser.suggestKeywords(['BY']);
     parser.suggestGroupBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 312: case 615: case 824: case 827: case 828: case 853: case 854: case 875: case 878:

     parser.suggestColumns();
   
break;
case 317: case 318: case 324: case 325: case 852: case 1080: case 1123:

     parser.valueExpressionSuggest();
   
break;
case 329:

     parser.valueExpressionSuggest();
     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 330:

     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 334:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-2];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
        parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 335:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-3];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
       parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 336:
this.$ = { joinType: $$[$0] };
break;
case 337:
this.$ = { joinType: $$[$0-1] };
break;
case 338:

     if ($$[$0-2].suggestKeywords) {
       parser.suggestKeywords($$[$0-2].suggestKeywords);
     }
   
break;
case 339:

     if ($$[$0].suggestKeywords) {
       parser.suggestKeywords($$[$0].suggestKeywords);
     }
   
break;
case 342:

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         parser.suggestJoins({
           prependJoin: false,
           joinType: $$[$0-2],
           tables: tables
         })
       }
     }
     parser.suggestTables();
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 347:
this.$ = 'CROSS JOIN';
break;
case 348:
this.$ = 'FULL JOIN';
break;
case 349:
this.$ = 'FULL OUTER JOIN';
break;
case 350:
this.$ = 'INNER JOIN';
break;
case 351:
this.$ = 'JOIN';
break;
case 352:
this.$ = 'LEFT INNER JOIN';
break;
case 353:
this.$ = 'LEFT JOIN';
break;
case 354:
this.$ = 'LEFT OUTER JOIN';
break;
case 355:
this.$ = 'LEFT SEMI JOIN';
break;
case 356:
this.$ = 'OUTER JOIN';
break;
case 357: case 359:
this.$ = 'RIGHT OUTER JOIN';
break;
case 358:
this.$ = 'RIGHT JOIN';
break;
case 360:
this.$ = 'RIGHT SEMI JOIN';
break;
case 361:
this.$ = 'SEMI JOIN';
break;
case 362: case 364: case 365: case 367: case 368: case 369: case 370: case 372: case 373: case 374: case 375:
this.$ = { suggestKeywords: ['JOIN'] };
break;
case 363: case 366: case 371:
this.$ = { suggestKeywords: ['OUTER'] };
break;
case 376:
this.$ = { noJoinCondition: true, suggestKeywords: ['ON'] };
break;
case 377:
this.$ = { valueExpression: $$[$0] };
break;
case 381:

     parser.valueExpressionSuggest();
     parser.suggestJoinConditions({ prependOn: false });
   
break;
case 388:

     parser.suggestKeywords([{ value: '10', weight: 10000 }, { value: '100', weight: 10000 }, { value: '1000', weight: 10000 }, { value: '5000', weight: 10000 }, { value: '10000', weight: 10000 }])
   
break;
case 392:

     if ($$[$0].emptyOrderBy) {
       parser.suggestOrderBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 393:

     parser.suggestKeywords(['BY']);
     parser.suggestOrderBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 397:

     this.$ = { emptyOrderBy: false }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 398: case 399: case 400:
this.$ = { emptyOrderBy: false };
break;
case 401:
this.$ = parser.mergeSuggestKeywords($$[$0]);
break;
case 403:

     this.$ = { emptyOrderBy: true }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 404:
this.$ = { suggestKeywords: ['ASC', 'DESC'] };;
break;
case 407:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     this.$ = { selectList: $$[$0] };
   
break;
case 408:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     this.$ = { selectList: $$[$0-1], tableExpression: $$[$0] }
   
break;
case 409:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     if ($$[$0].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-1]) {
         keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
       }
       parser.suggestKeywords(keywords);
     } else {
       parser.checkForSelectListKeywords($$[$0]);
     }
     if ($$[$0].suggestFunctions) {
       parser.suggestFunctions();
     }
     if ($$[$0].suggestColumns) {
       parser.suggestColumns({ identifierChain: [], source: 'select' });
     }
     if ($$[$0].suggestTables) {
       parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     }
     if ($$[$0].suggestDatabases) {
       parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
     }
     if ($$[$0].suggestAggregateFunctions && (!$$[$0-1] || $$[$0-1] === 'ALL')) {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
   
break;
case 410:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-1] || $$[$0-1] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-1]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 411:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
   
break;
case 412:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.selectListNoTableSuggest($$[$0-1], $$[$0-2]);
     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'select';
     }
   
break;
case 413:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2] || $$[$0-2] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-2]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 414:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]), _$[$0-2]);
     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 415:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]), _$[$0-3]);
     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 416:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.checkForSelectListKeywords($$[$0-1]);
     var keywords = ['FROM'];
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.suggestTables({ prependFrom: true });
     parser.suggestDatabases({ prependFrom: true, appendDot: true });
   
break;
case 420: case 421:

     parser.addClauseLocation('whereClause', _$[$0-1], $$[$0].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0].limitClausePreceding || _$[$0-1], $$[$0].limitClauseLocation);
   
break;
case 422:

     var keywords = [];

     parser.addClauseLocation('whereClause', _$[$0-3], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-2].limitClausePreceding || _$[$0-3], $$[$0-2].limitClauseLocation);

     if ($$[$0-3]) {
       if (typeof $$[$0-3].tableReferenceList.hasJoinCondition !== 'undefined' && !$$[$0-3].tableReferenceList.hasJoinCondition) {
         keywords.push({ value: 'ON', weight: 3 });
       }
       if ($$[$0-3].suggestKeywords) {
         keywords = parser.createWeightedKeywords($$[$0-3].suggestKeywords, 3);
       }
       if ($$[$0-3].tableReferenceList.suggestJoinConditions) {
         parser.suggestJoinConditions($$[$0-3].tableReferenceList.suggestJoinConditions);
       }
       if ($$[$0-3].tableReferenceList.suggestJoins) {
         parser.suggestJoins($$[$0-3].tableReferenceList.suggestJoins);
       }
       if ($$[$0-3].tableReferenceList.suggestKeywords) {
         keywords = keywords.concat(parser.createWeightedKeywords($$[$0-3].tableReferenceList.suggestKeywords, 3));
       }

       // Lower the weights for 'TABLESAMPLE'
       keywords.forEach(function (keyword) {
         if (keyword.value === 'TABLESAMPLE') {
           keyword.weight = 1.1;
         }
       });

       if ($$[$0-3].tableReferenceList.types) {
         var veKeywords = parser.getValueExpressionKeywords($$[$0-3].tableReferenceList);
         keywords = keywords.concat(veKeywords.suggestKeywords);
         if (veKeywords.suggestColRefKeywords) {
           parser.suggestColRefKeywords(veKeywords.suggestColRefKeywords);
           parser.addColRefIfExists($$[$0-3].tableReferenceList);
         }
       }
     }

     if ($$[$0-1].empty && $$[$0] && $$[$0].joinType.toUpperCase() === 'JOIN') {
       keywords = keywords.concat(['FULL', 'FULL OUTER', 'INNER', 'LEFT', 'LEFT OUTER', 'RIGHT', 'RIGHT OUTER']);
       parser.suggestKeywords(keywords);
       return;
     }

     if ($$[$0-1].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].suggestFilters) {
       parser.suggestFilters($$[$0-1].suggestFilters);
     }
     if ($$[$0-1].suggestGroupBys) {
       parser.suggestGroupBys($$[$0-1].suggestGroupBys);
     }
     if ($$[$0-1].suggestOrderBys) {
       parser.suggestOrderBys($$[$0-1].suggestOrderBys);
     }

     if ($$[$0-1].empty) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }

     keywords = keywords.concat([
       { value: 'FULL JOIN', weight: 1 },
       { value: 'FULL OUTER JOIN', weight: 1 },
       { value: 'INNER JOIN', weight: 1 },
       { value: 'JOIN', weight: 1 },
       { value: 'LEFT JOIN', weight: 1 },
       { value: 'LEFT OUTER JOIN', weight: 1 },
       { value: 'RIGHT JOIN', weight: 1 },
       { value: 'RIGHT OUTER JOIN', weight: 1 }
     ]);
     parser.suggestKeywords(keywords);
  
break;
case 423:

     // A couple of things are going on here:
     // - If there are no SelectConditions (WHERE, GROUP BY, etc.) we should suggest complete join options
     // - If there's an OptionalJoin at the end, i.e. 'SELECT * FROM foo | JOIN ...' we should suggest
     //   different join types
     // - The FromClause could end with a valueExpression, in which case we should suggest keywords like '='
     //   or 'AND' based on type

     if (!$$[$0-1]) {
       parser.addClauseLocation('whereClause', _$[$0-2]);
       parser.addClauseLocation('limitClause', _$[$0-2]);
       return;
     }
     parser.addClauseLocation('whereClause', _$[$0-2], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-1].limitClausePreceding || _$[$0-2], $$[$0-1].limitClauseLocation);
     var keywords = [];

     if ($$[$0-1].suggestColRefKeywords) {
       parser.suggestColRefKeywords($$[$0-1].suggestColRefKeywords);
       parser.addColRefIfExists($$[$0-1]);
     }

     if ($$[$0-1].suggestKeywords && $$[$0-1].suggestKeywords.length) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].cursorAtEnd) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 424:
this.$ = [ $$[$0] ];
break;
case 425:

     $$[$0-2].push($$[$0]);
   
break;
case 427: case 428:

     this.$ = { cursorAtStart : true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 430:

     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 431:

     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 432:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestTables: true, suggestDatabases: true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 434: case 435: case 437:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true,  };
   
break;
case 439:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
       this.$ = { valueExpression: $$[$0-1], alias: $$[$0].alias };
       if (!parser.yy.selectListAliases) {
         parser.yy.selectListAliases = [];
       }
       parser.yy.selectListAliases.push($$[$0-1].function && $$[$0-1].types && $$[$0-1].types.length && $$[$0-1].types[0] === 'UDFREF' ? { name: $$[$0].alias, udfRef: $$[$0-1].function, types: $$[$0-1].types } : { name: $$[$0].alias, types: $$[$0-1].types || ['T'] });
     } else {
       this.$ = { valueExpression: $$[$0-1] }
     }
   
break;
case 440:

     parser.addAsteriskLocation(_$[$0], [{ asterisk: true }]);
     this.$ = { asterisk: true }
   
break;
case 441:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
     }
   
break;
case 442:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.addColumnAliasLocation(_$[$0], $$[$0], _$[$0-2]);
     this.$ = { suggestAggregateFunctions: true };
   
break;
case 444:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'WHERE', weight: 7 }, { value: 'GROUP BY', weight: 6 }, { value: 'HAVING', weight: 5 }, { value: 'ORDER BY', weight: 4 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true, true]);

     if (keywords.length > 0) {
       this.$ = { suggestKeywords: keywords, empty: !$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0] };
     } else {
       this.$ = {};
     }

     this.$.whereClauseLocation = $$[$0-4] ? _$[$0-4] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;

     if (!$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestFilters = { prefix: 'WHERE', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestGroupBys = { prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-1] && !$$[$0]) {
       this.$.suggestOrderBys = { prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
   
break;
case 445:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'where';
     }
   
break;
case 446:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'group by';
     }
   
break;
case 448:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'order by';
     }
   
break;
case 450:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'GROUP BY', weight: 8 }, { value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true]);
     if ($$[$0-5].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-5].suggestKeywords, 1));
     }
     this.$ = parser.getValueExpressionKeywords($$[$0-5], keywords);
     this.$.cursorAtEnd = !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if ($$[$0-5].columnReference) {
       this.$.columnReference = $$[$0-5].columnReference;
     }
     if (!$$[$0-3]) {
       parser.suggestGroupBys({ prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 451:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true]);
     if ($$[$0-4].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-4].suggestKeywords, 8));
     }
     if ($$[$0-4].valueExpression) {
       this.$ = parser.getValueExpressionKeywords($$[$0-4].valueExpression, keywords);
       if ($$[$0-4].valueExpression.columnReference) {
         this.$.columnReference = $$[$0-4].valueExpression.columnReference;
       }
     } else {
       this.$ = { suggestKeywords: keywords };
     }
     this.$.cursorAtEnd = !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 452:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-1], $$[$0]],
       [{ value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true]);
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0-1] && !$$[$0] };
     if (!$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-3], _$[$0-3]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 453:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0]],
       [{ value: 'LIMIT', weight: 3 }],
       [true]);
     if ($$[$0-2].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-2].suggestKeywords, 4));
     }
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0] };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 454:

     this.$ = { suggestKeywords: [], cursorAtEnd: true };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = _$[$0-1];
   
break;
case 465:

     parser.suggestKeywords(['ALL', 'DISTINCT', 'SELECT']);
   
break;
case 466:

     parser.suggestKeywords(['ALL', 'DISTINCT']);
   
break;
case 471:

     if ($$[$0].suggestFilters) {
       parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 472:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS', 'NOT EXISTS']);
     parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 485:

     parser.suggestKeywords(['TABLE']);
   
break;
case 486:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
     if (!$$[$0-1]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 490:

     parser.addTablePrimary($$[$0-1]);
     if (!$$[$0-2]) {
       parser.suggestKeywords(['IF EXISTS']);
     }
   
break;
case 492:

     if (!$$[$0]) {
       $$[$0-1].suggestKeywords = ['OVER'];
     }
   
break;
case 499:

     parser.suggestKeywords(['OVER']);
   
break;
case 508:

     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 509: case 527:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 510:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       if ($$[$0-4].toLowerCase() === 'group_concat') {
         keywords.push('ALL');
       } else {
         keywords.push('DISTINCT');
       }
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 511: case 525:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 512:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords(true);
       if (!$$[$0-2]) {
         if ($$[$0-4].toLowerCase() === 'group_concat') {
           keywords.push('ALL');
         } else {
           keywords.push('DISTINCT');
         }
       }
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
       parser.suggestKeywords(keywords);
     }
     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], $$[$0-1].activePosition);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 521:

     parser.addFunctionArgumentLocations($$[$0-3], [{
       expression: { text: $$[$0-1] },
       location: _$[$0-1]
     }]);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] }
   
break;
case 522: case 528:

     this.$ = { function: $$[$0-2], types: ['UDFREF'] }
   
break;
case 523:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] }
   
break;
case 524:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 526:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-2]) {
         keywords.push('DISTINCT');
       }
       parser.suggestKeywords(keywords);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 529:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 530:

     parser.suggestValueExpressionKeywords($$[$0-2]);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 531:

     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 532:

    this.$ = { function: $$[$0-2], types: ['UDFREF'] }
  
break;
case 533:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     this.$ = {
       function: $$[$0-3],
       expression: $$[$0-1].expressions[$$[$0-1].expressions.length - 1].expression,
       types: ['UDFREF']
     }
   
break;
case 534:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-3], 1);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 535:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-2].expressions);
     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 536:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     parser.applyArgumentTypesToSuggestions($$[$0-3], $$[$0-1].activePosition);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 541:

     var expression = $$[$0-3];
     parser.extractExpressionText(expression, $$[$0-3], $$[$0-2], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-5], [{
       expression: expression,
       location: {
         first_line: _$[$0-3].first_line,
         last_line: _$[$0-1].last_line,
         first_column: _$[$0-3].first_column,
         last_column: _$[$0-1].last_column
       }
     }]);
     this.$ = { types: [ $$[$0-1].toUpperCase() ] }
   
break;
case 542: case 547: case 548: case 1015:
this.$ = { types: [ 'T' ] };
break;
case 543:

     parser.valueExpressionSuggest();
     this.$ = { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 544: case 545:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ] };
   
break;
case 546:
this.$ = { types: [ $$[$0-1].toUpperCase() ] };
break;
case 549:

     parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'AS', weight: 2 }]);
     this.$ =  { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 550:

     parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'AS', weight: 2 }]);
     this.$ = { types: [ 'T' ] };
   
break;
case 551: case 552:

     parser.suggestKeywords(parser.getTypeKeywords());
     this.$ = { types: [ 'T' ] };
   
break;
case 553:

     // We need to handle arbitrary UDFs here instead of inside UserDefinedFunction or there will be a conflict
     // with columnReference for functions like: db.udf(foo)
     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     if ($$[$0-1].lastLoc && $$[$0-1].lastLoc.location) {
       $$[$0-1].lastLoc.type = 'function';
       $$[$0-1].lastLoc.function = fn;
       $$[$0-1].lastLoc.location = {
         first_line: $$[$0-1].lastLoc.location.first_line,
         last_line: $$[$0-1].lastLoc.location.last_line,
         first_column: $$[$0-1].lastLoc.location.first_column,
         last_column: $$[$0-1].lastLoc.location.last_column - 1
       }
       if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
          $$[$0-1].firstLoc.type = 'database';
       } else {
         delete $$[$0-1].lastLoc.identifierChain;
       }
     }
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: fn, expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: fn, types: ['UDFREF'] }
     }
   
break;
case 554:

    parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
    if ($$[$0].expressions && $$[$0].expressions.length) {
      this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
    } else {
      this.$ = { function: $$[$0-1], types: ['UDFREF'] }
    }
  
break;
case 557:
this.$ = { types: ['COLREF'], columnReference: $$[$0].chain };
break;
case 558:
this.$ = { types: [ 'NULL' ], text: $$[$0] };
break;
case 559:

     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     $$[$0-1].lastLoc.type = 'function';
     $$[$0-1].lastLoc.function = fn;
     $$[$0-1].lastLoc.location = {
       first_line: $$[$0-1].lastLoc.location.first_line,
       last_line: $$[$0-1].lastLoc.location.last_line,
       first_column: $$[$0-1].lastLoc.location.first_column,
       last_column: $$[$0-1].lastLoc.location.last_column - 1
     }
     if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
        $$[$0-1].firstLoc.type = 'database';
     } else {
       delete $$[$0-1].lastLoc.identifierChain;
     }
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions(fn, $$[$0].activePosition);
     }
     this.$ = { function: fn, types: ['UDFREF'] };
   
break;
case 560: case 566: case 567:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions($$[$0-1], $$[$0].activePosition);
     }
     this.$ = { function: $$[$0-1], types: ['UDFREF'] };
   
break;
case 563:

     if ($$[$0].suggestKeywords) {
       this.$ = { types: ['COLREF'], columnReference: $$[$0], suggestKeywords: $$[$0].suggestKeywords };
     } else {
       this.$ = { types: ['COLREF'], columnReference: $$[$0] };
     }
   
break;
case 564: case 565:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: $$[$0-1], types: ['UDFREF'] }
     }
   
break;
case 570:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }]
     }
   
break;
case 571:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = $$[$0-3];
   
break;
case 573: case 575:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0], location: _$[$0] }]
     }
   
break;
case 574: case 576:

     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: $$[$0], location: _$[$0] }])
     }
   
break;
case 577:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0-2], location: _$[$0-2] }].concat($$[$0].expressions)
     }
   
break;
case 578:

     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: $$[$0-2], location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 579:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: { text: '' }, location: _$[$0] }])
     }
   
break;
case 580:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: { text: '' }, location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 581:

     parser.suggestValueExpressionKeywords($$[$0-3].expressions[$$[$0-3].expressions.length - 1].expression);
     this.$ = {
       activePosition: $$[$0-3].activePosition,
       expressions: $$[$0-3].expressions.concat($$[$0].expressions)
     }
   
break;
case 582:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 583:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 584:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 585:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-3] }, { expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 597:

     parser.suggestKeywords([ 'WHERE' ]);
   
break;
case 598:

     parser.suggestKeywords([ 'SET' ]);
   
break;
case 614:

     parser.suggestKeywords([ '=' ]);
   
break;
case 623:

     if (! parser.yy.cursorFound) {
       parser.yy.result.useDatabase = $$[$0];
     }
   
break;
case 624: case 843:

     parser.suggestDatabases();
   
break;
case 626: case 627:

     return parser.yy.result;
   
break;
case 628:

     parser.prepareNewStatement();
   
break;
case 630: case 632: case 634:

     parser.addStatementLocation(_$[$0]);
   
break;
case 633: case 635:

     parser.addStatementLocation(_$[$0-3]);
   
break;
case 639:

     parser.suggestDdlAndDmlKeywords();
   
break;
case 768: case 771: case 857:
this.$ = '';
break;
case 783: case 786:

     parser.yy.correlatedSubQuery = false;
   
break;
case 784: case 788:

     parser.suggestKeywords(['EXISTS']);
   
break;
case 787:

     parser.suggestKeywords(['NOT EXISTS']);
   
break;
case 798: case 800: case 801: case 803:

     parser.suggestKeywords(['<', '<=', '<>', '=', '>', '>=']);
   
break;
case 832: case 858:

     parser.addTableLocation(_$[$0], [ { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0] } ] };
   
break;
case 833: case 859:

     parser.addDatabaseLocation(_$[$0-2], [ { name: $$[$0-2] } ]);
     parser.addTableLocation(_$[$0], [ { name: $$[$0-2] }, { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0-2] }, { name: $$[$0] } ] };
   
break;
case 835: case 840:

     parser.suggestDatabases();
     this.$ = { identifierChain: [{ name: $$[$0-2] }] };
   
break;
case 836: case 861:

     parser.suggestTablesOrColumns($$[$0-2]);
   
break;
case 837:
this.$ = [{ name: $$[$0] }];
break;
case 838:
this.$ = [{ name: $$[$0-2] }, { name: $$[$0-1] }];
break;
case 839:

     parser.suggestDatabases({ appendDot: true });
   
break;
case 860:

     parser.suggestTables();
     parser.suggestDatabases({ prependDot: true });
   
break;
case 863:
this.$ = { identifierChain: $$[$0-1].identifierChain, alias: $$[$0] };
break;
case 866:

     parser.yy.locations[parser.yy.locations.length - 1].type = 'column';
   
break;
case 867: case 1032:

     parser.addAsteriskLocation(_$[$0], $$[$0-2].concat({ asterisk: true }));
   
break;
case 869:

     this.$ = [ $$[$0].identifier ];
     parser.yy.firstChainLocation = parser.addUnknownLocation($$[$0].location, [ $$[$0].identifier ]);
   
break;
case 870:

     if (parser.yy.firstChainLocation) {
       parser.yy.firstChainLocation.firstInChain = true;
       delete parser.yy.firstChainLocation;
     }
     $$[$0-2].push($$[$0].identifier);
     parser.addUnknownLocation($$[$0].location, $$[$0-2].concat());
   
break;
case 871:

     parser.suggestColumns({
       identifierChain: $$[$0-2]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 872:

     parser.suggestColumns({
       identifierChain: $$[$0-4]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 873:
this.$ = [ $$[$0].identifier ];
break;
case 874:

     $$[$0-2].push($$[$0].identifier);
   
break;
case 876:

     parser.suggestColumns({ identifierChain: $$[$0-2] });
   
break;
case 877:

     parser.suggestColumns({ identifierChain: $$[$0-4] });
   
break;
case 879:
this.$ = { identifier: { name: $$[$0] }, location: _$[$0] };
break;
case 900: case 901:

     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 902: case 927:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 903:

     // verifyType($$[$0], 'NUMBER');
     this.$ = $$[$0];
     $$[$0].types = ['NUMBER'];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 904: case 905: case 906:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 907:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 908:

     this.$ = { types: [ 'BOOLEAN' ] };
     // clear correlated flag after completed sub-query (set by lexer)
     parser.yy.correlatedSubQuery = false;
   
break;
case 910: case 911: case 912: case 913:

     parser.addColRefToVariableIfExists($$[$0-2], $$[$0]);
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 914: case 915: case 916: case 917: case 947: case 1005: case 1006:
this.$ = { types: [ 'BOOLEAN' ] };
break;
case 918:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 919:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 920: case 921:

     // verifyType($$[$0-2], 'BOOLEAN');
     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 922: case 923: case 924:

     // verifyType($$[$0-2], 'NUMBER');
     // verifyType($$[$0], 'NUMBER');
     this.$ = { types: [ 'NUMBER' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 925:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 926:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 928:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 930:

     parser.suggestKeywords(['BETWEEN', 'EXISTS', 'IN', 'LIKE', 'REGEXP', 'RLIKE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 931: case 933:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
break;
case 932:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 934:

     parser.suggestFunctions({ types: [ 'BOOLEAN' ] });
     parser.suggestColumns({ types: [ 'BOOLEAN' ] });
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 935:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0].suggestFilters };
break;
case 936:

     parser.suggestFunctions();
     parser.suggestColumns();
     this.$ = { types: [ 'T' ] };
   
break;
case 937:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 938:

     parser.suggestFunctions({ types: [ 'NUMBER' ] });
     parser.suggestColumns({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ] };
   
break;
case 939:

     parser.suggestKeywords(['FALSE', 'NOT NULL', 'NOT TRUE', 'NOT FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 940:

     parser.suggestKeywords(['FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 941:

     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 942: case 943: case 944:

     parser.suggestKeywords(['NOT']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 945:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-3] ? 'IS NOT DISTINCT FROM' : 'IS DISTINCT FROM');
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 946:

     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 948:

     this.$ = $$[$0-1];
   
break;
case 949:

     parser.valueExpressionSuggest();
     this.$ = { types: ['T'], typeSet: true };
   
break;
case 950:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 951: case 952: case 953:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 954: case 955: case 956: case 957:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0]);
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 958: case 960:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 959:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ] , typeSet: true, endsWithLessThanOrEqual: true };
   
break;
case 961:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, endsWithLessThanOrEqual: $$[$0-1] === '<='  };
   
break;
case 962: case 963: case 964: case 965:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 966:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-3]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 967:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 968: case 969:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
break;
case 970: case 971:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
break;
case 972:

     if ($$[$0-2].types[0] === $$[$0].types[0] && !$$[$0-5].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
   
break;
case 973:

     if ($$[$0-5].types[0] === $$[$0].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 974:

     if ($$[$0-5].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 975:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 976: case 982:

     parser.suggestValueExpressionKeywords($$[$0-1], ['AND']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 977:

     parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 978:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-4].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
   
break;
case 979:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 980:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 981:

     parser.valueExpressionSuggest($$[$0-4], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-4]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 983:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 984: case 986: case 988: case 990:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, suggestFilters: true };
   
break;
case 985: case 989:

     parser.addColRefIfExists($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 987: case 991:

     parser.addColRefIfExists($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 992: case 993:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 994: case 995: case 996:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 997: case 998: case 999:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 1000: case 1001: case 1002:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 1003:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1004:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1007:

     parser.valueExpressionSuggest(undefined, $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 1008:

     parser.valueExpressionSuggest(undefined, $$[$0-1] + ' ' + $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 1010:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1012:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1013:

      this.$ = $$[$0];
      this.$.suggestFilters = $$[$0-1].suggestFilters;
    
break;
case 1014:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1016: case 1018:

     $$[$0].position = 1;
   
break;
case 1017:

     $$[$0].position = $$[$0-2].position + 1;
     this.$ = $$[$0];
   
break;
case 1019:

     $$[$0-2].position += 1;
   
break;
case 1020:

     $$[$0-2].position = 1;
   
break;
case 1021:

     $$[$0-4].position += 1;
   
break;
case 1022:

     parser.valueExpressionSuggest();
     $$[$0-2].position += 1;
   
break;
case 1023:

     parser.valueExpressionSuggest();
     $$[$0-4].position += 1;
   
break;
case 1024:

     parser.suggestValueExpressionKeywords($$[$0-3]);
   
break;
case 1025: case 1026:

     parser.valueExpressionSuggest();
     this.$ = { cursorAtStart : true, position: 1 };
   
break;
case 1027: case 1028:

     parser.valueExpressionSuggest();
     this.$ = { position: 2 };
   
break;
case 1031:

     var lastLoc = parser.yy.locations[parser.yy.locations.length - 1];
     if (lastLoc.type !== 'variable') {
       lastLoc.type = 'column';
     }
     // used for function references with db prefix
     var firstLoc = parser.yy.locations[parser.yy.locations.length - $$[$0].length];
     this.$ = { chain: $$[$0], firstLoc: firstLoc, lastLoc: lastLoc }
   
break;
case 1038:

     parser.suggestValues($$[$0]);
   
break;
case 1039:
this.$ = { types: [ 'NUMBER' ], text: $$[$0] };
break;
case 1045: case 1047: case 1048:
this.$ = $$[$0-1] + $$[$0];
break;
case 1046: case 1049:
this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 1050:
this.$ = $$[$0-3] + $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 1051:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: "'" + $$[$0] + "'" }
     } else {
       this.$ = { types: [ 'STRING' ] }
     }
   
break;
case 1052:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: '"' + $$[$0] + '"' }
     } else {
       this.$ = { types: [ 'STRING' ], text: '"' + $$[$0] + '"' }
     }
   
break;
case 1053:
this.$ = { types: [ 'BOOLEAN' ], text: $$[$0] };
break;
case 1054:

    this.$ = { partialQuote: '\'', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 1055:

    this.$ = { partialQuote: '"', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 1062:

     this.$ = $$[$0];

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         this.$.suggestJoins = {
           prependJoin: true,
           tables: tables
         };
       }
      }
   
break;
case 1069:

     this.$ = {
       primary: $$[$0-1]
     }
     if ($$[$0-1].identifierChain) {
       if ($$[$0]) {
         $$[$0-1].alias = $$[$0].alias
         parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
       }
       parser.addTablePrimary($$[$0-1]);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     } else if ($$[$0].suggestKeywords) {
       keywords = $$[$0].suggestKeywords;
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 1070:

     this.$ = {
       primary: $$[$0-1]
     };

     if ($$[$0]) {
       this.$.primary.alias = $$[$0].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 1071:

     if ($$[$0]) {
       parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }
   
break;
case 1072:

     if ($$[$0]) {
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias);
     }
   
break;
case 1082:

     parser.pushQueryState();
   
break;
case 1083:

     parser.popQueryState();
   
break;
case 1085:

     if ($$[$0-1]) {
       $$[$0-2].alias = $$[$0-1].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0-1].alias });
       parser.addSubqueryAliasLocation($$[$0-1].location, $$[$0-1].alias, $$[$0-2].identifierChain);
     }
     this.$ = $$[$0-2];
   
break;
case 1088:

     var subQuery = parser.getSubQuery($$[$0]);
     subQuery.columns.forEach(function (column) {
       parser.expandIdentifierChain({ wrapper: column });
       delete column.linked;
     });
     parser.popQueryState(subQuery);
     this.$ = subQuery;
   
break;
case 1105: case 1106: case 1107: case 1108:
this.$ = { alias: $$[$0], location: _$[$0] };
break;
case 1115: case 1116:

     if (parser.yy.result.suggestFunctions) {
       parser.suggestAggregateFunctions();
     }
   
break;
case 1117:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords([{ value: 'PARTITION BY', weight: 2 }, { value: 'ORDER BY', weight: 1 }]);
     } else if (!$$[$0-2]) {
       parser.suggestKeywords(['PARTITION BY']);
     }
   
break;
case 1118:

      if (!$$[$0-1]) {
        parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ORDER BY', weight: 2 }]);
      } else {
        parser.suggestValueExpressionKeywords($$[$0-3]);
      }
    
break;
case 1127:

      // Only allowed in last order by
      delete parser.yy.result.suggestAnalyticFunctions;
    
break;
case 1128:

      var keywords = [];
      if ($$[$0-2].suggestKeywords) {
        keywords = parser.createWeightedKeywords($$[$0-2].suggestKeywords, 2);
      }
      if (!$$[$0]) {
        keywords = keywords.concat([{ value: 'RANGE BETWEEN', weight: 1 }, { value: 'ROWS BETWEEN', weight: 1 }]);
      }
      parser.suggestKeywords(keywords);
    
break;
case 1134:

     parser.suggestKeywords(['BETWEEN']);
   
break;
case 1135:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED PRECEDING']);
     } else if (!$$[$0-1]) {
       parser.suggestKeywords(['AND']);
     }
   
break;
case 1140:

    lexer.popState();
  
break;
case 1141:

    lexer.begin('hdfs');
  
break;
case 1143:

      parser.suggestHdfs({ path: $$[$0-3] });
    
break;
case 1144:

     parser.suggestHdfs({ path: $$[$0-2] });
   
break;
case 1145:

      parser.suggestHdfs({ path: $$[$0-1] });
    
break;
case 1146:

     parser.suggestHdfs({ path: '' });
   
break;
case 1147:

      parser.suggestHdfs({ path: '' });
    
break;
case 1153:

     parser.suggestKeywords(['PRECEDING']);
   
break;
case 1154: case 1159:

     parser.suggestKeywords(['ROW']);
   
break;
case 1158:

     parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED FOLLOWING']);
   
break;
case 1160:

     parser.suggestKeywords(['FOLLOWING']);
   
break;
case 1171:

     parser.suggestKeywords(['TABLES', 'CATALOGS', 'CURRENT CATALOG', 'DATABASES', 'CURRENT DATABASE', 'VIEWS', 'FUNCTIONS']);
   
break;
case 1179:
this.$ = { inValueEdit: true };
break;
case 1180:
this.$ = { inValueEdit: true, cursorAtStart: true };
break;
case 1181: case 1182: case 1183:

     this.$ = { suggestKeywords: ['NOT'] }
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1187: case 1188: case 1189:

     parser.suggestFunctions({ types: [ 'STRING' ] });
     parser.suggestColumns({ types: [ 'STRING' ] });
     this.$ = { types: ['BOOLEAN'] }
   
break;
case 1190:

     this.$ = parser.findCaseType($$[$0-1])
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1191:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1192:
this.$ = parser.findCaseType($$[$0-1]);
break;
case 1193:

     parser.suggestValueExpressionKeywords($$[$0-1], ['END']);
     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1194:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1195:
this.$ = parser.findCaseType($$[$0-2]);
break;
case 1196:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1197:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-2]);
   
break;
case 1198:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     this.$.suggestFilters = $$[$0-1].suggestFilters
   
break;
case 1199:

     parser.valueExpressionSuggest();
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 1200:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 1201:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = $$[$0-1];
   
break;
case 1202:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ] };
   
break;
case 1205:

     this.$ = { caseTypes: [ $$[$0] ], lastType: $$[$0] }
     parser.extractExpressionText(this.$, $$[$0]);
   
break;
case 1206:

     $$[$0-1].caseTypes.push($$[$0]);
     this.$ = { caseTypes: $$[$0-1].caseTypes, lastType: $$[$0] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 1210:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
   
break;
case 1212:

     this.$ = $$[$0]
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 1213:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0].suggestFilters };
break;
case 1214:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0-1].suggestFilters };
break;
case 1215:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0-2].suggestFilters };
break;
case 1216: case 1217:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0].suggestFilters };
break;
case 1218:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1219:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [$$[$0]] };
   
break;
case 1220:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1221:

      parser.valueExpressionSuggest();
      parser.suggestKeywords(['WHEN']);
      this.$ = { caseTypes: [{ types: ['T'] }] };
    
break;
case 1222: case 1224:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1223:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 1225:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [$$[$0]], suggestFilters: true };
   
break;
case 1226:

     parser.suggestValueExpressionKeywords($$[$0-1], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1227:

     parser.suggestValueExpressionKeywords($$[$0-2], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 1228: case 1229: case 1230: case 1231:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
}
},
table: [o($V0,$V1,{343:1,268:2}),{1:[3]},o($V2,$V3,{344:3,348:4,21:5,160:6,49:7,22:8,23:9,24:10,25:11,26:12,27:13,28:14,29:15,30:16,31:17,36:19,37:20,40:22,161:23,162:24,173:25,174:26,41:27,47:28,163:34,4:$V4,8:$V5,12:$V6,16:$V7,38:$V8,167:$V9,179:$Va,246:$Vb,276:$Vc,326:$Vd,342:$Ve,514:$Vf}),{345:[1,40],349:[1,41]},o($V2,[2,630]),o($V2,[2,636]),o($V2,[2,637]),o($V2,[2,638]),o($V2,[2,17]),o($V2,[2,18]),o($V2,[2,19]),o($V2,[2,20]),o($V2,[2,21]),o($V2,[2,22]),o($V2,[2,23]),o($V2,[2,24]),o($V2,[2,25]),o($V2,[2,26]),{32:[1,42],33:43,64:44,68:$Vg,118:$Vh,233:$Vi,352:47,353:$Vj,354:$Vk},o($V2,[2,29]),o($V2,[2,30]),{39:51,369:[1,54],508:[1,52],509:[1,53],511:[1,55],512:[1,56],513:[1,57]},o($V2,[2,32]),o($V2,[2,248]),o($V2,[2,249]),{84:[1,59],174:58,246:$Vb},o($Vl,$Vm,{175:60,263:61,265:62,267:$Vn}),{42:64,130:[1,65]},{48:[1,66]},{44:[1,69],52:[1,70],62:67,68:[1,68],370:$Vo,388:$Vp},{44:[1,75],52:[1,76],62:73,68:[1,74],370:$Vo,388:$Vp},{44:[1,77]},{64:78,68:$Vg,118:$Vh,233:$Vi,352:47,353:$Vj,354:$Vk},{45:79,64:81,68:$Vg,118:$Vh,124:80,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($V2,[2,250]),{64:81,68:$Vg,118:$Vh,124:87,233:$Vi,327:83,333:84,335:85,352:47,353:$Vj,354:$Vk,363:$Vq,432:86},{64:81,68:$Vg,118:$Vh,124:90,180:88,182:89,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o([59,60,68,84,100,101,112,117,118,233,258,272,274,275,276,299,300,301,302,303,304,305,306,307,308,309,311,312,353,354,356,357,360,363,367,375,394,395],$Vr,{247:91,32:$Vs,252:$Vt}),{44:[1,94],52:[1,95]},{168:[1,96]},{1:[2,625]},o($V0,$V1,{268:97}),o($V2,[2,27]),{34:[1,98],272:[1,99]},o($Vu,[2,475]),o($Vv,[2,648]),o($Vv,[2,649]),o($Vv,[2,650]),o($Vv,[2,645]),o($Vv,[2,646]),o($Vv,[2,647]),o($V2,[2,31]),o($V2,[2,1163]),o($V2,[2,1164]),{370:[1,101],510:[1,100]},o($V2,[2,1166]),o($V2,[2,1169]),o($V2,[2,1170]),o($Vl,$Vm,{263:61,265:62,175:102,267:$Vn}),{49:103,173:25,174:26,179:$Va,246:$Vb},o($Vl,[2,266]),o($Vl,[2,456],{265:104,267:$Vn}),o($Vw,[2,458]),o([32,246,252],$V1,{268:105}),o($V2,[2,33]),{84:[1,106]},{49:107,173:25,174:26,179:$Va,246:$Vb},o($Vx,$Vy,{63:108,311:$Vz}),{64:110,68:$Vg,118:$Vh,233:$Vi,352:47,353:$Vj,354:$Vk},o($VA,$Vy,{63:111,311:$Vz}),o($VA,$Vy,{63:112,311:$Vz}),o($VB,[2,765]),o($VB,[2,766]),o($VA,$VC,{155:113,311:$VD}),{64:115,68:$Vg,118:$Vh,233:$Vi,352:47,353:$Vj,354:$Vk},o($VA,$VC,{155:116,311:$VD}),o($VA,$VC,{155:117,311:$VD}),o($VA,$VC,{155:118,311:$VD}),o($V2,[2,623]),o($V2,[2,1172]),o($V2,$VE,{272:[1,119]}),o($Vv,[2,855]),{61:[1,120],363:[1,121]},{16:[1,122]},{16:[2,602]},{16:[2,604]},{16:[2,862],64:81,68:$Vg,118:$Vh,124:123,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($VF,[2,858],{272:[1,124]}),o([84,246],[2,275],{90:[1,125]}),o($VG,[2,277]),{48:[1,126]},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:129,232:159,233:$Vi,248:127,255:128,258:$VO,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vb1,[2,418]),o($Vb1,[2,419]),{45:185,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{45:187,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($VA,[2,262],{169:188,44:[1,189]}),o($V2,$V3,{348:4,21:5,160:6,49:7,22:8,23:9,24:10,25:11,26:12,27:13,28:14,29:15,30:16,31:17,36:19,37:20,40:22,161:23,162:24,173:25,174:26,41:27,47:28,163:34,344:190,4:$V4,8:$V5,12:$V6,16:$V7,38:$V8,167:$V9,179:$Va,246:$Vb,276:$Vc,326:$Vd,342:$Ve,514:$Vf}),{35:191,56:194,59:$VH,60:$VI,64:192,68:$Vg,101:[1,197],118:$Vh,232:198,233:$Vi,272:$VP,273:193,274:[1,195],275:[1,196],352:47,353:$Vj,354:$Vk,357:[1,199],394:$V91,395:$Va1,400:201,403:202,453:[1,200],458:165,459:166},{64:203,68:$Vg,118:$Vh,233:$Vi,352:47,353:$Vj,354:$Vk},o($V2,[2,1165]),o($V2,[2,1167]),o($Vl,[2,264]),{86:[1,204]},o($Vw,[2,459]),{32:$Vs,246:$Vr,247:205,252:$Vt},{64:81,68:$Vg,92:208,118:$Vh,124:161,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,414:206,430:207},o($V2,[2,41]),o($V2,[2,58],{352:47,64:209,68:$Vg,118:$Vh,233:$Vi,353:$Vj,354:$Vk}),{100:[1,210]},o($V2,[2,67]),{64:81,68:$Vg,69:211,71:212,77:213,118:$Vh,124:214,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{64:81,68:$Vg,77:215,118:$Vh,124:214,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{64:81,68:$Vg,118:$Vh,124:216,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{375:[1,217]},o($V2,[2,233]),{45:218,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{45:219,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{45:220,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{45:221,64:81,68:$Vg,118:$Vh,124:222,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{363:[1,223]},o($Vv,[2,857]),{64:81,68:$Vg,92:153,118:$Vh,124:161,154:227,233:$Vi,328:224,337:225,339:226,352:47,353:$Vj,354:$Vk,363:$Vq,434:228},{16:[2,863]},{64:81,68:$Vg,118:$Vh,124:229,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{64:81,68:$Vg,118:$Vh,124:90,182:230,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{84:[1,231]},o($Vw,[2,407],{249:232,186:234,90:[1,233],187:[1,235]}),o($Vc1,[2,424]),o($Vc1,$Vd1,{352:47,64:81,400:201,403:202,257:236,445:250,124:251,56:252,34:$Ve1,48:$Vf1,59:$VH,60:$VI,68:$Vg,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,118:$Vh,147:$Vk1,233:$Vi,258:$Vl1,353:$Vj,354:$Vk,357:$Vm1,361:$Vn1,362:$Vo1,363:$Vq,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($Vc1,[2,440]),o($Vv1,[2,899]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:257,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:258,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:259,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:260,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{84:$Vw1,442:261},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:263,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:265,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,397:$Vx1,400:167,403:168,434:144,446:264,454:152,456:160,458:165,459:166,460:169,515:266,517:267},o($Vv1,[2,557],{315:269,84:$Vy1}),{84:$Vy1,315:271},o($Vv1,[2,555]),o($Vv1,[2,556]),o($Vv1,[2,558]),o($Vz1,[2,1031],{272:[1,272]}),{84:[2,537]},{84:[2,538]},{84:[2,539]},{84:[2,540]},o($Vv1,[2,586],{280:273,282:274,323:$VA1}),{282:276,323:$VA1},o($Vv1,[2,494]),o($Vv1,[2,1037]),o($VB1,[2,869]),o($VC1,[2,502]),o($VC1,[2,503]),o($VC1,[2,504]),{84:[1,277]},{84:[1,278]},o($Vv1,[2,1039]),o($Vv1,[2,1040]),o([34,48,55,59,60,68,82,84,86,90,100,112,113,114,117,118,134,147,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,258,267,269,272,345,349,353,354,357,361,362,363,364,365,366,368,371,372,373,374,376,379,380,381,382,384,385,387,389,390,391,392,393,396,397,444],[2,879]),{84:[1,279]},{84:[1,280]},{84:[1,281]},o($Vv1,[2,1042]),o($Vv1,[2,1043]),o($Vv1,[2,1051]),o($Vv1,[2,1052]),o($Vv1,[2,1053]),{84:[2,513]},{84:[2,514]},{84:[2,515]},{84:[2,516]},{84:[2,517]},{84:[2,518]},{84:[2,519]},{84:[2,520]},o($Vv1,[2,1044],{272:[1,282]}),{394:[1,283],395:[1,284]},{394:[1,285]},{59:[1,287],61:[1,286]},{60:[1,289],61:[1,288]},o($Vv1,[2,1056]),o($Vv1,[2,1057]),{130:[2,38]},o($VD1,$VE,{272:$VE1}),{48:[2,47]},{45:291,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($VA,[2,263]),o($V2,[2,631]),o($V2,[2,28]),o($V2,[2,477]),o($V2,[2,478],{352:47,64:292,68:$Vg,118:$Vh,233:$Vi,353:$Vj,354:$Vk}),o($V2,[2,480]),o($V2,[2,481]),o($V2,[2,482]),o($V2,[2,483]),o($Vx,[2,1034]),{232:293,272:$VP,394:$V91,395:$Va1,458:165,459:166},{232:294,272:$VP,394:$V91,395:$Va1,458:165,459:166},o($VF1,[2,773]),o($VF1,[2,774]),o($Vu,[2,476]),o($Vl,$Vm,{263:61,265:62,175:295,267:$Vn}),{174:296,246:$Vb},{86:[1,297],90:[1,298]},o($VG1,[2,844]),{34:[1,299]},o($V2,$VH1,{65:300,53:301,54:302,55:$VI1}),{375:[1,304]},o($V2,[2,68]),o($VJ1,[2,164],{72:305,129:306,130:[1,307]}),o($VK1,[2,80],{78:308,81:309,82:[1,310],84:[1,311]}),o($VL1,[2,837],{272:[1,312]}),o($VM1,[2,216],{149:313,151:314,84:[1,315]}),o($V2,[2,780],{156:316,410:[1,317]}),o($VA,[2,783]),o($V2,[2,240],{158:318,159:[1,319]}),o($V2,[2,242]),o($V2,[2,484]),o($V2,[2,1173]),o($V2,$VN1,{272:$VE1}),o($Vv,[2,856]),o($VO1,[2,619],{329:320,90:[1,321],187:[1,322]}),o($VP1,[2,606]),{34:[1,323]},{34:[2,616]},o($VQ1,[2,866],{272:[1,324]}),o($VF,[2,859]),o($VG,[2,278]),o($VR1,$VS1,{184:325,471:326}),o($Vw,[2,408]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:129,232:159,233:$Vi,255:327,258:$VO,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VT1,$VU1,{253:328,260:329,262:330,269:$VV1}),{45:339,64:81,68:$Vg,84:$Vw1,118:$Vh,124:186,188:332,191:333,212:335,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,442:340,461:334,463:336,465:337,466:338},o($Vc1,[2,439]),o($VW1,[2,1058],{441:341,100:[1,342]}),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:343,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:344,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:345,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:346,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{82:$Vg1,364:[1,348],379:[1,347],384:$Vt1,385:$Vu1,445:349},{84:[1,350]},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:351,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:352,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:353,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:354,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:355,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:356,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vv1,[2,925]),o($VX1,[2,1105]),o($VX1,[2,1106]),{56:358,59:$VH,60:$VI,64:81,68:$Vg,118:$Vh,124:357,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,400:201,403:202},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:359,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:360,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:361,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VY1,[2,900],{445:250,34:$Ve1,82:$Vg1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VY1,[2,901],{445:250,34:$Ve1,82:$Vg1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VY1,[2,902],{445:250,34:$Ve1,82:$Vg1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VZ1,[2,903],{445:250}),o($Vv1,[2,908]),o($VR1,$VS1,{471:326,442:340,184:362,466:363,84:$Vw1}),{34:$Ve1,82:$Vg1,86:[1,364],100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,445:250},o($Vv1,[2,927]),{34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,397:$Vx1,445:250,446:365,515:266,517:267},{373:[1,367],374:[1,366],397:$Vx1,517:368},o($V_1,[2,1205]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:369,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vv1,[2,553]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,86:[1,370],92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:372,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,297:371,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vv1,[2,554]),{64:81,68:$Vg,92:374,118:$Vh,124:161,233:$Vi,258:[1,373],352:47,353:$Vj,354:$Vk,363:$Vq},o($Vv1,[2,492]),o($Vv1,[2,587]),{64:81,68:$Vg,84:[1,377],118:$Vh,124:375,233:$Vi,324:376,352:47,353:$Vj,354:$Vk,363:$Vq},o($Vv1,[2,493]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,86:[1,378],92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:372,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,297:379,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,86:[1,381],92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:380,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o([59,60,68,84,86,100,101,112,117,118,233,272,274,275,276,299,300,301,302,303,304,305,306,307,308,309,311,312,353,354,356,357,360,363,367,375,394,395],$Vr,{247:382,32:$Vs,252:$Vt}),o($V$1,$Vr,{247:385,32:$Vs,86:[1,384],252:$Vt,258:[1,383]}),o($V$1,$Vr,{247:386,32:$Vs,86:[1,387],252:$Vt}),o($Vv1,[2,1045],{394:[1,388],395:[1,389]}),o($Vv1,[2,1047]),{394:[1,390]},o($Vv1,[2,1048]),{59:[1,391]},o($V02,[2,768]),{60:[1,392]},o($V02,[2,771]),{64:81,68:$Vg,118:$Vh,124:393,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{145:[1,394]},o($V2,[2,479]),o($Vx,[2,1035]),o($Vx,[2,1036]),o($Vl,[2,265]),o($Vw,[2,464]),o($V2,[2,795]),{64:81,68:$Vg,92:208,118:$Vh,124:161,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,430:395},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:396,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($V2,[2,59]),o($V2,[2,65]),o([48,86,90,114,345,349],[2,51]),{56:397,59:$VH,60:$VI,400:201,403:202},o([68,118,233,345,349,353,354,363],[2,786]),o($V2,[2,202],{73:398,48:[1,399]}),o($VJ1,[2,165]),{131:[1,400]},o($VK1,[2,77]),o($VK1,[2,81]),{45:401,64:81,68:$Vg,118:$Vh,124:186,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{64:81,68:$Vg,85:402,89:403,92:404,118:$Vh,124:161,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{64:81,68:$Vg,118:$Vh,124:405,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{48:$VH1,53:406,54:302,55:$VI1},o($VM1,[2,217]),{64:81,68:$Vg,92:153,118:$Vh,124:161,152:407,154:408,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,434:228},o($V2,[2,226]),o($V2,[2,781]),o($V2,[2,234]),o($V2,[2,241]),o($V2,$VU1,{262:330,260:409,269:$VV1}),{64:81,68:$Vg,92:153,118:$Vh,124:161,154:227,233:$Vi,337:410,339:226,352:47,353:$Vj,354:$Vk,363:$Vq,434:228},{45:339,64:81,68:$Vg,84:$Vw1,118:$Vh,124:186,191:411,212:335,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,442:340,461:334,463:336,465:337,466:338},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:413,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,340:412,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{64:81,68:$Vg,92:374,118:$Vh,124:161,233:$Vi,258:[1,414],352:47,353:$Vj,354:$Vk,363:$Vq},{86:[1,415]},{49:423,173:25,174:26,179:$Va,246:$Vb,473:416,475:417,477:418,479:419,481:420,483:421,485:422},o($Vc1,[2,425]),o($Vw,[2,420]),o($V12,[2,297],{193:424,194:425,195:[1,426]}),o($VT1,[2,469]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:428,232:159,233:$Vi,270:427,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o([86,195,206,231,237,267,269,345,349],[2,287],{90:[1,429]}),o($V22,[2,290]),o($V22,[2,1060]),o($V22,[2,1062],{209:430,211:431,219:$V32,220:$V42,221:$V52,222:$V62,223:$V72,224:$V82,225:$V92,226:$Va2}),o($V22,[2,1063]),o($Vb2,$Vd1,{352:47,64:81,400:201,403:202,124:251,56:252,257:440,48:$Vf1,59:$VH,60:$VI,68:$Vg,118:$Vh,233:$Vi,353:$Vj,354:$Vk,363:$Vq}),o($Vb2,$Vd1,{352:47,64:81,400:201,403:202,124:251,56:252,257:441,48:$Vf1,59:$VH,60:$VI,68:$Vg,118:$Vh,233:$Vi,353:$Vj,354:$Vk,363:$Vq}),o($Vc2,[2,1074]),o($Vc2,[2,1076]),{101:[1,442],252:[1,445],274:[1,443],275:[1,444]},o($VW1,[2,1059]),o($Vd2,[2,910],{445:250,82:$Vg1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($Vd2,[2,911],{445:250,82:$Vg1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($Vd2,[2,912],{445:250,82:$Vg1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($Vd2,[2,913],{445:250,82:$Vg1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),{84:[1,446]},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:447,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vv1,[2,926]),o($VR1,$VS1,{352:47,64:81,313:131,314:139,310:140,278:141,316:142,434:144,279:149,281:150,283:151,454:152,92:153,290:154,291:155,292:156,232:159,456:160,124:161,296:162,458:165,459:166,400:167,403:168,460:169,471:326,184:448,443:449,143:450,59:$VH,60:$VI,68:$Vg,84:$VJ,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,311:$V21,312:$V31,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1}),{34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,444:[1,451],445:250},o($Ve2,[2,920],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($Ve2,[2,921],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VZ1,[2,922],{445:250,82:$Vg1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VZ1,[2,923],{445:250,82:$Vg1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VZ1,[2,924],{445:250,82:$Vg1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VX1,[2,1107]),o($VX1,[2,1108]),o($VZ1,[2,1181],{445:250}),o($VZ1,[2,1182],{445:250}),o($VZ1,[2,1183],{445:250}),{86:[1,452]},{48:$Vf1,56:252,59:$VH,60:$VI,64:81,68:$Vg,86:$Vd1,118:$Vh,124:251,233:$Vi,257:453,352:47,353:$Vj,354:$Vk,363:$Vq,400:201,403:202},o($Vv1,[2,909]),o($Vv1,[2,928]),o($Vv1,[2,1190]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:454,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($V_1,[2,1206]),{34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,391:[1,455],445:250},o($Vv1,[2,568]),{86:[1,456],90:$Vf2},o($VG1,[2,573],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($Vz1,[2,1032]),o($VB1,[2,870]),o($Vv1,[2,589]),o($Vv1,[2,590]),o($Vg2,[2,1119],{487:458,491:459,130:[1,460]}),{323:[2,532]},{86:[1,461],90:$Vf2},{34:$Ve1,48:[1,462],82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,445:250},o($Vv1,[2,542]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,86:[1,463],92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:372,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,297:464,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{86:[1,465]},o($VC1,[2,522]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:372,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,297:466,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:467,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VC1,[2,528]),o($Vv1,[2,1046]),{394:[1,468]},o($Vv1,[2,1049]),o($V02,[2,767]),o($V02,[2,770]),o($VD1,$VN1),{84:$Vh2,170:469,171:470},o($VG1,[2,845]),o($VG1,[2,850],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o([48,55,86,90,100,101,114,345,349],[2,52]),o($V2,[2,72]),o($VR1,[2,206],{148:472}),{132:473,134:[1,474]},o($VK1,[2,82]),{86:[1,475],90:[1,476]},o($VG1,[2,88]),{93:477,102:478,103:479,104:480,105:481,106:482,107:483,108:484,112:$Vi2,117:$Vj2,118:$Vk2,365:$Vl2,366:$Vm2,368:$Vn2,371:$Vo2,372:$Vp2,376:$Vq2,380:$Vr2,389:$Vs2,390:$Vt2,392:$Vu2,393:$Vv2,396:$Vw2},o($VL1,[2,838]),{48:[1,500]},{86:[1,501],90:[1,502]},o($VG1,$VH1,{54:302,53:503,55:$VI1}),o($V2,[2,592]),o($VP1,[2,607]),o($VO1,[2,620]),o($VP1,[2,612]),o($VP1,[2,617],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($VQ1,[2,867]),o($VG,[2,283]),{86:[2,1088]},{86:[2,1090]},{86:[2,1092]},{86:[2,1094]},{86:[2,1096]},{86:[2,1098]},{86:[2,1100]},{86:[2,1102]},o($Vx2,[2,326],{204:504,205:505,206:[1,506]}),o($V12,[2,298]),{131:[1,507]},o($VT1,[2,470]),o($VT1,[2,473],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),{45:339,64:81,68:$Vg,84:$Vw1,118:$Vh,124:186,191:508,212:335,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,442:340,461:334,463:336,465:337,466:338},o($V22,[2,1066],{211:509,219:$V32,220:$V42,221:$V52,222:$V62,223:$V72,224:$V82,225:$V92,226:$Va2}),{45:339,64:81,68:$Vg,84:$Vw1,118:$Vh,124:186,212:510,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,442:340,465:337,466:338},{220:[1,511]},{220:[1,512],222:[1,513]},{220:[1,514]},o($Vy2,[2,351]),{220:[1,516],222:[1,517],223:[1,515],225:[1,518]},{220:[1,519]},{220:[1,521],222:[1,522],223:[1,520],225:[1,523]},{220:[1,524]},o($Vb2,[2,1069]),o($Vb2,[2,1070]),o($Vv1,[2,904]),o($Vv1,[2,905]),o($Vv1,[2,906]),{187:[1,525]},o($VR1,$VS1,{352:47,64:81,313:131,314:139,310:140,278:141,316:142,434:144,279:149,281:150,283:151,454:152,92:153,290:154,291:155,292:156,232:159,456:160,124:161,296:162,458:165,459:166,400:167,403:168,460:169,471:326,143:450,184:526,443:527,59:$VH,60:$VI,68:$Vg,84:$VJ,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,311:$V21,312:$V31,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1}),{34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,444:[1,528],445:250},{86:[1,529]},{86:[1,530],90:$Vz2},o($VA2,[2,1016],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:532,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VB2,[2,1084]),{86:[1,533]},{34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,374:[1,534],379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,445:250},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:535,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vv1,[2,569]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:536,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{86:[2,1125],236:538,237:$VC2,488:537},o($Vg2,[2,1120]),{131:[1,540]},{323:[2,533]},{102:541,365:$Vl2,366:$Vm2,368:$Vn2,371:$Vo2,372:$Vp2,376:$Vq2,380:$Vr2,389:$Vs2,390:$Vt2,392:$Vu2,393:$Vv2,396:$Vw2},o($VC1,[2,508]),{86:[1,542],90:$Vf2},o($VC1,[2,521]),{86:[1,543],90:$Vf2},{34:$Ve1,82:$Vg1,86:[1,544],100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,445:250},o($Vv1,[2,1050]),o($V2,[2,253],{90:[1,545]}),o($VD2,[2,259]),{59:$VH,60:$VI,64:81,68:$Vg,92:153,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,172:546,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:547,314:139,316:142,352:47,353:$Vj,354:$Vk,363:$Vq,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{49:548,173:25,174:26,179:$Va,246:$Vb},o($VJ1,[2,166]),{84:[1,550],135:549},o($VK1,[2,86]),{64:81,68:$Vg,89:551,92:404,118:$Vh,124:161,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($VG1,[2,102],{94:552,97:553,98:554,54:557,55:$VI1,100:$VE2,101:$VF2}),o($VG2,[2,114]),o($VG2,[2,115]),o($VG2,[2,116]),o($VG2,[2,117]),o($VG2,[2,118]),o($VG2,[2,119]),o($VG2,[2,120]),o($VG2,[2,882]),o($VG2,[2,883]),o($VG2,$VH2,{439:558,84:$VI2}),o($VG2,[2,896],{440:560,84:[1,561]}),o($VG2,[2,886]),o($VG2,[2,887]),o($VG2,[2,888]),o($VG2,[2,889]),o($VG2,[2,890]),o($VG2,[2,891]),o($VG2,[2,892]),o($VG2,$VH2,{439:562,84:$VI2}),{113:[1,563]},{113:[1,564]},{113:[1,565]},{49:566,173:25,174:26,179:$Va,246:$Vb},o($VM1,[2,218]),{64:81,68:$Vg,92:153,118:$Vh,124:161,154:567,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,434:228},o($VG1,[2,220]),o($VJ2,[2,389],{235:568,236:569,237:$VC2}),o($Vx2,[2,327]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:570,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:572,196:571,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($V22,[2,291]),{45:339,64:81,68:$Vg,84:$Vw1,118:$Vh,124:186,212:573,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,442:340,465:337,466:338},o($VK2,$VL2,{213:574,227:$VM2}),o($Vy2,[2,347]),o($Vy2,[2,348]),{220:[1,576]},o($Vy2,[2,350]),{220:[1,577]},o($Vy2,[2,353]),{220:[1,578]},{220:[1,579]},o($Vy2,[2,356]),{220:[1,580]},o($Vy2,[2,358]),{220:[1,581]},{220:[1,582]},o($Vy2,[2,361]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:583,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{86:[1,584]},{86:[1,585],90:$Vz2},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:586,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vv1,[2,916]),o($Vv1,[2,917]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:587,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o([48,59,60,68,86,90,118,134,187,195,206,219,220,221,222,223,224,225,226,231,233,237,244,245,267,269,345,349,353,354,361,363,364,373,374,382,387,391,397,444],[2,919],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VB2,[2,1085]),o($Vv1,[2,1191]),o($V_1,[2,1212],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($VG1,[2,574],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),{86:[1,588]},{86:[2,1130],134:[1,593],387:[1,592],492:589,494:590,495:591},{131:[1,594]},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:450,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,443:595,454:152,456:160,458:165,459:166,460:169},{86:[1,596]},o($VC1,[2,509]),o($VC1,[2,523]),o($VC1,[2,527]),{84:$Vh2,171:597},{86:[1,598],90:[1,599]},o($VG1,[2,1029]),o($V2,[2,203]),{84:[1,601],136:600},{64:81,68:$Vg,92:603,118:$Vh,124:161,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq,426:602},o($VG1,[2,89]),o($VG1,[2,98]),o($VG1,[2,103],{54:557,98:604,55:$VI1,100:$VE2,101:$VF2}),o($VN2,[2,104]),{101:[1,605]},o($VN2,[2,111]),o($VN2,[2,112]),o($VG2,[2,884]),{394:[1,606]},o($VG2,[2,885]),{394:[1,607]},o($VG2,[2,893]),{93:608,102:478,103:479,104:480,105:481,106:482,107:483,108:484,112:$Vi2,114:[1,609],117:$Vj2,118:$Vk2,365:$Vl2,366:$Vm2,368:$Vn2,371:$Vo2,372:$Vp2,376:$Vq2,380:$Vr2,389:$Vs2,390:$Vt2,392:$Vu2,393:$Vv2,396:$Vw2},{102:610,114:[1,611],365:$Vl2,366:$Vm2,368:$Vn2,371:$Vo2,372:$Vp2,376:$Vq2,380:$Vr2,389:$Vs2,390:$Vt2,392:$Vu2,393:$Vv2,396:$Vw2},{64:81,68:$Vg,114:[1,613],118:$Vh,119:612,121:614,124:615,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($V2,[2,207]),o($VG1,$VH1,{54:302,53:616,55:$VI1}),o($Vw,[2,382],{229:617,230:618,231:[1,619]}),o($VJ2,[2,390]),o($Vx2,[2,328],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($V12,[2,299],{90:[1,620]}),o($VO2,[2,314],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($VK2,$VL2,{213:621,227:$VM2}),o($VK2,[2,334]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:622,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vy2,[2,349]),o($Vy2,[2,352]),o($Vy2,[2,354]),o($Vy2,[2,355]),o($Vy2,[2,357]),o($Vy2,[2,359]),o($Vy2,[2,360]),o($VZ1,[2,907],{445:250}),o($Vv1,[2,914]),o($Vv1,[2,915]),o($VY1,[2,918],{445:250,34:$Ve1,82:$Vg1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,362:$Vo1,379:$Vq1,381:$Vr1,384:$Vt1,385:$Vu1}),o($VA2,[2,1017],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($Vv1,[2,1114]),{86:[2,1126]},{86:[2,1131]},{364:[1,623],499:[1,624]},o($VP2,[2,1148]),o($VP2,[2,1149]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:627,232:159,233:$Vi,238:625,241:626,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($Vg2,[2,1121],{90:$Vz2}),o($Vv1,[2,541]),o($VD2,[2,260]),o($VD2,[2,261]),{59:$VH,60:$VI,64:81,68:$Vg,92:153,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:628,314:139,316:142,352:47,353:$Vj,354:$Vk,363:$Vq,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VJ1,[2,170]),{130:$VQ2,139:629,141:630},{86:[1,632],90:[1,633]},o($VG1,[2,825]),o($VN2,[2,105]),o($VN2,[2,110]),{86:[1,634]},{86:[1,635],90:[1,636]},{114:[1,637]},o($VG2,[2,125]),{90:[1,638]},o($VG2,[2,129]),{90:[1,640],114:[1,639]},o($VG2,[2,135]),o($VR2,[2,137]),{125:[1,641]},o($VG1,[2,221]),o($Vw,[2,444]),o($Vw,[2,383]),{232:642,233:[1,643],272:$VP,394:$V91,395:$Va1,458:165,459:166},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:644,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VK2,[2,335]),o($VK2,[2,377],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($VS2,$VT2,{496:645}),o($VS2,$VT2,{496:646}),o([86,134,231,267,345,349,387],[2,391],{90:[1,647]}),o($VU2,[2,394]),o($VU2,[2,404],{445:250,243:648,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,244:[1,649],245:[1,650],258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($VG1,[2,1030]),{86:[1,651],90:[1,652]},o($VG1,[2,179]),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:653,145:[1,654],232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{84:[2,822]},{64:81,68:$Vg,92:655,118:$Vh,124:161,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},o($VG2,[2,895]),o($VG2,[2,897]),{394:[1,656]},o($VG2,[2,124]),{93:657,102:478,103:479,104:480,105:481,106:482,107:483,108:484,112:$Vi2,117:$Vj2,118:$Vk2,365:$Vl2,366:$Vm2,368:$Vn2,371:$Vo2,372:$Vp2,376:$Vq2,380:$Vr2,389:$Vs2,390:$Vt2,392:$Vu2,393:$Vv2,396:$Vw2},o($VG2,[2,134]),{64:81,68:$Vg,118:$Vh,121:658,124:615,233:$Vi,352:47,353:$Vj,354:$Vk,363:$Vq},{93:659,102:478,103:479,104:480,105:481,106:482,107:483,108:484,112:$Vi2,117:$Vj2,118:$Vk2,365:$Vl2,366:$Vm2,368:$Vn2,371:$Vo2,372:$Vp2,376:$Vq2,380:$Vr2,389:$Vs2,390:$Vt2,392:$Vu2,393:$Vv2,396:$Vw2},o($Vw,[2,384],{90:[1,660]}),o($Vw,[2,386],{90:[1,661]}),o($VO2,[2,315],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),o($VV2,$VW2,{497:662,507:663,369:$VX2,394:$VY2,499:$VZ2}),o($VV2,$VW2,{507:663,497:667,369:$VX2,394:$VY2,499:$VZ2}),{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:627,232:159,233:$Vi,241:668,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($VU2,[2,401]),o($VU2,[2,405]),o($VU2,[2,406]),o($VJ1,[2,176]),{130:$VQ2,141:669},{34:$Ve1,82:$Vg1,100:$Vh1,113:[1,671],114:$Vj1,144:670,147:[1,672],258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1,445:250},{113:$V_2,144:673,147:$V$2},o($VG1,[2,826]),{86:[1,676]},{114:[1,677]},o($VR2,[2,138]),o($VR2,$VH1,{54:302,53:678,55:$VI1}),{232:679,272:$VP,394:$V91,395:$Va1,458:165,459:166},{233:[1,680]},{86:$V03,361:$V13,498:681},{383:[1,683]},{386:[1,684]},o($V23,[2,1161]),o($V23,[2,1162]),{86:$V03,361:$V13,498:685},o($VU2,[2,395]),o($VG1,[2,180]),{145:[1,686]},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:344,145:$V33,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:346,145:$V43,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:687,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},o($V$1,$V33),o($V$1,$V43),o($VG2,[2,898]),o($VG2,[2,128]),o($VR2,[2,144]),o($Vw,[2,385]),o($Vw,[2,387]),{86:[2,1132]},{369:[1,688],394:$VY2,499:$VZ2,507:689},o($VV2,[2,1151]),o($VV2,[2,1152]),{86:[2,1133]},o($VG1,[2,188],{144:690,113:$V_2,147:$V$2}),o($VG1,[2,187],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1}),{386:[1,691]},{377:[1,692]},{59:$VH,60:$VI,64:81,68:$Vg,84:$VJ,92:153,100:$VK,101:$VL,112:$VM,117:$VN,118:$Vh,124:161,143:693,232:159,233:$Vi,272:$VP,274:$VQ,275:$VR,276:$VS,278:141,279:149,281:150,283:151,290:154,291:155,292:156,296:162,299:$VT,300:$VU,301:$VV,302:$VW,303:$VX,304:$VY,305:$VZ,306:$V_,307:$V$,308:$V01,309:$V11,310:140,311:$V21,312:$V31,313:131,314:139,316:142,352:47,353:$Vj,354:$Vk,356:$V41,357:$V51,360:$V61,363:$Vq,367:$V71,375:$V81,394:$V91,395:$Va1,400:167,403:168,434:144,454:152,456:160,458:165,459:166,460:169},{86:[2,1156]},{86:[2,1157]},o($VG1,[2,186],{445:250,34:$Ve1,82:$Vg1,100:$Vh1,113:$Vi1,114:$Vj1,147:$Vk1,258:$Vl1,357:$Vm1,361:$Vn1,362:$Vo1,364:$Vp1,379:$Vq1,381:$Vr1,382:$Vs1,384:$Vt1,385:$Vu1})],
defaultActions: {40:[2,625],84:[2,602],85:[2,604],123:[2,863],145:[2,537],146:[2,538],147:[2,539],148:[2,540],170:[2,513],171:[2,514],172:[2,515],173:[2,516],174:[2,517],175:[2,518],176:[2,519],177:[2,520],185:[2,38],187:[2,47],227:[2,616],378:[2,532],416:[2,1088],417:[2,1090],418:[2,1092],419:[2,1094],420:[2,1096],421:[2,1098],422:[2,1100],423:[2,1102],461:[2,533],589:[2,1126],590:[2,1131],632:[2,822],681:[2,1132],685:[2,1133],691:[2,1156],692:[2,1157]},
parseError: function parseError (str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
    }
},
parse: function parse (input) {
    var self = this,
        stack = [0],
        tstack = [], // token stack
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    var args = lstack.slice.call(arguments, 1);

    //this.reductionCount = this.shiftCount = 0;

    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    // copy state
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }

    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);

    var ranges = lexer.options && lexer.options.ranges;

    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }

    function popStack (n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

_token_stack:
    var lex = function () {
        var token;
        token = lexer.lex() || EOF;
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length - 1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

_handle_error:
        // handle parse error
        if (typeof action === 'undefined' || !action.length || !action[0]) {
            var error_rule_depth;
            var errStr = '';

            // Return the rule stack depth where the nearest error rule can be found.
            // Return FALSE when no error recovery rule was found.
            function locateNearestErrorRecoveryRule(state) {
                var stack_probe = stack.length - 1;
                var depth = 0;

                // try to recover from error
                for(;;) {
                    // check for error recovery rule in this state
                    if ((TERROR.toString()) in table[state]) {
                        return depth;
                    }
                    if (state === 0 || stack_probe < 2) {
                        return false; // No suitable error recovery rule available.
                    }
                    stack_probe -= 2; // popStack(1): [symbol, action]
                    state = stack[stack_probe];
                    ++depth;
                }
            }

            if (!recovering) {
                // first see if there's any chance at hitting an error recovery rule:
                error_rule_depth = locateNearestErrorRecoveryRule(state);

                // Report error
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push("'"+this.terminals_[p]+"'");
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol)+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == EOF ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: lexer.yylloc,
                    ruleId: stack.slice(stack.length - 2, stack.length).join('_'),
                    expected: expected,
                    recoverable: (error_rule_depth !== false)
                });
            } else if (preErrorSymbol !== EOF) {
                error_rule_depth = locateNearestErrorRecoveryRule(state);
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol === EOF || preErrorSymbol === EOF) {
                    throw new Error(errStr || 'Parsing halted while starting to recover from another error.');
                }

                // discard current lookahead and grab another
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            if (error_rule_depth === false) {
                throw new Error(errStr || 'Parsing halted. No suitable error recovery rule available.');
            }
            popStack(error_rule_depth);

            preErrorSymbol = (symbol == TERROR ? null : symbol); // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {
            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(lexer.yytext);
                lstack.push(lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = lexer.yyleng;
                    yytext = lexer.yytext;
                    yylineno = lexer.yylineno;
                    yyloc = lexer.yylloc;
                    if (recovering > 0) {
                        recovering--;
                    }
                } else {
                    // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2:
                // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                if (ranges) {
                  yyval._$.range = [lstack[lstack.length-(len||1)].range[0], lstack[lstack.length-1].range[1]];
                }
                r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3:
                // accept
                return true;
        }

    }

    return true;
}};


SqlParseSupport.initSyntaxParser(parser);/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function(match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex () {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin (condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState () {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules () {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState (n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState (condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {"case-insensitive":true,"flex":true},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: /* skip whitespace */ 
break;
case 1: /* skip comments */ 
break;
case 2: /* skip comments */ 
break;
case 3: parser.yy.partialCursor = false; parser.yy.cursorFound = yy_.yylloc; return 5; 
break;
case 4: parser.yy.partialCursor = true; parser.yy.cursorFound = yy_.yylloc; return 398; 
break;
case 5: this.popState(); return 444; 
break;
case 6: return 32; 
break;
case 7: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('ALTER', yy_.yylloc, yy.lexer.upcomingInput()); return 4; 
break;
case 8: return 361; 
break;
case 9: return 48; 
break;
case 10: return 244; 
break;
case 11: this.begin('between'); return 364; 
break;
case 12: return 365; 
break;
case 13: return 366; 
break;
case 14: return 131; 
break;
case 15: return 410; 
break;
case 16: return 367; 
break;
case 17: return 368; 
break;
case 18: return 55; 
break;
case 19: parser.determineCase(yy_.yytext); return 8; 
break;
case 20: return 219; 
break;
case 21: return 369; 
break;
case 22: return 370; 
break;
case 23: return 371; 
break;
case 24: return 245; 
break;
case 25: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('DESCRIBE', yy_.yylloc); return 514; 
break;
case 26: return 252; 
break;
case 27: return 362; 
break;
case 28: return 372; 
break;
case 29: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('DROP', yy_.yylloc, yy.lexer.upcomingInput()); return 12; 
break;
case 30: return 373; 
break;
case 31: return 374; 
break;
case 32: parser.yy.correlatedSubQuery = true; return 375; 
break;
case 33: return 275; 
break;
case 34: return 376; 
break;
case 35: return 377; 
break;
case 36: parser.determineCase(yy_.yytext); return 187; 
break;
case 37: return 221; 
break;
case 38: return 195; 
break;
case 39: return 206; 
break;
case 40: return 311; 
break;
case 41: return 379; 
break;
case 42: return 223; 
break;
case 43: return 167; 
break;
case 44: return 380; 
break;
case 45: return 168; 
break;
case 46: return 381; 
break;
case 47: return 220; 
break;
case 48: return 224; 
break;
case 49: return 82; 
break;
case 50: return 231; 
break;
case 51: return 100; 
break;
case 52: return 101; 
break;
case 53: return 227; 
break;
case 54: return 353; 
break;
case 55: return 382; 
break;
case 56: return 237; 
break;
case 57: return 222; 
break;
case 58: return 130; 
break;
case 59: return 383; 
break;
case 60: return 159; 
break;
case 61: return 134; 
break;
case 62: return 384; 
break;
case 63: return 226; 
break;
case 64: return 385; 
break;
case 65: return 386; 
break;
case 66: return 68; 
break;
case 67: return 387; 
break;
case 68: return 388; 
break;
case 69: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SELECT', yy_.yylloc); return 246; 
break;
case 70: return 225; 
break;
case 71: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SET', yy_.yylloc); return 16; 
break;
case 72: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SHOW', yy_.yylloc); return 38; 
break;
case 73: return 389; 
break;
case 74: return 390; 
break;
case 75: return 44; 
break;
case 76: return 391; 
break;
case 77: return 392; 
break;
case 78: return 393; 
break;
case 79: return 'TO'; 
break;
case 80: return 274; 
break;
case 81: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('TRUNCATE', yy_.yylloc, yy.lexer.upcomingInput()); return 276; 
break;
case 82: return 499; 
break;
case 83: return 267; 
break;
case 84: parser.determineCase(yy_.yytext); return 326; 
break;
case 85: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('USE', yy_.yylloc); return 342; 
break;
case 86: return 145; 
break;
case 87: return 396; 
break;
case 88: return 52; 
break;
case 89: return 397; 
break;
case 90: return 269; 
break;
case 91: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('WITH', yy_.yylloc); return 179; 
break;
case 92: return 323; 
break;
case 93: return 68; 
break;
case 94: yy.lexer.unput('('); yy_.yytext = 'avg'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 299; 
break;
case 95: yy.lexer.unput('('); yy_.yytext = 'cast'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 312; 
break;
case 96: yy.lexer.unput('('); yy_.yytext = 'count'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 307; 
break;
case 97: yy.lexer.unput('('); yy_.yytext = 'max'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 300; 
break;
case 98: yy.lexer.unput('('); yy_.yytext = 'min'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 301; 
break;
case 99: yy.lexer.unput('('); yy_.yytext = 'stddev_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 302; 
break;
case 100: yy.lexer.unput('('); yy_.yytext = 'stddev_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 303; 
break;
case 101: yy.lexer.unput('('); yy_.yytext = 'sum'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 308; 
break;
case 102: yy.lexer.unput('('); yy_.yytext = 'var_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 304; 
break;
case 103: yy.lexer.unput('('); yy_.yytext = 'var_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 305; 
break;
case 104: yy.lexer.unput('('); yy_.yytext = 'variance'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 306; 
break;
case 105: yy.lexer.unput('('); yy_.yytext = 'cume_dist'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 106: yy.lexer.unput('('); yy_.yytext = 'dense_rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 107: yy.lexer.unput('('); yy_.yytext = 'first_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 108: yy.lexer.unput('('); yy_.yytext = 'lag'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 109: yy.lexer.unput('('); yy_.yytext = 'last_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 110: yy.lexer.unput('('); yy_.yytext = 'lead'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 111: yy.lexer.unput('('); yy_.yytext = 'rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 112: yy.lexer.unput('('); yy_.yytext = 'row_number'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 309; 
break;
case 113: return 394; 
break;
case 114: return 394; 
break;
case 115: return 395; 
break;
case 116: return 354; 
break;
case 117: parser.yy.cursorFound = true; return 5; 
break;
case 118: parser.yy.cursorFound = true; return 398; 
break;
case 119: return 378; 
break;
case 120: parser.addFileLocation(yy_.yylloc, yy_.yytext); return 504; 
break;
case 121: this.popState(); return 505; 
break;
case 122: return 345; 
break;
case 123: return 361; 
break;
case 124: return 382; 
break;
case 125: return 34; 
break;
case 126: return 113; 
break;
case 127: return 114; 
break;
case 128: return 147; 
break;
case 129: return 147; 
break;
case 130: return 147; 
break;
case 131: return 147; 
break;
case 132: return 147; 
break;
case 133: return 357; 
break;
case 134: return 258; 
break;
case 135: return 362; 
break;
case 136: return 362; 
break;
case 137: return 362; 
break;
case 138: return 362; 
break;
case 139: return 362; 
break;
case 140: return 362; 
break;
case 141: return 90; 
break;
case 142: return 272; 
break;
case 143: return 125; 
break;
case 144: return 349; 
break;
case 145: return 360; 
break;
case 146: return 356; 
break;
case 147: return 84; 
break;
case 148: return 86; 
break;
case 149: return 358; 
break;
case 150: return 359; 
break;
case 151: return 233; 
break;
case 152: this.begin('backtickedValue'); return 363; 
break;
case 153:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '`')) {
                                               return 402;
                                             }
                                             return 61;
                                           
break;
case 154: this.popState(); return 363; 
break;
case 155: this.begin('singleQuotedValue'); return 59; 
break;
case 156:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '\'')) {
                                               return 402;
                                             }
                                             return 61;
                                           
break;
case 157: this.popState(); return 59; 
break;
case 158: this.begin('doubleQuotedValue'); return 60; 
break;
case 159:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '"')) {
                                               return 402;
                                             }
                                             return 61;
                                           
break;
case 160: this.popState(); return 60; 
break;
case 161: return 345; 
break;
case 162: /* To prevent console logging of unknown chars */ 
break;
case 163: 
break;
case 164: 
break;
case 165: 
break;
case 166: 
break;
case 167: 
break;
case 168:console.log(yy_.yytext);
break;
}
},
rules: [/^(?:\s)/i,/^(?:--.*)/i,/^(?:[/][*][^*]*[*]+([^/*][^*]*[*]+)*[/])/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:AND)/i,/^(?:ALL)/i,/^(?:ALTER)/i,/^(?:AND)/i,/^(?:AS)/i,/^(?:ASC)/i,/^(?:BETWEEN)/i,/^(?:BIGINT)/i,/^(?:BOOLEAN)/i,/^(?:BY)/i,/^(?:CASCADE)/i,/^(?:CASE)/i,/^(?:CHAR)/i,/^(?:COMMENT)/i,/^(?:CREATE)/i,/^(?:CROSS)/i,/^(?:CURRENT)/i,/^(?:DATABASE)/i,/^(?:DECIMAL)/i,/^(?:DESC)/i,/^(?:DESCRIBE)/i,/^(?:DISTINCT)/i,/^(?:DIV)/i,/^(?:DOUBLE)/i,/^(?:DROP)/i,/^(?:ELSE)/i,/^(?:END)/i,/^(?:EXISTS)/i,/^(?:FALSE)/i,/^(?:FLOAT)/i,/^(?:FOLLOWING)/i,/^(?:FROM)/i,/^(?:FULL)/i,/^(?:GROUP)/i,/^(?:HAVING)/i,/^(?:IF)/i,/^(?:IN)/i,/^(?:INNER)/i,/^(?:INSERT)/i,/^(?:INT)/i,/^(?:INTO)/i,/^(?:IS)/i,/^(?:JOIN)/i,/^(?:LEFT)/i,/^(?:LIKE)/i,/^(?:LIMIT)/i,/^(?:NOT)/i,/^(?:NULL)/i,/^(?:ON)/i,/^(?:OPTION)/i,/^(?:OR)/i,/^(?:ORDER)/i,/^(?:OUTER)/i,/^(?:PARTITION)/i,/^(?:PRECEDING)/i,/^(?:PURGE)/i,/^(?:RANGE)/i,/^(?:REGEXP)/i,/^(?:RIGHT)/i,/^(?:RLIKE)/i,/^(?:ROW)/i,/^(?:ROLE)/i,/^(?:ROWS)/i,/^(?:SCHEMA)/i,/^(?:SELECT)/i,/^(?:SEMI)/i,/^(?:SET)/i,/^(?:SHOW)/i,/^(?:SMALLINT)/i,/^(?:STRING)/i,/^(?:TABLE)/i,/^(?:THEN)/i,/^(?:TIMESTAMP)/i,/^(?:TINYINT)/i,/^(?:TO)/i,/^(?:TRUE)/i,/^(?:TRUNCATE)/i,/^(?:UNBOUNDED)/i,/^(?:UNION)/i,/^(?:UPDATE)/i,/^(?:USE)/i,/^(?:VALUES)/i,/^(?:VARCHAR)/i,/^(?:VIEW)/i,/^(?:WHEN)/i,/^(?:WHERE)/i,/^(?:WITH)/i,/^(?:OVER)/i,/^(?:ROLE)/i,/^(?:AVG\s*\()/i,/^(?:CAST\s*\()/i,/^(?:COUNT\s*\()/i,/^(?:MAX\s*\()/i,/^(?:MIN\s*\()/i,/^(?:STDDEV_POP\s*\()/i,/^(?:STDDEV_SAMP\s*\()/i,/^(?:SUM\s*\()/i,/^(?:VAR_POP\s*\()/i,/^(?:VAR_SAMP\s*\()/i,/^(?:VARIANCE\s*\()/i,/^(?:CUME_DIST\s*\()/i,/^(?:DENSE_RANK\s*\()/i,/^(?:FIRST_VALUE\s*\()/i,/^(?:LAG\s*\()/i,/^(?:LAST_VALUE\s*\()/i,/^(?:LEAD\s*\()/i,/^(?:RANK\s*\()/i,/^(?:ROW_NUMBER\s*\()/i,/^(?:[0-9]+)/i,/^(?:[0-9]+(?:[YSL]|BD)?)/i,/^(?:[0-9]+E)/i,/^(?:[A-Za-z0-9_]+)/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:\s+['"])/i,/^(?:[^'"\u2020\u2021]+)/i,/^(?:['"])/i,/^(?:$)/i,/^(?:&&)/i,/^(?:\|\|)/i,/^(?:=)/i,/^(?:<)/i,/^(?:>)/i,/^(?:!=)/i,/^(?:<=)/i,/^(?:>=)/i,/^(?:<>)/i,/^(?:<=>)/i,/^(?:-)/i,/^(?:\*)/i,/^(?:\+)/i,/^(?:\/)/i,/^(?:%)/i,/^(?:\|)/i,/^(?:\^)/i,/^(?:&)/i,/^(?:,)/i,/^(?:\.)/i,/^(?::)/i,/^(?:;)/i,/^(?:~)/i,/^(?:!)/i,/^(?:\()/i,/^(?:\))/i,/^(?:\[)/i,/^(?:\])/i,/^(?:\$\{[^}]*\})/i,/^(?:`)/i,/^(?:[^`]+)/i,/^(?:`)/i,/^(?:')/i,/^(?:(?:\\\\|\\[']|[^'])+)/i,/^(?:')/i,/^(?:")/i,/^(?:(?:\\\\|\\["]|[^"])+)/i,/^(?:")/i,/^(?:$)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i],
conditions: {"hdfs":{"rules":[117,118,119,120,121,122,164],"inclusive":false},"doubleQuotedValue":{"rules":[159,160,167],"inclusive":false},"singleQuotedValue":{"rules":[156,157,166],"inclusive":false},"backtickedValue":{"rules":[153,154,165],"inclusive":false},"between":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,155,158,161,162,163,168],"inclusive":true},"INITIAL":{"rules":[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,155,158,161,162,168],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
export default flinkSyntaxParser;
