/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.enterprise.ssl;

import com.cloudera.cmf.cdhclient.util.HttpConnectionConfigurator;
import com.cloudera.enterprise.ssl.AcceptAllCertificates;
import com.cloudera.enterprise.ssl.FileBasedKeyStoresFactory;
import com.cloudera.enterprise.ssl.SSLHostnameVerifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLFactory
implements HttpConnectionConfigurator {
    private static Logger LOG = LoggerFactory.getLogger(SSLFactory.class);
    public static final String SSL_REQUIRE_CLIENT_CERT_KEY = "com.cloudera.enterprise.ssl.require.client.cert";
    public static final String SSL_HOSTNAME_VERIFIER_KEY = "com.cloudera.enterprise.ssl.hostname.verifier";
    public static final String SSLCERTIFICATE = System.getProperty("java.vendor").contains("IBM") ? "ibmX509" : "SunX509";
    public static final boolean DEFAULT_SSL_REQUIRE_CLIENT_CERT = false;
    public static final String KEYSTORES_FACTORY_CLASS_KEY = "hadoop.ssl.keystores.factory.class";
    private MapConfiguration conf;
    private Mode mode;
    private boolean requireClientCert;
    private SSLContext context;
    private HostnameVerifier hostnameVerifier;
    private FileBasedKeyStoresFactory keystoresFactory;

    public SSLFactory(Mode mode, MapConfiguration conf) {
        this.conf = conf;
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.mode = mode;
        this.requireClientCert = conf.getBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, false);
        this.keystoresFactory = new FileBasedKeyStoresFactory();
        this.keystoresFactory.setConf(conf);
    }

    public void init() throws GeneralSecurityException, IOException {
        this.keystoresFactory.init(this.mode);
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.keystoresFactory.getKeyManagers(), this.keystoresFactory.getTrustManagers(), null);
        this.hostnameVerifier = this.getHostnameVerifier(this.conf);
    }

    private HostnameVerifier getHostnameVerifier(MapConfiguration conf) throws GeneralSecurityException, IOException {
        SSLHostnameVerifier hostnameVerifier;
        String verifier = conf.getString(SSL_HOSTNAME_VERIFIER_KEY, "DEFAULT").trim().toUpperCase();
        if (verifier.equals("DEFAULT")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT;
        } else if (verifier.equals("DEFAULT_AND_LOCALHOST")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT_AND_LOCALHOST;
        } else if (verifier.equals("STRICT")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT;
        } else if (verifier.equals("STRICT_IE6")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT_IE6;
        } else if (verifier.equals("ALLOW_ALL")) {
            hostnameVerifier = SSLHostnameVerifier.ALLOW_ALL;
        } else {
            throw new GeneralSecurityException("Invalid hostname verifier: " + verifier);
        }
        return hostnameVerifier;
    }

    public void destroy() {
        this.keystoresFactory.destroy();
    }

    public FileBasedKeyStoresFactory getKeystoresFactory() {
        return this.keystoresFactory;
    }

    public SSLEngine createSSLEngine() throws GeneralSecurityException, IOException {
        SSLEngine sslEngine = this.context.createSSLEngine();
        if (this.mode == Mode.CLIENT) {
            sslEngine.setUseClientMode(true);
        } else {
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.requireClientCert);
        }
        return sslEngine;
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.SERVER) {
            throw new IllegalStateException("Factory is in CLIENT mode");
        }
        return this.context.getServerSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is not in CLIENT mode");
        }
        return this.context.getSocketFactory();
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is not in CLIENT mode");
        }
        return this.hostnameVerifier;
    }

    public boolean isClientCertRequired() {
        return this.requireClientCert;
    }

    public void configure(HttpURLConnection conn) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            try {
                sslConn.setSSLSocketFactory(this.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            sslConn.setHostnameVerifier(this.getHostnameVerifier());
        }
    }

    public static HttpConnectionConfigurator getHttpConnectionConfigurator(Configuration config, MapConfiguration sslFactoryConfiguration) throws GeneralSecurityException, IOException {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)sslFactoryConfiguration);
        if (SSLFactory.skipCertificateVerification(config)) {
            LOG.warn("Attempting to suppress certificate verification, the default java truststore may still be in use for some HTTPS communication.");
            return new AcceptAllCertificates();
        }
        if (SSLFactory.isClientTruststoreConfigured(config)) {
            SSLFactory sslFactory = new SSLFactory(Mode.CLIENT, sslFactoryConfiguration);
            sslFactory.init();
            LOG.info("Using configured truststore for verification of server certificates in HTTPS communication.");
            return sslFactory;
        }
        LOG.info("Using default java truststore for verification of server certificates in HTTPS communication.");
        return null;
    }

    public static boolean isClientTruststoreConfigured(Configuration config) {
        return !StringUtils.isEmpty((String)config.getString("com.cloudera.enterprise.ssl.client.truststore.location", null));
    }

    public static boolean skipCertificateVerification(Configuration config) {
        return config.getBoolean("com.cloudera.enterprise.ssl.skip.certificate.verification", false);
    }

    public static MapConfiguration getSSLFactoryConfiguration(Configuration config) {
        Preconditions.checkNotNull((Object)config);
        HashMap configuration = Maps.newHashMap();
        Iterator iterator = config.getKeys("com.cloudera.enterprise.ssl.");
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            configuration.put(key, config.getProperty(key));
        }
        return new MapConfiguration((Map)configuration);
    }

    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

