/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.enterprise.authentication;

import com.cloudera.cmf.cdhclient.util.ThrottlingLogger;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthenticator
extends Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(HttpAuthenticator.class);
    private static final ThrottlingLogger THROTTLING_LOGGER = new ThrottlingLogger(LOG, Duration.standardMinutes((long)15L));
    private final Cache<URL, UrlCredentialProvider> credentialProviderCache;

    public HttpAuthenticator(Duration expireAfterAccessDuration, long maxCacheSize) {
        Preconditions.checkNotNull((Object)expireAfterAccessDuration);
        this.credentialProviderCache = CacheBuilder.newBuilder().expireAfterAccess(expireAfterAccessDuration.getMillis(), TimeUnit.MILLISECONDS).maximumSize(maxCacheSize).build();
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        UrlCredentialProvider provider;
        if (THROTTLING_LOGGER.isDebugEnabled()) {
            THROTTLING_LOGGER.debug(String.format("Got authentication request for URL: %s, host: %s, port %d, InetAddress %s, protocol: %s, scheme: %s", this.getRequestingURL().toString(), this.getRequestingHost(), this.getRequestingPort(), this.getRequestingSite() != null ? this.getRequestingSite().toString() : "none", this.getRequestingProtocol(), this.getRequestingScheme()));
        }
        if (null != (provider = (UrlCredentialProvider)this.credentialProviderCache.getIfPresent((Object)this.getRequestingURL()))) {
            return provider.getPasswordAuthentication();
        }
        return null;
    }

    public void registerUrlCredentialProvider(UrlCredentialProvider provider) {
        Preconditions.checkNotNull((Object)provider);
        if (THROTTLING_LOGGER.isDebugEnabled()) {
            THROTTLING_LOGGER.debug("Registering provider for URL: " + provider.getAuthenticatedUrl().toString());
        }
        this.credentialProviderCache.put((Object)provider.getAuthenticatedUrl(), (Object)provider);
    }

    public void unRegisterUrlCredentialProvider(URL url) {
        Preconditions.checkNotNull((Object)url);
        if (THROTTLING_LOGGER.isDebugEnabled()) {
            THROTTLING_LOGGER.debug("Unregistering provider for URL:" + url.toString());
        }
        this.credentialProviderCache.invalidate((Object)url);
    }

    public static interface UrlCredentialProvider {
        public URL getAuthenticatedUrl();

        public PasswordAuthentication getPasswordAuthentication();
    }
}

