---
title: Hue 4.10 and its new SQL Editor component, REST API, small File Importer and Slack App are out!
author: Hue Team
type: post
date: 2021-06-10T00:00:00+00:00
url: /blog/hue-4-10-sql-scratchpad-component-rest-api-small-file-importer-slack-app/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_related_articles:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
sf_remove_promo_bar:
  - 1
ampforwp-amp-on-off:
  - default
categories:
  - Version 4.10
  - Release

---
Hi Data Explorers,

The Hue Team is glad to thanks all the contributors and release Hue 4.10!

<a href="https://cdn.gethue.com/uploads/2021/02/hue-4.9.png">
  <img src="https://cdn.gethue.com/uploads/2021/02/hue-4.9.png" />
</a>

&nbsp;

Here is a summary of the [main improvements](/categories/version-4.10/) of 4.10 on top of the previous [4.9](/blog/hue-4-9-sql-dialects-phoenix-dasksql-flink-components/) release:


## SQL Editor Component & API
Now build your own SQL Editor in three HTML line by leveraging the [SQL Scratchpad](https://docs.gethue.com/developer/components/scratchpad/) component. The first version of the public [REST API](https://docs.gethue.com/developer/api/rest/) for executing queries was also published.

Read more about the [SQL Scratchpad and REST API](https://gethue.com/blog/2021-05-29-create-own-sql-editor-via-webcomponent-and-public-api/).

Here is a live demo of how easy it is to add the component:

{{< rawhtml >}}
<p>
  <div style="position: absolute; height: 10%; width: 100%">
    <sql-scratchpad api-url="https://demo.gethue.com" username="demo" password="demo" dialect="mysql" />
  </div>

  <script type="text/javascript" src="https://unpkg.com/gethue/lib/components/SqlScratchpadWebComponent.js"></script>

  <br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>
</p>
{{< /rawhtml >}}

![Adding the component in 3 lines and watching the interaction with the public API of demo.gethue.com](https://cdn-images-1.medium.com/max/2356/1*yXRjYQN_eRUimzlXPl5SwQ.gif)*Adding the component in 3 lines and watching the interaction with the public API of demo.gethue.com*

## Create Table Wizard

Create a Hive, Impala, MySql, Phoenix SQL table via a small file in three clicks. Just upload it via your browser, without the need to have any Storage filesystem like HDFS or S3 configured and follow the wizard.

Read more about the [create table from a small file](https://gethue.com/blog/2021-05-26-improved-hue-importer-select-a-file-choose-a-dialect-create-a-table/).

![Importer direct upload steps](https://cdn.gethue.com/uploads/2021/05/Importer_direct_upload_steps.gif)

## Slack App
Collaborate more via Slack thanks to the rich preview of SQL queries, auto links, query bank and export result to Slack.

[Install the app](/blog/2021-05-18-installing-hue-slack-app-in-three-simple-steps/) in a few clicks and learn more about the [functionalities of assistance](https://docs.gethue.com/user/concept/#slack).

![Slack Installation Flow](https://cdn.gethue.com/uploads/2021/05/slack-install.gif)

## Tech stack & Tooling

- [Provide your users proper S3 file access without giving them any credential keys](https://gethue.com/blog/2021-04-23-s3-file-access-without-any-credentials-and-signed-urls/)
- [Distribute your container App as a Package](https://gethue.com/blog/2021-04-19-publish-kubernetes-container-application-via-package-with-helm/)
- [Performing Web/API Service upgrades without Downtime](https://gethue.com/blog/2021-03-06-web-api-service-upgrade-no-downtime-kubernetes-rollout/)
- [Interactively Querying HBase via SQL - Tech Talk](https://gethue.com/blog/2021-04-05-interactively-querying-hbase-via-sql-tech-talk/)
- [Process & Learnings when upgrading the Webserver Stack - Django Upgrade (1.11 to 3.1)](https://gethue.com/blog/2021-03-09-process-and-learnings-when-upgrading-the-webserver-stack-django-upgrade-1-to-3/)
- [Introducing Vue 3 & Web Components in Hue Query Editor](https://gethue.com/blog/vue3-build-cli-options-composition-api-template-web-components-hue/)
- Docker Image size [reduced by 60%](https://github.com/cloudera/hue/pull/2129)
- [Phoenix SQL](/sql-querying-apache-hbase-with-apache-phoenix/) column keys are now displayed in the left assist


It has more than 700+ commits and 100+ bug fixes! For more details on all the changes, check out the [release notes](https://docs.gethue.com/releases/release-notes-4.10.0/).

Go grab it and give it a spin!

* Docker
    ```
    docker run -it -p 8888:8888 gethue/4.10.0
    ```
* Kubernetes :
    ```
    helm repo add gethue https://helm.gethue.com
    helm repo update
    helm install hue gethue/hue
    ```
* [demo.gethue.com](demo.gethue.com)
* [Tarball](https://cdn.gethue.com/downloads/hue-4.10.0.tgz) or [source](https://github.com/cloudera/hue/archive/release-4.10.0.zip)

</br>
</br>

Any feedback or question? Feel free to comment here or on the <a href="https://discourse.gethue.com/">Forum</a> and <a href="https://docs.gethue.com/quickstart/">quick start</a> SQL querying!


Onwards!

Romain from the Hue Team
