// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/* parser generated by jison 0.4.17 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
import SqlParseSupport from 'parse/sql/dasksql/sqlParseSupport';

var dasksqlSyntaxParser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[4,17,35,126,209,213,215],$V1=[2,364],$V2=[209,213],$V3=[2,365],$V4=[1,13],$V5=[1,17],$V6=[1,19],$V7=[1,18],$V8=[1,6],$V9=[20,209,213],$Va=[2,241],$Vb=[1,27],$Vc=[1,36],$Vd=[1,38],$Ve=[1,39],$Vf=[1,40],$Vg=[1,35],$Vh=[1,34],$Vi=[2,203],$Vj=[1,42],$Vk=[1,43],$Vl=[20,148,209,213],$Vm=[18,22,126],$Vn=[15,17,18,20,22,23,37,40,71,86,99,100,101,102,103,104,105,106,107,111,113,117,124,125,139,148,150,209,213,219,220,221,222,225,226,227,228,232,233,234,235,240,245,246,247,253,256,257,258,262,263,264,266,269,272,280,341],$Vo=[1,69],$Vp=[1,62],$Vq=[1,102],$Vr=[1,103],$Vs=[1,104],$Vt=[1,105],$Vu=[1,106],$Vv=[1,107],$Vw=[1,108],$Vx=[1,109],$Vy=[1,95],$Vz=[1,96],$VA=[1,89],$VB=[1,77],$VC=[1,78],$VD=[1,79],$VE=[1,80],$VF=[1,90],$VG=[1,75],$VH=[1,65],$VI=[1,67],$VJ=[1,111],$VK=[1,66],$VL=[1,70],$VM=[1,114],$VN=[1,68],$VO=[1,116],$VP=[1,64],$VQ=[1,113],$VR=[1,115],$VS=[1,110],$VT=[1,112],$VU=[18,20,113,126,139,174,175,176,177,178,179,180,181,182,183,184,186,187,188,189,190,196,219,220,221,222,224,225,226,231,234,238,245,248,249,257,269,275,276,277],$VV=[15,17,23],$VW=[20,22,37,148,209,213],$VX=[2,840],$VY=[1,151],$VZ=[1,136],$V_=[1,152],$V$=[1,146],$V01=[1,145],$V11=[1,137],$V21=[1,138],$V31=[1,144],$V41=[1,147],$V51=[1,142],$V61=[1,139],$V71=[1,141],$V81=[1,135],$V91=[1,140],$Va1=[1,143],$Vb1=[1,154],$Vc1=[1,153],$Vd1=[15,20,22,23,37,40,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,139,148,150,209,213,219,220,221,222,225,227,228,232,233,234,235,240,245,246,247,253,256,257,258,262,263,264,266,269,272,280,341],$Ve1=[1,162],$Vf1=[1,168],$Vg1=[1,170],$Vh1=[15,18,20,22,23,37,40,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,139,148,150,209,213,219,220,221,222,225,227,228,232,233,234,235,240,245,246,247,253,256,257,258,262,263,264,266,269,272,280,341],$Vi1=[1,175],$Vj1=[15,18,20,22,23,37,40,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,139,148,150,209,213,219,220,221,222,225,226,227,228,232,233,234,235,240,245,246,247,253,256,257,258,262,263,264,266,269,272,280,341],$Vk1=[15,20,22,23,37,40,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,139,148,150,204,209,213,219,220,221,222,225,227,228,232,233,234,235,240,245,246,247,253,256,257,258,262,263,264,266,269,272,280,341],$Vl1=[17,126],$Vm1=[2,818],$Vn1=[20,71,86,111,117,148,209,213],$Vo1=[133,196,249,275],$Vp1=[20,22,37,71,86,99,100,101,102,103,104,105,106,107,111,117,148,150,209,213],$Vq1=[15,20,22,37,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,148,150,209,213,219,220,221,222,232,234,235,245,246,247,257,258,262,266,269,272,280,341],$Vr1=[15,20,22,23,37,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,139,148,150,209,213,219,220,221,222,225,227,228,232,233,234,235,240,245,246,247,257,258,262,266,269,272,280,341],$Vs1=[246,247,280],$Vt1=[18,113,174,175,176,177,178,179,180,181,182,183,184,186,187,188,189,190,196,219,220,221,222,224,225,226,231,234,238,245,248,249,257,269,275,276,277],$Vu1=[15,20,22,23,37,40,71,86,99,100,101,102,103,104,105,106,107,111,113,117,124,125,139,148,150,209,213,219,220,221,222,225,227,228,232,233,234,235,240,245,246,247,253,256,257,258,262,263,264,266,269,272,280,341],$Vv1=[15,20,22,71,86,99,100,101,102,103,104,105,106,107,111,113,117,148,150,209,213,219,220,221,222,234,245,269],$Vw1=[20,86,111,117,148,209,213],$Vx1=[20,22,71,86,111,117,148,150,209,213],$Vy1=[1,290],$Vz1=[1,293],$VA1=[1,291],$VB1=[1,295],$VC1=[1,292],$VD1=[1,294],$VE1=[1,297],$VF1=[1,296],$VG1=[20,22,71,86,99,100,101,102,103,104,105,106,107,111,117,148,150,209,213],$VH1=[15,20,22,23,37,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,148,150,209,213,219,220,221,222,227,228,232,234,235,240,245,246,247,257,258,262,266,269,272,280,341],$VI1=[15,20,22,37,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,148,150,209,213,219,220,221,222,232,234,245,246,247,258,262,266,269,272,280,341],$VJ1=[1,315],$VK1=[20,22],$VL1=[20,117],$VM1=[20,111,117,148,209,213],$VN1=[18,113,219,220,221,222,234],$VO1=[1,358],$VP1=[20,22,117],$VQ1=[1,366],$VR1=[20,111,148,209,213],$VS1=[20,22,71,86,99,100,101,102,103,104,105,106,111,117,148,150,209,213],$VT1=[2,162],$VU1=[1,393],$VV1=[1,416],$VW1=[2,630],$VX1=[20,22,86,111,117,148,209,213],$VY1=[235,396],$VZ1=[20,232,241,276,396],$V_1=[2,876],$V$1=[20,22,111,148,209,213,262,266],$V02=[20,232],$V12=[2,886],$V22=[1,449],$V32=[1,450],$V42=[1,451],$V52=[2,891],$V62=[1,458],$V72=[251,260];
var parser = {trace: function trace () { },
yy: {},
symbols_: {"error":2,"DataDefinition_EDIT":3,"CREATE":4,"CURSOR":5,"TableDefinition_EDIT":6,"ViewDefinition_EDIT":7,"ShowStatement_EDIT":8,"DataDefinition":9,"TableDefinition":10,"ViewDefinition":11,"ShowStatement":12,"TABLE":13,"SchemaQualifiedIdentifier":14,"AS":15,"QuerySpecification":16,"WITH":17,"(":18,"TableWithDefinition":19,")":20,"TableWithDefinitionLine":21,",":22,"=":23,"GeneralLiteral":24,"EDIT":25,"QuerySpecification_EDIT":26,"TableWithDefinition_EDIT":27,"SchemaQualifiedIdentifier_EDIT":28,"TableWithDefinitionLine_EDIT":29,"GeneralLiteral_EDIT":30,"VIEW":31,"ShowColumnsStatement":32,"ShowSchemasStatement":33,"ShowTablesStatement":34,"SHOW":35,"COLUMNS":36,"FROM":37,"SchemaQualifiedTableIdentifier":38,"SCHEMAS":39,"LIKE":40,"SingleQuotedValue":41,"TABLES":42,"DatabaseIdentifier":43,"ShowColumnsStatement_EDIT":44,"ShowSchemasStatement_EDIT":45,"ShowTablesStatement_EDIT":46,"SchemaQualifiedTableIdentifier_EDIT":47,"CommonTableExpression":48,"SelectStatement":49,"OptionalUnions":50,"SelectStatement_EDIT":51,"OptionalUnions_EDIT":52,"CommonTableExpression_EDIT":53,"WithQueries":54,"WithQueries_EDIT":55,"WithQuery":56,"WithQuery_EDIT":57,"RegularOrBacktickedIdentifier":58,"TableSubQueryInner":59,"AnyCursor":60,"RightParenthesisOrError":61,"TableSubQueryInner_EDIT":62,"FromClause":63,"TableReferenceList":64,"FromClause_EDIT":65,"TableReferenceList_EDIT":66,"TableReference":67,"TableReference_EDIT":68,"OptionalGroupByClause":69,"GroupByClause":70,"GROUP":71,"BY":72,"GroupByColumnList":73,"GroupByClause_EDIT":74,"GroupByColumnList_EDIT":75,"ColumnGroupingSets":76,"ColumnReference":77,"ColumnGroupingSets_EDIT":78,"ColumnGroupingSet_EDIT":79,"ColumnReference_EDIT":80,"ValueExpression":81,"ValueExpression_EDIT":82,"GroupByColumnListPartTwo_EDIT":83,"OptionalHavingClause":84,"HavingClause":85,"HAVING":86,"HavingClause_EDIT":87,"OptionalJoins":88,"Joins":89,"Joins_INVALID":90,"JoinType":91,"TablePrimary":92,"OptionalJoinCondition":93,"Join_EDIT":94,"JoinType_EDIT":95,"TablePrimary_EDIT":96,"JoinCondition_EDIT":97,"Joins_EDIT":98,"CROSS":99,"JOIN":100,"FULL":101,"OUTER":102,"INNER":103,"LEFT":104,"SEMI":105,"RIGHT":106,"ON":107,"UsingColList":108,"OptionalLimitClause":109,"LimitClause":110,"LIMIT":111,"UnsignedNumericLiteral":112,"VARIABLE_REFERENCE":113,"LimitClause_EDIT":114,"OptionalOrderByClause":115,"OrderByClause":116,"ORDER":117,"OrderByColumnList":118,"OrderByClause_EDIT":119,"OrderByColumnList_EDIT":120,"OrderByIdentifier":121,"OrderByIdentifier_EDIT":122,"OptionalAscOrDesc":123,"ASC":124,"DESC":125,"SELECT":126,"OptionalAllOrDistinct":127,"SelectList":128,"TableExpression":129,"SelectList_EDIT":130,"TableExpression_EDIT":131,"ALL":132,"DISTINCT":133,"OptionalSelectConditions":134,"OptionalSelectConditions_EDIT":135,"SelectSpecification":136,"SelectSpecification_EDIT":137,"OptionalCorrelationName":138,"*":139,"OptionalCorrelationName_EDIT":140,"OptionalWhereClause":141,"WhereClause_EDIT":142,"WhereClause":143,"Unions":144,"Unions_EDIT":145,"UnionClause":146,"UnionClause_EDIT":147,"UNION":148,"NewStatement":149,"WHERE":150,"SearchCondition":151,"SearchCondition_EDIT":152,"UserDefinedFunction":153,"AggregateFunction":154,"OptionalOverClause":155,"AnalyticFunction":156,"OverClause":157,"CastFunction":158,"UserDefinedFunction_EDIT":159,"AggregateFunction_EDIT":160,"OptionalOverClause_EDIT":161,"AnalyticFunction_EDIT":162,"OverClause_EDIT":163,"CastFunction_EDIT":164,"OtherAggregateFunction":165,"CountFunction":166,"SumFunction":167,"OtherAggregateFunction_EDIT":168,"CountFunction_EDIT":169,"SumFunction_EDIT":170,"OtherAggregateFunction_Type":171,"UdfArgumentList":172,"UdfArgumentList_EDIT":173,"AVG":174,"MAX":175,"MIN":176,"STDDEV_POP":177,"STDDEV_SAMP":178,"VAR_POP":179,"VAR_SAMP":180,"VARIANCE":181,"COUNT":182,"SUM":183,"ANALYTIC":184,"ArbitraryFunctionName":185,"ARRAY":186,"IF":187,"MAP":188,"TRUNCATE":189,"CAST":190,"PrimitiveType":191,"NonParenthesizedValueExpressionPrimary":192,"ColumnOrArbitraryFunctionRef":193,"ArbitraryFunctionRightPart":194,"UnsignedValueSpecification":195,"NULL":196,"NonParenthesizedValueExpressionPrimary_EDIT":197,"ArbitraryFunctionRightPart_EDIT":198,"UnsignedValueSpecification_EDIT":199,"ColumnOrArbitraryFunctionRef_EDIT":200,"ArbitraryFunction":201,"RegularIdentifier":202,"ArbitraryFunction_EDIT":203,"OVER":204,"WindowExpression":205,"WindowExpression_EDIT":206,"SqlSyntax":207,"SqlStatements":208,"EOF":209,"SqlAutocomplete":210,"SqlStatements_EDIT":211,"SqlStatement":212,";":213,"SqlStatement_EDIT":214,"DataManipulation":215,"DataManipulation_EDIT":216,"SetSpecification_EDIT":217,"NonReservedKeyword":218,"ROLE":219,"OPTION":220,"STRUCT":221,"REGULAR_IDENTIFIER":222,"NonStartingToken":223,"!":224,"-":225,".":226,"<":227,">":228,"[":229,"]":230,"~":231,"AND":232,"ARITHMETIC_OPERATOR":233,"BACKTICK":234,"BETWEEN":235,"BIGINT":236,"BOOLEAN":237,"CASE":238,"CHAR":239,"COMPARISON_OPERATOR":240,"CURRENT":241,"DATABASE":242,"DECIMAL":243,"DOUBLE":244,"DOUBLE_QUOTE":245,"ELSE":246,"END":247,"EXISTS":248,"FALSE":249,"FLOAT":250,"FOLLOWING":251,"HDFS_START_QUOTE":252,"IN":253,"INT":254,"INTO":255,"IS":256,"NOT":257,"OR":258,"PARTITION":259,"PRECEDING":260,"PURGE":261,"RANGE":262,"REGEXP":263,"RLIKE":264,"ROW":265,"ROWS":266,"SCHEMA":267,"SET":268,"SINGLE_QUOTE":269,"SMALLINT":270,"STRING":271,"THEN":272,"TIMESTAMP":273,"TINYINT":274,"TRUE":275,"UNSIGNED_INTEGER":276,"UNSIGNED_INTEGER_E":277,"VALUES":278,"VARCHAR":279,"WHEN":280,"Commas":281,"PARTIAL_CURSOR":282,"FromOrIn":283,"DatabaseOrSchema":284,"VALUE":285,"SingleQuotedValue_EDIT":286,"PARTIAL_VALUE":287,"DoubleQuotedValue":288,"DoubleQuotedValue_EDIT":289,"QuotedValue":290,"QuotedValue_EDIT":291,"OptionalFromDatabase":292,"OptionalFromDatabase_EDIT":293,"DatabaseIdentifier_EDIT":294,"OptionalCascade":295,"CASCADE":296,"OptionalIfExists":297,"OptionalIfExists_EDIT":298,"OptionalIfNotExists":299,"OptionalIfNotExists_EDIT":300,"OptionalInDatabase":301,"OptionalPartitionSpec":302,"PartitionSpec":303,"OptionalPartitionSpec_EDIT":304,"PartitionSpec_EDIT":305,"PartitionSpecList":306,"PartitionSpecList_EDIT":307,"RangePartitionSpec":308,"RangePartitionComparisonOperator":309,"RangePartitionSpec_EDIT":310,"ConfigurationName":311,"PartialBacktickedOrAnyCursor":312,"PartialBacktickedIdentifier":313,"PartialBacktickedOrCursor":314,"PartialBacktickedOrPartialCursor":315,"OptionalParenthesizedColumnList":316,"ParenthesizedColumnList":317,"OptionalParenthesizedColumnList_EDIT":318,"ParenthesizedColumnList_EDIT":319,"ColumnList":320,"ColumnList_EDIT":321,"ColumnIdentifier":322,"ParenthesizedSimpleValueList":323,"SimpleValueList":324,"PartitionExpression":325,"PartitionExpression_EDIT":326,"RegularOrBackTickedSchemaQualifiedName":327,"RegularOrBackTickedSchemaQualifiedName_EDIT":328,"LocalOrSchemaQualifiedName":329,"LocalOrSchemaQualifiedName_EDIT":330,"BasicIdentifierChain":331,"BasicIdentifierChain_EDIT":332,"DerivedColumnChain":333,"DerivedColumnChain_EDIT":334,"PartialBacktickedIdentifierOrPartialCursor":335,"OptionalTypeLength":336,"OptionalTypePrecision":337,"OptionalNot":338,"TableSubQuery":339,"ValueExpressionList":340,"BETWEEN_AND":341,"LikeRightPart":342,"CaseRightPart":343,"TableSubQuery_EDIT":344,"ValueExpressionInSecondPart_EDIT":345,"LikeRightPart_EDIT":346,"CaseRightPart_EDIT":347,"EndOrError":348,"ValueExpressionList_EDIT":349,"InValueList":350,"SignedInteger":351,"+":352,"UnsignedLiteral":353,"UnsignedLiteral_EDIT":354,"ExactNumericLiteral":355,"ApproximateNumericLiteral":356,"TruthValue":357,"TablePrimaryOrJoinedTable":358,"TablePrimaryOrJoinedTable_EDIT":359,"JoinedTable":360,"JoinedTable_EDIT":361,"TableOrQueryName":362,"DerivedTable":363,"TableOrQueryName_EDIT":364,"DerivedTable_EDIT":365,"OptionalOnColumn":366,"OptionalOnColumn_EDIT":367,"PushQueryState":368,"PopQueryState":369,"SubQuery":370,"SubQuery_EDIT":371,"QueryExpression":372,"QueryExpression_EDIT":373,"QueryExpressionBody":374,"QueryExpressionBody_EDIT":375,"NonJoinQueryExpression":376,"NonJoinQueryExpression_EDIT":377,"NonJoinQueryTerm":378,"NonJoinQueryTerm_EDIT":379,"NonJoinQueryPrimary":380,"NonJoinQueryPrimary_EDIT":381,"SimpleTable":382,"SimpleTable_EDIT":383,"OptionalPartitionBy":384,"OptionalOrderByAndWindow":385,"PartitionBy_EDIT":386,"OptionalOrderByAndWindow_EDIT":387,"PartitionBy":388,"OptionalWindowSpec":389,"WindowSpec_EDIT":390,"WindowSpec":391,"RowsOrRange":392,"PopLexerState":393,"OptionalCurrentOrPreceding":394,"OptionalAndFollowing":395,"UNBOUNDED":396,"OptionalCurrentOrPreceding_EDIT":397,"OptionalAndFollowing_EDIT":398,"PushHdfsLexerState":399,"HdfsPath":400,"HDFS_PATH":401,"HDFS_END_QUOTE":402,"HdfsPath_EDIT":403,"IntegerOrUnbounded":404,"CaseWhenThenList":405,"CaseWhenThenList_EDIT":406,"CaseWhenThenListPartTwo":407,"CaseWhenThenListPartTwo_EDIT":408,"$accept":0,"$end":1},
terminals_: {2:"error",4:"CREATE",5:"CURSOR",13:"TABLE",15:"AS",17:"WITH",18:"(",20:")",22:",",23:"=",25:"EDIT",31:"VIEW",35:"SHOW",36:"COLUMNS",37:"FROM",39:"SCHEMAS",40:"LIKE",42:"TABLES",71:"GROUP",72:"BY",86:"HAVING",99:"CROSS",100:"JOIN",101:"FULL",102:"OUTER",103:"INNER",104:"LEFT",105:"SEMI",106:"RIGHT",107:"ON",111:"LIMIT",113:"VARIABLE_REFERENCE",117:"ORDER",124:"ASC",125:"DESC",126:"SELECT",132:"ALL",133:"DISTINCT",139:"*",148:"UNION",150:"WHERE",174:"AVG",175:"MAX",176:"MIN",177:"STDDEV_POP",178:"STDDEV_SAMP",179:"VAR_POP",180:"VAR_SAMP",181:"VARIANCE",182:"COUNT",183:"SUM",184:"ANALYTIC",186:"ARRAY",187:"IF",188:"MAP",189:"TRUNCATE",190:"CAST",196:"NULL",204:"OVER",209:"EOF",213:";",215:"DataManipulation",216:"DataManipulation_EDIT",217:"SetSpecification_EDIT",219:"ROLE",220:"OPTION",221:"STRUCT",222:"REGULAR_IDENTIFIER",224:"!",225:"-",226:".",227:"<",228:">",229:"[",230:"]",231:"~",232:"AND",233:"ARITHMETIC_OPERATOR",234:"BACKTICK",235:"BETWEEN",236:"BIGINT",237:"BOOLEAN",238:"CASE",239:"CHAR",240:"COMPARISON_OPERATOR",241:"CURRENT",242:"DATABASE",243:"DECIMAL",244:"DOUBLE",245:"DOUBLE_QUOTE",246:"ELSE",247:"END",248:"EXISTS",249:"FALSE",250:"FLOAT",251:"FOLLOWING",252:"HDFS_START_QUOTE",253:"IN",254:"INT",255:"INTO",256:"IS",257:"NOT",258:"OR",259:"PARTITION",260:"PRECEDING",261:"PURGE",262:"RANGE",263:"REGEXP",264:"RLIKE",265:"ROW",266:"ROWS",267:"SCHEMA",268:"SET",269:"SINGLE_QUOTE",270:"SMALLINT",271:"STRING",272:"THEN",273:"TIMESTAMP",274:"TINYINT",275:"TRUE",276:"UNSIGNED_INTEGER",277:"UNSIGNED_INTEGER_E",278:"VALUES",279:"VARCHAR",280:"WHEN",282:"PARTIAL_CURSOR",285:"VALUE",287:"PARTIAL_VALUE",296:"CASCADE",341:"BETWEEN_AND",352:"+",396:"UNBOUNDED",401:"HDFS_PATH",402:"HDFS_END_QUOTE"},
productions_: [0,[3,2],[3,1],[3,1],[3,1],[9,1],[9,1],[9,1],[10,5],[10,7],[19,1],[19,3],[21,3],[6,3],[6,4],[6,5],[6,5],[6,7],[6,5],[6,7],[6,7],[27,1],[27,2],[27,3],[29,2],[29,3],[29,3],[11,5],[7,3],[7,4],[7,5],[7,5],[7,5],[12,1],[12,1],[12,1],[32,4],[33,2],[33,4],[34,4],[8,2],[8,1],[8,1],[8,1],[45,3],[44,3],[44,4],[44,4],[46,3],[46,4],[16,3],[16,5],[16,2],[26,4],[26,3],[26,3],[26,1],[26,4],[26,3],[26,2],[26,2],[48,2],[53,2],[54,1],[54,3],[55,1],[55,3],[55,3],[55,5],[56,5],[57,2],[57,5],[57,5],[63,2],[65,2],[65,2],[64,1],[64,3],[66,1],[66,3],[66,3],[66,5],[66,3],[69,0],[69,1],[70,3],[74,3],[74,3],[74,2],[76,0],[76,1],[76,3],[76,3],[78,1],[78,3],[78,3],[78,5],[78,3],[79,1],[79,1],[73,1],[73,3],[75,1],[75,2],[75,3],[75,3],[75,3],[75,4],[75,5],[83,1],[83,2],[83,1],[84,0],[84,1],[85,2],[87,2],[87,2],[88,0],[88,1],[88,1],[89,3],[89,4],[90,1],[90,2],[94,3],[94,1],[94,3],[94,3],[94,3],[98,1],[98,2],[98,2],[98,3],[91,2],[91,2],[91,3],[91,2],[91,1],[91,3],[91,2],[91,3],[91,3],[91,2],[91,3],[91,2],[91,3],[91,3],[91,2],[95,2],[95,3],[95,3],[95,2],[95,3],[95,3],[95,3],[95,3],[95,2],[95,3],[95,3],[95,3],[95,3],[95,2],[93,0],[93,2],[108,1],[108,3],[97,2],[97,2],[109,0],[109,1],[110,2],[110,4],[110,2],[110,4],[114,2],[115,0],[115,1],[116,3],[119,3],[119,2],[118,1],[118,3],[120,1],[120,2],[120,3],[120,4],[120,5],[121,2],[122,2],[122,2],[123,0],[123,1],[123,1],[49,3],[49,4],[51,3],[51,3],[51,4],[51,4],[51,4],[51,5],[51,6],[51,4],[127,0],[127,1],[127,1],[129,2],[131,2],[131,4],[131,3],[128,1],[128,3],[130,1],[130,2],[130,3],[130,3],[130,3],[130,4],[130,3],[130,3],[130,4],[130,4],[130,4],[130,5],[130,5],[136,2],[136,1],[137,2],[137,3],[137,2],[134,5],[135,5],[135,5],[135,5],[135,5],[135,5],[135,6],[135,6],[135,6],[135,6],[135,6],[50,0],[50,1],[52,1],[144,1],[144,2],[145,1],[145,2],[145,2],[145,3],[146,4],[147,3],[147,4],[147,4],[141,0],[141,1],[143,2],[142,2],[142,2],[151,1],[152,1],[153,2],[153,2],[153,1],[159,1],[159,2],[159,1],[159,2],[159,2],[159,2],[159,1],[154,1],[154,1],[154,1],[160,1],[160,1],[160,1],[165,4],[165,5],[168,5],[168,6],[168,5],[171,1],[171,1],[171,1],[171,1],[171,1],[171,1],[171,1],[171,1],[166,4],[166,3],[166,5],[169,5],[169,6],[169,5],[167,5],[167,3],[170,5],[170,6],[170,5],[156,3],[156,4],[162,4],[162,5],[162,4],[185,1],[185,1],[185,1],[185,1],[158,6],[158,3],[164,6],[164,5],[164,4],[164,6],[164,5],[164,4],[164,6],[164,5],[164,6],[164,5],[192,2],[192,2],[192,1],[192,1],[192,1],[192,1],[197,2],[197,2],[197,1],[197,1],[197,1],[201,2],[201,2],[203,2],[203,2],[194,2],[194,3],[198,3],[198,4],[198,3],[172,1],[172,3],[173,1],[173,3],[173,3],[173,5],[173,3],[173,5],[173,4],[173,3],[173,2],[173,2],[173,4],[155,0],[155,1],[161,1],[157,2],[157,2],[163,2],[207,3],[210,3],[210,3],[149,0],[208,0],[208,1],[208,4],[211,1],[211,4],[211,4],[211,7],[212,1],[212,1],[212,1],[214,1],[214,2],[214,1],[214,1],[214,1],[214,1],[218,1],[218,1],[218,1],[202,1],[202,1],[202,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[223,1],[281,1],[281,2],[60,1],[60,1],[283,1],[283,1],[284,1],[284,1],[41,3],[41,2],[286,2],[288,3],[288,2],[289,2],[290,1],[290,1],[291,1],[291,1],[292,0],[292,2],[293,2],[295,0],[295,1],[297,0],[297,2],[298,2],[299,0],[299,3],[300,2],[300,3],[301,0],[301,2],[301,2],[302,0],[302,1],[304,1],[303,4],[305,4],[308,5],[310,2],[310,3],[310,4],[310,5],[310,5],[310,5],[309,1],[309,1],[309,1],[309,1],[311,1],[311,1],[312,1],[312,1],[314,1],[314,1],[315,1],[315,1],[313,2],[61,1],[61,1],[316,0],[316,1],[318,1],[317,3],[319,3],[319,3],[320,1],[320,3],[321,3],[321,5],[323,3],[324,1],[324,3],[38,1],[38,3],[47,1],[47,3],[47,3],[14,1],[14,3],[28,1],[28,3],[28,3],[43,1],[294,1],[306,1],[306,3],[307,1],[307,3],[307,3],[307,5],[325,3],[326,3],[326,3],[326,3],[326,1],[58,1],[58,3],[58,2],[327,1],[327,3],[328,1],[328,3],[329,1],[329,2],[330,1],[330,2],[77,1],[77,3],[80,1],[331,1],[331,3],[332,3],[332,5],[333,1],[333,3],[334,1],[334,3],[334,5],[334,3],[322,1],[335,1],[335,1],[191,1],[191,1],[191,2],[191,2],[191,1],[191,1],[191,1],[191,1],[191,1],[191,1],[191,1],[191,2],[336,0],[336,3],[337,0],[337,3],[337,5],[81,1],[81,2],[81,2],[81,2],[81,2],[81,4],[81,4],[81,4],[81,6],[81,2],[81,3],[81,3],[81,3],[81,3],[81,3],[81,6],[81,6],[81,5],[81,5],[81,6],[81,5],[81,3],[81,3],[81,3],[81,3],[81,3],[81,2],[81,3],[81,2],[81,3],[82,1],[82,3],[82,2],[82,2],[82,2],[82,2],[82,2],[82,2],[82,2],[82,2],[82,3],[82,4],[82,5],[82,4],[82,4],[82,4],[82,6],[82,6],[82,2],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,4],[82,3],[82,6],[82,6],[82,5],[82,5],[82,6],[82,6],[82,6],[82,6],[82,5],[82,4],[82,5],[82,5],[82,5],[82,5],[82,4],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,3],[82,2],[82,3],[82,2],[82,3],[82,2],[82,3],[82,2],[82,3],[82,3],[82,4],[82,3],[82,3],[82,3],[340,1],[340,3],[349,1],[349,3],[349,3],[349,5],[349,3],[349,5],[349,4],[349,3],[349,2],[349,2],[349,4],[350,1],[350,3],[193,1],[193,3],[200,1],[351,1],[351,2],[351,2],[195,1],[199,1],[353,1],[353,1],[354,1],[112,1],[112,1],[355,1],[355,2],[355,3],[355,2],[356,2],[356,3],[356,4],[24,1],[24,1],[24,1],[30,1],[30,1],[357,1],[357,1],[338,0],[338,1],[67,1],[68,1],[358,1],[358,1],[359,1],[359,1],[360,2],[361,2],[361,2],[92,2],[92,2],[96,2],[96,2],[96,2],[362,1],[364,1],[363,1],[365,1],[366,0],[366,2],[367,2],[367,2],[368,0],[369,0],[339,3],[339,4],[344,3],[344,3],[59,2],[62,3],[370,1],[371,1],[372,1],[373,1],[374,1],[375,1],[376,1],[377,1],[378,1],[379,1],[380,1],[381,1],[382,1],[383,1],[138,0],[138,1],[138,1],[138,2],[138,2],[140,1],[140,1],[140,2],[140,2],[140,2],[205,4],[206,4],[206,4],[206,5],[206,7],[384,0],[384,1],[388,3],[386,2],[386,3],[386,3],[385,0],[385,2],[387,1],[387,3],[387,2],[389,0],[389,1],[391,5],[391,5],[390,2],[390,6],[390,5],[390,5],[390,5],[390,4],[393,0],[399,0],[400,3],[403,5],[403,4],[403,3],[403,3],[403,2],[392,1],[392,1],[394,0],[394,2],[394,2],[397,2],[397,2],[395,0],[395,3],[395,3],[398,2],[398,3],[398,3],[404,1],[404,1],[345,3],[345,3],[345,3],[342,2],[342,2],[342,2],[346,2],[346,2],[346,2],[346,2],[346,2],[346,2],[343,2],[343,4],[347,2],[347,4],[347,4],[347,3],[347,4],[347,3],[347,4],[347,4],[347,3],[347,4],[347,3],[348,1],[348,1],[405,1],[405,2],[406,1],[406,2],[406,3],[406,3],[406,2],[407,4],[408,2],[408,3],[408,4],[408,4],[408,3],[408,3],[408,4],[408,2],[408,3],[408,2],[408,3],[408,3],[408,4],[408,3],[408,4],[408,4],[408,5],[408,4],[408,3]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:

     parser.suggestKeywords(['TABLE', 'VIEW']);
   
break;
case 14:

     parser.suggestKeywords(['AS', "WITH ("]);
   
break;
case 15: case 30: case 71: case 376: case 823:

     parser.suggestKeywords(['SELECT']);
   
break;
case 19:

     parser.suggestKeywords([')']);
   
break;
case 22:

     parser.suggestKeywords([',', ')']);
   
break;
case 24:

     parser.suggestKeywords(['=']);
   
break;
case 29: case 70:

     parser.suggestKeywords(['AS']);
   
break;
case 40:

     parser.suggestKeywords(['SCHEMAS', 'TABLES', 'COLUMNS']);
   
break;
case 44:

     parser.suggestKeywords(['LIKE']);
   
break;
case 45: case 48:

     parser.suggestKeywords(['FROM']);
   
break;
case 46: case 570:

     parser.suggestTables();
     parser.suggestDatabases({ appendDot: true });
   
break;
case 49:

     parser.suggestDatabases({ appendDot: false });
   
break;
case 51: case 224:
this.$ = $$[$0-2];
break;
case 52: case 222: case 338: case 341: case 503: case 506: case 592: case 645: case 820:
this.$ = $$[$0-1];
break;
case 53:

     parser.addCommonTableExpressions($$[$0-3]);
   
break;
case 54: case 55: case 66:

     parser.addCommonTableExpressions($$[$0-2]);
   
break;
case 61: case 77: case 101: case 177: case 181: case 219: case 229: case 256: case 745: case 747: case 802: case 857: case 932:
this.$ = $$[$0];
break;
case 63:
this.$ = [$$[$0]];
break;
case 64:
this.$ = $$[$0-2].concat([$$[$0]]);
break;
case 68:

     parser.addCommonTableExpressions($$[$0-4]);
   
break;
case 69:

     parser.addCteAliasLocation(_$[$0-4], $$[$0-4]);
     $$[$0-1].alias = $$[$0-4];
     this.$ = $$[$0-1];
   
break;
case 73:

     this.$ = { tableReferenceList : $$[$0] }
   
break;
case 74: case 82:

       parser.suggestTables();
       parser.suggestDatabases({ appendDot: true });
   
break;
case 85:

     this.$ = { valueExpression: $$[$0] };
   
break;
case 86: case 188:

     parser.suggestSelectListAliases();
   
break;
case 87:

     parser.valueExpressionSuggest();
     parser.suggestSelectListAliases();
     parser.suggestGroupBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 88:

     parser.suggestKeywords(['BY']);
     parser.suggestGroupBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 98: case 560: case 563: case 564: case 589: case 590: case 611: case 614:

     parser.suggestColumns();
   
break;
case 103: case 104: case 110: case 111: case 588: case 816: case 859:

     parser.valueExpressionSuggest();
   
break;
case 115:

     parser.valueExpressionSuggest();
     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 116:

     parser.suggestAggregateFunctions();
     parser.suggestSelectListAliases(true);
   
break;
case 120:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-2];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
        parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 121:

     if ($$[$0] && $$[$0].valueExpression) {
       this.$ = $$[$0].valueExpression;
     } else {
       this.$ = {};
     }
     this.$.joinType = $$[$0-3];
     if ($$[$0].noJoinCondition) {
       this.$.suggestJoinConditions = { prependOn: true, tablePrimaries: parser.yy.latestTablePrimaries.concat() }
     }
     if ($$[$0].suggestKeywords) {
       this.$.suggestKeywords = $$[$0].suggestKeywords;
     }
     if (parser.yy.latestTablePrimaries.length > 0) {
       parser.yy.latestTablePrimaries[parser.yy.latestTablePrimaries.length - 1].join = true;
     }
   
break;
case 122:
this.$ = { joinType: $$[$0] };
break;
case 123:
this.$ = { joinType: $$[$0-1] };
break;
case 124:

     if ($$[$0-2].suggestKeywords) {
       parser.suggestKeywords($$[$0-2].suggestKeywords);
     }
   
break;
case 125:

     if ($$[$0].suggestKeywords) {
       parser.suggestKeywords($$[$0].suggestKeywords);
     }
   
break;
case 128:

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         parser.suggestJoins({
           prependJoin: false,
           joinType: $$[$0-2],
           tables: tables
         })
       }
     }
     parser.suggestTables();
     parser.suggestDatabases({
       appendDot: true
     });
   
break;
case 133:
this.$ = 'CROSS JOIN';
break;
case 134:
this.$ = 'FULL JOIN';
break;
case 135:
this.$ = 'FULL OUTER JOIN';
break;
case 136:
this.$ = 'INNER JOIN';
break;
case 137:
this.$ = 'JOIN';
break;
case 138:
this.$ = 'LEFT INNER JOIN';
break;
case 139:
this.$ = 'LEFT JOIN';
break;
case 140:
this.$ = 'LEFT OUTER JOIN';
break;
case 141:
this.$ = 'LEFT SEMI JOIN';
break;
case 142:
this.$ = 'OUTER JOIN';
break;
case 143: case 145:
this.$ = 'RIGHT OUTER JOIN';
break;
case 144:
this.$ = 'RIGHT JOIN';
break;
case 146:
this.$ = 'RIGHT SEMI JOIN';
break;
case 147:
this.$ = 'SEMI JOIN';
break;
case 148: case 150: case 151: case 153: case 154: case 155: case 156: case 158: case 159: case 160: case 161:
this.$ = { suggestKeywords: ['JOIN'] };
break;
case 149: case 152: case 157:
this.$ = { suggestKeywords: ['OUTER'] };
break;
case 162:
this.$ = { noJoinCondition: true, suggestKeywords: ['ON'] };
break;
case 163:
this.$ = { valueExpression: $$[$0] };
break;
case 167:

     parser.valueExpressionSuggest();
     parser.suggestJoinConditions({ prependOn: false });
   
break;
case 174:

     parser.suggestKeywords([{ value: '10', weight: 10000 }, { value: '100', weight: 10000 }, { value: '1000', weight: 10000 }, { value: '5000', weight: 10000 }, { value: '10000', weight: 10000 }])
   
break;
case 178:

     if ($$[$0].emptyOrderBy) {
       parser.suggestOrderBys({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 179:

     parser.suggestKeywords(['BY']);
     parser.suggestOrderBys({ prefix: 'BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 183:

     this.$ = { emptyOrderBy: false }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 184: case 185: case 186:
this.$ = { emptyOrderBy: false };
break;
case 187:
this.$ = parser.mergeSuggestKeywords($$[$0]);
break;
case 189:

     this.$ = { emptyOrderBy: true }
     parser.valueExpressionSuggest();
     parser.suggestAnalyticFunctions();
     parser.suggestSelectListAliases();
   
break;
case 190:
this.$ = { suggestKeywords: ['ASC', 'DESC'] };;
break;
case 193:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     this.$ = { selectList: $$[$0] };
   
break;
case 194:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     this.$ = { selectList: $$[$0-1], tableExpression: $$[$0] }
   
break;
case 195:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0]);
     if ($$[$0].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-1]) {
         keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
       }
       parser.suggestKeywords(keywords);
     } else {
       parser.checkForSelectListKeywords($$[$0]);
     }
     if ($$[$0].suggestFunctions) {
       parser.suggestFunctions();
     }
     if ($$[$0].suggestColumns) {
       parser.suggestColumns({ identifierChain: [], source: 'select' });
     }
     if ($$[$0].suggestTables) {
       parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     }
     if ($$[$0].suggestDatabases) {
       parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
     }
     if ($$[$0].suggestAggregateFunctions && (!$$[$0-1] || $$[$0-1] === 'ALL')) {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
   
break;
case 196:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2]), _$[$0], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-1] || $$[$0-1] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-1]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 197:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
   
break;
case 198:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.selectListNoTableSuggest($$[$0-1], $$[$0-2]);
     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'select';
     }
   
break;
case 199:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1], true);
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2] || $$[$0-2] === 'ALL') {
       parser.suggestAggregateFunctions();
       parser.suggestAnalyticFunctions();
     }
     if (!$$[$0-2]) {
       keywords = keywords.concat(parser.SELECT_FIRST_OPTIONAL_KEYWORDS);
     }
     parser.suggestKeywords(keywords);
     parser.suggestFunctions();
     parser.suggestColumns({ identifierChain: [], source: 'select' });
     parser.suggestTables({ prependQuestionMark: true, prependFrom: true });
     parser.suggestDatabases({ prependQuestionMark: true, prependFrom: true, appendDot: true });
   
break;
case 200:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]), _$[$0-2]);
     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 201:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]), _$[$0-3]);
     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 202:

     parser.addClauseLocation('selectList', parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3]), _$[$0-1]);
     parser.checkForSelectListKeywords($$[$0-1]);
     var keywords = ['FROM'];
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.suggestTables({ prependFrom: true });
     parser.suggestDatabases({ prependFrom: true, appendDot: true });
   
break;
case 206: case 207:

     parser.addClauseLocation('whereClause', _$[$0-1], $$[$0].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0].limitClausePreceding || _$[$0-1], $$[$0].limitClauseLocation);
   
break;
case 208:

     var keywords = [];

     parser.addClauseLocation('whereClause', _$[$0-3], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-2].limitClausePreceding || _$[$0-3], $$[$0-2].limitClauseLocation);

     if ($$[$0-3]) {
       if (typeof $$[$0-3].tableReferenceList.hasJoinCondition !== 'undefined' && !$$[$0-3].tableReferenceList.hasJoinCondition) {
         keywords.push({ value: 'ON', weight: 3 });
       }
       if ($$[$0-3].suggestKeywords) {
         keywords = parser.createWeightedKeywords($$[$0-3].suggestKeywords, 3);
       }
       if ($$[$0-3].tableReferenceList.suggestJoinConditions) {
         parser.suggestJoinConditions($$[$0-3].tableReferenceList.suggestJoinConditions);
       }
       if ($$[$0-3].tableReferenceList.suggestJoins) {
         parser.suggestJoins($$[$0-3].tableReferenceList.suggestJoins);
       }
       if ($$[$0-3].tableReferenceList.suggestKeywords) {
         keywords = keywords.concat(parser.createWeightedKeywords($$[$0-3].tableReferenceList.suggestKeywords, 3));
       }

       // Lower the weights for 'TABLESAMPLE'
       keywords.forEach(function (keyword) {
         if (keyword.value === 'TABLESAMPLE') {
           keyword.weight = 1.1;
         }
       });

       if ($$[$0-3].tableReferenceList.types) {
         var veKeywords = parser.getValueExpressionKeywords($$[$0-3].tableReferenceList);
         keywords = keywords.concat(veKeywords.suggestKeywords);
         if (veKeywords.suggestColRefKeywords) {
           parser.suggestColRefKeywords(veKeywords.suggestColRefKeywords);
           parser.addColRefIfExists($$[$0-3].tableReferenceList);
         }
       }
     }

     if ($$[$0-1].empty && $$[$0] && $$[$0].joinType.toUpperCase() === 'JOIN') {
       keywords = keywords.concat(['FULL', 'FULL OUTER', 'INNER', 'LEFT', 'LEFT OUTER', 'RIGHT', 'RIGHT OUTER']);
       parser.suggestKeywords(keywords);
       return;
     }

     if ($$[$0-1].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].suggestFilters) {
       parser.suggestFilters($$[$0-1].suggestFilters);
     }
     if ($$[$0-1].suggestGroupBys) {
       parser.suggestGroupBys($$[$0-1].suggestGroupBys);
     }
     if ($$[$0-1].suggestOrderBys) {
       parser.suggestOrderBys($$[$0-1].suggestOrderBys);
     }

     if ($$[$0-1].empty) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }

     keywords = keywords.concat([
       { value: 'FULL JOIN', weight: 1 },
       { value: 'FULL OUTER JOIN', weight: 1 },
       { value: 'INNER JOIN', weight: 1 },
       { value: 'JOIN', weight: 1 },
       { value: 'LEFT JOIN', weight: 1 },
       { value: 'LEFT OUTER JOIN', weight: 1 },
       { value: 'RIGHT JOIN', weight: 1 },
       { value: 'RIGHT OUTER JOIN', weight: 1 }
     ]);
     parser.suggestKeywords(keywords);
  
break;
case 209:

     // A couple of things are going on here:
     // - If there are no SelectConditions (WHERE, GROUP BY, etc.) we should suggest complete join options
     // - If there's an OptionalJoin at the end, i.e. 'SELECT * FROM foo | JOIN ...' we should suggest
     //   different join types
     // - The FromClause could end with a valueExpression, in which case we should suggest keywords like '='
     //   or 'AND' based on type

     if (!$$[$0-1]) {
       parser.addClauseLocation('whereClause', _$[$0-2]);
       parser.addClauseLocation('limitClause', _$[$0-2]);
       return;
     }
     parser.addClauseLocation('whereClause', _$[$0-2], $$[$0-1].whereClauseLocation);
     parser.addClauseLocation('limitClause', $$[$0-1].limitClausePreceding || _$[$0-2], $$[$0-1].limitClauseLocation);
     var keywords = [];

     if ($$[$0-1].suggestColRefKeywords) {
       parser.suggestColRefKeywords($$[$0-1].suggestColRefKeywords);
       parser.addColRefIfExists($$[$0-1]);
     }

     if ($$[$0-1].suggestKeywords && $$[$0-1].suggestKeywords.length) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-1].suggestKeywords, 2));
     }

     if ($$[$0-1].cursorAtEnd) {
       keywords.push({ value: 'UNION', weight: 2.11 });
     }
     parser.suggestKeywords(keywords);
   
break;
case 210:
this.$ = [ $$[$0] ];
break;
case 211:

     $$[$0-2].push($$[$0]);
   
break;
case 213: case 214:

     this.$ = { cursorAtStart : true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 216:

     parser.checkForSelectListKeywords($$[$0-2]);
   
break;
case 217:

     parser.checkForSelectListKeywords($$[$0-3]);
   
break;
case 218:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestTables: true, suggestDatabases: true, suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true };
   
break;
case 220: case 221: case 223:

     this.$ = { suggestKeywords: parser.getSelectListKeywords(), suggestFunctions: true, suggestColumns: true, suggestAggregateFunctions: true,  };
   
break;
case 225:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
       this.$ = { valueExpression: $$[$0-1], alias: $$[$0].alias };
       if (!parser.yy.selectListAliases) {
         parser.yy.selectListAliases = [];
       }
       parser.yy.selectListAliases.push($$[$0-1].function && $$[$0-1].types && $$[$0-1].types.length && $$[$0-1].types[0] === 'UDFREF' ? { name: $$[$0].alias, udfRef: $$[$0-1].function, types: $$[$0-1].types } : { name: $$[$0].alias, types: $$[$0-1].types || ['T'] });
     } else {
       this.$ = { valueExpression: $$[$0-1] }
     }
   
break;
case 226:

     parser.addAsteriskLocation(_$[$0], [{ asterisk: true }]);
     this.$ = { asterisk: true }
   
break;
case 227:

     if ($$[$0]) {
       parser.addColumnAliasLocation($$[$0].location, $$[$0].alias, _$[$0-1]);
     }
   
break;
case 228:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.addColumnAliasLocation(_$[$0], $$[$0], _$[$0-2]);
     this.$ = { suggestAggregateFunctions: true };
   
break;
case 230:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'WHERE', weight: 7 }, { value: 'GROUP BY', weight: 6 }, { value: 'HAVING', weight: 5 }, { value: 'ORDER BY', weight: 4 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true, true]);

     if (keywords.length > 0) {
       this.$ = { suggestKeywords: keywords, empty: !$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0] };
     } else {
       this.$ = {};
     }

     this.$.whereClauseLocation = $$[$0-4] ? _$[$0-4] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;

     if (!$$[$0-4] && !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestFilters = { prefix: 'WHERE', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0]) {
       this.$.suggestGroupBys = { prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
     if (!$$[$0-1] && !$$[$0]) {
       this.$.suggestOrderBys = { prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() };
     }
   
break;
case 231:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'where';
     }
   
break;
case 232:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'group by';
     }
   
break;
case 234:

     if (parser.yy.result.suggestColumns) {
       parser.yy.result.suggestColumns.source = 'order by';
     }
   
break;
case 236:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-3], $$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'GROUP BY', weight: 8 }, { value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true, true]);
     if ($$[$0-5].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-5].suggestKeywords, 1));
     }
     this.$ = parser.getValueExpressionKeywords($$[$0-5], keywords);
     this.$.cursorAtEnd = !$$[$0-3] && !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if ($$[$0-5].columnReference) {
       this.$.columnReference = $$[$0-5].columnReference;
     }
     if (!$$[$0-3]) {
       parser.suggestGroupBys({ prefix: 'GROUP BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     if (!$$[$0-3] && !$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 237:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-2], $$[$0-1], $$[$0]],
       [{ value: 'HAVING', weight: 7 }, { value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true, true]);
     if ($$[$0-4].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-4].suggestKeywords, 8));
     }
     if ($$[$0-4].valueExpression) {
       this.$ = parser.getValueExpressionKeywords($$[$0-4].valueExpression, keywords);
       if ($$[$0-4].valueExpression.columnReference) {
         this.$.columnReference = $$[$0-4].valueExpression.columnReference;
       }
     } else {
       this.$ = { suggestKeywords: keywords };
     }
     this.$.cursorAtEnd = !$$[$0-2] && !$$[$0-1] && !$$[$0];
     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-2], _$[$0-2], $$[$0-4], _$[$0-4]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 238:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0-1], $$[$0]],
       [{ value: 'ORDER BY', weight: 5 }, { value: 'LIMIT', weight: 3 }],
       [true, true]);
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0-1] && !$$[$0] };
     if (!$$[$0-1]) {
       parser.suggestOrderBys({ prefix: 'ORDER BY', tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-1], _$[$0-1], $$[$0-3], _$[$0-3]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 239:

     var keywords = parser.getKeywordsForOptionalsLR(
       [$$[$0]],
       [{ value: 'LIMIT', weight: 3 }],
       [true]);
     if ($$[$0-2].suggestKeywords) {
       keywords = keywords.concat(parser.createWeightedKeywords($$[$0-2].suggestKeywords, 4));
     }
     this.$ = { suggestKeywords: keywords, cursorAtEnd: !$$[$0] };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2]);
     this.$.limitClauseLocation = $$[$0] ? _$[$0] : undefined;
   
break;
case 240:

     this.$ = { suggestKeywords: [], cursorAtEnd: true };
     this.$.whereClauseLocation = $$[$0-5] ? _$[$0-5] : undefined;
     this.$.limitClausePreceding = parser.firstDefined($$[$0-2], _$[$0-2], $$[$0-3], _$[$0-3], $$[$0-4], _$[$0-4], $$[$0-5], _$[$0-5]);
     this.$.limitClauseLocation = _$[$0-1];
   
break;
case 251:

     parser.suggestKeywords(['ALL', 'DISTINCT', 'SELECT']);
   
break;
case 252:

     parser.suggestKeywords(['ALL', 'DISTINCT']);
   
break;
case 257:

     if ($$[$0].suggestFilters) {
       parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
     }
   
break;
case 258:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS', 'NOT EXISTS']);
     parser.suggestFilters({ tablePrimaries: parser.yy.latestTablePrimaries.concat() });
   
break;
case 261:

     if (!$$[$0]) {
       $$[$0-1].suggestKeywords = ['OVER'];
     }
   
break;
case 268:

     parser.suggestKeywords(['OVER']);
   
break;
case 277:

     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 278: case 296:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 279:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       if ($$[$0-4].toLowerCase() === 'group_concat') {
         keywords.push('ALL');
       } else {
         keywords.push('DISTINCT');
       }
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 280: case 294:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 281:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords(true);
       if (!$$[$0-2]) {
         if ($$[$0-4].toLowerCase() === 'group_concat') {
           keywords.push('ALL');
         } else {
           keywords.push('DISTINCT');
         }
       }
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
       parser.suggestKeywords(keywords);
     }
     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], $$[$0-1].activePosition);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 290:

     parser.addFunctionArgumentLocations($$[$0-3], [{
       expression: { text: $$[$0-1] },
       location: _$[$0-1]
     }]);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] }
   
break;
case 291: case 297:

     this.$ = { function: $$[$0-2], types: ['UDFREF'] }
   
break;
case 292:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-1].expressions);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] }
   
break;
case 293:

     parser.valueExpressionSuggest();
     var keywords = parser.getSelectListKeywords();
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
       if (parser.yy.result.suggestKeywords) {
         keywords = parser.yy.result.suggestKeywords.concat(keywords);
       }
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 295:

     if ($$[$0-1].cursorAtStart) {
       var keywords = parser.getSelectListKeywords();
       if (!$$[$0-2]) {
         keywords.push('DISTINCT');
       }
       parser.suggestKeywords(keywords);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 298:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     var keywords = parser.getSelectListKeywords(true);
     if (!$$[$0-2]) {
       keywords.push('DISTINCT');
     }
     if (parser.yy.result.suggestKeywords) {
       keywords = parser.yy.result.suggestKeywords.concat(keywords);
     }
     parser.suggestKeywords(keywords);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 299:

     parser.suggestValueExpressionKeywords($$[$0-2]);
     this.$ = { function: $$[$0-5], types: ['UDFREF'] };
   
break;
case 300:

     if (parser.yy.result.suggestFunctions && !parser.yy.result.suggestFunctions.types) {
       parser.applyArgumentTypesToSuggestions($$[$0-4], 1);
     }
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 301:

    this.$ = { function: $$[$0-2], types: ['UDFREF'] }
  
break;
case 302:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     this.$ = {
       function: $$[$0-3],
       expression: $$[$0-1].expressions[$$[$0-1].expressions.length - 1].expression,
       types: ['UDFREF']
     }
   
break;
case 303:

     parser.valueExpressionSuggest();
     parser.applyArgumentTypesToSuggestions($$[$0-3], 1);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 304:

     parser.addFunctionArgumentLocations($$[$0-4], $$[$0-2].expressions);
     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = { function: $$[$0-4], types: ['UDFREF'] };
   
break;
case 305:

     parser.addFunctionArgumentLocations($$[$0-3], $$[$0-1].expressions);
     parser.applyArgumentTypesToSuggestions($$[$0-3], $$[$0-1].activePosition);
     this.$ = { function: $$[$0-3], types: ['UDFREF'] };
   
break;
case 310:

     var expression = $$[$0-3];
     parser.extractExpressionText(expression, $$[$0-3], $$[$0-2], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-5], [{
       expression: expression,
       location: {
         first_line: _$[$0-3].first_line,
         last_line: _$[$0-1].last_line,
         first_column: _$[$0-3].first_column,
         last_column: _$[$0-1].last_column
       }
     }]);
     this.$ = { types: [ $$[$0-1].toUpperCase() ] }
   
break;
case 311: case 316: case 317: case 751:
this.$ = { types: [ 'T' ] };
break;
case 312:

     parser.valueExpressionSuggest();
     this.$ = { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 313: case 314:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ] };
   
break;
case 315:
this.$ = { types: [ $$[$0-1].toUpperCase() ] };
break;
case 318:

     parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'AS', weight: 2 }]);
     this.$ =  { types: [ $$[$0-1].toUpperCase() ] };
   
break;
case 319:

     parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'AS', weight: 2 }]);
     this.$ = { types: [ 'T' ] };
   
break;
case 320: case 321:

     parser.suggestKeywords(parser.getTypeKeywords());
     this.$ = { types: [ 'T' ] };
   
break;
case 322:

     // We need to handle arbitrary UDFs here instead of inside UserDefinedFunction or there will be a conflict
     // with columnReference for functions like: db.udf(foo)
     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     if ($$[$0-1].lastLoc && $$[$0-1].lastLoc.location) {
       $$[$0-1].lastLoc.type = 'function';
       $$[$0-1].lastLoc.function = fn;
       $$[$0-1].lastLoc.location = {
         first_line: $$[$0-1].lastLoc.location.first_line,
         last_line: $$[$0-1].lastLoc.location.last_line,
         first_column: $$[$0-1].lastLoc.location.first_column,
         last_column: $$[$0-1].lastLoc.location.last_column - 1
       }
       if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
          $$[$0-1].firstLoc.type = 'database';
       } else {
         delete $$[$0-1].lastLoc.identifierChain;
       }
     }
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: fn, expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: fn, types: ['UDFREF'] }
     }
   
break;
case 323:

    parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
    if ($$[$0].expressions && $$[$0].expressions.length) {
      this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
    } else {
      this.$ = { function: $$[$0-1], types: ['UDFREF'] }
    }
  
break;
case 326:
this.$ = { types: ['COLREF'], columnReference: $$[$0].chain };
break;
case 327:
this.$ = { types: [ 'NULL' ], text: $$[$0] };
break;
case 328:

     var fn = $$[$0-1].chain[$$[$0-1].chain.length - 1].name.toLowerCase();
     parser.addFunctionArgumentLocations(fn, $$[$0].expressions, $$[$0-1].chain);
     $$[$0-1].lastLoc.type = 'function';
     $$[$0-1].lastLoc.function = fn;
     $$[$0-1].lastLoc.location = {
       first_line: $$[$0-1].lastLoc.location.first_line,
       last_line: $$[$0-1].lastLoc.location.last_line,
       first_column: $$[$0-1].lastLoc.location.first_column,
       last_column: $$[$0-1].lastLoc.location.last_column - 1
     }
     if ($$[$0-1].lastLoc !== $$[$0-1].firstLoc) {
        $$[$0-1].firstLoc.type = 'database';
     } else {
       delete $$[$0-1].lastLoc.identifierChain;
     }
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions(fn, $$[$0].activePosition);
     }
     this.$ = { function: fn, types: ['UDFREF'] };
   
break;
case 329: case 335: case 336:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].activePosition) {
       parser.applyArgumentTypesToSuggestions($$[$0-1], $$[$0].activePosition);
     }
     this.$ = { function: $$[$0-1], types: ['UDFREF'] };
   
break;
case 332:

     if ($$[$0].suggestKeywords) {
       this.$ = { types: ['COLREF'], columnReference: $$[$0], suggestKeywords: $$[$0].suggestKeywords };
     } else {
       this.$ = { types: ['COLREF'], columnReference: $$[$0] };
     }
   
break;
case 333: case 334:

     parser.addFunctionLocation(_$[$0-1], $$[$0-1]);
     parser.addFunctionArgumentLocations($$[$0-1], $$[$0].expressions);
     if ($$[$0].expressions && $$[$0].expressions.length) {
       this.$ = { function: $$[$0-1], expression: $$[$0].expressions[$$[$0].expressions.length - 1].expression, types: ['UDFREF'] }
     } else {
       this.$ = { function: $$[$0-1], types: ['UDFREF'] }
     }
   
break;
case 339:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }]
     }
   
break;
case 340:

     parser.suggestValueExpressionKeywords($$[$0-2].expressions[$$[$0-2].expressions.length - 1].expression);
     this.$ = $$[$0-3];
   
break;
case 342: case 344:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0], location: _$[$0] }]
     }
   
break;
case 343: case 345:

     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: $$[$0], location: _$[$0] }])
     }
   
break;
case 346:

     this.$ = {
       activePosition: 1,
       expressions: [{ expression: $$[$0-2], location: _$[$0-2] }].concat($$[$0].expressions)
     }
   
break;
case 347:

     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: $$[$0-2], location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 348:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-2].activePosition + 1,
       expressions: $$[$0-2].expressions.concat([{ expression: { text: '' }, location: _$[$0] }])
     }
   
break;
case 349:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: $$[$0-4].activePosition + 1,
       expressions: $$[$0-4].expressions.concat([{ expression: { text: '' }, location: _$[$0-2] }]).concat($$[$0].expressions)
     }
   
break;
case 350:

     parser.suggestValueExpressionKeywords($$[$0-3].expressions[$$[$0-3].expressions.length - 1].expression);
     this.$ = {
       activePosition: $$[$0-3].activePosition,
       expressions: $$[$0-3].expressions.concat($$[$0].expressions)
     }
   
break;
case 351:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 352:

     parser.valueExpressionSuggest();
     this.$ = {
       cursorAtStart : true,
       activePosition: 1,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 353:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-1] }, { expression: { text: '' }, location: _$[$0] }]
     };
   
break;
case 354:

     parser.valueExpressionSuggest();
     this.$ = {
       activePosition: 2,
       expressions: [{ expression: { text: '' }, location: _$[$0-3] }, { expression: { text: '' }, location: _$[$0-2] }].concat($$[$0].expressions)
     };
   
break;
case 362: case 363:

     return parser.yy.result;
   
break;
case 364:

     parser.prepareNewStatement();
   
break;
case 366: case 368: case 370:

     parser.addStatementLocation(_$[$0]);
   
break;
case 369: case 371:

     parser.addStatementLocation(_$[$0-3]);
   
break;
case 375:

     parser.suggestDdlAndDmlKeywords();
   
break;
case 504: case 507: case 593:
this.$ = '';
break;
case 519: case 522:

     parser.yy.correlatedSubQuery = false;
   
break;
case 520: case 524:

     parser.suggestKeywords(['EXISTS']);
   
break;
case 523:

     parser.suggestKeywords(['NOT EXISTS']);
   
break;
case 534: case 536: case 537: case 539:

     parser.suggestKeywords(['<', '<=', '<>', '=', '>', '>=']);
   
break;
case 535: case 538:

     parser.suggestKeywords(['VALUES']);
   
break;
case 568: case 594:

     parser.addTableLocation(_$[$0], [ { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0] } ] };
   
break;
case 569: case 595:

     parser.addDatabaseLocation(_$[$0-2], [ { name: $$[$0-2] } ]);
     parser.addTableLocation(_$[$0], [ { name: $$[$0-2] }, { name: $$[$0] } ]);
     this.$ = { identifierChain: [ { name: $$[$0-2] }, { name: $$[$0] } ] };
   
break;
case 571: case 576:

     parser.suggestDatabases();
     this.$ = { identifierChain: [{ name: $$[$0-2] }] };
   
break;
case 572: case 597:

     parser.suggestTablesOrColumns($$[$0-2]);
   
break;
case 573:
this.$ = [{ name: $$[$0] }];
break;
case 574:
this.$ = [{ name: $$[$0-2] }, { name: $$[$0-1] }];
break;
case 575:

     parser.suggestDatabases({ appendDot: true });
   
break;
case 579:

     parser.suggestDatabases();
   
break;
case 596:

     parser.suggestTables();
     parser.suggestDatabases({ prependDot: true });
   
break;
case 599:
this.$ = { identifierChain: $$[$0-1].identifierChain, alias: $$[$0] };
break;
case 602:

     parser.yy.locations[parser.yy.locations.length - 1].type = 'column';
   
break;
case 603: case 768:

     parser.addAsteriskLocation(_$[$0], $$[$0-2].concat({ asterisk: true }));
   
break;
case 605:

     this.$ = [ $$[$0].identifier ];
     parser.yy.firstChainLocation = parser.addUnknownLocation($$[$0].location, [ $$[$0].identifier ]);
   
break;
case 606:

     if (parser.yy.firstChainLocation) {
       parser.yy.firstChainLocation.firstInChain = true;
       delete parser.yy.firstChainLocation;
     }
     $$[$0-2].push($$[$0].identifier);
     parser.addUnknownLocation($$[$0].location, $$[$0-2].concat());
   
break;
case 607:

     parser.suggestColumns({
       identifierChain: $$[$0-2]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 608:

     parser.suggestColumns({
       identifierChain: $$[$0-4]
     });
     this.$ = { suggestKeywords: [{ value: '*', weight: 10000 }] };
   
break;
case 609:
this.$ = [ $$[$0].identifier ];
break;
case 610:

     $$[$0-2].push($$[$0].identifier);
   
break;
case 612:

     parser.suggestColumns({ identifierChain: $$[$0-2] });
   
break;
case 613:

     parser.suggestColumns({ identifierChain: $$[$0-4] });
   
break;
case 615:
this.$ = { identifier: { name: $$[$0] }, location: _$[$0] };
break;
case 636: case 637:

     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 638: case 663:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 639:

     // verifyType($$[$0], 'NUMBER');
     this.$ = $$[$0];
     $$[$0].types = ['NUMBER'];
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 640: case 641: case 642:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 643:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 644:

     this.$ = { types: [ 'BOOLEAN' ] };
     // clear correlated flag after completed sub-query (set by lexer)
     parser.yy.correlatedSubQuery = false;
   
break;
case 646: case 647: case 648: case 649:

     parser.addColRefToVariableIfExists($$[$0-2], $$[$0]);
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 650: case 651: case 652: case 653: case 683: case 741: case 742:
this.$ = { types: [ 'BOOLEAN' ] };
break;
case 654:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-5], $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 655:

     this.$ = { types: [ 'BOOLEAN' ] }
     parser.extractExpressionText(this.$, $$[$0-4], $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 656: case 657:

     // verifyType($$[$0-2], 'BOOLEAN');
     // verifyType($$[$0], 'BOOLEAN');
     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 658: case 659: case 660:

     // verifyType($$[$0-2], 'NUMBER');
     // verifyType($$[$0], 'NUMBER');
     this.$ = { types: [ 'NUMBER' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 661:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 662:

     this.$ = { types: [ 'BOOLEAN' ] };
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 664:

     this.$ = $$[$0];
     parser.extractExpressionText(this.$, $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 666:

     parser.suggestKeywords(['BETWEEN', 'EXISTS', 'IN', 'LIKE', 'REGEXP', 'RLIKE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 667: case 669:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
break;
case 668:

     parser.suggestFunctions();
     parser.suggestColumns();
     parser.suggestKeywords(['EXISTS']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 670:

     parser.suggestFunctions({ types: [ 'BOOLEAN' ] });
     parser.suggestColumns({ types: [ 'BOOLEAN' ] });
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 671:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0].suggestFilters };
break;
case 672:

     parser.suggestFunctions();
     parser.suggestColumns();
     this.$ = { types: [ 'T' ] };
   
break;
case 673:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 674:

     parser.suggestFunctions({ types: [ 'NUMBER' ] });
     parser.suggestColumns({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ] };
   
break;
case 675:

     parser.suggestKeywords(['FALSE', 'NOT NULL', 'NOT TRUE', 'NOT FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 676:

     parser.suggestKeywords(['FALSE', 'NULL', 'TRUE']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 677:

     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 678: case 679: case 680:

     parser.suggestKeywords(['NOT']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 681:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-3] ? 'IS NOT DISTINCT FROM' : 'IS DISTINCT FROM');
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 682:

     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 684:

     this.$ = $$[$0-1];
   
break;
case 685:

     parser.valueExpressionSuggest();
     this.$ = { types: ['T'], typeSet: true };
   
break;
case 686:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 687: case 688: case 689:

     parser.valueExpressionSuggest($$[$0], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 690: case 691: case 692: case 693:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0]);
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 694: case 696:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 695:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ] , typeSet: true, endsWithLessThanOrEqual: true };
   
break;
case 697:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, endsWithLessThanOrEqual: $$[$0-1] === '<='  };
   
break;
case 698: case 699: case 700: case 701:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 702:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-3]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 703:

     if ($$[$0].inValueEdit) {
       parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     if ($$[$0].cursorAtStart) {
       parser.suggestKeywords(['SELECT']);
     }
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 704: case 705:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
break;
case 706: case 707:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
break;
case 708:

     if ($$[$0-2].types[0] === $$[$0].types[0] && !$$[$0-5].typeSet) {
       parser.applyTypeToSuggestions($$[$0-2]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-5].suggestFilters };
   
break;
case 709:

     if ($$[$0-5].types[0] === $$[$0].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 710:

     if ($$[$0-5].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-5]);
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 711:

     parser.valueExpressionSuggest($$[$0-5], $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 712: case 718:

     parser.suggestValueExpressionKeywords($$[$0-1], ['AND']);
     this.$ = { types: [ 'BOOLEAN' ] };
   
break;
case 713:

     parser.valueExpressionSuggest($$[$0-3], $$[$0-2] + ' ' + $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 714:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-4].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-4].suggestFilters };
   
break;
case 715:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
   
break;
case 716:

     if ($$[$0-4].types[0] === $$[$0-2].types[0] && !$$[$0].typeSet) {
       parser.applyTypeToSuggestions($$[$0-4])
     }
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 717:

     parser.valueExpressionSuggest($$[$0-4], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-4]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true  };
   
break;
case 719:

     parser.valueExpressionSuggest($$[$0-2], $$[$0-1]);
     parser.applyTypeToSuggestions($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 720: case 722: case 724: case 726:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true, suggestFilters: true };
   
break;
case 721: case 725:

     parser.addColRefIfExists($$[$0]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 723: case 727:

     parser.addColRefIfExists($$[$0-2]);
     this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0].suggestFilters }
   
break;
case 728: case 729:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: [ 'NUMBER' ] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 730: case 731: case 732:

     if (!$$[$0-2].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0-2].suggestFilters }
   
break;
case 733: case 734: case 735:

     parser.valueExpressionSuggest(undefined, $$[$0-1]);
     parser.applyTypeToSuggestions({ types: ['NUMBER'] });
     this.$ = { types: [ 'NUMBER' ], typeSet: true };
   
break;
case 736: case 737: case 738:

     if (!$$[$0].typeSet) {
       parser.applyTypeToSuggestions({ types: ['NUMBER'] });
       parser.addColRefIfExists($$[$0-2]);
     }
     this.$ = { types: [ 'NUMBER' ], suggestFilters: $$[$0].suggestFilters };
   
break;
case 739:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 740:
this.$ = { types: [ 'BOOLEAN' ], suggestFilters: $$[$0-2].suggestFilters };
break;
case 743:

     parser.valueExpressionSuggest(undefined, $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 744:

     parser.valueExpressionSuggest(undefined, $$[$0-1] + ' ' + $$[$0]);
     parser.applyTypeToSuggestions({ types: [ 'STRING' ] });
     this.$ = { types: [ 'BOOLEAN' ], typeSet: true };
   
break;
case 746:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 748:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 749:

      this.$ = $$[$0];
      this.$.suggestFilters = $$[$0-1].suggestFilters;
    
break;
case 750:
this.$ = { types: [ 'T' ], suggestFilters: $$[$0-1].suggestFilters };
break;
case 752: case 754:

     $$[$0].position = 1;
   
break;
case 753:

     $$[$0].position = $$[$0-2].position + 1;
     this.$ = $$[$0];
   
break;
case 755:

     $$[$0-2].position += 1;
   
break;
case 756:

     $$[$0-2].position = 1;
   
break;
case 757:

     $$[$0-4].position += 1;
   
break;
case 758:

     parser.valueExpressionSuggest();
     $$[$0-2].position += 1;
   
break;
case 759:

     parser.valueExpressionSuggest();
     $$[$0-4].position += 1;
   
break;
case 760:

     parser.suggestValueExpressionKeywords($$[$0-3]);
   
break;
case 761: case 762:

     parser.valueExpressionSuggest();
     this.$ = { cursorAtStart : true, position: 1 };
   
break;
case 763: case 764:

     parser.valueExpressionSuggest();
     this.$ = { position: 2 };
   
break;
case 767:

     var lastLoc = parser.yy.locations[parser.yy.locations.length - 1];
     if (lastLoc.type !== 'variable') {
       lastLoc.type = 'column';
     }
     // used for function references with db prefix
     var firstLoc = parser.yy.locations[parser.yy.locations.length - $$[$0].length];
     this.$ = { chain: $$[$0], firstLoc: firstLoc, lastLoc: lastLoc }
   
break;
case 774:

     parser.suggestValues($$[$0]);
   
break;
case 775:
this.$ = { types: [ 'NUMBER' ], text: $$[$0] };
break;
case 781: case 783: case 784:
this.$ = $$[$0-1] + $$[$0];
break;
case 782: case 785:
this.$ = $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 786:
this.$ = $$[$0-3] + $$[$0-2] + $$[$0-1] + $$[$0];
break;
case 787:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: "'" + $$[$0] + "'" }
     } else {
       this.$ = { types: [ 'STRING' ] }
     }
   
break;
case 788:

     if (/\$\{[^}]*\}/.test($$[$0])) {
       parser.addVariableLocation(_$[$0], $$[$0]);
       this.$ = { types: [ 'STRING' ], columnReference: [{ name: $$[$0] }], text: '"' + $$[$0] + '"' }
     } else {
       this.$ = { types: [ 'STRING' ], text: '"' + $$[$0] + '"' }
     }
   
break;
case 789:
this.$ = { types: [ 'BOOLEAN' ], text: $$[$0] };
break;
case 790:

    this.$ = { partialQuote: '\'', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 791:

    this.$ = { partialQuote: '"', missingEndQuote: parser.yy.missingEndQuote };
  
break;
case 798:

     this.$ = $$[$0];

     if (parser.yy.latestTablePrimaries.length > 0) {
       var idx = parser.yy.latestTablePrimaries.length - 1;
       var tables = [];
       do {
         var tablePrimary = parser.yy.latestTablePrimaries[idx];
         if (!tablePrimary.subQueryAlias) {
           tables.unshift(tablePrimary.alias ? { identifierChain: tablePrimary.identifierChain, alias: tablePrimary.alias } : { identifierChain: tablePrimary.identifierChain })
         }
         idx--;
       } while (idx >= 0 && tablePrimary.join && !tablePrimary.subQueryAlias)

       if (tables.length > 0) {
         this.$.suggestJoins = {
           prependJoin: true,
           tables: tables
         };
       }
      }
   
break;
case 805:

     this.$ = {
       primary: $$[$0-1]
     }
     if ($$[$0-1].identifierChain) {
       if ($$[$0]) {
         $$[$0-1].alias = $$[$0].alias
         parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
       }
       parser.addTablePrimary($$[$0-1]);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     } else if ($$[$0].suggestKeywords) {
       keywords = $$[$0].suggestKeywords;
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 806:

     this.$ = {
       primary: $$[$0-1]
     };

     if ($$[$0]) {
       this.$.primary.alias = $$[$0].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }

     var keywords = [];
     if (!$$[$0]) {
       keywords = ['AS'];
     }
     if (keywords.length > 0) {
       this.$.suggestKeywords = keywords;
     }
   
break;
case 807:

     if ($$[$0]) {
       parser.addTableAliasLocation($$[$0].location, $$[$0].alias, $$[$0-1].identifierChain);
     }
   
break;
case 808:

     if ($$[$0]) {
       parser.addTablePrimary({ subQueryAlias: $$[$0].alias });
       parser.addSubqueryAliasLocation($$[$0].location, $$[$0].alias);
     }
   
break;
case 818:

     parser.pushQueryState();
   
break;
case 819:

     parser.popQueryState();
   
break;
case 821:

     if ($$[$0-1]) {
       $$[$0-2].alias = $$[$0-1].alias;
       parser.addTablePrimary({ subQueryAlias: $$[$0-1].alias });
       parser.addSubqueryAliasLocation($$[$0-1].location, $$[$0-1].alias, $$[$0-2].identifierChain);
     }
     this.$ = $$[$0-2];
   
break;
case 824:

     var subQuery = parser.getSubQuery($$[$0]);
     subQuery.columns.forEach(function (column) {
       parser.expandIdentifierChain({ wrapper: column });
       delete column.linked;
     });
     parser.popQueryState(subQuery);
     this.$ = subQuery;
   
break;
case 841: case 842: case 843: case 844:
this.$ = { alias: $$[$0], location: _$[$0] };
break;
case 851: case 852:

     if (parser.yy.result.suggestFunctions) {
       parser.suggestAggregateFunctions();
     }
   
break;
case 853:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords([{ value: 'PARTITION BY', weight: 2 }, { value: 'ORDER BY', weight: 1 }]);
     } else if (!$$[$0-2]) {
       parser.suggestKeywords(['PARTITION BY']);
     }
   
break;
case 854:

      if (!$$[$0-1]) {
        parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ORDER BY', weight: 2 }]);
      } else {
        parser.suggestValueExpressionKeywords($$[$0-3]);
      }
    
break;
case 858:

     parser.suggestKeywords(['BY']);
   
break;
case 863:

      // Only allowed in last order by
      delete parser.yy.result.suggestAnalyticFunctions;
    
break;
case 864:

      var keywords = [];
      if ($$[$0-2].suggestKeywords) {
        keywords = parser.createWeightedKeywords($$[$0-2].suggestKeywords, 2);
      }
      if (!$$[$0]) {
        keywords = keywords.concat([{ value: 'RANGE BETWEEN', weight: 1 }, { value: 'ROWS BETWEEN', weight: 1 }]);
      }
      parser.suggestKeywords(keywords);
    
break;
case 870:

     parser.suggestKeywords(['BETWEEN']);
   
break;
case 871:

     if (!$$[$0-2] && !$$[$0-1]) {
       parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED PRECEDING']);
     } else if (!$$[$0-1]) {
       parser.suggestKeywords(['AND']);
     }
   
break;
case 876:

    lexer.popState();
  
break;
case 877:

    lexer.begin('hdfs');
  
break;
case 879:

      parser.suggestHdfs({ path: $$[$0-3] });
    
break;
case 880:

     parser.suggestHdfs({ path: $$[$0-2] });
   
break;
case 881:

      parser.suggestHdfs({ path: $$[$0-1] });
    
break;
case 882:

     parser.suggestHdfs({ path: '' });
   
break;
case 883:

      parser.suggestHdfs({ path: '' });
    
break;
case 889:

     parser.suggestKeywords(['PRECEDING']);
   
break;
case 890: case 895:

     parser.suggestKeywords(['ROW']);
   
break;
case 894:

     parser.suggestKeywords(['CURRENT ROW', 'UNBOUNDED FOLLOWING']);
   
break;
case 896:

     parser.suggestKeywords(['FOLLOWING']);
   
break;
case 900:
this.$ = { inValueEdit: true };
break;
case 901:
this.$ = { inValueEdit: true, cursorAtStart: true };
break;
case 902: case 903: case 904:

     this.$ = { suggestKeywords: ['NOT'] }
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 908: case 909: case 910:

     parser.suggestFunctions({ types: [ 'STRING' ] });
     parser.suggestColumns({ types: [ 'STRING' ] });
     this.$ = { types: ['BOOLEAN'] }
   
break;
case 911:

     this.$ = parser.findCaseType($$[$0-1])
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 912:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 913:
this.$ = parser.findCaseType($$[$0-1]);
break;
case 914:

     parser.suggestValueExpressionKeywords($$[$0-1], ['END']);
     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 915:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 916:
this.$ = parser.findCaseType($$[$0-2]);
break;
case 917:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-3], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 918:

     if ($$[$0].toLowerCase() !== 'end') {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'END', weight: 3 }, { value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     } else {
       parser.suggestValueExpressionKeywords($$[$0-2], [{ value: 'ELSE', weight: 2 }, { value: 'WHEN', weight: 1 }]);
     }
     this.$ = parser.findCaseType($$[$0-2]);
   
break;
case 919:

     $$[$0-3].caseTypes.push($$[$0-1]);
     this.$ = parser.findCaseType($$[$0-3]);
     this.$.suggestFilters = $$[$0-1].suggestFilters
   
break;
case 920:

     parser.valueExpressionSuggest();
     this.$ = parser.findCaseType($$[$0-3]);
   
break;
case 921:

     parser.valueExpressionSuggest();
     this.$ = { types: [ 'T' ], typeSet: true };
   
break;
case 922:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = $$[$0-1];
   
break;
case 923:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { types: [ 'T' ] };
   
break;
case 926:

     this.$ = { caseTypes: [ $$[$0] ], lastType: $$[$0] }
     parser.extractExpressionText(this.$, $$[$0]);
   
break;
case 927:

     $$[$0-1].caseTypes.push($$[$0]);
     this.$ = { caseTypes: $$[$0-1].caseTypes, lastType: $$[$0] };
     parser.extractExpressionText(this.$, $$[$0-1], $$[$0]);
   
break;
case 931:

     parser.suggestValueExpressionKeywords($$[$0-2], ['WHEN']);
   
break;
case 933:

     this.$ = $$[$0]
     parser.extractExpressionText(this.$, $$[$0-3], $$[$0-2], $$[$0-1], $$[$0]);
   
break;
case 934:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0].suggestFilters };
break;
case 935:
this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: $$[$0-1].suggestFilters };
break;
case 936:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0-2].suggestFilters };
break;
case 937: case 938:
this.$ = { caseTypes: [$$[$0]], suggestFilters: $$[$0].suggestFilters };
break;
case 939:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 940:

     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [$$[$0]] };
   
break;
case 941:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['WHEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 942:

      parser.valueExpressionSuggest();
      parser.suggestKeywords(['WHEN']);
      this.$ = { caseTypes: [{ types: ['T'] }] };
    
break;
case 943: case 945:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 944:

     parser.valueExpressionSuggest();
     parser.suggestKeywords(['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }], suggestFilters: true };
   
break;
case 946:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [$$[$0]], suggestFilters: true };
   
break;
case 947:

     parser.suggestValueExpressionKeywords($$[$0-1], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 948:

     parser.suggestValueExpressionKeywords($$[$0-2], ['THEN']);
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
case 949: case 950: case 951: case 952:

     parser.valueExpressionSuggest();
     this.$ = { caseTypes: [{ types: ['T'] }] };
   
break;
}
},
table: [o($V0,$V1,{207:1,149:2}),{1:[3]},o($V2,$V3,{208:3,212:4,9:5,16:7,10:8,11:9,12:10,48:11,49:12,32:14,33:15,34:16,4:$V4,17:$V5,35:$V6,126:$V7,215:$V8}),{209:[1,20],213:[1,21]},o($V2,[2,366]),o($V2,[2,372]),o($V2,[2,373]),o($V2,[2,374]),o($V2,[2,5]),o($V2,[2,6]),o($V2,[2,7]),{18:[1,23],49:22,126:$V7},o($V9,$Va,{50:24,144:25,146:26,148:$Vb}),{13:[1,28],31:[1,29]},o($V2,[2,33]),o($V2,[2,34]),o($V2,[2,35]),{54:30,56:31,58:32,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},o([18,113,139,174,175,176,177,178,179,180,181,182,183,184,186,187,188,189,190,196,219,220,221,222,224,225,226,231,234,238,245,248,249,257,269,275,276,277],$Vi,{127:41,132:$Vj,133:$Vk}),{36:[1,44],39:[1,45],42:[1,46]},{1:[2,361]},o($V0,$V1,{149:47}),o($V9,$Va,{144:25,146:26,50:48,148:$Vb}),{16:49,17:$V5,48:11,49:12,126:$V7},o($V9,[2,52]),o($V9,[2,242],{146:50,148:$Vb}),o($Vl,[2,244]),o([126,132,133],$V1,{149:51}),{14:52,58:53,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},{14:54,58:53,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},o([18,126],[2,61],{22:[1,55]}),o($Vm,[2,63]),{15:[1,56]},o($Vn,[2,591]),{234:[1,58],285:[1,57]},o($Vn,[2,384]),o($Vn,[2,385]),o($Vn,[2,386]),o($Vn,[2,381]),o($Vn,[2,382]),o($Vn,[2,383]),{18:$Vo,24:92,41:99,58:93,81:61,112:91,113:$Vc,128:59,136:60,139:$Vp,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($VU,[2,204]),o($VU,[2,205]),{37:[1,117]},o($V2,[2,37],{40:[1,118]}),{37:[1,119]},o($V2,$V3,{212:4,9:5,16:7,10:8,11:9,12:10,48:11,49:12,32:14,33:15,34:16,208:120,4:$V4,17:$V5,35:$V6,126:$V7,215:$V8}),o($V9,[2,50]),{20:[1,121]},o($Vl,[2,245]),{126:$Vi,127:122,132:$Vj,133:$Vk},{15:[1,123],17:[1,124]},o($VV,[2,573],{226:[1,125]}),{15:[1,126]},{56:127,58:32,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},{18:[1,128]},{234:[1,129]},o($Vn,[2,593]),o($Vl,[2,193],{129:130,63:132,22:[1,131],37:[1,133]}),o($VW,[2,210]),o($VW,$VX,{202:33,218:37,138:134,342:148,58:149,290:150,41:155,288:156,15:$VY,23:$VZ,40:$V_,113:$Vc,139:$V$,219:$Vd,220:$Ve,221:$Vf,222:$Vg,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,234:$Vh,235:$V51,240:$V61,245:$VM,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,269:$VQ}),o($VW,[2,226]),o($Vd1,[2,635]),{18:$Vo,24:92,41:99,58:93,81:157,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:158,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:159,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:160,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Ve1,339:161},{18:$Vo,24:92,41:99,58:93,81:163,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:165,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,280:$Vf1,288:100,322:85,331:76,343:164,353:84,355:97,356:98,357:101,405:166,407:167},o($Vd1,[2,326],{194:169,18:$Vg1}),{18:$Vg1,194:171},o($Vd1,[2,324]),o($Vd1,[2,325]),o($Vd1,[2,327]),o($Vh1,[2,767],{226:[1,172]}),{18:[2,306]},{18:[2,307]},{18:[2,308]},{18:[2,309]},o($Vd1,[2,355],{155:173,157:174,204:$Vi1}),{157:176,204:$Vi1},o($Vd1,[2,263]),o($Vd1,[2,773]),o($Vj1,[2,605]),o($Vk1,[2,271]),o($Vk1,[2,272]),o($Vk1,[2,273]),{18:[1,177]},{18:[1,178]},o($Vd1,[2,775]),o($Vd1,[2,776]),o($Vj1,[2,615]),{18:[1,179]},{18:[1,180]},{18:[1,181]},o($Vd1,[2,778]),o($Vd1,[2,779]),o($Vd1,[2,787]),o($Vd1,[2,788]),o($Vd1,[2,789]),{18:[2,282]},{18:[2,283]},{18:[2,284]},{18:[2,285]},{18:[2,286]},{18:[2,287]},{18:[2,288]},{18:[2,289]},o($Vd1,[2,780],{226:[1,182]}),{276:[1,183],277:[1,184]},{276:[1,185]},{269:[1,187],285:[1,186]},{245:[1,189],285:[1,188]},o($Vd1,[2,792]),o($Vd1,[2,793]),{38:190,58:191,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},{41:192,269:$VQ},{43:193,58:194,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},o($V2,[2,367]),o($V9,$Va,{144:25,146:26,50:195,148:$Vb}),{49:196,126:$V7},{16:197,17:$V5,48:11,49:12,126:$V7},{18:[1,198]},{58:199,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},{16:200,17:$V5,48:11,49:12,126:$V7},o($Vm,[2,64]),o($Vl1,$Vm1,{59:201,368:202}),o($Vn,[2,592]),o($Vl,[2,194]),{18:$Vo,24:92,41:99,58:93,81:61,112:91,113:$Vc,136:203,139:$Vp,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vn1,[2,254],{134:204,141:205,143:206,150:[1,207]}),{18:$Ve1,38:215,58:191,64:208,67:209,92:211,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,339:216,358:210,360:212,362:213,363:214},o($VW,[2,225]),o($Vo1,[2,794],{338:217,257:[1,218]}),{18:$Vo,24:92,41:99,58:93,81:219,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:220,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:221,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:222,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{40:$V_,235:[1,224],253:[1,223],263:$Vb1,264:$Vc1,342:225},{18:[1,226]},{18:$Vo,24:92,41:99,58:93,81:227,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:228,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:229,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:230,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:231,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:232,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vd1,[2,661]),o($Vp1,[2,841]),o($Vp1,[2,842]),{41:155,58:233,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,245:$VM,269:$VQ,288:156,290:234},{18:$Vo,24:92,41:99,58:93,81:235,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:236,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:237,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vp1,[2,509]),o($Vp1,[2,510]),o($Vq1,[2,636],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,240:$V61,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($Vq1,[2,637],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,240:$V61,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($Vq1,[2,638],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,240:$V61,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($Vr1,[2,639],{342:148}),o($Vd1,[2,644]),o($Vl1,$Vm1,{368:202,339:216,59:238,363:239,18:$Ve1}),{20:[1,240],23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,342:148},o($Vd1,[2,663]),{23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,280:$Vf1,342:148,343:241,405:166,407:167},{246:[1,243],247:[1,242],280:$Vf1,407:244},o($Vs1,[2,926]),{18:$Vo,24:92,41:99,58:93,81:245,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vd1,[2,322]),{18:$Vo,20:[1,246],24:92,41:99,58:93,81:248,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,172:247,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vd1,[2,323]),{58:93,113:$Vc,139:[1,249],202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,322:250},o($Vd1,[2,261]),o($Vd1,[2,356]),{18:[1,253],58:251,113:$Vc,202:33,205:252,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},o($Vd1,[2,262]),{18:$Vo,20:[1,254],24:92,41:99,58:93,81:248,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,172:255,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,20:[1,257],24:92,41:99,58:93,81:256,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o([18,20,113,174,175,176,177,178,179,180,181,182,183,184,186,187,188,189,190,196,219,220,221,222,224,225,226,231,234,238,245,248,249,257,269,275,276,277],$Vi,{127:258,132:$Vj,133:$Vk}),o($Vt1,$Vi,{127:261,20:[1,260],132:$Vj,133:$Vk,139:[1,259]}),o($Vt1,$Vi,{127:262,20:[1,263],132:$Vj,133:$Vk}),o($Vd1,[2,781],{276:[1,264],277:[1,265]}),o($Vd1,[2,783]),{276:[1,266]},o($Vd1,[2,784]),{269:[1,267]},o($Vu1,[2,504]),{245:[1,268]},o($Vu1,[2,507]),o($V2,[2,36]),o($Vv1,[2,568],{226:[1,269]}),o($V2,[2,38]),o($V2,[2,39]),o($V2,[2,578]),o($V9,[2,51]),o($Vl,[2,250]),o($V2,[2,8]),{14:272,19:270,21:271,58:53,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},o($VV,[2,574]),o($V2,[2,27]),{20:[1,273]},{16:281,17:$V5,48:11,49:12,126:$V7,370:274,372:275,374:276,376:277,378:278,380:279,382:280},o($VW,[2,211]),o($Vl,[2,206]),o($Vw1,[2,83],{69:282,70:283,71:[1,284]}),o($Vn1,[2,255]),{18:$Vo,24:92,41:99,58:93,81:286,112:91,113:$Vc,151:285,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o([20,71,86,111,117,148,150,209,213],[2,73],{22:[1,287]}),o($Vx1,[2,76]),o($Vx1,[2,796]),o($Vx1,[2,798],{89:288,91:289,99:$Vy1,100:$Vz1,101:$VA1,102:$VB1,103:$VC1,104:$VD1,105:$VE1,106:$VF1}),o($Vx1,[2,799]),o($VG1,$VX,{202:33,218:37,58:149,290:150,41:155,288:156,138:298,15:$VY,113:$Vc,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,245:$VM,269:$VQ}),o($VG1,$VX,{202:33,218:37,58:149,290:150,41:155,288:156,138:299,15:$VY,113:$Vc,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,245:$VM,269:$VQ}),o($Vv1,[2,810]),o($Vv1,[2,812]),{133:[1,303],196:[1,300],249:[1,302],275:[1,301]},o($Vo1,[2,795]),o($VH1,[2,646],{342:148,40:$V_,139:$V$,225:$V01,233:$V41,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($VH1,[2,647],{342:148,40:$V_,139:$V$,225:$V01,233:$V41,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($VH1,[2,648],{342:148,40:$V_,139:$V$,225:$V01,233:$V41,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($VH1,[2,649],{342:148,40:$V_,139:$V$,225:$V01,233:$V41,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),{18:[1,304]},{18:$Vo,24:92,41:99,58:93,81:305,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vd1,[2,662]),o($Vl1,$Vm1,{202:33,218:37,192:63,193:71,185:72,153:73,195:74,331:76,154:81,156:82,158:83,353:84,322:85,165:86,166:87,167:88,112:91,24:92,58:93,171:94,355:97,356:98,41:99,288:100,357:101,368:202,59:306,340:307,81:308,18:$Vo,113:$Vc,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,196:$VG,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT}),{23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,341:[1,309],342:148},o($VI1,[2,656],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,263:$Vb1,264:$Vc1}),o($VI1,[2,657],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,263:$Vb1,264:$Vc1}),o($Vr1,[2,658],{342:148,40:$V_,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($Vr1,[2,659],{342:148,40:$V_,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($Vr1,[2,660],{342:148,40:$V_,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($Vp1,[2,843]),o($Vp1,[2,844]),o($Vr1,[2,902],{342:148}),o($Vr1,[2,903],{342:148}),o($Vr1,[2,904],{342:148}),{20:[1,310]},{15:$VY,20:$VX,41:155,58:149,113:$Vc,138:311,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,245:$VM,269:$VQ,288:156,290:150},o($Vd1,[2,645]),o($Vd1,[2,664]),o($Vd1,[2,911]),{18:$Vo,24:92,41:99,58:93,81:312,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vs1,[2,927]),{23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,272:[1,313],342:148},o($Vd1,[2,337]),{20:[1,314],22:$VJ1},o($VK1,[2,342],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($Vh1,[2,768]),o($Vj1,[2,606]),o($Vd1,[2,358]),o($Vd1,[2,359]),o($VL1,[2,855],{384:316,388:317,259:[1,318]}),{204:[2,301]},{20:[1,319],22:$VJ1},{15:[1,320],23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,342:148},o($Vd1,[2,311]),{18:$Vo,20:[1,321],24:92,41:99,58:93,81:248,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,172:322,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{20:[1,323]},o($Vk1,[2,291]),{18:$Vo,24:92,41:99,58:93,81:248,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,172:324,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,81:325,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vk1,[2,297]),o($Vd1,[2,782]),{276:[1,326]},o($Vd1,[2,785]),o($Vu1,[2,503]),o($Vu1,[2,506]),{58:327,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},{20:[1,328]},{20:[2,10],22:[1,329]},{23:[1,330]},o($Vm,[2,69]),{20:[2,824]},{20:[2,826]},{20:[2,828]},{20:[2,830]},{20:[2,832]},{20:[2,834]},{20:[2,836]},{20:[2,838]},o($VM1,[2,112],{84:331,85:332,86:[1,333]}),o($Vw1,[2,84]),{72:[1,334]},o($Vn1,[2,256]),o($Vn1,[2,259],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),{18:$Ve1,38:215,58:191,67:335,92:211,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,339:216,358:210,360:212,362:213,363:214},o($Vx1,[2,802],{91:336,99:$Vy1,100:$Vz1,101:$VA1,102:$VB1,103:$VC1,104:$VD1,105:$VE1,106:$VF1}),{18:$Ve1,38:215,58:191,92:337,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,339:216,362:213,363:214},{100:[1,338]},{100:[1,339],102:[1,340]},{100:[1,341]},o($VN1,[2,137]),{100:[1,343],102:[1,344],103:[1,342],105:[1,345]},{100:[1,346]},{100:[1,348],102:[1,349],103:[1,347],105:[1,350]},{100:[1,351]},o($VG1,[2,805]),o($VG1,[2,806]),o($Vd1,[2,640]),o($Vd1,[2,641]),o($Vd1,[2,642]),{37:[1,352]},o($Vl1,$Vm1,{202:33,218:37,192:63,193:71,185:72,153:73,195:74,331:76,154:81,156:82,158:83,353:84,322:85,165:86,166:87,167:88,112:91,24:92,58:93,171:94,355:97,356:98,41:99,288:100,357:101,368:202,81:308,59:353,340:354,18:$Vo,113:$Vc,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,196:$VG,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT}),{23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,341:[1,355],342:148},{20:[1,356]},{20:[1,357],22:$VO1},o($VP1,[2,752],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),{18:$Vo,24:92,41:99,58:93,81:359,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vu1,[2,820]),{20:[1,360]},{23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,247:[1,361],253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,342:148},{18:$Vo,24:92,41:99,58:93,81:362,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vd1,[2,338]),{18:$Vo,24:92,41:99,58:93,81:363,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{20:[2,861],116:365,117:$VQ1,385:364},o($VL1,[2,856]),{72:[1,367]},{204:[2,302]},{191:368,236:[1,369],237:[1,370],239:[1,371],243:[1,372],244:[1,373],250:[1,374],254:[1,375],270:[1,376],271:[1,377],273:[1,378],274:[1,379],279:[1,380]},o($Vk1,[2,277]),{20:[1,381],22:$VJ1},o($Vk1,[2,290]),{20:[1,382],22:$VJ1},{20:[1,383],23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1,342:148},o($Vd1,[2,786]),o($Vv1,[2,569]),o($V2,[2,9]),{14:272,19:384,21:271,58:53,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh},{24:385,41:99,245:$VM,249:$VO,269:$VQ,275:$VR,288:100,357:101},o($VR1,[2,175],{115:386,116:387,117:$VQ1}),o($VM1,[2,113]),{18:$Vo,24:92,41:99,58:93,81:388,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{18:$Vo,24:92,41:99,58:93,73:389,81:390,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vx1,[2,77]),{18:$Ve1,38:215,58:191,92:391,113:$Vc,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,234:$Vh,339:216,362:213,363:214},o($VS1,$VT1,{93:392,107:$VU1}),o($VN1,[2,133]),o($VN1,[2,134]),{100:[1,394]},o($VN1,[2,136]),{100:[1,395]},o($VN1,[2,139]),{100:[1,396]},{100:[1,397]},o($VN1,[2,142]),{100:[1,398]},o($VN1,[2,144]),{100:[1,399]},{100:[1,400]},o($VN1,[2,147]),{18:$Vo,24:92,41:99,58:93,81:401,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},{20:[1,402]},{20:[1,403],22:$VO1},{18:$Vo,24:92,41:99,58:93,81:404,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($Vd1,[2,652]),o($Vd1,[2,653]),{18:$Vo,24:92,41:99,58:93,81:405,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o([15,20,22,37,71,86,99,100,101,102,103,104,105,106,111,113,117,124,125,148,150,209,213,219,220,221,222,232,234,235,245,246,247,258,262,266,269,272,280,341],[2,655],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,240:$V61,253:$V71,256:$V81,257:$V91,263:$Vb1,264:$Vc1}),o($Vu1,[2,821]),o($Vd1,[2,912]),o($Vs1,[2,933],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($VK1,[2,343],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),{20:[1,406]},{20:[2,866],262:[1,411],266:[1,410],389:407,391:408,392:409},{72:[1,412]},{18:$Vo,24:92,41:99,58:93,81:308,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,340:413,353:84,355:97,356:98,357:101},{20:[1,414]},{20:[2,618]},{20:[2,619]},{18:$VV1,20:$VW1,336:415},{18:[1,418],20:[2,632],337:417},{20:[2,622]},{20:[2,623]},{20:[2,624]},{20:[2,625]},{20:[2,626]},{20:[2,627]},{20:[2,628]},{18:$VV1,20:$VW1,336:419},o($Vk1,[2,278]),o($Vk1,[2,292]),o($Vk1,[2,296]),{20:[2,11]},o($VK1,[2,12]),o($Vl,[2,168],{109:420,110:421,111:[1,422]}),o($VR1,[2,176]),o($VM1,[2,114],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($Vw1,[2,85],{22:[1,423]}),o($VX1,[2,100],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($VS1,$VT1,{93:424,107:$VU1}),o($VS1,[2,120]),{18:$Vo,24:92,41:99,58:93,81:425,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($VN1,[2,135]),o($VN1,[2,138]),o($VN1,[2,140]),o($VN1,[2,141]),o($VN1,[2,143]),o($VN1,[2,145]),o($VN1,[2,146]),o($Vr1,[2,643],{342:148}),o($Vd1,[2,650]),o($Vd1,[2,651]),o($Vq1,[2,654],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,233:$V41,240:$V61,253:$V71,256:$V81,263:$Vb1,264:$Vc1}),o($VP1,[2,753],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($Vd1,[2,850]),{20:[2,862]},{20:[2,867]},{235:[1,426],396:[1,427]},o($VY1,[2,884]),o($VY1,[2,885]),{18:$Vo,24:92,41:99,58:93,81:430,112:91,113:$Vc,118:428,121:429,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($VL1,[2,857],{22:$VO1}),o($Vd1,[2,310]),{20:[2,620]},{276:[1,431]},{20:[2,621]},{276:[1,432]},{20:[2,629]},o($Vl,[2,230]),o($Vl,[2,169]),{112:433,113:[1,434],226:$VJ,276:$VS,277:$VT,355:97,356:98},{18:$Vo,24:92,41:99,58:93,81:435,112:91,113:$Vc,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($VS1,[2,121]),o($VS1,[2,163],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($VZ1,$V_1,{393:436}),o($VZ1,$V_1,{393:437}),o([20,111,148,209,213,262,266],[2,177],{22:[1,438]}),o($V$1,[2,180]),o($V$1,[2,190],{342:148,123:439,23:$VZ,40:$V_,124:[1,440],125:[1,441],139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),{20:[1,442]},{20:[1,443],22:[1,444]},o($Vl,[2,170],{22:[1,445]}),o($Vl,[2,172],{22:[1,446]}),o($VX1,[2,101],{342:148,23:$VZ,40:$V_,139:$V$,225:$V01,227:$V11,228:$V21,232:$V31,233:$V41,235:$V51,240:$V61,253:$V71,256:$V81,257:$V91,258:$Va1,263:$Vb1,264:$Vc1}),o($V02,$V12,{394:447,404:448,241:$V22,276:$V32,396:$V42}),o($V02,$V12,{404:448,394:452,241:$V22,276:$V32,396:$V42}),{18:$Vo,24:92,41:99,58:93,81:430,112:91,113:$Vc,121:453,153:73,154:81,156:82,158:83,165:86,166:87,167:88,171:94,174:$Vq,175:$Vr,176:$Vs,177:$Vt,178:$Vu,179:$Vv,180:$Vw,181:$Vx,182:$Vy,183:$Vz,184:$VA,185:72,186:$VB,187:$VC,188:$VD,189:$VE,190:$VF,192:63,193:71,195:74,196:$VG,202:33,218:37,219:$Vd,220:$Ve,221:$Vf,222:$Vg,224:$VH,225:$VI,226:$VJ,231:$VK,234:$Vh,238:$VL,245:$VM,248:$VN,249:$VO,257:$VP,269:$VQ,275:$VR,276:$VS,277:$VT,288:100,322:85,331:76,353:84,355:97,356:98,357:101},o($V$1,[2,187]),o($V$1,[2,191]),o($V$1,[2,192]),{20:[2,631]},{20:[2,633]},{276:[1,454]},{112:455,226:$VJ,276:$VS,277:$VT,355:97,356:98},{113:[1,456]},{20:$V52,232:$V62,395:457},{260:[1,459]},{265:[1,460]},o($V72,[2,897]),o($V72,[2,898]),{20:$V52,232:$V62,395:461},o($V$1,[2,181]),{20:[1,462]},o($Vl,[2,171]),o($Vl,[2,173]),{20:[2,868]},{241:[1,463],276:$V32,396:$V42,404:464},o($V02,[2,887]),o($V02,[2,888]),{20:[2,869]},{20:[2,634]},{265:[1,465]},{251:[1,466]},{20:[2,892]},{20:[2,893]}],
defaultActions: {20:[2,361],77:[2,306],78:[2,307],79:[2,308],80:[2,309],102:[2,282],103:[2,283],104:[2,284],105:[2,285],106:[2,286],107:[2,287],108:[2,288],109:[2,289],254:[2,301],274:[2,824],275:[2,826],276:[2,828],277:[2,830],278:[2,832],279:[2,834],280:[2,836],281:[2,838],319:[2,302],369:[2,618],370:[2,619],373:[2,622],374:[2,623],375:[2,624],376:[2,625],377:[2,626],378:[2,627],379:[2,628],384:[2,11],407:[2,862],408:[2,867],415:[2,620],417:[2,621],419:[2,629],442:[2,631],443:[2,633],457:[2,868],461:[2,869],462:[2,634],465:[2,892],466:[2,893]},
parseError: function parseError (str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        var error = new Error(str);
        error.hash = hash;
        throw error;
    }
},
parse: function parse (input) {
    var self = this,
        stack = [0],
        tstack = [], // token stack
        vstack = [null], // semantic value stack
        lstack = [], // location stack
        table = this.table,
        yytext = '',
        yylineno = 0,
        yyleng = 0,
        recovering = 0,
        TERROR = 2,
        EOF = 1;

    var args = lstack.slice.call(arguments, 1);

    //this.reductionCount = this.shiftCount = 0;

    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    // copy state
    for (var k in this.yy) {
      if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
        sharedState.yy[k] = this.yy[k];
      }
    }

    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);

    var ranges = lexer.options && lexer.options.ranges;

    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }

    function popStack (n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }

_token_stack:
    var lex = function () {
        var token;
        token = lexer.lex() || EOF;
        // if token isn't its numeric value, convert
        if (typeof token !== 'number') {
            token = self.symbols_[token] || token;
        }
        return token;
    }

    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        // retreive state number from top of stack
        state = stack[stack.length - 1];

        // use default actions if available
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            // read action for current state and first input
            action = table[state] && table[state][symbol];
        }

_handle_error:
        // handle parse error
        if (typeof action === 'undefined' || !action.length || !action[0]) {
            var error_rule_depth;
            var errStr = '';

            // Return the rule stack depth where the nearest error rule can be found.
            // Return FALSE when no error recovery rule was found.
            function locateNearestErrorRecoveryRule(state) {
                var stack_probe = stack.length - 1;
                var depth = 0;

                // try to recover from error
                for(;;) {
                    // check for error recovery rule in this state
                    if ((TERROR.toString()) in table[state]) {
                        return depth;
                    }
                    if (state === 0 || stack_probe < 2) {
                        return false; // No suitable error recovery rule available.
                    }
                    stack_probe -= 2; // popStack(1): [symbol, action]
                    state = stack[stack_probe];
                    ++depth;
                }
            }

            if (!recovering) {
                // first see if there's any chance at hitting an error recovery rule:
                error_rule_depth = locateNearestErrorRecoveryRule(state);

                // Report error
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push("'"+this.terminals_[p]+"'");
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line '+(yylineno+1)+":\n"+lexer.showPosition()+"\nExpecting "+expected.join(', ') + ", got '" + (this.terminals_[symbol] || symbol)+ "'";
                } else {
                    errStr = 'Parse error on line '+(yylineno+1)+": Unexpected " +
                                  (symbol == EOF ? "end of input" :
                                              ("'"+(this.terminals_[symbol] || symbol)+"'"));
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: lexer.yylloc,
                    ruleId: stack.slice(stack.length - 2, stack.length).join('_'),
                    expected: expected,
                    recoverable: (error_rule_depth !== false)
                });
            } else if (preErrorSymbol !== EOF) {
                error_rule_depth = locateNearestErrorRecoveryRule(state);
            }

            // just recovered from another error
            if (recovering == 3) {
                if (symbol === EOF || preErrorSymbol === EOF) {
                    throw new Error(errStr || 'Parsing halted while starting to recover from another error.');
                }

                // discard current lookahead and grab another
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                symbol = lex();
            }

            // try to recover from error
            if (error_rule_depth === false) {
                throw new Error(errStr || 'Parsing halted. No suitable error recovery rule available.');
            }
            popStack(error_rule_depth);

            preErrorSymbol = (symbol == TERROR ? null : symbol); // save the lookahead token
            symbol = TERROR;         // insert generic error symbol as new lookahead
            state = stack[stack.length-1];
            action = table[state] && table[state][TERROR];
            recovering = 3; // allow 3 real symbols to be shifted before reporting a new error
        }

        // this shouldn't happen, unless resolve defaults are off
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: '+state+', token: '+symbol);
        }

        switch (action[0]) {
            case 1: // shift
                //this.shiftCount++;

                stack.push(symbol);
                vstack.push(lexer.yytext);
                lstack.push(lexer.yylloc);
                stack.push(action[1]); // push state
                symbol = null;
                if (!preErrorSymbol) { // normal execution/no error
                    yyleng = lexer.yyleng;
                    yytext = lexer.yytext;
                    yylineno = lexer.yylineno;
                    yyloc = lexer.yylloc;
                    if (recovering > 0) {
                        recovering--;
                    }
                } else {
                    // error just occurred, resume old lookahead f/ before error
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                }
                break;

            case 2:
                // reduce
                //this.reductionCount++;

                len = this.productions_[action[1]][1];

                // perform semantic action
                yyval.$ = vstack[vstack.length-len]; // default to $$ = $1
                // default location, uses first token for firsts, last for lasts
                yyval._$ = {
                    first_line: lstack[lstack.length-(len||1)].first_line,
                    last_line: lstack[lstack.length-1].last_line,
                    first_column: lstack[lstack.length-(len||1)].first_column,
                    last_column: lstack[lstack.length-1].last_column
                };
                if (ranges) {
                  yyval._$.range = [lstack[lstack.length-(len||1)].range[0], lstack[lstack.length-1].range[1]];
                }
                r = this.performAction.apply(yyval, [yytext, yyleng, yylineno, sharedState.yy, action[1], vstack, lstack].concat(args));

                if (typeof r !== 'undefined') {
                    return r;
                }

                // pop off stack
                if (len) {
                    stack = stack.slice(0,-1*len*2);
                    vstack = vstack.slice(0, -1*len);
                    lstack = lstack.slice(0, -1*len);
                }

                stack.push(this.productions_[action[1]][0]);    // push nonterminal (reduce)
                vstack.push(yyval.$);
                lstack.push(yyval._$);
                // goto new state = table[STATE][NONTERMINAL]
                newState = table[stack[stack.length-2]][stack[stack.length-1]];
                stack.push(newState);
                break;

            case 3:
                // accept
                return true;
        }

    }

    return true;
}};


SqlParseSupport.initSyntaxParser(parser);/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function(match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex () {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin (condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState () {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules () {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState (n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState (condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {"case-insensitive":true,"flex":true},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0: /* skip whitespace */ 
break;
case 1: /* skip comments */ 
break;
case 2: /* skip comments */ 
break;
case 3: parser.yy.partialCursor = false; parser.yy.cursorFound = yy_.yylloc; return 5; 
break;
case 4: parser.yy.partialCursor = true; parser.yy.cursorFound = yy_.yylloc; return 282; 
break;
case 5: this.popState(); return 341; 
break;
case 6: return 132; 
break;
case 7: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('ALTER', yy_.yylloc, yy.lexer.upcomingInput()); return 'ALTER'; 
break;
case 8: return 232; 
break;
case 9: return 15; 
break;
case 10: return 124; 
break;
case 11: this.begin('between'); return 235; 
break;
case 12: return 236; 
break;
case 13: return 237; 
break;
case 14: return 72; 
break;
case 15: return 296; 
break;
case 16: return 238; 
break;
case 17: return 239; 
break;
case 18: return 36; 
break;
case 19: return 'COMMENT'; 
break;
case 20: parser.determineCase(yy_.yytext); return 4; 
break;
case 21: return 99; 
break;
case 22: return 241; 
break;
case 23: return 242; 
break;
case 24: return 243; 
break;
case 25: return 125; 
break;
case 26: return 133; 
break;
case 27: return 233; 
break;
case 28: return 244; 
break;
case 29: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('DROP', yy_.yylloc, yy.lexer.upcomingInput()); return 'DROP'; 
break;
case 30: return 246; 
break;
case 31: return 247; 
break;
case 32: parser.yy.correlatedSubQuery = true; return 248; 
break;
case 33: return 249; 
break;
case 34: return 250; 
break;
case 35: return 251; 
break;
case 36: parser.determineCase(yy_.yytext); return 37; 
break;
case 37: return 101; 
break;
case 38: return 71; 
break;
case 39: return 86; 
break;
case 40: return 187; 
break;
case 41: return 253; 
break;
case 42: return 103; 
break;
case 43: return 'INSERT'; 
break;
case 44: return 254; 
break;
case 45: return 255; 
break;
case 46: return 256; 
break;
case 47: return 100; 
break;
case 48: return 104; 
break;
case 49: return 40; 
break;
case 50: return 111; 
break;
case 51: return 257; 
break;
case 52: return 196; 
break;
case 53: return 107; 
break;
case 54: return 220; 
break;
case 55: return 258; 
break;
case 56: return 117; 
break;
case 57: return 102; 
break;
case 58: return 259; 
break;
case 59: return 260; 
break;
case 60: return 261; 
break;
case 61: return 262; 
break;
case 62: return 263; 
break;
case 63: return 106; 
break;
case 64: return 264; 
break;
case 65: return 265; 
break;
case 66: return 219; 
break;
case 67: return 266; 
break;
case 68: return 267; 
break;
case 69: return 39; 
break;
case 70: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SELECT', yy_.yylloc); return 126; 
break;
case 71: return 105; 
break;
case 72: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SET', yy_.yylloc); return 268; 
break;
case 73: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('SHOW', yy_.yylloc); return 35; 
break;
case 74: return 270; 
break;
case 75: return 271; 
break;
case 76: return 13; 
break;
case 77: return 42; 
break;
case 78: return 272; 
break;
case 79: return 273; 
break;
case 80: return 274; 
break;
case 81: return 'TO'; 
break;
case 82: return 275; 
break;
case 83: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('TRUNCATE', yy_.yylloc, yy.lexer.upcomingInput()); return 189; 
break;
case 84: return 396; 
break;
case 85: return 148; 
break;
case 86: parser.determineCase(yy_.yytext); return 'UPDATE'; 
break;
case 87: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('USE', yy_.yylloc); return 'USE'; 
break;
case 88: return 278; 
break;
case 89: return 279; 
break;
case 90: return 31; 
break;
case 91: return 280; 
break;
case 92: return 150; 
break;
case 93: parser.determineCase(yy_.yytext); parser.addStatementTypeLocation('WITH', yy_.yylloc); return 17; 
break;
case 94: return 204; 
break;
case 95: return 219; 
break;
case 96: yy.lexer.unput('('); yy_.yytext = 'avg'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 174; 
break;
case 97: yy.lexer.unput('('); yy_.yytext = 'cast'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 190; 
break;
case 98: yy.lexer.unput('('); yy_.yytext = 'count'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 182; 
break;
case 99: yy.lexer.unput('('); yy_.yytext = 'max'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 175; 
break;
case 100: yy.lexer.unput('('); yy_.yytext = 'min'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 176; 
break;
case 101: yy.lexer.unput('('); yy_.yytext = 'stddev_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 177; 
break;
case 102: yy.lexer.unput('('); yy_.yytext = 'stddev_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 178; 
break;
case 103: yy.lexer.unput('('); yy_.yytext = 'sum'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 183; 
break;
case 104: yy.lexer.unput('('); yy_.yytext = 'var_pop'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 179; 
break;
case 105: yy.lexer.unput('('); yy_.yytext = 'var_samp'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 180; 
break;
case 106: yy.lexer.unput('('); yy_.yytext = 'variance'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 181; 
break;
case 107: yy.lexer.unput('('); yy_.yytext = 'cume_dist'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 108: yy.lexer.unput('('); yy_.yytext = 'dense_rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 109: yy.lexer.unput('('); yy_.yytext = 'first_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 110: yy.lexer.unput('('); yy_.yytext = 'lag'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 111: yy.lexer.unput('('); yy_.yytext = 'last_value'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 112: yy.lexer.unput('('); yy_.yytext = 'lead'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 113: yy.lexer.unput('('); yy_.yytext = 'rank'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 114: yy.lexer.unput('('); yy_.yytext = 'row_number'; parser.addFunctionLocation(yy_.yylloc, yy_.yytext); return 184; 
break;
case 115: return 276; 
break;
case 116: return 276; 
break;
case 117: return 277; 
break;
case 118: return 222; 
break;
case 119: parser.yy.cursorFound = true; return 5; 
break;
case 120: parser.yy.cursorFound = true; return 282; 
break;
case 121: return 252; 
break;
case 122: parser.addFileLocation(yy_.yylloc, yy_.yytext); return 401; 
break;
case 123: this.popState(); return 402; 
break;
case 124: return 209; 
break;
case 125: return 232; 
break;
case 126: return 258; 
break;
case 127: return 23; 
break;
case 128: return 227; 
break;
case 129: return 228; 
break;
case 130: return 240; 
break;
case 131: return 240; 
break;
case 132: return 240; 
break;
case 133: return 240; 
break;
case 134: return 240; 
break;
case 135: return 225; 
break;
case 136: return 139; 
break;
case 137: return 233; 
break;
case 138: return 233; 
break;
case 139: return 233; 
break;
case 140: return 233; 
break;
case 141: return 233; 
break;
case 142: return 233; 
break;
case 143: return 22; 
break;
case 144: return 226; 
break;
case 145: return ':'; 
break;
case 146: return 213; 
break;
case 147: return 231; 
break;
case 148: return 224; 
break;
case 149: return 18; 
break;
case 150: return 20; 
break;
case 151: return 229; 
break;
case 152: return 230; 
break;
case 153: return 113; 
break;
case 154: this.begin('backtickedValue'); return 234; 
break;
case 155:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '`')) {
                                               return 287;
                                             }
                                             return 285;
                                           
break;
case 156: this.popState(); return 234; 
break;
case 157: this.begin('singleQuotedValue'); return 269; 
break;
case 158:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '\'')) {
                                               return 287;
                                             }
                                             return 285;
                                           
break;
case 159: this.popState(); return 269; 
break;
case 160: this.begin('doubleQuotedValue'); return 245; 
break;
case 161:
                                             if (parser.handleQuotedValueWithCursor(this, yy_.yytext, yy_.yylloc, '"')) {
                                               return 287;
                                             }
                                             return 285;
                                           
break;
case 162: this.popState(); return 245; 
break;
case 163: return 209; 
break;
case 164: /* To prevent console logging of unknown chars */ 
break;
case 165: 
break;
case 166: 
break;
case 167: 
break;
case 168: 
break;
case 169: 
break;
case 170:console.log(yy_.yytext);
break;
}
},
rules: [/^(?:\s)/i,/^(?:--.*)/i,/^(?:[/][*][^*]*[*]+([^/*][^*]*[*]+)*[/])/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:AND)/i,/^(?:ALL)/i,/^(?:ALTER)/i,/^(?:AND)/i,/^(?:AS)/i,/^(?:ASC)/i,/^(?:BETWEEN)/i,/^(?:BIGINT)/i,/^(?:BOOLEAN)/i,/^(?:BY)/i,/^(?:CASCADE)/i,/^(?:CASE)/i,/^(?:CHAR)/i,/^(?:COLUMNS)/i,/^(?:COMMENT)/i,/^(?:CREATE)/i,/^(?:CROSS)/i,/^(?:CURRENT)/i,/^(?:DATABASE)/i,/^(?:DECIMAL)/i,/^(?:DESC)/i,/^(?:DISTINCT)/i,/^(?:DIV)/i,/^(?:DOUBLE)/i,/^(?:DROP)/i,/^(?:ELSE)/i,/^(?:END)/i,/^(?:EXISTS)/i,/^(?:FALSE)/i,/^(?:FLOAT)/i,/^(?:FOLLOWING)/i,/^(?:FROM)/i,/^(?:FULL)/i,/^(?:GROUP)/i,/^(?:HAVING)/i,/^(?:IF)/i,/^(?:IN)/i,/^(?:INNER)/i,/^(?:INSERT)/i,/^(?:INT)/i,/^(?:INTO)/i,/^(?:IS)/i,/^(?:JOIN)/i,/^(?:LEFT)/i,/^(?:LIKE)/i,/^(?:LIMIT)/i,/^(?:NOT)/i,/^(?:NULL)/i,/^(?:ON)/i,/^(?:OPTION)/i,/^(?:OR)/i,/^(?:ORDER)/i,/^(?:OUTER)/i,/^(?:PARTITION)/i,/^(?:PRECEDING)/i,/^(?:PURGE)/i,/^(?:RANGE)/i,/^(?:REGEXP)/i,/^(?:RIGHT)/i,/^(?:RLIKE)/i,/^(?:ROW)/i,/^(?:ROLE)/i,/^(?:ROWS)/i,/^(?:SCHEMA)/i,/^(?:SCHEMAS)/i,/^(?:SELECT)/i,/^(?:SEMI)/i,/^(?:SET)/i,/^(?:SHOW)/i,/^(?:SMALLINT)/i,/^(?:STRING)/i,/^(?:TABLE)/i,/^(?:TABLES)/i,/^(?:THEN)/i,/^(?:TIMESTAMP)/i,/^(?:TINYINT)/i,/^(?:TO)/i,/^(?:TRUE)/i,/^(?:TRUNCATE)/i,/^(?:UNBOUNDED)/i,/^(?:UNION)/i,/^(?:UPDATE)/i,/^(?:USE)/i,/^(?:VALUES)/i,/^(?:VARCHAR)/i,/^(?:VIEW)/i,/^(?:WHEN)/i,/^(?:WHERE)/i,/^(?:WITH)/i,/^(?:OVER)/i,/^(?:ROLE)/i,/^(?:AVG\s*\()/i,/^(?:CAST\s*\()/i,/^(?:COUNT\s*\()/i,/^(?:MAX\s*\()/i,/^(?:MIN\s*\()/i,/^(?:STDDEV_POP\s*\()/i,/^(?:STDDEV_SAMP\s*\()/i,/^(?:SUM\s*\()/i,/^(?:VAR_POP\s*\()/i,/^(?:VAR_SAMP\s*\()/i,/^(?:VARIANCE\s*\()/i,/^(?:CUME_DIST\s*\()/i,/^(?:DENSE_RANK\s*\()/i,/^(?:FIRST_VALUE\s*\()/i,/^(?:LAG\s*\()/i,/^(?:LAST_VALUE\s*\()/i,/^(?:LEAD\s*\()/i,/^(?:RANK\s*\()/i,/^(?:ROW_NUMBER\s*\()/i,/^(?:[0-9]+)/i,/^(?:[0-9]+(?:[YSL]|BD)?)/i,/^(?:[0-9]+E)/i,/^(?:[A-Za-z0-9_]+)/i,/^(?:\u2020)/i,/^(?:\u2021)/i,/^(?:\s+['"])/i,/^(?:[^'"\u2020\u2021]+)/i,/^(?:['"])/i,/^(?:$)/i,/^(?:&&)/i,/^(?:\|\|)/i,/^(?:=)/i,/^(?:<)/i,/^(?:>)/i,/^(?:!=)/i,/^(?:<=)/i,/^(?:>=)/i,/^(?:<>)/i,/^(?:<=>)/i,/^(?:-)/i,/^(?:\*)/i,/^(?:\+)/i,/^(?:\/)/i,/^(?:%)/i,/^(?:\|)/i,/^(?:\^)/i,/^(?:&)/i,/^(?:,)/i,/^(?:\.)/i,/^(?::)/i,/^(?:;)/i,/^(?:~)/i,/^(?:!)/i,/^(?:\()/i,/^(?:\))/i,/^(?:\[)/i,/^(?:\])/i,/^(?:\$\{[^}]*\})/i,/^(?:`)/i,/^(?:[^`]+)/i,/^(?:`)/i,/^(?:')/i,/^(?:(?:\\\\|\\[']|[^'])+)/i,/^(?:')/i,/^(?:")/i,/^(?:(?:\\\\|\\["]|[^"])+)/i,/^(?:")/i,/^(?:$)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i,/^(?:.)/i],
conditions: {"hdfs":{"rules":[119,120,121,122,123,124,166],"inclusive":false},"doubleQuotedValue":{"rules":[161,162,169],"inclusive":false},"singleQuotedValue":{"rules":[158,159,168],"inclusive":false},"backtickedValue":{"rules":[155,156,167],"inclusive":false},"between":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,157,160,163,164,165,170],"inclusive":true},"INITIAL":{"rules":[0,1,2,3,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,157,160,163,164,170],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();
export default dasksqlSyntaxParser;
