/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.enterprise.ssl;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFallbackX509TrustManager
implements X509TrustManager {
    final X509TrustManager finalDefaultTm;
    final X509TrustManager finalMyTm;
    private static Logger LOG = LoggerFactory.getLogger(DefaultFallbackX509TrustManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultFallbackX509TrustManager(String trustPath, String trustPassword) throws Exception {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager defaultTm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            defaultTm = (X509TrustManager)tm;
            break;
        }
        this.finalDefaultTm = defaultTm;
        X509TrustManager myTm = null;
        try {
            FileInputStream myKeys = new FileInputStream(trustPath);
            KeyStore myTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            myTrustStore.load(myKeys, trustPassword.toCharArray());
            myKeys.close();
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(myTrustStore);
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                myTm = (X509TrustManager)tm;
                break;
            }
        }
        catch (Exception e) {
            LOG.warn("Error creating Trust Manager for the configured Trust Store. Using default Trust Store location");
            myTm = null;
        }
        finally {
            this.finalMyTm = myTm;
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.finalMyTm == null) {
            return this.finalDefaultTm.getAcceptedIssuers();
        }
        HashSet<X509Certificate> combinedAcceptedIssuers = new HashSet<X509Certificate>(Arrays.asList(this.finalDefaultTm.getAcceptedIssuers()));
        combinedAcceptedIssuers.addAll(Arrays.asList(this.finalMyTm.getAcceptedIssuers()));
        return combinedAcceptedIssuers.toArray(new X509Certificate[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.finalMyTm == null) {
            this.finalDefaultTm.checkServerTrusted(chain, authType);
        } else {
            try {
                this.finalMyTm.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                this.finalDefaultTm.checkServerTrusted(chain, authType);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.finalMyTm == null) {
            this.finalDefaultTm.checkClientTrusted(chain, authType);
        } else {
            try {
                this.finalMyTm.checkClientTrusted(chain, authType);
            }
            catch (CertificateException e) {
                this.finalDefaultTm.checkClientTrusted(chain, authType);
            }
        }
    }
}

