/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.enterprise.crypto;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.crypto.spec.SecretKeySpec;

public class JceksPasswordExtractor {
    private static final String USAGE = "Usage: JceksPasswordExtractor <creds.jceks> <alias>\n";

    @VisibleForTesting
    public static String extract(String keystoreFilename, String keystorePassword, String alias) throws Exception {
        FileInputStream is = new FileInputStream(keystoreFilename);
        KeyStore keyStore = KeyStore.getInstance("jceks");
        keyStore.load(is, keystorePassword.toCharArray());
        SecretKeySpec key = (SecretKeySpec)keyStore.getKey(alias, keystorePassword.toCharArray());
        if (key == null) {
            throw new IllegalArgumentException("Alias " + alias + " not found");
        }
        return new String(key.getEncoded());
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String keystoreFilename = args[0];
        String alias = args[1];
        String keystorePassword = System.getenv("HADOOP_CREDSTORE_PASSWORD");
        if (keystorePassword == null) {
            System.err.println("Error: Password not present");
            System.exit(1);
        }
        String password = "";
        try {
            password = JceksPasswordExtractor.extract(keystoreFilename, keystorePassword, alias);
        }
        catch (Exception e) {
            System.err.println("Error extracting " + alias + " from " + keystoreFilename + ": " + e);
            System.exit(1);
        }
        System.out.print(password);
    }
}

