/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.enterprise.crypto;

import com.cloudera.enterprise.crypto.RandomUtils;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class EncryptUtil {
    private static final int PBKDF2_ROUNDS = 4096;
    private static final int SALT_LENGTH = 16;
    private static final int HMAC_KEY_SIZE = 32;
    private static final int AES_KEY_SIZE = 16;
    private static final int HMAC_SIZE = 32;
    private static final String PBKDF2_ALGO = "PBKDF2WithHmacSHA1";
    private static final String HASH_ALGO = "SHA-256";
    private static final String HMAC_ALGO = "HmacSHA256";
    private static final String CIPHER_ALGO = "AES";
    private static final String CIPHER_SPEC = "AES/CBC/PKCS5Padding";
    private static final byte VERSION_1 = 1;
    private static byte clearByteCtr = (byte)23;
    private static char clearCharCtr = (char)88;

    private static byte[] genSalt() {
        byte[] salt = new byte[16];
        RandomUtils.getBytes(salt);
        return salt;
    }

    private static byte[] genSaltFromString(String saltString) throws GeneralSecurityException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance(HASH_ALGO);
        byte[] sha256 = digest.digest(saltString.getBytes("UTF-8"));
        byte[] salt = new byte[16];
        System.arraycopy(sha256, 0, salt, 0, 16);
        return salt;
    }

    private static byte[] getIV(byte[] salt) {
        byte[] IV = new byte[16];
        for (int i = 0; i < 16; ++i) {
            IV[i] = ~salt[i];
        }
        return IV;
    }

    private static byte[] getKeys(char[] password, byte[] salt) throws GeneralSecurityException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 4096, 768);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGO);
        byte[] key = skf.generateSecret(spec).getEncoded();
        return key;
    }

    public static void cleanse(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = clearByteCtr = (byte)(clearByteCtr ^ bytes[i]);
        }
    }

    public static void cleanse(char[] chars) {
        if (chars == null) {
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = clearCharCtr = (char)(clearCharCtr ^ chars[i]);
        }
    }

    private static byte[] char2byte(char[] chars) {
        byte[] bytes = new byte[chars.length * 2];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i * 2] = (byte)(chars[i] >> 8 & 0xFF);
            bytes[i * 2 + 1] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }

    private static char[] byte2char(byte[] bytes) {
        Preconditions.checkArgument((bytes.length % 2 == 0 ? 1 : 0) != 0);
        char[] chars = new char[bytes.length / 2];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)((bytes[i * 2] & 0xFF) << 8 | bytes[i * 2 + 1] & 0xFF);
        }
        return chars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrypt(char[] password, char[] cleartext) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] salt = EncryptUtil.genSalt();
        try {
            String string = EncryptUtil.encrypt(password, salt, cleartext);
            return string;
        }
        finally {
            EncryptUtil.cleanse(salt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encrypt(char[] password, String saltString, char[] cleartext) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] salt = EncryptUtil.genSaltFromString(saltString);
        try {
            String string = EncryptUtil.encrypt(password, salt, cleartext);
            return string;
        }
        finally {
            EncryptUtil.cleanse(salt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encrypt(char[] password, byte[] salt, char[] cleartext) throws GeneralSecurityException, UnsupportedEncodingException {
        String stringOutput;
        Preconditions.checkNotNull((Object)password);
        Preconditions.checkNotNull((Object)cleartext);
        Preconditions.checkArgument((password.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((cleartext.length > 0 ? 1 : 0) != 0);
        Preconditions.checkState((salt.length == 16 ? 1 : 0) != 0);
        byte[] IV = null;
        byte[] keyBytes = null;
        byte[] clearBytes = null;
        byte[] cipherBytes = null;
        byte[] hmacBytes = null;
        byte[] outputBytes = null;
        try {
            IV = EncryptUtil.getIV(salt);
            keyBytes = EncryptUtil.getKeys(password, salt);
            SecretKeySpec aesKey = new SecretKeySpec(keyBytes, 0, 16, CIPHER_ALGO);
            SecretKeySpec hmacKey = new SecretKeySpec(keyBytes, 16, 32, HMAC_ALGO);
            Cipher cipher = Cipher.getInstance(CIPHER_SPEC);
            cipher.init(1, (Key)aesKey, new IvParameterSpec(IV));
            clearBytes = EncryptUtil.char2byte(cleartext);
            cipherBytes = cipher.doFinal(clearBytes);
            Mac hmac = Mac.getInstance(HMAC_ALGO);
            hmac.init(hmacKey);
            hmacBytes = hmac.doFinal(cipherBytes);
            outputBytes = new byte[4 + salt.length + hmacBytes.length + cipherBytes.length];
            outputBytes[0] = 67;
            outputBytes[1] = 77;
            outputBytes[2] = 69;
            outputBytes[3] = 1;
            System.arraycopy(salt, 0, outputBytes, 4, salt.length);
            System.arraycopy(hmacBytes, 0, outputBytes, 4 + salt.length, hmacBytes.length);
            System.arraycopy(cipherBytes, 0, outputBytes, 4 + salt.length + hmacBytes.length, cipherBytes.length);
            stringOutput = Base64.encodeBase64URLSafeString((byte[])outputBytes);
        }
        catch (Throwable throwable) {
            EncryptUtil.cleanse(IV);
            EncryptUtil.cleanse(keyBytes);
            EncryptUtil.cleanse(clearBytes);
            EncryptUtil.cleanse(cipherBytes);
            EncryptUtil.cleanse(hmacBytes);
            EncryptUtil.cleanse(outputBytes);
            throw throwable;
        }
        EncryptUtil.cleanse(IV);
        EncryptUtil.cleanse(keyBytes);
        EncryptUtil.cleanse(clearBytes);
        EncryptUtil.cleanse(cipherBytes);
        EncryptUtil.cleanse(hmacBytes);
        EncryptUtil.cleanse(outputBytes);
        return stringOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] decrypt(char[] password, String ciphertext) throws GeneralSecurityException {
        Preconditions.checkNotNull((Object)password);
        Preconditions.checkNotNull((Object)ciphertext);
        Preconditions.checkArgument((password.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((!ciphertext.isEmpty() ? 1 : 0) != 0);
        byte[] inputBytes = null;
        byte[] salt = null;
        byte[] hmacBytes = null;
        byte[] cipherBytes = null;
        byte[] IV = null;
        byte[] keyBytes = null;
        byte[] calculatedHmacBytes = null;
        byte[] plainBytes = null;
        char[] plaintext = null;
        try {
            inputBytes = Base64.decodeBase64((String)ciphertext);
            if (inputBytes.length == 0) {
                throw new BadPaddingException("Input ciphertext not base 64");
            }
            if (inputBytes.length < 4) {
                throw new BadPaddingException("Input ciphertext much too short");
            }
            if (inputBytes[0] != 67 || inputBytes[1] != 77 || inputBytes[2] != 69) {
                throw new BadPaddingException("Invalid Ciphertext String");
            }
            if (inputBytes[3] != 1) {
                throw new BadPaddingException("Invalid Ciphertext Version");
            }
            if (inputBytes.length < 52) {
                throw new BadPaddingException("Input ciphertext too short");
            }
            salt = new byte[16];
            hmacBytes = new byte[32];
            cipherBytes = new byte[inputBytes.length - (4 + salt.length + hmacBytes.length)];
            System.arraycopy(inputBytes, 4, salt, 0, salt.length);
            System.arraycopy(inputBytes, 4 + salt.length, hmacBytes, 0, hmacBytes.length);
            System.arraycopy(inputBytes, 4 + salt.length + hmacBytes.length, cipherBytes, 0, cipherBytes.length);
            IV = EncryptUtil.getIV(salt);
            keyBytes = EncryptUtil.getKeys(password, salt);
            SecretKeySpec aesKey = new SecretKeySpec(keyBytes, 0, 16, CIPHER_ALGO);
            SecretKeySpec hmacKey = new SecretKeySpec(keyBytes, 16, 32, HMAC_ALGO);
            Mac hmac = Mac.getInstance(HMAC_ALGO);
            hmac.init(hmacKey);
            calculatedHmacBytes = hmac.doFinal(cipherBytes);
            if (!Arrays.equals(calculatedHmacBytes, hmacBytes)) {
                throw new BadPaddingException("Detected ciphertext tampering");
            }
            Cipher cipher = Cipher.getInstance(CIPHER_SPEC);
            cipher.init(2, (Key)aesKey, new IvParameterSpec(IV));
            plainBytes = cipher.doFinal(cipherBytes);
            plaintext = EncryptUtil.byte2char(plainBytes);
        }
        catch (Throwable throwable) {
            EncryptUtil.cleanse(inputBytes);
            EncryptUtil.cleanse(salt);
            EncryptUtil.cleanse(hmacBytes);
            EncryptUtil.cleanse(cipherBytes);
            EncryptUtil.cleanse(IV);
            EncryptUtil.cleanse(calculatedHmacBytes);
            EncryptUtil.cleanse(keyBytes);
            EncryptUtil.cleanse(plainBytes);
            throw throwable;
        }
        EncryptUtil.cleanse(inputBytes);
        EncryptUtil.cleanse(salt);
        EncryptUtil.cleanse(hmacBytes);
        EncryptUtil.cleanse(cipherBytes);
        EncryptUtil.cleanse(IV);
        EncryptUtil.cleanse(calculatedHmacBytes);
        EncryptUtil.cleanse(keyBytes);
        EncryptUtil.cleanse(plainBytes);
        return plaintext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decryptUsingEnvironment(String ciphertext, String envName) throws GeneralSecurityException {
        if (ciphertext == null || ciphertext.isEmpty() || envName == null || envName.isEmpty()) {
            return ciphertext;
        }
        String encPass = System.getenv(envName);
        if (encPass != null) {
            char[] encPassChars = null;
            char[] decryptedPassword = null;
            try {
                encPassChars = encPass.toCharArray();
                decryptedPassword = EncryptUtil.decrypt(encPassChars, ciphertext);
                ciphertext = new String(decryptedPassword);
            }
            catch (Throwable throwable) {
                EncryptUtil.cleanse(encPassChars);
                EncryptUtil.cleanse(decryptedPassword);
                throw throwable;
            }
            EncryptUtil.cleanse(encPassChars);
            EncryptUtil.cleanse(decryptedPassword);
        }
        return ciphertext;
    }
}

