// Licensed to Cloudera, Inc. under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  Cloudera, Inc. licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

var SqlTestUtils = (function() {

  // Needed to compare by val without taking attr order into account
  var resultEquals = function (a, b) {
    if (typeof a !== typeof b) {
      return false;
    }
    if (a === b) {
      return true;
    }
    if (typeof a === 'object') {
      var aKeys = Object.keys(a);
      if (aKeys.length !== Object.keys(b).length) {
        return false;
      }
      for (var i = 0; i < aKeys.length; i++) {
        if (!resultEquals(a[aKeys[i]], b[aKeys[i]])) {
          return false;
        }
      }
      return true;
    } else {
      return jasmine.matchersUtil.equals(a, b);
    }
  };

  var LOTS_OF_PARSE_RESULTS = [
    {index:0,colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},lowerCase:false},
    {index:1,colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:2,lowerCase:false},
    {index:3,lowerCase:true},
    {index:4,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{cte:"t1"}]}]},commonTableExpressions:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"t1"}],lowerCase:false},
    {index:5,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"bar"}]}]},subQueries:[{columns:[{alias:"i",identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{alias:"n",identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"bar"}],suggestIdentifiers:[{name:"bar.",type:"sub-query"}],lowerCase:true},
    {index:6,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"subQueryThree"}]}]},subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryTwo"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryOne"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"subQueryOne"}],alias:"subQueryTwo"}],alias:"subQueryThree"}],suggestIdentifiers:[{name:"subQueryThree.",type:"sub-query"}],lowerCase:false},
    {index:7,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"subQueryTwo"}]}]},subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryOne"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"subQueryOne"}],alias:"subQueryTwo"}],suggestIdentifiers:[{name:"subQueryTwo.",type:"sub-query"}],lowerCase:false},
    {index:8,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},commonTableExpressions:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"t1"}],lowerCase:false,suggestCommonTableExpressions:[{name:"t1",prependFrom:true,prependQuestionMark:true}]},
    {index:9,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:10,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:true},
    {index:11,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"bar"}]}]},subQueries:[{columns:[{alias:"i",identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{alias:"n",identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"bar"}],suggestIdentifiers:[{name:"bar.",type:"sub-query"}],lowerCase:true},
    {index:12,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"subQueryThree"}]}]},subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryTwo"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryOne"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"subQueryOne"}],alias:"subQueryTwo"}],alias:"subQueryThree"}],suggestIdentifiers:[{name:"subQueryThree.",type:"sub-query"}],lowerCase:false},
    {index:13,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"subQueryTwo"}]}]},subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryOne"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"subQueryOne"}],alias:"subQueryTwo"}],suggestIdentifiers:[{name:"subQueryTwo.",type:"sub-query"}],lowerCase:false},
    {index:14,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},commonTableExpressions:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"t1"}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:47,last_column:48},expected:["')'"],recoverable:true}],lowerCase:false,suggestCommonTableExpressions:[{name:"t1",prependFrom:true,prependQuestionMark:true}]},
    {index:15,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},commonTableExpressions:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"t1"}],lowerCase:false,suggestCommonTableExpressions:[{name:"t1",prependFrom:true,prependQuestionMark:true}]},
    {index:16,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:23,last_column:24},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:17,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:40,last_column:41},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:18,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:19,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:true},
    {index:20,suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:21,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestIdentifiers:[{name:"col.",type:"table"},{name:"tbl2.",type:"table"}],lowerCase:false},
    {index:22,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestIdentifiers:[{name:"tbl1.",type:"table"},{name:"tbl2.",type:"table"}],lowerCase:false},
    {index:23,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:true},
    {index:24,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:25,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:true},
    {index:26,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}],alias:"t"}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"t"}]},suggestIdentifiers:[{name:"t.",type:"alias"},{name:"a.",type:"alias"},{name:"arr_exp",type:"alias"},{name:"i.",type:"alias"},{name:"arr_items",type:"alias"}],lowerCase:false},
    {index:27,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}],alias:"t"}]},suggestAnalyticFunctions:true,suggestKeywords:["*","ALL","DISTINCT","STRAIGHT_JOIN"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"t"}]},suggestIdentifiers:[{name:"t.",type:"alias"},{name:"tm.",type:"alias"}],lowerCase:false},
    {index:28,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}],alias:"ttb"}]},suggestAnalyticFunctions:true,suggestKeywords:["*","ALL","DISTINCT"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{subQuery:"ttaSum"}]},{identifierChain:[{name:"ident_one"}],alias:"ttb"}]},subQueries:[{columns:[{alias:"total",type:"DOUBLE"}],alias:"ttaSum"}],suggestIdentifiers:[{name:"tta.",type:"alias"},{name:"ttaSum.",type:"sub-query"},{name:"ttb.",type:"alias"}],lowerCase:false},
    {index:29,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"tta.",type:"alias"},{name:"testTableB.",type:"table"}],lowerCase:false},
    {index:30,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"tta.",type:"alias"},{name:"testTableB.",type:"table"}],lowerCase:false},
    {index:31,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:32,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"a.",type:"alias"},{name:"arr_exp",type:"alias"},{name:"i.",type:"alias"},{name:"arr_items",type:"alias"}],lowerCase:false},
    {index:33,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestKeywords:["*","ALL","DISTINCT"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:34,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestKeywords:["*","ALL","DISTINCT"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"explodedMap.",type:"alias"},{name:"testMapKey",type:"alias"},{name:"testMapValue",type:"alias"}],lowerCase:false},
    {index:35,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestKeywords:["*","ALL","DISTINCT"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"explodedTable.",type:"alias"},{name:"testItem",type:"alias"}],lowerCase:false},
    {index:36,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestKeywords:["*","ALL","DISTINCT"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"explodedTable.",type:"alias"},{name:"testKey",type:"alias"},{name:"testValue",type:"alias"}],lowerCase:false},
    {index:37,suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:38,suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"AS",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1}],lowerCase:false},
    {index:39,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:40,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestGroupBys:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:41,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestGroupBys:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:42,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestGroupBys:{tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"tta.",type:"alias"},{name:"testTableB.",type:"table"}],lowerCase:false},
    {index:43,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestIdentifiers:[{name:"tta.",type:"alias"},{name:"testTableB.",type:"table"}],lowerCase:false},
    {index:44,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestGroupBys:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:45,suggestColumns:{source:"group by",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestGroupBys:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:46,suggestColumns:{source:"order by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestAnalyticFunctions:true,lowerCase:false},
    {index:47,suggestColumns:{source:"order by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestAnalyticFunctions:true,suggestOrderBys:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:48,suggestColumns:{source:"order by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestAnalyticFunctions:true,lowerCase:false},
    {index:49,suggestColumns:{source:"order by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestAnalyticFunctions:true,suggestOrderBys:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:50,suggestColumns:{source:"order by",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestAnalyticFunctions:true,suggestOrderBys:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:51,suggestColumns:{source:"order by",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestAnalyticFunctions:true,suggestOrderBys:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:52,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"},{name:"ident_four"}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:53,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]}]},lowerCase:false},
    {index:54,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:55,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:56,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestKeywords:[{value:"*",weight:10000}],lowerCase:false},
    {index:57,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},lowerCase:false},
    {index:58,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:["THEN"],lowerCase:false},
    {index:59,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:["WHEN"],lowerCase:false},
    {index:60,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:13,last_column:14},expected:["'<hive>AS'","'AS'","')'"],recoverable:true}],lowerCase:false},
    {index:61,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:18},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'CURSOR'","'<hive>BINARY'","'<hive>DATE'","'<impala>AVRO'","'<impala>KUDU'","'<impala>REAL'","'<impala>PARQUET'","'<impala>RCFILE'","'<impala>SEQUENCEFILE'","'<impala>TEXTFILE'","'BIGINT'","'BOOLEAN'","'CHAR'","'DECIMAL'","'DOUBLE'","'FLOAT'","'INT'","'SMALLINT'","'STRING'","'TIMESTAMP'","'TINYINT'","'VARCHAR'","'WITH'","'('","')'","'BACKTICK'","'SELECT'"],recoverable:true}],lowerCase:false},
    {index:62,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:19},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],lowerCase:false},
    {index:63,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:18,last_column:19},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'='","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'THEN'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:64,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:18,last_column:19},expected:["'END'"],recoverable:true}],lowerCase:false},
    {index:65,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:19,last_column:22},expected:["'<hive>AFTER'","'<hive>CASCADE'","'<hive>COMMENT'","'<hive>FIRST'","'<hive>LOCATION'","'<hive>RESTRICT'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'EOF'","';'","'CURSOR'","'NULL'","'<impala>COMMENT'","'<impala>LOCATION'","'<impala>PRIMARY'","'<impala>...'","'NOT'","'>'","','","')'"],recoverable:true}],lowerCase:false},
    {index:66,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:20,last_column:21},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'='","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'THEN'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:67,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:21,last_column:25},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'NOT'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:68,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:23,last_column:24},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'='","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:69,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:23,last_column:24},expected:["'='","'BETWEEN'","'END'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:70,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:26,last_column:27},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:71,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:30,last_column:31},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:72,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:31,last_column:32},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'='","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:73,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:31,last_column:35},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'NOT'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:74,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:34,last_column:35},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:75,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:35,last_column:38},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:76,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:35,last_column:38},expected:["'='","'BETWEEN'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:77,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:36,last_column:37},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'EOF'","';'","'='","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<hive>ASC'","'<hive>DESC'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>LIMIT'","'<impala>NULLS'","'<impala>.'","'ASC'","'CASE'","'DESC'","'EXISTS'","'FULL'","'IF'","'INNER'","'JOIN'","'LEFT'","'LIKE'","'LIMIT'","'NOT'","'REGEXP'","'RIGHT'","'RLIKE'","'UNION'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","'.'","'~'","'!'","'('","')'","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>SORT'","'<impala>OFFSET'","'<hive>HISTOGRAM_NUMERI'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:78,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:38,last_column:39},expected:["'='","'END'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:79,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:40,last_column:41},expected:["'='","'LIKE'","'NOT'","'ORDER'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'*'","'ARITHMETIC_OPERATOR'","','","')'"],recoverable:true}],lowerCase:false},
    {index:80,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:41,last_column:42},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:81,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:43,last_column:44},expected:["'ORDER'","','","')'"],recoverable:true}],lowerCase:false},
    {index:82,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:44,last_column:45},expected:["'='","'BETWEEN'","'END'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:83,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:84,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"THEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:21,last_column:24},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:85,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"THEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:46,last_column:47},expected:["'='","'BETWEEN'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:86,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"THEN",weight:-1}],lowerCase:false},
    {index:87,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:13,last_column:14},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'='","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'THEN'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:88,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:20},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'END'","'EXISTS'","'IF'","'NOT'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:89,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:21,last_column:22},expected:["'='","'BETWEEN'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:90,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:21,last_column:24},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:91,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:92,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:[{value:"*",weight:10000}],lowerCase:false},
    {index:93,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"testTable"},{name:"testArray",keySet:true},{name:"fieldC"}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:94,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"testTable"},{name:"testArray1"},{name:"item"},{name:"testArray2"},{name:"item"}]}]},lowerCase:false},
    {index:95,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"testTable"},{name:"testFoo",keySet:true},{name:"testBar",keySet:true}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:96,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"testTable"},{name:"testMap",keySet:true},{name:"fieldC"}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:97,suggestColumns:{source:"select",tables:[{identifierChain:[{name:"testTable"},{name:"testMap",keySet:true}]}]},suggestKeywords:["*"],lowerCase:false},
    {index:98,suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"bar"}]}]},suggestKeywords:["*"],subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{alias:"col3alias",type:"NUMBER"}],alias:"bar"}],lowerCase:false},
    {index:99,suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"bar"}]}]},suggestKeywords:["*"],subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"boo"},{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"bar"}],lowerCase:false},
    {index:100,suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"bar"}]}]},suggestKeywords:[{value:"*",weight:10000}],subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{alias:"col3alias",type:"NUMBER"}],alias:"bar"}],lowerCase:false},
    {index:101,suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"bar"}]}]},suggestKeywords:[{value:"*",weight:10000}],subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"boo"},{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"bar"}],lowerCase:false},
    {index:102,suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"s2"}]}]},suggestKeywords:["*"],subQueries:[{columns:[{identifierChain:[{subQuery:"s1"},{name:"a"}],type:"COLREF"},{identifierChain:[{subQuery:"s1"},{name:"bla"}],type:"COLREF"}],subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{alias:"bla",type:"DOUBLE"}],alias:"s1"}],alias:"s2"}],lowerCase:false},
    {index:103,suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"s2"}]}]},suggestKeywords:["*"],subQueries:[{columns:[{identifierChain:[{subQuery:"s1"},{name:"a"}],type:"COLREF"},{identifierChain:[{subQuery:"s1"},{name:"bla"}],type:"COLREF"}],subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"},{alias:"bla",type:"T"}],alias:"s1"}],alias:"s2"}],lowerCase:false},
    {index:104,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]}]},lowerCase:false},
    {index:105,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:106,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bla"},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestIdentifiers:[{name:"bla.",type:"alias"},{name:"bar.",type:"table"}],lowerCase:false},
    {index:107,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bla"},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestIdentifiers:[{name:"bla.",type:"alias"},{name:"bar.",type:"table"}],lowerCase:false},
    {index:108,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bla"}]},suggestFunctions:{},suggestIdentifiers:[{name:"bla.",type:"alias"}],lowerCase:false},
    {index:109,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bla"}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestIdentifiers:[{name:"bla.",type:"alias"}],lowerCase:false},
    {index:110,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},lowerCase:false},
    {index:111,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:112,suggestColumns:{source:"where",tables:[{identifierChain:[{name:"testTable"},{name:"testMap",keySet:true}]}]},lowerCase:false},
    {index:113,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]}]},lowerCase:false},
    {index:114,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:115,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},lowerCase:false},
    {index:116,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:117,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"},{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}],alias:"t4"}]},suggestFunctions:{},suggestIdentifiers:[{name:"t1.",type:"alias"},{name:"table2.",type:"table"},{name:"table3.",type:"table"},{name:"t4.",type:"alias"}],lowerCase:false},
    {index:118,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestJoinConditions:{prependOn:false,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:true},
    {index:119,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestJoinConditions:{prependOn:false,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:true},
    {index:120,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:false},
    {index:121,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestJoinConditions:{prependOn:false,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:false},
    {index:122,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:100,last_column:111},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:false},
    {index:123,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:109,last_column:110},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:false},
    {index:124,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:57,last_column:58},expected:["'='","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:false},
    {index:125,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestJoinConditions:{prependOn:false,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:false},
    {index:126,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:119,last_column:120},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],lowerCase:false},
    {index:127,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:128,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:true},
    {index:129,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},lowerCase:false},
    {index:130,suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestColumnAliases:[{name:"boo",types:["BIGINT"]}],lowerCase:false},
    {index:131,suggestColumns:{types:["ARRAY","MAP"],tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]}]},lowerCase:false},
    {index:132,suggestColumns:{types:["ARRAY","MAP"],tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["ARRAY","MAP"]},lowerCase:false},
    {index:133,suggestColumns:{types:["ARRAY"],tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["ARRAY"]},lowerCase:false},
    {index:134,suggestColumns:{types:["BIGINT"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["BIGINT"]},lowerCase:false},
    {index:135,suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:47,last_column:48},expected:["'ORDER'","','","')'"],recoverable:true}],suggestIdentifiers:[{name:"foo.",type:"table"},{name:"bar.",type:"table"}],lowerCase:true},
    {index:136,suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestIdentifiers:[{name:"foo.",type:"table"},{name:"bar.",type:"table"}],lowerCase:true},
    {index:137,suggestColumns:{types:["COLREF"],tables:[{identifierChain:[{name:"ident_one"}]}]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:81,last_column:82},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],lowerCase:true},
    {index:138,suggestColumns:{types:["COLREF"],tables:[{identifierChain:[{name:"ident_one"}]}]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:true},
    {index:139,suggestColumns:{types:["DECIMAL","DOUBLE"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["DECIMAL","DOUBLE"]},lowerCase:false},
    {index:140,suggestColumns:{types:["DECIMAL"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["DECIMAL"]},lowerCase:false},
    {index:141,suggestColumns:{types:["DOUBLE"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["DOUBLE"]},lowerCase:false},
    {index:142,suggestColumns:{types:["DOUBLE"],source:"where",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:143,suggestColumns:{types:["INT"],source:"select",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:144,suggestColumns:{types:["INT"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["INT"]},lowerCase:false},
    {index:145,suggestColumns:{types:["NUMBER"],source:"group by",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},suggestIdentifiers:[{name:"tta.",type:"alias"},{name:"testTableB.",type:"table"}],lowerCase:false},
    {index:146,suggestColumns:{types:["NUMBER"],source:"order by",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{types:["NUMBER"]},lowerCase:false},
    {index:147,suggestColumns:{types:["NUMBER"],source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"boo"},{identifierChain:[{name:"ident_one"}],alias:"baa"}]},suggestFunctions:{types:["NUMBER"]},suggestIdentifiers:[{name:"boo.",type:"alias"},{name:"baa.",type:"alias"}],lowerCase:false},
    {index:148,suggestColumns:{types:["NUMBER"],source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"boo"},{identifierChain:[{name:"ident_one"}],alias:"baa"}]},suggestFunctions:{types:["NUMBER"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],suggestIdentifiers:[{name:"boo.",type:"alias"},{name:"baa.",type:"alias"}],lowerCase:false},
    {index:149,suggestColumns:{types:["NUMBER"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},lowerCase:false},
    {index:150,suggestColumns:{types:["NUMBER"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:20,last_column:21},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],lowerCase:false},
    {index:151,suggestColumns:{types:["NUMBER"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:152,suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},lowerCase:false},
    {index:153,suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},lowerCase:true},
    {index:154,suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:155,suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:true},
    {index:156,suggestColumns:{types:["STRING"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["STRING"]},lowerCase:false},
    {index:157,suggestColumns:{types:["STRING"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["STRING"]},lowerCase:false},
    {index:158,suggestColumns:{types:["STRING"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["STRING"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:42,last_column:45},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'EXISTS'","'IF'","'NOT'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:159,suggestColumns:{types:["T"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["T"]},lowerCase:false},
    {index:160,suggestColumns:{types:["T"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["T"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:29,last_column:30},expected:["'ORDER'","','","')'"],recoverable:true}],lowerCase:false},
    {index:161,suggestColumns:{types:["T"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["T"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:162,suggestColumns:{types:["T"],source:"select",tables:[{identifierChain:[{subQuery:"boo"}]},{identifierChain:[{subQuery:"bar"}]}]},suggestFunctions:{types:["T"]},subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"boo"},{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"bar"}],suggestIdentifiers:[{name:"boo.",type:"sub-query"},{name:"bar.",type:"sub-query"}],lowerCase:false},
    {index:163,suggestColumns:{types:["T"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:164,suggestColumns:{types:["TIMESTAMP"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["TIMESTAMP"]},lowerCase:false},
    {index:165,suggestDatabases:{appendDot:true},lowerCase:false},
    {index:166,suggestDatabases:{},lowerCase:false},
    {index:167,suggestDatabases:{},suggestKeywords:["EXTENDED"],lowerCase:false},
    {index:168,suggestFunctions:{types:["BIGINT"]},lowerCase:false},
    {index:169,suggestFunctions:{types:["BOOLEAN"]},suggestColumns:{types:["BOOLEAN"],source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bar"}]},suggestIdentifiers:[{name:"bar.",type:"alias"}],lowerCase:false},
    {index:170,suggestFunctions:{types:["INT"]},lowerCase:false},
    {index:171,suggestFunctions:{types:["NUMBER"]},lowerCase:false},
    {index:172,suggestFunctions:{types:["NUMBER"]},suggestColumns:{types:["NUMBER"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:173,suggestFunctions:{types:["NUMBER"]},suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:174,suggestFunctions:{types:["NUMBER"]},suggestKeywords:["VALUES"],lowerCase:false},
    {index:175,suggestFunctions:{types:["STRING"]},lowerCase:false},
    {index:176,suggestFunctions:{types:["STRING"]},suggestColumns:{types:["STRING"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:177,suggestFunctions:{types:["STRING"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:178,suggestFunctions:{},lowerCase:false},
    {index:179,suggestFunctions:{},suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:180,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}],alias:"tt"},{identifierChain:[{subQuery:"bar"}]}]},subQueries:[{columns:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],type:"COLREF"}],alias:"bar"}],suggestIdentifiers:[{name:"tt.",type:"alias"},{name:"bar.",type:"sub-query"}],lowerCase:false},
    {index:181,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},errors:[{text:",",token:",",line:0,loc:{first_line:1,last_line:1,first_column:70,last_column:76},expected:["'EOF'","';'","'<hive>CLUSTER'","'<hive>DISTRIBUTE'","'<hive>LATERAL'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'GROUP'","'HAVING'","'LIMIT'","'ORDER'","'UNION'","'WHERE'","')'","'<hive>GROUP'","'SELECT'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:182,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:183,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:184,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"subQueryOne"}]}]},subQueries:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"subQueryOne"}],suggestIdentifiers:[{name:"subQueryOne.",type:"sub-query"}],lowerCase:false},
    {index:185,suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{subQuery:"subQueryTwo"}]}]},subQueries:[{columns:[{tables:[{identifierChain:[{subQuery:"subQueryOne"}]}]}],subQueries:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"subQueryOne"}],alias:"subQueryTwo"}],suggestIdentifiers:[{name:"subQueryTwo.",type:"sub-query"}],lowerCase:false},
    {index:186,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bar"}]},suggestKeywords:["EXISTS"],suggestIdentifiers:[{name:"bar.",type:"alias"}],lowerCase:false},
    {index:187,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"bar"}]},suggestKeywords:[{value:"EXISTS",weight:-1}],suggestIdentifiers:[{name:"bar.",type:"alias"}],lowerCase:false},
    {index:188,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"},{identifierChain:[{name:"ident_one"}],alias:"t2"}]},suggestKeywords:["EXISTS","NOT EXISTS"],suggestFilters:{tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"},{identifierChain:[{name:"ident_one"}],alias:"t2"}]},suggestIdentifiers:[{name:"t1.",type:"alias"},{name:"t2.",type:"alias"}],lowerCase:false},
    {index:189,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:190,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["EXISTS","NOT EXISTS"],suggestFilters:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:191,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["EXISTS"],lowerCase:false},
    {index:192,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:[{value:"EXISTS",weight:-1},{value:"NOT EXISTS",weight:-1}],suggestFilters:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:193,suggestFunctions:{},suggestColumns:{source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:[{value:"EXISTS",weight:-1}],lowerCase:false},
    {index:194,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},lowerCase:false},
    {index:195,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:196,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestKeywords:["EXISTS","NOT EXISTS"],lowerCase:false},
    {index:197,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestKeywords:[{value:"EXISTS",weight:-1},{value:"NOT EXISTS",weight:-1}],lowerCase:false},
    {index:198,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,errors:[{text:"baa",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:19},expected:["'EOF'","';'","'CURSOR'","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<hive>LATERAL'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'<impala>USING'","'FROM'","'FULL'","'GROUP'","'HAVING'","'INNER'","'JOIN'","'LEFT'","'LIMIT'","'ON'","'ORDER'","'RIGHT'","'UNION'","'WHERE'","','","')'","'<hive>GROUP'","'SELECT'","'TableExpression_ERROR'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:199,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,errors:[{text:"BLARGH",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:13,last_column:18},expected:["'EOF'","';'","'CURSOR'","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<hive>LATERAL'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'<impala>USING'","'FROM'","'FULL'","'GROUP'","'HAVING'","'INNER'","'JOIN'","'LEFT'","'LIMIT'","'ON'","'ORDER'","'RIGHT'","'UNION'","'WHERE'","','","')'","'<hive>GROUP'","'SELECT'","'TableExpression_ERROR'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:200,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,errors:[{text:"SELECT",token:"SELECT",line:0,loc:{first_line:1,last_line:1,first_column:15,last_column:16},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'CURSOR'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'EXISTS'","'IF'","'NOT'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'*'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'PARTIAL_CURSOR'","'<hive>HISTOGRAM_NUMERI'","'Errors'"],recoverable:true}],lowerCase:false},
    {index:201,suggestFunctions:{},suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:202,suggestFunctions:{},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:13,last_column:14},expected:["'<hive>AS'","'AS'","')'"],recoverable:true}],lowerCase:false},
    {index:203,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:204,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:205,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:206,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:207,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestKeywords:[{value:"GROUP BY",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11},{value:"<",weight:2},{value:"<=",weight:2},{value:"<=>",weight:2},{value:"<>",weight:2},{value:"=",weight:2},{value:">",weight:2},{value:">=",weight:2},{value:"BETWEEN",weight:2},{value:"IN",weight:2},{value:"IS NOT NULL",weight:2},{value:"IS NULL",weight:2},{value:"NOT BETWEEN",weight:2},{value:"NOT IN",weight:2}],errors:[{text:"RLIKE",token:"RLIKE",line:0,loc:{first_line:1,last_line:1,first_column:39,last_column:40},expected:["'EOF'","';'","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'FULL'","'GROUP'","'HAVING'","'INNER'","'JOIN'","'LEFT'","'LIMIT'","'ORDER'","'RIGHT'","'UNION'","')'","'<hive>GROUP'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:208,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestKeywords:[{value:"GROUP BY",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11},{value:"<",weight:2},{value:"<=",weight:2},{value:"<=>",weight:2},{value:"<>",weight:2},{value:"=",weight:2},{value:">",weight:2},{value:">=",weight:2},{value:"BETWEEN",weight:2},{value:"IN",weight:2},{value:"IS NOT NULL",weight:2},{value:"IS NULL",weight:2},{value:"NOT BETWEEN",weight:2},{value:"NOT IN",weight:2}],lowerCase:false},
    {index:209,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["GROUP BY","HAVING","ORDER BY","LIMIT","UNION","<","<=","<>","=",">",">=","AND","BETWEEN","IN","IS NOT NULL","IS NULL","NOT BETWEEN","NOT IN","OR"],lowerCase:false},
    {index:210,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["GROUP BY","HAVING","WINDOW","ORDER BY","CLUSTER BY","DISTRIBUTE BY","SORT BY","LIMIT","UNION","<","<=","<=>","<>","=",">",">=","AND","BETWEEN","IN","IS NOT NULL","IS NULL","NOT BETWEEN","NOT IN","OR"],lowerCase:false},
    {index:211,suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:[{value:"GROUP BY",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11},{value:"<",weight:2},{value:"<=",weight:2},{value:"<=>",weight:2},{value:"<>",weight:2},{value:"=",weight:2},{value:">",weight:2},{value:">=",weight:2},{value:"AND",weight:2},{value:"BETWEEN",weight:2},{value:"IN",weight:2},{value:"IS NOT NULL",weight:2},{value:"IS NULL",weight:2},{value:"NOT BETWEEN",weight:2},{value:"NOT IN",weight:2},{value:"OR",weight:2}],lowerCase:false},
    {index:212,suggestHdfs:{path:""},lowerCase:false},
    {index:213,suggestHdfs:{path:"/"},lowerCase:false},
    {index:214,suggestHdfs:{path:"/bla/"},lowerCase:false},
    {index:215,suggestIdentifiers:[{name:"key",type:"alias"},{name:"value",type:"alias"}],lowerCase:false},
    {index:216,suggestIdentifiers:[{name:"pos",type:"alias"},{name:"val",type:"alias"}],lowerCase:false},
    {index:217,suggestIdentifiers:[{name:"t1.",type:"table"},{name:"ta2.",type:"alias"},{name:"t3.",type:"table"}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:104,last_column:105},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:218,suggestIdentifiers:[{name:"testMapKey",type:"alias"},{name:"testMapValue",type:"alias"}],lowerCase:false},
    {index:219,suggestJoinConditions:{prependOn:true,tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"},{identifierChain:[{name:"ident_one"}],alias:"t2"}]},lowerCase:false},
    {index:220,suggestJoinConditions:{prependOn:true,tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"},{identifierChain:[{name:"ident_one"}],alias:"t2"}]},suggestKeywords:["ON","FULL","FULL OUTER","INNER","LEFT","LEFT OUTER","RIGHT","RIGHT OUTER"],lowerCase:false},
    {index:221,suggestJoinConditions:{prependOn:true,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:222,suggestJoinConditions:{prependOn:true,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:223,suggestJoinConditions:{prependOn:true,tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:[{value:"ON",weight:3},{value:"WHERE",weight:2.9},{value:"GROUP BY",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11},{value:"LATERAL VIEW",weight:1.1},{value:"CROSS JOIN",weight:1},{value:"FULL JOIN",weight:1},{value:"FULL OUTER JOIN",weight:1},{value:"JOIN",weight:1},{value:"LEFT JOIN",weight:1},{value:"LEFT OUTER JOIN",weight:1},{value:"LEFT SEMI JOIN",weight:1},{value:"RIGHT JOIN",weight:1},{value:"RIGHT OUTER JOIN",weight:1}],lowerCase:false},
    {index:224,suggestJoins:{prependJoin:false,joinType:"JOIN",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:225,suggestJoins:{prependJoin:false,joinType:"JOIN",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:226,suggestJoins:{prependJoin:false,joinType:"LEFT OUTER JOIN",tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:227,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],alias:"f"}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],alias:"f"}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],alias:"f"}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}],alias:"f"}]},suggestKeywords:["WHERE","GROUP BY","HAVING","WINDOW","ORDER BY","CLUSTER BY","DISTRIBUTE BY","SORT BY","LIMIT","UNION","LATERAL VIEW","CROSS JOIN","FULL JOIN","FULL OUTER JOIN","JOIN","LEFT JOIN","LEFT OUTER JOIN","LEFT SEMI JOIN","RIGHT JOIN","RIGHT OUTER JOIN"],lowerCase:false},
    {index:228,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},lowerCase:false},
    {index:229,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestKeywords:["FULL","FULL OUTER","INNER","LEFT","LEFT ANTI","LEFT OUTER","LEFT SEMI","RIGHT","RIGHT ANTI","RIGHT OUTER","RIGHT SEMI"],lowerCase:false},
    {index:230,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestKeywords:["FULL","FULL OUTER","INNER","LEFT","LEFT OUTER","RIGHT","RIGHT OUTER"],lowerCase:false},
    {index:231,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestKeywords:["LATERAL VIEW","CROSS","FULL","FULL OUTER","LEFT","LEFT OUTER","LEFT SEMI","RIGHT","RIGHT OUTER"],lowerCase:false},
    {index:232,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["AS","WHERE","GROUP BY","HAVING","ORDER BY","LIMIT","OFFSET","UNION","FULL JOIN","FULL OUTER JOIN","INNER JOIN","JOIN","LEFT ANTI JOIN","LEFT JOIN","LEFT OUTER JOIN","LEFT SEMI JOIN","RIGHT ANTI JOIN","RIGHT JOIN","RIGHT OUTER JOIN","RIGHT SEMI JOIN"],lowerCase:false},
    {index:233,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}],alias:"tta"},{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["AS","WHERE","GROUP BY","HAVING","ORDER BY","LIMIT","UNION","FULL JOIN","FULL OUTER JOIN","INNER JOIN","JOIN","LEFT JOIN","LEFT OUTER JOIN","RIGHT JOIN","RIGHT OUTER JOIN"],lowerCase:false},
    {index:234,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:235,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:["AS","WHERE","GROUP BY","HAVING","WINDOW","ORDER BY","CLUSTER BY","DISTRIBUTE BY","SORT BY","LIMIT","UNION","LATERAL VIEW","TABLESAMPLE","CROSS JOIN","FULL JOIN","FULL OUTER JOIN","JOIN","LEFT JOIN","LEFT OUTER JOIN","LEFT SEMI JOIN","RIGHT JOIN","RIGHT OUTER JOIN"],lowerCase:false},
    {index:236,suggestJoins:{prependJoin:true,tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFilters:{prefix:"WHERE",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestGroupBys:{prefix:"GROUP BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestKeywords:[{value:"AS",weight:3.1},{value:"WHERE",weight:2.9},{value:"GROUP BY",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11},{value:"LATERAL VIEW",weight:1.1},{value:"TABLESAMPLE",weight:1.1},{value:"CROSS JOIN",weight:1},{value:"FULL JOIN",weight:1},{value:"FULL OUTER JOIN",weight:1},{value:"JOIN",weight:1},{value:"LEFT JOIN",weight:1},{value:"LEFT OUTER JOIN",weight:1},{value:"LEFT SEMI JOIN",weight:1},{value:"RIGHT JOIN",weight:1},{value:"RIGHT OUTER JOIN",weight:1}],lowerCase:false},
    {index:237,suggestKeyValues:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{},lowerCase:false},
    {index:238,suggestKeywords:["*"],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:239,suggestKeywords:["[BROADCAST]","[SHUFFLE]"],suggestJoins:{prependJoin:false,joinType:"JOIN",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:240,suggestKeywords:["[BROADCAST]","[SHUFFLE]"],suggestJoins:{prependJoin:false,joinType:"LEFT OUTER JOIN",tables:[{identifierChain:[{name:"ident_one"}],alias:"t1"}]},suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:241,suggestKeywords:["ALL","INSERT","ROLE","SELECT"],lowerCase:false},
    {index:242,suggestKeywords:["ALL","NONE"],lowerCase:true},
    {index:243,suggestKeywords:["ALL","TABLE"],suggestTables:{},lowerCase:false},
    {index:244,suggestKeywords:["BY"],suggestGroupBys:{prefix:"BY",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:245,suggestKeywords:["BY"],suggestOrderBys:{prefix:"BY",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:246,suggestKeywords:["COLUMN","PARTITION"],suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:247,suggestKeywords:["COLUMN"],suggestColumns:{tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:248,suggestKeywords:["DATABASE","EXTENDED","FORMATTED","FUNCTION","SCHEMA"],suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:249,suggestKeywords:["DATABASE","EXTENDED","FORMATTED"],suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:250,suggestKeywords:["DATABASE","TABLE"],suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:251,suggestKeywords:["DIRECTORY","LOCAL DIRECTORY","TABLE"],suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:252,suggestKeywords:["EXTENDED","FORMATTED"],suggestDatabases:{},lowerCase:false},
    {index:253,suggestKeywords:["GRANT"],lowerCase:false},
    {index:254,suggestKeywords:["IF EXISTS"],suggestDatabases:{},lowerCase:false},
    {index:255,suggestKeywords:["IF EXISTS"],suggestTables:{onlyTables:true},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:256,suggestKeywords:["IF EXISTS"],suggestTables:{onlyViews:true},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:257,suggestKeywords:["IF NOT EXISTS"],suggestDatabases:{appendDot:true},lowerCase:false},
    {index:258,suggestKeywords:["INSERT INTO","INSERT OVERWRITE","SELECT"],lowerCase:true},
    {index:259,suggestKeywords:["PARTITION","[NOSHUFFLE]","[SHUFFLE]","SELECT","VALUES"],commonTableExpressions:[{columns:[{type:"NUMBER"}],alias:"t1"},{columns:[{type:"NUMBER"}],alias:"t2"}],lowerCase:false},
    {index:260,suggestKeywords:["PARTITION","[NOSHUFFLE]","[SHUFFLE]","SELECT","VALUES"],lowerCase:false},
    {index:261,suggestKeywords:["TABLE"],suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:262,suggestKeywords:[{value:"*",weight:10000}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:263,suggestKeywords:[{value:"*",weight:10000}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:264,suggestKeywords:[{value:"*",weight:1000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAggregateFunctions:{tables:[{identifierChain:[{name:"ident_one"}]}]},suggestAnalyticFunctions:true,lowerCase:false},
    {index:265,suggestKeywords:[{value:"*",weight:1000}],suggestFunctions:{},suggestColumns:{source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:266,suggestKeywords:[{value:"-",weight:-1},{value:"*",weight:-1},{value:"/",weight:-1},{value:"%",weight:-1},{value:"+",weight:-1},{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"AS",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"LIKE",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"NOT LIKE",weight:-1},{value:"OVER",weight:-1},{value:"REGEX",weight:-1},{value:"RLIKE",weight:-1}],suggestTables:{prependFrom:true},suggestDatabases:{prependFrom:true,appendDot:true},lowerCase:false},
    {index:267,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"AND",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"OR",weight:-1},{value:"THEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:24,last_column:25},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'NOT'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:268,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"AND",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"OR",weight:-1},{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:19,last_column:20},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'NOT'","'THEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:269,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"AS",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"AND",weight:-1},{value:"OR",weight:-1},{value:"+",weight:-1},{value:"-",weight:-1},{value:"*",weight:-1},{value:"/",weight:-1},{value:"%",weight:-1},{value:"LIKE",weight:-1},{value:"NOT LIKE",weight:-1},{value:"REGEX",weight:-1},{value:"RLIKE",weight:-1}],suggestTables:{prependFrom:true},suggestDatabases:{prependFrom:true,appendDot:true},lowerCase:false},
    {index:270,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"END",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1}],suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:271,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"AND",weight:-1},{value:"OR",weight:-1},{value:"+",weight:-1},{value:"-",weight:-1},{value:"*",weight:-1},{value:"/",weight:-1},{value:"%",weight:-1},{value:"LIKE",weight:-1},{value:"NOT LIKE",weight:-1},{value:"REGEX",weight:-1},{value:"RLIKE",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:18,last_column:19},expected:["','","')'"],recoverable:true}],lowerCase:false},
    {index:272,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"THEN",weight:-1}],suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:29,last_column:30},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:273,suggestKeywords:[{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"WHEN",weight:-1}],suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:274,suggestKeywords:[{value:"=",weight:-1}],lowerCase:false},
    {index:275,suggestKeywords:[{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1},{value:"SELECT",weight:-1}],lowerCase:false},
    {index:276,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"*",token:"*",line:0,loc:{first_line:1,last_line:1,first_column:1,last_column:2},expected:["'<hive>PURGE'","'EOF'","';'","'='","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<hive>LATERAL'","'<hive>PARTITION'","'<hive>ASC'","'<hive>DESC'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'ASC'","'DESC'","'FROM'","'FULL'","'GROUP'","'HAVING'","'INNER'","'JOIN'","'LEFT'","'LIMIT'","'ORDER'","'PARTITION'","'RIGHT'","'UNION'","'WHERE'","'>'","','","')'","'<hive>GROUP'","'SELECT'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:277,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:";",token:";",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:3},expected:[],recoverable:true}],lowerCase:false},
    {index:278,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:";",token:";",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:4},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'CURSOR'","'('","'BACKTICK'"],recoverable:true}],lowerCase:false},
    {index:279,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"bla",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:3},expected:[],recoverable:true},{text:"blaa",token:"REGULAR_IDENTIFIER",line:1,loc:{first_line:2,last_line:2,first_column:4,last_column:13},expected:[],recoverable:true}],lowerCase:false},
    {index:280,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"bla",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:3},expected:[],recoverable:true}],lowerCase:false},
    {index:281,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"bla",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:4},expected:[],recoverable:true}],lowerCase:false},
    {index:282,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"LIMIT",token:"LIMIT",line:0,loc:{first_line:1,last_line:1,first_column:5,last_column:11},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ALL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'ALL'","'CASE'","'DISTINCT'","'EXISTS'","'IF'","'NOT'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'*'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'","'Errors'"],recoverable:true}],lowerCase:false},
    {index:283,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"SELECT",token:"SELECT",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:4},expected:[],recoverable:true},{text:";",token:";",line:0,loc:{first_line:1,last_line:1,first_column:28,last_column:33},expected:[],recoverable:true}],lowerCase:false},
    {index:284,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"SELECT",token:"SELECT",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:4},expected:[],recoverable:true}],lowerCase:false},
    {index:285,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],errors:[{text:"USE",token:"<hive>USE",line:0,loc:{first_line:1,last_line:1,first_column:0,last_column:4},expected:[],recoverable:true}],lowerCase:false},
    {index:286,suggestKeywords:[{value:"ALTER",weight:-1},{value:"ANALYZE TABLE",weight:-1},{value:"CREATE",weight:-1},{value:"DELETE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"EXPLAIN",weight:-1},{value:"EXPORT",weight:-1},{value:"FROM",weight:-1},{value:"GRANT",weight:-1},{value:"IMPORT",weight:-1},{value:"INSERT",weight:-1},{value:"LOAD",weight:-1},{value:"MSCK",weight:-1},{value:"RELOAD FUNCTION",weight:-1},{value:"RESET",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],lowerCase:true},
    {index:287,suggestKeywords:[{value:"ALTER",weight:-1},{value:"CREATE",weight:-1},{value:"DESCRIBE",weight:-1},{value:"DROP",weight:-1},{value:"GRANT",weight:-1},{value:"INSERT",weight:-1},{value:"REVOKE",weight:-1},{value:"SELECT",weight:-1},{value:"SET",weight:-1},{value:"SHOW",weight:-1},{value:"TRUNCATE",weight:-1},{value:"UPDATE",weight:-1},{value:"USE",weight:-1},{value:"WITH",weight:-1}],lowerCase:true},
    {index:288,suggestKeywords:[{value:"AND",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:78,last_column:79},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:289,suggestKeywords:[{value:"AND",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:86,last_column:87},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:290,suggestKeywords:[{value:"ARRAY<>",weight:-1},{value:"BIGINT",weight:-1},{value:"BINARY",weight:-1},{value:"BOOLEAN",weight:-1},{value:"CHAR",weight:-1},{value:"DATE",weight:-1},{value:"DECIMAL",weight:-1},{value:"DOUBLE",weight:-1},{value:"FLOAT",weight:-1},{value:"INT",weight:-1},{value:"MAP<>",weight:-1},{value:"SMALLINT",weight:-1},{value:"STRING",weight:-1},{value:"STRUCT<>",weight:-1},{value:"TIMESTAMP",weight:-1},{value:"TINYINT",weight:-1},{value:"UNIONTYPE<>",weight:-1},{value:"VARCHAR",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:22,last_column:23},expected:["','","')'"],recoverable:true}],lowerCase:false},
    {index:291,suggestKeywords:[{value:"ARRAY<>",weight:-1},{value:"BIGINT",weight:-1},{value:"BINARY",weight:-1},{value:"BOOLEAN",weight:-1},{value:"CHAR",weight:-1},{value:"DATE",weight:-1},{value:"DECIMAL",weight:-1},{value:"DOUBLE",weight:-1},{value:"FLOAT",weight:-1},{value:"INT",weight:-1},{value:"MAP<>",weight:-1},{value:"SMALLINT",weight:-1},{value:"STRING",weight:-1},{value:"STRUCT<>",weight:-1},{value:"TIMESTAMP",weight:-1},{value:"TINYINT",weight:-1},{value:"UNIONTYPE<>",weight:-1},{value:"VARCHAR",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:43,last_column:44},expected:["','","')'"],recoverable:true}],lowerCase:false},
    {index:292,suggestKeywords:[{value:"AS",weight:2},{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"AND",weight:-1},{value:"OR",weight:-1},{value:"+",weight:-1},{value:"-",weight:-1},{value:"*",weight:-1},{value:"/",weight:-1},{value:"%",weight:-1},{value:"LIKE",weight:-1},{value:"NOT LIKE",weight:-1},{value:"REGEX",weight:-1},{value:"RLIKE",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:17,last_column:18},expected:["'<hive>STRING'","'<hive>TINYINT'","'<hive>BINARY'","'<hive>DATE'","'<impala>REAL'","'BIGINT'","'BOOLEAN'","'CHAR'","'DECIMAL'","'DOUBLE'","'FLOAT'","'INT'","'SMALLINT'","'STRING'","'TIMESTAMP'","'TINYINT'","'VARCHAR'","')'"],recoverable:true}],lowerCase:false},
    {index:293,suggestKeywords:[{value:"AS",weight:2},{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1}],suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:17,last_column:18},expected:["'<hive>STRING'","'<hive>TINYINT'","'<hive>BINARY'","'<hive>DATE'","'<impala>REAL'","'BIGINT'","'BOOLEAN'","'CHAR'","'DECIMAL'","'DOUBLE'","'FLOAT'","'INT'","'SMALLINT'","'STRING'","'TIMESTAMP'","'TINYINT'","'VARCHAR'","')'"],recoverable:true}],lowerCase:false},
    {index:294,suggestKeywords:[{value:"ASC",weight:2.5},{value:"DESC",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11}],errors:[{text:",",token:",",line:0,loc:{first_line:1,last_line:1,first_column:61,last_column:62},expected:["'EOF'","';'","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<impala>LIMIT'","'FULL'","'INNER'","'JOIN'","'LEFT'","'LIMIT'","'RIGHT'","'UNION'","')'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:295,suggestKeywords:[{value:"ASC",weight:2},{value:"DESC",weight:2},{value:"RANGE BETWEEN",weight:1},{value:"ROWS BETWEEN",weight:1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:53,last_column:54},expected:["'RANGE'","'ROWS'","')'"],recoverable:true}],lowerCase:false},
    {index:296,suggestKeywords:[{value:"BETWEEN",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:58,last_column:59},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:297,suggestKeywords:[{value:"BIGINT",weight:-1},{value:"BINARY",weight:-1},{value:"BOOLEAN",weight:-1},{value:"CHAR",weight:-1},{value:"DATE",weight:-1},{value:"DECIMAL",weight:-1},{value:"DOUBLE",weight:-1},{value:"FLOAT",weight:-1},{value:"INT",weight:-1},{value:"SMALLINT",weight:-1},{value:"STRING",weight:-1},{value:"TIMESTAMP",weight:-1},{value:"TINYINT",weight:-1},{value:"VARCHAR",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:17},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:298,suggestKeywords:[{value:"BIGINT",weight:-1},{value:"BINARY",weight:-1},{value:"BOOLEAN",weight:-1},{value:"CHAR",weight:-1},{value:"DATE",weight:-1},{value:"DECIMAL",weight:-1},{value:"DOUBLE",weight:-1},{value:"FLOAT",weight:-1},{value:"INT",weight:-1},{value:"SMALLINT",weight:-1},{value:"STRING",weight:-1},{value:"TIMESTAMP",weight:-1},{value:"TINYINT",weight:-1},{value:"VARCHAR",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:20,last_column:21},expected:["')'"],recoverable:true}],lowerCase:true},
    {index:299,suggestKeywords:[{value:"BIGINT",weight:-1},{value:"BINARY",weight:-1},{value:"BOOLEAN",weight:-1},{value:"CHAR",weight:-1},{value:"DATE",weight:-1},{value:"DECIMAL",weight:-1},{value:"DOUBLE",weight:-1},{value:"FLOAT",weight:-1},{value:"INT",weight:-1},{value:"SMALLINT",weight:-1},{value:"STRING",weight:-1},{value:"TIMESTAMP",weight:-1},{value:"TINYINT",weight:-1},{value:"VARCHAR",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:20,last_column:21},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:300,suggestKeywords:[{value:"BY",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:37,last_column:38},expected:["'ORDER'","')'"],recoverable:true}],lowerCase:false},
    {index:301,suggestKeywords:[{value:"BY",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:51,last_column:52},expected:["'EOF'","';'","'<hive>CLUSTER'","'<hive>CROSS'","'<hive>DISTRIBUTE'","'<impala>LIMIT'","'FULL'","'INNER'","'JOIN'","'LEFT'","'LIMIT'","'RIGHT'","'UNION'","')'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:302,suggestKeywords:[{value:"BY",weight:-1}],suggestGroupBys:{prefix:"BY",tables:[{identifierChain:[{name:"ident_one"}]}]},errors:[{text:"baaa",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:30,last_column:33},expected:["'EOF'","';'","'CURSOR'","'='","'<hive>CLUSTER'","'<hive>DISTRIBUTE'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'BETWEEN'","'GROUP'","'HAVING'","'IN'","'IS'","'LIKE'","'LIMIT'","'NOT'","'ORDER'","'REGEXP'","'RLIKE'","'UNION'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'","'<hive>GROUP'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:303,suggestKeywords:[{value:"BY",weight:-1}],suggestGroupBys:{prefix:"BY",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:304,suggestKeywords:[{value:"BY",weight:-1}],suggestOrderBys:{prefix:"BY",tables:[{identifierChain:[{name:"ident_one"}]}]},errors:[{text:"baaa",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:30,last_column:33},expected:["'EOF'","';'","'CURSOR'","'='","'<hive>CLUSTER'","'<hive>DISTRIBUTE'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'BETWEEN'","'GROUP'","'HAVING'","'IN'","'IS'","'LIKE'","'LIMIT'","'NOT'","'ORDER'","'REGEXP'","'RLIKE'","'UNION'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'","'<hive>GROUP'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:305,suggestKeywords:[{value:"BY",weight:-1}],suggestOrderBys:{prefix:"BY",tables:[{identifierChain:[{name:"ident_one"}]}]},lowerCase:false},
    {index:306,suggestKeywords:[{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11}],errors:[{text:"bla",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:33,last_column:36},expected:["'EOF'","';'","'CURSOR'","'='","'<hive>CLUSTER'","'<hive>DISTRIBUTE'","'<hive>ASC'","'<hive>DESC'","'<impala>LIMIT'","'<impala>NULLS'","'ASC'","'BETWEEN'","'DESC'","'IN'","'IS'","'LIKE'","'LIMIT'","'NOT'","'RANGE'","'REGEXP'","'RLIKE'","'ROWS'","'UNION'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","','","')'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:307,suggestKeywords:[{value:"CURRENT ROW",weight:-1},{value:"UNBOUNDED FOLLOWING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:82,last_column:83},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:308,suggestKeywords:[{value:"CURRENT ROW",weight:-1},{value:"UNBOUNDED FOLLOWING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:90,last_column:91},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:309,suggestKeywords:[{value:"CURRENT ROW",weight:-1},{value:"UNBOUNDED PRECEDING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:66,last_column:67},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:310,suggestKeywords:[{value:"END",weight:3},{value:"ELSE",weight:2},{value:"WHEN",weight:1},{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"AND",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1},{value:"OR",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:42,last_column:45},expected:["'='","'BETWEEN'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'THEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:311,suggestKeywords:[{value:"END",weight:3},{value:"ELSE",weight:2},{value:"WHEN",weight:1},{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1}],suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:29,last_column:30},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'END'","'EXISTS'","'IF'","'NOT'","'THEN'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:312,suggestKeywords:[{value:"END",weight:3},{value:"ELSE",weight:2},{value:"WHEN",weight:1},{value:"<",weight:-1},{value:"<=",weight:-1},{value:"<=>",weight:-1},{value:"<>",weight:-1},{value:"=",weight:-1},{value:">",weight:-1},{value:">=",weight:-1},{value:"BETWEEN",weight:-1},{value:"IN",weight:-1},{value:"IS NOT NULL",weight:-1},{value:"IS NULL",weight:-1},{value:"NOT BETWEEN",weight:-1},{value:"NOT IN",weight:-1}],suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:33,last_column:34},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'END'","'EXISTS'","'IF'","'NOT'","'THEN'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:313,suggestKeywords:[{value:"FOLLOWING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:100,last_column:101},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:314,suggestKeywords:[{value:"FOLLOWING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:84,last_column:85},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:315,suggestKeywords:[{value:"GROUP BY",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"LIMIT",weight:2.3},{value:"UNION",weight:2.11}],errors:[{text:"baaa",token:"REGULAR_IDENTIFIER",line:0,loc:{first_line:1,last_line:1,first_column:30,last_column:33},expected:["'EOF'","';'","'CURSOR'","'='","'<hive>CLUSTER'","'<hive>DISTRIBUTE'","'<hive>WINDOW'","'<impala>GROUP'","'<impala>LIMIT'","'BETWEEN'","'GROUP'","'HAVING'","'IN'","'IS'","'LIKE'","'LIMIT'","'NOT'","'ORDER'","'REGEXP'","'RLIKE'","'UNION'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'","'<hive>GROUP'","'<hive>SORT'","'<impala>OFFSET'","'<hive>INSERT'"],recoverable:true}],lowerCase:false},
    {index:316,suggestKeywords:[{value:"IF EXISTS",weight:-1}],suggestDatabases:{},lowerCase:false},
    {index:317,suggestKeywords:[{value:"IF EXISTS",weight:-1}],suggestTables:{onlyTables:true},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:318,suggestKeywords:[{value:"IF EXISTS",weight:-1}],suggestTables:{onlyViews:true},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:319,suggestKeywords:[{value:"IF NOT EXISTS",weight:-1}],suggestDatabases:{appendDot:true},lowerCase:false},
    {index:320,suggestKeywords:[{value:"PARTITION BY",weight:2},{value:"ORDER BY",weight:1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:28,last_column:29},expected:["'<hive>PARTITION'","'ORDER'","'PARTITION'","')'"],recoverable:true}],lowerCase:false},
    {index:321,suggestKeywords:[{value:"PRECEDING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:68,last_column:69},expected:["'AND'","')'"],recoverable:true}],lowerCase:false},
    {index:322,suggestKeywords:[{value:"PRECEDING",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:76,last_column:77},expected:["'AND'","')'"],recoverable:true}],lowerCase:false},
    {index:323,suggestKeywords:[{value:"ROW",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:74,last_column:75},expected:["'AND'","')'"],recoverable:true}],lowerCase:false},
    {index:324,suggestKeywords:[{value:"ROW",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:90,last_column:91},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:325,suggestKeywords:[{value:"SELECT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:13,last_column:14},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:326,suggestKeywords:[{value:"SELECT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:17},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:327,suggestKeywords:[{value:"SELECT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:16,last_column:17},expected:["')'"],recoverable:true}],lowerCase:true},
    {index:328,suggestKeywords:[{value:"SELECT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:48,last_column:49},expected:["')'"],recoverable:true}],lowerCase:false},
    {index:329,suggestKeywords:[{value:"SELECT",weight:-1}],lowerCase:true},
    {index:330,suggestKeywords:[{value:"TABLE",weight:-1}],suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:331,suggestKeywords:[{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:22,last_column:26},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'ELSE'","'END'","'EXISTS'","'IF'","'NOT'","'WHEN'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:332,suggestKeywords:[{value:"WHEN",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:27,last_column:30},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'IS'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:333,suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},lowerCase:false},
    {index:334,suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:335,suggestOrderBys:{prefix:"ORDER BY",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestColRefKeywords:{BOOLEAN:["AND","OR"],NUMBER:["+","-","*","/","%"],STRING:["LIKE","NOT LIKE","REGEX","RLIKE"]},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestKeywords:[{value:"GROUPING SETS",weight:2.8},{value:"WITH CUBE",weight:2.8},{value:"WITH ROLLUP",weight:2.8},{value:"HAVING",weight:2.7},{value:"WINDOW",weight:2.6},{value:"ORDER BY",weight:2.5},{value:"CLUSTER BY",weight:2.4},{value:"DISTRIBUTE BY",weight:2.4},{value:"SORT BY",weight:2.4},{value:"<",weight:2},{value:"<=",weight:2},{value:"<=>",weight:2},{value:"<>",weight:2},{value:"=",weight:2},{value:">",weight:2},{value:">=",weight:2},{value:"BETWEEN",weight:2},{value:"GROUPING SETS",weight:2},{value:"IN",weight:2},{value:"IS NOT NULL",weight:2},{value:"IS NULL",weight:2},{value:"NOT BETWEEN",weight:2},{value:"NOT IN",weight:2},{value:"WITH CUBE",weight:2},{value:"WITH ROLLUP",weight:2}],lowerCase:false},
    {index:336,suggestTables:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"},{name:"ident_four"}]},lowerCase:false},
    {index:337,suggestTables:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:338,suggestTables:{identifierChain:[{name:"ident_one"}],onlyTables:true},lowerCase:false},
    {index:339,suggestTables:{identifierChain:[{name:"ident_one"}],onlyViews:true},lowerCase:false},
    {index:340,suggestTables:{identifierChain:[{name:"ident_one"}]},lowerCase:false},
    {index:341,suggestTables:{identifierChain:[{name:"ident_one"}]},lowerCase:true},
    {index:342,suggestTables:{onlyTables:true},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:343,suggestTables:{onlyViews:true},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:344,suggestTables:{prependFrom:true},suggestDatabases:{prependFrom:true,appendDot:true},lowerCase:false},
    {index:345,suggestTables:{},lowerCase:false},
    {index:346,suggestTables:{},suggestDatabases:{appendDot:true},commonTableExpressions:[{columns:[{tables:[{identifierChain:[{name:"ident_one"}]}]}],alias:"t1"}],lowerCase:false,suggestCommonTableExpressions:[{name:"t1"}]},
    {index:347,suggestTables:{},suggestDatabases:{appendDot:true},commonTableExpressions:[{columns:[{type:"NUMBER"}],alias:"t1"},{columns:[{type:"NUMBER"}],alias:"t2"}],lowerCase:false,suggestCommonTableExpressions:[{name:"t1"},{name:"t2"}]},
    {index:348,suggestTables:{},suggestDatabases:{appendDot:true},commonTableExpressions:[{columns:[{type:"NUMBER"}],alias:"t1"},{columns:[{type:"NUMBER"}],alias:"t2"}],lowerCase:true,suggestCommonTableExpressions:[{name:"t1"},{name:"t2"}]},
    {index:349,suggestTables:{},suggestDatabases:{appendDot:true},lowerCase:false},
    {index:350,suggestTables:{},suggestDatabases:{appendDot:true},suggestKeywords:["DATABASE","SCHEMA"],lowerCase:false},
    {index:351,suggestTables:{},suggestDatabases:{appendDot:true},suggestKeywords:["PARQUET"],lowerCase:false},
    {index:352,suggestTables:{},suggestDatabases:{prependDot:true},lowerCase:false},
    {index:353,suggestValues:{partialQuote:"",missingEndQuote:false},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:354,suggestValues:{partialQuote:"",missingEndQuote:true},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:355,suggestValues:{partialQuote:"'",missingEndQuote:false},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:356,suggestValues:{partialQuote:"'",missingEndQuote:true},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:357,suggestValues:{partialQuote:"\\",missingEndQuote:false},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:358,suggestValues:{partialQuote:"\\",missingEndQuote:true},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},lowerCase:false},
    {index:359,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"t"}]},suggestFunctions:{types:["COLREF"]},suggestIdentifiers:[{name:"t.",type:"alias"},{name:"m.",type:"alias"}],lowerCase:false},
    {index:360,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}],alias:"t"}]},suggestFunctions:{types:["COLREF"]},suggestIdentifiers:[{name:"t.",type:"alias"},{name:"tm.",type:"alias"}],lowerCase:false},
    {index:361,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},suggestColumns:{types:["COLREF"],tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{types:["COLREF"]},lowerCase:false},
    {index:362,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"},{name:"ident_three"}]},suggestColumns:{types:["COLREF"],tables:[{identifierChain:[{name:"ident_one"},{name:"ident_two"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:363,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},lowerCase:false},
    {index:364,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:22,last_column:23},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'THEN'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:365,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:23,last_column:24},expected:["'='","'BETWEEN'","'ELSE'","'END'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'THEN'","'WHEN'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'"],recoverable:true}],lowerCase:false},
    {index:366,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"FROM",token:"FROM",line:0,loc:{first_line:1,last_line:1,first_column:34,last_column:38},expected:["'<hive>ADD'","'<hive>ADMIN'","'<hive>AFTER'","'<hive>ANALYZE'","'<hive>ARCHIVE'","'<hive>AVRO'","'<hive>BUCKET'","'<hive>BUCKETS'","'<hive>CACHE'","'<hive>CASCADE'","'<hive>CHANGE'","'<hive>CLUSTERED'","'<hive>COLLECTION'","'<hive>COLUMNS'","'<hive>COMMENT'","'<hive>COMPACT'","'<hive>COMPACTIONS'","'<hive>COMPUTE'","'<hive>CONCATENATE'","'<hive>DATA'","'<hive>DATABASES'","'<hive>DEFERRED'","'<hive>DEFINED'","'<hive>DELIMITED'","'<hive>DEPENDENCY'","'<hive>DIRECTORY'","'<hive>DISABLE'","'<hive>ENABLE'","'<hive>ESCAPED'","'<hive>EXCHANGE'","'<hive>EXPLAIN'","'<hive>EXPORT'","'<hive>FIELDS'","'<hive>FILE'","'<hive>FILEFORMAT'","'<hive>FIRST'","'<hive>FORMAT'","'<hive>FUNCTIONS'","'<hive>INPATH'","'<hive>INPUTFORMAT'","'<hive>JAR'","'<hive>IDXPROPERTIES'","'<hive>ITEMS'","'<hive>KEYS'","'<hive>LINES'","'<hive>LOAD'","'<hive>LOCATION'","'<hive>LOCKS'","'<hive>METADATA'","'<hive>MSCK'","'<hive>NOSCAN'","'<hive>NO_DROP'","'<hive>OFFLINE'","'<hive>ORC'","'<hive>OUTPUTFORMAT'","'<hive>OVERWRITE'","'<hive>PARQUET'","'<hive>PARTITIONED'","'<hive>PARTITIONS'","'<hive>PRIVILEGES'","'<hive>PURGE'","'<hive>RCFILE'","'<hive>REBUILD'","'<hive>RELOAD'","'<hive>REPAIR'","'<hive>REPLICATION'","'<hive>RECOVER'","'<hive>RENAME'","'<hive>REPLACE'","'<hive>RESTRICT'","'<hive>ROLE'","'<hive>ROLES'","'<hive>SCHEMAS'","'<hive>SEQUENCEFILE'","'<hive>SERDE'","'<hive>SERDEPROPERTIES'","'<hive>SETS'","'<hive>SHOW'","'<hive>SKEWED'","'<hive>SORTED'","'<hive>STATISTICS'","'<hive>STORED'","'<hive>STRING'","'<hive>STRUCT'","'<hive>TABLES'","'<hive>TBLPROPERTIES'","'<hive>TEMPORARY'","'<hive>TERMINATED'","'<hive>TEXTFILE'","'<hive>TINYINT'","'<hive>TOUCH'","'<hive>TRANSACTIONS'","'<hive>UNARCHIVE'","'<hive>UNIONTYPE'","'<hive>USE'","'<hive>VIEW'","'<impala>ANALYTIC'","'<impala>ANTI'","'<impala>CURRENT'","'<impala>GRANT'","'<impala>ROLE'","'<impala>ROLES'","'<impala>URI'","'<impala>SERVER'","'<impala>BLOCK_SIZE'","'<impala>COMPRESSION'","'<impala>DEFAULT'","'<impala>ENCODING'","'<impala>KEY'","'ROLE'","'OPTION'","'REGULAR_IDENTIFIER'","'VARIABLE_REFERENCE'","'TRUE'","'FALSE'","'NULL'","'<hive>ARRAY'","'<hive>BINARY'","'<hive>MAP'","'<hive>.'","'<impala>INTERVAL'","'<impala>.'","'CASE'","'END'","'EXISTS'","'IF'","'NOT'","'AVG'","'CAST'","'COUNT'","'MAX'","'MIN'","'STDDEV_POP'","'STDDEV_SAMP'","'SUM'","'VARIANCE'","'VAR_POP'","'VAR_SAMP'","'<hive>COLLECT_SET'","'<hive>COLLECT_LIST'","'<hive>CORR'","'<hive>COVAR_POP'","'<hive>COVAR_SAMP'","'<hive>NTILE'","'<hive>PERCENTILE'","'<hive>PERCENTILE_APPROX'","'<impala>APPX_MEDIAN'","'<impala>EXTRACT'","'<impala>GROUP_CONCAT'","'<impala>STDDEV'","'<impala>VARIANCE_POP'","'<impala>VARIANCE_SAMP'","'ANALYTIC'","'UNSIGNED_INTEGER'","'UNSIGNED_INTEGER_E'","'-'","'.'","'~'","'!'","'('","'BACKTICK'","'SINGLE_QUOTE'","'DOUBLE_QUOTE'","'<hive>HISTOGRAM_NUMERI'"],recoverable:true}],lowerCase:false},
    {index:367,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"select",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:368,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:["SELECT"],suggestIdentifiers:[{name:"foo.",type:"table"},{name:"bar.",type:"table"}],lowerCase:true},
    {index:369,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"SELECT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:42,last_column:43},expected:["','","')'"],recoverable:true}],suggestIdentifiers:[{name:"foo.",type:"table"},{name:"bar.",type:"table"}],lowerCase:true},
    {index:370,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},lowerCase:false},
    {index:371,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:["SELECT"],lowerCase:false},
    {index:372,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:373,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"SELECT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:33,last_column:34},expected:["','","')'"],recoverable:true}],lowerCase:false},
    {index:374,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:true},
    {index:375,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["COLREF"],tables:[{identifierChain:[{name:"ident_one"}]},{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["COLREF"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],errors:[{text:"",token:"EOF",line:0,loc:{first_line:1,last_line:1,first_column:71,last_column:72},expected:["'='","'BETWEEN'","'IN'","'LIKE'","'NOT'","'REGEXP'","'RLIKE'","'AND'","'OR'","'<'","'>'","'COMPARISON_OPERATOR'","'-'","'*'","'ARITHMETIC_OPERATOR'","')'"],recoverable:true}],suggestIdentifiers:[{name:"testTable1.",type:"table"},{name:"testTable2.",type:"table"}],lowerCase:true},
    {index:376,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},lowerCase:false},
    {index:377,suggestValues:{},colRef:{identifierChain:[{name:"ident_one"},{name:"ident_two"}]},suggestColumns:{types:["NUMBER"],source:"where",tables:[{identifierChain:[{name:"ident_one"}]}]},suggestFunctions:{types:["NUMBER"]},suggestKeywords:[{value:"CASE",weight:-1},{value:"EXISTS",weight:-1},{value:"NOT",weight:-1}],lowerCase:false},
    {index:378,useDatabase:"closest_db",suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:379,useDatabase:"closest_db",suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:false},
    {index:380,useDatabase:"database_two",suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:true},
    {index:381,useDatabase:"database_two",suggestAggregateFunctions:{tables:[]},suggestAnalyticFunctions:true,suggestKeywords:[{value:"*",weight:10000},{value:"ALL",weight:-1},{value:"DISTINCT",weight:-1}],suggestFunctions:{},suggestTables:{prependQuestionMark:true,prependFrom:true},suggestDatabases:{prependQuestionMark:true,prependFrom:true,appendDot:true},lowerCase:true},
    {index:382,suggestColumns:{tables:[{identifierChain:[{name:"bla1"},{name:"bla2"}]},{subQuery:"bla3"}]},errors:[{text:"from",token:"FROM",line:1,loc:{first_line:1,last_line:1,first_column:0,last_column:6},expected:["<hive>ADD","<hive>ADMIN","<hive>AFTER","<hive>ANALYZE","<hive>ARCHIVE","<hive>AVRO","<hive>BUCKET","<hive>BUCKETS","<hive>CACHE","<hive>CASCADE","<hive>CHANGE","<hive>CLUSTERED","<hive>COLLECTION","<hive>COLUMNS","<hive>COMMENT","<hive>COMPACT","<hive>COMPACTIONS","<hive>COMPUTE","<hive>CONCATENATE","<hive>DATA","<hive>DATABASES","<hive>DEFERRED","<hive>DEFINED","<hive>DELIMITED","<hive>DEPENDENCY","<hive>DIRECTORY","<hive>DISABLE","<hive>ENABLE","<hive>ESCAPED","<hive>EXCHANGE","<hive>EXPLAIN","<hive>EXPORT","<hive>FIELDS","<hive>FILE","<hive>FILEFORMAT","<hive>FIRST","<hive>FORMAT","<hive>FUNCTIONS","<hive>INPATH","<hive>INPUTFORMAT","<hive>JAR","<hive>IDXPROPERTIES","<hive>ITEMS","<hive>KEYS","<hive>LINES","<hive>LOAD","<hive>LOCATION","<hive>LOCKS","<hive>METADATA","<hive>MSCK","<hive>NOSCAN","<hive>NO_DROP","<hive>OFFLINE","<hive>ORC","<hive>OUTPUTFORMAT","<hive>OVERWRITE","<hive>PARQUET","<hive>PARTITIONED","<hive>PARTITIONS","<hive>PRIVILEGES","<hive>PURGE","<hive>RCFILE","<hive>REBUILD","<hive>RELOAD","<hive>REPAIR","<hive>REPLICATION","<hive>RECOVER","<hive>RENAME","<hive>REPLACE","<hive>RESTRICT","<hive>ROLE","<hive>ROLES","<hive>SCHEMAS","<hive>SEQUENCEFILE","<hive>SERDE","<hive>SERDEPROPERTIES","<hive>SETS","<hive>SHOW","<hive>SKEWED","<hive>SORTED","<hive>STATISTICS","<hive>STORED","<hive>STRING","<hive>STRUCT","<hive>TABLES","<hive>TBLPROPERTIES","<hive>TEMPORARY","<hive>TERMINATED","<hive>TEXTFILE","<hive>TINYINT","<hive>TOUCH","<hive>TRANSACTIONS","<hive>UNARCHIVE","<hive>UNIONTYPE","<hive>USE","<hive>VIEW","<impala>ANALYTIC","<impala>ANTI","<impala>CURRENT","<impala>GRANT","<impala>ROLE","<impala>ROLES","<impala>URI","<impala>SERVER","<impala>BLOCK_SIZE","<impala>COMPRESSION","<impala>DEFAULT","<impala>ENCODING","<impala>KEY","ROLE","OPTION","REGULAR_IDENTIFIER","VARIABLE_REFERENCE","CURSOR","TRUE","FALSE","NULL","<hive>ALL","<hive>ARRAY","<hive>BINARY","<hive>MAP","<hive>.","<impala>INTERVAL","<impala>.","ALL","CASE","DISTINCT","EXISTS","IF","NOT","AVG","CAST","COUNT","MAX","MIN","STDDEV_POP","STDDEV_SAMP","SUM","VARIANCE","VAR_POP","VAR_SAMP","<hive>COLLECT_SET","<hive>COLLECT_LIST","<hive>CORR","<hive>COVAR_POP","<hive>COVAR_SAMP","<hive>NTILE","<hive>PERCENTILE","<hive>PERCENTILE_APPROX","<impala>APPX_MEDIAN","<impala>EXTRACT","<impala>GROUP_CONCAT","<impala>STDDEV","<impala>VARIANCE_POP","<impala>VARIANCE_SAMP","ANALYTIC","UNSIGNED_INTEGER","UNSIGNED_INTEGER_E","-","*",".","~","!","(","BACKTICK","SINGLE_QUOTE","DOUBLE_QUOTE","PARTIAL_CURSOR","<hive>HISTOGRAM_NUMERI","Errors"],recoverable:true}],subQueries:[{columns:[{tables:[{identifierChain:[{name:"bla4"},{name:"bla5"}]}]}],alias:"bla3"}],lowerCase:true}
  ];

  var jsonStringToJsString = function (jsonString) {
    return jsonString.replace(/'([a-zA-Z]+)':/g, function (all, group) {
      return group + ':';
    }).replace(/([:{,])/g, function (all, group) { return group + ' ' }).replace(/[}]/g, ' }').replace(/["]/g, '\'')
        .replace(/'([a-z_]+)':/gi, '$1:');
  };

  return {
    autocompleteMatcher : {
      toEqualAutocompleteValues : function() {
        return {
          compare: function(actualItems, expectedValues) {
            if (actualItems.length !== expectedValues.length) {
              return { pass: false };
            }

            for (var i = 0; i < expectedValues.length; i++) {
              var stringValue = typeof actualItems[i] !== "string" ? '' + actualItems[i].value : actualItems[i].value;
              if (stringValue !== expectedValues[i]) {
                return { pass: false };
              }
            }
            return { pass: true };
          }
        }
      }
    },
    testDefinitionMatcher: {
      toEqualDefinition : function() {
        return {
          compare: function(actualResponse, testDefinition) {
            if (typeof testDefinition.noErrors === 'undefined' && actualResponse.errors) {
              var allRecoverable = true;
              actualResponse.errors.forEach(function (error) {
                allRecoverable = allRecoverable && error.recoverable;
              });
              if (allRecoverable) {
                delete actualResponse.errors;
              }
            }

            if (testDefinition.dialect !== 'impala' && actualResponse.locations) {
              actualResponse.locations = actualResponse.locations.filter(function (location) {
                if (location.type !== 'statementType') {
                  return location;
                }
              })
            }

            if (testDefinition.locationsOnly) {
              return {
                pass: resultEquals(actualResponse.locations, testDefinition.expectedLocations),
                message: '\n        Statement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                '          Dialect: ' + testDefinition.dialect + '\n' +
                'Expected locations: ' + jsonStringToJsString(JSON.stringify(testDefinition.expectedLocations)) + '\n' +
                '  Parser locations: ' + jsonStringToJsString(JSON.stringify(actualResponse.locations)) +   '\n'
              };
            }

            if (actualResponse.suggestKeywords) {
              var weightFreeKeywords = [];
              actualResponse.suggestKeywords.forEach(function (keyword) {
                weightFreeKeywords.push(keyword.value);
              });
              actualResponse.suggestKeywords = weightFreeKeywords;
            }

            if (!!testDefinition.noLocations) {
              if (actualResponse.locations.length > 0) {
                return {
                  pass: false,
                  message: '\nStatement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                  '  Dialect: ' + testDefinition.dialect + '\n' +
                  '           Expected no locations, found ' + actualResponse.locations.length
                }
              }
            }
            if (typeof testDefinition.expectedResult.locations === 'undefined') {
              delete actualResponse.locations;
            }
            var deleteKeywords = false;
            if (testDefinition.containsColRefKeywords) {
              if (typeof actualResponse.suggestColRefKeywords == 'undefined') {
                return {
                  pass: false,
                  message: '\nStatement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                  '  Dialect: ' + testDefinition.dialect + '\n' +
                  '           No colRef keywords found'
                }
              } else if (testDefinition.containsColRefKeywords !== true) {
                var contains = true;
                testDefinition.containsColRefKeywords.forEach(function (keyword) {
                  contains = contains && (actualResponse.suggestColRefKeywords.BOOLEAN.indexOf(keyword) !== -1 ||
                    actualResponse.suggestColRefKeywords.NUMBER.indexOf(keyword) !== -1 ||
                    actualResponse.suggestColRefKeywords.STRING.indexOf(keyword) !== -1);
                });
                if (!contains) {
                  return {
                    pass: false,
                    message: '\nStatement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                               '  Dialect: ' + testDefinition.dialect + '\n' +
                               '           Expected colRef keywords not found ' +
                               'Expected keywords: ' + JSON.stringify(testDefinition.containsColRefKeywords) + '\n' +
                               '  Parser keywords: ' + JSON.stringify(actualResponse.suggestColRefKeywords) +   '\n'
                  }
                }
              }
              delete actualResponse.suggestColRefKeywords;
            }

            if (typeof testDefinition.containsKeywords !== 'undefined') {
              var keywords = actualResponse.suggestKeywords;
              var contains = true;
              testDefinition.containsKeywords.forEach(function (keyword) {
                if (typeof keywords === 'undefined' || keywords.indexOf(keyword) === -1) {
                  contains = false;
                  return false;
                }
              });
              if (!contains) {
                return {
                  pass: false,
                  message: '\n        Statement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                             '          Dialect: ' + testDefinition.dialect + '\n' +
                             'Expected keywords: ' + JSON.stringify(testDefinition.containsKeywords) + '\n' +
                             '  Parser keywords: ' + JSON.stringify(keywords) +   '\n'
                }
              }
              deleteKeywords = true;
            }
            if (typeof testDefinition.doesNotContainKeywords !== 'undefined') {
              var keywords = actualResponse.suggestKeywords;
              var contains = false;
              testDefinition.doesNotContainKeywords.forEach(function (keyword) {
                if (typeof keywords === 'undefined' || keywords.indexOf(keyword) !== -1) {
                  contains = true;
                  return false;
                }
              });
              if (contains) {
                return {
                  pass: false,
                  message: '\n            Statement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                  '              Dialect: ' + testDefinition.dialect + '\n' +
                  'Not expected keywords: ' + JSON.stringify(testDefinition.doesNotContainKeywords) + '\n' +
                  '      Parser keywords: ' + JSON.stringify(keywords) +   '\n'
                }
              }
              deleteKeywords = true;
            }

            if (deleteKeywords) {
              delete actualResponse.suggestKeywords;
            }
            return {
              pass: resultEquals(actualResponse, testDefinition.expectedResult),
              message: '\n        Statement: ' + testDefinition.beforeCursor + '|' + testDefinition.afterCursor + '\n' +
                         '          Dialect: ' + testDefinition.dialect + '\n' +
                         'Expected response: ' + jsonStringToJsString(JSON.stringify(testDefinition.expectedResult) + '\n') +
                         '  Parser response: ' + jsonStringToJsString(JSON.stringify(actualResponse) +   '\n')
            };
          }
        }
      }
    },

    assertAutocomplete: function(testDefinition) {
      var debug = false;
      if (typeof testDefinition.dialect === 'undefined') {
        expect(sqlAutocompleteParser.parseSql(testDefinition.beforeCursor, testDefinition.afterCursor, undefined, debug)).toEqualDefinition(testDefinition);
        expect(sqlAutocompleteParser.parseSql(testDefinition.beforeCursor, testDefinition.afterCursor, 'hive', debug)).toEqualDefinition(testDefinition);
        expect(sqlAutocompleteParser.parseSql(testDefinition.beforeCursor, testDefinition.afterCursor, 'impala', debug)).toEqualDefinition(testDefinition);
      } else {
        expect(sqlAutocompleteParser.parseSql(testDefinition.beforeCursor, testDefinition.afterCursor, testDefinition.dialect, debug)).toEqualDefinition(testDefinition);
      }
    },
    LOTS_OF_PARSE_RESULTS: LOTS_OF_PARSE_RESULTS
  }
})();