#ifndef __GPIO_OMAP_H
#define __GPIO_OMAP_H

#define AM335X_GPIO0_BASE (0x44e07000)
#define AM335X_GPIO1_BASE (0x4804c000)
#define AM335X_GPIO2_BASE (0x481ac000)
#define AM335X_GPIO3_BASE (0x481ae000)
#define AM335X_GPIO0A_IRQ 96
#define AM335X_GPIO0B_IRQ 97
#define AM335X_GPIO1A_IRQ 98
#define AM335X_GPIO1B_IRQ 99
#define AM335X_GPIO2A_IRQ 32
#define AM335X_GPIO2B_IRQ 33
#define AM335X_GPIO3A_IRQ 62
#define AM335X_GPIO3B_IRQ 63
#define AM335X_GPIO0A_IRQ_HOOK_ID 0
#define AM335X_GPIO0B_IRQ_HOOK_ID 1
#define AM335X_GPIO1A_IRQ_HOOK_ID 2
#define AM335X_GPIO1B_IRQ_HOOK_ID 3
#define AM335X_GPIO2A_IRQ_HOOK_ID 4
#define AM335X_GPIO2B_IRQ_HOOK_ID 5
#define AM335X_GPIO3A_IRQ_HOOK_ID 6
#define AM335X_GPIO3B_IRQ_HOOK_ID 7

#define AM335X_GPIO_REVISION 0x000
#define AM335X_GPIO_SYSCONFIG 0x010
#define AM335X_GPIO_EOI 0x020
#define AM335X_GPIO_IRQSTATUS_RAW_0 0x024
#define AM335X_GPIO_IRQSTATUS_RAW_1 0x028
#define AM335X_GPIO_IRQSTATUS_0 0x02C
#define AM335X_GPIO_IRQSTATUS_1 0x030
#define AM335X_GPIO_IRQSTATUS_SET_0 0x034
#define AM335X_GPIO_IRQSTATUS_SET_1 0x038
#define AM335X_GPIO_IRQSTATUS_CLR_0 0x03C
#define AM335X_GPIO_IRQSTATUS_CLR_1 0x040
#define AM335X_GPIO_IRQWAKEN_0 0x044
#define AM335X_GPIO_IRQWAKEN_1 0x048
#define AM335X_GPIO_SYSSTATUS 0x114
#define AM335X_GPIO_CTRL 0x130
#define AM335X_GPIO_OE 0x134
#define AM335X_GPIO_DATAIN 0x138
#define AM335X_GPIO_DATAOUT 0x13C
#define AM335X_GPIO_LEVELDETECT0 0x140
#define AM335X_GPIO_LEVELDETECT1 0x144
#define AM335X_GPIO_RISINGDETECT 0x148
#define AM335X_GPIO_FALLINGDETECT 0x14C
#define AM335X_GPIO_DEBOUNCENABLE 0x150
#define AM335X_GPIO_DEBOUNCINGTIME 0x154
#define AM335X_GPIO_CLEARDATAOUT 0x190
#define AM335X_GPIO_SETDATAOUT 0x194

#define AM335X_GPIO_REVISION_MAJOR(X) ((X >> 8) & 0x07)
#define AM335X_GPIO_REVISION_MINOR(X) (X & 0x3f)

#define DM37XX_GPIO1_BASE (0x48310000)
#define DM37XX_GPIO2_BASE (0x49050000)
#define DM37XX_GPIO3_BASE (0x49052000)
#define DM37XX_GPIO4_BASE (0x49054000)
#define DM37XX_GPIO5_BASE (0x49056000)
#define DM37XX_GPIO6_BASE (0x49058000)
#define DM37XX_GPIO1_IRQ  29		/* GPIO module 1 */
#define DM37XX_GPIO2_IRQ  30		/* GPIO module 2 */
#define DM37XX_GPIO3_IRQ  31		/* GPIO module 3 */
#define DM37XX_GPIO4_IRQ  32		/* GPIO module 4 */
#define DM37XX_GPIO5_IRQ  33		/* GPIO module 5 */
#define DM37XX_GPIO6_IRQ  34		/* GPIO module 6 */
#define DM37XX_GPIO1_IRQ_HOOK_ID 0
#define DM37XX_GPIO2_IRQ_HOOK_ID 1
#define DM37XX_GPIO3_IRQ_HOOK_ID 2
#define DM37XX_GPIO4_IRQ_HOOK_ID 3
#define DM37XX_GPIO5_IRQ_HOOK_ID 4
#define DM37XX_GPIO6_IRQ_HOOK_ID 5

#define DM37XX_GPIO_IRQSTATUS1 (0x18)
#define DM37XX_GPIO_IRQENABLE1 (0x01C)
#define DM37XX_GPIO_DATAOUT (0x3c)
#define DM37XX_GPIO_DATAIN (0x38)
#define DM37XX_GPIO_OE    (0x34)	/* Output Data Enable */
#define DM37XX_GPIO_RISINGDETECT1 (0x048)
#define DM37XX_GPIO_FALLINGDETECT1 (0x04c)
#define DM37XX_GPIO_CLEARDATAOUT (0x90)
#define DM37XX_GPIO_SETDATAOUT (0x94)

#define DM37XX_GPIO_REVISION 0x00
#define DM37XX_GPIO_REVISION_MAJOR(X) ((X & 0xF0) >> 4)
#define DM37XX_GPIO_REVISION_MINOR(X) (X & 0XF)

#endif /* __GPIO_OMAP_H */
