/* Scancode conversion tables from PC keyboard scan codes to USB HID codes. */
/*
 * The contents of this file are based on the Microsoft "USB HID to PS/2 Scan
 * Code Translation Table" document, of which the purpose is to provide a
 * translation the other way around.  Therefore, some codes might be missing.
 */
#include <minix/input.h>

#include "pckbd.h"

const struct scanmap scanmap_normal[KBD_SCAN_CODES] = {
	[0x01] = { INPUT_PAGE_KEY,	INPUT_KEY_ESCAPE		},
	[0x02] = { INPUT_PAGE_KEY,	INPUT_KEY_1			},
	[0x03] = { INPUT_PAGE_KEY,	INPUT_KEY_2			},
	[0x04] = { INPUT_PAGE_KEY,	INPUT_KEY_3			},
	[0x05] = { INPUT_PAGE_KEY,	INPUT_KEY_4			},
	[0x06] = { INPUT_PAGE_KEY,	INPUT_KEY_5			},
	[0x07] = { INPUT_PAGE_KEY,	INPUT_KEY_6			},
	[0x08] = { INPUT_PAGE_KEY,	INPUT_KEY_7			},
	[0x09] = { INPUT_PAGE_KEY,	INPUT_KEY_8			},
	[0x0A] = { INPUT_PAGE_KEY,	INPUT_KEY_9			},
	[0x0B] = { INPUT_PAGE_KEY,	INPUT_KEY_0			},
	[0x0C] = { INPUT_PAGE_KEY,	INPUT_KEY_DASH			},
	[0x0D] = { INPUT_PAGE_KEY,	INPUT_KEY_EQUAL			},
	[0x0E] = { INPUT_PAGE_KEY,	INPUT_KEY_BACKSPACE		},
	[0x0F] = { INPUT_PAGE_KEY,	INPUT_KEY_TAB			},
	[0x10] = { INPUT_PAGE_KEY,	INPUT_KEY_Q			},
	[0x11] = { INPUT_PAGE_KEY,	INPUT_KEY_W			},
	[0x12] = { INPUT_PAGE_KEY,	INPUT_KEY_E			},
	[0x13] = { INPUT_PAGE_KEY,	INPUT_KEY_R			},
	[0x14] = { INPUT_PAGE_KEY,	INPUT_KEY_T			},
	[0x15] = { INPUT_PAGE_KEY,	INPUT_KEY_Y			},
	[0x16] = { INPUT_PAGE_KEY,	INPUT_KEY_U			},
	[0x17] = { INPUT_PAGE_KEY,	INPUT_KEY_I			},
	[0x18] = { INPUT_PAGE_KEY,	INPUT_KEY_O			},
	[0x19] = { INPUT_PAGE_KEY,	INPUT_KEY_P			},
	[0x1A] = { INPUT_PAGE_KEY,	INPUT_KEY_OPEN_BRACKET		},
	[0x1B] = { INPUT_PAGE_KEY,	INPUT_KEY_CLOSE_BRACKET		},
	[0x1C] = { INPUT_PAGE_KEY,	INPUT_KEY_ENTER			},
	[0x1D] = { INPUT_PAGE_KEY,	INPUT_KEY_LEFT_CTRL		},
	[0x1E] = { INPUT_PAGE_KEY,	INPUT_KEY_A			},
	[0x1F] = { INPUT_PAGE_KEY,	INPUT_KEY_S			},
	[0x20] = { INPUT_PAGE_KEY,	INPUT_KEY_D			},
	[0x21] = { INPUT_PAGE_KEY,	INPUT_KEY_F			},
	[0x22] = { INPUT_PAGE_KEY,	INPUT_KEY_G			},
	[0x23] = { INPUT_PAGE_KEY,	INPUT_KEY_H			},
	[0x24] = { INPUT_PAGE_KEY,	INPUT_KEY_J			},
	[0x25] = { INPUT_PAGE_KEY,	INPUT_KEY_K			},
	[0x26] = { INPUT_PAGE_KEY,	INPUT_KEY_L			},
	[0x27] = { INPUT_PAGE_KEY,	INPUT_KEY_SEMICOLON		},
	[0x28] = { INPUT_PAGE_KEY,	INPUT_KEY_APOSTROPH		},
	[0x29] = { INPUT_PAGE_KEY,	INPUT_KEY_GRAVE_ACCENT		},
	[0x2A] = { INPUT_PAGE_KEY,	INPUT_KEY_LEFT_SHIFT		},
	[0x2B] = { INPUT_PAGE_KEY,	INPUT_KEY_BACKSLASH		},
	[0x2C] = { INPUT_PAGE_KEY,	INPUT_KEY_Z			},
	[0x2D] = { INPUT_PAGE_KEY,	INPUT_KEY_X			},
	[0x2E] = { INPUT_PAGE_KEY,	INPUT_KEY_C			},
	[0x2F] = { INPUT_PAGE_KEY,	INPUT_KEY_V			},
	[0x30] = { INPUT_PAGE_KEY,	INPUT_KEY_B			},
	[0x31] = { INPUT_PAGE_KEY,	INPUT_KEY_N			},
	[0x32] = { INPUT_PAGE_KEY,	INPUT_KEY_M			},
	[0x33] = { INPUT_PAGE_KEY,	INPUT_KEY_COMMA			},
	[0x34] = { INPUT_PAGE_KEY,	INPUT_KEY_PERIOD		},
	[0x35] = { INPUT_PAGE_KEY,	INPUT_KEY_SLASH			},
	[0x36] = { INPUT_PAGE_KEY,	INPUT_KEY_RIGHT_SHIFT		},
	[0x37] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_STAR		},
	[0x38] = { INPUT_PAGE_KEY,	INPUT_KEY_LEFT_ALT		},
	[0x39] = { INPUT_PAGE_KEY,	INPUT_KEY_SPACEBAR		},
	[0x3A] = { INPUT_PAGE_KEY,	INPUT_KEY_CAPS_LOCK		},
	[0x3B] = { INPUT_PAGE_KEY,	INPUT_KEY_F1			},
	[0x3C] = { INPUT_PAGE_KEY,	INPUT_KEY_F2			},
	[0x3D] = { INPUT_PAGE_KEY,	INPUT_KEY_F3			},
	[0x3E] = { INPUT_PAGE_KEY,	INPUT_KEY_F4			},
	[0x3F] = { INPUT_PAGE_KEY,	INPUT_KEY_F5			},
	[0x40] = { INPUT_PAGE_KEY,	INPUT_KEY_F6			},
	[0x41] = { INPUT_PAGE_KEY,	INPUT_KEY_F7			},
	[0x42] = { INPUT_PAGE_KEY,	INPUT_KEY_F8			},
	[0x43] = { INPUT_PAGE_KEY,	INPUT_KEY_F9			},
	[0x44] = { INPUT_PAGE_KEY,	INPUT_KEY_F10			},
	[0x45] = { INPUT_PAGE_KEY,	INPUT_KEY_NUM_LOCK		},
	[0x46] = { INPUT_PAGE_KEY,	INPUT_KEY_SCROLL_LOCK		},
	[0x47] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_7			},
	[0x48] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_8			},
	[0x49] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_9			},
	[0x4A] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_DASH		},
	[0x4B] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_4			},
	[0x4C] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_5			},
	[0x4D] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_6			},
	[0x4E] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_PLUS		},
	[0x4F] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_1			},
	[0x50] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_2			},
	[0x51] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_3			},
	[0x52] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_0			},
	[0x53] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_PERIOD		},
	[0x54] = { INPUT_PAGE_KEY,	INPUT_KEY_SYSREQ		},
	[0x56] = { INPUT_PAGE_KEY,	INPUT_KEY_EUROPE_2		},
	[0x57] = { INPUT_PAGE_KEY,	INPUT_KEY_F11			},
	[0x58] = { INPUT_PAGE_KEY,	INPUT_KEY_F12			},
	[0x59] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_EQUAL		},
	[0x5C] = { INPUT_PAGE_KEY,	INPUT_KEY_I10L_6		},
	[0x64] = { INPUT_PAGE_KEY,	INPUT_KEY_F13			},
	[0x65] = { INPUT_PAGE_KEY,	INPUT_KEY_F14			},
	[0x66] = { INPUT_PAGE_KEY,	INPUT_KEY_F15			},
	[0x67] = { INPUT_PAGE_KEY,	INPUT_KEY_F16			},
	[0x68] = { INPUT_PAGE_KEY,	INPUT_KEY_F17			},
	[0x69] = { INPUT_PAGE_KEY,	INPUT_KEY_F18			},
	[0x6A] = { INPUT_PAGE_KEY,	INPUT_KEY_F19			},
	[0x6B] = { INPUT_PAGE_KEY,	INPUT_KEY_F20			},
	[0x6C] = { INPUT_PAGE_KEY,	INPUT_KEY_F21			},
	[0x6D] = { INPUT_PAGE_KEY,	INPUT_KEY_F22			},
	[0x6E] = { INPUT_PAGE_KEY,	INPUT_KEY_F23			},
	[0x70] = { INPUT_PAGE_KEY,	INPUT_KEY_I10L_2		},
	/* The following two keys (0x71, 0x72) are release-only. */
	[0x71] = { INPUT_PAGE_KEY,	INPUT_KEY_LANG_2		},
	[0x72] = { INPUT_PAGE_KEY,	INPUT_KEY_LANG_1		},
	[0x73] = { INPUT_PAGE_KEY,	INPUT_KEY_I10L_1		},
	/* The following key (0x76) can be either F24 or LANG_5. */
	[0x76] = { INPUT_PAGE_KEY,	INPUT_KEY_F24			},
	[0x77] = { INPUT_PAGE_KEY,	INPUT_KEY_LANG_4		},
	[0x78] = { INPUT_PAGE_KEY,	INPUT_KEY_LANG_3		},
	[0x79] = { INPUT_PAGE_KEY,	INPUT_KEY_I10L_4		},
	[0x7B] = { INPUT_PAGE_KEY,	INPUT_KEY_I10L_5		},
	[0x7D] = { INPUT_PAGE_KEY,	INPUT_KEY_I10L_3		},
	[0x7E] = { INPUT_PAGE_KEY,	INPUT_KEY_EQUAL_SIGN		},
};

const struct scanmap scanmap_escaped[KBD_SCAN_CODES] = {
	[0x10] = { INPUT_PAGE_CONS,	INPUT_CONS_SCAN_PREVIOUS_TRACK	},
	[0x19] = { INPUT_PAGE_CONS,	INPUT_CONS_SCAN_NEXT_TRACK	},
	[0x1C] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_ENTER		},
	[0x1D] = { INPUT_PAGE_KEY,	INPUT_KEY_RIGHT_CTRL		},
	[0x20] = { INPUT_PAGE_CONS,	INPUT_CONS_MUTE			},
	[0x21] = { INPUT_PAGE_CONS,	INPUT_CONS_AL_CALCULATOR	},
	[0x22] = { INPUT_PAGE_CONS,	INPUT_CONS_PLAY_PAUSE		},
	[0x24] = { INPUT_PAGE_CONS,	INPUT_CONS_STOP			},
	[0x2E] = { INPUT_PAGE_CONS,	INPUT_CONS_VOLUME_DOWN		},
	[0x30] = { INPUT_PAGE_CONS,	INPUT_CONS_VOLUME_UP		},
	[0x32] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_HOME		},
	[0x35] = { INPUT_PAGE_KEY,	INPUT_KEY_KP_SLASH		},
	[0x37] = { INPUT_PAGE_KEY,	INPUT_KEY_PRINT_SCREEN		},
	[0x38] = { INPUT_PAGE_KEY,	INPUT_KEY_RIGHT_ALT		},
	[0x46] = { INPUT_PAGE_KEY,	INPUT_KEY_PAUSE			},
	[0x47] = { INPUT_PAGE_KEY,	INPUT_KEY_HOME			},
	[0x48] = { INPUT_PAGE_KEY,	INPUT_KEY_UP_ARROW		},
	[0x49] = { INPUT_PAGE_KEY,	INPUT_KEY_PAGE_UP		},
	[0x4B] = { INPUT_PAGE_KEY,	INPUT_KEY_LEFT_ARROW		},
	[0x4D] = { INPUT_PAGE_KEY,	INPUT_KEY_RIGHT_ARROW		},
	[0x4F] = { INPUT_PAGE_KEY,	INPUT_KEY_END			},
	[0x50] = { INPUT_PAGE_KEY,	INPUT_KEY_DOWN_ARROW		},
	[0x51] = { INPUT_PAGE_KEY,	INPUT_KEY_PAGE_DOWN		},
	[0x52] = { INPUT_PAGE_KEY,	INPUT_KEY_INSERT		},
	[0x53] = { INPUT_PAGE_KEY,	INPUT_KEY_DELETE		},
	[0x5B] = { INPUT_PAGE_KEY,	INPUT_KEY_LEFT_GUI		},
	[0x5C] = { INPUT_PAGE_KEY,	INPUT_KEY_RIGHT_GUI		},
	[0x5D] = { INPUT_PAGE_KEY,	INPUT_KEY_APPLICATION		},
	/* The following extended key (0x5E) may also be INPUT_KEY_POWER. */
	[0x5E] = { INPUT_PAGE_GD,	INPUT_GD_SYSTEM_POWER_DOWN	},
	[0x5F] = { INPUT_PAGE_GD,	INPUT_GD_SYSTEM_SLEEP		},
	[0x63] = { INPUT_PAGE_GD,	INPUT_GD_SYSTEM_WAKE_UP		},
	[0x65] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_SEARCH		},
	[0x66] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_BOOKMARKS		},
	[0x67] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_REFRESH		},
	[0x68] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_STOP		},
	[0x69] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_FORWARD		},
	[0x6A] = { INPUT_PAGE_CONS,	INPUT_CONS_AC_BACK		},
	[0x6B] = { INPUT_PAGE_CONS,	INPUT_CONS_AL_LOCAL_BROWSER	},
	[0x6C] = { INPUT_PAGE_CONS,	INPUT_CONS_AL_EMAIL_READER	},
	[0x6D] = { INPUT_PAGE_CONS,	INPUT_CONS_AL_MEDIA_SELECT	},
};
