#!/bin/sh
# $NetBSD: mkheaderlist.sh,v 1.2 2011/02/05 13:30:26 yamt Exp $

# scan the source tree and create the headerlist file which is used by
# Makefile.nbincludes.

set -e

mklist()
{
	echo "# \$NetBSD\$"
	echo "#"
	echo '# do not edit; this file was automatically generated by:'
	echo '#	$NetBSD: mkheaderlist.sh,v 1.2 2011/02/05 13:30:26 yamt Exp $' | sed -e 's/\$//g'
	echo
	cd ../sys/arch && find . -name disklabel.h -o -name elf_machdep.h
}

LIST=headerlist
rm -f ${LIST}
mklist > ${LIST}
