/* termcap - print termcap settings	Author: Terrence Holm */

#include <stdlib.h>
#include <termcap.h>
#include <stdio.h>

#define  TC_BUFFER  1024	/* Size of termcap(3) buffer	*/

/****************************************************************/
/*								*/
/*    termcap  [ type ]						*/
/*								*/
/*    Prints out all of the termcap capabilities as described	*/
/*    in termcap(4). If "type" is not supplied then $TERM is	*/
/*    used.							*/
/*								*/
/****************************************************************/

_PROTOTYPE(int main, (int argc, char **argv));
_PROTOTYPE(void Print, (char *comment, char *name));
_PROTOTYPE(void Error, (char *message, char *arg));

int main(argc, argv)
int argc;
char *argv[];

  {
  char *term;
  char  buffer[ TC_BUFFER ];


  /*  Check for an argument  */

  if ( argc > 2 )
    Error( "Usage:  %s  [ type ]\n", argv[0] );

  if ( argc == 2 )
    term = argv[1];
  else
    term = getenv( "TERM" );

  if ( term == NULL )
    Error( "termcap:  $TERM is not defined\n", "" );


  /*  Read in the termcap entry  */

  if ( tgetent( buffer, term ) != 1 )
    Error( "termcap:  No termcap entry for %s\n", term );


  /*  Print out the entry's contents  */

  printf( "TERM = %s\n\n", term );

  if ( tgetflag( "am" ) == 1 )
    printf( "End of line wraps to next line   (am)\n" );

  if ( tgetflag( "bs" ) == 1 )
    printf( "Ctrl/H performs a backspace      (bs)\n" );

  printf( "Number of columns                (co) = %d\n", tgetnum( "co" ) );
  printf( "Number of lines                  (li) = %d\n", tgetnum( "li" ) );

  Print( "Clear to end of line", 	  "ce" );
  Print( "Clear to end of screen", 	  "cd" );
  Print( "Clear the whole screen",	  "cl" );

  Print( "Start \"stand out\" mode",	  "so" );
  Print( "End \"stand out\" mode",	  "se" );
  Print( "Start underscore mode",	  "us" );
  Print( "End underscore mode",		  "ue" );
  Print( "Start blinking mode",		  "mb" );
  Print( "Start bold mode",		  "md" );
  Print( "Start reverse mode",		  "mr" );
  Print( "Return to normal mode",	  "me" );

  Print( "Scroll backwards",		  "sr" );
  Print( "Cursor motion",		  "cm" );

  Print( "Up one line",			  "up" );
  Print( "Down one line",		  "do" );
  Print( "Left one space",		  "le" );
  Print( "Right one space",		  "nd" );
  Print( "Move to top left corner",	  "ho" );

  Print( "Generated by \"UP\"",		  "ku" );
  Print( "Generated by \"DOWN\"",	  "kd" );
  Print( "Generated by \"LEFT\"",	  "kl" );
  Print( "Generated by \"RIGHT\"",	  "kr" );
  Print( "Generated by \"HOME\"",	  "kh" );
  Print( "Generated by \"END\"",	  "@7" );
  Print( "Generated by \"PGUP\"",	  "kP" );
  Print( "Generated by \"PGDN\"",	  "kN" );
  Print( "Generated by \"F1\" ",	  "k1" );
  Print( "Generated by numeric \"+\"",	  "%5" );
  Print( "Generated by numeric \"-\"",	  "%8" );
  Print( "Generated by numeric \"5\"",	  "K2" );

  return( 0 );
  }






/****************************************************************/
/*								*/
/*    	Print( comment, name )					*/
/*								*/
/*    		If a termcap entry exists for "name", then	*/
/*		print out "comment" and the entry. Control	*/
/*		characters are printed as ^x.			*/
/*								*/
/****************************************************************/


void Print( comment, name )
  char *comment;
  char *name;

  {
  char  entry[ 50 ];
  char *p = entry;

  if ( tgetstr( name, &p ) == NULL )
    return;
    
  printf( "%-32s (%s) = ", comment, name );

  for ( p = entry;  *p != '\0';  ++p )
    if ( *p < ' ' )
      printf( "^%c", *p + '@' );
    else if ( *p == '\177' )
      printf( "^?" );
    else
      putchar( *p );

  putchar( '\n' );
  }






/****************************************************************/
/*								*/
/*    	Error( message, arg )					*/
/*								*/
/*    		Printf the "message" and abort.			*/
/*								*/
/****************************************************************/


void Error( message, arg )
  char *message;
  char *arg;

  {
  fprintf( stderr, message, arg );
  exit( 1 );
  }
