var list = {

	"Cameras": [
		[ "Camera", "cameras/Camera" ],
		[ "OrthographicCamera", "cameras/OrthographicCamera" ],
		[ "PerspectiveCamera", "cameras/PerspectiveCamera" ]
	],

	"Core": [
		[ "Clock", "core/Clock" ],
		[ "Color", "core/Color" ],
		[ "Face3", "core/Face3" ],
		[ "Face4", "core/Face4" ],
		[ "Frustum", "core/Frustum" ],
		[ "Geometry", "core/Geometry" ],
		[ "Math", "core/Math" ],
		[ "Matrix3", "core/Matrix3" ],
		[ "Matrix4", "core/Matrix4" ],
		[ "Object3D", "core/Object3D" ],
		[ "Projector", "core/Projector" ],
		[ "Quaternion", "core/Quaternion" ],
		[ "Ray", "core/Ray" ],
		[ "Rectangle", "core/Rectangle" ],
		[ "Spline", "core/Spline" ],
		[ "UV", "core/UV" ],
		[ "Vector2", "core/Vector2" ],
		[ "Vector3", "core/Vector3" ],
		[ "Vector4", "core/Vector4" ]
	],

	"Lights": [
		[ "Light", "lights/Light" ],
		[ "AmbientLight", "lights/AmbientLight" ],
		[ "DirectionalLight", "lights/DirectionalLight" ],
		[ "PointLight", "lights/PointLight" ],
		[ "SpotLight", "lights/SpotLight" ]
	],


	"Loaders": [
		[ "Loader", "loaders/Loader" ],
		[ "BinaryLoader", "loaders/BinaryLoader" ],
		[ "GeometryLoader", "loaders/GeometryLoader" ],
		[ "ImageLoader", "loaders/ImageLoader" ],
		[ "JSONLoader", "loaders/JSONLoader" ],
		[ "LoadingMonitor", "loaders/LoadingMonitor" ],
		[ "SceneLoader", "loaders/SceneLoader" ],
		[ "TextureLoader", "loaders/TextureLoader" ],
	],

	"Materials": [
		[ "Material", "materials/Material" ],
		[ "LineBasicMaterial", "materials/LineBasicMaterial" ],
		[ "MeshBasicMaterial", "materials/MeshBasicMaterial" ],
		[ "MeshDepthMaterial", "materials/MeshDepthMaterial" ],
		[ "MeshFaceMaterial", "materials/MeshFaceMaterial" ],
		[ "MeshLambertMaterial", "materials/MeshLambertMaterial" ],
		[ "MeshNormalMaterial", "materials/MeshNormalMaterial" ],
		[ "MeshPhongMaterial", "materials/MeshPhongMaterial" ],
		[ "ParticleBasicMaterial", "materials/ParticleBasicMaterial" ],
		[ "ParticleCanvasMaterial", "materials/ParticleCanvasMaterial" ],
		[ "ParticleDOMMaterial", "materials/ParticleDOMMaterial" ],
		[ "ShaderMaterial", "materials/ShaderMaterial" ]

	],

	"Objects": [
		[ "Bone", "objects/Bone" ],
		[ "Line", "objects/Line" ],
		[ "LOD", "objects/LOD" ],
		[ "Mesh", "objects/Mesh" ],
		[ "MorphAnimMesh", "objects/MorphAnimMesh" ],
		[ "Particle", "objects/Particle" ],
		[ "ParticleSystem", "objects/ParticleSystem" ],
		[ "Ribbon", "objects/Ribbon" ],
		[ "SkinnedMesh", "objects/SkinnedMesh" ],
		[ "Sprite", "objects/Sprite" ]

	],

	"Renderers": [
		[ "CanvasRenderer", "renderers/CanvasRenderer" ],
		[ "DOMRenderer", "renderers/DOMRenderer" ],
		[ "SVGRenderer", "renderers/SVGRenderer" ],
		[ "WebGLRenderer", "renderers/WebGLRenderer" ],
		[ "WebGLRenderTarget", "renderers/WebGLRenderTarget" ],
		[ "WebGLRenderTargetCube", "renderers/WebGLRenderTargetCube" ],
		[ "WebGLShaders", "renderers/WebGLShaders" ]
	],

	"Renderers / Renderables": [
		[ "RenderableFace3", "renderers/renderables/RenderableFace3" ],
		[ "RenderableFace4", "renderers/renderables/RenderableFace4" ],
		[ "RenderableLine", "renderers/renderables/RenderableLine" ],
		[ "RenderableObject", "renderers/renderables/RenderableObject" ],
		[ "RenderableParticle", "renderers/renderables/RenderableParticle" ],
		[ "RenderableVertex", "renderers/renderables/RenderableVertex" ]
	],

	"Scenes": [
		[ "Fog", "scenes/Fog" ],
		[ "FogExp2", "scenes/FogExp2" ],
		[ "Scene", "scenes/Scene" ]
	],

	"Textures": [
		[ "DataTexture", "textures/DataTexture" ],
		[ "Texture", "textures/Texture" ]
	],

	"Extras": [
		[ "ColorUtils", "extras/ColorUtils" ],
		[ "GeometryUtils", "extras/GeometryUtils" ],
		[ "ImageUtils", "extras/ImageUtils" ],
		[ "SceneUtils", "extras/SceneUtils" ],
		[ "ShaderUtils", "extras/ShaderUtils" ]
	],

	"Extras / Animation": [
		[ "Animation", "extras/animation/Animation" ],
		[ "AnimationHandler", "extras/animation/AnimationHandler" ],
		[ "AnimationMorphTarget", "extras/animation/AnimationMorphTarget" ],
		[ "KeyFrameAnimation", "extras/animation/KeyFrameAnimation" ]
	],

	"Extras / Cameras": [
		[ "CombinedCamera", "extras/cameras/CombinedCamera" ],
		[ "CubeCamera", "extras/cameras/CubeCamera" ]
	],

	"Extras / Controls": [
		[ "FirstPersonControls", "extras/controls/FirstPersonControls" ],
		[ "FlyControls", "extras/controls/FlyControls" ],
		[ "PathControls", "extras/controls/PathControls" ],
		[ "RollControls", "extras/controls/RollControls" ],
		[ "TrackballControls", "extras/controls/TrackballControls" ]
	],

	"Extras / Core": [
		[ "BufferGeometry", "extras/core/BufferGeometry" ],
		[ "Curve", "extras/core/Curve" ],
		[ "CurvePath", "extras/core/CurvePath" ],
		[ "EventTarget", "extras/core/EventTarget" ],
		[ "Gyroscope", "extras/core/Gyroscope" ],
		[ "Path", "extras/core/Path" ],
		[ "Shape", "extras/core/Shape" ],
		[ "TextPath", "extras/core/TextPath" ]
	],

	"Extras / Geometries": [
		[ "CubeGeometry", "extras/geometries/CubeGeometry" ],
		[ "CylinderGeometry", "extras/geometries/CylinderGeometry" ],
		[ "ExtrudeGeometry", "extras/geometries/ExtrudeGeometry" ],
		[ "IcosahedronGeometry", "extras/geometries/IcosahedronGeometry" ],
		[ "LatheGeometry", "extras/geometries/LatheGeometry" ],
		[ "OctahedronGeometry", "extras/geometries/OctahedronGeometry" ],
		[ "PlaneGeometry", "extras/geometries/PlaneGeometry" ],
		[ "PolyhedronGeometry", "extras/geometries/PolyhedronGeometry" ],
		[ "SphereGeometry", "extras/geometries/SphereGeometry" ],
		[ "TetrahedronGeometry", "extras/geometries/TetrahedronGeometry" ],
		[ "TextGeometry", "extras/geometries/TextGeometry" ],
		[ "TorusGeometry", "extras/geometries/TorusGeometry" ],
		[ "TorusKnotGeometry", "extras/geometries/TorusKnotGeometry" ]
	],

	"Extras / Helpers": [
		[ "AxisHelper", "extras/helpers/AxisHelper" ],
		[ "CameraHelper", "extras/helpers/CameraHelper" ]
	],

	"Extras / Modifiers": [
		[ "SubdivisionModifier", "extras/modifiers/SubdivisionModifier" ]
	],

	"Extras / Objects": [
		[ "LensFlare", "extras/objects/LensFlare" ],
		[ "MarchingCubes", "extras/objects/MarchingCubes" ]
	],

	"Extras / Renderers / Effects": [
		[ "AnaglyphEffect", "extras/renderers/effects/AnaglyphEffect" ],
		[ "CrosseyedEffect", "extras/renderers/effects/CrosseyedEffect" ],
		[ "ParallaxBarrierEffect", "extras/renderers/effects/ParallaxBarrierEffect" ],
		[ "StereoEffect", "extras/renderers/effects/StereoEffect" ]
	],

	"Extras / Renderers / Plugins": [
		[ "LensFlarePlugin", "extras/renderers/plugins/LensFlarePlugin" ],
		[ "ShadowMapPlugin", "extras/renderers/plugins/ShadowMapPlugin" ],
		[ "SpritePlugin", "extras/renderers/plugins/SpritePlugin" ]
	],

	"Extras / Shaders": [
		[ "ShaderFlares", "extras/shaders/ShaderFlares" ],
		[ "ShaderSprite", "extras/shaders/ShaderSprite" ]
	]

};

var pages = {};

for ( var category in list ) {

	for ( var i = 0; i < list[ category ].length; i ++ ) {

		var page = list[ category ][ i ];
		pages[ page[ 0 ] ] = page[ 1 ];

	}

}
