//
//  ViewController.swift
//  ChipMemorySpeed
//
//  Created by Myles C. Maxfield on 9/13/19.
//  Copyright © 2019 Myles C. Maxfield. All rights reserved.
//

import UIKit

class ViewController: UIViewController {
    var speedTests: [SpeedTest]!
    var results: [CFTimeInterval] = []
    let trials = 20
    var trialIndex = 0
    var speedTestIndex = 0

    func executeTests() {
        speedTests[speedTestIndex].runTest {duration in
            if self.trialIndex != 0 {
                self.results[self.speedTestIndex] += duration
            }
            //print("\(self.speedTestIndex): \((duration) * 1000) ms")
            self.speedTestIndex += 1
            if self.speedTestIndex >= self.speedTests.count {
                self.trialIndex += 1
                if self.trialIndex >= self.trials {
                    self.results = self.results.map({$0 / CFTimeInterval(self.trials - 1) * 1000})
                    print("Results: \(self.results)")
                    return
                }
                self.speedTestIndex = 0
            }
            self.executeTests()
        }
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        let device = MTLCreateSystemDefaultDevice()!
        let width = 4096
        let height = 4096

        speedTests = [TextureWriteSpeed(device: device, width: width, height: height), RenderTargetSpeed(device: device, width: width, height: height), ImageBlockSpeed(device: device, width: width, height: height)]

        results = Array(repeating: CFTimeInterval(0), count: speedTests.count)

        executeTests()
    }
}

