//
//  TextureWriteShaders.metal
//  ChipMemorySpeed
//
//  Created by Myles C. Maxfield on 9/14/19.
//  Copyright © 2019 Myles C. Maxfield. All rights reserved.
//

#include <metal_stdlib>
using namespace metal;

struct FragmentIn {
    float2 textureCoordinate [[id(0)]];
};

struct Uniforms {
    uint width;
    uint height;
};

fragment void textureWriteIntermediateFragmentFunction(FragmentIn fragmentIn [[stage_in]], texture2d<float, access::write> intermediateTexture [[texture(0)]], constant Uniforms& uniforms [[buffer(0)]]) {
    intermediateTexture.write(float4(0.75, 0.75, 0.75, 0.75), uint2(fragmentIn.textureCoordinate * float2(uniforms.width, uniforms.height)));
}

fragment float4 textureWriteDestinationFragmentFunction(FragmentIn fragmentIn [[stage_in]], texture2d<float, access::read> intermediateTexture [[texture(0)]], constant Uniforms& uniforms [[buffer(0)]]) {
    float4 value = intermediateTexture.read(uint2(fragmentIn.textureCoordinate * float2(uniforms.width, uniforms.height)));
    return value + float4(0.125, 0.125, 0.125, 0.125);
}
