//
//  Shaders.metal
//  ChipMemorySpeed
//
//  Created by Myles C. Maxfield on 9/13/19.
//  Copyright © 2019 Myles C. Maxfield. All rights reserved.
//

#include <metal_stdlib>
using namespace metal;

struct VertexIn {
    float2 position [[attribute(0)]];
};

struct VertexOut {
    float4 position [[position]];
    float2 textureCoordinate [[id(0)]];
};

vertex VertexOut vertexFunction(VertexIn vertexIn [[stage_in]]) {
    VertexOut vertexOut;
    vertexOut.position = float4(vertexIn.position, 0, 1);
    vertexOut.textureCoordinate = (vertexIn.position + 1) / 2;
    return vertexOut;
}
