# Running a Validator

This document describes how to participate in the Solana testnet as a validator
node.

Please note some of the information and instructions described here may change
in future releases, and documentation will be updated for mainnet participation.

## Overview

Solana currently maintains several testnets, each featuring a validator that can
serve as the entrypoint to the cluster for your validator.

Current testnet entrypoints:

* Stable, testnet.solana.com
* Beta, beta.testnet.solana.com
* Edge, edge.testnet.solana.com

Solana may launch special testnets for validator participation; we will provide
you with a specific entrypoint URL to use.

Prior to mainnet, the testnets may be running different versions of solana
software, which may feature breaking changes. For information on choosing a
testnet and finding software version info, jump to [Choosing a Testnet](validator-testnet.md).

The testnets are configured to reset the ledger daily, or sooner, should the
hourly automated cluster sanity test fail.

There is a network explorer that shows the status of solana testnets available
at [http://explorer.solana.com/](https://explorer.solana.com/).

Also we'd love it if you choose to register your validator node with us at
[https://forms.gle/LfFscZqJELbuUP139](https://forms.gle/LfFscZqJELbuUP139).
