# Table of contents

* [Introduction](introduction.md)
* [Terminology](terminology.md)
* [Getting Started](getting-started/README.md)
  * [Testnet Participation](getting-started/testnet-participation.md)
  * [Example Client: Web Wallet](getting-started/webwallet.md)
* [Programming Model](programs/README.md)
  * [Example: Tic-Tac-Toe](programs/tictactoe.md)
  * [Drones](programs/drones.md)
* [A Solana Cluster](cluster/README.md)
  * [Synchronization](cluster/synchronization.md)
  * [Leader Rotation](cluster/leader-rotation.md)
  * [Fork Generation](cluster/fork-generation.md)
  * [Managing Forks](cluster/managing-forks.md)
  * [Turbine Block Propagation](cluster/turbine-block-propagation.md)
  * [Ledger Replication](cluster/ledger-replication.md)
  * [Secure Vote Signing](cluster/vote-signing.md)
  * [Stake Delegation and Rewards](cluster/stake-delegation-and-rewards.md)
  * [Performance Metrics](cluster/performance-metrics.md)
* [Anatomy of a Validator](validator/README.md)
  * [TPU](validator/tpu.md)
  * [TVU](validator/tvu/README.md)
    * [Blockstore](validator/tvu/blockstore.md)
  * [Gossip Service](validator/gossip.md)
  * [The Runtime](validator/runtime.md)
* [Anatomy of a Transaction](transaction.md)
* [Running a Validator](running-validator/README.md)
  * [Validator Requirements](running-validator/validator-reqs.md)
  * [Choosing a Testnet](running-validator/validator-testnet.md)
  * [Installing the Validator Software](running-validator/validator-software.md)
  * [Starting a Validator](running-validator/validator-start.md)
  * [Staking](running-validator/validator-stake.md)
  * [Monitoring a Validator](running-validator/validator-monitor.md)
  * [Publishing Validator Info](running-validator/validator-info.md)
  * [Troubleshooting](running-validator/validator-troubleshoot.md)
* [Running an Archiver](running-archiver.md)
* [Paper Wallet](paper-wallet/README.md)
  * [Installation](paper-wallet/installation.md)
  * [Paper Wallet Usage](paper-wallet/usage.md)
* [Offline Signing](offline-signing/README.md)
  * [Durable Transaction Nonces](offline-signing/durable-nonce.md)
* [API Reference](api-reference/README.md)
  * [Transaction](api-reference/transaction-api.md)
  * [Instruction](api-reference/instruction-api.md)
  * [Blockstreamer](api-reference/blockstreamer.md)
  * [JSON RPC API](api-reference/jsonrpc-api.md)
  * [JavaScript API](api-reference/javascript-api.md)
  * [solana CLI](api-reference/cli.md)
* [Accepted Design Proposals](proposals/README.md)
  * [Ledger Replication](proposals/ledger-replication-to-implement.md)
  * [Secure Vote Signing](proposals/vote-signing-to-implement.md)
  * [Cluster Test Framework](proposals/cluster-test-framework.md)
  * [Validator](proposals/validator-proposal.md)
  * [Simple Payment and State Verification](proposals/simple-payment-and-state-verification.md)
  * [Cross-Program Invocation](proposals/cross-program-invocation.md)
  * [Inter-chain Transaction Verification](proposals/interchain-transaction-verification.md)
  * [Snapshot Verification](proposals/snapshot-verification.md)
  * [Bankless Leader](proposals/bankless-leader.md)
  * [Slashing](proposals/slashing.md)
* [Implemented Design Proposals](implemented-proposals/README.md)
  * [Blockstore](implemented-proposals/blockstore.md)
  * [Cluster Software Installation and Updates](implemented-proposals/installer.md)
  * [Cluster Economics](implemented-proposals/ed_overview/README.md)
    * [Validation-client Economics](implemented-proposals/ed_overview/ed_validation_client_economics/README.md)
      * [State-validation Protocol-based Rewards](implemented-proposals/ed_overview/ed_validation_client_economics/ed_vce_state_validation_protocol_based_rewards.md)
      * [State-validation Transaction Fees](implemented-proposals/ed_overview/ed_validation_client_economics/ed_vce_state_validation_transaction_fees.md)
      * [Replication-validation Transaction Fees](implemented-proposals/ed_overview/ed_validation_client_economics/ed_vce_replication_validation_transaction_fees.md)
      * [Validation Stake Delegation](implemented-proposals/ed_overview/ed_validation_client_economics/ed_vce_validation_stake_delegation.md)
    * [Replication-client Economics](implemented-proposals/ed_overview/ed_replication_client_economics/README.md)
      * [Storage-replication Rewards](implemented-proposals/ed_overview/ed_replication_client_economics/ed_rce_storage_replication_rewards.md)
      * [Replication-client Reward Auto-delegation](implemented-proposals/ed_overview/ed_replication_client_economics/ed_rce_replication_client_reward_auto_delegation.md)
    * [Economic Sustainability](implemented-proposals/ed_overview/ed_economic_sustainability.md)
    * [Attack Vectors](implemented-proposals/ed_overview/ed_attack_vectors.md)
    * [Economic Design MVP](implemented-proposals/ed_overview/ed_mvp.md)
    * [References](implemented-proposals/ed_overview/ed_references.md)
  * [Deterministic Transaction Fees](implemented-proposals/transaction-fees.md)
  * [Tower BFT](implemented-proposals/tower-bft.md)
  * [Leader-to-Leader Transition](implemented-proposals/leader-leader-transition.md)
  * [Leader-to-Validator Transition](implemented-proposals/leader-validator-transition.md)
  * [Persistent Account Storage](implemented-proposals/persistent-account-storage.md)
  * [Reliable Vote Transmission](implemented-proposals/reliable-vote-transmission.md)
  * [Repair Service](implemented-proposals/repair-service.md)
  * [Testing Programs](implemented-proposals/testing-programs.md)
  * [Credit-only Accounts](implemented-proposals/readonly-accounts.md)
  * [Embedding the Move Langauge](implemented-proposals/embedding-move.md)
  * [Staking Rewards](implemented-proposals/staking-rewards.md)
  * [Rent](implemented-proposals/rent.md)
  * [Durable Transaction Nonces](implemented-proposals/durable-tx-nonces.md)
  * [Validator Timestamp Oracle](implemented-proposals/validator-timestamp-oracle.md)
