## Interblockchain Communication Protocol Ecosystem

### Handler implementations

Implementations of the canonical IBC protocol & handler as defined in the specification.

Suitable for integration with blockchains written in the respective client languages.

| Status    | Language    | Implementer                                     | Links                     |
| --------- | ----------- | ----------------------                          | ------------------------- |
| Alpha     | Golang      | [All in Bits](https://tendermint.com)           | [Tracking issue](https://github.com/cosmos/ics/issues/145), [source code](https://github.com/cosmos/cosmos-sdk/pull/4548) |
| Upcoming  | Rust        | [Interchain Foundation](https://interchain.io)  | TBA |
| Upcoming  | Haskell     | [Kadena](https://kadena.io)                     | TBA |
| Upcoming  | Javascript  | [Agoric](https://agoric.com)                    | TBA |
| Upcoming  | Rust        | [CodeChain](https://codechain.io)               | [Source code](https://github.com/CodeChain-io/codechain) |

### Bridges

Specialised bridges which integrate neatly with the IBC protocol.

| Status    | Blockchain | Implementer                              | Links                |
| --------- | ---------- | -----------                              | -------------------- |
| Alpha     | Bitcoin    | [Nomic](https://nomic.io)                | [Source code](https://github.com/nomic-io/bitcoin-peg) |
| Alpha     | Ethereum   | [Swish Labs](http://www.swishlabs.com/)  | [Source code](https://github.com/swishlabsco/peggy) |
| Upcoming  | Substrate  | [SpeckleOS](https://www.speckleos.io/)   | TBA |

### Relayers

Relayer implementations, as standalone processes or integrated into wallets.

(coming soon)

### Ledgers

Operational distributed ledgers which speak IBC.

(coming soon)

### Applications

Decentralised applications which utilise IBC.

(coming soon)

### Explorers

Block explorers which can parse & trace IBC transactions.

(coming soon)
