# Inter-blockchain Communication Protocol (IBC)

The *inter-blockchain communication protocol* is a reliable & secure inter-module communication protocol, where modules are deterministic processes that run on independent distributed ledgers (also referred to as blockchains). IBC can be used by any application which builds on top of reliable & secure interchain communication. Example applications include cross-chain asset transfer, atomic swaps, multi-chain smart contracts (with or without mutually comprehensible VMs), and data & code sharding of various kinds.

For an overview of the IBC protocol, read the following documents in numerical order.

1. [IBC Architecture](./1_IBC_ARCHITECTURE.md)
1. [IBC Design Principles](./2_IBC_DESIGN_PRINCIPLES.md)
1. [IBC Terminology](./3_IBC_TERMINOLOGY.md)
1. [IBC Usecases](./4_IBC_USECASES.md)
1. [IBC Design Patterns](./5_IBC_DESIGN_PATTERNS.md)

You might also be interested in the [research compilation](./RESEARCH.md).
