// DO NOT EDIT THIS FILE.
//go:generate gb help documentation

/*
gb, a project based build tool for the Go programming language.

Usage:

        gb command [arguments]

The commands are:

        build       build a package
        doc         show documentation for a package or symbol
        env         print project environment variables
        generate    generate Go files by processing source
        info        info returns information about this project
        list        list the packages named by the importpaths
        plugin      run a plugin
        test        test packages

Use "gb help [command]" for more information about a command.

Additional help topics:

        project     gb project layout

Use "gb help [topic]" for more information about that topic.


Build a package

Usage:

        gb build [build flags] [packages]

Build compiles the packages named by the import paths, along with their dependencies.

The build flags are

	-f
		ignore cached packages if present, new packages built will overwrite any cached packages.
		This effectively disables incremental compilation.
	-F
		do not cache packages, cached packages will still be used for incremental compilation.
		-f -F is advised to disable the package caching system.
	-q
		decreases verbosity, effectively raising the output level to ERROR.
		In a successful build, no output will be displayed.
	-P
		The number of build jobs to run in parallel, including test execution.
		By default this is the number of CPUs visible to gb.
	-R
		sets the base of the project root search path from the current working directory to the value supplied.
		Effectively gb changes working directory to this path before searching for the project root.
	-v
		increases verbosity, effectively lowering the output level from INFO to DEBUG.
	-dotfile
		if provided, gb will output a dot formatted file of the build steps to be performed.
	-ldflags 'flag list'
		arguments to pass on each linker invocation.
	-gcflags 'arg list'
		arguments to pass on each go tool compile invocation.

The list flags accept a space-separated list of strings. To embed spaces in an element in the list, surround it with either single or double quotes.

For more about specifying packages, see 'gb help packages'. For more about where packages and binaries are installed, run 'gb help project'.


Show documentation for a package or symbol

Usage:

        gb doc <pkg> <sym>[.<method>]




Print project environment variables

Usage:

        gb env

Env prints project environment variables.


Generate Go files by processing source

Usage:

        gb generate

Generate runs commands described by directives within existing files.
Those commands can run any process but the intent is to create or update Go
source files, for instance by running yacc.

See 'go help generate'


Info returns information about this project

Usage:

        gb info

info returns information about this project.

info returns 0 if the project is well formed, and non zero otherwise.


List the packages named by the importpaths

Usage:

        gb list [-s] [-f format] [-json] [packages]

list lists packages.

The default output shows the package import path:

	% gb list github.com/constabulary/...
	github.com/constabulary/gb
	github.com/constabulary/gb/cmd
	github.com/constabulary/gb/cmd/gb
	github.com/constabulary/gb/cmd/gb-env
	github.com/constabulary/gb/cmd/gb-list

Flags:
	-f
		alternate format for the list, using the syntax of package template.
		The default output is equivalent to -f '{{.ImportPath}}'. The struct
		being passed to the template is currently an instance of gb.Package.
		This structure is under active development and it'As contents are not
		guarenteed to be stable.


Run a plugin

Usage:

        gb plugin command

gb supports git style plugins

See gb help plugins.


Gb project layout

A gb project is defined as any directory that contains a src/ subdirectory.
gb automatically detects the root of the project by looking at the current working directory and walking backwards until it finds a directory that contains a src/ subdirectory.

In the event you wish to override this auto detection mechanism, the -R flag can be used to supply a project root.

See http://getgb.io/docs/project for details


Test packages

Usage:

        gb test [build flags] [packages] [flags for test binary]

'gb test' automates testing the packages named by the import paths.

'gb test' recompiles each package along with any files with names matching
the file pattern "*_test.go".

See 'go help test'


*/
package main
