# v0.5.0

## High-level overview

- A significant number of types, methods and functions have been renamed in preparation for a
  future `v1.0.0` release. These renames aim to create a more coherent interface for the
  functionalities exposed by the `depgraph` package.

## New features

- The `depgraph.DepGraph` type now exposes a `RemoveDependency` method allowing to remove a given
  module including any edges starting or ending at this module.
- The new `lib/modules` package exposes methods to retrieve various levels of module information.
- The `depgraph.DepAnalysis` type now also contains information about the update backlog time of
  a module's dependencies. This reflects the timespan between the timestamp of the used version of a
  dependency and the timestamp of the newest available update.

## Breaking changes

- Package split: the `depgraph.Module` and `depgraph.ModuleError` types have been extracted to a
  separate `lib/modules` package in preparation for future work that will expand the configurability
  of information loading to support new features.
- Type renames:
  - `depgraph.Node` has been renamed to `depgraph.Dependency` after the pre-existing type of that
    name has been removed in the `v0.4.0` release.
  - `depgraph.NodeReference` has been renamed to `depgraph.DependencyReference`.
  - `depgraph.NodeMap` has been renamed to `depgraph.DependencyMap` and the associated
    `NewNodeMap()` function has accordingly been renamed to `NewDependencyMap()`.
- The `depgraph.DepGraph` type's methods have changed:
  - `Main()` has been removed in favour of direct access to a field with the same name.
  - `Nodes()` has been removed in favour of direct access to a field named `Dependencies`.
  - `Node()` has been renamed to `GetDependency()`.
  - `AddNode()` has been renamed to `AddDependency` and now only returns a `*Dependency` instead of
    also a `bool`. The returned `value` is `nil` if the module passed as parameter could not be
    added.
- The `depgraph.DependencyFilter` type's `Dependency` field has been renamed to `Module`.
- The `depgraph.NewDepGraph()` function now also takes the path where the contained module lives.
- The `depgraph.GetDepGraph()` function now also takes a relative or absolute path to the directory
  where the targeted Go module lives.
