/**
 * Set the attributes for the Dimension Control
 *
 * @type {Object}
 */
const DimensionsAttributes = {
	paddingTop: {
		type: 'number',
	},
	paddingRight: {
		type: 'number',
	},
	paddingBottom: {
		type: 'number',
	},
	paddingLeft: {
		type: 'number',
	},
	paddingTopTablet: {
		type: 'number',
	},
	paddingRightTablet: {
		type: 'number',
	},
	paddingBottomTablet: {
		type: 'number',
	},
	paddingLeftTablet: {
		type: 'number',
	},
	paddingTopMobile: {
		type: 'number',
	},
	paddingRightMobile: {
		type: 'number',
	},
	paddingBottomMobile: {
		type: 'number',
	},
	paddingLeftMobile: {
		type: 'number',
	},
	paddingUnit: {
		type: 'string',
		default: 'px',
	},
	paddingSize: {
		type: 'string',
		default: 'no',
	},
	paddingSyncUnits: {
		type: 'boolean',
		default: false,
	},
	paddingSyncUnitsTablet: {
		type: 'boolean',
		default: true,
	},
	paddingSyncUnitsMobile: {
		type: 'boolean',
		default: true,
	},
	marginTop: {
		type: 'number',
	},
	marginRight: {
		type: 'number',
	},
	marginBottom: {
		type: 'number',
	},
	marginLeft: {
		type: 'number',
	},
	marginTopTablet: {
		type: 'number',
	},
	marginRightTablet: {
		type: 'number',
	},
	marginBottomTablet: {
		type: 'number',
	},
	marginLeftTablet: {
		type: 'number',
	},
	marginTopMobile: {
		type: 'number',
	},
	marginRightMobile: {
		type: 'number',
	},
	marginBottomMobile: {
		type: 'number',
	},
	marginLeftMobile: {
		type: 'number',
	},
	marginUnit: {
		type: 'string',
		default: 'px',
	},
	marginSize: {
		type: 'string',
		default: 'no',
	},
	marginSyncUnits: {
		type: 'boolean',
		default: false,
	},
	marginSyncUnitsTablet: {
		type: 'boolean',
		default: false,
	},
	marginSyncUnitsMobile: {
		type: 'boolean',
		default: false,
	},
	hasMarginControl: {
		type: 'boolean',
		default: true,
	},
	hasAlignmentControls: {
		type: 'boolean',
		default: true,
	},
	hasStackedControl: {
		type: 'boolean',
		default: true,
	},
};

export default DimensionsAttributes;
