// Register block category
import './utils/block-category';

// Utils
import './js/coblocks-color-fix';

// Extensions
import './extensions/apply-extensions';
import './extensions/block-patterns';
import './extensions/coblocks-settings';
import './extensions/coblocks-labs';

// The following three imports are intentionally ordered for CoBlocks Labs controls.
import './extensions/site-content';
import './extensions/site-design';
import './extensions/layout-selector';

// Formats
import './formats';

// Block Styles - Each block style imports its own styles.
// Styles are located in `style-coblocks-extensions.css`.
import './block-styles/core/paragraph';
import './block-styles/core/image';
import './block-styles/core/cover';
import './block-styles/core/media-text';
import './block-styles/core/list';
import './block-styles/core/buttons';

// Block Variations
import './block-variations/core/paragraph';
import './block-variations/core/columns';
