import {createApp} from 'vue'
import App from './App.vue'
import "./tailwind.css"
import "boxicons/css/boxicons.min.css"
import axios from 'axios'
import store from './store'
import config from "./config";
import __ from 'lodash'

window.axios = axios
window.__ = __
store.setup()

let app = createApp(App)

app.config.globalProperties.store = store
app.config.globalProperties.config = config
app.config.globalProperties.__ = __
app.config.globalProperties.filesize = size => {
    let i = size === 0 ? 0 : Math.floor(Math.log(size) / Math.log(1024));
    return (size / Math.pow(1024, i)).toFixed(2) * 1 + ' ' + ['B', 'kB', 'MB', 'GB', 'TB'][i];
}
app.config.globalProperties.unixToDiff = (timestamp) => {

    let msPerMinute = 60 * 1000;
    let msPerHour = msPerMinute * 60;
    let msPerDay = msPerHour * 24;
    let msPerMonth = msPerDay * 30;
    let msPerYear = msPerDay * 365;

    let elapsed = (new Date).getTime() - timestamp * 1000

    if (elapsed === 0) {
        return 'now';
    } else if (elapsed < msPerMinute) {
        return Math.round(elapsed / 1000) + ' seconds ago';
    } else if (elapsed < msPerHour) {
        return Math.round(elapsed / msPerMinute) + ' minutes ago';
    } else if (elapsed < msPerDay) {
        return Math.round(elapsed / msPerHour) + ' hours ago';
    } else if (elapsed < msPerMonth) {
        return Math.round(elapsed / msPerDay) + ' days ago';
    } else if (elapsed < msPerYear) {
        return Math.round(elapsed / msPerMonth) + ' months ago';
    } else {
        return Math.round(elapsed / msPerYear) + ' years ago';
    }
}
app.config.globalProperties.unixToString = UNIX_timestamp => {
    // https://stackoverflow.com/a/6078873/5211299
    let a = new Date(UNIX_timestamp * 1000);
    let months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    let year = a.getFullYear();
    let month = months[a.getMonth()];
    let date = a.getDate();
    let hour = a.getHours();
    let min = a.getMinutes();
    let sec = a.getSeconds();
    return date + ' ' + month + ' ' + year + ' ' + hour + ':' + min + ':' + sec;
}

app.mount('#app')
