## GitHub Site Policy 
Because these policies and procedures should be open source, too.

### What can I do here?

#### First, you can take and reuse our policies! 

We are proud to offer the policies in this repository under [CC0-1.0](#license). That means that if any of them are useful to you, even in part, you're welcome to use them, without restriction. See the [license section](#license) for use guidelines.

Because we are providing these policies to our community, we believe it is only responsible to also provide the history and insight that a repository of commits, pull requests, and issues can offer. Over time, the repository's commits, pull requests, and issues will allow anyone wanting to use our policies to see the discussions and alterations that have gone into them.

#### Second, you can contribute to making our policies even better.

We host collaborative development on GitHub's site policies, procedures, and guidelines here. That means you’re welcome to provide feedback via a pull request or by opening an issue. When opening an issue, please look over the [Contribution Guidelines](CONTRIBUTING.md). This will help us respond to your concern more quickly.

### That seems like great power! What about the great responsibility?

That's easy: just be responsible. Follow our [Code of Conduct](CODE_OF_CONDUCT.md), and help us maintain a respectful environment for all contributors.

#### There are a few things you should _not_ post in this respository:

- Please don't post legal complaints or ask for technical support. We may not respond to issues promptly. If you need help, [contact Support](https://github.com/contact) and they'll get you an answer.
-	Please avoid hypotheticals. We can't give you legal advice, which means we often can't tell you if a hypothetical situation would or wouldn't be a violation of our policies. We also can't tell you what you should or shouldn't do. We can tell you how we interpret our policies.
- Please don't give other users legal advice, to avoid confusion.

### How often will GitHub review these policies?

We have a semi-annual review and modification process for the policies in this repository. This allows plenty of time for discussion and lets our community rely on our policies. Of course, GitHub may alter our policies outside that schedule if necessary, such as when we have new product releases.

#### What's the process? 

Policies will be open for discussion and feedback throughout the year. You can expect that someone from GitHub's legal department will see your feedback, but we might not respond immediately. If you need an immediate answer on a legal matter, [contact Support](https://github.com/contact).

Every six months, we'll do thorough review of the feedback we have received. If changes are not needed, great! We'll let you know that we're not putting out an update, and we'll close any issues or PRs that are still hanging around. 

If changes to a policy _are_ needed, we will freeze feedback for two weeks. We'll draft changes based on the pull requests and input we've gotten. Then we'll post the updated policy as a pull request, and we'll get your feedback on the pull request. The updated policy will be available here for thirty days before it goes into effect.

For those who are following this repository, the posting of the updated policy will provide a notice of any modifications to the policy.
 
## License
 
[CC0-1.0](LICENSE.md). Note that CC0-1.0 does not grant any trademark permissions.

You're under no legal obligation to do so, but in the spirit of transparency and collaboration these policies are developed and shared with, you're encouraged to:

- Share your adapted policies under CC0-1.0 or other open terms
- Make your adaptations transparent by using a public repo to show changes you've made
- [Let us know](CONTRIBUTING.md#help-wanted) how you're using adapted policies

## The official legal disclaimer part:

- The information in this repository is for informational purposes only and is not intended to convey or constitute legal advice. It is not intended as a solicitation, and your use of this information does not create an attorney-client relationship between you and GitHub. GitHub is not a law firm. (You know that, though, right?)
- These policies and procedures may not suit your organization's needs. Please consult a lawyer if you want to adopt these policies for your own uses.
