---
title: Global Privacy Practices
redirect_from:
 - /eu-safe-harbor/
---

### Privacy Shield Framework

For those located in the European Union, we have applied for certification for the [EU–US Privacy Shield](https://www.privacyshield.gov/) on August 26, 2016, and received our certification on January 26, 2017. You may view it on the [Privacy Shield List](https://www.privacyshield.gov/participant?id=a2zt000000001K2AAI).

The Privacy Shield Framework is based on seven principles, and GitHub complies with them in the following ways:

- **Notice**
  - We let you know when we're collecting your personal information. 
  - We let you know, in our [Privacy Statement](/articles/github-privacy-statement/), what purposes we have for collecting and using your information, who we share that information with and under what restrictions, and what access you have to your data.
  - We let you know that we're participating in the Privacy Shield framework, and what that means to you.
  - We have a {{ site.data.variables.contact.contact_privacy }} where you can contact us with questions about your privacy.  
  - We let you know about your right to invoke binding arbitration, provided at no cost to you, in the unlikely event of a dispute.
  - We let you know that we are subject to the jurisdiction of the Federal Trade Commission. 
- **Choice**
  - We let you choose what happens to your data. Before we use your data for a purpose other than the one for which you gave it to us, we will let you know and get your permission. 
  - We will provide you with reasonable mechanisms to make your choices.
- **Accountability for Onward Transfer**
  - When we transfer your information to third party vendors that are processing it on our behalf, we are only sending your data to third parties, under contract with us, that will safeguard it consistently with our Privacy Statement. When we transfer your data to our vendors under Privacy Shield, we remain responsible for it.
  - We share only the amount of data with our third party vendors as is necessary to complete their transaction.
- **Security**
  - We will protect your personal information with [all reasonable and appropriate security measures](/articles/github-security/). 
- **Data Integrity and Purpose Limitation**
  - We only collect your data for the purposes relevant for providing our services to you. 
  - We collect as little information about you as we can, unless you choose to give us more. 
  - We take reasonable steps to ensure that the data we have about you is accurate, current, and reliable for its intended use.
- **Access**
  - You are always able to access the data we have about you in your [user profile](https://github.com/settings/profile). You may access, update, alter, or delete your information there.
- **Recourse, Enforcement and Liability**
  - If you have questions about our privacy practices, you can reach our with our {{ site.data.variables.contact.contact_privacy }} and we will respond within 45 days at the latest.
  - In the unlikely event of a dispute that we cannot resolve, you have access to binding arbitration at no cost to you. Please see our [Privacy Statement](/articles/github-privacy-statement/) for more information.
  - We will conduct regular audits of our relevant privacy practices to verify compliance with the promises we have made. 
  - We require our employees to respect our privacy promises, and violation of our privacy policies is subject to disciplinary action up to and including termination of employment.

### U.S.–Swiss Safe Harbor Framework

GitHub received [Swiss Safe Harbor](https://build.export.gov/main/safeharbor/swiss/index.asp) Certification on January 28th, 2013, and we continue to maintain our Swiss Safe Harbor certification. Additional information about our Swiss Safe Harbor certification can be found at <https://safeharbor.export.gov/companyinfo.aspx?id=33260>.

In addition, GitHub has never relied solely on our Safe Harbor certification for our data transfers. We also obtain informed consent from our users at the point of data collection, and offer our users control over their own personal data.

Please see our [Privacy Statement](/articles/github-privacy-statement/) for more information.
