---
title: GitHub Business Plan Addendum
---

### Business Plan Addendum

These are the additional terms for GitHub's Business plan ("Business Plan Terms"). Any capitalized terms not defined in these Business Plan Terms will be defined in the [Terms of Service](/articles/github-terms-of-service/) or the [Corporate Terms of Service](/articles/github-corporate-terms-of-service/). By agreeing to these Business Plan Terms, you also agree to the Terms of Service, as determined by the type of account you have.

The Business Plan includes an Organization account, SAML single sign-on, access provisioning, and 24/5 support with an 8-hour response time. This list of features and services is non-exhaustive and may be updated from time to time. For more information, see the [Business Plan page](https://github.com/pricing/business-hosted).

### Definitions:
- Active User: means a user trying to access our Service at the time of an Outage.
- Customer: person or entity who has purchased a Business plan from GitHub.
- Eligible User: means an individual who is designated as a member of the Customer's Business plan organization by having their individual GitHub account associated with the Customer's Business plan account.
- Essential Services: means the services essential to GitHub's core version control functionality, including features and services such as creating, forking, and cloning repositories; creating, committing, and merging branches; creating, reviewing, and merging pull requests; and, web, API, and Git client interfaces to the core Git workflows. The following are examples of peripheral features and services not included: webhooks, Gists, Pages, or email notifications.
- Outage: means the interruption of an Essential Service that affects more than 50% of Active Users.
- Scheduled Downtime: means maintenance or updates to the Service (including to any servers or other hardware required to host the Service), which has been scheduled in advance, during which the Service may be down or inaccessible to Users.
- Service Credit: a dollar credit, calculated as set forth below, that we may credit back to an eligible account.

### Business Plan Uptime SLA

Program Benefits:
- We guarantee that the service will have a quarterly Uptime percentage of 99.95%. That means GitHub's Essential Services will not be interrupted by an Outage affecting more than 50% of Active Users, for more than .05% of the quarter.
- If we don't meet our 99.95% quarterly Uptime guarantee, we may issue Service Credits to Customers.

How do we calculate Uptime?
- Our Uptime calculation is based on the percentage of successful requests we serve through our web, API, and Git client interfaces.

What's excluded from our Uptime guarantee? Outages resulting from:
- Scheduled Downtime
- Customer's acts, omissions, or misuse of the Services, including violations of the Terms of Service.
- Failures of your internet connectivity
- Factors outside our reasonable control, including Internet access related problems, force majeure events, and third party services or technology
- Your equipment, services, or other technology

What are Uptime Service Credits, how can I find out if I have them, and how can I redeem them?
- If GitHub's quarterly Uptime percentage drops below our 99.95% Uptime guarantee, then Customer is entitled to receive 25 times the amount that was paid for the Outage time that exceeds the quarterly Uptime guarantee ("Uptime Service Credit"), which will be applied against the Customer's next bill. Uptime Service Credits are calculated at the end of each quarter, and may only be granted upon request.
- To find out about GitHub's Uptime percentage, you can request an Uptime report at the end of each quarter.
- In order to be granted Uptime Service Credits, either an account Owner or Billing Manager must send in a written request, on Customer's behalf, within 30 days of the end of each quarter. Uptime Service Credits may not be saved. After being granted an Uptime Service Credit, it will be automatically applied to Customer's next bill. Written requests should be sent to {{ site.data.variables.contact.contact_support }}.

**Disclaimer and Limitation of Liability:**
GitHub's [Status Page](https://status.github.com/) is not connected to this Uptime SLA and is not an accurate representation of GitHub's Uptime for the purposes of calculating Uptime Service Credits. Service Credits are limited to 30 days of paid service, per quarter. Service Credits are Customer's only remedy for any failure by GitHub to meet any Uptime obligations as identified in this Addendum.
