# -*- coding: utf-8 -*-
# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
import importlib
import sys


if sys.version_info < (3, 7):
    raise ImportError("This module requires Python 3.7 or later.")


_lazy_type_to_package_map = {
    # Message types
    "ActivityCountryInfo": "google.ads.googleads.v13.common.types.criteria",
    "ActivityIdInfo": "google.ads.googleads.v13.common.types.criteria",
    "ActivityRatingInfo": "google.ads.googleads.v13.common.types.criteria",
    "AdAssetPolicySummary": "google.ads.googleads.v13.common.types.asset_policy",
    "AdDiscoveryCarouselCardAsset": "google.ads.googleads.v13.common.types.ad_asset",
    "AddressInfo": "google.ads.googleads.v13.common.types.criteria",
    "AdImageAsset": "google.ads.googleads.v13.common.types.ad_asset",
    "AdMediaBundleAsset": "google.ads.googleads.v13.common.types.ad_asset",
    "AdScheduleInfo": "google.ads.googleads.v13.common.types.criteria",
    "AdTextAsset": "google.ads.googleads.v13.common.types.ad_asset",
    "AdVideoAsset": "google.ads.googleads.v13.common.types.ad_asset",
    "AffiliateLocationFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "AgeDimension": "google.ads.googleads.v13.common.types.audiences",
    "AgeRangeInfo": "google.ads.googleads.v13.common.types.criteria",
    "AgeSegment": "google.ads.googleads.v13.common.types.audiences",
    "AppAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "AppEngagementAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "AppFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "AppPaymentModelInfo": "google.ads.googleads.v13.common.types.criteria",
    "AppPreRegistrationAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "AssetDisapproved": "google.ads.googleads.v13.common.types.asset_policy",
    "AssetInteractionTarget": "google.ads.googleads.v13.common.types.segments",
    "AssetLinkPrimaryStatusDetails": "google.ads.googleads.v13.common.types.asset_policy",
    "AssetUsage": "google.ads.googleads.v13.common.types.asset_usage",
    "AudienceDimension": "google.ads.googleads.v13.common.types.audiences",
    "AudienceExclusionDimension": "google.ads.googleads.v13.common.types.audiences",
    "AudienceInfo": "google.ads.googleads.v13.common.types.criteria",
    "AudienceSegment": "google.ads.googleads.v13.common.types.audiences",
    "AudienceSegmentDimension": "google.ads.googleads.v13.common.types.audiences",
    "BasicUserListInfo": "google.ads.googleads.v13.common.types.user_lists",
    "BidModifierSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "BidModifierSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "BookOnGoogleAsset": "google.ads.googleads.v13.common.types.asset_types",
    "BudgetCampaignAssociationStatus": "google.ads.googleads.v13.common.types.segments",
    "BudgetSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "BudgetSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "BusinessNameFilter": "google.ads.googleads.v13.common.types.feed_item_set_filter_type_infos",
    "BusinessProfileBusinessNameFilter": "google.ads.googleads.v13.common.types.asset_set_types",
    "BusinessProfileLocation": "google.ads.googleads.v13.common.types.asset_types",
    "BusinessProfileLocationGroup": "google.ads.googleads.v13.common.types.asset_set_types",
    "BusinessProfileLocationSet": "google.ads.googleads.v13.common.types.asset_set_types",
    "CallAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "CallAsset": "google.ads.googleads.v13.common.types.asset_types",
    "CallFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "CalloutAsset": "google.ads.googleads.v13.common.types.asset_types",
    "CalloutFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "CallToActionAsset": "google.ads.googleads.v13.common.types.asset_types",
    "CarrierInfo": "google.ads.googleads.v13.common.types.criteria",
    "ChainFilter": "google.ads.googleads.v13.common.types.asset_set_types",
    "ChainLocationGroup": "google.ads.googleads.v13.common.types.asset_set_types",
    "ChainSet": "google.ads.googleads.v13.common.types.asset_set_types",
    "ClickLocation": "google.ads.googleads.v13.common.types.click_location",
    "CombinedAudienceInfo": "google.ads.googleads.v13.common.types.criteria",
    "Commission": "google.ads.googleads.v13.common.types.bidding",
    "ConceptGroup": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "ContentLabelInfo": "google.ads.googleads.v13.common.types.criteria",
    "CpcBidSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "CpcBidSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "CpvBidSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "CpvBidSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "CriterionCategoryAvailability": "google.ads.googleads.v13.common.types.criterion_category_availability",
    "CriterionCategoryChannelAvailability": "google.ads.googleads.v13.common.types.criterion_category_availability",
    "CriterionCategoryLocaleAvailability": "google.ads.googleads.v13.common.types.criterion_category_availability",
    "CrmBasedUserListInfo": "google.ads.googleads.v13.common.types.user_lists",
    "CustomAffinityInfo": "google.ads.googleads.v13.common.types.criteria",
    "CustomAudienceInfo": "google.ads.googleads.v13.common.types.criteria",
    "CustomAudienceSegment": "google.ads.googleads.v13.common.types.audiences",
    "CustomerMatchUserListMetadata": "google.ads.googleads.v13.common.types.offline_user_data",
    "CustomIntentInfo": "google.ads.googleads.v13.common.types.criteria",
    "CustomizerValue": "google.ads.googleads.v13.common.types.customizer_value",
    "CustomParameter": "google.ads.googleads.v13.common.types.custom_parameter",
    "DateRange": "google.ads.googleads.v13.common.types.dates",
    "DetailedDemographicSegment": "google.ads.googleads.v13.common.types.audiences",
    "DeviceInfo": "google.ads.googleads.v13.common.types.criteria",
    "DiscoveryCarouselAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "DiscoveryCarouselCardAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DiscoveryMultiAssetAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "DisplayUploadAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "DynamicAffiliateLocationSetFilter": "google.ads.googleads.v13.common.types.feed_item_set_filter_type_infos",
    "DynamicBusinessProfileLocationGroupFilter": "google.ads.googleads.v13.common.types.asset_set_types",
    "DynamicCustomAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicEducationAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicFlightsAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicHotelsAndRentalsAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicJobsAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicLocalAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicLocationSetFilter": "google.ads.googleads.v13.common.types.feed_item_set_filter_type_infos",
    "DynamicRealEstateAsset": "google.ads.googleads.v13.common.types.asset_types",
    "DynamicTravelAsset": "google.ads.googleads.v13.common.types.asset_types",
    "EnhancedCpc": "google.ads.googleads.v13.common.types.bidding",
    "EventAttribute": "google.ads.googleads.v13.common.types.offline_user_data",
    "EventItemAttribute": "google.ads.googleads.v13.common.types.offline_user_data",
    "ExclusionSegment": "google.ads.googleads.v13.common.types.audiences",
    "ExpandedDynamicSearchAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "ExpandedTextAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "FinalAppUrl": "google.ads.googleads.v13.common.types.final_app_url",
    "FlexibleRuleOperandInfo": "google.ads.googleads.v13.common.types.user_lists",
    "FlexibleRuleUserListInfo": "google.ads.googleads.v13.common.types.user_lists",
    "FrequencyCapEntry": "google.ads.googleads.v13.common.types.frequency_cap",
    "FrequencyCapKey": "google.ads.googleads.v13.common.types.frequency_cap",
    "GenderDimension": "google.ads.googleads.v13.common.types.audiences",
    "GenderInfo": "google.ads.googleads.v13.common.types.criteria",
    "GeoPointInfo": "google.ads.googleads.v13.common.types.criteria",
    "HistoricalMetricsOptions": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "HotelAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "HotelAdvanceBookingWindowInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelCalloutAsset": "google.ads.googleads.v13.common.types.asset_types",
    "HotelCalloutFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "HotelCheckInDateRangeInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelCheckInDayInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelCityInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelClassInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelCountryRegionInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelDateSelectionTypeInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelIdInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelLengthOfStayInfo": "google.ads.googleads.v13.common.types.criteria",
    "HotelPropertyAsset": "google.ads.googleads.v13.common.types.asset_types",
    "HotelStateInfo": "google.ads.googleads.v13.common.types.criteria",
    "HouseholdIncomeDimension": "google.ads.googleads.v13.common.types.audiences",
    "ImageAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "ImageAsset": "google.ads.googleads.v13.common.types.asset_types",
    "ImageDimension": "google.ads.googleads.v13.common.types.asset_types",
    "ImageFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "IncomeRangeInfo": "google.ads.googleads.v13.common.types.criteria",
    "InFeedVideoAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "InteractionTypeInfo": "google.ads.googleads.v13.common.types.criteria",
    "IpBlockInfo": "google.ads.googleads.v13.common.types.criteria",
    "ItemAttribute": "google.ads.googleads.v13.common.types.offline_user_data",
    "Keyword": "google.ads.googleads.v13.common.types.segments",
    "KeywordAnnotations": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "KeywordConcept": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "KeywordInfo": "google.ads.googleads.v13.common.types.criteria",
    "KeywordPlanAggregateMetricResults": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "KeywordPlanAggregateMetrics": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "KeywordPlanDeviceSearches": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "KeywordPlanHistoricalMetrics": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "KeywordThemeInfo": "google.ads.googleads.v13.common.types.criteria",
    "LanguageInfo": "google.ads.googleads.v13.common.types.criteria",
    "LeadFormAsset": "google.ads.googleads.v13.common.types.asset_types",
    "LeadFormCustomQuestionField": "google.ads.googleads.v13.common.types.asset_types",
    "LeadFormDeliveryMethod": "google.ads.googleads.v13.common.types.asset_types",
    "LeadFormField": "google.ads.googleads.v13.common.types.asset_types",
    "LeadFormSingleChoiceAnswers": "google.ads.googleads.v13.common.types.asset_types",
    "LegacyAppInstallAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "LegacyResponsiveDisplayAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "LifeEventSegment": "google.ads.googleads.v13.common.types.audiences",
    "ListingDimensionInfo": "google.ads.googleads.v13.common.types.criteria",
    "ListingGroupInfo": "google.ads.googleads.v13.common.types.criteria",
    "ListingScopeInfo": "google.ads.googleads.v13.common.types.criteria",
    "LocalAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "LocalServiceIdInfo": "google.ads.googleads.v13.common.types.criteria",
    "LocationAsset": "google.ads.googleads.v13.common.types.asset_types",
    "LocationFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "LocationGroupInfo": "google.ads.googleads.v13.common.types.criteria",
    "LocationInfo": "google.ads.googleads.v13.common.types.criteria",
    "LocationSet": "google.ads.googleads.v13.common.types.asset_set_types",
    "LogicalUserListInfo": "google.ads.googleads.v13.common.types.user_lists",
    "LogicalUserListOperandInfo": "google.ads.googleads.v13.common.types.user_lists",
    "ManualCpa": "google.ads.googleads.v13.common.types.bidding",
    "ManualCpc": "google.ads.googleads.v13.common.types.bidding",
    "ManualCpm": "google.ads.googleads.v13.common.types.bidding",
    "ManualCpv": "google.ads.googleads.v13.common.types.bidding",
    "MapsLocationInfo": "google.ads.googleads.v13.common.types.asset_set_types",
    "MapsLocationSet": "google.ads.googleads.v13.common.types.asset_set_types",
    "MatchingFunction": "google.ads.googleads.v13.common.types.matching_function",
    "MaximizeConversions": "google.ads.googleads.v13.common.types.bidding",
    "MaximizeConversionValue": "google.ads.googleads.v13.common.types.bidding",
    "MediaBundleAsset": "google.ads.googleads.v13.common.types.asset_types",
    "MetricGoal": "google.ads.googleads.v13.common.types.metric_goal",
    "Metrics": "google.ads.googleads.v13.common.types.metrics",
    "MobileAppAsset": "google.ads.googleads.v13.common.types.asset_types",
    "MobileAppCategoryInfo": "google.ads.googleads.v13.common.types.criteria",
    "MobileApplicationInfo": "google.ads.googleads.v13.common.types.criteria",
    "MobileDeviceInfo": "google.ads.googleads.v13.common.types.criteria",
    "Money": "google.ads.googleads.v13.common.types.feed_common",
    "MonthlySearchVolume": "google.ads.googleads.v13.common.types.keyword_plan_common",
    "OfflineUserAddressInfo": "google.ads.googleads.v13.common.types.offline_user_data",
    "Operand": "google.ads.googleads.v13.common.types.matching_function",
    "OperatingSystemVersionInfo": "google.ads.googleads.v13.common.types.criteria",
    "PageFeedAsset": "google.ads.googleads.v13.common.types.asset_types",
    "ParentalStatusDimension": "google.ads.googleads.v13.common.types.audiences",
    "ParentalStatusInfo": "google.ads.googleads.v13.common.types.criteria",
    "PercentCpc": "google.ads.googleads.v13.common.types.bidding",
    "PercentCpcBidSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "PercentCpcBidSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "PlacementInfo": "google.ads.googleads.v13.common.types.criteria",
    "PolicySummary": "google.ads.googleads.v13.common.types.policy_summary",
    "PolicyTopicConstraint": "google.ads.googleads.v13.common.types.policy",
    "PolicyTopicEntry": "google.ads.googleads.v13.common.types.policy",
    "PolicyTopicEvidence": "google.ads.googleads.v13.common.types.policy",
    "PolicyValidationParameter": "google.ads.googleads.v13.common.types.policy",
    "PolicyViolationKey": "google.ads.googleads.v13.common.types.policy",
    "PriceAsset": "google.ads.googleads.v13.common.types.asset_types",
    "PriceFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "PriceOffer": "google.ads.googleads.v13.common.types.extensions",
    "PriceOffering": "google.ads.googleads.v13.common.types.asset_types",
    "ProductBiddingCategoryInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductBrandInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductChannelExclusivityInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductChannelInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductConditionInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductCustomAttributeInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductGroupingInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductItemIdInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductLabelsInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductLegacyConditionInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductTypeFullInfo": "google.ads.googleads.v13.common.types.criteria",
    "ProductTypeInfo": "google.ads.googleads.v13.common.types.criteria",
    "PromotionAsset": "google.ads.googleads.v13.common.types.asset_types",
    "PromotionFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "ProximityInfo": "google.ads.googleads.v13.common.types.criteria",
    "RealTimeBiddingSetting": "google.ads.googleads.v13.common.types.real_time_bidding_setting",
    "ResponsiveDisplayAdControlSpec": "google.ads.googleads.v13.common.types.ad_type_infos",
    "ResponsiveDisplayAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "ResponsiveSearchAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "RuleBasedUserListInfo": "google.ads.googleads.v13.common.types.user_lists",
    "Segments": "google.ads.googleads.v13.common.types.segments",
    "ShoppingComparisonListingAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "ShoppingLoyalty": "google.ads.googleads.v13.common.types.offline_user_data",
    "ShoppingProductAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "ShoppingSmartAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "SimilarUserListInfo": "google.ads.googleads.v13.common.types.user_lists",
    "SitelinkAsset": "google.ads.googleads.v13.common.types.asset_types",
    "SitelinkFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "SkAdNetworkSourceApp": "google.ads.googleads.v13.common.types.segments",
    "SmartCampaignAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "StoreAttribute": "google.ads.googleads.v13.common.types.offline_user_data",
    "StoreSalesMetadata": "google.ads.googleads.v13.common.types.offline_user_data",
    "StoreSalesThirdPartyMetadata": "google.ads.googleads.v13.common.types.offline_user_data",
    "StructuredSnippetAsset": "google.ads.googleads.v13.common.types.asset_types",
    "StructuredSnippetFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "TagSnippet": "google.ads.googleads.v13.common.types.tag_snippet",
    "TargetCpa": "google.ads.googleads.v13.common.types.bidding",
    "TargetCpaSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "TargetCpaSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "TargetCpm": "google.ads.googleads.v13.common.types.bidding",
    "TargetCpmTargetFrequencyGoal": "google.ads.googleads.v13.common.types.bidding",
    "TargetImpressionShare": "google.ads.googleads.v13.common.types.bidding",
    "TargetImpressionShareSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "TargetImpressionShareSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "TargetingSetting": "google.ads.googleads.v13.common.types.targeting_setting",
    "TargetRestriction": "google.ads.googleads.v13.common.types.targeting_setting",
    "TargetRestrictionOperation": "google.ads.googleads.v13.common.types.targeting_setting",
    "TargetRoas": "google.ads.googleads.v13.common.types.bidding",
    "TargetRoasSimulationPoint": "google.ads.googleads.v13.common.types.simulation",
    "TargetRoasSimulationPointList": "google.ads.googleads.v13.common.types.simulation",
    "TargetSpend": "google.ads.googleads.v13.common.types.bidding",
    "TextAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "TextAsset": "google.ads.googleads.v13.common.types.asset_types",
    "TextLabel": "google.ads.googleads.v13.common.types.text_label",
    "TextMessageFeedItem": "google.ads.googleads.v13.common.types.extensions",
    "TopicInfo": "google.ads.googleads.v13.common.types.criteria",
    "TransactionAttribute": "google.ads.googleads.v13.common.types.offline_user_data",
    "TravelAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "UnknownListingDimensionInfo": "google.ads.googleads.v13.common.types.criteria",
    "UrlCollection": "google.ads.googleads.v13.common.types.url_collection",
    "UserAttribute": "google.ads.googleads.v13.common.types.offline_user_data",
    "UserData": "google.ads.googleads.v13.common.types.offline_user_data",
    "UserIdentifier": "google.ads.googleads.v13.common.types.offline_user_data",
    "UserInterestInfo": "google.ads.googleads.v13.common.types.criteria",
    "UserInterestSegment": "google.ads.googleads.v13.common.types.audiences",
    "UserListActionInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListDateRuleItemInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListInfo": "google.ads.googleads.v13.common.types.criteria",
    "UserListLogicalRuleInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListNumberRuleItemInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListRuleInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListRuleItemGroupInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListRuleItemInfo": "google.ads.googleads.v13.common.types.user_lists",
    "UserListSegment": "google.ads.googleads.v13.common.types.audiences",
    "UserListStringRuleItemInfo": "google.ads.googleads.v13.common.types.user_lists",
    "Value": "google.ads.googleads.v13.common.types.value",
    "VideoAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "VideoBumperInStreamAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "VideoNonSkippableInStreamAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "VideoOutstreamAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "VideoResponsiveAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "VideoTrueViewInStreamAdInfo": "google.ads.googleads.v13.common.types.ad_type_infos",
    "WebhookDelivery": "google.ads.googleads.v13.common.types.asset_types",
    "WebpageConditionInfo": "google.ads.googleads.v13.common.types.criteria",
    "WebpageInfo": "google.ads.googleads.v13.common.types.criteria",
    "WebpageSampleInfo": "google.ads.googleads.v13.common.types.criteria",
    "YearMonth": "google.ads.googleads.v13.common.types.dates",
    "YearMonthRange": "google.ads.googleads.v13.common.types.dates",
    "YouTubeChannelInfo": "google.ads.googleads.v13.common.types.criteria",
    "YoutubeVideoAsset": "google.ads.googleads.v13.common.types.asset_types",
    "YouTubeVideoInfo": "google.ads.googleads.v13.common.types.criteria",
    "AccessInvitationStatusEnum": "google.ads.googleads.v13.enums.types.access_invitation_status",
    "AccessReasonEnum": "google.ads.googleads.v13.enums.types.access_reason",
    "AccessRoleEnum": "google.ads.googleads.v13.enums.types.access_role",
    "AccountBudgetProposalStatusEnum": "google.ads.googleads.v13.enums.types.account_budget_proposal_status",
    "AccountBudgetProposalTypeEnum": "google.ads.googleads.v13.enums.types.account_budget_proposal_type",
    "AccountBudgetStatusEnum": "google.ads.googleads.v13.enums.types.account_budget_status",
    "AccountLinkStatusEnum": "google.ads.googleads.v13.enums.types.account_link_status",
    "AdCustomizerPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.ad_customizer_placeholder_field",
    "AdDestinationTypeEnum": "google.ads.googleads.v13.enums.types.ad_destination_type",
    "AdGroupAdRotationModeEnum": "google.ads.googleads.v13.enums.types.ad_group_ad_rotation_mode",
    "AdGroupAdStatusEnum": "google.ads.googleads.v13.enums.types.ad_group_ad_status",
    "AdGroupCriterionApprovalStatusEnum": "google.ads.googleads.v13.enums.types.ad_group_criterion_approval_status",
    "AdGroupCriterionStatusEnum": "google.ads.googleads.v13.enums.types.ad_group_criterion_status",
    "AdGroupStatusEnum": "google.ads.googleads.v13.enums.types.ad_group_status",
    "AdGroupTypeEnum": "google.ads.googleads.v13.enums.types.ad_group_type",
    "AdNetworkTypeEnum": "google.ads.googleads.v13.enums.types.ad_network_type",
    "AdServingOptimizationStatusEnum": "google.ads.googleads.v13.enums.types.ad_serving_optimization_status",
    "AdStrengthEnum": "google.ads.googleads.v13.enums.types.ad_strength",
    "AdTypeEnum": "google.ads.googleads.v13.enums.types.ad_type",
    "AdvertisingChannelSubTypeEnum": "google.ads.googleads.v13.enums.types.advertising_channel_sub_type",
    "AdvertisingChannelTypeEnum": "google.ads.googleads.v13.enums.types.advertising_channel_type",
    "AffiliateLocationFeedRelationshipTypeEnum": "google.ads.googleads.v13.enums.types.affiliate_location_feed_relationship_type",
    "AffiliateLocationPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.affiliate_location_placeholder_field",
    "AgeRangeTypeEnum": "google.ads.googleads.v13.enums.types.age_range_type",
    "AppCampaignAppStoreEnum": "google.ads.googleads.v13.enums.types.app_campaign_app_store",
    "AppCampaignBiddingStrategyGoalTypeEnum": "google.ads.googleads.v13.enums.types.app_campaign_bidding_strategy_goal_type",
    "AppPaymentModelTypeEnum": "google.ads.googleads.v13.enums.types.app_payment_model_type",
    "AppPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.app_placeholder_field",
    "AppStoreEnum": "google.ads.googleads.v13.enums.types.app_store",
    "AppUrlOperatingSystemTypeEnum": "google.ads.googleads.v13.enums.types.app_url_operating_system_type",
    "AssetFieldTypeEnum": "google.ads.googleads.v13.enums.types.asset_field_type",
    "AssetGroupStatusEnum": "google.ads.googleads.v13.enums.types.asset_group_status",
    "AssetLinkPrimaryStatusEnum": "google.ads.googleads.v13.enums.types.asset_link_primary_status",
    "AssetLinkPrimaryStatusReasonEnum": "google.ads.googleads.v13.enums.types.asset_link_primary_status_reason",
    "AssetLinkStatusEnum": "google.ads.googleads.v13.enums.types.asset_link_status",
    "AssetOfflineEvaluationErrorReasonsEnum": "google.ads.googleads.v13.enums.types.asset_offline_evaluation_error_reasons",
    "AssetPerformanceLabelEnum": "google.ads.googleads.v13.enums.types.asset_performance_label",
    "AssetSetAssetStatusEnum": "google.ads.googleads.v13.enums.types.asset_set_asset_status",
    "AssetSetLinkStatusEnum": "google.ads.googleads.v13.enums.types.asset_set_link_status",
    "AssetSetStatusEnum": "google.ads.googleads.v13.enums.types.asset_set_status",
    "AssetSetTypeEnum": "google.ads.googleads.v13.enums.types.asset_set_type",
    "AssetSourceEnum": "google.ads.googleads.v13.enums.types.asset_source",
    "AssetTypeEnum": "google.ads.googleads.v13.enums.types.asset_type",
    "AsyncActionStatusEnum": "google.ads.googleads.v13.enums.types.async_action_status",
    "AttributionModelEnum": "google.ads.googleads.v13.enums.types.attribution_model",
    "AudienceInsightsDimensionEnum": "google.ads.googleads.v13.enums.types.audience_insights_dimension",
    "AudienceStatusEnum": "google.ads.googleads.v13.enums.types.audience_status",
    "BatchJobStatusEnum": "google.ads.googleads.v13.enums.types.batch_job_status",
    "BiddingSourceEnum": "google.ads.googleads.v13.enums.types.bidding_source",
    "BiddingStrategyStatusEnum": "google.ads.googleads.v13.enums.types.bidding_strategy_status",
    "BiddingStrategySystemStatusEnum": "google.ads.googleads.v13.enums.types.bidding_strategy_system_status",
    "BiddingStrategyTypeEnum": "google.ads.googleads.v13.enums.types.bidding_strategy_type",
    "BidModifierSourceEnum": "google.ads.googleads.v13.enums.types.bid_modifier_source",
    "BillingSetupStatusEnum": "google.ads.googleads.v13.enums.types.billing_setup_status",
    "BrandSafetySuitabilityEnum": "google.ads.googleads.v13.enums.types.brand_safety_suitability",
    "BudgetCampaignAssociationStatusEnum": "google.ads.googleads.v13.enums.types.budget_campaign_association_status",
    "BudgetDeliveryMethodEnum": "google.ads.googleads.v13.enums.types.budget_delivery_method",
    "BudgetPeriodEnum": "google.ads.googleads.v13.enums.types.budget_period",
    "BudgetStatusEnum": "google.ads.googleads.v13.enums.types.budget_status",
    "BudgetTypeEnum": "google.ads.googleads.v13.enums.types.budget_type",
    "CallConversionReportingStateEnum": "google.ads.googleads.v13.enums.types.call_conversion_reporting_state",
    "CalloutPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.callout_placeholder_field",
    "CallPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.call_placeholder_field",
    "CallToActionTypeEnum": "google.ads.googleads.v13.enums.types.call_to_action_type",
    "CallTrackingDisplayLocationEnum": "google.ads.googleads.v13.enums.types.call_tracking_display_location",
    "CallTypeEnum": "google.ads.googleads.v13.enums.types.call_type",
    "CampaignCriterionStatusEnum": "google.ads.googleads.v13.enums.types.campaign_criterion_status",
    "CampaignDraftStatusEnum": "google.ads.googleads.v13.enums.types.campaign_draft_status",
    "CampaignExperimentTypeEnum": "google.ads.googleads.v13.enums.types.campaign_experiment_type",
    "CampaignGroupStatusEnum": "google.ads.googleads.v13.enums.types.campaign_group_status",
    "CampaignPrimaryStatusEnum": "google.ads.googleads.v13.enums.types.campaign_primary_status",
    "CampaignPrimaryStatusReasonEnum": "google.ads.googleads.v13.enums.types.campaign_primary_status_reason",
    "CampaignServingStatusEnum": "google.ads.googleads.v13.enums.types.campaign_serving_status",
    "CampaignSharedSetStatusEnum": "google.ads.googleads.v13.enums.types.campaign_shared_set_status",
    "CampaignStatusEnum": "google.ads.googleads.v13.enums.types.campaign_status",
    "ChainRelationshipTypeEnum": "google.ads.googleads.v13.enums.types.chain_relationship_type",
    "ChangeClientTypeEnum": "google.ads.googleads.v13.enums.types.change_client_type",
    "ChangeEventResourceTypeEnum": "google.ads.googleads.v13.enums.types.change_event_resource_type",
    "ChangeStatusOperationEnum": "google.ads.googleads.v13.enums.types.change_status_operation",
    "ChangeStatusResourceTypeEnum": "google.ads.googleads.v13.enums.types.change_status_resource_type",
    "ClickTypeEnum": "google.ads.googleads.v13.enums.types.click_type",
    "CombinedAudienceStatusEnum": "google.ads.googleads.v13.enums.types.combined_audience_status",
    "ContentLabelTypeEnum": "google.ads.googleads.v13.enums.types.content_label_type",
    "ConversionActionCategoryEnum": "google.ads.googleads.v13.enums.types.conversion_action_category",
    "ConversionActionCountingTypeEnum": "google.ads.googleads.v13.enums.types.conversion_action_counting_type",
    "ConversionActionStatusEnum": "google.ads.googleads.v13.enums.types.conversion_action_status",
    "ConversionActionTypeEnum": "google.ads.googleads.v13.enums.types.conversion_action_type",
    "ConversionAdjustmentTypeEnum": "google.ads.googleads.v13.enums.types.conversion_adjustment_type",
    "ConversionAttributionEventTypeEnum": "google.ads.googleads.v13.enums.types.conversion_attribution_event_type",
    "ConversionCustomVariableStatusEnum": "google.ads.googleads.v13.enums.types.conversion_custom_variable_status",
    "ConversionEnvironmentEnum": "google.ads.googleads.v13.enums.types.conversion_environment_enum",
    "ConversionLagBucketEnum": "google.ads.googleads.v13.enums.types.conversion_lag_bucket",
    "ConversionOrAdjustmentLagBucketEnum": "google.ads.googleads.v13.enums.types.conversion_or_adjustment_lag_bucket",
    "ConversionOriginEnum": "google.ads.googleads.v13.enums.types.conversion_origin",
    "ConversionTrackingStatusEnum": "google.ads.googleads.v13.enums.types.conversion_tracking_status_enum",
    "ConversionValueRulePrimaryDimensionEnum": "google.ads.googleads.v13.enums.types.conversion_value_rule_primary_dimension",
    "ConversionValueRuleSetStatusEnum": "google.ads.googleads.v13.enums.types.conversion_value_rule_set_status",
    "ConversionValueRuleStatusEnum": "google.ads.googleads.v13.enums.types.conversion_value_rule_status",
    "CriterionCategoryChannelAvailabilityModeEnum": "google.ads.googleads.v13.enums.types.criterion_category_channel_availability_mode",
    "CriterionCategoryLocaleAvailabilityModeEnum": "google.ads.googleads.v13.enums.types.criterion_category_locale_availability_mode",
    "CriterionSystemServingStatusEnum": "google.ads.googleads.v13.enums.types.criterion_system_serving_status",
    "CriterionTypeEnum": "google.ads.googleads.v13.enums.types.criterion_type",
    "CustomAudienceMemberTypeEnum": "google.ads.googleads.v13.enums.types.custom_audience_member_type",
    "CustomAudienceStatusEnum": "google.ads.googleads.v13.enums.types.custom_audience_status",
    "CustomAudienceTypeEnum": "google.ads.googleads.v13.enums.types.custom_audience_type",
    "CustomConversionGoalStatusEnum": "google.ads.googleads.v13.enums.types.custom_conversion_goal_status",
    "CustomerMatchUploadKeyTypeEnum": "google.ads.googleads.v13.enums.types.customer_match_upload_key_type",
    "CustomerPayPerConversionEligibilityFailureReasonEnum": "google.ads.googleads.v13.enums.types.customer_pay_per_conversion_eligibility_failure_reason",
    "CustomerStatusEnum": "google.ads.googleads.v13.enums.types.customer_status",
    "CustomInterestMemberTypeEnum": "google.ads.googleads.v13.enums.types.custom_interest_member_type",
    "CustomInterestStatusEnum": "google.ads.googleads.v13.enums.types.custom_interest_status",
    "CustomInterestTypeEnum": "google.ads.googleads.v13.enums.types.custom_interest_type",
    "CustomizerAttributeStatusEnum": "google.ads.googleads.v13.enums.types.customizer_attribute_status",
    "CustomizerAttributeTypeEnum": "google.ads.googleads.v13.enums.types.customizer_attribute_type",
    "CustomizerValueStatusEnum": "google.ads.googleads.v13.enums.types.customizer_value_status",
    "CustomPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.custom_placeholder_field",
    "DataDrivenModelStatusEnum": "google.ads.googleads.v13.enums.types.data_driven_model_status",
    "DayOfWeekEnum": "google.ads.googleads.v13.enums.types.day_of_week",
    "DeviceEnum": "google.ads.googleads.v13.enums.types.device",
    "DisplayAdFormatSettingEnum": "google.ads.googleads.v13.enums.types.display_ad_format_setting",
    "DisplayUploadProductTypeEnum": "google.ads.googleads.v13.enums.types.display_upload_product_type",
    "DistanceBucketEnum": "google.ads.googleads.v13.enums.types.distance_bucket",
    "DsaPageFeedCriterionFieldEnum": "google.ads.googleads.v13.enums.types.dsa_page_feed_criterion_field",
    "EducationPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.education_placeholder_field",
    "ExperimentMetricDirectionEnum": "google.ads.googleads.v13.enums.types.experiment_metric_direction",
    "ExperimentMetricEnum": "google.ads.googleads.v13.enums.types.experiment_metric",
    "ExperimentStatusEnum": "google.ads.googleads.v13.enums.types.experiment_status",
    "ExperimentTypeEnum": "google.ads.googleads.v13.enums.types.experiment_type",
    "ExtensionSettingDeviceEnum": "google.ads.googleads.v13.enums.types.extension_setting_device",
    "ExtensionTypeEnum": "google.ads.googleads.v13.enums.types.extension_type",
    "ExternalConversionSourceEnum": "google.ads.googleads.v13.enums.types.external_conversion_source",
    "FeedAttributeTypeEnum": "google.ads.googleads.v13.enums.types.feed_attribute_type",
    "FeedItemQualityApprovalStatusEnum": "google.ads.googleads.v13.enums.types.feed_item_quality_approval_status",
    "FeedItemQualityDisapprovalReasonEnum": "google.ads.googleads.v13.enums.types.feed_item_quality_disapproval_reason",
    "FeedItemSetStatusEnum": "google.ads.googleads.v13.enums.types.feed_item_set_status",
    "FeedItemSetStringFilterTypeEnum": "google.ads.googleads.v13.enums.types.feed_item_set_string_filter_type",
    "FeedItemStatusEnum": "google.ads.googleads.v13.enums.types.feed_item_status",
    "FeedItemTargetDeviceEnum": "google.ads.googleads.v13.enums.types.feed_item_target_device",
    "FeedItemTargetStatusEnum": "google.ads.googleads.v13.enums.types.feed_item_target_status",
    "FeedItemTargetTypeEnum": "google.ads.googleads.v13.enums.types.feed_item_target_type",
    "FeedItemValidationStatusEnum": "google.ads.googleads.v13.enums.types.feed_item_validation_status",
    "FeedLinkStatusEnum": "google.ads.googleads.v13.enums.types.feed_link_status",
    "FeedMappingCriterionTypeEnum": "google.ads.googleads.v13.enums.types.feed_mapping_criterion_type",
    "FeedMappingStatusEnum": "google.ads.googleads.v13.enums.types.feed_mapping_status",
    "FeedOriginEnum": "google.ads.googleads.v13.enums.types.feed_origin",
    "FeedStatusEnum": "google.ads.googleads.v13.enums.types.feed_status",
    "FlightPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.flight_placeholder_field",
    "FrequencyCapEventTypeEnum": "google.ads.googleads.v13.enums.types.frequency_cap_event_type",
    "FrequencyCapLevelEnum": "google.ads.googleads.v13.enums.types.frequency_cap_level",
    "FrequencyCapTimeUnitEnum": "google.ads.googleads.v13.enums.types.frequency_cap_time_unit",
    "GenderTypeEnum": "google.ads.googleads.v13.enums.types.gender_type",
    "GeoTargetConstantStatusEnum": "google.ads.googleads.v13.enums.types.geo_target_constant_status",
    "GeoTargetingRestrictionEnum": "google.ads.googleads.v13.enums.types.geo_targeting_restriction",
    "GeoTargetingTypeEnum": "google.ads.googleads.v13.enums.types.geo_targeting_type",
    "GoalConfigLevelEnum": "google.ads.googleads.v13.enums.types.goal_config_level",
    "GoogleAdsFieldCategoryEnum": "google.ads.googleads.v13.enums.types.google_ads_field_category",
    "GoogleAdsFieldDataTypeEnum": "google.ads.googleads.v13.enums.types.google_ads_field_data_type",
    "GoogleVoiceCallStatusEnum": "google.ads.googleads.v13.enums.types.google_voice_call_status",
    "HotelAssetSuggestionStatusEnum": "google.ads.googleads.v13.enums.types.hotel_asset_suggestion_status",
    "HotelDateSelectionTypeEnum": "google.ads.googleads.v13.enums.types.hotel_date_selection_type",
    "HotelPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.hotel_placeholder_field",
    "HotelPriceBucketEnum": "google.ads.googleads.v13.enums.types.hotel_price_bucket",
    "HotelRateTypeEnum": "google.ads.googleads.v13.enums.types.hotel_rate_type",
    "HotelReconciliationStatusEnum": "google.ads.googleads.v13.enums.types.hotel_reconciliation_status",
    "ImagePlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.image_placeholder_field",
    "IncomeRangeTypeEnum": "google.ads.googleads.v13.enums.types.income_range_type",
    "InteractionEventTypeEnum": "google.ads.googleads.v13.enums.types.interaction_event_type",
    "InteractionTypeEnum": "google.ads.googleads.v13.enums.types.interaction_type",
    "InvoiceTypeEnum": "google.ads.googleads.v13.enums.types.invoice_type",
    "JobPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.job_placeholder_field",
    "KeywordMatchTypeEnum": "google.ads.googleads.v13.enums.types.keyword_match_type",
    "KeywordPlanAggregateMetricTypeEnum": "google.ads.googleads.v13.enums.types.keyword_plan_aggregate_metric_type",
    "KeywordPlanCompetitionLevelEnum": "google.ads.googleads.v13.enums.types.keyword_plan_competition_level",
    "KeywordPlanConceptGroupTypeEnum": "google.ads.googleads.v13.enums.types.keyword_plan_concept_group_type",
    "KeywordPlanForecastIntervalEnum": "google.ads.googleads.v13.enums.types.keyword_plan_forecast_interval",
    "KeywordPlanKeywordAnnotationEnum": "google.ads.googleads.v13.enums.types.keyword_plan_keyword_annotation",
    "KeywordPlanNetworkEnum": "google.ads.googleads.v13.enums.types.keyword_plan_network",
    "LabelStatusEnum": "google.ads.googleads.v13.enums.types.label_status",
    "LeadFormCallToActionTypeEnum": "google.ads.googleads.v13.enums.types.lead_form_call_to_action_type",
    "LeadFormDesiredIntentEnum": "google.ads.googleads.v13.enums.types.lead_form_desired_intent",
    "LeadFormFieldUserInputTypeEnum": "google.ads.googleads.v13.enums.types.lead_form_field_user_input_type",
    "LeadFormPostSubmitCallToActionTypeEnum": "google.ads.googleads.v13.enums.types.lead_form_post_submit_call_to_action_type",
    "LegacyAppInstallAdAppStoreEnum": "google.ads.googleads.v13.enums.types.legacy_app_install_ad_app_store",
    "LinkedAccountTypeEnum": "google.ads.googleads.v13.enums.types.linked_account_type",
    "LinkedProductTypeEnum": "google.ads.googleads.v13.enums.types.linked_product_type",
    "ListingGroupFilterBiddingCategoryLevelEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_bidding_category_level",
    "ListingGroupFilterCustomAttributeIndexEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_custom_attribute_index",
    "ListingGroupFilterProductChannelEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_product_channel",
    "ListingGroupFilterProductConditionEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_product_condition",
    "ListingGroupFilterProductTypeLevelEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_product_type_level",
    "ListingGroupFilterTypeEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_type_enum",
    "ListingGroupFilterVerticalEnum": "google.ads.googleads.v13.enums.types.listing_group_filter_vertical",
    "ListingGroupTypeEnum": "google.ads.googleads.v13.enums.types.listing_group_type",
    "LocalPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.local_placeholder_field",
    "LocationExtensionTargetingCriterionFieldEnum": "google.ads.googleads.v13.enums.types.location_extension_targeting_criterion_field",
    "LocationGroupRadiusUnitsEnum": "google.ads.googleads.v13.enums.types.location_group_radius_units",
    "LocationOwnershipTypeEnum": "google.ads.googleads.v13.enums.types.location_ownership_type",
    "LocationPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.location_placeholder_field",
    "LocationSourceTypeEnum": "google.ads.googleads.v13.enums.types.location_source_type",
    "LocationStringFilterTypeEnum": "google.ads.googleads.v13.enums.types.location_string_filter_type",
    "ManagerLinkStatusEnum": "google.ads.googleads.v13.enums.types.manager_link_status",
    "MatchingFunctionContextTypeEnum": "google.ads.googleads.v13.enums.types.matching_function_context_type",
    "MatchingFunctionOperatorEnum": "google.ads.googleads.v13.enums.types.matching_function_operator",
    "MediaTypeEnum": "google.ads.googleads.v13.enums.types.media_type",
    "MerchantCenterLinkStatusEnum": "google.ads.googleads.v13.enums.types.merchant_center_link_status",
    "MessagePlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.message_placeholder_field",
    "MimeTypeEnum": "google.ads.googleads.v13.enums.types.mime_type",
    "MinuteOfHourEnum": "google.ads.googleads.v13.enums.types.minute_of_hour",
    "MobileAppVendorEnum": "google.ads.googleads.v13.enums.types.mobile_app_vendor",
    "MobileDeviceTypeEnum": "google.ads.googleads.v13.enums.types.mobile_device_type",
    "MonthOfYearEnum": "google.ads.googleads.v13.enums.types.month_of_year",
    "NegativeGeoTargetTypeEnum": "google.ads.googleads.v13.enums.types.negative_geo_target_type",
    "OfflineUserDataJobFailureReasonEnum": "google.ads.googleads.v13.enums.types.offline_user_data_job_failure_reason",
    "OfflineUserDataJobMatchRateRangeEnum": "google.ads.googleads.v13.enums.types.offline_user_data_job_match_rate_range",
    "OfflineUserDataJobStatusEnum": "google.ads.googleads.v13.enums.types.offline_user_data_job_status",
    "OfflineUserDataJobTypeEnum": "google.ads.googleads.v13.enums.types.offline_user_data_job_type",
    "OperatingSystemVersionOperatorTypeEnum": "google.ads.googleads.v13.enums.types.operating_system_version_operator_type",
    "OptimizationGoalTypeEnum": "google.ads.googleads.v13.enums.types.optimization_goal_type",
    "ParentalStatusTypeEnum": "google.ads.googleads.v13.enums.types.parental_status_type",
    "PaymentModeEnum": "google.ads.googleads.v13.enums.types.payment_mode",
    "PerformanceMaxUpgradeStatusEnum": "google.ads.googleads.v13.enums.types.performance_max_upgrade_status",
    "PlaceholderTypeEnum": "google.ads.googleads.v13.enums.types.placeholder_type",
    "PlacementTypeEnum": "google.ads.googleads.v13.enums.types.placement_type",
    "PolicyApprovalStatusEnum": "google.ads.googleads.v13.enums.types.policy_approval_status",
    "PolicyReviewStatusEnum": "google.ads.googleads.v13.enums.types.policy_review_status",
    "PolicyTopicEntryTypeEnum": "google.ads.googleads.v13.enums.types.policy_topic_entry_type",
    "PolicyTopicEvidenceDestinationMismatchUrlTypeEnum": "google.ads.googleads.v13.enums.types.policy_topic_evidence_destination_mismatch_url_type",
    "PolicyTopicEvidenceDestinationNotWorkingDeviceEnum": "google.ads.googleads.v13.enums.types.policy_topic_evidence_destination_not_working_device",
    "PolicyTopicEvidenceDestinationNotWorkingDnsErrorTypeEnum": "google.ads.googleads.v13.enums.types.policy_topic_evidence_destination_not_working_dns_error_type",
    "PositiveGeoTargetTypeEnum": "google.ads.googleads.v13.enums.types.positive_geo_target_type",
    "PriceExtensionPriceQualifierEnum": "google.ads.googleads.v13.enums.types.price_extension_price_qualifier",
    "PriceExtensionPriceUnitEnum": "google.ads.googleads.v13.enums.types.price_extension_price_unit",
    "PriceExtensionTypeEnum": "google.ads.googleads.v13.enums.types.price_extension_type",
    "PricePlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.price_placeholder_field",
    "ProductBiddingCategoryLevelEnum": "google.ads.googleads.v13.enums.types.product_bidding_category_level",
    "ProductBiddingCategoryStatusEnum": "google.ads.googleads.v13.enums.types.product_bidding_category_status",
    "ProductChannelEnum": "google.ads.googleads.v13.enums.types.product_channel",
    "ProductChannelExclusivityEnum": "google.ads.googleads.v13.enums.types.product_channel_exclusivity",
    "ProductConditionEnum": "google.ads.googleads.v13.enums.types.product_condition",
    "ProductCustomAttributeIndexEnum": "google.ads.googleads.v13.enums.types.product_custom_attribute_index",
    "ProductTypeLevelEnum": "google.ads.googleads.v13.enums.types.product_type_level",
    "PromotionExtensionDiscountModifierEnum": "google.ads.googleads.v13.enums.types.promotion_extension_discount_modifier",
    "PromotionExtensionOccasionEnum": "google.ads.googleads.v13.enums.types.promotion_extension_occasion",
    "PromotionPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.promotion_placeholder_field",
    "ProximityRadiusUnitsEnum": "google.ads.googleads.v13.enums.types.proximity_radius_units",
    "QualityScoreBucketEnum": "google.ads.googleads.v13.enums.types.quality_score_bucket",
    "ReachPlanAgeRangeEnum": "google.ads.googleads.v13.enums.types.reach_plan_age_range",
    "ReachPlanNetworkEnum": "google.ads.googleads.v13.enums.types.reach_plan_network",
    "RealEstatePlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.real_estate_placeholder_field",
    "RecommendationTypeEnum": "google.ads.googleads.v13.enums.types.recommendation_type",
    "ResourceChangeOperationEnum": "google.ads.googleads.v13.enums.types.resource_change_operation",
    "ResourceLimitTypeEnum": "google.ads.googleads.v13.enums.types.resource_limit_type",
    "ResponseContentTypeEnum": "google.ads.googleads.v13.enums.types.response_content_type",
    "SearchEngineResultsPageTypeEnum": "google.ads.googleads.v13.enums.types.search_engine_results_page_type",
    "SearchTermMatchTypeEnum": "google.ads.googleads.v13.enums.types.search_term_match_type",
    "SearchTermTargetingStatusEnum": "google.ads.googleads.v13.enums.types.search_term_targeting_status",
    "SeasonalityEventScopeEnum": "google.ads.googleads.v13.enums.types.seasonality_event_scope",
    "SeasonalityEventStatusEnum": "google.ads.googleads.v13.enums.types.seasonality_event_status",
    "ServedAssetFieldTypeEnum": "google.ads.googleads.v13.enums.types.served_asset_field_type",
    "SharedSetStatusEnum": "google.ads.googleads.v13.enums.types.shared_set_status",
    "SharedSetTypeEnum": "google.ads.googleads.v13.enums.types.shared_set_type",
    "SimulationModificationMethodEnum": "google.ads.googleads.v13.enums.types.simulation_modification_method",
    "SimulationTypeEnum": "google.ads.googleads.v13.enums.types.simulation_type",
    "SitelinkPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.sitelink_placeholder_field",
    "SkAdNetworkAdEventTypeEnum": "google.ads.googleads.v13.enums.types.sk_ad_network_ad_event_type",
    "SkAdNetworkAttributionCreditEnum": "google.ads.googleads.v13.enums.types.sk_ad_network_attribution_credit",
    "SkAdNetworkUserTypeEnum": "google.ads.googleads.v13.enums.types.sk_ad_network_user_type",
    "SlotEnum": "google.ads.googleads.v13.enums.types.slot",
    "SmartCampaignNotEligibleReasonEnum": "google.ads.googleads.v13.enums.types.smart_campaign_not_eligible_reason",
    "SmartCampaignStatusEnum": "google.ads.googleads.v13.enums.types.smart_campaign_status",
    "SpendingLimitTypeEnum": "google.ads.googleads.v13.enums.types.spending_limit_type",
    "StructuredSnippetPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.structured_snippet_placeholder_field",
    "SummaryRowSettingEnum": "google.ads.googleads.v13.enums.types.summary_row_setting",
    "SystemManagedResourceSourceEnum": "google.ads.googleads.v13.enums.types.system_managed_entity_source",
    "TargetCpaOptInRecommendationGoalEnum": "google.ads.googleads.v13.enums.types.target_cpa_opt_in_recommendation_goal",
    "TargetFrequencyTimeUnitEnum": "google.ads.googleads.v13.enums.types.target_frequency_time_unit",
    "TargetImpressionShareLocationEnum": "google.ads.googleads.v13.enums.types.target_impression_share_location",
    "TargetingDimensionEnum": "google.ads.googleads.v13.enums.types.targeting_dimension",
    "TimeTypeEnum": "google.ads.googleads.v13.enums.types.time_type",
    "TrackingCodePageFormatEnum": "google.ads.googleads.v13.enums.types.tracking_code_page_format",
    "TrackingCodeTypeEnum": "google.ads.googleads.v13.enums.types.tracking_code_type",
    "TravelPlaceholderFieldEnum": "google.ads.googleads.v13.enums.types.travel_placeholder_field",
    "UserIdentifierSourceEnum": "google.ads.googleads.v13.enums.types.user_identifier_source",
    "UserInterestTaxonomyTypeEnum": "google.ads.googleads.v13.enums.types.user_interest_taxonomy_type",
    "UserListAccessStatusEnum": "google.ads.googleads.v13.enums.types.user_list_access_status",
    "UserListClosingReasonEnum": "google.ads.googleads.v13.enums.types.user_list_closing_reason",
    "UserListCrmDataSourceTypeEnum": "google.ads.googleads.v13.enums.types.user_list_crm_data_source_type",
    "UserListDateRuleItemOperatorEnum": "google.ads.googleads.v13.enums.types.user_list_date_rule_item_operator",
    "UserListFlexibleRuleOperatorEnum": "google.ads.googleads.v13.enums.types.user_list_flexible_rule_operator",
    "UserListLogicalRuleOperatorEnum": "google.ads.googleads.v13.enums.types.user_list_logical_rule_operator",
    "UserListMembershipStatusEnum": "google.ads.googleads.v13.enums.types.user_list_membership_status",
    "UserListNumberRuleItemOperatorEnum": "google.ads.googleads.v13.enums.types.user_list_number_rule_item_operator",
    "UserListPrepopulationStatusEnum": "google.ads.googleads.v13.enums.types.user_list_prepopulation_status",
    "UserListRuleTypeEnum": "google.ads.googleads.v13.enums.types.user_list_rule_type",
    "UserListSizeRangeEnum": "google.ads.googleads.v13.enums.types.user_list_size_range",
    "UserListStringRuleItemOperatorEnum": "google.ads.googleads.v13.enums.types.user_list_string_rule_item_operator",
    "UserListTypeEnum": "google.ads.googleads.v13.enums.types.user_list_type",
    "ValueRuleDeviceTypeEnum": "google.ads.googleads.v13.enums.types.value_rule_device_type",
    "ValueRuleGeoLocationMatchTypeEnum": "google.ads.googleads.v13.enums.types.value_rule_geo_location_match_type",
    "ValueRuleOperationEnum": "google.ads.googleads.v13.enums.types.value_rule_operation",
    "ValueRuleSetAttachmentTypeEnum": "google.ads.googleads.v13.enums.types.value_rule_set_attachment_type",
    "ValueRuleSetDimensionEnum": "google.ads.googleads.v13.enums.types.value_rule_set_dimension",
    "VanityPharmaDisplayUrlModeEnum": "google.ads.googleads.v13.enums.types.vanity_pharma_display_url_mode",
    "VanityPharmaTextEnum": "google.ads.googleads.v13.enums.types.vanity_pharma_text",
    "VideoThumbnailEnum": "google.ads.googleads.v13.enums.types.video_thumbnail",
    "WebpageConditionOperandEnum": "google.ads.googleads.v13.enums.types.webpage_condition_operand",
    "WebpageConditionOperatorEnum": "google.ads.googleads.v13.enums.types.webpage_condition_operator",
    "AccessInvitationErrorEnum": "google.ads.googleads.v13.errors.types.access_invitation_error",
    "AccountBudgetProposalErrorEnum": "google.ads.googleads.v13.errors.types.account_budget_proposal_error",
    "AccountLinkErrorEnum": "google.ads.googleads.v13.errors.types.account_link_error",
    "AdCustomizerErrorEnum": "google.ads.googleads.v13.errors.types.ad_customizer_error",
    "AdErrorEnum": "google.ads.googleads.v13.errors.types.ad_error",
    "AdGroupAdErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_ad_error",
    "AdGroupBidModifierErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_bid_modifier_error",
    "AdGroupCriterionCustomizerErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_criterion_customizer_error",
    "AdGroupCriterionErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_criterion_error",
    "AdGroupCustomizerErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_customizer_error",
    "AdGroupErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_error",
    "AdGroupFeedErrorEnum": "google.ads.googleads.v13.errors.types.ad_group_feed_error",
    "AdParameterErrorEnum": "google.ads.googleads.v13.errors.types.ad_parameter_error",
    "AdSharingErrorEnum": "google.ads.googleads.v13.errors.types.ad_sharing_error",
    "AdxErrorEnum": "google.ads.googleads.v13.errors.types.adx_error",
    "AssetErrorEnum": "google.ads.googleads.v13.errors.types.asset_error",
    "AssetGroupAssetErrorEnum": "google.ads.googleads.v13.errors.types.asset_group_asset_error",
    "AssetGroupErrorEnum": "google.ads.googleads.v13.errors.types.asset_group_error",
    "AssetGroupListingGroupFilterErrorEnum": "google.ads.googleads.v13.errors.types.asset_group_listing_group_filter_error",
    "AssetLinkErrorEnum": "google.ads.googleads.v13.errors.types.asset_link_error",
    "AssetSetAssetErrorEnum": "google.ads.googleads.v13.errors.types.asset_set_asset_error",
    "AssetSetErrorEnum": "google.ads.googleads.v13.errors.types.asset_set_error",
    "AssetSetLinkErrorEnum": "google.ads.googleads.v13.errors.types.asset_set_link_error",
    "AudienceErrorEnum": "google.ads.googleads.v13.errors.types.audience_error",
    "AudienceInsightsErrorEnum": "google.ads.googleads.v13.errors.types.audience_insights_error",
    "AuthenticationErrorEnum": "google.ads.googleads.v13.errors.types.authentication_error",
    "AuthorizationErrorEnum": "google.ads.googleads.v13.errors.types.authorization_error",
    "BatchJobErrorEnum": "google.ads.googleads.v13.errors.types.batch_job_error",
    "BiddingErrorEnum": "google.ads.googleads.v13.errors.types.bidding_error",
    "BiddingStrategyErrorEnum": "google.ads.googleads.v13.errors.types.bidding_strategy_error",
    "BillingSetupErrorEnum": "google.ads.googleads.v13.errors.types.billing_setup_error",
    "CampaignBudgetErrorEnum": "google.ads.googleads.v13.errors.types.campaign_budget_error",
    "CampaignConversionGoalErrorEnum": "google.ads.googleads.v13.errors.types.campaign_conversion_goal_error",
    "CampaignCriterionErrorEnum": "google.ads.googleads.v13.errors.types.campaign_criterion_error",
    "CampaignCustomizerErrorEnum": "google.ads.googleads.v13.errors.types.campaign_customizer_error",
    "CampaignDraftErrorEnum": "google.ads.googleads.v13.errors.types.campaign_draft_error",
    "CampaignErrorEnum": "google.ads.googleads.v13.errors.types.campaign_error",
    "CampaignExperimentErrorEnum": "google.ads.googleads.v13.errors.types.campaign_experiment_error",
    "CampaignFeedErrorEnum": "google.ads.googleads.v13.errors.types.campaign_feed_error",
    "CampaignSharedSetErrorEnum": "google.ads.googleads.v13.errors.types.campaign_shared_set_error",
    "ChangeEventErrorEnum": "google.ads.googleads.v13.errors.types.change_event_error",
    "ChangeStatusErrorEnum": "google.ads.googleads.v13.errors.types.change_status_error",
    "CollectionSizeErrorEnum": "google.ads.googleads.v13.errors.types.collection_size_error",
    "ContextErrorEnum": "google.ads.googleads.v13.errors.types.context_error",
    "ConversionActionErrorEnum": "google.ads.googleads.v13.errors.types.conversion_action_error",
    "ConversionAdjustmentUploadErrorEnum": "google.ads.googleads.v13.errors.types.conversion_adjustment_upload_error",
    "ConversionCustomVariableErrorEnum": "google.ads.googleads.v13.errors.types.conversion_custom_variable_error",
    "ConversionGoalCampaignConfigErrorEnum": "google.ads.googleads.v13.errors.types.conversion_goal_campaign_config_error",
    "ConversionUploadErrorEnum": "google.ads.googleads.v13.errors.types.conversion_upload_error",
    "ConversionValueRuleErrorEnum": "google.ads.googleads.v13.errors.types.conversion_value_rule_error",
    "ConversionValueRuleSetErrorEnum": "google.ads.googleads.v13.errors.types.conversion_value_rule_set_error",
    "CountryCodeErrorEnum": "google.ads.googleads.v13.errors.types.country_code_error",
    "CriterionErrorEnum": "google.ads.googleads.v13.errors.types.criterion_error",
    "CurrencyCodeErrorEnum": "google.ads.googleads.v13.errors.types.currency_code_error",
    "CurrencyErrorEnum": "google.ads.googleads.v13.errors.types.currency_error",
    "CustomAudienceErrorEnum": "google.ads.googleads.v13.errors.types.custom_audience_error",
    "CustomConversionGoalErrorEnum": "google.ads.googleads.v13.errors.types.custom_conversion_goal_error",
    "CustomerClientLinkErrorEnum": "google.ads.googleads.v13.errors.types.customer_client_link_error",
    "CustomerCustomizerErrorEnum": "google.ads.googleads.v13.errors.types.customer_customizer_error",
    "CustomerErrorEnum": "google.ads.googleads.v13.errors.types.customer_error",
    "CustomerFeedErrorEnum": "google.ads.googleads.v13.errors.types.customer_feed_error",
    "CustomerManagerLinkErrorEnum": "google.ads.googleads.v13.errors.types.customer_manager_link_error",
    "CustomerUserAccessErrorEnum": "google.ads.googleads.v13.errors.types.customer_user_access_error",
    "CustomInterestErrorEnum": "google.ads.googleads.v13.errors.types.custom_interest_error",
    "CustomizerAttributeErrorEnum": "google.ads.googleads.v13.errors.types.customizer_attribute_error",
    "DatabaseErrorEnum": "google.ads.googleads.v13.errors.types.database_error",
    "DateErrorEnum": "google.ads.googleads.v13.errors.types.date_error",
    "DateRangeErrorEnum": "google.ads.googleads.v13.errors.types.date_range_error",
    "DistinctErrorEnum": "google.ads.googleads.v13.errors.types.distinct_error",
    "EnumErrorEnum": "google.ads.googleads.v13.errors.types.enum_error",
    "ErrorCode": "google.ads.googleads.v13.errors.types.errors",
    "ErrorDetails": "google.ads.googleads.v13.errors.types.errors",
    "ErrorLocation": "google.ads.googleads.v13.errors.types.errors",
    "ExperimentArmErrorEnum": "google.ads.googleads.v13.errors.types.experiment_arm_error",
    "ExperimentErrorEnum": "google.ads.googleads.v13.errors.types.experiment_error",
    "ExtensionFeedItemErrorEnum": "google.ads.googleads.v13.errors.types.extension_feed_item_error",
    "ExtensionSettingErrorEnum": "google.ads.googleads.v13.errors.types.extension_setting_error",
    "FeedAttributeReferenceErrorEnum": "google.ads.googleads.v13.errors.types.feed_attribute_reference_error",
    "FeedErrorEnum": "google.ads.googleads.v13.errors.types.feed_error",
    "FeedItemErrorEnum": "google.ads.googleads.v13.errors.types.feed_item_error",
    "FeedItemSetErrorEnum": "google.ads.googleads.v13.errors.types.feed_item_set_error",
    "FeedItemSetLinkErrorEnum": "google.ads.googleads.v13.errors.types.feed_item_set_link_error",
    "FeedItemTargetErrorEnum": "google.ads.googleads.v13.errors.types.feed_item_target_error",
    "FeedItemValidationErrorEnum": "google.ads.googleads.v13.errors.types.feed_item_validation_error",
    "FeedMappingErrorEnum": "google.ads.googleads.v13.errors.types.feed_mapping_error",
    "FieldErrorEnum": "google.ads.googleads.v13.errors.types.field_error",
    "FieldMaskErrorEnum": "google.ads.googleads.v13.errors.types.field_mask_error",
    "FunctionErrorEnum": "google.ads.googleads.v13.errors.types.function_error",
    "FunctionParsingErrorEnum": "google.ads.googleads.v13.errors.types.function_parsing_error",
    "GeoTargetConstantSuggestionErrorEnum": "google.ads.googleads.v13.errors.types.geo_target_constant_suggestion_error",
    "GoogleAdsError": "google.ads.googleads.v13.errors.types.errors",
    "GoogleAdsFailure": "google.ads.googleads.v13.errors.types.errors",
    "HeaderErrorEnum": "google.ads.googleads.v13.errors.types.header_error",
    "IdErrorEnum": "google.ads.googleads.v13.errors.types.id_error",
    "ImageErrorEnum": "google.ads.googleads.v13.errors.types.image_error",
    "InternalErrorEnum": "google.ads.googleads.v13.errors.types.internal_error",
    "InvoiceErrorEnum": "google.ads.googleads.v13.errors.types.invoice_error",
    "KeywordPlanAdGroupErrorEnum": "google.ads.googleads.v13.errors.types.keyword_plan_ad_group_error",
    "KeywordPlanAdGroupKeywordErrorEnum": "google.ads.googleads.v13.errors.types.keyword_plan_ad_group_keyword_error",
    "KeywordPlanCampaignErrorEnum": "google.ads.googleads.v13.errors.types.keyword_plan_campaign_error",
    "KeywordPlanCampaignKeywordErrorEnum": "google.ads.googleads.v13.errors.types.keyword_plan_campaign_keyword_error",
    "KeywordPlanErrorEnum": "google.ads.googleads.v13.errors.types.keyword_plan_error",
    "KeywordPlanIdeaErrorEnum": "google.ads.googleads.v13.errors.types.keyword_plan_idea_error",
    "LabelErrorEnum": "google.ads.googleads.v13.errors.types.label_error",
    "LanguageCodeErrorEnum": "google.ads.googleads.v13.errors.types.language_code_error",
    "ListOperationErrorEnum": "google.ads.googleads.v13.errors.types.list_operation_error",
    "ManagerLinkErrorEnum": "google.ads.googleads.v13.errors.types.manager_link_error",
    "MediaBundleErrorEnum": "google.ads.googleads.v13.errors.types.media_bundle_error",
    "MediaFileErrorEnum": "google.ads.googleads.v13.errors.types.media_file_error",
    "MediaUploadErrorEnum": "google.ads.googleads.v13.errors.types.media_upload_error",
    "MerchantCenterErrorEnum": "google.ads.googleads.v13.errors.types.merchant_center_error",
    "MultiplierErrorEnum": "google.ads.googleads.v13.errors.types.multiplier_error",
    "MutateErrorEnum": "google.ads.googleads.v13.errors.types.mutate_error",
    "NewResourceCreationErrorEnum": "google.ads.googleads.v13.errors.types.new_resource_creation_error",
    "NotAllowlistedErrorEnum": "google.ads.googleads.v13.errors.types.not_allowlisted_error",
    "NotEmptyErrorEnum": "google.ads.googleads.v13.errors.types.not_empty_error",
    "NullErrorEnum": "google.ads.googleads.v13.errors.types.null_error",
    "OfflineUserDataJobErrorEnum": "google.ads.googleads.v13.errors.types.offline_user_data_job_error",
    "OperationAccessDeniedErrorEnum": "google.ads.googleads.v13.errors.types.operation_access_denied_error",
    "OperatorErrorEnum": "google.ads.googleads.v13.errors.types.operator_error",
    "PartialFailureErrorEnum": "google.ads.googleads.v13.errors.types.partial_failure_error",
    "PaymentsAccountErrorEnum": "google.ads.googleads.v13.errors.types.payments_account_error",
    "PolicyFindingDetails": "google.ads.googleads.v13.errors.types.errors",
    "PolicyFindingErrorEnum": "google.ads.googleads.v13.errors.types.policy_finding_error",
    "PolicyValidationParameterErrorEnum": "google.ads.googleads.v13.errors.types.policy_validation_parameter_error",
    "PolicyViolationDetails": "google.ads.googleads.v13.errors.types.errors",
    "PolicyViolationErrorEnum": "google.ads.googleads.v13.errors.types.policy_violation_error",
    "QueryErrorEnum": "google.ads.googleads.v13.errors.types.query_error",
    "QuotaErrorDetails": "google.ads.googleads.v13.errors.types.errors",
    "QuotaErrorEnum": "google.ads.googleads.v13.errors.types.quota_error",
    "RangeErrorEnum": "google.ads.googleads.v13.errors.types.range_error",
    "ReachPlanErrorEnum": "google.ads.googleads.v13.errors.types.reach_plan_error",
    "RecommendationErrorEnum": "google.ads.googleads.v13.errors.types.recommendation_error",
    "RegionCodeErrorEnum": "google.ads.googleads.v13.errors.types.region_code_error",
    "RequestErrorEnum": "google.ads.googleads.v13.errors.types.request_error",
    "ResourceAccessDeniedErrorEnum": "google.ads.googleads.v13.errors.types.resource_access_denied_error",
    "ResourceCountDetails": "google.ads.googleads.v13.errors.types.errors",
    "ResourceCountLimitExceededErrorEnum": "google.ads.googleads.v13.errors.types.resource_count_limit_exceeded_error",
    "SettingErrorEnum": "google.ads.googleads.v13.errors.types.setting_error",
    "SharedCriterionErrorEnum": "google.ads.googleads.v13.errors.types.shared_criterion_error",
    "SharedSetErrorEnum": "google.ads.googleads.v13.errors.types.shared_set_error",
    "SizeLimitErrorEnum": "google.ads.googleads.v13.errors.types.size_limit_error",
    "SmartCampaignErrorEnum": "google.ads.googleads.v13.errors.types.smart_campaign_error",
    "StringFormatErrorEnum": "google.ads.googleads.v13.errors.types.string_format_error",
    "StringLengthErrorEnum": "google.ads.googleads.v13.errors.types.string_length_error",
    "ThirdPartyAppAnalyticsLinkErrorEnum": "google.ads.googleads.v13.errors.types.third_party_app_analytics_link_error",
    "TimeZoneErrorEnum": "google.ads.googleads.v13.errors.types.time_zone_error",
    "UrlFieldErrorEnum": "google.ads.googleads.v13.errors.types.url_field_error",
    "UserDataErrorEnum": "google.ads.googleads.v13.errors.types.user_data_error",
    "UserListErrorEnum": "google.ads.googleads.v13.errors.types.user_list_error",
    "YoutubeVideoRegistrationErrorEnum": "google.ads.googleads.v13.errors.types.youtube_video_registration_error",
    "AccessibleBiddingStrategy": "google.ads.googleads.v13.resources.types.accessible_bidding_strategy",
    "AccountBudget": "google.ads.googleads.v13.resources.types.account_budget",
    "AccountBudgetProposal": "google.ads.googleads.v13.resources.types.account_budget_proposal",
    "AccountLink": "google.ads.googleads.v13.resources.types.account_link",
    "Ad": "google.ads.googleads.v13.resources.types.ad",
    "AdGroup": "google.ads.googleads.v13.resources.types.ad_group",
    "AdGroupAd": "google.ads.googleads.v13.resources.types.ad_group_ad",
    "AdGroupAdAssetCombinationView": "google.ads.googleads.v13.resources.types.ad_group_ad_asset_combination_view",
    "AdGroupAdAssetPolicySummary": "google.ads.googleads.v13.resources.types.ad_group_ad_asset_view",
    "AdGroupAdAssetView": "google.ads.googleads.v13.resources.types.ad_group_ad_asset_view",
    "AdGroupAdLabel": "google.ads.googleads.v13.resources.types.ad_group_ad_label",
    "AdGroupAdPolicySummary": "google.ads.googleads.v13.resources.types.ad_group_ad",
    "AdGroupAsset": "google.ads.googleads.v13.resources.types.ad_group_asset",
    "AdGroupAssetSet": "google.ads.googleads.v13.resources.types.ad_group_asset_set",
    "AdGroupAudienceView": "google.ads.googleads.v13.resources.types.ad_group_audience_view",
    "AdGroupBidModifier": "google.ads.googleads.v13.resources.types.ad_group_bid_modifier",
    "AdGroupCriterion": "google.ads.googleads.v13.resources.types.ad_group_criterion",
    "AdGroupCriterionCustomizer": "google.ads.googleads.v13.resources.types.ad_group_criterion_customizer",
    "AdGroupCriterionLabel": "google.ads.googleads.v13.resources.types.ad_group_criterion_label",
    "AdGroupCriterionSimulation": "google.ads.googleads.v13.resources.types.ad_group_criterion_simulation",
    "AdGroupCustomizer": "google.ads.googleads.v13.resources.types.ad_group_customizer",
    "AdGroupExtensionSetting": "google.ads.googleads.v13.resources.types.ad_group_extension_setting",
    "AdGroupFeed": "google.ads.googleads.v13.resources.types.ad_group_feed",
    "AdGroupLabel": "google.ads.googleads.v13.resources.types.ad_group_label",
    "AdGroupSimulation": "google.ads.googleads.v13.resources.types.ad_group_simulation",
    "AdParameter": "google.ads.googleads.v13.resources.types.ad_parameter",
    "AdScheduleView": "google.ads.googleads.v13.resources.types.ad_schedule_view",
    "AdvertisingPartnerLinkIdentifier": "google.ads.googleads.v13.resources.types.account_link",
    "AgeRangeView": "google.ads.googleads.v13.resources.types.age_range_view",
    "Asset": "google.ads.googleads.v13.resources.types.asset",
    "AssetFieldTypePolicySummary": "google.ads.googleads.v13.resources.types.asset",
    "AssetFieldTypeView": "google.ads.googleads.v13.resources.types.asset_field_type_view",
    "AssetGroup": "google.ads.googleads.v13.resources.types.asset_group",
    "AssetGroupAsset": "google.ads.googleads.v13.resources.types.asset_group_asset",
    "AssetGroupListingGroupFilter": "google.ads.googleads.v13.resources.types.asset_group_listing_group_filter",
    "AssetGroupProductGroupView": "google.ads.googleads.v13.resources.types.asset_group_product_group_view",
    "AssetGroupSignal": "google.ads.googleads.v13.resources.types.asset_group_signal",
    "AssetPolicySummary": "google.ads.googleads.v13.resources.types.asset",
    "AssetSet": "google.ads.googleads.v13.resources.types.asset_set",
    "AssetSetAsset": "google.ads.googleads.v13.resources.types.asset_set_asset",
    "AssetSetTypeView": "google.ads.googleads.v13.resources.types.asset_set_type_view",
    "AttributeFieldMapping": "google.ads.googleads.v13.resources.types.feed_mapping",
    "Audience": "google.ads.googleads.v13.resources.types.audience",
    "BatchJob": "google.ads.googleads.v13.resources.types.batch_job",
    "BiddingDataExclusion": "google.ads.googleads.v13.resources.types.bidding_data_exclusion",
    "BiddingSeasonalityAdjustment": "google.ads.googleads.v13.resources.types.bidding_seasonality_adjustment",
    "BiddingStrategy": "google.ads.googleads.v13.resources.types.bidding_strategy",
    "BiddingStrategySimulation": "google.ads.googleads.v13.resources.types.bidding_strategy_simulation",
    "BillingSetup": "google.ads.googleads.v13.resources.types.billing_setup",
    "CallReportingSetting": "google.ads.googleads.v13.resources.types.customer",
    "CallView": "google.ads.googleads.v13.resources.types.call_view",
    "Campaign": "google.ads.googleads.v13.resources.types.campaign",
    "CampaignAsset": "google.ads.googleads.v13.resources.types.campaign_asset",
    "CampaignAssetSet": "google.ads.googleads.v13.resources.types.campaign_asset_set",
    "CampaignAudienceView": "google.ads.googleads.v13.resources.types.campaign_audience_view",
    "CampaignBidModifier": "google.ads.googleads.v13.resources.types.campaign_bid_modifier",
    "CampaignBudget": "google.ads.googleads.v13.resources.types.campaign_budget",
    "CampaignConversionGoal": "google.ads.googleads.v13.resources.types.campaign_conversion_goal",
    "CampaignCriterion": "google.ads.googleads.v13.resources.types.campaign_criterion",
    "CampaignCriterionSimulation": "google.ads.googleads.v13.resources.types.campaign_criterion_simulation",
    "CampaignCustomizer": "google.ads.googleads.v13.resources.types.campaign_customizer",
    "CampaignDraft": "google.ads.googleads.v13.resources.types.campaign_draft",
    "CampaignExtensionSetting": "google.ads.googleads.v13.resources.types.campaign_extension_setting",
    "CampaignFeed": "google.ads.googleads.v13.resources.types.campaign_feed",
    "CampaignGroup": "google.ads.googleads.v13.resources.types.campaign_group",
    "CampaignLabel": "google.ads.googleads.v13.resources.types.campaign_label",
    "CampaignSharedSet": "google.ads.googleads.v13.resources.types.campaign_shared_set",
    "CampaignSimulation": "google.ads.googleads.v13.resources.types.campaign_simulation",
    "CarrierConstant": "google.ads.googleads.v13.resources.types.carrier_constant",
    "ChangeEvent": "google.ads.googleads.v13.resources.types.change_event",
    "ChangeStatus": "google.ads.googleads.v13.resources.types.change_status",
    "ClickView": "google.ads.googleads.v13.resources.types.click_view",
    "CombinedAudience": "google.ads.googleads.v13.resources.types.combined_audience",
    "ConversionAction": "google.ads.googleads.v13.resources.types.conversion_action",
    "ConversionCustomVariable": "google.ads.googleads.v13.resources.types.conversion_custom_variable",
    "ConversionGoalCampaignConfig": "google.ads.googleads.v13.resources.types.conversion_goal_campaign_config",
    "ConversionTrackingSetting": "google.ads.googleads.v13.resources.types.customer",
    "ConversionValueRule": "google.ads.googleads.v13.resources.types.conversion_value_rule",
    "ConversionValueRuleSet": "google.ads.googleads.v13.resources.types.conversion_value_rule_set",
    "CurrencyConstant": "google.ads.googleads.v13.resources.types.currency_constant",
    "CustomAudience": "google.ads.googleads.v13.resources.types.custom_audience",
    "CustomAudienceMember": "google.ads.googleads.v13.resources.types.custom_audience",
    "CustomConversionGoal": "google.ads.googleads.v13.resources.types.custom_conversion_goal",
    "Customer": "google.ads.googleads.v13.resources.types.customer",
    "CustomerAsset": "google.ads.googleads.v13.resources.types.customer_asset",
    "CustomerAssetSet": "google.ads.googleads.v13.resources.types.customer_asset_set",
    "CustomerClient": "google.ads.googleads.v13.resources.types.customer_client",
    "CustomerClientLink": "google.ads.googleads.v13.resources.types.customer_client_link",
    "CustomerConversionGoal": "google.ads.googleads.v13.resources.types.customer_conversion_goal",
    "CustomerCustomizer": "google.ads.googleads.v13.resources.types.customer_customizer",
    "CustomerExtensionSetting": "google.ads.googleads.v13.resources.types.customer_extension_setting",
    "CustomerFeed": "google.ads.googleads.v13.resources.types.customer_feed",
    "CustomerLabel": "google.ads.googleads.v13.resources.types.customer_label",
    "CustomerManagerLink": "google.ads.googleads.v13.resources.types.customer_manager_link",
    "CustomerNegativeCriterion": "google.ads.googleads.v13.resources.types.customer_negative_criterion",
    "CustomerUserAccess": "google.ads.googleads.v13.resources.types.customer_user_access",
    "CustomerUserAccessInvitation": "google.ads.googleads.v13.resources.types.customer_user_access_invitation",
    "CustomInterest": "google.ads.googleads.v13.resources.types.custom_interest",
    "CustomInterestMember": "google.ads.googleads.v13.resources.types.custom_interest",
    "CustomizerAttribute": "google.ads.googleads.v13.resources.types.customizer_attribute",
    "CustomLeadFormSubmissionField": "google.ads.googleads.v13.resources.types.lead_form_submission_data",
    "DataPartnerIdentifier": "google.ads.googleads.v13.resources.types.product_link",
    "DataPartnerLinkIdentifier": "google.ads.googleads.v13.resources.types.account_link",
    "DetailedDemographic": "google.ads.googleads.v13.resources.types.detailed_demographic",
    "DetailPlacementView": "google.ads.googleads.v13.resources.types.detail_placement_view",
    "DisplayKeywordView": "google.ads.googleads.v13.resources.types.display_keyword_view",
    "DistanceView": "google.ads.googleads.v13.resources.types.distance_view",
    "DomainCategory": "google.ads.googleads.v13.resources.types.domain_category",
    "DynamicSearchAdsSearchTermView": "google.ads.googleads.v13.resources.types.dynamic_search_ads_search_term_view",
    "ExpandedLandingPageView": "google.ads.googleads.v13.resources.types.expanded_landing_page_view",
    "Experiment": "google.ads.googleads.v13.resources.types.experiment",
    "ExperimentArm": "google.ads.googleads.v13.resources.types.experiment_arm",
    "ExtensionFeedItem": "google.ads.googleads.v13.resources.types.extension_feed_item",
    "Feed": "google.ads.googleads.v13.resources.types.feed",
    "FeedAttribute": "google.ads.googleads.v13.resources.types.feed",
    "FeedAttributeOperation": "google.ads.googleads.v13.resources.types.feed",
    "FeedItem": "google.ads.googleads.v13.resources.types.feed_item",
    "FeedItemAttributeValue": "google.ads.googleads.v13.resources.types.feed_item",
    "FeedItemPlaceholderPolicyInfo": "google.ads.googleads.v13.resources.types.feed_item",
    "FeedItemSet": "google.ads.googleads.v13.resources.types.feed_item_set",
    "FeedItemSetLink": "google.ads.googleads.v13.resources.types.feed_item_set_link",
    "FeedItemTarget": "google.ads.googleads.v13.resources.types.feed_item_target",
    "FeedItemValidationError": "google.ads.googleads.v13.resources.types.feed_item",
    "FeedMapping": "google.ads.googleads.v13.resources.types.feed_mapping",
    "FeedPlaceholderView": "google.ads.googleads.v13.resources.types.feed_placeholder_view",
    "GenderView": "google.ads.googleads.v13.resources.types.gender_view",
    "GeographicView": "google.ads.googleads.v13.resources.types.geographic_view",
    "GeoTargetConstant": "google.ads.googleads.v13.resources.types.geo_target_constant",
    "GoogleAdsField": "google.ads.googleads.v13.resources.types.google_ads_field",
    "GoogleAdsIdentifier": "google.ads.googleads.v13.resources.types.product_link",
    "GoogleAdsLinkIdentifier": "google.ads.googleads.v13.resources.types.account_link",
    "GroupPlacementView": "google.ads.googleads.v13.resources.types.group_placement_view",
    "HotelCenterLinkIdentifier": "google.ads.googleads.v13.resources.types.account_link",
    "HotelGroupView": "google.ads.googleads.v13.resources.types.hotel_group_view",
    "HotelPerformanceView": "google.ads.googleads.v13.resources.types.hotel_performance_view",
    "HotelReconciliation": "google.ads.googleads.v13.resources.types.hotel_reconciliation",
    "IncomeRangeView": "google.ads.googleads.v13.resources.types.income_range_view",
    "Invoice": "google.ads.googleads.v13.resources.types.invoice",
    "KeywordPlan": "google.ads.googleads.v13.resources.types.keyword_plan",
    "KeywordPlanAdGroup": "google.ads.googleads.v13.resources.types.keyword_plan_ad_group",
    "KeywordPlanAdGroupKeyword": "google.ads.googleads.v13.resources.types.keyword_plan_ad_group_keyword",
    "KeywordPlanCampaign": "google.ads.googleads.v13.resources.types.keyword_plan_campaign",
    "KeywordPlanCampaignKeyword": "google.ads.googleads.v13.resources.types.keyword_plan_campaign_keyword",
    "KeywordPlanForecastPeriod": "google.ads.googleads.v13.resources.types.keyword_plan",
    "KeywordPlanGeoTarget": "google.ads.googleads.v13.resources.types.keyword_plan_campaign",
    "KeywordThemeConstant": "google.ads.googleads.v13.resources.types.keyword_theme_constant",
    "KeywordView": "google.ads.googleads.v13.resources.types.keyword_view",
    "Label": "google.ads.googleads.v13.resources.types.label",
    "LandingPageView": "google.ads.googleads.v13.resources.types.landing_page_view",
    "LanguageConstant": "google.ads.googleads.v13.resources.types.language_constant",
    "LeadFormSubmissionData": "google.ads.googleads.v13.resources.types.lead_form_submission_data",
    "LeadFormSubmissionField": "google.ads.googleads.v13.resources.types.lead_form_submission_data",
    "LifeEvent": "google.ads.googleads.v13.resources.types.life_event",
    "ListingGroupFilterDimension": "google.ads.googleads.v13.resources.types.asset_group_listing_group_filter",
    "LocationView": "google.ads.googleads.v13.resources.types.location_view",
    "ManagedPlacementView": "google.ads.googleads.v13.resources.types.managed_placement_view",
    "MediaAudio": "google.ads.googleads.v13.resources.types.media_file",
    "MediaBundle": "google.ads.googleads.v13.resources.types.media_file",
    "MediaFile": "google.ads.googleads.v13.resources.types.media_file",
    "MediaImage": "google.ads.googleads.v13.resources.types.media_file",
    "MediaVideo": "google.ads.googleads.v13.resources.types.media_file",
    "MerchantCenterLink": "google.ads.googleads.v13.resources.types.merchant_center_link",
    "MobileAppCategoryConstant": "google.ads.googleads.v13.resources.types.mobile_app_category_constant",
    "MobileDeviceConstant": "google.ads.googleads.v13.resources.types.mobile_device_constant",
    "OfflineUserDataJob": "google.ads.googleads.v13.resources.types.offline_user_data_job",
    "OfflineUserDataJobMetadata": "google.ads.googleads.v13.resources.types.offline_user_data_job",
    "OperatingSystemVersionConstant": "google.ads.googleads.v13.resources.types.operating_system_version_constant",
    "PaidOrganicSearchTermView": "google.ads.googleads.v13.resources.types.paid_organic_search_term_view",
    "ParentalStatusView": "google.ads.googleads.v13.resources.types.parental_status_view",
    "PaymentsAccount": "google.ads.googleads.v13.resources.types.payments_account",
    "PerStoreView": "google.ads.googleads.v13.resources.types.per_store_view",
    "ProductBiddingCategoryConstant": "google.ads.googleads.v13.resources.types.product_bidding_category_constant",
    "ProductGroupView": "google.ads.googleads.v13.resources.types.product_group_view",
    "ProductLink": "google.ads.googleads.v13.resources.types.product_link",
    "QualifyingQuestion": "google.ads.googleads.v13.resources.types.qualifying_question",
    "Recommendation": "google.ads.googleads.v13.resources.types.recommendation",
    "RemarketingAction": "google.ads.googleads.v13.resources.types.remarketing_action",
    "RemarketingSetting": "google.ads.googleads.v13.resources.types.customer",
    "SearchTermView": "google.ads.googleads.v13.resources.types.search_term_view",
    "SharedCriterion": "google.ads.googleads.v13.resources.types.shared_criterion",
    "SharedSet": "google.ads.googleads.v13.resources.types.shared_set",
    "ShoppingPerformanceView": "google.ads.googleads.v13.resources.types.shopping_performance_view",
    "SmartCampaignSearchTermView": "google.ads.googleads.v13.resources.types.smart_campaign_search_term_view",
    "SmartCampaignSetting": "google.ads.googleads.v13.resources.types.smart_campaign_setting",
    "ThirdPartyAppAnalyticsLink": "google.ads.googleads.v13.resources.types.third_party_app_analytics_link",
    "ThirdPartyAppAnalyticsLinkIdentifier": "google.ads.googleads.v13.resources.types.account_link",
    "TopicConstant": "google.ads.googleads.v13.resources.types.topic_constant",
    "TopicView": "google.ads.googleads.v13.resources.types.topic_view",
    "TravelActivityGroupView": "google.ads.googleads.v13.resources.types.travel_activity_group_view",
    "TravelActivityPerformanceView": "google.ads.googleads.v13.resources.types.travel_activity_performance_view",
    "UserInterest": "google.ads.googleads.v13.resources.types.user_interest",
    "UserList": "google.ads.googleads.v13.resources.types.user_list",
    "UserLocationView": "google.ads.googleads.v13.resources.types.user_location_view",
    "Video": "google.ads.googleads.v13.resources.types.video",
    "WebpageView": "google.ads.googleads.v13.resources.types.webpage_view",
    "AccountBudgetProposalOperation": "google.ads.googleads.v13.services.types.account_budget_proposal_service",
    "AccountLinkOperation": "google.ads.googleads.v13.services.types.account_link_service",
    "AddBatchJobOperationsRequest": "google.ads.googleads.v13.services.types.batch_job_service",
    "AddBatchJobOperationsResponse": "google.ads.googleads.v13.services.types.batch_job_service",
    "AddOfflineUserDataJobOperationsRequest": "google.ads.googleads.v13.services.types.offline_user_data_job_service",
    "AddOfflineUserDataJobOperationsResponse": "google.ads.googleads.v13.services.types.offline_user_data_job_service",
    "AdGroupAdLabelOperation": "google.ads.googleads.v13.services.types.ad_group_ad_label_service",
    "AdGroupAdOperation": "google.ads.googleads.v13.services.types.ad_group_ad_service",
    "AdGroupAssetOperation": "google.ads.googleads.v13.services.types.ad_group_asset_service",
    "AdGroupAssetSetOperation": "google.ads.googleads.v13.services.types.ad_group_asset_set_service",
    "AdGroupBidModifierOperation": "google.ads.googleads.v13.services.types.ad_group_bid_modifier_service",
    "AdGroupCriterionCustomizerOperation": "google.ads.googleads.v13.services.types.ad_group_criterion_customizer_service",
    "AdGroupCriterionLabelOperation": "google.ads.googleads.v13.services.types.ad_group_criterion_label_service",
    "AdGroupCriterionOperation": "google.ads.googleads.v13.services.types.ad_group_criterion_service",
    "AdGroupCustomizerOperation": "google.ads.googleads.v13.services.types.ad_group_customizer_service",
    "AdGroupExtensionSettingOperation": "google.ads.googleads.v13.services.types.ad_group_extension_setting_service",
    "AdGroupFeedOperation": "google.ads.googleads.v13.services.types.ad_group_feed_service",
    "AdGroupKeywordSuggestion": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "AdGroupLabelOperation": "google.ads.googleads.v13.services.types.ad_group_label_service",
    "AdGroupOperation": "google.ads.googleads.v13.services.types.ad_group_service",
    "AdOperation": "google.ads.googleads.v13.services.types.ad_service",
    "AdParameterOperation": "google.ads.googleads.v13.services.types.ad_parameter_service",
    "AdvancedProductTargeting": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ApplyRecommendationOperation": "google.ads.googleads.v13.services.types.recommendation_service",
    "ApplyRecommendationRequest": "google.ads.googleads.v13.services.types.recommendation_service",
    "ApplyRecommendationResponse": "google.ads.googleads.v13.services.types.recommendation_service",
    "ApplyRecommendationResult": "google.ads.googleads.v13.services.types.recommendation_service",
    "AssetGroupAssetOperation": "google.ads.googleads.v13.services.types.asset_group_asset_service",
    "AssetGroupListingGroupFilterOperation": "google.ads.googleads.v13.services.types.asset_group_listing_group_filter_service",
    "AssetGroupOperation": "google.ads.googleads.v13.services.types.asset_group_service",
    "AssetGroupSignalOperation": "google.ads.googleads.v13.services.types.asset_group_signal_service",
    "AssetOperation": "google.ads.googleads.v13.services.types.asset_service",
    "AssetSetAssetOperation": "google.ads.googleads.v13.services.types.asset_set_asset_service",
    "AssetSetOperation": "google.ads.googleads.v13.services.types.asset_set_service",
    "AudienceCompositionAttribute": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceCompositionAttributeCluster": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceCompositionMetrics": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceCompositionSection": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceInsightsAttribute": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceInsightsAttributeMetadata": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceInsightsCategory": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceInsightsDynamicLineup": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceInsightsEntity": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceInsightsTopic": "google.ads.googleads.v13.services.types.audience_insights_service",
    "AudienceOperation": "google.ads.googleads.v13.services.types.audience_service",
    "AudienceTargeting": "google.ads.googleads.v13.services.types.reach_plan_service",
    "BasicInsightsAudience": "google.ads.googleads.v13.services.types.audience_insights_service",
    "BatchJobOperation": "google.ads.googleads.v13.services.types.batch_job_service",
    "BatchJobResult": "google.ads.googleads.v13.services.types.batch_job_service",
    "BiddingDataExclusionOperation": "google.ads.googleads.v13.services.types.bidding_data_exclusion_service",
    "BiddingSeasonalityAdjustmentOperation": "google.ads.googleads.v13.services.types.bidding_seasonality_adjustment_service",
    "BiddingStrategyOperation": "google.ads.googleads.v13.services.types.bidding_strategy_service",
    "BillingSetupOperation": "google.ads.googleads.v13.services.types.billing_setup_service",
    "CallConversion": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "CallConversionResult": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "CampaignAssetOperation": "google.ads.googleads.v13.services.types.campaign_asset_service",
    "CampaignAssetSetOperation": "google.ads.googleads.v13.services.types.campaign_asset_set_service",
    "CampaignBidModifierOperation": "google.ads.googleads.v13.services.types.campaign_bid_modifier_service",
    "CampaignBudgetMapping": "google.ads.googleads.v13.services.types.experiment_service",
    "CampaignBudgetOperation": "google.ads.googleads.v13.services.types.campaign_budget_service",
    "CampaignConversionGoalOperation": "google.ads.googleads.v13.services.types.campaign_conversion_goal_service",
    "CampaignCriterionOperation": "google.ads.googleads.v13.services.types.campaign_criterion_service",
    "CampaignCustomizerOperation": "google.ads.googleads.v13.services.types.campaign_customizer_service",
    "CampaignDraftOperation": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "CampaignDuration": "google.ads.googleads.v13.services.types.reach_plan_service",
    "CampaignExtensionSettingOperation": "google.ads.googleads.v13.services.types.campaign_extension_setting_service",
    "CampaignFeedOperation": "google.ads.googleads.v13.services.types.campaign_feed_service",
    "CampaignGroupOperation": "google.ads.googleads.v13.services.types.campaign_group_service",
    "CampaignLabelOperation": "google.ads.googleads.v13.services.types.campaign_label_service",
    "CampaignOperation": "google.ads.googleads.v13.services.types.campaign_service",
    "CampaignSharedSetOperation": "google.ads.googleads.v13.services.types.campaign_shared_set_service",
    "CartData": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "ClickConversion": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "ClickConversionResult": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "ConversionActionOperation": "google.ads.googleads.v13.services.types.conversion_action_service",
    "ConversionAdjustment": "google.ads.googleads.v13.services.types.conversion_adjustment_upload_service",
    "ConversionAdjustmentResult": "google.ads.googleads.v13.services.types.conversion_adjustment_upload_service",
    "ConversionCustomVariableOperation": "google.ads.googleads.v13.services.types.conversion_custom_variable_service",
    "ConversionGoalCampaignConfigOperation": "google.ads.googleads.v13.services.types.conversion_goal_campaign_config_service",
    "ConversionValueRuleOperation": "google.ads.googleads.v13.services.types.conversion_value_rule_service",
    "ConversionValueRuleSetOperation": "google.ads.googleads.v13.services.types.conversion_value_rule_set_service",
    "CreateAccountLinkRequest": "google.ads.googleads.v13.services.types.account_link_service",
    "CreateAccountLinkResponse": "google.ads.googleads.v13.services.types.account_link_service",
    "CreateCustomerClientRequest": "google.ads.googleads.v13.services.types.customer_service",
    "CreateCustomerClientResponse": "google.ads.googleads.v13.services.types.customer_service",
    "CreateOfflineUserDataJobRequest": "google.ads.googleads.v13.services.types.offline_user_data_job_service",
    "CreateOfflineUserDataJobResponse": "google.ads.googleads.v13.services.types.offline_user_data_job_service",
    "CreateProductLinkRequest": "google.ads.googleads.v13.services.types.product_link_service",
    "CreateProductLinkResponse": "google.ads.googleads.v13.services.types.product_link_service",
    "CustomAudienceOperation": "google.ads.googleads.v13.services.types.custom_audience_service",
    "CustomConversionGoalOperation": "google.ads.googleads.v13.services.types.custom_conversion_goal_service",
    "CustomerAssetOperation": "google.ads.googleads.v13.services.types.customer_asset_service",
    "CustomerAssetSetOperation": "google.ads.googleads.v13.services.types.customer_asset_set_service",
    "CustomerClientLinkOperation": "google.ads.googleads.v13.services.types.customer_client_link_service",
    "CustomerConversionGoalOperation": "google.ads.googleads.v13.services.types.customer_conversion_goal_service",
    "CustomerCustomizerOperation": "google.ads.googleads.v13.services.types.customer_customizer_service",
    "CustomerExtensionSettingOperation": "google.ads.googleads.v13.services.types.customer_extension_setting_service",
    "CustomerFeedOperation": "google.ads.googleads.v13.services.types.customer_feed_service",
    "CustomerLabelOperation": "google.ads.googleads.v13.services.types.customer_label_service",
    "CustomerManagerLinkOperation": "google.ads.googleads.v13.services.types.customer_manager_link_service",
    "CustomerNegativeCriterionOperation": "google.ads.googleads.v13.services.types.customer_negative_criterion_service",
    "CustomerOperation": "google.ads.googleads.v13.services.types.customer_service",
    "CustomerUserAccessInvitationOperation": "google.ads.googleads.v13.services.types.customer_user_access_invitation_service",
    "CustomerUserAccessOperation": "google.ads.googleads.v13.services.types.customer_user_access_service",
    "CustomInterestOperation": "google.ads.googleads.v13.services.types.custom_interest_service",
    "CustomizerAttributeOperation": "google.ads.googleads.v13.services.types.customizer_attribute_service",
    "CustomVariable": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "DismissRecommendationRequest": "google.ads.googleads.v13.services.types.recommendation_service",
    "DismissRecommendationResponse": "google.ads.googleads.v13.services.types.recommendation_service",
    "DynamicLineupAttributeMetadata": "google.ads.googleads.v13.services.types.audience_insights_service",
    "EffectiveFrequencyBreakdown": "google.ads.googleads.v13.services.types.reach_plan_service",
    "EffectiveFrequencyLimit": "google.ads.googleads.v13.services.types.reach_plan_service",
    "EndExperimentRequest": "google.ads.googleads.v13.services.types.experiment_service",
    "ExperimentArmOperation": "google.ads.googleads.v13.services.types.experiment_arm_service",
    "ExperimentOperation": "google.ads.googleads.v13.services.types.experiment_service",
    "ExtensionFeedItemOperation": "google.ads.googleads.v13.services.types.extension_feed_item_service",
    "ExternalAttributionData": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "FeedItemOperation": "google.ads.googleads.v13.services.types.feed_item_service",
    "FeedItemSetLinkOperation": "google.ads.googleads.v13.services.types.feed_item_set_link_service",
    "FeedItemSetOperation": "google.ads.googleads.v13.services.types.feed_item_set_service",
    "FeedItemTargetOperation": "google.ads.googleads.v13.services.types.feed_item_target_service",
    "FeedMappingOperation": "google.ads.googleads.v13.services.types.feed_mapping_service",
    "FeedOperation": "google.ads.googleads.v13.services.types.feed_service",
    "Forecast": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ForecastMetricOptions": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ForecastMetrics": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "FrequencyCap": "google.ads.googleads.v13.services.types.reach_plan_service",
    "GclidDateTimePair": "google.ads.googleads.v13.services.types.conversion_adjustment_upload_service",
    "GenerateAdGroupThemesRequest": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateAdGroupThemesResponse": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateAudienceCompositionInsightsRequest": "google.ads.googleads.v13.services.types.audience_insights_service",
    "GenerateAudienceCompositionInsightsResponse": "google.ads.googleads.v13.services.types.audience_insights_service",
    "GenerateForecastCurveRequest": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateForecastCurveResponse": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateForecastMetricsRequest": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateForecastMetricsResponse": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateForecastTimeSeriesRequest": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateForecastTimeSeriesResponse": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateHistoricalMetricsRequest": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateHistoricalMetricsResponse": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "GenerateInsightsFinderReportRequest": "google.ads.googleads.v13.services.types.audience_insights_service",
    "GenerateInsightsFinderReportResponse": "google.ads.googleads.v13.services.types.audience_insights_service",
    "GenerateKeywordHistoricalMetricsRequest": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateKeywordHistoricalMetricsResponse": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateKeywordHistoricalMetricsResult": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeaResponse": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeaResult": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateKeywordIdeasRequest": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "GenerateReachForecastRequest": "google.ads.googleads.v13.services.types.reach_plan_service",
    "GenerateReachForecastResponse": "google.ads.googleads.v13.services.types.reach_plan_service",
    "GeoTargetConstantSuggestion": "google.ads.googleads.v13.services.types.geo_target_constant_service",
    "GetAdRequest": "google.ads.googleads.v13.services.types.ad_service",
    "GetGoogleAdsFieldRequest": "google.ads.googleads.v13.services.types.google_ads_field_service",
    "GetMerchantCenterLinkRequest": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "GetSmartCampaignStatusRequest": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "GetSmartCampaignStatusResponse": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "GoogleAdsRow": "google.ads.googleads.v13.services.types.google_ads_service",
    "GraduateExperimentRequest": "google.ads.googleads.v13.services.types.experiment_service",
    "HotelAssetSuggestion": "google.ads.googleads.v13.services.types.travel_asset_suggestion_service",
    "HotelImageAsset": "google.ads.googleads.v13.services.types.travel_asset_suggestion_service",
    "HotelTextAsset": "google.ads.googleads.v13.services.types.travel_asset_suggestion_service",
    "InsightsAudience": "google.ads.googleads.v13.services.types.audience_insights_service",
    "InsightsAudienceAttributeGroup": "google.ads.googleads.v13.services.types.audience_insights_service",
    "KeywordAndUrlSeed": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "KeywordPlanAdGroupForecast": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanAdGroupKeywordOperation": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_keyword_service",
    "KeywordPlanAdGroupOperation": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_service",
    "KeywordPlanCampaignForecast": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanCampaignForecastCurve": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanCampaignKeywordOperation": "google.ads.googleads.v13.services.types.keyword_plan_campaign_keyword_service",
    "KeywordPlanCampaignOperation": "google.ads.googleads.v13.services.types.keyword_plan_campaign_service",
    "KeywordPlanKeywordForecast": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanKeywordHistoricalMetrics": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanMaxCpcBidForecast": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanMaxCpcBidForecastCurve": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanOperation": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanWeeklyForecast": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordPlanWeeklyTimeSeriesForecast": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "KeywordSeed": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "LabelOperation": "google.ads.googleads.v13.services.types.label_service",
    "ListAccessibleCustomersRequest": "google.ads.googleads.v13.services.types.customer_service",
    "ListAccessibleCustomersResponse": "google.ads.googleads.v13.services.types.customer_service",
    "ListAudienceInsightsAttributesRequest": "google.ads.googleads.v13.services.types.audience_insights_service",
    "ListAudienceInsightsAttributesResponse": "google.ads.googleads.v13.services.types.audience_insights_service",
    "ListBatchJobResultsRequest": "google.ads.googleads.v13.services.types.batch_job_service",
    "ListBatchJobResultsResponse": "google.ads.googleads.v13.services.types.batch_job_service",
    "ListCampaignDraftAsyncErrorsRequest": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "ListCampaignDraftAsyncErrorsResponse": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "ListExperimentAsyncErrorsRequest": "google.ads.googleads.v13.services.types.experiment_service",
    "ListExperimentAsyncErrorsResponse": "google.ads.googleads.v13.services.types.experiment_service",
    "ListInsightsEligibleDatesRequest": "google.ads.googleads.v13.services.types.audience_insights_service",
    "ListInsightsEligibleDatesResponse": "google.ads.googleads.v13.services.types.audience_insights_service",
    "ListInvoicesRequest": "google.ads.googleads.v13.services.types.invoice_service",
    "ListInvoicesResponse": "google.ads.googleads.v13.services.types.invoice_service",
    "ListMerchantCenterLinksRequest": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "ListMerchantCenterLinksResponse": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "ListPaymentsAccountsRequest": "google.ads.googleads.v13.services.types.payments_account_service",
    "ListPaymentsAccountsResponse": "google.ads.googleads.v13.services.types.payments_account_service",
    "ListPlannableLocationsRequest": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ListPlannableLocationsResponse": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ListPlannableProductsRequest": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ListPlannableProductsResponse": "google.ads.googleads.v13.services.types.reach_plan_service",
    "LocationAttributeMetadata": "google.ads.googleads.v13.services.types.audience_insights_service",
    "MediaFileOperation": "google.ads.googleads.v13.services.types.media_file_service",
    "MerchantCenterLinkOperation": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "MoveManagerLinkRequest": "google.ads.googleads.v13.services.types.customer_manager_link_service",
    "MoveManagerLinkResponse": "google.ads.googleads.v13.services.types.customer_manager_link_service",
    "MutateAccountBudgetProposalRequest": "google.ads.googleads.v13.services.types.account_budget_proposal_service",
    "MutateAccountBudgetProposalResponse": "google.ads.googleads.v13.services.types.account_budget_proposal_service",
    "MutateAccountBudgetProposalResult": "google.ads.googleads.v13.services.types.account_budget_proposal_service",
    "MutateAccountLinkRequest": "google.ads.googleads.v13.services.types.account_link_service",
    "MutateAccountLinkResponse": "google.ads.googleads.v13.services.types.account_link_service",
    "MutateAccountLinkResult": "google.ads.googleads.v13.services.types.account_link_service",
    "MutateAdGroupAdLabelResult": "google.ads.googleads.v13.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdLabelsRequest": "google.ads.googleads.v13.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdLabelsResponse": "google.ads.googleads.v13.services.types.ad_group_ad_label_service",
    "MutateAdGroupAdResult": "google.ads.googleads.v13.services.types.ad_group_ad_service",
    "MutateAdGroupAdsRequest": "google.ads.googleads.v13.services.types.ad_group_ad_service",
    "MutateAdGroupAdsResponse": "google.ads.googleads.v13.services.types.ad_group_ad_service",
    "MutateAdGroupAssetResult": "google.ads.googleads.v13.services.types.ad_group_asset_service",
    "MutateAdGroupAssetSetResult": "google.ads.googleads.v13.services.types.ad_group_asset_set_service",
    "MutateAdGroupAssetSetsRequest": "google.ads.googleads.v13.services.types.ad_group_asset_set_service",
    "MutateAdGroupAssetSetsResponse": "google.ads.googleads.v13.services.types.ad_group_asset_set_service",
    "MutateAdGroupAssetsRequest": "google.ads.googleads.v13.services.types.ad_group_asset_service",
    "MutateAdGroupAssetsResponse": "google.ads.googleads.v13.services.types.ad_group_asset_service",
    "MutateAdGroupBidModifierResult": "google.ads.googleads.v13.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupBidModifiersRequest": "google.ads.googleads.v13.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupBidModifiersResponse": "google.ads.googleads.v13.services.types.ad_group_bid_modifier_service",
    "MutateAdGroupCriteriaRequest": "google.ads.googleads.v13.services.types.ad_group_criterion_service",
    "MutateAdGroupCriteriaResponse": "google.ads.googleads.v13.services.types.ad_group_criterion_service",
    "MutateAdGroupCriterionCustomizerResult": "google.ads.googleads.v13.services.types.ad_group_criterion_customizer_service",
    "MutateAdGroupCriterionCustomizersRequest": "google.ads.googleads.v13.services.types.ad_group_criterion_customizer_service",
    "MutateAdGroupCriterionCustomizersResponse": "google.ads.googleads.v13.services.types.ad_group_criterion_customizer_service",
    "MutateAdGroupCriterionLabelResult": "google.ads.googleads.v13.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionLabelsRequest": "google.ads.googleads.v13.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionLabelsResponse": "google.ads.googleads.v13.services.types.ad_group_criterion_label_service",
    "MutateAdGroupCriterionResult": "google.ads.googleads.v13.services.types.ad_group_criterion_service",
    "MutateAdGroupCustomizerResult": "google.ads.googleads.v13.services.types.ad_group_customizer_service",
    "MutateAdGroupCustomizersRequest": "google.ads.googleads.v13.services.types.ad_group_customizer_service",
    "MutateAdGroupCustomizersResponse": "google.ads.googleads.v13.services.types.ad_group_customizer_service",
    "MutateAdGroupExtensionSettingResult": "google.ads.googleads.v13.services.types.ad_group_extension_setting_service",
    "MutateAdGroupExtensionSettingsRequest": "google.ads.googleads.v13.services.types.ad_group_extension_setting_service",
    "MutateAdGroupExtensionSettingsResponse": "google.ads.googleads.v13.services.types.ad_group_extension_setting_service",
    "MutateAdGroupFeedResult": "google.ads.googleads.v13.services.types.ad_group_feed_service",
    "MutateAdGroupFeedsRequest": "google.ads.googleads.v13.services.types.ad_group_feed_service",
    "MutateAdGroupFeedsResponse": "google.ads.googleads.v13.services.types.ad_group_feed_service",
    "MutateAdGroupLabelResult": "google.ads.googleads.v13.services.types.ad_group_label_service",
    "MutateAdGroupLabelsRequest": "google.ads.googleads.v13.services.types.ad_group_label_service",
    "MutateAdGroupLabelsResponse": "google.ads.googleads.v13.services.types.ad_group_label_service",
    "MutateAdGroupResult": "google.ads.googleads.v13.services.types.ad_group_service",
    "MutateAdGroupsRequest": "google.ads.googleads.v13.services.types.ad_group_service",
    "MutateAdGroupsResponse": "google.ads.googleads.v13.services.types.ad_group_service",
    "MutateAdParameterResult": "google.ads.googleads.v13.services.types.ad_parameter_service",
    "MutateAdParametersRequest": "google.ads.googleads.v13.services.types.ad_parameter_service",
    "MutateAdParametersResponse": "google.ads.googleads.v13.services.types.ad_parameter_service",
    "MutateAdResult": "google.ads.googleads.v13.services.types.ad_service",
    "MutateAdsRequest": "google.ads.googleads.v13.services.types.ad_service",
    "MutateAdsResponse": "google.ads.googleads.v13.services.types.ad_service",
    "MutateAssetGroupAssetResult": "google.ads.googleads.v13.services.types.asset_group_asset_service",
    "MutateAssetGroupAssetsRequest": "google.ads.googleads.v13.services.types.asset_group_asset_service",
    "MutateAssetGroupAssetsResponse": "google.ads.googleads.v13.services.types.asset_group_asset_service",
    "MutateAssetGroupListingGroupFilterResult": "google.ads.googleads.v13.services.types.asset_group_listing_group_filter_service",
    "MutateAssetGroupListingGroupFiltersRequest": "google.ads.googleads.v13.services.types.asset_group_listing_group_filter_service",
    "MutateAssetGroupListingGroupFiltersResponse": "google.ads.googleads.v13.services.types.asset_group_listing_group_filter_service",
    "MutateAssetGroupResult": "google.ads.googleads.v13.services.types.asset_group_service",
    "MutateAssetGroupSignalResult": "google.ads.googleads.v13.services.types.asset_group_signal_service",
    "MutateAssetGroupSignalsRequest": "google.ads.googleads.v13.services.types.asset_group_signal_service",
    "MutateAssetGroupSignalsResponse": "google.ads.googleads.v13.services.types.asset_group_signal_service",
    "MutateAssetGroupsRequest": "google.ads.googleads.v13.services.types.asset_group_service",
    "MutateAssetGroupsResponse": "google.ads.googleads.v13.services.types.asset_group_service",
    "MutateAssetResult": "google.ads.googleads.v13.services.types.asset_service",
    "MutateAssetSetAssetResult": "google.ads.googleads.v13.services.types.asset_set_asset_service",
    "MutateAssetSetAssetsRequest": "google.ads.googleads.v13.services.types.asset_set_asset_service",
    "MutateAssetSetAssetsResponse": "google.ads.googleads.v13.services.types.asset_set_asset_service",
    "MutateAssetSetResult": "google.ads.googleads.v13.services.types.asset_set_service",
    "MutateAssetSetsRequest": "google.ads.googleads.v13.services.types.asset_set_service",
    "MutateAssetSetsResponse": "google.ads.googleads.v13.services.types.asset_set_service",
    "MutateAssetsRequest": "google.ads.googleads.v13.services.types.asset_service",
    "MutateAssetsResponse": "google.ads.googleads.v13.services.types.asset_service",
    "MutateAudienceResult": "google.ads.googleads.v13.services.types.audience_service",
    "MutateAudiencesRequest": "google.ads.googleads.v13.services.types.audience_service",
    "MutateAudiencesResponse": "google.ads.googleads.v13.services.types.audience_service",
    "MutateBatchJobRequest": "google.ads.googleads.v13.services.types.batch_job_service",
    "MutateBatchJobResponse": "google.ads.googleads.v13.services.types.batch_job_service",
    "MutateBatchJobResult": "google.ads.googleads.v13.services.types.batch_job_service",
    "MutateBiddingDataExclusionsRequest": "google.ads.googleads.v13.services.types.bidding_data_exclusion_service",
    "MutateBiddingDataExclusionsResponse": "google.ads.googleads.v13.services.types.bidding_data_exclusion_service",
    "MutateBiddingDataExclusionsResult": "google.ads.googleads.v13.services.types.bidding_data_exclusion_service",
    "MutateBiddingSeasonalityAdjustmentsRequest": "google.ads.googleads.v13.services.types.bidding_seasonality_adjustment_service",
    "MutateBiddingSeasonalityAdjustmentsResponse": "google.ads.googleads.v13.services.types.bidding_seasonality_adjustment_service",
    "MutateBiddingSeasonalityAdjustmentsResult": "google.ads.googleads.v13.services.types.bidding_seasonality_adjustment_service",
    "MutateBiddingStrategiesRequest": "google.ads.googleads.v13.services.types.bidding_strategy_service",
    "MutateBiddingStrategiesResponse": "google.ads.googleads.v13.services.types.bidding_strategy_service",
    "MutateBiddingStrategyResult": "google.ads.googleads.v13.services.types.bidding_strategy_service",
    "MutateBillingSetupRequest": "google.ads.googleads.v13.services.types.billing_setup_service",
    "MutateBillingSetupResponse": "google.ads.googleads.v13.services.types.billing_setup_service",
    "MutateBillingSetupResult": "google.ads.googleads.v13.services.types.billing_setup_service",
    "MutateCampaignAssetResult": "google.ads.googleads.v13.services.types.campaign_asset_service",
    "MutateCampaignAssetSetResult": "google.ads.googleads.v13.services.types.campaign_asset_set_service",
    "MutateCampaignAssetSetsRequest": "google.ads.googleads.v13.services.types.campaign_asset_set_service",
    "MutateCampaignAssetSetsResponse": "google.ads.googleads.v13.services.types.campaign_asset_set_service",
    "MutateCampaignAssetsRequest": "google.ads.googleads.v13.services.types.campaign_asset_service",
    "MutateCampaignAssetsResponse": "google.ads.googleads.v13.services.types.campaign_asset_service",
    "MutateCampaignBidModifierResult": "google.ads.googleads.v13.services.types.campaign_bid_modifier_service",
    "MutateCampaignBidModifiersRequest": "google.ads.googleads.v13.services.types.campaign_bid_modifier_service",
    "MutateCampaignBidModifiersResponse": "google.ads.googleads.v13.services.types.campaign_bid_modifier_service",
    "MutateCampaignBudgetResult": "google.ads.googleads.v13.services.types.campaign_budget_service",
    "MutateCampaignBudgetsRequest": "google.ads.googleads.v13.services.types.campaign_budget_service",
    "MutateCampaignBudgetsResponse": "google.ads.googleads.v13.services.types.campaign_budget_service",
    "MutateCampaignConversionGoalResult": "google.ads.googleads.v13.services.types.campaign_conversion_goal_service",
    "MutateCampaignConversionGoalsRequest": "google.ads.googleads.v13.services.types.campaign_conversion_goal_service",
    "MutateCampaignConversionGoalsResponse": "google.ads.googleads.v13.services.types.campaign_conversion_goal_service",
    "MutateCampaignCriteriaRequest": "google.ads.googleads.v13.services.types.campaign_criterion_service",
    "MutateCampaignCriteriaResponse": "google.ads.googleads.v13.services.types.campaign_criterion_service",
    "MutateCampaignCriterionResult": "google.ads.googleads.v13.services.types.campaign_criterion_service",
    "MutateCampaignCustomizerResult": "google.ads.googleads.v13.services.types.campaign_customizer_service",
    "MutateCampaignCustomizersRequest": "google.ads.googleads.v13.services.types.campaign_customizer_service",
    "MutateCampaignCustomizersResponse": "google.ads.googleads.v13.services.types.campaign_customizer_service",
    "MutateCampaignDraftResult": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "MutateCampaignDraftsRequest": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "MutateCampaignDraftsResponse": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "MutateCampaignExtensionSettingResult": "google.ads.googleads.v13.services.types.campaign_extension_setting_service",
    "MutateCampaignExtensionSettingsRequest": "google.ads.googleads.v13.services.types.campaign_extension_setting_service",
    "MutateCampaignExtensionSettingsResponse": "google.ads.googleads.v13.services.types.campaign_extension_setting_service",
    "MutateCampaignFeedResult": "google.ads.googleads.v13.services.types.campaign_feed_service",
    "MutateCampaignFeedsRequest": "google.ads.googleads.v13.services.types.campaign_feed_service",
    "MutateCampaignFeedsResponse": "google.ads.googleads.v13.services.types.campaign_feed_service",
    "MutateCampaignGroupResult": "google.ads.googleads.v13.services.types.campaign_group_service",
    "MutateCampaignGroupsRequest": "google.ads.googleads.v13.services.types.campaign_group_service",
    "MutateCampaignGroupsResponse": "google.ads.googleads.v13.services.types.campaign_group_service",
    "MutateCampaignLabelResult": "google.ads.googleads.v13.services.types.campaign_label_service",
    "MutateCampaignLabelsRequest": "google.ads.googleads.v13.services.types.campaign_label_service",
    "MutateCampaignLabelsResponse": "google.ads.googleads.v13.services.types.campaign_label_service",
    "MutateCampaignResult": "google.ads.googleads.v13.services.types.campaign_service",
    "MutateCampaignSharedSetResult": "google.ads.googleads.v13.services.types.campaign_shared_set_service",
    "MutateCampaignSharedSetsRequest": "google.ads.googleads.v13.services.types.campaign_shared_set_service",
    "MutateCampaignSharedSetsResponse": "google.ads.googleads.v13.services.types.campaign_shared_set_service",
    "MutateCampaignsRequest": "google.ads.googleads.v13.services.types.campaign_service",
    "MutateCampaignsResponse": "google.ads.googleads.v13.services.types.campaign_service",
    "MutateConversionActionResult": "google.ads.googleads.v13.services.types.conversion_action_service",
    "MutateConversionActionsRequest": "google.ads.googleads.v13.services.types.conversion_action_service",
    "MutateConversionActionsResponse": "google.ads.googleads.v13.services.types.conversion_action_service",
    "MutateConversionCustomVariableResult": "google.ads.googleads.v13.services.types.conversion_custom_variable_service",
    "MutateConversionCustomVariablesRequest": "google.ads.googleads.v13.services.types.conversion_custom_variable_service",
    "MutateConversionCustomVariablesResponse": "google.ads.googleads.v13.services.types.conversion_custom_variable_service",
    "MutateConversionGoalCampaignConfigResult": "google.ads.googleads.v13.services.types.conversion_goal_campaign_config_service",
    "MutateConversionGoalCampaignConfigsRequest": "google.ads.googleads.v13.services.types.conversion_goal_campaign_config_service",
    "MutateConversionGoalCampaignConfigsResponse": "google.ads.googleads.v13.services.types.conversion_goal_campaign_config_service",
    "MutateConversionValueRuleResult": "google.ads.googleads.v13.services.types.conversion_value_rule_service",
    "MutateConversionValueRuleSetResult": "google.ads.googleads.v13.services.types.conversion_value_rule_set_service",
    "MutateConversionValueRuleSetsRequest": "google.ads.googleads.v13.services.types.conversion_value_rule_set_service",
    "MutateConversionValueRuleSetsResponse": "google.ads.googleads.v13.services.types.conversion_value_rule_set_service",
    "MutateConversionValueRulesRequest": "google.ads.googleads.v13.services.types.conversion_value_rule_service",
    "MutateConversionValueRulesResponse": "google.ads.googleads.v13.services.types.conversion_value_rule_service",
    "MutateCustomAudienceResult": "google.ads.googleads.v13.services.types.custom_audience_service",
    "MutateCustomAudiencesRequest": "google.ads.googleads.v13.services.types.custom_audience_service",
    "MutateCustomAudiencesResponse": "google.ads.googleads.v13.services.types.custom_audience_service",
    "MutateCustomConversionGoalResult": "google.ads.googleads.v13.services.types.custom_conversion_goal_service",
    "MutateCustomConversionGoalsRequest": "google.ads.googleads.v13.services.types.custom_conversion_goal_service",
    "MutateCustomConversionGoalsResponse": "google.ads.googleads.v13.services.types.custom_conversion_goal_service",
    "MutateCustomerAssetResult": "google.ads.googleads.v13.services.types.customer_asset_service",
    "MutateCustomerAssetSetResult": "google.ads.googleads.v13.services.types.customer_asset_set_service",
    "MutateCustomerAssetSetsRequest": "google.ads.googleads.v13.services.types.customer_asset_set_service",
    "MutateCustomerAssetSetsResponse": "google.ads.googleads.v13.services.types.customer_asset_set_service",
    "MutateCustomerAssetsRequest": "google.ads.googleads.v13.services.types.customer_asset_service",
    "MutateCustomerAssetsResponse": "google.ads.googleads.v13.services.types.customer_asset_service",
    "MutateCustomerClientLinkRequest": "google.ads.googleads.v13.services.types.customer_client_link_service",
    "MutateCustomerClientLinkResponse": "google.ads.googleads.v13.services.types.customer_client_link_service",
    "MutateCustomerClientLinkResult": "google.ads.googleads.v13.services.types.customer_client_link_service",
    "MutateCustomerConversionGoalResult": "google.ads.googleads.v13.services.types.customer_conversion_goal_service",
    "MutateCustomerConversionGoalsRequest": "google.ads.googleads.v13.services.types.customer_conversion_goal_service",
    "MutateCustomerConversionGoalsResponse": "google.ads.googleads.v13.services.types.customer_conversion_goal_service",
    "MutateCustomerCustomizerResult": "google.ads.googleads.v13.services.types.customer_customizer_service",
    "MutateCustomerCustomizersRequest": "google.ads.googleads.v13.services.types.customer_customizer_service",
    "MutateCustomerCustomizersResponse": "google.ads.googleads.v13.services.types.customer_customizer_service",
    "MutateCustomerExtensionSettingResult": "google.ads.googleads.v13.services.types.customer_extension_setting_service",
    "MutateCustomerExtensionSettingsRequest": "google.ads.googleads.v13.services.types.customer_extension_setting_service",
    "MutateCustomerExtensionSettingsResponse": "google.ads.googleads.v13.services.types.customer_extension_setting_service",
    "MutateCustomerFeedResult": "google.ads.googleads.v13.services.types.customer_feed_service",
    "MutateCustomerFeedsRequest": "google.ads.googleads.v13.services.types.customer_feed_service",
    "MutateCustomerFeedsResponse": "google.ads.googleads.v13.services.types.customer_feed_service",
    "MutateCustomerLabelResult": "google.ads.googleads.v13.services.types.customer_label_service",
    "MutateCustomerLabelsRequest": "google.ads.googleads.v13.services.types.customer_label_service",
    "MutateCustomerLabelsResponse": "google.ads.googleads.v13.services.types.customer_label_service",
    "MutateCustomerManagerLinkRequest": "google.ads.googleads.v13.services.types.customer_manager_link_service",
    "MutateCustomerManagerLinkResponse": "google.ads.googleads.v13.services.types.customer_manager_link_service",
    "MutateCustomerManagerLinkResult": "google.ads.googleads.v13.services.types.customer_manager_link_service",
    "MutateCustomerNegativeCriteriaRequest": "google.ads.googleads.v13.services.types.customer_negative_criterion_service",
    "MutateCustomerNegativeCriteriaResponse": "google.ads.googleads.v13.services.types.customer_negative_criterion_service",
    "MutateCustomerNegativeCriteriaResult": "google.ads.googleads.v13.services.types.customer_negative_criterion_service",
    "MutateCustomerRequest": "google.ads.googleads.v13.services.types.customer_service",
    "MutateCustomerResponse": "google.ads.googleads.v13.services.types.customer_service",
    "MutateCustomerResult": "google.ads.googleads.v13.services.types.customer_service",
    "MutateCustomerUserAccessInvitationRequest": "google.ads.googleads.v13.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessInvitationResponse": "google.ads.googleads.v13.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessInvitationResult": "google.ads.googleads.v13.services.types.customer_user_access_invitation_service",
    "MutateCustomerUserAccessRequest": "google.ads.googleads.v13.services.types.customer_user_access_service",
    "MutateCustomerUserAccessResponse": "google.ads.googleads.v13.services.types.customer_user_access_service",
    "MutateCustomerUserAccessResult": "google.ads.googleads.v13.services.types.customer_user_access_service",
    "MutateCustomInterestResult": "google.ads.googleads.v13.services.types.custom_interest_service",
    "MutateCustomInterestsRequest": "google.ads.googleads.v13.services.types.custom_interest_service",
    "MutateCustomInterestsResponse": "google.ads.googleads.v13.services.types.custom_interest_service",
    "MutateCustomizerAttributeResult": "google.ads.googleads.v13.services.types.customizer_attribute_service",
    "MutateCustomizerAttributesRequest": "google.ads.googleads.v13.services.types.customizer_attribute_service",
    "MutateCustomizerAttributesResponse": "google.ads.googleads.v13.services.types.customizer_attribute_service",
    "MutateExperimentArmResult": "google.ads.googleads.v13.services.types.experiment_arm_service",
    "MutateExperimentArmsRequest": "google.ads.googleads.v13.services.types.experiment_arm_service",
    "MutateExperimentArmsResponse": "google.ads.googleads.v13.services.types.experiment_arm_service",
    "MutateExperimentResult": "google.ads.googleads.v13.services.types.experiment_service",
    "MutateExperimentsRequest": "google.ads.googleads.v13.services.types.experiment_service",
    "MutateExperimentsResponse": "google.ads.googleads.v13.services.types.experiment_service",
    "MutateExtensionFeedItemResult": "google.ads.googleads.v13.services.types.extension_feed_item_service",
    "MutateExtensionFeedItemsRequest": "google.ads.googleads.v13.services.types.extension_feed_item_service",
    "MutateExtensionFeedItemsResponse": "google.ads.googleads.v13.services.types.extension_feed_item_service",
    "MutateFeedItemResult": "google.ads.googleads.v13.services.types.feed_item_service",
    "MutateFeedItemSetLinkResult": "google.ads.googleads.v13.services.types.feed_item_set_link_service",
    "MutateFeedItemSetLinksRequest": "google.ads.googleads.v13.services.types.feed_item_set_link_service",
    "MutateFeedItemSetLinksResponse": "google.ads.googleads.v13.services.types.feed_item_set_link_service",
    "MutateFeedItemSetResult": "google.ads.googleads.v13.services.types.feed_item_set_service",
    "MutateFeedItemSetsRequest": "google.ads.googleads.v13.services.types.feed_item_set_service",
    "MutateFeedItemSetsResponse": "google.ads.googleads.v13.services.types.feed_item_set_service",
    "MutateFeedItemsRequest": "google.ads.googleads.v13.services.types.feed_item_service",
    "MutateFeedItemsResponse": "google.ads.googleads.v13.services.types.feed_item_service",
    "MutateFeedItemTargetResult": "google.ads.googleads.v13.services.types.feed_item_target_service",
    "MutateFeedItemTargetsRequest": "google.ads.googleads.v13.services.types.feed_item_target_service",
    "MutateFeedItemTargetsResponse": "google.ads.googleads.v13.services.types.feed_item_target_service",
    "MutateFeedMappingResult": "google.ads.googleads.v13.services.types.feed_mapping_service",
    "MutateFeedMappingsRequest": "google.ads.googleads.v13.services.types.feed_mapping_service",
    "MutateFeedMappingsResponse": "google.ads.googleads.v13.services.types.feed_mapping_service",
    "MutateFeedResult": "google.ads.googleads.v13.services.types.feed_service",
    "MutateFeedsRequest": "google.ads.googleads.v13.services.types.feed_service",
    "MutateFeedsResponse": "google.ads.googleads.v13.services.types.feed_service",
    "MutateGoogleAdsRequest": "google.ads.googleads.v13.services.types.google_ads_service",
    "MutateGoogleAdsResponse": "google.ads.googleads.v13.services.types.google_ads_service",
    "MutateKeywordPlanAdGroupKeywordResult": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupKeywordsRequest": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupKeywordsResponse": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_keyword_service",
    "MutateKeywordPlanAdGroupResult": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanAdGroupsRequest": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanAdGroupsResponse": "google.ads.googleads.v13.services.types.keyword_plan_ad_group_service",
    "MutateKeywordPlanCampaignKeywordResult": "google.ads.googleads.v13.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignKeywordsRequest": "google.ads.googleads.v13.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignKeywordsResponse": "google.ads.googleads.v13.services.types.keyword_plan_campaign_keyword_service",
    "MutateKeywordPlanCampaignResult": "google.ads.googleads.v13.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlanCampaignsRequest": "google.ads.googleads.v13.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlanCampaignsResponse": "google.ads.googleads.v13.services.types.keyword_plan_campaign_service",
    "MutateKeywordPlansRequest": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "MutateKeywordPlansResponse": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "MutateKeywordPlansResult": "google.ads.googleads.v13.services.types.keyword_plan_service",
    "MutateLabelResult": "google.ads.googleads.v13.services.types.label_service",
    "MutateLabelsRequest": "google.ads.googleads.v13.services.types.label_service",
    "MutateLabelsResponse": "google.ads.googleads.v13.services.types.label_service",
    "MutateMediaFileResult": "google.ads.googleads.v13.services.types.media_file_service",
    "MutateMediaFilesRequest": "google.ads.googleads.v13.services.types.media_file_service",
    "MutateMediaFilesResponse": "google.ads.googleads.v13.services.types.media_file_service",
    "MutateMerchantCenterLinkRequest": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "MutateMerchantCenterLinkResponse": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "MutateMerchantCenterLinkResult": "google.ads.googleads.v13.services.types.merchant_center_link_service",
    "MutateOperation": "google.ads.googleads.v13.services.types.google_ads_service",
    "MutateOperationResponse": "google.ads.googleads.v13.services.types.google_ads_service",
    "MutateRemarketingActionResult": "google.ads.googleads.v13.services.types.remarketing_action_service",
    "MutateRemarketingActionsRequest": "google.ads.googleads.v13.services.types.remarketing_action_service",
    "MutateRemarketingActionsResponse": "google.ads.googleads.v13.services.types.remarketing_action_service",
    "MutateSharedCriteriaRequest": "google.ads.googleads.v13.services.types.shared_criterion_service",
    "MutateSharedCriteriaResponse": "google.ads.googleads.v13.services.types.shared_criterion_service",
    "MutateSharedCriterionResult": "google.ads.googleads.v13.services.types.shared_criterion_service",
    "MutateSharedSetResult": "google.ads.googleads.v13.services.types.shared_set_service",
    "MutateSharedSetsRequest": "google.ads.googleads.v13.services.types.shared_set_service",
    "MutateSharedSetsResponse": "google.ads.googleads.v13.services.types.shared_set_service",
    "MutateSmartCampaignSettingResult": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "MutateSmartCampaignSettingsRequest": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "MutateSmartCampaignSettingsResponse": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "MutateUserListResult": "google.ads.googleads.v13.services.types.user_list_service",
    "MutateUserListsRequest": "google.ads.googleads.v13.services.types.user_list_service",
    "MutateUserListsResponse": "google.ads.googleads.v13.services.types.user_list_service",
    "OfflineUserDataJobOperation": "google.ads.googleads.v13.services.types.offline_user_data_job_service",
    "OnTargetAudienceMetrics": "google.ads.googleads.v13.services.types.reach_plan_service",
    "PlannableLocation": "google.ads.googleads.v13.services.types.reach_plan_service",
    "PlannableTargeting": "google.ads.googleads.v13.services.types.reach_plan_service",
    "PlannedProduct": "google.ads.googleads.v13.services.types.reach_plan_service",
    "PlannedProductForecast": "google.ads.googleads.v13.services.types.reach_plan_service",
    "PlannedProductReachForecast": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ProductMetadata": "google.ads.googleads.v13.services.types.reach_plan_service",
    "PromoteCampaignDraftRequest": "google.ads.googleads.v13.services.types.campaign_draft_service",
    "PromoteExperimentMetadata": "google.ads.googleads.v13.services.types.experiment_service",
    "PromoteExperimentRequest": "google.ads.googleads.v13.services.types.experiment_service",
    "ReachCurve": "google.ads.googleads.v13.services.types.reach_plan_service",
    "ReachForecast": "google.ads.googleads.v13.services.types.reach_plan_service",
    "RegenerateShareableLinkIdRequest": "google.ads.googleads.v13.services.types.third_party_app_analytics_link_service",
    "RegenerateShareableLinkIdResponse": "google.ads.googleads.v13.services.types.third_party_app_analytics_link_service",
    "RemarketingActionOperation": "google.ads.googleads.v13.services.types.remarketing_action_service",
    "RemoveProductLinkRequest": "google.ads.googleads.v13.services.types.product_link_service",
    "RemoveProductLinkResponse": "google.ads.googleads.v13.services.types.product_link_service",
    "RestatementValue": "google.ads.googleads.v13.services.types.conversion_adjustment_upload_service",
    "RunBatchJobRequest": "google.ads.googleads.v13.services.types.batch_job_service",
    "RunOfflineUserDataJobRequest": "google.ads.googleads.v13.services.types.offline_user_data_job_service",
    "ScheduleExperimentMetadata": "google.ads.googleads.v13.services.types.experiment_service",
    "ScheduleExperimentRequest": "google.ads.googleads.v13.services.types.experiment_service",
    "SearchGoogleAdsFieldsRequest": "google.ads.googleads.v13.services.types.google_ads_field_service",
    "SearchGoogleAdsFieldsResponse": "google.ads.googleads.v13.services.types.google_ads_field_service",
    "SearchGoogleAdsRequest": "google.ads.googleads.v13.services.types.google_ads_service",
    "SearchGoogleAdsResponse": "google.ads.googleads.v13.services.types.google_ads_service",
    "SearchGoogleAdsStreamRequest": "google.ads.googleads.v13.services.types.google_ads_service",
    "SearchGoogleAdsStreamResponse": "google.ads.googleads.v13.services.types.google_ads_service",
    "SharedCriterionOperation": "google.ads.googleads.v13.services.types.shared_criterion_service",
    "SharedSetOperation": "google.ads.googleads.v13.services.types.shared_set_service",
    "SiteSeed": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "SmartCampaignEligibleDetails": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "SmartCampaignEndedDetails": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "SmartCampaignNotEligibleDetails": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "SmartCampaignPausedDetails": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "SmartCampaignRemovedDetails": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "SmartCampaignSettingOperation": "google.ads.googleads.v13.services.types.smart_campaign_setting_service",
    "SmartCampaignSuggestionInfo": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestGeoTargetConstantsRequest": "google.ads.googleads.v13.services.types.geo_target_constant_service",
    "SuggestGeoTargetConstantsResponse": "google.ads.googleads.v13.services.types.geo_target_constant_service",
    "SuggestKeywordThemeConstantsRequest": "google.ads.googleads.v13.services.types.keyword_theme_constant_service",
    "SuggestKeywordThemeConstantsResponse": "google.ads.googleads.v13.services.types.keyword_theme_constant_service",
    "SuggestKeywordThemesRequest": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestKeywordThemesResponse": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignAdRequest": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignAdResponse": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignBudgetOptionsRequest": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestSmartCampaignBudgetOptionsResponse": "google.ads.googleads.v13.services.types.smart_campaign_suggest_service",
    "SuggestTravelAssetsRequest": "google.ads.googleads.v13.services.types.travel_asset_suggestion_service",
    "SuggestTravelAssetsResponse": "google.ads.googleads.v13.services.types.travel_asset_suggestion_service",
    "Targeting": "google.ads.googleads.v13.services.types.reach_plan_service",
    "UnusableAdGroup": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "UploadCallConversionsRequest": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "UploadCallConversionsResponse": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "UploadClickConversionsRequest": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "UploadClickConversionsResponse": "google.ads.googleads.v13.services.types.conversion_upload_service",
    "UploadConversionAdjustmentsRequest": "google.ads.googleads.v13.services.types.conversion_adjustment_upload_service",
    "UploadConversionAdjustmentsResponse": "google.ads.googleads.v13.services.types.conversion_adjustment_upload_service",
    "UploadUserDataRequest": "google.ads.googleads.v13.services.types.user_data_service",
    "UploadUserDataResponse": "google.ads.googleads.v13.services.types.user_data_service",
    "UrlSeed": "google.ads.googleads.v13.services.types.keyword_plan_idea_service",
    "UserDataOperation": "google.ads.googleads.v13.services.types.user_data_service",
    "UserListOperation": "google.ads.googleads.v13.services.types.user_list_service",
    "YouTubeChannelAttributeMetadata": "google.ads.googleads.v13.services.types.audience_insights_service",
    "YouTubeSelectLineUp": "google.ads.googleads.v13.services.types.reach_plan_service",
    "YouTubeSelectSettings": "google.ads.googleads.v13.services.types.reach_plan_service",
    # Enum types
    # Client classes and transports
    "AccountBudgetProposalServiceClient": "google.ads.googleads.v13.services.services.account_budget_proposal_service",
    "AccountBudgetProposalServiceTransport": "google.ads.googleads.v13.services.services.account_budget_proposal_service.transports",
    "AccountBudgetProposalServiceGrpcTransport": "google.ads.googleads.v13.services.services.account_budget_proposal_service.transports",
    "AccountLinkServiceClient": "google.ads.googleads.v13.services.services.account_link_service",
    "AccountLinkServiceTransport": "google.ads.googleads.v13.services.services.account_link_service.transports",
    "AccountLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.account_link_service.transports",
    "AdGroupAdLabelServiceClient": "google.ads.googleads.v13.services.services.ad_group_ad_label_service",
    "AdGroupAdLabelServiceTransport": "google.ads.googleads.v13.services.services.ad_group_ad_label_service.transports",
    "AdGroupAdLabelServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_ad_label_service.transports",
    "AdGroupAdServiceClient": "google.ads.googleads.v13.services.services.ad_group_ad_service",
    "AdGroupAdServiceTransport": "google.ads.googleads.v13.services.services.ad_group_ad_service.transports",
    "AdGroupAdServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_ad_service.transports",
    "AdGroupAssetServiceClient": "google.ads.googleads.v13.services.services.ad_group_asset_service",
    "AdGroupAssetServiceTransport": "google.ads.googleads.v13.services.services.ad_group_asset_service.transports",
    "AdGroupAssetServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_asset_service.transports",
    "AdGroupAssetSetServiceClient": "google.ads.googleads.v13.services.services.ad_group_asset_set_service",
    "AdGroupAssetSetServiceTransport": "google.ads.googleads.v13.services.services.ad_group_asset_set_service.transports",
    "AdGroupAssetSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_asset_set_service.transports",
    "AdGroupBidModifierServiceClient": "google.ads.googleads.v13.services.services.ad_group_bid_modifier_service",
    "AdGroupBidModifierServiceTransport": "google.ads.googleads.v13.services.services.ad_group_bid_modifier_service.transports",
    "AdGroupBidModifierServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_bid_modifier_service.transports",
    "AdGroupCriterionCustomizerServiceClient": "google.ads.googleads.v13.services.services.ad_group_criterion_customizer_service",
    "AdGroupCriterionCustomizerServiceTransport": "google.ads.googleads.v13.services.services.ad_group_criterion_customizer_service.transports",
    "AdGroupCriterionCustomizerServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_criterion_customizer_service.transports",
    "AdGroupCriterionLabelServiceClient": "google.ads.googleads.v13.services.services.ad_group_criterion_label_service",
    "AdGroupCriterionLabelServiceTransport": "google.ads.googleads.v13.services.services.ad_group_criterion_label_service.transports",
    "AdGroupCriterionLabelServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_criterion_label_service.transports",
    "AdGroupCriterionServiceClient": "google.ads.googleads.v13.services.services.ad_group_criterion_service",
    "AdGroupCriterionServiceTransport": "google.ads.googleads.v13.services.services.ad_group_criterion_service.transports",
    "AdGroupCriterionServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_criterion_service.transports",
    "AdGroupCustomizerServiceClient": "google.ads.googleads.v13.services.services.ad_group_customizer_service",
    "AdGroupCustomizerServiceTransport": "google.ads.googleads.v13.services.services.ad_group_customizer_service.transports",
    "AdGroupCustomizerServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_customizer_service.transports",
    "AdGroupExtensionSettingServiceClient": "google.ads.googleads.v13.services.services.ad_group_extension_setting_service",
    "AdGroupExtensionSettingServiceTransport": "google.ads.googleads.v13.services.services.ad_group_extension_setting_service.transports",
    "AdGroupExtensionSettingServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_extension_setting_service.transports",
    "AdGroupFeedServiceClient": "google.ads.googleads.v13.services.services.ad_group_feed_service",
    "AdGroupFeedServiceTransport": "google.ads.googleads.v13.services.services.ad_group_feed_service.transports",
    "AdGroupFeedServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_feed_service.transports",
    "AdGroupLabelServiceClient": "google.ads.googleads.v13.services.services.ad_group_label_service",
    "AdGroupLabelServiceTransport": "google.ads.googleads.v13.services.services.ad_group_label_service.transports",
    "AdGroupLabelServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_label_service.transports",
    "AdGroupServiceClient": "google.ads.googleads.v13.services.services.ad_group_service",
    "AdGroupServiceTransport": "google.ads.googleads.v13.services.services.ad_group_service.transports",
    "AdGroupServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_group_service.transports",
    "AdParameterServiceClient": "google.ads.googleads.v13.services.services.ad_parameter_service",
    "AdParameterServiceTransport": "google.ads.googleads.v13.services.services.ad_parameter_service.transports",
    "AdParameterServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_parameter_service.transports",
    "AdServiceClient": "google.ads.googleads.v13.services.services.ad_service",
    "AdServiceTransport": "google.ads.googleads.v13.services.services.ad_service.transports",
    "AdServiceGrpcTransport": "google.ads.googleads.v13.services.services.ad_service.transports",
    "AssetGroupAssetServiceClient": "google.ads.googleads.v13.services.services.asset_group_asset_service",
    "AssetGroupAssetServiceTransport": "google.ads.googleads.v13.services.services.asset_group_asset_service.transports",
    "AssetGroupAssetServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_group_asset_service.transports",
    "AssetGroupListingGroupFilterServiceClient": "google.ads.googleads.v13.services.services.asset_group_listing_group_filter_service",
    "AssetGroupListingGroupFilterServiceTransport": "google.ads.googleads.v13.services.services.asset_group_listing_group_filter_service.transports",
    "AssetGroupListingGroupFilterServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_group_listing_group_filter_service.transports",
    "AssetGroupServiceClient": "google.ads.googleads.v13.services.services.asset_group_service",
    "AssetGroupServiceTransport": "google.ads.googleads.v13.services.services.asset_group_service.transports",
    "AssetGroupServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_group_service.transports",
    "AssetGroupSignalServiceClient": "google.ads.googleads.v13.services.services.asset_group_signal_service",
    "AssetGroupSignalServiceTransport": "google.ads.googleads.v13.services.services.asset_group_signal_service.transports",
    "AssetGroupSignalServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_group_signal_service.transports",
    "AssetServiceClient": "google.ads.googleads.v13.services.services.asset_service",
    "AssetServiceTransport": "google.ads.googleads.v13.services.services.asset_service.transports",
    "AssetServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_service.transports",
    "AssetSetAssetServiceClient": "google.ads.googleads.v13.services.services.asset_set_asset_service",
    "AssetSetAssetServiceTransport": "google.ads.googleads.v13.services.services.asset_set_asset_service.transports",
    "AssetSetAssetServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_set_asset_service.transports",
    "AssetSetServiceClient": "google.ads.googleads.v13.services.services.asset_set_service",
    "AssetSetServiceTransport": "google.ads.googleads.v13.services.services.asset_set_service.transports",
    "AssetSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.asset_set_service.transports",
    "AudienceInsightsServiceClient": "google.ads.googleads.v13.services.services.audience_insights_service",
    "AudienceInsightsServiceTransport": "google.ads.googleads.v13.services.services.audience_insights_service.transports",
    "AudienceInsightsServiceGrpcTransport": "google.ads.googleads.v13.services.services.audience_insights_service.transports",
    "AudienceServiceClient": "google.ads.googleads.v13.services.services.audience_service",
    "AudienceServiceTransport": "google.ads.googleads.v13.services.services.audience_service.transports",
    "AudienceServiceGrpcTransport": "google.ads.googleads.v13.services.services.audience_service.transports",
    "BatchJobServiceClient": "google.ads.googleads.v13.services.services.batch_job_service",
    "BatchJobServiceTransport": "google.ads.googleads.v13.services.services.batch_job_service.transports",
    "BatchJobServiceGrpcTransport": "google.ads.googleads.v13.services.services.batch_job_service.transports",
    "BiddingDataExclusionServiceClient": "google.ads.googleads.v13.services.services.bidding_data_exclusion_service",
    "BiddingDataExclusionServiceTransport": "google.ads.googleads.v13.services.services.bidding_data_exclusion_service.transports",
    "BiddingDataExclusionServiceGrpcTransport": "google.ads.googleads.v13.services.services.bidding_data_exclusion_service.transports",
    "BiddingSeasonalityAdjustmentServiceClient": "google.ads.googleads.v13.services.services.bidding_seasonality_adjustment_service",
    "BiddingSeasonalityAdjustmentServiceTransport": "google.ads.googleads.v13.services.services.bidding_seasonality_adjustment_service.transports",
    "BiddingSeasonalityAdjustmentServiceGrpcTransport": "google.ads.googleads.v13.services.services.bidding_seasonality_adjustment_service.transports",
    "BiddingStrategyServiceClient": "google.ads.googleads.v13.services.services.bidding_strategy_service",
    "BiddingStrategyServiceTransport": "google.ads.googleads.v13.services.services.bidding_strategy_service.transports",
    "BiddingStrategyServiceGrpcTransport": "google.ads.googleads.v13.services.services.bidding_strategy_service.transports",
    "BillingSetupServiceClient": "google.ads.googleads.v13.services.services.billing_setup_service",
    "BillingSetupServiceTransport": "google.ads.googleads.v13.services.services.billing_setup_service.transports",
    "BillingSetupServiceGrpcTransport": "google.ads.googleads.v13.services.services.billing_setup_service.transports",
    "CampaignAssetServiceClient": "google.ads.googleads.v13.services.services.campaign_asset_service",
    "CampaignAssetServiceTransport": "google.ads.googleads.v13.services.services.campaign_asset_service.transports",
    "CampaignAssetServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_asset_service.transports",
    "CampaignAssetSetServiceClient": "google.ads.googleads.v13.services.services.campaign_asset_set_service",
    "CampaignAssetSetServiceTransport": "google.ads.googleads.v13.services.services.campaign_asset_set_service.transports",
    "CampaignAssetSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_asset_set_service.transports",
    "CampaignBidModifierServiceClient": "google.ads.googleads.v13.services.services.campaign_bid_modifier_service",
    "CampaignBidModifierServiceTransport": "google.ads.googleads.v13.services.services.campaign_bid_modifier_service.transports",
    "CampaignBidModifierServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_bid_modifier_service.transports",
    "CampaignBudgetServiceClient": "google.ads.googleads.v13.services.services.campaign_budget_service",
    "CampaignBudgetServiceTransport": "google.ads.googleads.v13.services.services.campaign_budget_service.transports",
    "CampaignBudgetServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_budget_service.transports",
    "CampaignConversionGoalServiceClient": "google.ads.googleads.v13.services.services.campaign_conversion_goal_service",
    "CampaignConversionGoalServiceTransport": "google.ads.googleads.v13.services.services.campaign_conversion_goal_service.transports",
    "CampaignConversionGoalServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_conversion_goal_service.transports",
    "CampaignCriterionServiceClient": "google.ads.googleads.v13.services.services.campaign_criterion_service",
    "CampaignCriterionServiceTransport": "google.ads.googleads.v13.services.services.campaign_criterion_service.transports",
    "CampaignCriterionServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_criterion_service.transports",
    "CampaignCustomizerServiceClient": "google.ads.googleads.v13.services.services.campaign_customizer_service",
    "CampaignCustomizerServiceTransport": "google.ads.googleads.v13.services.services.campaign_customizer_service.transports",
    "CampaignCustomizerServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_customizer_service.transports",
    "CampaignDraftServiceClient": "google.ads.googleads.v13.services.services.campaign_draft_service",
    "CampaignDraftServiceTransport": "google.ads.googleads.v13.services.services.campaign_draft_service.transports",
    "CampaignDraftServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_draft_service.transports",
    "CampaignExtensionSettingServiceClient": "google.ads.googleads.v13.services.services.campaign_extension_setting_service",
    "CampaignExtensionSettingServiceTransport": "google.ads.googleads.v13.services.services.campaign_extension_setting_service.transports",
    "CampaignExtensionSettingServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_extension_setting_service.transports",
    "CampaignFeedServiceClient": "google.ads.googleads.v13.services.services.campaign_feed_service",
    "CampaignFeedServiceTransport": "google.ads.googleads.v13.services.services.campaign_feed_service.transports",
    "CampaignFeedServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_feed_service.transports",
    "CampaignGroupServiceClient": "google.ads.googleads.v13.services.services.campaign_group_service",
    "CampaignGroupServiceTransport": "google.ads.googleads.v13.services.services.campaign_group_service.transports",
    "CampaignGroupServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_group_service.transports",
    "CampaignLabelServiceClient": "google.ads.googleads.v13.services.services.campaign_label_service",
    "CampaignLabelServiceTransport": "google.ads.googleads.v13.services.services.campaign_label_service.transports",
    "CampaignLabelServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_label_service.transports",
    "CampaignServiceClient": "google.ads.googleads.v13.services.services.campaign_service",
    "CampaignServiceTransport": "google.ads.googleads.v13.services.services.campaign_service.transports",
    "CampaignServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_service.transports",
    "CampaignSharedSetServiceClient": "google.ads.googleads.v13.services.services.campaign_shared_set_service",
    "CampaignSharedSetServiceTransport": "google.ads.googleads.v13.services.services.campaign_shared_set_service.transports",
    "CampaignSharedSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.campaign_shared_set_service.transports",
    "ConversionActionServiceClient": "google.ads.googleads.v13.services.services.conversion_action_service",
    "ConversionActionServiceTransport": "google.ads.googleads.v13.services.services.conversion_action_service.transports",
    "ConversionActionServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_action_service.transports",
    "ConversionAdjustmentUploadServiceClient": "google.ads.googleads.v13.services.services.conversion_adjustment_upload_service",
    "ConversionAdjustmentUploadServiceTransport": "google.ads.googleads.v13.services.services.conversion_adjustment_upload_service.transports",
    "ConversionAdjustmentUploadServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_adjustment_upload_service.transports",
    "ConversionCustomVariableServiceClient": "google.ads.googleads.v13.services.services.conversion_custom_variable_service",
    "ConversionCustomVariableServiceTransport": "google.ads.googleads.v13.services.services.conversion_custom_variable_service.transports",
    "ConversionCustomVariableServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_custom_variable_service.transports",
    "ConversionGoalCampaignConfigServiceClient": "google.ads.googleads.v13.services.services.conversion_goal_campaign_config_service",
    "ConversionGoalCampaignConfigServiceTransport": "google.ads.googleads.v13.services.services.conversion_goal_campaign_config_service.transports",
    "ConversionGoalCampaignConfigServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_goal_campaign_config_service.transports",
    "ConversionUploadServiceClient": "google.ads.googleads.v13.services.services.conversion_upload_service",
    "ConversionUploadServiceTransport": "google.ads.googleads.v13.services.services.conversion_upload_service.transports",
    "ConversionUploadServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_upload_service.transports",
    "ConversionValueRuleServiceClient": "google.ads.googleads.v13.services.services.conversion_value_rule_service",
    "ConversionValueRuleServiceTransport": "google.ads.googleads.v13.services.services.conversion_value_rule_service.transports",
    "ConversionValueRuleServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_value_rule_service.transports",
    "ConversionValueRuleSetServiceClient": "google.ads.googleads.v13.services.services.conversion_value_rule_set_service",
    "ConversionValueRuleSetServiceTransport": "google.ads.googleads.v13.services.services.conversion_value_rule_set_service.transports",
    "ConversionValueRuleSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.conversion_value_rule_set_service.transports",
    "CustomAudienceServiceClient": "google.ads.googleads.v13.services.services.custom_audience_service",
    "CustomAudienceServiceTransport": "google.ads.googleads.v13.services.services.custom_audience_service.transports",
    "CustomAudienceServiceGrpcTransport": "google.ads.googleads.v13.services.services.custom_audience_service.transports",
    "CustomConversionGoalServiceClient": "google.ads.googleads.v13.services.services.custom_conversion_goal_service",
    "CustomConversionGoalServiceTransport": "google.ads.googleads.v13.services.services.custom_conversion_goal_service.transports",
    "CustomConversionGoalServiceGrpcTransport": "google.ads.googleads.v13.services.services.custom_conversion_goal_service.transports",
    "CustomerAssetServiceClient": "google.ads.googleads.v13.services.services.customer_asset_service",
    "CustomerAssetServiceTransport": "google.ads.googleads.v13.services.services.customer_asset_service.transports",
    "CustomerAssetServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_asset_service.transports",
    "CustomerAssetSetServiceClient": "google.ads.googleads.v13.services.services.customer_asset_set_service",
    "CustomerAssetSetServiceTransport": "google.ads.googleads.v13.services.services.customer_asset_set_service.transports",
    "CustomerAssetSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_asset_set_service.transports",
    "CustomerClientLinkServiceClient": "google.ads.googleads.v13.services.services.customer_client_link_service",
    "CustomerClientLinkServiceTransport": "google.ads.googleads.v13.services.services.customer_client_link_service.transports",
    "CustomerClientLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_client_link_service.transports",
    "CustomerConversionGoalServiceClient": "google.ads.googleads.v13.services.services.customer_conversion_goal_service",
    "CustomerConversionGoalServiceTransport": "google.ads.googleads.v13.services.services.customer_conversion_goal_service.transports",
    "CustomerConversionGoalServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_conversion_goal_service.transports",
    "CustomerCustomizerServiceClient": "google.ads.googleads.v13.services.services.customer_customizer_service",
    "CustomerCustomizerServiceTransport": "google.ads.googleads.v13.services.services.customer_customizer_service.transports",
    "CustomerCustomizerServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_customizer_service.transports",
    "CustomerExtensionSettingServiceClient": "google.ads.googleads.v13.services.services.customer_extension_setting_service",
    "CustomerExtensionSettingServiceTransport": "google.ads.googleads.v13.services.services.customer_extension_setting_service.transports",
    "CustomerExtensionSettingServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_extension_setting_service.transports",
    "CustomerFeedServiceClient": "google.ads.googleads.v13.services.services.customer_feed_service",
    "CustomerFeedServiceTransport": "google.ads.googleads.v13.services.services.customer_feed_service.transports",
    "CustomerFeedServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_feed_service.transports",
    "CustomerLabelServiceClient": "google.ads.googleads.v13.services.services.customer_label_service",
    "CustomerLabelServiceTransport": "google.ads.googleads.v13.services.services.customer_label_service.transports",
    "CustomerLabelServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_label_service.transports",
    "CustomerManagerLinkServiceClient": "google.ads.googleads.v13.services.services.customer_manager_link_service",
    "CustomerManagerLinkServiceTransport": "google.ads.googleads.v13.services.services.customer_manager_link_service.transports",
    "CustomerManagerLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_manager_link_service.transports",
    "CustomerNegativeCriterionServiceClient": "google.ads.googleads.v13.services.services.customer_negative_criterion_service",
    "CustomerNegativeCriterionServiceTransport": "google.ads.googleads.v13.services.services.customer_negative_criterion_service.transports",
    "CustomerNegativeCriterionServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_negative_criterion_service.transports",
    "CustomerServiceClient": "google.ads.googleads.v13.services.services.customer_service",
    "CustomerServiceTransport": "google.ads.googleads.v13.services.services.customer_service.transports",
    "CustomerServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_service.transports",
    "CustomerUserAccessInvitationServiceClient": "google.ads.googleads.v13.services.services.customer_user_access_invitation_service",
    "CustomerUserAccessInvitationServiceTransport": "google.ads.googleads.v13.services.services.customer_user_access_invitation_service.transports",
    "CustomerUserAccessInvitationServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_user_access_invitation_service.transports",
    "CustomerUserAccessServiceClient": "google.ads.googleads.v13.services.services.customer_user_access_service",
    "CustomerUserAccessServiceTransport": "google.ads.googleads.v13.services.services.customer_user_access_service.transports",
    "CustomerUserAccessServiceGrpcTransport": "google.ads.googleads.v13.services.services.customer_user_access_service.transports",
    "CustomInterestServiceClient": "google.ads.googleads.v13.services.services.custom_interest_service",
    "CustomInterestServiceTransport": "google.ads.googleads.v13.services.services.custom_interest_service.transports",
    "CustomInterestServiceGrpcTransport": "google.ads.googleads.v13.services.services.custom_interest_service.transports",
    "CustomizerAttributeServiceClient": "google.ads.googleads.v13.services.services.customizer_attribute_service",
    "CustomizerAttributeServiceTransport": "google.ads.googleads.v13.services.services.customizer_attribute_service.transports",
    "CustomizerAttributeServiceGrpcTransport": "google.ads.googleads.v13.services.services.customizer_attribute_service.transports",
    "ExperimentArmServiceClient": "google.ads.googleads.v13.services.services.experiment_arm_service",
    "ExperimentArmServiceTransport": "google.ads.googleads.v13.services.services.experiment_arm_service.transports",
    "ExperimentArmServiceGrpcTransport": "google.ads.googleads.v13.services.services.experiment_arm_service.transports",
    "ExperimentServiceClient": "google.ads.googleads.v13.services.services.experiment_service",
    "ExperimentServiceTransport": "google.ads.googleads.v13.services.services.experiment_service.transports",
    "ExperimentServiceGrpcTransport": "google.ads.googleads.v13.services.services.experiment_service.transports",
    "ExtensionFeedItemServiceClient": "google.ads.googleads.v13.services.services.extension_feed_item_service",
    "ExtensionFeedItemServiceTransport": "google.ads.googleads.v13.services.services.extension_feed_item_service.transports",
    "ExtensionFeedItemServiceGrpcTransport": "google.ads.googleads.v13.services.services.extension_feed_item_service.transports",
    "FeedItemServiceClient": "google.ads.googleads.v13.services.services.feed_item_service",
    "FeedItemServiceTransport": "google.ads.googleads.v13.services.services.feed_item_service.transports",
    "FeedItemServiceGrpcTransport": "google.ads.googleads.v13.services.services.feed_item_service.transports",
    "FeedItemSetLinkServiceClient": "google.ads.googleads.v13.services.services.feed_item_set_link_service",
    "FeedItemSetLinkServiceTransport": "google.ads.googleads.v13.services.services.feed_item_set_link_service.transports",
    "FeedItemSetLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.feed_item_set_link_service.transports",
    "FeedItemSetServiceClient": "google.ads.googleads.v13.services.services.feed_item_set_service",
    "FeedItemSetServiceTransport": "google.ads.googleads.v13.services.services.feed_item_set_service.transports",
    "FeedItemSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.feed_item_set_service.transports",
    "FeedItemTargetServiceClient": "google.ads.googleads.v13.services.services.feed_item_target_service",
    "FeedItemTargetServiceTransport": "google.ads.googleads.v13.services.services.feed_item_target_service.transports",
    "FeedItemTargetServiceGrpcTransport": "google.ads.googleads.v13.services.services.feed_item_target_service.transports",
    "FeedMappingServiceClient": "google.ads.googleads.v13.services.services.feed_mapping_service",
    "FeedMappingServiceTransport": "google.ads.googleads.v13.services.services.feed_mapping_service.transports",
    "FeedMappingServiceGrpcTransport": "google.ads.googleads.v13.services.services.feed_mapping_service.transports",
    "FeedServiceClient": "google.ads.googleads.v13.services.services.feed_service",
    "FeedServiceTransport": "google.ads.googleads.v13.services.services.feed_service.transports",
    "FeedServiceGrpcTransport": "google.ads.googleads.v13.services.services.feed_service.transports",
    "GeoTargetConstantServiceClient": "google.ads.googleads.v13.services.services.geo_target_constant_service",
    "GeoTargetConstantServiceTransport": "google.ads.googleads.v13.services.services.geo_target_constant_service.transports",
    "GeoTargetConstantServiceGrpcTransport": "google.ads.googleads.v13.services.services.geo_target_constant_service.transports",
    "GoogleAdsFieldServiceClient": "google.ads.googleads.v13.services.services.google_ads_field_service",
    "GoogleAdsFieldServiceTransport": "google.ads.googleads.v13.services.services.google_ads_field_service.transports",
    "GoogleAdsFieldServiceGrpcTransport": "google.ads.googleads.v13.services.services.google_ads_field_service.transports",
    "GoogleAdsServiceClient": "google.ads.googleads.v13.services.services.google_ads_service",
    "GoogleAdsServiceTransport": "google.ads.googleads.v13.services.services.google_ads_service.transports",
    "GoogleAdsServiceGrpcTransport": "google.ads.googleads.v13.services.services.google_ads_service.transports",
    "InvoiceServiceClient": "google.ads.googleads.v13.services.services.invoice_service",
    "InvoiceServiceTransport": "google.ads.googleads.v13.services.services.invoice_service.transports",
    "InvoiceServiceGrpcTransport": "google.ads.googleads.v13.services.services.invoice_service.transports",
    "KeywordPlanAdGroupKeywordServiceClient": "google.ads.googleads.v13.services.services.keyword_plan_ad_group_keyword_service",
    "KeywordPlanAdGroupKeywordServiceTransport": "google.ads.googleads.v13.services.services.keyword_plan_ad_group_keyword_service.transports",
    "KeywordPlanAdGroupKeywordServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_plan_ad_group_keyword_service.transports",
    "KeywordPlanAdGroupServiceClient": "google.ads.googleads.v13.services.services.keyword_plan_ad_group_service",
    "KeywordPlanAdGroupServiceTransport": "google.ads.googleads.v13.services.services.keyword_plan_ad_group_service.transports",
    "KeywordPlanAdGroupServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_plan_ad_group_service.transports",
    "KeywordPlanCampaignKeywordServiceClient": "google.ads.googleads.v13.services.services.keyword_plan_campaign_keyword_service",
    "KeywordPlanCampaignKeywordServiceTransport": "google.ads.googleads.v13.services.services.keyword_plan_campaign_keyword_service.transports",
    "KeywordPlanCampaignKeywordServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_plan_campaign_keyword_service.transports",
    "KeywordPlanCampaignServiceClient": "google.ads.googleads.v13.services.services.keyword_plan_campaign_service",
    "KeywordPlanCampaignServiceTransport": "google.ads.googleads.v13.services.services.keyword_plan_campaign_service.transports",
    "KeywordPlanCampaignServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_plan_campaign_service.transports",
    "KeywordPlanIdeaServiceClient": "google.ads.googleads.v13.services.services.keyword_plan_idea_service",
    "KeywordPlanIdeaServiceTransport": "google.ads.googleads.v13.services.services.keyword_plan_idea_service.transports",
    "KeywordPlanIdeaServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_plan_idea_service.transports",
    "KeywordPlanServiceClient": "google.ads.googleads.v13.services.services.keyword_plan_service",
    "KeywordPlanServiceTransport": "google.ads.googleads.v13.services.services.keyword_plan_service.transports",
    "KeywordPlanServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_plan_service.transports",
    "KeywordThemeConstantServiceClient": "google.ads.googleads.v13.services.services.keyword_theme_constant_service",
    "KeywordThemeConstantServiceTransport": "google.ads.googleads.v13.services.services.keyword_theme_constant_service.transports",
    "KeywordThemeConstantServiceGrpcTransport": "google.ads.googleads.v13.services.services.keyword_theme_constant_service.transports",
    "LabelServiceClient": "google.ads.googleads.v13.services.services.label_service",
    "LabelServiceTransport": "google.ads.googleads.v13.services.services.label_service.transports",
    "LabelServiceGrpcTransport": "google.ads.googleads.v13.services.services.label_service.transports",
    "MediaFileServiceClient": "google.ads.googleads.v13.services.services.media_file_service",
    "MediaFileServiceTransport": "google.ads.googleads.v13.services.services.media_file_service.transports",
    "MediaFileServiceGrpcTransport": "google.ads.googleads.v13.services.services.media_file_service.transports",
    "MerchantCenterLinkServiceClient": "google.ads.googleads.v13.services.services.merchant_center_link_service",
    "MerchantCenterLinkServiceTransport": "google.ads.googleads.v13.services.services.merchant_center_link_service.transports",
    "MerchantCenterLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.merchant_center_link_service.transports",
    "OfflineUserDataJobServiceClient": "google.ads.googleads.v13.services.services.offline_user_data_job_service",
    "OfflineUserDataJobServiceTransport": "google.ads.googleads.v13.services.services.offline_user_data_job_service.transports",
    "OfflineUserDataJobServiceGrpcTransport": "google.ads.googleads.v13.services.services.offline_user_data_job_service.transports",
    "PaymentsAccountServiceClient": "google.ads.googleads.v13.services.services.payments_account_service",
    "PaymentsAccountServiceTransport": "google.ads.googleads.v13.services.services.payments_account_service.transports",
    "PaymentsAccountServiceGrpcTransport": "google.ads.googleads.v13.services.services.payments_account_service.transports",
    "ProductLinkServiceClient": "google.ads.googleads.v13.services.services.product_link_service",
    "ProductLinkServiceTransport": "google.ads.googleads.v13.services.services.product_link_service.transports",
    "ProductLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.product_link_service.transports",
    "ReachPlanServiceClient": "google.ads.googleads.v13.services.services.reach_plan_service",
    "ReachPlanServiceTransport": "google.ads.googleads.v13.services.services.reach_plan_service.transports",
    "ReachPlanServiceGrpcTransport": "google.ads.googleads.v13.services.services.reach_plan_service.transports",
    "RecommendationServiceClient": "google.ads.googleads.v13.services.services.recommendation_service",
    "RecommendationServiceTransport": "google.ads.googleads.v13.services.services.recommendation_service.transports",
    "RecommendationServiceGrpcTransport": "google.ads.googleads.v13.services.services.recommendation_service.transports",
    "RemarketingActionServiceClient": "google.ads.googleads.v13.services.services.remarketing_action_service",
    "RemarketingActionServiceTransport": "google.ads.googleads.v13.services.services.remarketing_action_service.transports",
    "RemarketingActionServiceGrpcTransport": "google.ads.googleads.v13.services.services.remarketing_action_service.transports",
    "SharedCriterionServiceClient": "google.ads.googleads.v13.services.services.shared_criterion_service",
    "SharedCriterionServiceTransport": "google.ads.googleads.v13.services.services.shared_criterion_service.transports",
    "SharedCriterionServiceGrpcTransport": "google.ads.googleads.v13.services.services.shared_criterion_service.transports",
    "SharedSetServiceClient": "google.ads.googleads.v13.services.services.shared_set_service",
    "SharedSetServiceTransport": "google.ads.googleads.v13.services.services.shared_set_service.transports",
    "SharedSetServiceGrpcTransport": "google.ads.googleads.v13.services.services.shared_set_service.transports",
    "SmartCampaignSettingServiceClient": "google.ads.googleads.v13.services.services.smart_campaign_setting_service",
    "SmartCampaignSettingServiceTransport": "google.ads.googleads.v13.services.services.smart_campaign_setting_service.transports",
    "SmartCampaignSettingServiceGrpcTransport": "google.ads.googleads.v13.services.services.smart_campaign_setting_service.transports",
    "SmartCampaignSuggestServiceClient": "google.ads.googleads.v13.services.services.smart_campaign_suggest_service",
    "SmartCampaignSuggestServiceTransport": "google.ads.googleads.v13.services.services.smart_campaign_suggest_service.transports",
    "SmartCampaignSuggestServiceGrpcTransport": "google.ads.googleads.v13.services.services.smart_campaign_suggest_service.transports",
    "ThirdPartyAppAnalyticsLinkServiceClient": "google.ads.googleads.v13.services.services.third_party_app_analytics_link_service",
    "ThirdPartyAppAnalyticsLinkServiceTransport": "google.ads.googleads.v13.services.services.third_party_app_analytics_link_service.transports",
    "ThirdPartyAppAnalyticsLinkServiceGrpcTransport": "google.ads.googleads.v13.services.services.third_party_app_analytics_link_service.transports",
    "TravelAssetSuggestionServiceClient": "google.ads.googleads.v13.services.services.travel_asset_suggestion_service",
    "TravelAssetSuggestionServiceTransport": "google.ads.googleads.v13.services.services.travel_asset_suggestion_service.transports",
    "TravelAssetSuggestionServiceGrpcTransport": "google.ads.googleads.v13.services.services.travel_asset_suggestion_service.transports",
    "UserDataServiceClient": "google.ads.googleads.v13.services.services.user_data_service",
    "UserDataServiceTransport": "google.ads.googleads.v13.services.services.user_data_service.transports",
    "UserDataServiceGrpcTransport": "google.ads.googleads.v13.services.services.user_data_service.transports",
    "UserListServiceClient": "google.ads.googleads.v13.services.services.user_list_service",
    "UserListServiceTransport": "google.ads.googleads.v13.services.services.user_list_service.transports",
    "UserListServiceGrpcTransport": "google.ads.googleads.v13.services.services.user_list_service.transports",
}


# Background on how this behaves: https://www.python.org/dev/peps/pep-0562/
def __getattr__(name):  # Requires Python >= 3.7
    if name == "__all__":
        all_names = globals()["__all__"] = sorted(_lazy_type_to_package_map)
        return all_names
    elif name in _lazy_type_to_package_map:
        module = importlib.import_module(f"{_lazy_type_to_package_map[name]}")
        klass = getattr(module, name)
        globals()[name] = klass
        return klass
    else:
        raise AttributeError(f"unknown type {name!r}.")


def __dir__():
    return globals().get("__all__") or __getattr__("__all__")
