<?php
/**
 * StoreApiTest
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Please update the test case below to test the endpoint.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\Configuration;
use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\ObjectSerializer;

/**
 * StoreApiTest Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache License v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class StoreApiTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Setup before running each test case
     */
    public static function setUpBeforeClass()
    {
        // add a new pet (id 10005) to ensure the pet object is available for all the tests

        // for error reporting (need to run with php5.3 to get no warning)
        //ini_set('display_errors', 1);
        //error_reporting(~0);

        // new pet
        $new_pet_id = 10005;
        $new_pet = new \Swagger\Client\Model\Pet;
        $new_pet->setId($new_pet_id);
        $new_pet->setName("PHP Unit Test");
        $new_pet->setStatus("available");
        // new tag
        $tag= new \Swagger\Client\Model\Tag;
        $tag->setId($new_pet_id); // use the same id as pet
        $tag->setName("test php tag");
        // new category
        $category = new \Swagger\Client\Model\Category;
        $category->setId($new_pet_id); // use the same id as pet
        $category->setName("test php category");

        $new_pet->setTags(array($tag));
        $new_pet->setCategory($category);

        $pet_api = new PetAPI();
        // add a new pet (model)
        $add_response = $pet_api->addPet($new_pet);
    }

    /**
     * Clean up after running each test case
     */
    public static function tearDownAfterClass()
    {

    }

    /**
     * Test case for deleteOrder
     *
     * Delete purchase order by ID.
     *
     */
    public function testDeleteOrder()
    {

    }

    /**
     * Test case for getInventory
     *
     * Returns pet inventories by status.
     *
     */
    public function testGetInventory()
    {
        // initialize the API client
        $config = (new Configuration())->setHost('http://petstore.swagger.io/v2');
        $api_client = new ApiClient($config);
        $store_api = new StoreApi($api_client);
        // get inventory
        $get_response = $store_api->getInventory();

        $this->assertInternalType("array", $get_response);
        $this->assertInternalType("int", $get_response['available']);
    }

    /**
     * Test case for getOrderById
     *
     * Find purchase order by ID.
     *
     */
    public function testGetOrderById()
    {

    }

    /**
     * Test case for placeOrder
     *
     * Place an order for a pet.
     *
     */
    public function testPlaceOrder()
    {

    }

}
