#import <Foundation/Foundation.h>
#import "SWGUser.h"
#import "SWGApi.h"

/**
* Swagger Petstore
* This is a sample server Petstore server.  You can find out more about Swagger at <a href=\"http://swagger.io\">http://swagger.io</a> or on irc.freenode.net, #swagger.  For this sample, you can use the api key \"special-key\" to test the authorization filters
*
* OpenAPI spec version: 1.0.0
* Contact: apiteam@wordnik.com
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/swagger-api/swagger-codegen.git
* Do not edit the class manually.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/


@interface SWGUserApi: NSObject <SWGApi>

extern NSString* kSWGUserApiErrorDomain;
extern NSInteger kSWGUserApiMissingParamErrorCode;

-(instancetype) initWithApiClient:(SWGApiClient *)apiClient NS_DESIGNATED_INITIALIZER;

/// Create user
/// This can only be done by the logged in user.
///
/// @param body Created user object (optional)
/// 
///  code:0 message:"successful operation"
///
/// @return 
-(NSURLSessionTask*) createUserWithBody: (SWGUser*) body
    completionHandler: (void (^)(NSError* error)) handler;


/// Creates list of users with given input array
/// 
///
/// @param body List of user object (optional)
/// 
///  code:0 message:"successful operation"
///
/// @return 
-(NSURLSessionTask*) createUsersWithArrayInputWithBody: (NSArray<SWGUser>*) body
    completionHandler: (void (^)(NSError* error)) handler;


/// Creates list of users with given input array
/// 
///
/// @param body List of user object (optional)
/// 
///  code:0 message:"successful operation"
///
/// @return 
-(NSURLSessionTask*) createUsersWithListInputWithBody: (NSArray<SWGUser>*) body
    completionHandler: (void (^)(NSError* error)) handler;


/// Delete user
/// This can only be done by the logged in user.
///
/// @param username The name that needs to be deleted
/// 
///  code:400 message:"Invalid username supplied",
///  code:404 message:"User not found"
///
/// @return 
-(NSURLSessionTask*) deleteUserWithUsername: (NSString*) username
    completionHandler: (void (^)(NSError* error)) handler;


/// Get user by user name
/// 
///
/// @param username The name that needs to be fetched. Use user1 for testing. 
/// 
///  code:200 message:"successful operation",
///  code:400 message:"Invalid username supplied",
///  code:404 message:"User not found"
///
/// @return SWGUser*
-(NSURLSessionTask*) getUserByNameWithUsername: (NSString*) username
    completionHandler: (void (^)(SWGUser* output, NSError* error)) handler;


/// Logs user into the system
/// 
///
/// @param username The user name for login (optional)
/// @param password The password for login in clear text (optional)
/// 
///  code:200 message:"successful operation",
///  code:400 message:"Invalid username/password supplied"
///
/// @return NSString*
-(NSURLSessionTask*) loginUserWithUsername: (NSString*) username
    password: (NSString*) password
    completionHandler: (void (^)(NSString* output, NSError* error)) handler;


/// Logs out current logged in user session
/// 
///
/// 
///  code:0 message:"successful operation"
///
/// @return 
-(NSURLSessionTask*) logoutUserWithCompletionHandler: 
    (void (^)(NSError* error)) handler;


/// Updated user
/// This can only be done by the logged in user.
///
/// @param username name that need to be deleted
/// @param body Updated user object (optional)
/// 
///  code:400 message:"Invalid user supplied",
///  code:404 message:"User not found"
///
/// @return 
-(NSURLSessionTask*) updateUserWithUsername: (NSString*) username
    body: (SWGUser*) body
    completionHandler: (void (^)(NSError* error)) handler;



@end
