# SwaggerClient

This is a sample server Petstore server.  You can find out more about Swagger at <a href=\"http://swagger.io\">http://swagger.io</a> or on irc.freenode.net, #swagger.  For this sample, you can use the api key \"special-key\" to test the authorization filters

This ObjC package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 
- Build date: 2016-08-23T10:56:26.470+02:00
- Build package: class io.swagger.codegen.languages.ObjcClientCodegen

## Requirements

The SDK requires [**ARC (Automatic Reference Counting)**](http://stackoverflow.com/questions/7778356/how-to-enable-disable-automatic-reference-counting) to be enabled in the Xcode project.

## Installation & Usage
### Install from Github using [CocoaPods](https://cocoapods.org/)

Add the following to the Podfile:

```ruby
pod 'SwaggerClient', :git => 'https://github.com/GIT_USER_ID/GIT_REPO_ID.git'
```

To specify a particular branch, append `, :branch => 'branch-name-here'`

To specify a particular commit, append `, :commit => '11aa22'`

### Install from local path using [CocoaPods](https://cocoapods.org/)

Put the SDK under your project folder (e.g. /path/to/objc_project/Vendor/SwaggerClient) and then add the following to the Podfile:

```ruby
pod 'SwaggerClient', :path => 'Vendor/SwaggerClient'
```

### Usage

Import the following:

```objc
#import <SwaggerClient/SWGApiClient.h>
#import <SwaggerClient/SWGDefaultConfiguration.h>
// load models
#import <SwaggerClient/SWGCategory.h>
#import <SwaggerClient/SWGOrder.h>
#import <SwaggerClient/SWGPet.h>
#import <SwaggerClient/SWGTag.h>
#import <SwaggerClient/SWGUser.h>
// load API classes for accessing endpoints
#import <SwaggerClient/SWGPetApi.h>
#import <SwaggerClient/SWGStoreApi.h>
#import <SwaggerClient/SWGUserApi.h>

```

## Recommendation

It's recommended to create an instance of ApiClient per thread in a multi-threaded environment to avoid any potential issue.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```objc

SWGDefaultConfiguration *apiConfig = [SWGDefaultConfiguration sharedConfig];

// Configure OAuth2 access token for authorization: (authentication scheme: petstore_auth)
[apiConfig setAccessToken:@"YOUR_ACCESS_TOKEN"];


SWGPet* *body = [[SWGPet alloc] init]; // Pet object that needs to be added to the store (optional)

SWGPetApi *apiInstance = [[SWGPetApi alloc] init];

// Add a new pet to the store
[apiInstance addPetWithBody:body
              completionHandler: ^(NSError* error) {
                            if (error) {
                                NSLog(@"Error: %@", error);
                            }
                        }];

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SWGPetApi* | [**addPet**](docs/SWGPetApi.md#addpet) | **POST** /pet | Add a new pet to the store
*SWGPetApi* | [**deletePet**](docs/SWGPetApi.md#deletepet) | **DELETE** /pet/{petId} | Deletes a pet
*SWGPetApi* | [**findPetsByStatus**](docs/SWGPetApi.md#findpetsbystatus) | **GET** /pet/findByStatus | Finds Pets by status
*SWGPetApi* | [**findPetsByTags**](docs/SWGPetApi.md#findpetsbytags) | **GET** /pet/findByTags | Finds Pets by tags
*SWGPetApi* | [**getPetById**](docs/SWGPetApi.md#getpetbyid) | **GET** /pet/{petId} | Find pet by ID
*SWGPetApi* | [**updatePet**](docs/SWGPetApi.md#updatepet) | **PUT** /pet | Update an existing pet
*SWGPetApi* | [**updatePetWithForm**](docs/SWGPetApi.md#updatepetwithform) | **POST** /pet/{petId} | Updates a pet in the store with form data
*SWGPetApi* | [**uploadFile**](docs/SWGPetApi.md#uploadfile) | **POST** /pet/{petId}/uploadImage | uploads an image
*SWGStoreApi* | [**deleteOrder**](docs/SWGStoreApi.md#deleteorder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*SWGStoreApi* | [**getInventory**](docs/SWGStoreApi.md#getinventory) | **GET** /store/inventory | Returns pet inventories by status
*SWGStoreApi* | [**getOrderById**](docs/SWGStoreApi.md#getorderbyid) | **GET** /store/order/{orderId} | Find purchase order by ID
*SWGStoreApi* | [**placeOrder**](docs/SWGStoreApi.md#placeorder) | **POST** /store/order | Place an order for a pet
*SWGUserApi* | [**createUser**](docs/SWGUserApi.md#createuser) | **POST** /user | Create user
*SWGUserApi* | [**createUsersWithArrayInput**](docs/SWGUserApi.md#createuserswitharrayinput) | **POST** /user/createWithArray | Creates list of users with given input array
*SWGUserApi* | [**createUsersWithListInput**](docs/SWGUserApi.md#createuserswithlistinput) | **POST** /user/createWithList | Creates list of users with given input array
*SWGUserApi* | [**deleteUser**](docs/SWGUserApi.md#deleteuser) | **DELETE** /user/{username} | Delete user
*SWGUserApi* | [**getUserByName**](docs/SWGUserApi.md#getuserbyname) | **GET** /user/{username} | Get user by user name
*SWGUserApi* | [**loginUser**](docs/SWGUserApi.md#loginuser) | **GET** /user/login | Logs user into the system
*SWGUserApi* | [**logoutUser**](docs/SWGUserApi.md#logoutuser) | **GET** /user/logout | Logs out current logged in user session
*SWGUserApi* | [**updateUser**](docs/SWGUserApi.md#updateuser) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [SWGCategory](docs/SWGCategory.md)
 - [SWGOrder](docs/SWGOrder.md)
 - [SWGPet](docs/SWGPet.md)
 - [SWGTag](docs/SWGTag.md)
 - [SWGUser](docs/SWGUser.md)


## Documentation For Authorization


## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author

apiteam@wordnik.com


