<?php
/**
 * OrderTest
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Please update the test case below to test the model.
 */

namespace Swagger\Client\Model;

/**
 * OrderTest Class Doc Comment
 *
 * @category    Class
 * @description Order
 * @package     Swagger\Client
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OrderTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Setup before running each test case
     */
    public static function setUpBeforeClass()
    {

    }

    /**
     * Clean up after running each test case
     */
    public static function tearDownAfterClass()
    {

    }

    /**
     * Test "Order"
     */
    public function testOrder()
    {
        // initialize the API client
        $order = new Order();

        $order->setStatus("placed");
        $this->assertSame("placed", $order->getStatus());
    }

    /**
     * @expectedException InvalidArgumentException
     */
    public function testOrderException()
    {
        // initialize the API client
        $order = new Order();
        $order->setStatus("invalid_value");
    }

    /**
     * Test attribute "id"
     */
    public function testPropertyId()
    {

    }

    /**
     * Test attribute "pet_id"
     */
    public function testPropertyPetId()
    {

    }

    /**
     * Test attribute "quantity"
     */
    public function testPropertyQuantity()
    {

    }

    /**
     * Test attribute "ship_date"
     */
    public function testPropertyShipDate()
    {

    }

    /**
     * Test attribute "status"
     */
    public function testPropertyStatus()
    {
        $this->assertSame(Order::STATUS_PLACED, "placed");
        $this->assertSame(Order::STATUS_APPROVED, "approved");
    }

    /**
     * Test attribute "complete"
     */
    public function testPropertyComplete()
    {

    }

    // test deseralization of order
    public function testDeserializationOfOrder()
    {
        $order_json = <<<ORDER
{
  "id": 10,
  "petId": 20,
  "quantity": 30,
  "shipDate": "2015-08-22T07:13:36.613Z",
  "status": "placed",
  "complete": false
}
ORDER;
        $order = \Swagger\Client\ObjectSerializer::deserialize(
            json_decode($order_json),
            'Swagger\Client\Model\Order'
        );
        
        $this->assertInstanceOf('Swagger\Client\Model\Order', $order);
        $this->assertSame(10, $order->getId());
        $this->assertSame(20, $order->getPetId());
        $this->assertSame(30, $order->getQuantity());
        $this->assertTrue(new \DateTime("2015-08-22T07:13:36.613Z") == $order->getShipDate());
        $this->assertSame("placed", $order->getStatus());
        $this->assertSame(false, $order->getComplete());
    }

    // test deseralization of array of array of order
    public function testDeserializationOfArrayOfArrayOfOrder()
    {
        $order_json = <<<ORDER
[[{
  "id": 10,
  "petId": 20,
  "quantity": 30,
  "shipDate": "2015-08-22T07:13:36.613Z",
  "status": "placed",
  "complete": false
}]]
ORDER;
        $order = \Swagger\Client\ObjectSerializer::deserialize(
            json_decode($order_json),
            'Swagger\Client\Model\Order[][]'
        );
        $this->assertArrayHasKey(0, $order);
        $this->assertArrayHasKey(0, $order[0]);
        $_order = $order[0][0];
        $this->assertInstanceOf('Swagger\Client\Model\Order', $_order);
        $this->assertSame(10, $_order->getId());
        $this->assertSame(20, $_order->getPetId());
        $this->assertSame(30, $_order->getQuantity());
        $this->assertTrue(new \DateTime("2015-08-22T07:13:36.613Z") == $_order->getShipDate());
        $this->assertSame("placed", $_order->getStatus());
        $this->assertSame(false, $_order->getComplete());
    }

    // test deseralization of map of map of order
    public function testDeserializationOfMapOfMapOfOrder()
    {
        $order_json = <<<ORDER
{
  "test": {
    "test2": {
      "id": 10,
      "petId": 20,
      "quantity": 30,
      "shipDate": "2015-08-22T07:13:36.613Z",
      "status": "placed",
      "complete": false
    }
  }
}
ORDER;
        $order = \Swagger\Client\ObjectSerializer::deserialize(
            json_decode($order_json),
            'map[string,map[string,\Swagger\Client\Model\Order]]'
        );
        $this->assertArrayHasKey('test', $order);
        $this->assertArrayHasKey('test2', $order['test']);
        $_order = $order['test']['test2'];
        $this->assertInstanceOf('Swagger\Client\Model\Order', $_order);
        $this->assertSame(10, $_order->getId());
        $this->assertSame(20, $_order->getPetId());
        $this->assertSame(30, $_order->getQuantity());
        $this->assertTrue(new \DateTime("2015-08-22T07:13:36.613Z") == $_order->getShipDate());
        $this->assertSame("placed", $_order->getStatus());
        $this->assertSame(false, $_order->getComplete());
    }

}
