<?php
/**
 * UserApiTest
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Swagger Petstore
 *
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * OpenAPI spec version: 1.0.0
 * Contact: apiteam@swagger.io
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Please update the test case below to test the endpoint.
 */

namespace Swagger\Client\Api;

use \Swagger\Client\Configuration;
use \Swagger\Client\ApiClient;
use \Swagger\Client\ApiException;
use \Swagger\Client\ObjectSerializer;

/**
 * UserApiTest Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UserApiTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Setup before running each test case
     */
    public static function setUpBeforeClass()
    {

    }

    /**
     * Clean up after running each test case
     */
    public static function tearDownAfterClass()
    {

    }

    /**
     * Test case for createUser
     *
     * Create user.
     *
     */
    public function testCreateUser()
    {

    }

    /**
     * Test case for createUsersWithArrayInput
     *
     * Creates list of users with given input array.
     *
     */
    public function testCreateUsersWithArrayInput()
    {

    }

    /**
     * Test case for createUsersWithListInput
     *
     * Creates list of users with given input array.
     *
     */
    public function testCreateUsersWithListInput()
    {

    }

    /**
     * Test case for deleteUser
     *
     * Delete user.
     *
     */
    public function testDeleteUser()
    {

    }

    /**
     * Test case for getUserByName
     *
     * Get user by user name.
     *
     */
    public function testGetUserByName()
    {

    }

    /**
     * Test case for loginUser
     *
     * Logs user into the system.
     *
     */
    public function testLoginUser()
    {
        // initialize the API client
        $config = (new Configuration())->setHost('http://petstore.swagger.io/v2');
        $api_client = new ApiClient($config);
        $user_api = new UserApi($api_client);
        // login
        $response = $user_api->loginUser("xxxxx", "yyyyyyyy");
        
        $this->assertInternalType("string", $response);
        $this->assertRegExp(
            "/^logged in user session/",
            $response,
            "response string starts with 'logged in user session'"
        );
    }

    /**
     * Test case for logoutUser
     *
     * Logs out current logged in user session.
     *
     */
    public function testLogoutUser()
    {

    }

    /**
     * Test case for updateUser
     *
     * Updated user.
     *
     */
    public function testUpdateUser()
    {

    }

}
