/*
 * Copyright (c) 2018 David Sargent
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer below) provided that
 * the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list
 * of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice, this
 * list of conditions and the following disclaimer in the documentation and/or
 * other materials provided with the distribution.
 * Neither the name of NAME nor the names of its contributors may be used to
 * endorse or promote products derived from this software without specific prior
 * written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY THIS
 * LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESSFOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

package com.google.blocks.ftcrobotcontroller.onbotjava;

import android.support.annotation.NonNull;

import fi.iki.elonen.NanoHTTPD;

import static com.google.blocks.ftcrobotcontroller.onbotjava.MimeUtil.MIME_JSON;
import static fi.iki.elonen.NanoHTTPD.MIME_PLAINTEXT;
import static fi.iki.elonen.NanoHTTPD.newFixedLengthResponse;

public final class StandardResponses {
    @NonNull
    public static NanoHTTPD.Response successfulRequest() {
        return successfulJsonRequest("{\"success\":\"true\"}");
    }

    @NonNull
    public static NanoHTTPD.Response successfulRequest(Object serializableObject) {
        return successfulJsonRequest(OnBotJavaWebInterfaceManager.instance().gson().toJson(serializableObject));
    }

    @NonNull
    public static NanoHTTPD.Response successfulJsonRequest(String message) {
        return newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_JSON, message);
    }

    @NonNull
    public static NanoHTTPD.Response successfulRequest(String message) {
        return newFixedLengthResponse(NanoHTTPD.Response.Status.OK, MIME_PLAINTEXT, message);
    }

    @NonNull
    public static NanoHTTPD.Response serverError() {
        return serverError("Server Error");
    }

    @NonNull
    public static NanoHTTPD.Response serverError(@NonNull final String message) {
        return newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, MIME_JSON, message);
    }

    @NonNull
    public static NanoHTTPD.Response badRequest() {
        return badRequest("{\"success\":\"false\"}");
    }

    @NonNull
    public static NanoHTTPD.Response badRequest(@NonNull final String message) {
        return newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, MIME_JSON, message);
    }

    @NonNull
    public static NanoHTTPD.Response fileNotFound() {
        return newFixedLengthResponse( NanoHTTPD.Response.Status.NOT_FOUND, MIME_PLAINTEXT, "File Not Found!");
    }

    @NonNull
    public static NanoHTTPD.Response unauthorizedAccess() {
        return newFixedLengthResponse(NanoHTTPD.Response.Status.UNAUTHORIZED, MIME_PLAINTEXT, "Access is not allowed");
    }
}
