/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.firstinspires.ftc.robotcore.internal.android.dx.util;

/**
 * Simple interface for objects that can return a "human" (as opposed to
 * a complete but often hard to read) string form.
 */
public interface ToHuman {
    /**
     * Return the "human" string form of this instance.  This is
     * generally less "debuggy" than {@code toString()}.
     *
     * @return {@code non-null;} the human string form
     */
    public String toHuman();
}
