/*
 * Decompiled with CFR 0.152.
 */
package com.vuforia.ar.pl;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import com.vuforia.ar.pl.DebugLog;
import com.vuforia.ar.pl.DrawOverlayView;
import com.vuforia.ar.pl.SurfaceManager;
import com.vuforia.ar.pl.SystemTools;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RenderManager {
    private static final int AR_RENDERING_MODE_UNKNOWN = 0;
    private static final int AR_RENDERING_MODE_DISABLED = 1;
    private static final int AR_RENDERING_MODE_CONTINUOUS = 2;
    private static final int AR_RENDERING_MODE_WHENDIRTY = 3;
    private static int viewId = 0;
    SurfaceManager surfaceManager;
    int renderMode;
    boolean synchronousMode;
    ScheduledThreadPoolExecutor timer;
    ScheduledFuture<?> fixedFrameRateRunnerTask;
    ScheduledFuture<?> renderRequestWatcherTask;
    AtomicBoolean renderRequestServiced;
    AtomicBoolean renderRequested;
    long delayMS = 0L;
    long minMS = 0L;
    long maxMS = 0L;
    private static final String MODULENAME = "RenderManager";

    public RenderManager(SurfaceManager surfaceManager) {
        this.surfaceManager = surfaceManager;
        this.renderMode = 2;
        this.timer = new ScheduledThreadPoolExecutor(1);
        this.synchronousMode = false;
        this.renderRequestServiced = new AtomicBoolean(false);
        this.renderRequested = new AtomicBoolean(false);
    }

    void startTimer() {
        if (this.timer.isShutdown()) {
            this.timer = new ScheduledThreadPoolExecutor(1);
        }
        if (this.fixedFrameRateRunnerTask != null && !this.fixedFrameRateRunnerTask.isCancelled()) {
            this.fixedFrameRateRunnerTask.cancel(true);
        }
        if (this.renderRequestWatcherTask != null && !this.renderRequestWatcherTask.isCancelled()) {
            this.renderRequestWatcherTask.cancel(true);
        }
        this.fixedFrameRateRunnerTask = null;
        this.renderRequestWatcherTask = null;
        long l = this.delayMS < 4L ? 1L : this.delayMS / 4L;
        this.renderRequestWatcherTask = this.timer.scheduleWithFixedDelay(new RenderRequestWatcher(), 0L, l, TimeUnit.MILLISECONDS);
    }

    void shutdownTimer() {
        if (!this.timer.isShutdown()) {
            this.timer.shutdown();
        }
    }

    public boolean canSetRenderMode() {
        boolean bl = this.surfaceManager.retrieveGLSurfaceView();
        if (!bl) {
            DebugLog.LOGD(MODULENAME, "Could not retrieve a valid GLSurfaceView in view hierarchy, therefore cannot set any render mode");
        }
        return bl;
    }

    public int getRenderMode() {
        return this.renderMode;
    }

    public boolean setRenderMode(int n) {
        boolean bl = false;
        if (this.surfaceManager == null) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        this.surfaceManager.retrieveGLSurfaceView();
        switch (n) {
            case 2: {
                bl = this.surfaceManager.setEnableRenderWhenDirty(false);
                if (!bl) break;
                this.shutdownTimer();
                break;
            }
            case 1: 
            case 3: {
                long l;
                bl = this.surfaceManager.setEnableRenderWhenDirty(true);
                if (!bl) break;
                if (n == 1) {
                    this.shutdownTimer();
                    break;
                }
                if (n == this.renderMode && !this.timer.isShutdown()) break;
                long l2 = l = this.synchronousMode ? this.minMS : this.maxMS;
                if (l == 0L) break;
                this.delayMS = l;
                this.startTimer();
                break;
            }
            default: {
                SystemTools.setSystemErrorCode(2);
                return false;
            }
        }
        if (!bl) {
            SystemTools.setSystemErrorCode(6);
        } else {
            this.renderMode = n;
        }
        return bl;
    }

    public boolean setRenderFpsLimits(boolean bl, int n, int n2) {
        this.synchronousMode = bl;
        if (n == 0 || n2 == 0) {
            SystemTools.setSystemErrorCode(2);
            return false;
        }
        this.minMS = n > 1000 ? 1L : 1000L / (long)n;
        long l = this.maxMS = n2 > 1000 ? 1L : 1000L / (long)n2;
        if (this.renderMode == 3) {
            long l2;
            long l3 = l2 = this.synchronousMode ? this.minMS : this.maxMS;
            if (l2 != this.delayMS) {
                this.delayMS = l2;
                this.startTimer();
            }
        }
        return true;
    }

    public boolean requestRender() {
        this.renderRequested.set(true);
        return true;
    }

    public View addOverlay(byte[] byArray, int n, int n2, float[] fArray, int[] nArray) {
        final Activity activity = SystemTools.getActivityFromNative();
        if (activity == null) {
            DebugLog.LOGE(MODULENAME, "drawOverlay could not get access to an activity");
            return null;
        }
        final DrawOverlayView drawOverlayView = new DrawOverlayView((Context)activity, byArray, n, n2, fArray, nArray);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                drawOverlayView.addOverlay(activity);
            }
        });
        return drawOverlayView;
    }

    public boolean removeOverlay(final View view) {
        final Activity activity = SystemTools.getActivityFromNative();
        if (activity == null) {
            return false;
        }
        if (view == null) {
            return false;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DrawOverlayView drawOverlayView = new DrawOverlayView((Context)activity);
                drawOverlayView.removeOverlay(activity, view);
            }
        });
        return true;
    }

    private final class FixedFrameRateRunner
    implements Runnable {
        private FixedFrameRateRunner() {
        }

        @Override
        public void run() {
            if (!RenderManager.this.renderRequestServiced.getAndSet(false) && RenderManager.this.surfaceManager != null) {
                RenderManager.this.surfaceManager.requestRender();
                if (!RenderManager.this.synchronousMode && !RenderManager.this.renderRequestWatcherTask.isCancelled()) {
                    RenderManager.this.renderRequestWatcherTask.cancel(false);
                }
            }
        }
    }

    private final class RenderRequestWatcher
    implements Runnable {
        private RenderRequestWatcher() {
        }

        @Override
        public void run() {
            if (RenderManager.this.renderRequested.compareAndSet(true, false) && RenderManager.this.surfaceManager != null) {
                RenderManager.this.surfaceManager.requestRender();
                RenderManager.this.renderRequestServiced.set(true);
                if (RenderManager.this.fixedFrameRateRunnerTask == null) {
                    RenderManager.this.fixedFrameRateRunnerTask = RenderManager.this.timer.scheduleAtFixedRate(new FixedFrameRateRunner(), 0L, RenderManager.this.delayMS, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

