/*
 * Decompiled with CFR 0.152.
 */
package com.vuforia.ar.pl;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import com.vuforia.ar.pl.CameraSurface;
import com.vuforia.ar.pl.DebugLog;
import com.vuforia.ar.pl.SurfaceManager;
import com.vuforia.ar.pl.SystemTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;

public class Camera1_Preview
implements Camera.PreviewCallback {
    private SurfaceManager surfaceManager = null;
    private Vector<CameraCacheInfo> cameraCacheInfo = null;
    private HashMap<Camera, Integer> cameraCacheInfoIndexCache = null;
    private static final int CAMERA_CAPTUREINFO_VALUE_WIDTH = 0;
    private static final int CAMERA_CAPTUREINFO_VALUE_HEIGHT = 1;
    private static final int CAMERA_CAPTUREINFO_VALUE_FORMAT = 2;
    private static final int CAMERA_CAPTUREINFO_VALUE_FRAMERATE = 3;
    private static final int CAMERA_CAPTUREINFO_VALUE_PREVIEWSURFACEENABLED = 4;
    private static final int _NUM_CAMERA_CAPTUREINFO_VALUE_ = 5;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_QUERYABLE_PARAMS = 0;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_SETTABLE_PARAMS = 1;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_PARAMVALUES = 2;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_IMAGESIZES = 3;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_FRAMERATES = 4;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_IMAGEFORMATS = 5;
    private static final int _NUM_CAMERA_CAPSINFO_VALUE_ = 6;
    private static final int AR_CAMERA_PARAMTYPE_BASE = 0x20000000;
    private static final int AR_CAMERA_PARAMTYPE_TORCHMODE = 0x20000001;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSMODE = 0x20000002;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSVALUE = 0x20000004;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSRANGE = 0x20000008;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSREGION = 0x20000010;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREMODE = 0x20000020;
    private static final int AR_CAMERA_PARAMTYPE_ISO = 0x20000040;
    private static final int AR_CAMERA_PARAMTYPE_ISORANGE = 0x20000080;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURETIME = 0x20000100;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURETIMERANGE = 0x20000200;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREVALUE = 0x20000400;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREVALUERANGE = 0x20000800;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCEMODE = 0x20001000;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCEVALUE = 0x20002000;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCERANGE = 0x20004000;
    private static final int AR_CAMERA_PARAMTYPE_ZOOMVALUE = 0x20008000;
    private static final int AR_CAMERA_PARAMTYPE_ZOOMRANGE = 0x20010000;
    private static final int AR_CAMERA_PARAMTYPE_BRIGHTNESSVALUE = 0x20020000;
    private static final int AR_CAMERA_PARAMTYPE_BRIGHTNESSRANGE = 0x20040000;
    private static final int AR_CAMERA_PARAMTYPE_CONTRASTVALUE = 0x20080000;
    private static final int AR_CAMERA_PARAMTYPE_CONTRASTRANGE = 0x20100000;
    private static final int AR_CAMERA_PARAMTYPE_ROTATION = 0x20200000;
    private static final int AR_CAMERA_PARAMTYPE_RECORDING_HINT = 0x20400000;
    private static final int AR_CAMERA_PARAMTYPE_LENS_IS_ADJUSTING = 0x20800000;
    private static final int AR_CAMERA_PARAMTYPE_VIDEO_STABILIZATION = 0x21000000;
    private static final int AR_CAMERA_PARAMVALUE_BASE = 0x30000000;
    private static final int AR_CAMERA_TORCHMODE_OFF = 0x30000001;
    private static final int AR_CAMERA_TORCHMODE_ON = 0x30000002;
    private static final int AR_CAMERA_TORCHMODE_AUTO = 0x30000004;
    private static final int AR_CAMERA_TORCHMODE_CONTINUOUSAUTO = 0x30000008;
    private static final int AR_CAMERA_FOCUSMODE_NORMAL = 0x30000010;
    private static final int AR_CAMERA_FOCUSMODE_AUTO = 0x30000020;
    private static final int AR_CAMERA_FOCUSMODE_CONTINUOUSAUTO = 0x30000040;
    private static final int AR_CAMERA_FOCUSMODE_MACRO = 0x30000080;
    private static final int AR_CAMERA_FOCUSMODE_INFINITY = 0x30000100;
    private static final int AR_CAMERA_FOCUSMODE_FIXED = 0x30000200;
    private static final int AR_CAMERA_EXPOSUREMODE_LOCKED = 0x30001000;
    private static final int AR_CAMERA_EXPOSUREMODE_AUTO = 0x30002000;
    private static final int AR_CAMERA_EXPOSUREMODE_CONTINUOUSAUTO = 0x30004000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_LOCKED = 0x30100000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_AUTO = 0x30200000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_CONTINUOUSAUTO = 0x30400000;
    private static final int AR_CAMERA_TYPE_UNKNOWN = 0x10003010;
    private static final int AR_CAMERA_TYPE_MONO = 0x10003011;
    private static final int AR_CAMERA_TYPE_STEREO = 268447762;
    private static final int AR_CAMERA_DIRECTION_UNKNOWN = 0x10002010;
    private static final int AR_CAMERA_DIRECTION_BACK = 0x10002011;
    private static final int AR_CAMERA_DIRECTION_FRONT = 0x10002012;
    private static final int AR_CAMERA_STATUS_UNKNOWN = 0x10002000;
    private static final int AR_CAMERA_STATUS_UNINITIALIZED = 0x10002001;
    private static final int AR_CAMERA_STATUS_OPENED = 0x10002002;
    private static final int AR_CAMERA_STATUS_CAPTURE_RUNNING = 268443651;
    private static final int AR_CAMERA_IMAGE_FORMAT_UNKNOWN = 0x10001100;
    private static final int AR_CAMERA_IMAGE_FORMAT_LUM = 0x10001101;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB565 = 0x10001102;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB888 = 0x10001103;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB24 = 0x10001103;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA8888 = 0x10001104;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA32 = 0x10001104;
    private static final int AR_CAMERA_IMAGE_FORMAT_ARGB8888 = 0x10001105;
    private static final int AR_CAMERA_IMAGE_FORMAT_ARGB32 = 0x10001105;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGRA8888 = 0x10001106;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGRA32 = 0x10001106;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV12 = 0x10001107;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV16 = 0x10001108;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV21 = 0x10001109;
    private static final int AR_CAMERA_IMAGE_FORMAT_YV12 = 0x1000110A;
    private static final int AR_CAMERA_IMAGE_FORMAT_YV16 = 0x1000110B;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA5551 = 0x1000110C;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA4444 = 0x1000110D;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGR888 = 0x1000110E;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGR24 = 0x1000110E;
    private static final int[] CAMERA_IMAGE_FORMAT_CONVERSIONTABLE = new int[]{16, 0x10001108, 17, 0x10001109, 4, 0x10001102, 842094169, 0x1000110A};
    private static boolean CONVERT_FORMAT_TO_PL = true;
    private static boolean CONVERT_FORMAT_TO_ANDROID = false;
    private static final int NUM_CAPTURE_BUFFERS = 2;
    private static final int NUM_CAPTURE_BUFFERS_TO_ADD = 2;
    private static final int NUM_MAX_CAMERAOPEN_RETRY = 10;
    private static final int TIME_CAMERAOPEN_RETRY_DELAY_MS = 250;
    private static final String MODULENAME = "Camera1_Preview";
    private static final String FOCUS_MODE_NORMAL = "normal";
    private static final String SAMSUNG_PARAM_VRMODE_SUPPORTED = "vrmode-supported";
    private static final String SAMSUNG_PARAM_VRMODE = "vrmode";
    private static final String SAMSUNG_PARAM_FAST_FPS_MODE = "fast-fps-mode";

    private boolean checkPermission() {
        try {
            Activity activity = SystemTools.getActivityFromNative();
            if (activity == null) {
                return false;
            }
            PackageManager packageManager = activity.getPackageManager();
            int n = packageManager.checkPermission("android.permission.CAMERA", activity.getPackageName());
            if (n == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int getCameraDeviceIndex(int n, int n2, int n3) {
        if (n2 != 0x10003010) {
            // empty if block
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            int n4 = -1;
            switch (n3) {
                case 0x10002010: {
                    break;
                }
                case 0x10002011: {
                    n4 = 0;
                    break;
                }
                case 0x10002012: {
                    n4 = 1;
                    break;
                }
                default: {
                    SystemTools.setSystemErrorCode(2);
                    return -1;
                }
            }
            int n5 = Camera.getNumberOfCameras();
            for (int i = 0; i < n5; ++i) {
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                try {
                    Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                }
                catch (Exception exception) {
                    continue;
                }
                if (n4 >= 0 && n4 != cameraInfo.facing || n >= 0 && n != i) continue;
                return i;
            }
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (n3 == 0x10002012) {
            SystemTools.setSystemErrorCode(2);
            return -1;
        }
        if (n >= 1) {
            SystemTools.setSystemErrorCode(2);
            return -1;
        }
        return 0;
    }

    private Camera.Parameters getCameraParameters(Camera camera) {
        Camera.Parameters parameters = null;
        try {
            parameters = camera.getParameters();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parameters;
    }

    private CameraCacheInfo getCameraCacheInfo(int n) {
        if (n < 0 || n >= this.cameraCacheInfo.size()) {
            return null;
        }
        return this.cameraCacheInfo.get(n);
    }

    private boolean setCustomCameraParams(Camera.Parameters parameters, String string) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            return false;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            try {
                object = jSONObject.get(string2);
            }
            catch (JSONException jSONException) {
                return false;
            }
            if (object.getClass() == String.class) {
                parameters.set(string2, (String)object);
                continue;
            }
            if (object.getClass() == Integer.class) {
                parameters.set(string2, ((Integer)object).intValue());
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean setCameraPreviewFps(int n, Camera.Parameters parameters) {
        List list = parameters.getSupportedPreviewFpsRange();
        int n2 = n * 1000;
        int n3 = Integer.MAX_VALUE;
        int[] nArray = null;
        if ((n == 60 || n == 120) && "true".equalsIgnoreCase(parameters.get(SAMSUNG_PARAM_VRMODE_SUPPORTED))) {
            nArray = new int[2];
            parameters.set(SAMSUNG_PARAM_VRMODE, 1);
            parameters.setRecordingHint(true);
            parameters.set("focus-mode", "continuous-video");
            if (n == 60) {
                parameters.set(SAMSUNG_PARAM_FAST_FPS_MODE, 1);
                nArray[0] = 60000;
                nArray[1] = 60000;
            }
            if (n == 120) {
                parameters.set(SAMSUNG_PARAM_FAST_FPS_MODE, 2);
                nArray[0] = 120000;
                nArray[1] = 120000;
            }
        } else {
            if ("true".equalsIgnoreCase(parameters.get(SAMSUNG_PARAM_VRMODE_SUPPORTED)) && parameters.get(SAMSUNG_PARAM_FAST_FPS_MODE) != null && parameters.getInt(SAMSUNG_PARAM_FAST_FPS_MODE) != 0) {
                parameters.set(SAMSUNG_PARAM_VRMODE, 0);
                parameters.set(SAMSUNG_PARAM_FAST_FPS_MODE, 0);
            }
            for (int[] nArray2 : list) {
                int n4;
                if (nArray2[0] != n2 || (n4 = nArray2[1] - nArray2[0]) >= n3) continue;
                nArray = nArray2;
            }
        }
        if (nArray != null) {
            parameters.setPreviewFpsRange(nArray[0], nArray[1]);
            return true;
        }
        return false;
    }

    private boolean setCameraCaptureParams(CameraCacheInfo cameraCacheInfo, Camera.Parameters parameters, int[] nArray, int[] nArray2) {
        boolean bl;
        if (nArray != null || nArray2 != null) {
            cameraCacheInfo.overrideWidth = nArray2 != null ? nArray2[0] : nArray[0];
            cameraCacheInfo.overrideHeight = nArray2 != null ? nArray2[1] : nArray[1];
            cameraCacheInfo.overrideFormatAndroid = this.translateImageFormat(nArray2 != null ? nArray2[2] : nArray[2], CONVERT_FORMAT_TO_ANDROID);
        }
        if (nArray == null) {
            return true;
        }
        cameraCacheInfo.requestWidth = nArray[0];
        cameraCacheInfo.requestHeight = nArray[1];
        cameraCacheInfo.requestFormatAndroid = this.translateImageFormat(nArray[2], CONVERT_FORMAT_TO_ANDROID);
        int n = nArray[3];
        try {
            if (cameraCacheInfo.requestWidth > 0 && cameraCacheInfo.requestHeight > 0) {
                parameters.setPreviewSize(cameraCacheInfo.requestWidth, cameraCacheInfo.requestHeight);
            }
            if (n > 0) {
                if (SystemTools.checkMinimumApiLevel(8)) {
                    if (!this.setCameraPreviewFps(n, parameters)) {
                        parameters.setPreviewFrameRate(n);
                    }
                } else {
                    parameters.setPreviewFrameRate(n);
                }
            }
            if (cameraCacheInfo.requestFormatAndroid != 0) {
                parameters.setPreviewFormat(cameraCacheInfo.requestFormatAndroid);
            }
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl2 = bl = nArray[4] > 0;
        if (bl) {
            if (SystemTools.checkMinimumApiLevel(11)) {
                int n2 = -1;
                try {
                    cameraCacheInfo.surfaceTexture = new SurfaceTexture(n2);
                }
                catch (Exception exception) {
                    return false;
                }
                try {
                    cameraCacheInfo.camera.setPreviewTexture(cameraCacheInfo.surfaceTexture);
                }
                catch (Exception exception) {}
            } else if (this.surfaceManager != null) {
                boolean bl3 = this.surfaceManager.addCameraSurface(cameraCacheInfo);
                if (!bl3) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean checkSamsungHighFPS(CameraCacheInfo cameraCacheInfo) {
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        if ("true".equalsIgnoreCase(parameters.get(SAMSUNG_PARAM_VRMODE_SUPPORTED)) && cameraCacheInfo.requestWidth > 0 && cameraCacheInfo.requestHeight > 0 && parameters.get(SAMSUNG_PARAM_FAST_FPS_MODE) != null && parameters.getInt(SAMSUNG_PARAM_FAST_FPS_MODE) != 0 && (cameraCacheInfo.requestWidth != parameters.getPreviewSize().width || cameraCacheInfo.requestHeight != parameters.getPreviewSize().height)) {
            DebugLog.LOGW(MODULENAME, "Detected Samsung high fps camera driver bug.");
            DebugLog.LOGW(MODULENAME, "Preview size doesn't match request; width " + cameraCacheInfo.requestWidth + "!=" + parameters.getPreviewSize().width + " or height " + cameraCacheInfo.requestHeight + "!=" + parameters.getPreviewSize().height);
            this.setCameraPreviewFps(30, parameters);
            parameters.setPreviewSize(cameraCacheInfo.requestWidth, cameraCacheInfo.requestHeight);
            try {
                cameraCacheInfo.camera.setParameters(parameters);
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
            parameters = this.getCameraParameters(cameraCacheInfo.camera);
            if (cameraCacheInfo.requestWidth != parameters.getPreviewSize().width || cameraCacheInfo.requestHeight != parameters.getPreviewSize().height) {
                DebugLog.LOGE(MODULENAME, "Unable to workaround Samsung high fps camera driver bug.");
                DebugLog.LOGE(MODULENAME, "Preview size doesn't match request; width " + cameraCacheInfo.requestWidth + "!=" + parameters.getPreviewSize().width + " or height " + cameraCacheInfo.requestHeight + "!=" + parameters.getPreviewSize().height);
                return false;
            }
        }
        return true;
    }

    private boolean setupPreviewBuffer(CameraCacheInfo cameraCacheInfo) {
        int n;
        block7: {
            Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
            if (parameters == null) {
                return false;
            }
            int n2 = 0;
            try {
                cameraCacheInfo.bufferWidth = cameraCacheInfo.requestWidth == cameraCacheInfo.overrideWidth ? parameters.getPreviewSize().width : cameraCacheInfo.overrideWidth;
                cameraCacheInfo.bufferHeight = cameraCacheInfo.requestHeight == cameraCacheInfo.overrideHeight ? parameters.getPreviewSize().height : cameraCacheInfo.overrideHeight;
                n2 = cameraCacheInfo.requestFormatAndroid == cameraCacheInfo.overrideFormatAndroid ? parameters.getPreviewFormat() : cameraCacheInfo.overrideFormatAndroid;
                cameraCacheInfo.bufferFormatPL = this.translateImageFormat(n2, CONVERT_FORMAT_TO_PL);
            }
            catch (Exception exception) {
                return false;
            }
            n = 0;
            try {
                PixelFormat pixelFormat = new PixelFormat();
                PixelFormat.getPixelFormatInfo((int)n2, (PixelFormat)pixelFormat);
                n = pixelFormat.bitsPerPixel;
            }
            catch (Exception exception) {
                n = this.getBitsPerPixel(n2);
                if (n != 0) break block7;
                return false;
            }
        }
        int n3 = cameraCacheInfo.bufferWidth * cameraCacheInfo.bufferHeight * n / 8 + 4096;
        if (n3 <= cameraCacheInfo.bufferSize) {
            cameraCacheInfo.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            return true;
        }
        cameraCacheInfo.buffer = new byte[2][];
        for (int i = 0; i < 2; ++i) {
            cameraCacheInfo.buffer[i] = new byte[n3];
            if (i >= 2) continue;
            cameraCacheInfo.camera.addCallbackBuffer(cameraCacheInfo.buffer[i]);
        }
        cameraCacheInfo.bufferSize = n3;
        cameraCacheInfo.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        System.gc();
        return true;
    }

    private void setCameraCapsBit(CameraCacheInfo cameraCacheInfo, int n, int n2, boolean bl) {
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = 0x30000000;
                break;
            }
            case 0: 
            case 1: {
                n3 = 0x20000000;
                break;
            }
            default: {
                return;
            }
        }
        int n4 = (int)(Math.log(n2 & ~n3) / Math.log(2.0));
        if (bl) {
            int n5 = n;
            cameraCacheInfo.caps[n5] = cameraCacheInfo.caps[n5] | 1 << n4;
        } else {
            int n6 = n;
            cameraCacheInfo.caps[n6] = cameraCacheInfo.caps[n6] & ~(1 << n4);
        }
    }

    private int translateImageFormat(int n, boolean bl) {
        for (int i = 0; i < CAMERA_IMAGE_FORMAT_CONVERSIONTABLE.length / 2; ++i) {
            int n2;
            int n3 = n2 = bl == CONVERT_FORMAT_TO_PL ? CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2] : CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2 + 1];
            if (n != n2) continue;
            return bl == CONVERT_FORMAT_TO_PL ? CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2 + 1] : CAMERA_IMAGE_FORMAT_CONVERSIONTABLE[i * 2];
        }
        return bl == CONVERT_FORMAT_TO_PL ? 0x10001100 : 0;
    }

    int getBitsPerPixel(int n) {
        switch (n) {
            case 16: {
                return 16;
            }
            case 4: {
                return 16;
            }
            case 17: {
                return 12;
            }
            case 842094169: {
                return 12;
            }
        }
        return 0;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        Integer n;
        long l = System.nanoTime();
        if (SystemTools.checkMinimumApiLevel(18)) {
            // empty if block
        }
        if ((n = this.cameraCacheInfoIndexCache.get(camera)) == null) {
            if (SystemTools.checkMinimumApiLevel(18)) {
                // empty if block
            }
            return;
        }
        int n2 = n;
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n2);
        if (cameraCacheInfo == null) {
            if (SystemTools.checkMinimumApiLevel(18)) {
                // empty if block
            }
            return;
        }
        this.newFrameAvailable(cameraCacheInfo.deviceHandle, n2, cameraCacheInfo.bufferWidth, cameraCacheInfo.bufferHeight, cameraCacheInfo.bufferFormatPL, byArray, l);
        camera.addCallbackBuffer(byArray);
        if (SystemTools.checkMinimumApiLevel(18)) {
            // empty if block
        }
    }

    private native void newFrameAvailable(long var1, int var3, int var4, int var5, int var6, byte[] var7, long var8);

    public boolean init() {
        this.cameraCacheInfo = new Vector();
        this.cameraCacheInfoIndexCache = new HashMap();
        return true;
    }

    public void setSurfaceManager(SurfaceManager surfaceManager) {
        this.surfaceManager = surfaceManager;
    }

    public int getNumberOfCameras() {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            try {
                int n = Camera.getNumberOfCameras();
                return n;
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
        }
        boolean bl = false;
        try {
            PackageManager packageManager = SystemTools.getActivityFromNative().getPackageManager();
            bl = packageManager.hasSystemFeature("android.hardware.camera");
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        return bl ? 1 : 0;
    }

    public int getOrientation(int n) {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            try {
                Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
            return cameraInfo.orientation;
        }
        SystemTools.setSystemErrorCode(6);
        return -1;
    }

    public int getDirection(int n) {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(9)) {
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            try {
                Camera.getCameraInfo((int)n, (Camera.CameraInfo)cameraInfo);
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
            switch (cameraInfo.facing) {
                case 0: {
                    return 0x10002011;
                }
                case 1: {
                    return 0x10002012;
                }
            }
            return 0x10002010;
        }
        return 0x10002011;
    }

    public int getDeviceID(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return -1;
        }
        return cameraCacheInfo.deviceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(long l, int n, int n2, int n3, String string, int[] nArray, int[] nArray2) {
        boolean bl;
        int n4;
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        int n5 = this.getCameraDeviceIndex(n, n2, n3);
        if (n5 < 0) {
            return -1;
        }
        int n6 = -1;
        CameraCacheInfo cameraCacheInfo = null;
        int n7 = this.cameraCacheInfo.size();
        for (n4 = 0; n4 < n7; ++n4) {
            cameraCacheInfo = this.cameraCacheInfo.get(n4);
            if (cameraCacheInfo.deviceID != n5) continue;
            n6 = n4;
            break;
        }
        if (n6 < 0) {
            cameraCacheInfo = new CameraCacheInfo();
            cameraCacheInfo.deviceID = n5;
            cameraCacheInfo.deviceHandle = l;
            cameraCacheInfo.camera = null;
            cameraCacheInfo.surface = null;
            cameraCacheInfo.buffer = null;
            cameraCacheInfo.overrideWidth = 0;
            cameraCacheInfo.requestWidth = 0;
            cameraCacheInfo.bufferWidth = 0;
            cameraCacheInfo.overrideHeight = 0;
            cameraCacheInfo.requestHeight = 0;
            cameraCacheInfo.bufferHeight = 0;
            cameraCacheInfo.bufferFormatPL = 0x10001100;
            cameraCacheInfo.overrideFormatAndroid = 0;
            cameraCacheInfo.requestFormatAndroid = 0;
            cameraCacheInfo.caps = null;
            cameraCacheInfo.status = 0x10002001;
            cameraCacheInfo.isAutoFocusing = false;
            cameraCacheInfo.isHalDriven = false;
        }
        cameraCacheInfo.bufferSize = 0;
        n4 = 0;
        int n8 = 10;
        do {
            try {
                if (SystemTools.checkMinimumApiLevel(9)) {
                    cameraCacheInfo.camera = Camera.open((int)cameraCacheInfo.deviceID);
                } else if (cameraCacheInfo.deviceID == 0) {
                    cameraCacheInfo.camera = Camera.open();
                }
                n4 = cameraCacheInfo.camera != null ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 != 0) continue;
            try {
                if (n8 <= 0) continue;
                Camera1_Preview camera1_Preview = this;
                synchronized (camera1_Preview) {
                    this.wait(250L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (n4 == 0 && n8-- > 0);
        if (cameraCacheInfo.camera == null) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        boolean bl2 = nArray != null && nArray.length > 0 || nArray2 != null && nArray2.length > 0;
        boolean bl3 = bl = string != null && string.length() > 0;
        if (bl2 || bl) {
            boolean bl4;
            Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
            if (parameters == null) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
            if (bl2) {
                if (nArray != null && nArray.length != 5) {
                    SystemTools.setSystemErrorCode(2);
                    return -1;
                }
                bl4 = this.setCameraCaptureParams(cameraCacheInfo, parameters, nArray, nArray2);
                if (!bl4) {
                    SystemTools.setSystemErrorCode(6);
                    return -1;
                }
            }
            if (bl && !(bl4 = this.setCustomCameraParams(parameters, string))) {
                SystemTools.setSystemErrorCode(2);
                return -1;
            }
            try {
                cameraCacheInfo.camera.setParameters(parameters);
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
            if (!this.checkSamsungHighFPS(cameraCacheInfo)) {
                return -1;
            }
        }
        cameraCacheInfo.status = 0x10002002;
        if (n6 < 0) {
            this.cameraCacheInfo.add(cameraCacheInfo);
            n6 = this.cameraCacheInfo.size() - 1;
        }
        this.cameraCacheInfoIndexCache.put(cameraCacheInfo.camera, n6);
        return n6;
    }

    public int registerHalCamera(int n, int n2, int n3, String string, int[] nArray, int[] nArray2) {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        int n4 = this.getCameraDeviceIndex(n, n2, n3);
        if (n4 < 0) {
            return -1;
        }
        int n5 = -1;
        CameraCacheInfo cameraCacheInfo = null;
        int n6 = this.cameraCacheInfo.size();
        for (int i = 0; i < n6; ++i) {
            cameraCacheInfo = this.cameraCacheInfo.get(i);
            if (cameraCacheInfo.deviceID != n4 || !cameraCacheInfo.isHalDriven) continue;
            n5 = i;
            break;
        }
        if (n5 < 0) {
            cameraCacheInfo = new CameraCacheInfo();
            cameraCacheInfo.deviceID = n4;
            cameraCacheInfo.camera = null;
            cameraCacheInfo.surface = null;
            cameraCacheInfo.buffer = null;
            cameraCacheInfo.overrideWidth = 0;
            cameraCacheInfo.requestWidth = 0;
            cameraCacheInfo.bufferWidth = 0;
            cameraCacheInfo.overrideHeight = 0;
            cameraCacheInfo.requestHeight = 0;
            cameraCacheInfo.bufferHeight = 0;
            cameraCacheInfo.bufferFormatPL = 0x10001100;
            cameraCacheInfo.overrideFormatAndroid = 0;
            cameraCacheInfo.requestFormatAndroid = 0;
            cameraCacheInfo.caps = null;
            cameraCacheInfo.status = 0x10002001;
            cameraCacheInfo.isAutoFocusing = false;
            cameraCacheInfo.isHalDriven = true;
        }
        cameraCacheInfo.bufferSize = 0;
        if (n5 < 0) {
            this.cameraCacheInfo.add(cameraCacheInfo);
            n5 = this.cameraCacheInfo.size() - 1;
            DebugLog.LOGD(MODULENAME, "New HAL camera cache info added to cache");
        }
        return n5;
    }

    public boolean close(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (cameraCacheInfo.isHalDriven) {
            DebugLog.LOGW(MODULENAME, "We shouldn't be here for HAL driven camera!");
            return true;
        }
        this.cameraCacheInfoIndexCache.remove(cameraCacheInfo.camera);
        boolean bl = false;
        try {
            cameraCacheInfo.camera.release();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        cameraCacheInfo.camera = null;
        cameraCacheInfo.buffer = null;
        cameraCacheInfo.status = 0x10002001;
        System.gc();
        return bl;
    }

    public int[] getCameraCapabilities(int n) {
        ListIterator listIterator;
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        if (cameraCacheInfo.caps != null) {
            return cameraCacheInfo.caps;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPreviewFrameRates();
        List list3 = parameters.getSupportedPreviewFormats();
        List list4 = parameters.getSupportedFlashModes();
        List list5 = parameters.getSupportedFocusModes();
        int n2 = list != null ? list.size() : 0;
        int n3 = list2 != null ? list2.size() : 0;
        int n4 = list3 != null ? list3.size() : 0;
        int n5 = 6 + n2 * 2 + n3 + n4;
        cameraCacheInfo.caps = new int[n5];
        int n6 = 0;
        cameraCacheInfo.caps[n6] = 0x20000000;
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000001, list4 != null ? list4.contains("torch") || list4.contains("on") : false);
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000002, true);
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000004, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000010, SystemTools.checkMinimumApiLevel(14));
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000400, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000800, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20008000, SystemTools.checkMinimumApiLevel(8) && parameters.isZoomSupported());
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20010000, SystemTools.checkMinimumApiLevel(8) && parameters.isZoomSupported());
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x21000000, SystemTools.checkMinimumApiLevel(15));
        n6 = 1;
        cameraCacheInfo.caps[n6] = 0x20000000;
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000001, list4 != null ? list4.contains("torch") || list4.contains("on") : false);
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000002, true);
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000010, SystemTools.checkMinimumApiLevel(14));
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20000400, SystemTools.checkMinimumApiLevel(8));
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x20008000, SystemTools.checkMinimumApiLevel(8) && parameters.isZoomSupported());
        this.setCameraCapsBit(cameraCacheInfo, n6, 0x21000000, SystemTools.checkMinimumApiLevel(15));
        n6 = 2;
        cameraCacheInfo.caps[n6] = 0x30000000;
        if (list4 != null && (list4.contains("torch") || list4.contains("on"))) {
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000001, true);
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000002, true);
        }
        if (list5 != null) {
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000010, true);
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000020, list5.contains("auto"));
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000040, list5.contains("continuous-video"));
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000080, list5.contains("macro"));
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000100, list5.contains("infinity"));
            this.setCameraCapsBit(cameraCacheInfo, n6, 0x30000200, list5.contains("fixed"));
        }
        cameraCacheInfo.caps[3] = n2;
        cameraCacheInfo.caps[4] = n3;
        cameraCacheInfo.caps[5] = n4;
        int n7 = 6;
        if (n2 > 0) {
            listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Camera.Size size = (Camera.Size)listIterator.next();
                cameraCacheInfo.caps[n7] = size.width;
                cameraCacheInfo.caps[n7 + 1] = size.height;
                n7 += 2;
            }
        }
        if (n3 > 0) {
            listIterator = list2.listIterator();
            while (listIterator.hasNext()) {
                int n8;
                cameraCacheInfo.caps[n7] = n8 = ((Integer)listIterator.next()).intValue();
                ++n7;
            }
        }
        if (n4 > 0) {
            listIterator = list3.listIterator();
            while (listIterator.hasNext()) {
                int n9 = (Integer)listIterator.next();
                cameraCacheInfo.caps[n7] = this.translateImageFormat(n9, true);
                ++n7;
            }
        }
        return cameraCacheInfo.caps;
    }

    public boolean setCaptureInfo(int n, int[] nArray, int[] nArray2) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (nArray.length != 5) {
            SystemTools.setSystemErrorCode(2);
            return false;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        boolean bl = this.setCameraCaptureParams(cameraCacheInfo, parameters, nArray, nArray2);
        if (!bl) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        try {
            cameraCacheInfo.camera.setParameters(parameters);
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        return this.checkSamsungHighFPS(cameraCacheInfo);
    }

    public int[] getCaptureInfo(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        int[] nArray = null;
        try {
            nArray = new int[]{parameters.getPreviewSize().width, parameters.getPreviewSize().height, this.translateImageFormat(parameters.getPreviewFormat(), CONVERT_FORMAT_TO_PL), parameters.getPreviewFrameRate(), cameraCacheInfo.surface != null || cameraCacheInfo.surfaceTexture != null ? 1 : 0};
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        return nArray;
    }

    public boolean start(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (!this.setupPreviewBuffer(cameraCacheInfo)) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        try {
            cameraCacheInfo.camera.startPreview();
            cameraCacheInfo.status = 268443651;
            return true;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    public boolean stop(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        try {
            cameraCacheInfo.camera.stopPreview();
            cameraCacheInfo.status = 0x10002002;
            return true;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    public boolean setBatchParameters(int n, String string) {
        if (string == null) {
            return false;
        }
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.camera == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        if (!this.setCustomCameraParams(parameters, string)) {
            return false;
        }
        cameraCacheInfo.camera.setParameters(parameters);
        return true;
    }

    boolean setUntypedCameraParameter(int n, String string, String string2) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.camera == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        try {
            parameters.set(string, string2);
            cameraCacheInfo.camera.setParameters(parameters);
            return true;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    String getUntypedCameraParameter(int n, String string) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.camera == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        String string2 = parameters.get(string);
        if (string2 == null) {
            SystemTools.setSystemErrorCode(6);
        }
        return string2;
    }

    String getFlattenedParameters(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.camera == null) {
            SystemTools.setSystemErrorCode(4);
            return "";
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return "";
        }
        return parameters.flatten();
    }

    boolean setTypedCameraParameter(int n, int n2, Object object) {
        boolean bl;
        Camera.Parameters parameters;
        CameraCacheInfo cameraCacheInfo;
        block74: {
            cameraCacheInfo = this.getCameraCacheInfo(n);
            if (cameraCacheInfo == null || cameraCacheInfo.camera == null) {
                SystemTools.setSystemErrorCode(4);
                return false;
            }
            parameters = this.getCameraParameters(cameraCacheInfo.camera);
            if (parameters == null) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
            bl = false;
            try {
                block3 : switch (n2) {
                    case 0x20000040: {
                        String string = Integer.toString(((Number)object).intValue());
                        String string2 = parameters.get("iso-values");
                        if (string2 != null) {
                            String[] stringArray = string2.split(",");
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (!stringArray[i].toLowerCase().contains(string.toLowerCase())) continue;
                                string = stringArray[i];
                                break;
                            }
                        }
                        parameters.set("iso", string);
                        break;
                    }
                    case 0x20400000: {
                        int n3 = ((Number)object).intValue();
                        if (SystemTools.checkMinimumApiLevel(14)) {
                            parameters.setRecordingHint(n3 != 0);
                            break;
                        }
                        parameters.set("recording-hint", n3 != 0 ? "true" : "false");
                        break;
                    }
                    case 0x20000001: {
                        int n4 = ((Number)object).intValue();
                        switch (n4) {
                            case 0x30000002: {
                                if (parameters.getSupportedFlashModes().contains("torch")) {
                                    parameters.setFlashMode("torch");
                                    break block3;
                                }
                                parameters.setFlashMode("on");
                                break block3;
                            }
                            case 0x30000001: {
                                parameters.setFlashMode("off");
                                break block3;
                            }
                            case 0x30000004: {
                                SystemTools.setSystemErrorCode(3);
                                return false;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000002: {
                        cameraCacheInfo.camera.cancelAutoFocus();
                        int n5 = ((Number)object).intValue();
                        switch (n5) {
                            case 0x30000010: {
                                if (parameters.getSupportedFocusModes().contains(FOCUS_MODE_NORMAL)) {
                                    parameters.setFocusMode(FOCUS_MODE_NORMAL);
                                    break block3;
                                }
                                parameters.setFocusMode("auto");
                                bl = true;
                                break block3;
                            }
                            case 0x30000020: {
                                parameters.setFocusMode("auto");
                                bl = true;
                                break block3;
                            }
                            case 0x30000040: {
                                if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                                    parameters.setFocusMode("continuous-video");
                                    break block3;
                                }
                                SystemTools.setSystemErrorCode(6);
                                return false;
                            }
                            case 0x30000080: {
                                parameters.setFocusMode("macro");
                                break block3;
                            }
                            case 0x30000100: {
                                parameters.setFocusMode("infinity");
                                break block3;
                            }
                            case 0x30000200: {
                                parameters.setFocusMode("fixed");
                                break block3;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000004: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000008: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000010: {
                        if (SystemTools.checkMinimumApiLevel(14)) {
                            float[] fArray = (float[])object;
                            if (fArray.length != 5) {
                                SystemTools.setSystemErrorCode(2);
                                return false;
                            }
                            if (fArray[0] < 0.0f || fArray[0] > 1.0f || fArray[1] < 0.0f || fArray[1] > 1.0f || fArray[2] < 0.0f || fArray[2] > 1.0f || fArray[3] < 0.0f || fArray[3] > 1.0f || fArray[4] < 0.0f || fArray[4] > 1.0f) {
                                SystemTools.setSystemErrorCode(2);
                                return false;
                            }
                            Rect rect = new Rect((int)((double)fArray[0] * 2000.0) - 1000, (int)((double)fArray[1] * 2000.0) - 1000, (int)((double)fArray[2] * 2000.0) - 1000, (int)((double)fArray[3] * 2000.0) - 1000);
                            ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
                            Camera.Area area = new Camera.Area(rect, (int)((double)fArray[4] * 1000.0));
                            arrayList.add(area);
                            if (parameters.getMaxNumFocusAreas() > 0) {
                                parameters.setFocusAreas(arrayList);
                            }
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000020: {
                        int n6 = ((Number)object).intValue();
                        switch (n6) {
                            case 0x30001000: {
                                if (parameters.isAutoExposureLockSupported()) {
                                    parameters.setAutoExposureLock(true);
                                    break block3;
                                }
                                break block74;
                            }
                            case 0x30004000: {
                                if (parameters.isAutoExposureLockSupported()) {
                                    parameters.setAutoExposureLock(false);
                                    break block3;
                                }
                                break block74;
                            }
                            default: {
                                SystemTools.setSystemErrorCode(3);
                                return false;
                            }
                        }
                    }
                    case 0x20000400: {
                        if (SystemTools.checkMinimumApiLevel(8)) {
                            float f = ((Number)object).floatValue();
                            float f2 = parameters.getExposureCompensationStep();
                            if (f2 == 0.0f) {
                                SystemTools.setSystemErrorCode(6);
                                return false;
                            }
                            parameters.setExposureCompensation(Math.round(f / f2));
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000800: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20001000: {
                        int n7 = ((Number)object).intValue();
                        switch (n7) {
                            case 0x30100000: {
                                if (parameters.isAutoWhiteBalanceLockSupported()) {
                                    parameters.setAutoWhiteBalanceLock(true);
                                    break block3;
                                }
                                break block74;
                            }
                            case 0x30400000: {
                                if (parameters.isAutoWhiteBalanceLockSupported()) {
                                    parameters.setAutoWhiteBalanceLock(false);
                                    break block3;
                                }
                                break block74;
                            }
                            default: {
                                SystemTools.setSystemErrorCode(3);
                                SystemTools.logSystemError("Cannot set unknown white balance mode (" + n7 + ")");
                                return false;
                            }
                        }
                    }
                    case 0x20002000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20004000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20008000: {
                        if (SystemTools.checkMinimumApiLevel(8) && parameters.isZoomSupported()) {
                            int n8 = ((Number)object).intValue();
                            parameters.setZoom(n8);
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20010000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20020000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20040000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20080000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20100000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20200000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x21000000: {
                        boolean bl2 = (Boolean)object;
                        if (bl2) {
                            parameters.setVideoStabilization(true);
                            break;
                        }
                        parameters.setVideoStabilization(false);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
        }
        try {
            cameraCacheInfo.camera.setParameters(parameters);
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        if (bl) {
            try {
                switch (n2) {
                    case 0x20000002: {
                        cameraCacheInfo.isAutoFocusing = true;
                        cameraCacheInfo.camera.autoFocus(new Camera.AutoFocusCallback(){

                            public void onAutoFocus(boolean bl, Camera camera) {
                                int n;
                                CameraCacheInfo cameraCacheInfo;
                                Object v = Camera1_Preview.this.cameraCacheInfoIndexCache.get(camera);
                                if (v != null && (cameraCacheInfo = Camera1_Preview.this.getCameraCacheInfo(n = ((Integer)v).intValue())) != null) {
                                    cameraCacheInfo.isAutoFocusing = false;
                                }
                            }
                        });
                        break;
                    }
                }
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
        }
        return true;
    }

    Object getTypedCameraParameter(int n, int n2) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.camera == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        Camera.Parameters parameters = this.getCameraParameters(cameraCacheInfo.camera);
        if (parameters == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        try {
            switch (n2) {
                case 0x20000001: {
                    String string = parameters.getFlashMode();
                    if (string.equals("torch") || string.equals("on")) {
                        return 0x30000002;
                    }
                    if (string.equals("off")) {
                        return 0x30000001;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000002: {
                    String string = parameters.getFocusMode();
                    if (string.equals("auto")) {
                        return cameraCacheInfo.isAutoFocusing ? 0x30000020 : 0x30000010;
                    }
                    if (string.equals("continuous-video")) {
                        return 0x30000040;
                    }
                    if (string.equals("infinity")) {
                        return 0x30000100;
                    }
                    if (string.equals("macro")) {
                        return 0x30000080;
                    }
                    if (string.equals("fixed")) {
                        return 0x30000200;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000004: {
                    if (SystemTools.checkMinimumApiLevel(8)) {
                        return Float.valueOf(parameters.getFocalLength());
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000008: {
                    if (SystemTools.checkMinimumApiLevel(9)) {
                        float[] fArray = new float[3];
                        parameters.getFocusDistances(fArray);
                        float[] fArray2 = new float[]{fArray[0], fArray[2]};
                        return fArray2;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000010: {
                    List list;
                    if (SystemTools.checkMinimumApiLevel(14) && parameters.getMaxNumFocusAreas() > 0 && (list = parameters.getFocusAreas()).size() > 0) {
                        Camera.Area area = (Camera.Area)list.get(0);
                        float[] fArray = new float[]{area.rect.left, area.rect.top, area.rect.right, area.rect.bottom, area.weight};
                        return fArray;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000020: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000400: {
                    if (SystemTools.checkMinimumApiLevel(8)) {
                        return Float.valueOf(parameters.getExposureCompensationStep() * (float)parameters.getExposureCompensation());
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000800: {
                    if (SystemTools.checkMinimumApiLevel(8)) {
                        float[] fArray = new float[]{parameters.getExposureCompensationStep() * (float)parameters.getMinExposureCompensation(), parameters.getExposureCompensationStep() * (float)parameters.getMaxExposureCompensation()};
                        return fArray;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20001000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20002000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20004000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20008000: {
                    if (SystemTools.checkMinimumApiLevel(8) && parameters.isZoomSupported()) {
                        return parameters.getZoom();
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20010000: {
                    if (SystemTools.checkMinimumApiLevel(8) && parameters.isZoomSupported()) {
                        int[] nArray = new int[]{0, parameters.getMaxZoom()};
                        return nArray;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20020000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20040000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20080000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20100000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20200000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x21000000: {
                    if (parameters.getVideoStabilization()) {
                        return true;
                    }
                    return false;
                }
            }
            return null;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
    }

    int getStatus(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return 0x10002000;
        }
        return cameraCacheInfo.status;
    }

    public class CameraCacheInfo {
        int deviceID;
        long deviceHandle;
        Camera camera;
        CameraSurface surface;
        SurfaceTexture surfaceTexture;
        byte[][] buffer;
        int bufferWidth;
        int bufferHeight;
        int bufferFormatPL;
        int requestWidth;
        int requestHeight;
        int requestFormatAndroid;
        int overrideWidth;
        int overrideHeight;
        int overrideFormatAndroid;
        int bufferSize;
        int[] caps;
        int status;
        boolean isAutoFocusing;
        boolean isHalDriven;
    }
}

