/*
 * Decompiled with CFR 0.152.
 */
package com.vuforia.ar.pl;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Trace;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import android.view.Surface;
import com.vuforia.ar.pl.DebugLog;
import com.vuforia.ar.pl.SystemTools;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=21)
public class Camera2_Preview {
    private Vector<CameraCacheInfo> mCameraCacheInfos = null;
    private Vector<CameraCacheInfo> mCameraCacheInfosInProgress = null;
    private HashMap<ImageReader, Integer> mCameraCacheInfoIndexCache = null;
    private Context mContext;
    private CameraManager mCameraManager;
    private Semaphore mOpenCloseSemaphore = new Semaphore(1);
    private static final int CAMERA_CAPTUREINFO_VALUE_WIDTH = 0;
    private static final int CAMERA_CAPTUREINFO_VALUE_HEIGHT = 1;
    private static final int CAMERA_CAPTUREINFO_VALUE_FORMAT = 2;
    private static final int CAMERA_CAPTUREINFO_VALUE_FRAMERATE = 3;
    private static final int CAMERA_CAPTUREINFO_VALUE_PREVIEWSURFACEENABLED = 4;
    private static final int _NUM_CAMERA_CAPTUREINFO_VALUE_ = 5;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_QUERYABLE_PARAMS = 0;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_SETTABLE_PARAMS = 1;
    private static final int CAMERA_CAPSINFO_VALUE_SUPPORTED_PARAMVALUES = 2;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_IMAGESIZES = 3;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_FRAMERATES = 4;
    private static final int CAMERA_CAPSINFO_VALUE_NUM_SUPPORTED_IMAGEFORMATS = 5;
    private static final int _NUM_CAMERA_CAPSINFO_VALUE_ = 6;
    private static final int AR_CAMERA_PARAMTYPE_BASE = 0x20000000;
    private static final int AR_CAMERA_PARAMTYPE_TORCHMODE = 0x20000001;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSMODE = 0x20000002;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSVALUE = 0x20000004;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSRANGE = 0x20000008;
    private static final int AR_CAMERA_PARAMTYPE_FOCUSREGION = 0x20000010;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREMODE = 0x20000020;
    private static final int AR_CAMERA_PARAMTYPE_ISO = 0x20000040;
    private static final int AR_CAMERA_PARAMTYPE_ISORANGE = 0x20000080;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURETIME = 0x20000100;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSURETIMERANGE = 0x20000200;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREVALUE = 0x20000400;
    private static final int AR_CAMERA_PARAMTYPE_EXPOSUREVALUERANGE = 0x20000800;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCEMODE = 0x20001000;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCEVALUE = 0x20002000;
    private static final int AR_CAMERA_PARAMTYPE_WHITEBALANCERANGE = 0x20004000;
    private static final int AR_CAMERA_PARAMTYPE_ZOOMVALUE = 0x20008000;
    private static final int AR_CAMERA_PARAMTYPE_ZOOMRANGE = 0x20010000;
    private static final int AR_CAMERA_PARAMTYPE_BRIGHTNESSVALUE = 0x20020000;
    private static final int AR_CAMERA_PARAMTYPE_BRIGHTNESSRANGE = 0x20040000;
    private static final int AR_CAMERA_PARAMTYPE_CONTRASTVALUE = 0x20080000;
    private static final int AR_CAMERA_PARAMTYPE_CONTRASTRANGE = 0x20100000;
    private static final int AR_CAMERA_PARAMTYPE_ROTATION = 0x20200000;
    private static final int AR_CAMERA_PARAMTYPE_RECORDING_HINT = 0x20400000;
    private static final int AR_CAMERA_PARAMTYPE_LENS_IS_ADJUSTING = 0x20800000;
    private static final int AR_CAMERA_PARAMTYPE_VIDEO_STABILIZATION = 0x21000000;
    private static final int AR_CAMERA_PARAMVALUE_BASE = 0x30000000;
    private static final int AR_CAMERA_TORCHMODE_OFF = 0x30000001;
    private static final int AR_CAMERA_TORCHMODE_ON = 0x30000002;
    private static final int AR_CAMERA_TORCHMODE_AUTO = 0x30000004;
    private static final int AR_CAMERA_TORCHMODE_CONTINUOUSAUTO = 0x30000008;
    private static final int AR_CAMERA_FOCUSMODE_NORMAL = 0x30000010;
    private static final int AR_CAMERA_FOCUSMODE_AUTO = 0x30000020;
    private static final int AR_CAMERA_FOCUSMODE_CONTINUOUSAUTO = 0x30000040;
    private static final int AR_CAMERA_FOCUSMODE_MACRO = 0x30000080;
    private static final int AR_CAMERA_FOCUSMODE_INFINITY = 0x30000100;
    private static final int AR_CAMERA_FOCUSMODE_FIXED = 0x30000200;
    private static final int AR_CAMERA_EXPOSUREMODE_LOCKED = 0x30001000;
    private static final int AR_CAMERA_EXPOSUREMODE_AUTO = 0x30002000;
    private static final int AR_CAMERA_EXPOSUREMODE_CONTINUOUSAUTO = 0x30004000;
    private static final int AR_CAMERA_EXPOSUREMODE_MANUAL = 0x30008000;
    private static final int AR_CAMERA_EXPOSUREMODE_SHUTTER_PRIORITY = 0x30010000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_LOCKED = 0x30100000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_AUTO = 0x30200000;
    private static final int AR_CAMERA_WHITEBALANCEMODE_CONTINUOUSAUTO = 0x30400000;
    private static final int AR_CAMERA_TYPE_UNKNOWN = 0x10003010;
    private static final int AR_CAMERA_TYPE_MONO = 0x10003011;
    private static final int AR_CAMERA_TYPE_STEREO = 268447762;
    private static final int AR_CAMERA_DIRECTION_UNKNOWN = 0x10002010;
    private static final int AR_CAMERA_DIRECTION_BACK = 0x10002011;
    private static final int AR_CAMERA_DIRECTION_FRONT = 0x10002012;
    private static final int AR_CAMERA_STATUS_UNKNOWN = 0x10002000;
    private static final int AR_CAMERA_STATUS_UNINITIALIZED = 0x10002001;
    private static final int AR_CAMERA_STATUS_OPENED = 0x10002002;
    private static final int AR_CAMERA_STATUS_CAPTURE_RUNNING = 268443651;
    private static final int AR_CAMERA_IMAGE_FORMAT_UNKNOWN = 0x10001100;
    private static final int AR_CAMERA_IMAGE_FORMAT_LUM = 0x10001101;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB565 = 0x10001102;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB888 = 0x10001103;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGB24 = 0x10001103;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA8888 = 0x10001104;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA32 = 0x10001104;
    private static final int AR_CAMERA_IMAGE_FORMAT_ARGB8888 = 0x10001105;
    private static final int AR_CAMERA_IMAGE_FORMAT_ARGB32 = 0x10001105;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGRA8888 = 0x10001106;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGRA32 = 0x10001106;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV12 = 0x10001107;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV16 = 0x10001108;
    private static final int AR_CAMERA_IMAGE_FORMAT_NV21 = 0x10001109;
    private static final int AR_CAMERA_IMAGE_FORMAT_YV12 = 0x1000110A;
    private static final int AR_CAMERA_IMAGE_FORMAT_YV16 = 0x1000110B;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA5551 = 0x1000110C;
    private static final int AR_CAMERA_IMAGE_FORMAT_RGBA4444 = 0x1000110D;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGR888 = 0x1000110E;
    private static final int AR_CAMERA_IMAGE_FORMAT_BGR24 = 0x1000110E;
    private static final int AR_CAMERA_IMAGE_FORMAT_YUV420P = 0x10001114;
    private static final int[] CAMERA_VALID_IMAGE_FORMAT_PL = new int[]{0x10001109, 0x10001107, 0x1000110A, 0x10001114};
    private static final int NUM_CAPTURE_BUFFERS = 2;
    private static final int NUM_MAX_CAMERAOPEN_RETRY = 10;
    private static final int TIME_CAMERAOPEN_RETRY_DELAY_MS = 250;
    private static final String MODULENAME = "Camera2_Preview";
    private static final int MAX_LOWEST_FPS_ALLOWED = 150;
    private static final int MAX_HIGHEST_FPS_ALLOWED = 300;
    private static final Range<Integer> EMPTY_RANGE = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
    private static final String FOCUS_MODE_NORMAL = "normal";
    private int mIsPermissionGranted = -1;

    private boolean checkPermission() {
        if (this.mIsPermissionGranted == 0) {
            return true;
        }
        try {
            Activity activity = SystemTools.getActivityFromNative();
            PackageManager packageManager = activity.getPackageManager();
            this.mIsPermissionGranted = packageManager.checkPermission("android.permission.CAMERA", activity.getPackageName());
            if (this.mIsPermissionGranted == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int getCameraDeviceIndex(int n, int n2, int n3) {
        if (n2 != 0x10003010) {
            // empty if block
        }
        int n4 = -1;
        switch (n3) {
            case 0x10002010: {
                break;
            }
            case 0x10002011: {
                n4 = 1;
                break;
            }
            case 0x10002012: {
                n4 = 0;
                break;
            }
            default: {
                SystemTools.setSystemErrorCode(2);
                return -1;
            }
        }
        try {
            String[] stringArray = this.mCameraManager.getCameraIdList();
            for (int i = 0; i < stringArray.length; ++i) {
                CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(stringArray[i]);
                if (n4 >= 0 && n4 != (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) || n >= 0 && n != i) continue;
                return i;
            }
        }
        catch (CameraAccessException cameraAccessException) {
            // empty catch block
        }
        SystemTools.setSystemErrorCode(6);
        return -1;
    }

    private CameraCacheInfo getCameraCacheInfo(int n) {
        if (n < 0 || n >= this.mCameraCacheInfos.size()) {
            return null;
        }
        return this.mCameraCacheInfos.get(n);
    }

    private boolean setCustomCameraParams(CameraCacheInfo cameraCacheInfo, String string) {
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null) {
            return false;
        }
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            return false;
        }
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            try {
                object = jSONObject.get(string2);
            }
            catch (JSONException jSONException) {
                return false;
            }
            Class<?> clazz = object.getClass();
            if (clazz == String.class || clazz == Integer.class) {
                if (this.mapStringToKey(string2, cameraCacheInfo.characteristics, object) != null) {
                    cameraCacheInfo.builder.set(this.mapStringToKey(string2, cameraCacheInfo.characteristics, object), object);
                    continue;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private <T> CaptureRequest.Key<T> mapStringToKey(String string, CameraCharacteristics cameraCharacteristics, T t) {
        List list = cameraCharacteristics.getAvailableCaptureRequestKeys();
        for (CaptureRequest.Key key : list) {
            if (!key.getName().equals(string)) continue;
            return key;
        }
        return null;
    }

    private boolean setCameraCaptureParams(CameraCacheInfo cameraCacheInfo, int[] nArray, int[] nArray2) {
        Size[] sizeArray;
        int n;
        if (nArray != null || nArray2 != null) {
            cameraCacheInfo.overrideWidth = nArray2 != null ? nArray2[0] : nArray[0];
            cameraCacheInfo.overrideHeight = nArray2 != null ? nArray2[1] : nArray[1];
            cameraCacheInfo.overrideFormatPL = nArray2 != null ? nArray2[2] : nArray[2];
            cameraCacheInfo.overrideFormatAndroid = this.translateImageFormatPLToAndroid(nArray2 != null ? nArray2[2] : nArray[2]);
        }
        if (nArray == null) {
            return true;
        }
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null) {
            DebugLog.LOGE(MODULENAME, "CamCacheInfo not properly initialized in setCaptureParams");
            return false;
        }
        cameraCacheInfo.requestWidth = nArray[0];
        cameraCacheInfo.requestHeight = nArray[1];
        cameraCacheInfo.requestFormatPL = nArray[2];
        cameraCacheInfo.requestFormatAndroid = this.translateImageFormatPLToAndroid(nArray[2]);
        cameraCacheInfo.requestFramerate = nArray[3];
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCacheInfo.characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizeArray2 = streamConfigurationMap.getOutputSizes(cameraCacheInfo.requestFormatAndroid);
        if (sizeArray2 == null) {
            DebugLog.LOGD(MODULENAME, String.format("setCameraCaptureParams: format not supported. : %d", nArray[2]));
            return false;
        }
        boolean bl = false;
        Size[] sizeArray3 = sizeArray2;
        int n2 = sizeArray3.length;
        for (n = 0; n < n2 && !(bl = (sizeArray = sizeArray3[n]).equals((Object)new Size(cameraCacheInfo.requestWidth, cameraCacheInfo.requestHeight))); ++n) {
        }
        if (!bl) {
            DebugLog.LOGD(MODULENAME, String.format("setCameraCaptureParams: size not supported. : %d, %d", cameraCacheInfo.requestWidth, cameraCacheInfo.requestHeight));
            return false;
        }
        sizeArray3 = (Range[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        Size size = null;
        n = Integer.MAX_VALUE;
        for (Size size2 : sizeArray3) {
            int n3;
            if ((Integer)size2.getLower() >= 150 || (Integer)size2.getUpper() >= 300) {
                DebugLog.LOGW(MODULENAME, String.format("Detected odd fps values from Camera2 API: low=%d, high=%d.  Using first fps range as default instead of searching for perfect fit.", size2.getLower(), size2.getUpper()));
                size = sizeArray3[0];
                break;
            }
            if (!size2.contains((Comparable)Integer.valueOf(cameraCacheInfo.requestFramerate)) || (n3 = (Integer)size2.getUpper() - (Integer)size2.getLower()) >= n) continue;
            size = size2;
            n = n3;
        }
        if (size == null) {
            DebugLog.LOGD(MODULENAME, String.format("setCameraCaptureParams: fps range not supported.", new Object[0]));
            return false;
        }
        cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, size);
        return true;
    }

    private boolean setupPreviewBuffer(CameraCacheInfo cameraCacheInfo) {
        cameraCacheInfo.reader = ImageReader.newInstance((int)cameraCacheInfo.requestWidth, (int)cameraCacheInfo.requestHeight, (int)cameraCacheInfo.requestFormatAndroid, (int)2);
        cameraCacheInfo.imageSemaphore = new Semaphore(2);
        cameraCacheInfo.images = new Image[2];
        cameraCacheInfo.bufferWidth = cameraCacheInfo.requestWidth == cameraCacheInfo.overrideWidth ? cameraCacheInfo.reader.getWidth() : cameraCacheInfo.overrideWidth;
        cameraCacheInfo.bufferHeight = cameraCacheInfo.requestHeight == cameraCacheInfo.overrideHeight ? cameraCacheInfo.reader.getHeight() : cameraCacheInfo.overrideHeight;
        int n = cameraCacheInfo.requestFormatAndroid == cameraCacheInfo.overrideFormatAndroid ? cameraCacheInfo.reader.getImageFormat() : cameraCacheInfo.overrideFormatAndroid;
        cameraCacheInfo.bufferFormatPL = cameraCacheInfo.requestFormatPL == cameraCacheInfo.overrideFormatPL ? cameraCacheInfo.requestFormatPL : cameraCacheInfo.overrideFormatPL;
        cameraCacheInfo.reader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new OnCameraDataAvailable(), cameraCacheInfo.handler);
        if (cameraCacheInfo.surfaces == null) {
            cameraCacheInfo.surfaces = new LinkedList<Surface>();
        }
        cameraCacheInfo.surfaces.clear();
        cameraCacheInfo.surfaces.add(cameraCacheInfo.reader.getSurface());
        return true;
    }

    private void setCameraCapsBit(CameraCacheInfo cameraCacheInfo, int n, int n2, boolean bl) {
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = 0x30000000;
                break;
            }
            case 0: 
            case 1: {
                n3 = 0x20000000;
                break;
            }
            default: {
                return;
            }
        }
        int n4 = (int)(Math.log(n2 & ~n3) / Math.log(2.0));
        if (bl) {
            int n5 = n;
            cameraCacheInfo.caps[n5] = cameraCacheInfo.caps[n5] | 1 << n4;
        } else {
            int n6 = n;
            cameraCacheInfo.caps[n6] = cameraCacheInfo.caps[n6] & ~(1 << n4);
        }
    }

    private int translateImageFormatPLToAndroid(int n) {
        for (int i = 0; i < CAMERA_VALID_IMAGE_FORMAT_PL.length; ++i) {
            if (n != CAMERA_VALID_IMAGE_FORMAT_PL[i]) continue;
            return 35;
        }
        return 0;
    }

    int getBitsPerPixel(int n) {
        switch (n) {
            case 16: {
                return 16;
            }
            case 4: {
                return 16;
            }
            case 17: {
                return 12;
            }
            case 842094169: {
                return 12;
            }
        }
        return 0;
    }

    private List<Integer> getSupportedPreviewFrameRates(CameraCharacteristics cameraCharacteristics) {
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (Range range : rangeArray) {
            n = Math.min(n, (Integer)range.getLower());
            n2 = Math.max(n2, (Integer)range.getUpper());
        }
        LinkedList linkedList = new LinkedList();
        if (n < 0 || n >= 150 || n2 < 0 || n2 >= 300) {
            DebugLog.LOGW(MODULENAME, String.format("Detected odd fps values from Camera2 API: low=%d, high=%d.  Using saner defaults instead.", n, n2));
            linkedList.add(30);
        } else {
            block1: for (int i = n; i <= n2; ++i) {
                for (Range range : rangeArray) {
                    if (!range.contains((Comparable)Integer.valueOf(i))) continue;
                    linkedList.add(i);
                    continue block1;
                }
            }
        }
        return linkedList;
    }

    private boolean checkCameraManager() {
        if (this.mCameraManager != null) {
            return true;
        }
        Activity activity = SystemTools.getActivityFromNative();
        if (activity == null) {
            return false;
        }
        Application application = activity.getApplication();
        if (application == null) {
            return false;
        }
        this.mCameraManager = (CameraManager)application.getSystemService("camera");
        return this.mCameraManager != null;
    }

    private static int compareHardwareSupportLevel(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n == 2) {
            return n2 >= 0 ? -1 : 1;
        }
        if (n2 == 2) {
            return n >= 0 ? 1 : -1;
        }
        return n - n2;
    }

    private void cleanupHandlerThread(CameraCacheInfo cameraCacheInfo) {
        cameraCacheInfo.handler = null;
        cameraCacheInfo.thread.quitSafely();
        cameraCacheInfo.thread = null;
    }

    private native void newFrameAvailable(long var1, int var3, int var4, int var5, int[] var6, int var7, ByteBuffer var8, Object var9);

    private native long getBufferAddress(ByteBuffer var1);

    public boolean init() {
        this.mCameraCacheInfos = new Vector();
        this.mCameraCacheInfosInProgress = new Vector();
        this.mCameraCacheInfoIndexCache = new HashMap();
        return true;
    }

    public int getNumberOfCameras() {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (!this.checkCameraManager()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(21)) {
            try {
                return this.mCameraManager.getCameraIdList().length;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SystemTools.setSystemErrorCode(6);
        return -1;
    }

    public int getOrientation(int n) {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (!this.checkCameraManager()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(21)) {
            try {
                String[] stringArray = this.mCameraManager.getCameraIdList();
                if (n < stringArray.length) {
                    CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(stringArray[n]);
                    return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SystemTools.setSystemErrorCode(6);
        return -1;
    }

    public int getDirection(int n) {
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (!this.checkCameraManager()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (SystemTools.checkMinimumApiLevel(21)) {
            try {
                String[] stringArray = this.mCameraManager.getCameraIdList();
                if (n < stringArray.length) {
                    CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(stringArray[n]);
                    Integer n2 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                    switch (n2) {
                        case 1: {
                            return 0x10002011;
                        }
                        case 0: {
                            return 0x10002012;
                        }
                    }
                    return 0x10002010;
                }
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
        }
        return 0x10002011;
    }

    public int getDeviceID(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return -1;
        }
        return cameraCacheInfo.deviceID;
    }

    public static boolean checkMinimumHardwareSupportLevel(int n, int n2) {
        try {
            int n3;
            if (n == 0x10002011) {
                n3 = 1;
            } else if (n == 0x10002012) {
                n3 = 0;
            } else {
                return false;
            }
            Activity activity = SystemTools.getActivityFromNative();
            CameraManager cameraManager = (CameraManager)activity.getSystemService("camera");
            String[] stringArray = cameraManager.getCameraIdList();
            for (int i = 0; i < stringArray.length; ++i) {
                CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(stringArray[i]);
                int n4 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (n4 != n3) continue;
                int n5 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                return Camera2_Preview.compareHardwareSupportLevel(n5, n2) >= 0;
            }
            return false;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int open(long l, int n, int n2, int n3, String string, int[] nArray, int[] nArray2) {
        boolean bl;
        int n4;
        if (!this.checkPermission()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (!this.checkCameraManager()) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        int n5 = this.getCameraDeviceIndex(n, n2, n3);
        if (n5 < 0) {
            return -1;
        }
        int n6 = -1;
        CameraCacheInfo cameraCacheInfo = null;
        int n7 = this.mCameraCacheInfos.size();
        for (n4 = 0; n4 < n7; ++n4) {
            cameraCacheInfo = this.mCameraCacheInfos.get(n4);
            if (cameraCacheInfo.deviceID != n5) continue;
            n6 = n4;
            break;
        }
        if (n6 < 0) {
            try {
                cameraCacheInfo = new CameraCacheInfo();
                cameraCacheInfo.deviceID = n5;
                cameraCacheInfo.deviceHandle = l;
                cameraCacheInfo.deviceIDString = this.mCameraManager.getCameraIdList()[cameraCacheInfo.deviceID];
                cameraCacheInfo.characteristics = this.mCameraManager.getCameraCharacteristics(cameraCacheInfo.deviceIDString);
                cameraCacheInfo.device = null;
                cameraCacheInfo.session = null;
                cameraCacheInfo.builder = null;
                cameraCacheInfo.surfaces = null;
                cameraCacheInfo.reader = null;
                cameraCacheInfo.images = null;
                cameraCacheInfo.imageSemaphore = null;
                cameraCacheInfo.overrideWidth = 0;
                cameraCacheInfo.bufferWidth = 0;
                cameraCacheInfo.overrideHeight = 0;
                cameraCacheInfo.bufferHeight = 0;
                cameraCacheInfo.bufferFormatPL = 0x10001100;
                cameraCacheInfo.overrideFormatPL = 0x10001100;
                cameraCacheInfo.overrideFormatAndroid = 0;
                cameraCacheInfo.caps = null;
                cameraCacheInfo.status = 0x10002001;
                cameraCacheInfo.isAutoFocusing = false;
                cameraCacheInfo.requestFormatPL = 0x10001109;
                cameraCacheInfo.requestFormatAndroid = 35;
                StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCacheInfo.characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                Size[] sizeArray = streamConfigurationMap.getOutputSizes(cameraCacheInfo.requestFormatAndroid);
                cameraCacheInfo.requestWidth = sizeArray.length > 0 ? sizeArray[0].getWidth() : 0;
                cameraCacheInfo.requestHeight = sizeArray.length > 0 ? sizeArray[0].getHeight() : 0;
            }
            catch (CameraAccessException cameraAccessException) {
                SystemTools.setSystemErrorCode(6);
                return -1;
            }
        }
        n4 = 0;
        int n8 = 10;
        cameraCacheInfo.thread = new HandlerThread(cameraCacheInfo.deviceIDString + "_camera_thread");
        cameraCacheInfo.thread.start();
        cameraCacheInfo.handler = new Handler(cameraCacheInfo.thread.getLooper());
        do {
            try {
                this.mOpenCloseSemaphore.acquire();
                this.mCameraCacheInfosInProgress.add(cameraCacheInfo);
                this.mCameraManager.openCamera(cameraCacheInfo.deviceIDString, new CameraDevice.StateCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onOpened(CameraDevice cameraDevice) {
                        CameraCacheInfo cameraCacheInfo = null;
                        try {
                            for (CameraCacheInfo cameraCacheInfo2 : Camera2_Preview.this.mCameraCacheInfosInProgress) {
                                if (!cameraCacheInfo2.deviceIDString.equals(cameraDevice.getId())) continue;
                                cameraCacheInfo = cameraCacheInfo2;
                                cameraCacheInfo.device = cameraDevice;
                                cameraCacheInfo.builder = cameraDevice.createCaptureRequest(1);
                            }
                        }
                        catch (CameraAccessException cameraAccessException) {
                            cameraCacheInfo.builder = null;
                            cameraCacheInfo.device = null;
                        }
                        finally {
                            Camera2_Preview.this.mOpenCloseSemaphore.release();
                        }
                    }

                    public void onError(CameraDevice cameraDevice, int n) {
                        cameraDevice.close();
                        Camera2_Preview.this.mOpenCloseSemaphore.release();
                    }

                    public void onDisconnected(CameraDevice cameraDevice) {
                        cameraDevice.close();
                        Camera2_Preview.this.mOpenCloseSemaphore.release();
                    }
                }, cameraCacheInfo.handler);
                this.mOpenCloseSemaphore.acquire();
                this.mCameraCacheInfosInProgress.remove(cameraCacheInfo);
                this.mOpenCloseSemaphore.release();
                n4 = cameraCacheInfo.device != null && cameraCacheInfo.builder != null ? 1 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 != 0) continue;
            try {
                if (n8 <= 0) continue;
                Camera2_Preview camera2_Preview = this;
                synchronized (camera2_Preview) {
                    this.wait(250L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (n4 == 0 && n8-- > 0);
        if (cameraCacheInfo.device == null || cameraCacheInfo.builder == null) {
            SystemTools.setSystemErrorCode(6);
            this.cleanupHandlerThread(cameraCacheInfo);
            return -1;
        }
        boolean bl2 = nArray != null && nArray.length > 0 || nArray2 != null && nArray2.length > 0;
        boolean bl3 = bl = string != null && string.length() > 0;
        if (bl2 || bl) {
            boolean bl4;
            if (bl2) {
                if (nArray != null && nArray.length != 5) {
                    SystemTools.setSystemErrorCode(2);
                    this.cleanupHandlerThread(cameraCacheInfo);
                    return -1;
                }
                bl4 = this.setCameraCaptureParams(cameraCacheInfo, nArray, nArray2);
                if (!bl4) {
                    SystemTools.setSystemErrorCode(6);
                    this.cleanupHandlerThread(cameraCacheInfo);
                    return -1;
                }
            }
            if (bl && !(bl4 = this.setCustomCameraParams(cameraCacheInfo, string))) {
                SystemTools.setSystemErrorCode(2);
                this.cleanupHandlerThread(cameraCacheInfo);
                return -1;
            }
        }
        cameraCacheInfo.status = 0x10002002;
        if (n6 < 0) {
            this.mCameraCacheInfos.add(cameraCacheInfo);
            n6 = this.mCameraCacheInfos.size() - 1;
        }
        return n6;
    }

    public boolean close(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        this.mCameraCacheInfoIndexCache.remove(cameraCacheInfo.reader);
        boolean bl = false;
        try {
            if (cameraCacheInfo.session != null) {
                cameraCacheInfo.session.close();
            }
            if (cameraCacheInfo.device != null) {
                cameraCacheInfo.device.close();
            }
            if (cameraCacheInfo.reader != null) {
                cameraCacheInfo.reader.close();
            }
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        cameraCacheInfo.session = null;
        cameraCacheInfo.reader = null;
        cameraCacheInfo.images = null;
        cameraCacheInfo.status = 0x10002001;
        this.cleanupHandlerThread(cameraCacheInfo);
        System.gc();
        return bl;
    }

    public int[] getCameraCapabilities(int n) {
        Integer n2;
        int n3;
        Object object;
        boolean bl;
        StreamConfigurationMap streamConfigurationMap;
        if (!this.checkCameraManager()) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        if (cameraCacheInfo.caps != null) {
            return cameraCacheInfo.caps;
        }
        try {
            String string = this.mCameraManager.getCameraIdList()[cameraCacheInfo.deviceID];
            streamConfigurationMap = (StreamConfigurationMap)this.mCameraManager.getCameraCharacteristics(string).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        }
        catch (CameraAccessException cameraAccessException) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        Size[] sizeArray = streamConfigurationMap.getOutputSizes(35);
        List<Integer> list = this.getSupportedPreviewFrameRates(cameraCacheInfo.characteristics);
        int[] nArray = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        Arrays.sort(nArray);
        int[] nArray2 = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        Arrays.sort(nArray2);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(35);
        int n4 = sizeArray != null ? sizeArray.length : 0;
        int n5 = list != null ? list.size() : 0;
        int n6 = linkedList != null ? linkedList.size() : 0;
        float[] fArray = (float[])cameraCacheInfo.characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        boolean bl2 = bl = fArray != null && fArray.length > 0;
        if (bl) {
            object = fArray;
            int n7 = ((float[])object).length;
            for (n3 = 0; n3 < n7; n3 += 1) {
                float f = object[n3];
            }
        }
        if ((object = (Object)((Boolean)cameraCacheInfo.characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE))) == null) {
            object = false;
        }
        n3 = (n2 = (Integer)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF)) != null && n2 > 0 ? 1 : 0;
        Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        boolean bl3 = range != null && !EMPTY_RANGE.equals((Object)range);
        Range range2 = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE);
        boolean bl4 = range2 != null && !EMPTY_RANGE.equals((Object)range2);
        Range range3 = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
        boolean bl5 = range2 != null && !EMPTY_RANGE.equals((Object)range3);
        int[] nArray3 = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
        int[] nArray4 = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
        boolean bl6 = nArray3 != null && nArray3.length > 1 || nArray4 != null && nArray4.length > 1;
        int n8 = 6 + n4 * 2 + n5 + n6;
        cameraCacheInfo.caps = new int[n8];
        int n9 = 0;
        cameraCacheInfo.caps[n9] = 0x20000000;
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000001, (Boolean)object);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000002, nArray.length > 0);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000004, bl);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000010, n3 != 0);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000020, nArray2.length > 0);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000400, bl3);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000800, bl3);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000040, bl4);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000080, bl4);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000100, bl5);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000200, bl5);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20008000, bl);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20010000, bl);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x21000000, bl6);
        n9 = 1;
        cameraCacheInfo.caps[n9] = 0x20000000;
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000001, (Boolean)object);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000002, nArray.length > 0);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000010, n3 != 0);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000020, nArray2.length > 0);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000400, bl3);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000040, bl4);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20000100, bl5);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x20008000, bl);
        this.setCameraCapsBit(cameraCacheInfo, n9, 0x21000000, bl6);
        n9 = 2;
        cameraCacheInfo.caps[n9] = 0x30000000;
        if (((Boolean)object).booleanValue()) {
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000001, true);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000002, true);
        }
        if (nArray != null) {
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000010, Arrays.binarySearch(nArray, 1) != -1);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000020, Arrays.binarySearch(nArray, 1) != -1);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000040, Arrays.binarySearch(nArray, 3) != -1);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000080, Arrays.binarySearch(nArray, 2) != -1);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000100, Arrays.binarySearch(nArray, 0) != -1 && CaptureRequest.LENS_FOCUS_DISTANCE != null);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30000200, Arrays.binarySearch(nArray, 0) != -1);
        }
        if (nArray2 != null) {
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30001000, Arrays.binarySearch(nArray2, 0) != -1);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30008000, Arrays.binarySearch(nArray2, 0) != -1);
            this.setCameraCapsBit(cameraCacheInfo, n9, 0x30004000, Arrays.binarySearch(nArray2, 1) != -1);
        }
        cameraCacheInfo.caps[3] = n4;
        cameraCacheInfo.caps[4] = n5;
        cameraCacheInfo.caps[5] = n6;
        int n10 = 6;
        if (n4 > 0) {
            for (Size size : sizeArray) {
                cameraCacheInfo.caps[n10] = size.getWidth();
                cameraCacheInfo.caps[n10 + 1] = size.getHeight();
                n10 += 2;
            }
        }
        if (n5 > 0) {
            for (Integer n11 : list) {
                cameraCacheInfo.caps[n10] = n11;
                ++n10;
            }
        }
        if (n6 > 0) {
            for (Integer n12 : linkedList) {
                cameraCacheInfo.caps[n10] = cameraCacheInfo.requestFormatPL;
                ++n10;
            }
        }
        return cameraCacheInfo.caps;
    }

    public boolean setCaptureInfo(int n, int[] nArray, int[] nArray2) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (nArray.length != 5) {
            SystemTools.setSystemErrorCode(2);
            return false;
        }
        boolean bl = this.setCameraCaptureParams(cameraCacheInfo, nArray, nArray2);
        if (!bl) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        return true;
    }

    public int[] getCaptureInfo(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        int[] nArray = null;
        try {
            nArray = new int[5];
            if (cameraCacheInfo.reader != null) {
                nArray[0] = cameraCacheInfo.reader.getWidth();
                nArray[1] = cameraCacheInfo.reader.getHeight();
            } else {
                nArray[0] = cameraCacheInfo.requestWidth;
                nArray[1] = cameraCacheInfo.requestHeight;
            }
            nArray[2] = cameraCacheInfo.requestFormatPL;
            if (cameraCacheInfo.builder != null) {
                Range range = (Range)cameraCacheInfo.builder.get(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE);
                nArray[3] = (Integer)range.getUpper();
            } else {
                nArray[3] = cameraCacheInfo.requestFramerate;
            }
            nArray[4] = 1;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        return nArray;
    }

    public boolean start(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        if (!this.setupPreviewBuffer(cameraCacheInfo)) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
        try {
            if (cameraCacheInfo.session == null) {
                this.mOpenCloseSemaphore.acquire();
                cameraCacheInfo.device.createCaptureSession(cameraCacheInfo.surfaces, new CameraCaptureSession.StateCallback(){

                    public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                        CameraCacheInfo cameraCacheInfo = null;
                        for (CameraCacheInfo cameraCacheInfo2 : Camera2_Preview.this.mCameraCacheInfos) {
                            if (!cameraCacheInfo2.deviceIDString.equals(cameraCaptureSession.getDevice().getId())) continue;
                            cameraCacheInfo = cameraCacheInfo2;
                            break;
                        }
                        cameraCacheInfo.session = cameraCaptureSession;
                        for (Surface surface : cameraCacheInfo.surfaces) {
                            cameraCacheInfo.builder.addTarget(surface);
                        }
                        Camera2_Preview.this.mOpenCloseSemaphore.release();
                    }

                    public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                        cameraCaptureSession.close();
                        Camera2_Preview.this.mOpenCloseSemaphore.release();
                    }
                }, cameraCacheInfo.handler);
                this.mOpenCloseSemaphore.acquire();
                this.mOpenCloseSemaphore.release();
                if (cameraCacheInfo.session == null) {
                    SystemTools.setSystemErrorCode(6);
                    return false;
                }
            }
            cameraCacheInfo.session.setRepeatingRequest(cameraCacheInfo.builder.build(), (CameraCaptureSession.CaptureCallback)new OnFrameCapturedCallback(cameraCacheInfo), cameraCacheInfo.handler);
            cameraCacheInfo.status = 268443651;
            this.mCameraCacheInfoIndexCache.put(cameraCacheInfo.reader, n);
            return true;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    public boolean stop(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        try {
            cameraCacheInfo.session.abortCaptures();
            cameraCacheInfo.status = 0x10002002;
            return true;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return false;
        }
    }

    public boolean setBatchParameters(int n, String string) {
        if (string == null) {
            return false;
        }
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        return this.setCustomCameraParams(cameraCacheInfo, string);
    }

    boolean setUntypedCameraParameter(int n, String string, Object object) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null || string == null || object == null) {
            SystemTools.setSystemErrorCode(4);
            return false;
        }
        List list = cameraCacheInfo.characteristics.getAvailableCaptureRequestKeys();
        for (int i = 0; i < list.size(); ++i) {
            CaptureRequest.Key key = (CaptureRequest.Key)list.get(i);
            if (!key.getName().equals(string)) continue;
            Object object2 = cameraCacheInfo.builder.get(key);
            if (!(object2 instanceof Integer || object2 instanceof Float || object2 instanceof Boolean || object2 instanceof Byte || object2 instanceof Long)) {
                return false;
            }
            if (object2 instanceof Byte && object instanceof Long) {
                object = new Byte(((Long)object).byteValue());
            }
            if (object2 instanceof Integer && object instanceof Long) {
                object = new Integer(((Long)object).intValue());
            }
            if (!object2.getClass().equals(object.getClass())) {
                return false;
            }
            try {
                cameraCacheInfo.builder.set(key, object);
                if (cameraCacheInfo.session != null) {
                    cameraCacheInfo.session.setRepeatingRequest(cameraCacheInfo.builder.build(), (CameraCaptureSession.CaptureCallback)new OnFrameCapturedCallback(cameraCacheInfo), cameraCacheInfo.handler);
                }
                return true;
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
        }
        SystemTools.setSystemErrorCode(6);
        return false;
    }

    Object getUntypedCameraParameter(int n, String string) {
        Object object;
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null || string == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        Object object2 = null;
        List list = cameraCacheInfo.characteristics.getAvailableCaptureRequestKeys();
        for (int i = 0; i < list.size(); ++i) {
            CaptureRequest.Key key = (CaptureRequest.Key)list.get(i);
            if (!key.getName().equals(string)) continue;
            object2 = cameraCacheInfo.builder.get(key);
            break;
        }
        List list2 = cameraCacheInfo.characteristics.getKeys();
        for (int i = 0; i < list2.size(); ++i) {
            object = (CameraCharacteristics.Key)list2.get(i);
            if (!object.getName().equals(string)) continue;
            object2 = cameraCacheInfo.characteristics.get(object);
            break;
        }
        if (object2 == null) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        if (object2 instanceof Long || object2 instanceof Float || object2 instanceof Boolean || object2 instanceof String) {
            return object2;
        }
        if (object2 instanceof Integer) {
            return new Long(((Integer)object2).longValue());
        }
        if (object2 instanceof Byte) {
            return new Long(((Byte)object2).longValue());
        }
        if (object2 instanceof Range) {
            Comparable comparable = ((Range)object2).getLower();
            object = ((Range)object2).getUpper();
            if (comparable instanceof Integer) {
                long[] lArray = new long[]{((Integer)comparable).longValue(), ((Integer)object).longValue()};
                return lArray;
            }
            if (comparable instanceof Long) {
                long[] lArray = new long[]{(Long)comparable, (Long)object};
                return lArray;
            }
            SystemTools.setSystemErrorCode(6);
            return null;
        }
        SystemTools.setSystemErrorCode(6);
        return null;
    }

    int getUntypedCameraParameterType(int n, String string) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null || string == null) {
            SystemTools.setSystemErrorCode(4);
            return -1;
        }
        Object object = null;
        boolean bl = false;
        List list = cameraCacheInfo.characteristics.getAvailableCaptureRequestKeys();
        for (int i = 0; i < list.size(); ++i) {
            CaptureRequest.Key key = (CaptureRequest.Key)list.get(i);
            if (!key.getName().equals(string)) continue;
            object = cameraCacheInfo.builder.get(key);
            bl = true;
            break;
        }
        List list2 = cameraCacheInfo.characteristics.getKeys();
        for (int i = 0; i < list2.size(); ++i) {
            CameraCharacteristics.Key key = (CameraCharacteristics.Key)list2.get(i);
            if (!key.getName().equals(string)) continue;
            object = cameraCacheInfo.characteristics.get(key);
            bl = true;
            break;
        }
        if (!bl) {
            SystemTools.setSystemErrorCode(6);
            return -1;
        }
        if (object == null) {
            return -1;
        }
        if (object instanceof Integer) {
            return 1;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Long) {
            return 1;
        }
        if (object instanceof Float) {
            return 2;
        }
        if (object instanceof Boolean) {
            return 3;
        }
        if (object instanceof String) {
            return 0;
        }
        if (object instanceof Range) {
            Comparable comparable = ((Range)object).getLower();
            if (comparable instanceof Integer) {
                return 4;
            }
            if (comparable instanceof Long) {
                return 4;
            }
        }
        return -1;
    }

    int getNamedParameterCount(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null) {
            SystemTools.setSystemErrorCode(4);
            return -1;
        }
        List list = cameraCacheInfo.characteristics.getAvailableCaptureRequestKeys();
        List list2 = cameraCacheInfo.characteristics.getKeys();
        return list.size() + list2.size();
    }

    String getNamedParameter(int n, int n2) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        List list = cameraCacheInfo.characteristics.getAvailableCaptureRequestKeys();
        List list2 = cameraCacheInfo.characteristics.getKeys();
        if (n2 < list.size()) {
            CaptureRequest.Key key = (CaptureRequest.Key)list.get(n2);
            if (key == null) {
                return null;
            }
            return key.getName();
        }
        if (n2 - list.size() < list2.size()) {
            CameraCharacteristics.Key key = (CameraCharacteristics.Key)list2.get(n2 - list.size());
            if (key == null) {
                return null;
            }
            return key.getName();
        }
        SystemTools.setSystemErrorCode(6);
        return null;
    }

    boolean setTypedCameraParameter(int n, int n2, Object object) {
        boolean bl;
        CameraCacheInfo cameraCacheInfo;
        block99: {
            cameraCacheInfo = this.getCameraCacheInfo(n);
            if (cameraCacheInfo == null || cameraCacheInfo.builder == null || cameraCacheInfo.characteristics == null) {
                SystemTools.setSystemErrorCode(4);
                return false;
            }
            bl = false;
            try {
                block3 : switch (n2) {
                    case 0x20400000: {
                        if (CaptureRequest.CONTROL_CAPTURE_INTENT == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        int n3 = ((Number)object).intValue();
                        cameraCacheInfo.builder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, (Object)(n3 != 0 ? 3 : 1));
                        break;
                    }
                    case 0x20000001: {
                        if (CaptureRequest.FLASH_MODE == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        int n3 = ((Number)object).intValue();
                        switch (n3) {
                            case 0x30000002: {
                                cameraCacheInfo.builder.set(CaptureRequest.FLASH_MODE, (Object)2);
                                break block3;
                            }
                            case 0x30000001: {
                                cameraCacheInfo.builder.set(CaptureRequest.FLASH_MODE, (Object)0);
                                break block3;
                            }
                            case 0x30000004: {
                                SystemTools.setSystemErrorCode(3);
                                return false;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000002: {
                        if (CaptureRequest.CONTROL_AF_MODE == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        int[] nArray = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
                        Arrays.sort(nArray);
                        int n4 = ((Number)object).intValue();
                        switch (n4) {
                            case 0x30000010: 
                            case 0x30000020: {
                                if (Arrays.binarySearch(nArray, 1) == -1) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)1);
                                bl = true;
                                break block3;
                            }
                            case 0x30000040: {
                                if (Arrays.binarySearch(nArray, 3) == -1) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                                break block3;
                            }
                            case 0x30000080: {
                                if (Arrays.binarySearch(nArray, 2) == -1) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)2);
                                bl = true;
                                break block3;
                            }
                            case 0x30000100: {
                                if (CaptureRequest.LENS_FOCUS_DISTANCE == null) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                if (Arrays.binarySearch(nArray, 0) == -1) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                                cameraCacheInfo.builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)Float.valueOf(0.0f));
                                break block3;
                            }
                            case 0x30000200: {
                                if (Arrays.binarySearch(nArray, 0) == -1) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)0);
                                break block3;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000004: {
                        if (CaptureRequest.LENS_FOCUS_DISTANCE == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        Float f = Float.valueOf(((Number)object).floatValue());
                        cameraCacheInfo.builder.set(CaptureRequest.LENS_FOCUS_DISTANCE, (Object)f);
                        break;
                    }
                    case 0x20000008: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000010: {
                        float[] fArray = (float[])object;
                        if (fArray.length != 5) {
                            SystemTools.setSystemErrorCode(2);
                            return false;
                        }
                        if (fArray[0] < 0.0f || fArray[0] > 1.0f || fArray[1] < 0.0f || fArray[1] > 1.0f || fArray[2] < 0.0f || fArray[2] > 1.0f || fArray[3] < 0.0f || fArray[3] > 1.0f || fArray[4] < 0.0f || fArray[4] > 1.0f) {
                            SystemTools.setSystemErrorCode(2);
                            return false;
                        }
                        Integer n5 = (Integer)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
                        if (CaptureRequest.CONTROL_AF_REGIONS == null || n5 == null || n5 == 0) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        Rect rect = (Rect)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                        if (rect == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        MeteringRectangle[] meteringRectangleArray = new MeteringRectangle[]{new MeteringRectangle(new Rect(Math.min((int)(fArray[0] * (float)rect.width()), rect.width() - 1), Math.min((int)(fArray[1] * (float)rect.height()), rect.height() - 1), Math.min((int)(fArray[2] * (float)rect.width()), rect.width() - 1), Math.min((int)(fArray[3] * (float)rect.height()), rect.height() - 1)), (int)(fArray[4] * 1000.0f + 0.0f))};
                        cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)meteringRectangleArray);
                        bl = true;
                        break;
                    }
                    case 0x20000020: {
                        int n6;
                        int n7 = ((Number)object).intValue();
                        int[] nArray = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
                        if (nArray == null || CaptureRequest.CONTROL_AE_MODE == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        switch (n7) {
                            case 0x30001000: 
                            case 0x30008000: {
                                int n8;
                                int n9;
                                boolean bl2 = false;
                                int[] nArray2 = nArray;
                                n6 = nArray2.length;
                                for (n9 = 0; n9 < n6 && !(bl2 = (n8 = nArray2[n9]) == 0); ++n9) {
                                }
                                if (!bl2) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)0);
                                break block3;
                            }
                            case 0x30004000: {
                                int n10;
                                int n8;
                                boolean bl3 = false;
                                int[] nArray3 = nArray;
                                int n9 = nArray3.length;
                                for (n8 = 0; n8 < n9 && !(bl3 = (n10 = nArray3[n8]) == 1); ++n8) {
                                }
                                if (!bl3) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                                break block3;
                            }
                        }
                        SystemTools.setSystemErrorCode(3);
                        return false;
                    }
                    case 0x20000040: {
                        Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE);
                        if (range == null || CaptureRequest.SENSOR_SENSITIVITY == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        int n11 = ((Number)object).intValue();
                        if (range.contains((Comparable)Integer.valueOf(n11))) {
                            cameraCacheInfo.builder.set(CaptureRequest.SENSOR_SENSITIVITY, (Object)n11);
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000080: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000100: {
                        Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
                        if (range == null || CaptureRequest.SENSOR_EXPOSURE_TIME == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        Long l = Math.round((double)((Number)object).floatValue() * 1.0E9);
                        if (range.contains((Comparable)l)) {
                            cameraCacheInfo.builder.set(CaptureRequest.SENSOR_EXPOSURE_TIME, (Object)l);
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000200: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000400: {
                        float f = ((Number)object).floatValue();
                        Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
                        Rational rational = (Rational)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
                        if (EMPTY_RANGE.equals((Object)range) || CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION == null || rational == null || CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        int n12 = Math.round(f / rational.floatValue());
                        if (range.contains((Comparable)Integer.valueOf(n12))) {
                            cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)n12);
                            break;
                        }
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20000800: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20001000: {
                        int n13 = ((Number)object).intValue();
                        switch (n13) {
                            case 0x30100000: {
                                if (CaptureRequest.CONTROL_AWB_LOCK == null) {
                                    SystemTools.setSystemErrorCode(6);
                                    return false;
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)true);
                                break block3;
                            }
                            case 0x30400000: {
                                if (CaptureRequest.CONTROL_AWB_LOCK != null && ((Boolean)cameraCacheInfo.builder.get(CaptureRequest.CONTROL_AWB_LOCK)).booleanValue()) {
                                    cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AWB_LOCK, (Object)false);
                                }
                                if (CaptureRequest.CONTROL_AWB_MODE != null) {
                                    cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AWB_MODE, (Object)1);
                                    break block3;
                                }
                                break block99;
                            }
                            default: {
                                SystemTools.setSystemErrorCode(3);
                                return false;
                            }
                        }
                    }
                    case 0x20002000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20004000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20008000: {
                        int n14 = ((Number)object).intValue();
                        float[] fArray = (float[])cameraCacheInfo.characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
                        if (fArray == null || CaptureRequest.LENS_FOCAL_LENGTH == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        boolean bl4 = false;
                        for (float f : fArray) {
                            if (!(Math.abs(f - (float)n14) < 0.01f)) continue;
                            bl4 = true;
                            cameraCacheInfo.builder.set(CaptureRequest.LENS_FOCAL_LENGTH, (Object)Float.valueOf(f));
                            break;
                        }
                        if (!bl4) {
                            SystemTools.setSystemErrorCode(2);
                            return false;
                        }
                        break;
                    }
                    case 0x20010000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20020000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20040000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20080000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20100000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x20200000: {
                        SystemTools.setSystemErrorCode(6);
                        return false;
                    }
                    case 0x21000000: {
                        boolean bl5;
                        int[] nArray = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
                        boolean bl6 = nArray != null && nArray.length > 1 && CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE != null;
                        int[] nArray4 = (int[])cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
                        boolean bl7 = bl5 = nArray4 != null && nArray4.length > 1 && CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE != null;
                        if (!bl6 && !bl5) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        int n6 = ((Boolean)object).booleanValue() ? 1 : 0;
                        if (bl6) {
                            cameraCacheInfo.builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                        }
                        if (bl5) {
                            cameraCacheInfo.builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                        }
                        if (n6 != 0) {
                            if (bl6) {
                                cameraCacheInfo.builder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                                break;
                            }
                            if (bl5) {
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                            }
                        }
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
        }
        if (cameraCacheInfo.session != null) {
            try {
                cameraCacheInfo.session.setRepeatingRequest(cameraCacheInfo.builder.build(), (CameraCaptureSession.CaptureCallback)new OnFrameCapturedCallback(cameraCacheInfo), cameraCacheInfo.handler);
            }
            catch (CameraAccessException cameraAccessException) {
                SystemTools.setSystemErrorCode(6);
                return false;
            }
            if (bl) {
                try {
                    switch (n2) {
                        case 0x20000002: {
                            MeteringRectangle[] meteringRectangleArray;
                            Integer n15 = (Integer)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
                            if (n15 != null && CameraCharacteristics.CONTROL_MAX_REGIONS_AF != null && n15 > 0 && CaptureRequest.CONTROL_AF_REGIONS != null && (meteringRectangleArray = (MeteringRectangle[])cameraCacheInfo.builder.get(CaptureRequest.CONTROL_AF_REGIONS)) != null && meteringRectangleArray.length > 0) {
                                MeteringRectangle[] meteringRectangleArray2 = new MeteringRectangle[meteringRectangleArray.length];
                                int n16 = 0;
                                for (MeteringRectangle meteringRectangle : meteringRectangleArray) {
                                    meteringRectangleArray2[n16++] = new MeteringRectangle(meteringRectangle.getRect(), 0);
                                }
                                cameraCacheInfo.builder.set(CaptureRequest.CONTROL_AF_REGIONS, (Object)meteringRectangleArray2);
                            }
                        }
                        case 0x20000010: {
                            AutofocusRunner autofocusRunner = new AutofocusRunner(cameraCacheInfo);
                            if (!autofocusRunner.triggerAutofocus()) {
                                SystemTools.setSystemErrorCode(6);
                                return false;
                            }
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    SystemTools.setSystemErrorCode(6);
                    return false;
                }
            }
        }
        return true;
    }

    Object getTypedCameraParameter(int n, int n2) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null || cameraCacheInfo.characteristics == null) {
            SystemTools.setSystemErrorCode(4);
            return null;
        }
        CaptureResult captureResult = cameraCacheInfo.lastResult;
        try {
            switch (n2) {
                case 0x20000001: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Integer n3 = (Integer)captureResult.get(CaptureResult.FLASH_MODE);
                    if (n3 == null || CaptureResult.FLASH_MODE == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    if (n3.equals(2)) {
                        return 0x30000002;
                    }
                    if (n3.equals(0)) {
                        return 0x30000001;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000002: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Integer n4 = (Integer)captureResult.get(CaptureResult.CONTROL_AF_MODE);
                    if (n4 == null || CaptureResult.CONTROL_AF_MODE == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    if (n4.equals(1)) {
                        return cameraCacheInfo.isAutoFocusing ? 0x30000020 : 0x30000010;
                    }
                    if (n4.equals(3)) {
                        return 0x30000040;
                    }
                    if (n4.equals(0)) {
                        Float f = (Float)captureResult.get(CaptureResult.LENS_FOCUS_DISTANCE);
                        if (f == null || CaptureResult.LENS_FOCUS_DISTANCE == null || !f.equals(Float.valueOf(0.0f))) {
                            return 0x30000200;
                        }
                        return 0x30000100;
                    }
                    if (n4.equals(2)) {
                        return 0x30000080;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000004: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Float f = (Float)captureResult.get(CaptureResult.LENS_FOCAL_LENGTH);
                    if (f == null || CaptureResult.LENS_FOCAL_LENGTH == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    return f;
                }
                case 0x20000008: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Pair pair = (Pair)captureResult.get(CaptureResult.LENS_FOCUS_RANGE);
                    if (pair != null && CaptureResult.LENS_FOCUS_RANGE != null) {
                        float[] fArray = new float[]{((Float)pair.first).floatValue(), ((Float)pair.second).floatValue()};
                        return fArray;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000010: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Integer n5 = (Integer)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
                    if (n5 != null && CameraCharacteristics.CONTROL_MAX_REGIONS_AF != null && n5 > 0 && CaptureResult.CONTROL_AF_REGIONS != null) {
                        MeteringRectangle[] meteringRectangleArray = (MeteringRectangle[])captureResult.get(CaptureResult.CONTROL_AF_REGIONS);
                        if (meteringRectangleArray == null || meteringRectangleArray.length == 0) {
                            return null;
                        }
                        Rect rect = (Rect)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                        if (rect == null) {
                            SystemTools.setSystemErrorCode(6);
                            return false;
                        }
                        Rect rect2 = meteringRectangleArray[0].getRect();
                        float[] fArray = new float[]{rect2.left / (rect.width() - 1), rect2.top / (rect.height() - 1), rect2.right / (rect.width() - 1), rect2.bottom / (rect.height() - 1), (meteringRectangleArray[0].getMeteringWeight() - 0) / 1000};
                        return fArray;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000020: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Integer n6 = (Integer)captureResult.get(CaptureResult.CONTROL_AE_MODE);
                    if (n6 == null || CaptureResult.CONTROL_AE_MODE == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    if (n6.equals(0)) {
                        return 0x30008000;
                    }
                    if (n6.equals(1)) {
                        return 0x30004000;
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000040: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Integer n7 = (Integer)captureResult.get(CaptureResult.SENSOR_SENSITIVITY);
                    if (n7 != null && CaptureResult.SENSOR_SENSITIVITY != null) {
                        return Float.valueOf(n7.floatValue());
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000080: {
                    Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE);
                    if (range == null || CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    float[] fArray = new float[]{((Integer)range.getLower()).floatValue(), ((Integer)range.getUpper()).floatValue()};
                    return fArray;
                }
                case 0x20000100: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Long l = (Long)captureResult.get(CaptureResult.SENSOR_EXPOSURE_TIME);
                    if (l != null && CaptureResult.SENSOR_EXPOSURE_TIME != null) {
                        return Float.valueOf((float)(l.doubleValue() / 1.0E9));
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000200: {
                    Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE);
                    if (range == null || CameraCharacteristics.SENSOR_INFO_EXPOSURE_TIME_RANGE == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    float[] fArray = new float[]{(float)(((Long)range.getLower()).doubleValue() / 1.0E9), (float)(((Long)range.getUpper()).doubleValue() / 1.0E9)};
                    return fArray;
                }
                case 0x20000400: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Integer n8 = (Integer)captureResult.get(CaptureResult.CONTROL_AE_EXPOSURE_COMPENSATION);
                    Rational rational = (Rational)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
                    if (n8 != null && CaptureResult.CONTROL_AE_EXPOSURE_COMPENSATION != null && rational != null && CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP != null) {
                        return Float.valueOf(rational.floatValue() * (float)n8.intValue());
                    }
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20000800: {
                    Range range = (Range)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
                    Rational rational = (Rational)cameraCacheInfo.characteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
                    if (range == null || CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE == null || rational == null || CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    float[] fArray = new float[]{rational.floatValue() * (float)((Integer)range.getLower()).intValue(), rational.floatValue() * (float)((Integer)range.getUpper()).intValue()};
                    return fArray;
                }
                case 0x20001000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20002000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20004000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20008000: {
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    Float f = (Float)captureResult.get(CaptureResult.LENS_FOCAL_LENGTH);
                    if (f == null || CaptureResult.LENS_FOCAL_LENGTH == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    return f;
                }
                case 0x20010000: {
                    SystemTools.setSystemErrorCode(6);
                }
                case 0x20020000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20040000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20080000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20100000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x20200000: {
                    SystemTools.setSystemErrorCode(6);
                    return null;
                }
                case 0x21000000: {
                    Integer n9;
                    if (captureResult == null) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    boolean bl = false;
                    Integer n10 = (Integer)captureResult.get(CaptureResult.CONTROL_VIDEO_STABILIZATION_MODE);
                    if (n10 != null && CaptureResult.CONTROL_VIDEO_STABILIZATION_MODE != null) {
                        bl = true;
                        if (n10.equals(1)) {
                            return true;
                        }
                    }
                    if ((n9 = (Integer)captureResult.get(CaptureResult.LENS_OPTICAL_STABILIZATION_MODE)) != null && CaptureResult.LENS_OPTICAL_STABILIZATION_MODE != null) {
                        bl = true;
                        if (n9.equals(1)) {
                            return true;
                        }
                    }
                    if (!bl) {
                        SystemTools.setSystemErrorCode(6);
                        return null;
                    }
                    return false;
                }
            }
            return null;
        }
        catch (Exception exception) {
            SystemTools.setSystemErrorCode(6);
            return null;
        }
    }

    int getStatus(int n) {
        CameraCacheInfo cameraCacheInfo = this.getCameraCacheInfo(n);
        if (cameraCacheInfo == null) {
            SystemTools.setSystemErrorCode(4);
            return 0x10002000;
        }
        return cameraCacheInfo.status;
    }

    private class AutofocusRunner
    extends CameraCaptureSession.CaptureCallback {
        private CameraCacheInfo mCCI;
        private CaptureRequest mCancelRequest;
        private CaptureRequest mFocusRequest;

        public AutofocusRunner(CameraCacheInfo cameraCacheInfo) {
            this.mCCI = cameraCacheInfo;
            this.mCancelRequest = null;
            this.mFocusRequest = null;
        }

        public boolean triggerAutofocus() throws CameraAccessException {
            if (this.mCCI == null || this.mCCI.builder == null || this.mCCI.session == null) {
                return false;
            }
            Integer n = (Integer)this.mCCI.builder.get(CaptureRequest.CONTROL_AF_MODE);
            if (CaptureRequest.CONTROL_AF_MODE == null || n == null) {
                return false;
            }
            if (n != 1 && n != 2) {
                return false;
            }
            this.mCCI.isAutoFocusing = true;
            this.mCCI.builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.mCancelRequest = this.mCCI.builder.build();
            this.mCCI.builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            this.mCCI.builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
            this.mFocusRequest = this.mCCI.builder.build();
            this.mCCI.builder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)0);
            this.mCCI.session.capture(this.mCancelRequest, (CameraCaptureSession.CaptureCallback)this, this.mCCI.handler);
            return true;
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            super.onCaptureCompleted(cameraCaptureSession, captureRequest, totalCaptureResult);
            Integer n = (Integer)totalCaptureResult.get(CaptureResult.CONTROL_AF_STATE);
            if (captureRequest.equals((Object)this.mCancelRequest) && n == 0) {
                try {
                    cameraCaptureSession.capture(this.mFocusRequest, (CameraCaptureSession.CaptureCallback)this, this.mCCI.handler);
                }
                catch (CameraAccessException cameraAccessException) {}
            } else if (captureRequest.equals((Object)this.mFocusRequest) && (n == 4 || n == 5)) {
                this.mCCI.isAutoFocusing = false;
            }
        }
    }

    private class OnFrameCapturedCallback
    extends CameraCaptureSession.CaptureCallback {
        CameraCacheInfo mCCI;

        public OnFrameCapturedCallback(CameraCacheInfo cameraCacheInfo) {
            this.mCCI = cameraCacheInfo;
        }

        public void onCaptureCompleted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, TotalCaptureResult totalCaptureResult) {
            if (this.mCCI != null) {
                this.mCCI.lastResult = totalCaptureResult;
            }
        }
    }

    private class OnCameraDataAvailable
    implements ImageReader.OnImageAvailableListener {
        private int actualCaptureFormat = 0x10001100;
        private int[] actualBufferSize = null;

        private OnCameraDataAvailable() {
        }

        public void onImageAvailable(ImageReader imageReader) {
            Trace.beginSection((String)"onImageAvailable (java)");
            Integer n = (Integer)Camera2_Preview.this.mCameraCacheInfoIndexCache.get(imageReader);
            if (n == null) {
                DebugLog.LOGE(Camera2_Preview.MODULENAME, "Unable to find reader in the index cache!");
                Trace.endSection();
                return;
            }
            CameraCacheInfo cameraCacheInfo = (CameraCacheInfo)Camera2_Preview.this.mCameraCacheInfos.get(n);
            if (cameraCacheInfo == null) {
                DebugLog.LOGE(Camera2_Preview.MODULENAME, "Unable to find CCI in list!");
                Trace.endSection();
                return;
            }
            if (!cameraCacheInfo.imageSemaphore.tryAcquire()) {
                DebugLog.LOGE(Camera2_Preview.MODULENAME, "Unable to aquire image semaphore, need to free some buffers!!");
                Trace.endSection();
                return;
            }
            Image image = null;
            if (imageReader.getMaxImages() > 0 && (image = imageReader.acquireLatestImage()) != null) {
                FrameInfo frameInfo = new FrameInfo();
                frameInfo.timestamp = image.getTimestamp();
                CaptureResult captureResult = cameraCacheInfo.lastResult;
                if (captureResult != null) {
                    Integer n2;
                    Long l = (Long)captureResult.get(CaptureResult.SENSOR_EXPOSURE_TIME);
                    if (l != null) {
                        frameInfo.exposureTime = l;
                        frameInfo.timestamp += l.longValue();
                    }
                    if ((n2 = (Integer)captureResult.get(CaptureResult.SENSOR_SENSITIVITY)) != null) {
                        frameInfo.iso = n2;
                    }
                }
                if (this.actualCaptureFormat == 0x10001100) {
                    this.actualCaptureFormat = this.getImageFormat(image);
                }
                Camera2_Preview.this.newFrameAvailable(cameraCacheInfo.deviceHandle, n, cameraCacheInfo.bufferWidth, cameraCacheInfo.bufferHeight, this.actualBufferSize, this.actualCaptureFormat, image.getPlanes()[0].getBuffer(), frameInfo);
                image.close();
            }
            cameraCacheInfo.imageSemaphore.release();
            Trace.endSection();
        }

        private int getImageFormat(Image image) {
            if (image == null || image.getPlanes().length != 3 || image.getFormat() != 35) {
                return 0x10001100;
            }
            Image.Plane plane = image.getPlanes()[0];
            Image.Plane plane2 = image.getPlanes()[1];
            Image.Plane plane3 = image.getPlanes()[2];
            if (plane.getPixelStride() != 1) {
                return 0x10001100;
            }
            if (plane2.getPixelStride() != plane3.getPixelStride() || plane2.getRowStride() != plane3.getRowStride()) {
                return 0x10001100;
            }
            long[] lArray = new long[]{Camera2_Preview.this.getBufferAddress(plane.getBuffer()), Camera2_Preview.this.getBufferAddress(plane2.getBuffer()), Camera2_Preview.this.getBufferAddress(plane3.getBuffer())};
            if (lArray[0] == 0L || lArray[1] == 0L || lArray[2] == 0L) {
                return 0x10001100;
            }
            if (plane2.getPixelStride() == 2) {
                if (lArray[1] + 1L == lArray[2]) {
                    this.actualBufferSize = this.calculateActualBufferSize(lArray[0], lArray[1], lArray[2], plane.getRowStride(), plane2.getRowStride(), image.getWidth(), image.getHeight(), 0x10001107);
                    return 0x10001107;
                }
                if (lArray[2] + 1L == lArray[1]) {
                    this.actualBufferSize = this.calculateActualBufferSize(lArray[0], lArray[2], lArray[1], plane.getRowStride(), plane2.getRowStride(), image.getWidth(), image.getHeight(), 0x10001109);
                    return 0x10001109;
                }
            }
            if (plane2.getPixelStride() == 1) {
                if (lArray[1] < lArray[2]) {
                    this.actualBufferSize = this.calculateActualBufferSize(lArray[0], lArray[1], lArray[2], plane.getRowStride(), plane2.getRowStride(), image.getWidth(), image.getHeight(), 0x1000110A);
                    return 0x1000110A;
                }
                this.actualBufferSize = this.calculateActualBufferSize(lArray[0], lArray[2], lArray[1], plane.getRowStride(), plane2.getRowStride(), image.getWidth(), image.getHeight(), 0x10001114);
                return 0x10001114;
            }
            DebugLog.LOGE(Camera2_Preview.MODULENAME, "Unable to detect a supported image format, Unknown Image Format");
            return 0x10001100;
        }

        private int[] calculateActualBufferSize(long l, long l2, long l3, int n, int n2, int n3, int n4, int n5) {
            int[] nArray = null;
            boolean bl = false;
            if ((n5 == 0x10001107 || n5 == 0x10001109) && l + (long)(n4 * n3) != l2) {
                bl = true;
            } else if (!(n5 != 0x1000110A && n5 != 0x10001114 || l + (long)(n4 * n3) == l2 && l2 + (long)(n4 / 2 * (n3 / 2)) == l3)) {
                bl = true;
            }
            if (bl) {
                nArray = new int[4];
                nArray[0] = n;
                nArray[1] = (int)((l2 - l) / (long)n);
                nArray[2] = n2;
                if (n5 == 0x10001107 || n5 == 0x10001109) {
                    nArray[3] = n4 / 2;
                } else if (n5 == 0x1000110A || n5 == 0x10001114) {
                    nArray[3] = (int)((l3 - l2) / (long)n2);
                }
            }
            return nArray;
        }
    }

    public class FrameInfo {
        long timestamp;
        long exposureTime;
        int iso;
    }

    public class CameraCacheInfo {
        int deviceID;
        long deviceHandle;
        String deviceIDString;
        CameraCharacteristics characteristics;
        CameraDevice device;
        CameraCaptureSession session;
        CaptureRequest.Builder builder;
        CaptureResult lastResult;
        List<Surface> surfaces;
        ImageReader reader;
        Image[] images;
        Semaphore imageSemaphore;
        Handler handler;
        HandlerThread thread;
        int bufferWidth;
        int bufferHeight;
        int bufferFormatPL;
        int requestWidth;
        int requestHeight;
        int requestFormatPL;
        int requestFormatAndroid;
        int requestFramerate;
        int overrideWidth;
        int overrideHeight;
        int overrideFormatPL;
        int overrideFormatAndroid;
        int[] caps;
        int status;
        boolean isAutoFocusing;
    }
}

