/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo.
// source: k8s.io/kops/protokube/pkg/gossip/mesh/mesh.proto
// DO NOT EDIT!

/*
	Package mesh is a generated protocol buffer package.

	It is generated from these files:
		k8s.io/kops/protokube/pkg/gossip/mesh/mesh.proto

	It has these top-level messages:
		KVState
		KVStateRecord
*/
package mesh

import (
	errors "errors"
	fmt "fmt"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"

	_ "github.com/gogo/protobuf/gogoproto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	proto "github.com/golang/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

type KVState struct {
	Records map[string]*KVStateRecord `protobuf:"bytes,1,rep,name=records" json:"records,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *KVState) Reset()                    { *m = KVState{} }
func (*KVState) ProtoMessage()               {}
func (*KVState) Descriptor() ([]byte, []int) { return fileDescriptorMesh, []int{0} }

func (m *KVState) GetRecords() map[string]*KVStateRecord {
	if m != nil {
		return m.Records
	}
	return nil
}

type KVStateRecord struct {
	Data      []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Tombstone bool   `protobuf:"varint,2,opt,name=tombstone,proto3" json:"tombstone,omitempty"`
	Version   uint64 `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *KVStateRecord) Reset()                    { *m = KVStateRecord{} }
func (*KVStateRecord) ProtoMessage()               {}
func (*KVStateRecord) Descriptor() ([]byte, []int) { return fileDescriptorMesh, []int{1} }

func init() {
	proto.RegisterType((*KVState)(nil), "mesh.KVState")
	proto.RegisterType((*KVStateRecord)(nil), "mesh.KVStateRecord")
}
func (m *KVState) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *KVState) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Records) > 0 {
		for k := range m.Records {
			data[i] = 0xa
			i++
			v := m.Records[k]
			if v == nil {
				return 0, errors.New("proto: map has nil element")
			}
			msgSize := v.Size()
			mapSize := 1 + len(k) + sovMesh(uint64(len(k))) + 1 + msgSize + sovMesh(uint64(msgSize))
			i = encodeVarintMesh(data, i, uint64(mapSize))
			data[i] = 0xa
			i++
			i = encodeVarintMesh(data, i, uint64(len(k)))
			i += copy(data[i:], k)
			data[i] = 0x12
			i++
			i = encodeVarintMesh(data, i, uint64(v.Size()))
			n1, err := v.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n1
		}
	}
	return i, nil
}

func (m *KVStateRecord) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *KVStateRecord) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintMesh(data, i, uint64(len(m.Data)))
		i += copy(data[i:], m.Data)
	}
	if m.Tombstone {
		data[i] = 0x10
		i++
		if m.Tombstone {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Version != 0 {
		data[i] = 0x18
		i++
		i = encodeVarintMesh(data, i, uint64(m.Version))
	}
	return i, nil
}

func encodeFixed64Mesh(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Mesh(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMesh(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func (m *KVState) Size() (n int) {
	var l int
	_ = l
	if len(m.Records) > 0 {
		for k, v := range m.Records {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
			}
			mapEntrySize := 1 + len(k) + sovMesh(uint64(len(k))) + 1 + l + sovMesh(uint64(l))
			n += mapEntrySize + 1 + sovMesh(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *KVStateRecord) Size() (n int) {
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovMesh(uint64(l))
	}
	if m.Tombstone {
		n += 2
	}
	if m.Version != 0 {
		n += 1 + sovMesh(uint64(m.Version))
	}
	return n
}

func sovMesh(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMesh(x uint64) (n int) {
	return sovMesh(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *KVState) String() string {
	if this == nil {
		return "nil"
	}
	keysForRecords := make([]string, 0, len(this.Records))
	for k := range this.Records {
		keysForRecords = append(keysForRecords, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRecords)
	mapStringForRecords := "map[string]*KVStateRecord{"
	for _, k := range keysForRecords {
		mapStringForRecords += fmt.Sprintf("%v: %v,", k, this.Records[k])
	}
	mapStringForRecords += "}"
	s := strings.Join([]string{`&KVState{`,
		`Records:` + mapStringForRecords + `,`,
		`}`,
	}, "")
	return s
}
func (this *KVStateRecord) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&KVStateRecord{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Tombstone:` + fmt.Sprintf("%v", this.Tombstone) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMesh(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *KVState) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesh
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KVState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KVState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Records", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesh
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthMesh
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(data[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			var valuekey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				valuekey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var mapmsglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				mapmsglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if mapmsglen < 0 {
				return ErrInvalidLengthMesh
			}
			postmsgIndex := iNdEx + mapmsglen
			if mapmsglen < 0 {
				return ErrInvalidLengthMesh
			}
			if postmsgIndex > l {
				return io.ErrUnexpectedEOF
			}
			mapvalue := &KVStateRecord{}
			if err := mapvalue.Unmarshal(data[iNdEx:postmsgIndex]); err != nil {
				return err
			}
			iNdEx = postmsgIndex
			if m.Records == nil {
				m.Records = make(map[string]*KVStateRecord)
			}
			m.Records[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesh(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesh
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KVStateRecord) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesh
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KVStateRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KVStateRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMesh
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], data[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tombstone", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tombstone = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Version |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMesh(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesh
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMesh(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMesh
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMesh
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMesh
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMesh(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMesh = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMesh   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorMesh = []byte{
	// 294 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x54, 0x90, 0xb1, 0x4e, 0xf3, 0x30,
	0x14, 0x85, 0x7b, 0xdb, 0xfc, 0x7f, 0xa8, 0x5b, 0x24, 0x64, 0x96, 0x28, 0x42, 0x56, 0xd4, 0x29,
	0x0c, 0xc4, 0xa8, 0x30, 0x54, 0x8c, 0x48, 0x4c, 0x0c, 0x48, 0x46, 0x62, 0x61, 0x4a, 0x5a, 0x93,
	0x46, 0x21, 0xb9, 0x51, 0xec, 0x54, 0xea, 0xc6, 0x23, 0x74, 0xe4, 0x91, 0x3a, 0x32, 0x32, 0xd2,
	0xf4, 0x45, 0x50, 0x6d, 0x2a, 0xe8, 0x62, 0x9d, 0xe3, 0xef, 0x9c, 0x33, 0x5c, 0x72, 0x99, 0x4f,
	0x54, 0x94, 0x21, 0xcf, 0xb1, 0x52, 0xbc, 0xaa, 0x51, 0x63, 0xde, 0x24, 0x92, 0x57, 0x79, 0xca,
	0x53, 0x54, 0x2a, 0xab, 0x78, 0x21, 0xd5, 0xdc, 0x3c, 0x91, 0xc1, 0xd4, 0xd9, 0x69, 0xff, 0x22,
	0xcd, 0xf4, 0xbc, 0x49, 0xa2, 0x29, 0x16, 0x3c, 0xc5, 0x14, 0x6d, 0x37, 0x69, 0x5e, 0x8c, 0x33,
	0xc6, 0x28, 0x5b, 0x1a, 0xad, 0x80, 0xb8, 0xf7, 0x4f, 0x8f, 0x3a, 0xd6, 0x92, 0x5e, 0x13, 0xb7,
	0x96, 0x53, 0xac, 0x67, 0xca, 0x83, 0xa0, 0x17, 0x0e, 0xc6, 0x7e, 0x64, 0xe6, 0x7f, 0x78, 0x24,
	0x2c, 0xbc, 0x2b, 0x75, 0xbd, 0x14, 0xfb, 0xa8, 0xff, 0x40, 0x86, 0x7f, 0x01, 0x3d, 0x21, 0xbd,
	0x5c, 0x2e, 0x3d, 0x08, 0x20, 0xec, 0x8b, 0x9d, 0xa4, 0xe7, 0xe4, 0xdf, 0x22, 0x7e, 0x6d, 0xa4,
	0xd7, 0x0d, 0x20, 0x1c, 0x8c, 0x4f, 0x0f, 0x56, 0x6d, 0x57, 0xd8, 0xc4, 0x4d, 0x77, 0x02, 0xa3,
	0x67, 0x72, 0x7c, 0xc0, 0x28, 0x25, 0xce, 0x2c, 0xd6, 0xb1, 0x99, 0x1c, 0x0a, 0xa3, 0xe9, 0x19,
	0xe9, 0x6b, 0x2c, 0x12, 0xa5, 0xb1, 0xb4, 0xbb, 0x47, 0xe2, 0xf7, 0x83, 0x7a, 0xc4, 0x5d, 0xc8,
	0x5a, 0x65, 0x58, 0x7a, 0xbd, 0x00, 0x42, 0x47, 0xec, 0xed, 0x6d, 0xb0, 0xde, 0x30, 0xf8, 0xdc,
	0xb0, 0xce, 0x5b, 0xcb, 0x60, 0xdd, 0x32, 0xf8, 0x68, 0x19, 0x7c, 0xb5, 0x0c, 0x56, 0x5b, 0xd6,
	0x79, 0xdf, 0xb2, 0x4e, 0xf2, 0xdf, 0x1c, 0xe6, 0xea, 0x3b, 0x00, 0x00, 0xff, 0xff, 0x27, 0xd6,
	0x38, 0xdb, 0x81, 0x01, 0x00, 0x00,
}
