## Release notes for kops 1.9 series

# Significant changes

* RBAC is now the default authorization mode for new clusters.  Existing clusters will not be changed.  Pass `--authorization=AlwaysAllow` to `kops create cluster` for the legacy authorization behaviour.

* Federation support has been removed from kops, reflecting the removal of federation upstream and refocusing on multicluster efforts.

# Required Actions

None known at this time

# Highlighted changes

(to follow)

# Full change list

## From kops 1.8.1 to 1.9.0

* Add list of PRs for 1.8.0 release [@justinsb](https://github.com/justinsb) [#3995](https://github.com/kubernetes/kops/pull/3995)
* Promote alpha channel to stable [@justinsb](https://github.com/justinsb) [#3996](https://github.com/kubernetes/kops/pull/3996)
* Release notes for 1.8.0 [@justinsb](https://github.com/justinsb) [#3999](https://github.com/kubernetes/kops/pull/3999)
* Put stable channel back to jessie for 1.9 / 1.10 [@justinsb](https://github.com/justinsb) [#4002](https://github.com/kubernetes/kops/pull/4002)
* Add missing permissions for NLB creation [@aledbf](https://github.com/aledbf) [#3976](https://github.com/kubernetes/kops/pull/3976)
* Fix filepath concatenation [@justinsb](https://github.com/justinsb) [#3973](https://github.com/kubernetes/kops/pull/3973)
* toolbox dump now dumps instances in alphabetical order [@justinsb](https://github.com/justinsb) [#3978](https://github.com/kubernetes/kops/pull/3978)
* SSH keys - be lazier about keystore creation [@justinsb](https://github.com/justinsb) [#3933](https://github.com/kubernetes/kops/pull/3933)
* Update aws-sdk-go to v1.10.34 [@rdrgmnzs](https://github.com/rdrgmnzs) [#3885](https://github.com/kubernetes/kops/pull/3885)
* Update bazel / gazelle [@justinsb](https://github.com/justinsb) [#4000](https://github.com/kubernetes/kops/pull/4000)
* When using private DNS add ELB name to the api certificate [@vainu-arto](https://github.com/vainu-arto) [#3941](https://github.com/kubernetes/kops/pull/3941)
* Fixed minor typo in 1.8-NOTES.md file [@sellers](https://github.com/sellers) [#4013](https://github.com/kubernetes/kops/pull/4013)
* Minor update to docs/getting_started/aws.md [@ysim](https://github.com/ysim) [#4008](https://github.com/kubernetes/kops/pull/4008)
* Fix libcgroup dependency typo [@wannabesrevenge](https://github.com/wannabesrevenge) [#4030](https://github.com/kubernetes/kops/pull/4030)
* Spelling fix in instancegroups.go error msg [@sneako](https://github.com/sneako) [#4024](https://github.com/kubernetes/kops/pull/4024)
* Include roles in toolbox dump structured output [@justinsb](https://github.com/justinsb) [#3934](https://github.com/kubernetes/kops/pull/3934)
* Fix URL for Docker 17.03.2 on Debian Stretch [@blakebarnett](https://github.com/blakebarnett) [#4014](https://github.com/kubernetes/kops/pull/4014)
* Fix spurious shared InternetGateway renaming [@rifelpet](https://github.com/rifelpet) [#4020](https://github.com/kubernetes/kops/pull/4020)
* Documentation fix for watchIngress flag in externalDns ClusterSpec [@krogon-dp](https://github.com/krogon-dp) [#4048](https://github.com/kubernetes/kops/pull/4048)
* Bastion output line [@gambol99](https://github.com/gambol99) [#4053](https://github.com/kubernetes/kops/pull/4053)
* Downgrade Flannel in Canal deployment to v0.9.0 [@KashifSaadat](https://github.com/KashifSaadat) [#4047](https://github.com/kubernetes/kops/pull/4047)
* Let a user set a hostnameOverride when the cloud provider is aws. [@rdrgmnzs](https://github.com/rdrgmnzs) [#3809](https://github.com/kubernetes/kops/pull/3809)
* Add additionalNetworkCIDRs to support VPCs with multiple CIDRs in AWS [@rdrgmnzs](https://github.com/rdrgmnzs) [#3898](https://github.com/kubernetes/kops/pull/3898)
* updating goimports [@chrislovecnm](https://github.com/chrislovecnm) [#3947](https://github.com/kubernetes/kops/pull/3947)
* implement security group task [@zengchen1024](https://github.com/zengchen1024) [#4016](https://github.com/kubernetes/kops/pull/4016)
* Implement security group rule task [@zengchen1024](https://github.com/zengchen1024) [#4017](https://github.com/kubernetes/kops/pull/4017)
* Update Weave Net to version 2.1.3 [@bboreham](https://github.com/bboreham) [#3944](https://github.com/kubernetes/kops/pull/3944)
* Fix Flannel nonMasqueradeCIDR [@mikesplain](https://github.com/mikesplain) [#3952](https://github.com/kubernetes/kops/pull/3952)
* Remove world read permissions on sensitive key files. [@KashifSaadat](https://github.com/KashifSaadat) [#4022](https://github.com/kubernetes/kops/pull/4022)
* Update gazelle [@justinsb](https://github.com/justinsb) [#4065](https://github.com/kubernetes/kops/pull/4065)
* Allow additional SGs to be added to API loadbalancer [@almariah](https://github.com/almariah) [#4036](https://github.com/kubernetes/kops/pull/4036)
* [Add-on][kube-state-metrics] Bump version [@tuannvm](https://github.com/tuannvm) [#4045](https://github.com/kubernetes/kops/pull/4045)
* add kube-ingress-aws-controller + skipper addons [@szuecs](https://github.com/szuecs) [#3983](https://github.com/kubernetes/kops/pull/3983)
* Bump flannel packaging version [@justinsb](https://github.com/justinsb) [#4064](https://github.com/kubernetes/kops/pull/4064)
* Bump weave version in bootstrapchannelbuilder [@bboreham](https://github.com/bboreham),[@justinsb](https://github.com/justinsb) [#4062](https://github.com/kubernetes/kops/pull/4062)
* Adding DescribeTags to masters [@robinpercy](https://github.com/robinpercy) [#4051](https://github.com/kubernetes/kops/pull/4051)
* Fix node counts [@ihoegen](https://github.com/ihoegen) [#4026](https://github.com/kubernetes/kops/pull/4026)
* Fix minor typo [@kintoandar](https://github.com/kintoandar) [#4070](https://github.com/kubernetes/kops/pull/4070)
* Gazelle updates [@chrislovecnm](https://github.com/chrislovecnm) [#4067](https://github.com/kubernetes/kops/pull/4067)
* apt-get: specify unattended installation [@justinsb](https://github.com/justinsb) [#4082](https://github.com/kubernetes/kops/pull/4082)
* files task: fix potential nil pointer error [@justinsb](https://github.com/justinsb) [#4081](https://github.com/kubernetes/kops/pull/4081)
* protokube: fix logging / logic around cluster-id [@justinsb](https://github.com/justinsb) [#4080](https://github.com/kubernetes/kops/pull/4080)
* protokube: better discovery of local address [@justinsb](https://github.com/justinsb) [#4078](https://github.com/kubernetes/kops/pull/4078)
* Refactor protokube hosts file into its own package [@justinsb](https://github.com/justinsb) [#4076](https://github.com/kubernetes/kops/pull/4076)
* assetstore: extract tar files to a temp directory [@justinsb](https://github.com/justinsb) [#4075](https://github.com/kubernetes/kops/pull/4075)
* Support for hostPort when using canal [@rajivm](https://github.com/rajivm) [#4063](https://github.com/kubernetes/kops/pull/4063)
* validation: don't require subnet CIDRs on baremetal [@justinsb](https://github.com/justinsb) [#4079](https://github.com/kubernetes/kops/pull/4079)
* Use default subnet when creating IG [@justinsb](https://github.com/justinsb) [#3987](https://github.com/kubernetes/kops/pull/3987)
* Return apierrors NotFound when object not found [@justinsb](https://github.com/justinsb) [#3981](https://github.com/kubernetes/kops/pull/3981)
* Copy dnsprovider into our code, implement route53 batching [@justinsb](https://github.com/justinsb) [#3860](https://github.com/kubernetes/kops/pull/3860)
* Remove nodeup templating [@justinsb](https://github.com/justinsb) [#3924](https://github.com/kubernetes/kops/pull/3924)
* nodeup: create kubeconfig under admin or root [@justinsb](https://github.com/justinsb) [#4077](https://github.com/kubernetes/kops/pull/4077)
* add imagePullProgressDeadline to kubelet config [@izakp](https://github.com/izakp) [#4046](https://github.com/kubernetes/kops/pull/4046)
* Refactor: separate out SSHCredentials from Keyset stores [@justinsb](https://github.com/justinsb) [#3832](https://github.com/kubernetes/kops/pull/3832)
* Adds permissions for ELB and NLB req'd by 1.9 [@geojaz](https://github.com/geojaz) [#4095](https://github.com/kubernetes/kops/pull/4095)
* work on using files assets [@chrislovecnm](https://github.com/chrislovecnm) [#3254](https://github.com/kubernetes/kops/pull/3254)
* fixing bazel [@chrislovecnm](https://github.com/chrislovecnm) [#4098](https://github.com/kubernetes/kops/pull/4098)
* Add support for Amazon VPC CNI plugin [@aledbf](https://github.com/aledbf) [#3997](https://github.com/kubernetes/kops/pull/3997)
* Support for OIDC 'username-prefix' and 'groups-prefix' flags [@xoen](https://github.com/xoen) [#4085](https://github.com/kubernetes/kops/pull/4085)
* make it go to f [@rcuza](https://github.com/rcuza) [#4102](https://github.com/kubernetes/kops/pull/4102)
* Add Dashboard v1.8.1 [@maciaszczykm](https://github.com/maciaszczykm) [#4101](https://github.com/kubernetes/kops/pull/4101)
* fixing goimports formatting [@chrislovecnm](https://github.com/chrislovecnm) [#4096](https://github.com/kubernetes/kops/pull/4096)
* Refactor CAStore to use API types [@justinsb](https://github.com/justinsb) [#3833](https://github.com/kubernetes/kops/pull/3833)
* Fix code comment on PhaseSecurity [@justinsb](https://github.com/justinsb) [#4106](https://github.com/kubernetes/kops/pull/4106)
* Add --subnets and --utility-subnets to kops create cluster [@meringu](https://github.com/meringu) [#4061](https://github.com/kubernetes/kops/pull/4061)
* Update ottoyiu/k8s-ec2-srcdst docker image [@aledbf](https://github.com/aledbf) [#4109](https://github.com/kubernetes/kops/pull/4109)
* Refactor: clean up SecretStore to not use KeystoreItem [@justinsb](https://github.com/justinsb) [#3834](https://github.com/kubernetes/kops/pull/3834)
* Avoid ListSecrets call in nodeup [@justinsb](https://github.com/justinsb) [#3835](https://github.com/kubernetes/kops/pull/3835)
* Remove use of deprecated create-if-missing functions [@justinsb](https://github.com/justinsb) [#3836](https://github.com/kubernetes/kops/pull/3836)
* updating bazel files [@chrislovecnm](https://github.com/chrislovecnm) [#4117](https://github.com/kubernetes/kops/pull/4117)
* added instance types for f1 family [@peterwhitesell](https://github.com/peterwhitesell) [#4116](https://github.com/kubernetes/kops/pull/4116)
* Update code-of-conduct.md [@spiffxp](https://github.com/spiffxp) [#4122](https://github.com/kubernetes/kops/pull/4122)
* Refactor VFS CA store to reuse keyset from clientset [@justinsb](https://github.com/justinsb) [#3837](https://github.com/kubernetes/kops/pull/3837)
* Add audit log format flag for api server [@audip](https://github.com/audip) [#4060](https://github.com/kubernetes/kops/pull/4060)
* Use bundles when loading keysets [@justinsb](https://github.com/justinsb) [#3838](https://github.com/kubernetes/kops/pull/3838)
* Fix null pointer issues when custom PROTOKUBE_IMAGE is specified. [@KashifSaadat](https://github.com/KashifSaadat) [#4120](https://github.com/kubernetes/kops/pull/4120)
* Fix documentation of shared resource tags in kops > 1.8 [@tsupertramp](https://github.com/tsupertramp) [#4126](https://github.com/kubernetes/kops/pull/4126)
* Force nodeup to use the bundle [@justinsb](https://github.com/justinsb) [#3839](https://github.com/kubernetes/kops/pull/3839)
* Remove labels.yaml [@spiffxp](https://github.com/spiffxp) [#4136](https://github.com/kubernetes/kops/pull/4136)
* Added a clarification/warning note about exporting full specs [@geojaz](https://github.com/geojaz) [#4151](https://github.com/kubernetes/kops/pull/4151)
* Moved paragraph relating to runtimeConfig [@steveruckdashel](https://github.com/steveruckdashel) [#4125](https://github.com/kubernetes/kops/pull/4125)
* Add support for cn-northwest-1. [@leeeboo](https://github.com/leeeboo) [#4148](https://github.com/kubernetes/kops/pull/4148)
* fixing lifecycle type for network in security phase [@chrislovecnm](https://github.com/chrislovecnm) [#4155](https://github.com/kubernetes/kops/pull/4155)
* Implement mirroring for API CAStore [@justinsb](https://github.com/justinsb) [#3840](https://github.com/kubernetes/kops/pull/3840)
* Documentation Cleanup [@rifelpet](https://github.com/rifelpet) [#4165](https://github.com/kubernetes/kops/pull/4165)
* Openapi updates [@chrislovecnm](https://github.com/chrislovecnm) [#4167](https://github.com/kubernetes/kops/pull/4167)
* Add roundtrip tests for certs & private keys [@justinsb](https://github.com/justinsb) [#4172](https://github.com/kubernetes/kops/pull/4172)
* Adding CNI v0.6.0 which is required for Kubernetes 1.9 [@chrislovecnm](https://github.com/chrislovecnm) [#4175](https://github.com/kubernetes/kops/pull/4175)
* Remove Romana preview notice from networking docs [@rwiggins](https://github.com/rwiggins) [#4187](https://github.com/kubernetes/kops/pull/4187)
* Improving bazel make targets, adding a target for kops cli, bumping go_rules version [@chrislovecnm](https://github.com/chrislovecnm) [#4170](https://github.com/kubernetes/kops/pull/4170)
* removing inactive approvers [@chrislovecnm](https://github.com/chrislovecnm) [#4176](https://github.com/kubernetes/kops/pull/4176)
* Adding override for setting etcd version [@chrislovecnm](https://github.com/chrislovecnm) [#4179](https://github.com/kubernetes/kops/pull/4179)
* Initial implementation of bundle command [@justinsb](https://github.com/justinsb) [#4193](https://github.com/kubernetes/kops/pull/4193)
* Add experimental kube-discovery [@justinsb](https://github.com/justinsb) [#4194](https://github.com/kubernetes/kops/pull/4194)
* Updating Manifest documentation [@chrislovecnm](https://github.com/chrislovecnm) [#4177](https://github.com/kubernetes/kops/pull/4177)
* Updating docs README.md file [@chrislovecnm](https://github.com/chrislovecnm) [#4178](https://github.com/kubernetes/kops/pull/4178)
* Golang 1.9 [@chrislovecnm](https://github.com/chrislovecnm) [#4168](https://github.com/kubernetes/kops/pull/4168)
* adding missed lifecycles in elb code [@chrislovecnm](https://github.com/chrislovecnm) [#4154](https://github.com/kubernetes/kops/pull/4154)
* Bump alpha channel for meltdown/spectre [@justinsb](https://github.com/justinsb) [#4204](https://github.com/kubernetes/kops/pull/4204)
* kube-discovery: deduplicate multicast responses [@justinsb](https://github.com/justinsb) [#4214](https://github.com/kubernetes/kops/pull/4214)
* Add makefile target for kube-discovery image [@justinsb](https://github.com/justinsb) [#4213](https://github.com/kubernetes/kops/pull/4213)
* nodeup: don't warn during distro detection [@justinsb](https://github.com/justinsb) [#4215](https://github.com/kubernetes/kops/pull/4215)
* gce: mounter asset has moved [@justinsb](https://github.com/justinsb) [#4216](https://github.com/kubernetes/kops/pull/4216)
* Adding cve updates for spectre and meltdown [@chrislovecnm](https://github.com/chrislovecnm) [#4211](https://github.com/kubernetes/kops/pull/4211)
* Suggest tweaks to meltdown advisory [@justinsb](https://github.com/justinsb) [#4220](https://github.com/kubernetes/kops/pull/4220)
* kops validate cluster can output YAML or JSON [@chrislovecnm](https://github.com/chrislovecnm) [#4107](https://github.com/kubernetes/kops/pull/4107)
* GCE: Don't set bucket-level permissions [@justinsb](https://github.com/justinsb) [#4221](https://github.com/kubernetes/kops/pull/4221)
* cloudConfig.elbSecurityGroup under wrong L3 heading [@steveruckdashel](https://github.com/steveruckdashel) [#4226](https://github.com/kubernetes/kops/pull/4226)
* Update state and cloudLabels docs, fix --target description [@rifelpet](https://github.com/rifelpet) [#4227](https://github.com/kubernetes/kops/pull/4227)
* Makefile command "apimachinery" run [@wannabesrevenge](https://github.com/wannabesrevenge) [#4241](https://github.com/kubernetes/kops/pull/4241)
* VFS: Support io.WriterTo interface [@justinsb](https://github.com/justinsb) [#4217](https://github.com/kubernetes/kops/pull/4217)
* Expose the --fail-swap-on flag for kubelet [@wannabesrevenge](https://github.com/wannabesrevenge) [#4239](https://github.com/kubernetes/kops/pull/4239)
* Cloudformation [@tdeshetler](https://github.com/tdeshetler) [#4244](https://github.com/kubernetes/kops/pull/4244)
* Update binary installation commands for macOS to use curl alone [@hopkinsth](https://github.com/hopkinsth) [#4260](https://github.com/kubernetes/kops/pull/4260)
* Slight changes to commands. [@darron](https://github.com/darron) [#4259](https://github.com/kubernetes/kops/pull/4259)
* Add SubnetType Tag to Subnets [@KashifSaadat](https://github.com/KashifSaadat) [#4198](https://github.com/kubernetes/kops/pull/4198)
* Kops Replace Force [@gambol99](https://github.com/gambol99) [#4275](https://github.com/kubernetes/kops/pull/4275)
* docs: upgrade.md: drop DrainAndValidateRollingUpdate note [@dkeitel](https://github.com/dkeitel) [#4282](https://github.com/kubernetes/kops/pull/4282)
* Bump alpha channel [@justinsb](https://github.com/justinsb) [#4285](https://github.com/kubernetes/kops/pull/4285)
* Validate IG MaxSize is not less than MinSize. [@mikesplain](https://github.com/mikesplain) [#4278](https://github.com/kubernetes/kops/pull/4278)
* Removing duplicate AMI entry from Documentation [@AlexLast](https://github.com/AlexLast) [#4223](https://github.com/kubernetes/kops/pull/4223)
* Move net mode log after it is known in create [@nebril](https://github.com/nebril) [#4294](https://github.com/kubernetes/kops/pull/4294)
* Implement ability to update Load Balancer subnets [@KashifSaadat](https://github.com/KashifSaadat) [#4281](https://github.com/kubernetes/kops/pull/4281)
* Update list of AdmissionControllers for k8s 1.9 [@blakebarnett](https://github.com/blakebarnett) [#4299](https://github.com/kubernetes/kops/pull/4299)
* bazel 0.9.0 running `make bazel-build` updates [@blakebarnett](https://github.com/blakebarnett) [#4298](https://github.com/kubernetes/kops/pull/4298)
* Upgrade to calico v2.6.6 [@blakebarnett](https://github.com/blakebarnett) [#4297](https://github.com/kubernetes/kops/pull/4297)
* Update bazelbuild/rules_go to 0.9.0 [@ixdy](https://github.com/ixdy) [#4304](https://github.com/kubernetes/kops/pull/4304)
* Copy alpha channel to stable [@justinsb](https://github.com/justinsb) [#4284](https://github.com/kubernetes/kops/pull/4284)
* Stick with jessie for 1.9 clusters [@justinsb](https://github.com/justinsb) [#4309](https://github.com/kubernetes/kops/pull/4309)
* Use jessie for 1.10 as well, to unblock queue [@justinsb](https://github.com/justinsb) [#4310](https://github.com/kubernetes/kops/pull/4310)
* Bump kopeio-networking to 1.0.20180120 [@justinsb](https://github.com/justinsb) [#4306](https://github.com/kubernetes/kops/pull/4306)
* Promote alpha channel image to stable [@justinsb](https://github.com/justinsb) [#4325](https://github.com/kubernetes/kops/pull/4325)
* Update aws-sdk-go to 1.12.57 [@leeeboo](https://github.com/leeeboo) [#4234](https://github.com/kubernetes/kops/pull/4234)
* Don't specify require-kubeconfig from 1.10 [@justinsb](https://github.com/justinsb) [#4308](https://github.com/kubernetes/kops/pull/4308)
* Fix ASG scaling by adding in ec2:DescribeRegions permission to the nodes IAM role [@mikn](https://github.com/mikn) [#4320](https://github.com/kubernetes/kops/pull/4320)
* fix config file name in aws-china.md [@qqshfox](https://github.com/qqshfox) [#4321](https://github.com/kubernetes/kops/pull/4321)
* Fix the buildImage command typo [@mingyuanzhu](https://github.com/mingyuanzhu) [#4319](https://github.com/kubernetes/kops/pull/4319)
* ReadTree: clarify that returns only files [@justinsb](https://github.com/justinsb) [#4315](https://github.com/kubernetes/kops/pull/4315)
* Add missing BUILD.bazel for util/pkg/slice [@justinsb](https://github.com/justinsb) [#4318](https://github.com/kubernetes/kops/pull/4318)
* bazel: expose version as in Makefile [@justinsb](https://github.com/justinsb) [#4333](https://github.com/kubernetes/kops/pull/4333)
* Add license to get_workspace_status & move to .sh [@mikesplain](https://github.com/mikesplain) [#4337](https://github.com/kubernetes/kops/pull/4337)
* Ensure GCE disk name does not start with a number [@justinsb](https://github.com/justinsb) [#4317](https://github.com/kubernetes/kops/pull/4317)
* GCE: Dial down logging [@justinsb](https://github.com/justinsb) [#4335](https://github.com/kubernetes/kops/pull/4335)
* Don't autobuild protobuf files [@justinsb](https://github.com/justinsb) [#4329](https://github.com/kubernetes/kops/pull/4329)
* Handle NotFound error when creating instance group [@georgebuckerfield](https://github.com/georgebuckerfield) [#4305](https://github.com/kubernetes/kops/pull/4305)
* GCE: Don't require SSH public key [@justinsb](https://github.com/justinsb) [#4334](https://github.com/kubernetes/kops/pull/4334)
* AWS LaunchConfiguration error handling fix [@justinsb](https://github.com/justinsb) [#4341](https://github.com/kubernetes/kops/pull/4341)
* GCE: Get default project from gcloud CLI [@justinsb](https://github.com/justinsb) [#4332](https://github.com/kubernetes/kops/pull/4332)
* When kops searches for AMI by name, if > 1 are returned, uses the latest. [@denniswebb](https://github.com/denniswebb) [#4338](https://github.com/kubernetes/kops/pull/4338)
* Enable metrics for AutoScalingGroups [@johanneswuerbach](https://github.com/johanneswuerbach) [#4342](https://github.com/kubernetes/kops/pull/4342)
* Update bastion.md [@metaflow](https://github.com/metaflow) [#4344](https://github.com/kubernetes/kops/pull/4344)
* Allow image override for etcd [@ottoyiu](https://github.com/ottoyiu) [#4245](https://github.com/kubernetes/kops/pull/4245)
* Switching the default for kops to create a cluster with RBAC enabled. [@chrislovecnm](https://github.com/chrislovecnm) [#4184](https://github.com/kubernetes/kops/pull/4184)
* Fix rootVolumeType accepts all volume types [@int128](https://github.com/int128) [#4270](https://github.com/kubernetes/kops/pull/4270)
* Interactive cli opt [@mrballcb](https://github.com/mrballcb) [#4166](https://github.com/kubernetes/kops/pull/4166)
* Bump kubernetes dashboard version to 1.8.1 [@stuffandthings](https://github.com/stuffandthings) [#4130](https://github.com/kubernetes/kops/pull/4130)
* Use 0.9.0 release of nginx-ingress-controller [@cap10morgan](https://github.com/cap10morgan) [#4027](https://github.com/kubernetes/kops/pull/4027)
* VFS: Fix bug in CopyTree when dest does not exist [@justinsb](https://github.com/justinsb) [#4316](https://github.com/kubernetes/kops/pull/4316)
* VFS: Recognize file:// paths [@justinsb](https://github.com/justinsb) [#4346](https://github.com/kubernetes/kops/pull/4346)
* exec target command, but still pipe it to tee [@justinsb](https://github.com/justinsb) [#4286](https://github.com/kubernetes/kops/pull/4286)
* Improve S3 url parsing for vfsPath to support more naming conventions [@ottoyiu](https://github.com/ottoyiu) [#4246](https://github.com/kubernetes/kops/pull/4246)
* Update single-to-multi-master.md [@jeyglk](https://github.com/jeyglk) [#4359](https://github.com/kubernetes/kops/pull/4359)
* Fix broken links for Usage instructions in addons.md [@Rcluoyi](https://github.com/Rcluoyi) [#4361](https://github.com/kubernetes/kops/pull/4361)
* update go version and ldflags [@oilbeater](https://github.com/oilbeater) [#4349](https://github.com/kubernetes/kops/pull/4349)
* Feature/extra terraform config [@iMartyn](https://github.com/iMartyn) [#4336](https://github.com/kubernetes/kops/pull/4336)
* Update terraform.md [@perryao](https://github.com/perryao) [#4201](https://github.com/kubernetes/kops/pull/4201)
* Extend examples of subnet parameter [@dictvm](https://github.com/dictvm) [#4199](https://github.com/kubernetes/kops/pull/4199)
* Update route-related IAM permissions for Romana [@cgilmour](https://github.com/cgilmour) [#4365](https://github.com/kubernetes/kops/pull/4365)
* update image go version [@oilbeater](https://github.com/oilbeater) [#4366](https://github.com/kubernetes/kops/pull/4366)
* Fix ccm startup wrt dns controller (set dnsPolicy to Default and host… [@wlan0](https://github.com/wlan0) [#4367](https://github.com/kubernetes/kops/pull/4367)
* modify check require-kubeconfig kube version [@zhangxiaoyu-zidif](https://github.com/zhangxiaoyu-zidif) [#4357](https://github.com/kubernetes/kops/pull/4357)
* Update kopeio-networking to 1.0.20180203 [@justinsb](https://github.com/justinsb) [#4374](https://github.com/kubernetes/kops/pull/4374)
* Remove federation support [@justinsb](https://github.com/justinsb) [#4379](https://github.com/kubernetes/kops/pull/4379)
* Documentation spelling/grammar fixes. [@lucasreed](https://github.com/lucasreed) [#4372](https://github.com/kubernetes/kops/pull/4372)
* Update gazelle [@justinsb](https://github.com/justinsb) [#4378](https://github.com/kubernetes/kops/pull/4378)
* Explicitly set go version in bazel build [@justinsb](https://github.com/justinsb) [#4376](https://github.com/kubernetes/kops/pull/4376)
* Update submodule dependencies for k8s 1.9 [@justinsb](https://github.com/justinsb) [#4377](https://github.com/kubernetes/kops/pull/4377)
* bazel: declare golang 1.9.3 [@justinsb](https://github.com/justinsb) [#4380](https://github.com/kubernetes/kops/pull/4380)
* Fix drain command for rolling-updates [@KashifSaadat](https://github.com/KashifSaadat) [#4387](https://github.com/kubernetes/kops/pull/4387)
* Add mac build for travis [@mikesplain](https://github.com/mikesplain) [#4388](https://github.com/kubernetes/kops/pull/4388)
* add support for changing the weave peer connection limit [@polarbizzle](https://github.com/polarbizzle) [#4398](https://github.com/kubernetes/kops/pull/4398)
* Update versions for romana container images [@cgilmour](https://github.com/cgilmour) [#4405](https://github.com/kubernetes/kops/pull/4405)
* Bump alpha channel to new image [@justinsb](https://github.com/justinsb) [#4411](https://github.com/kubernetes/kops/pull/4411)
* Update Weave Net to version 2.2.0 [@errordeveloper](https://github.com/errordeveloper) [#4413](https://github.com/kubernetes/kops/pull/4413)
* Bump weave version to 2.2.0 [@justinsb](https://github.com/justinsb) [#4421](https://github.com/kubernetes/kops/pull/4421)
* upup: Make RenderTerraform handle an error from AddOutputVariableArray [@kkaneda](https://github.com/kkaneda) [#4406](https://github.com/kubernetes/kops/pull/4406)
* Add notes for 1.8.1 release [@justinsb](https://github.com/justinsb) [#4423](https://github.com/kubernetes/kops/pull/4423)
* master node requires DescribeRegions when using a bucket from another… [@sstarcher](https://github.com/sstarcher) [#4409](https://github.com/kubernetes/kops/pull/4409)
* Pick up etcd version changes for a rolling update on master nodes [@KashifSaadat](https://github.com/KashifSaadat) [#4371](https://github.com/kubernetes/kops/pull/4371)
* API audit doc changes [@shavo007](https://github.com/shavo007) [#4427](https://github.com/kubernetes/kops/pull/4427)
* fix a typo in tool_template.go [@yank1](https://github.com/yank1) [#4426](https://github.com/kubernetes/kops/pull/4426)
* Updating Makefile to the correct versions for the 1.8.1 release [@chrislovecnm](https://github.com/chrislovecnm) [#4432](https://github.com/kubernetes/kops/pull/4432)
* Update BUILD files to account for some recent changes [@mikesplain](https://github.com/mikesplain) [#4431](https://github.com/kubernetes/kops/pull/4431)
* Use dep to maintain vendor directory [@justinsb](https://github.com/justinsb) [#4382](https://github.com/kubernetes/kops/pull/4382)
* Update upgrade.md [@jar349](https://github.com/jar349) [#4433](https://github.com/kubernetes/kops/pull/4433)
* Update Cluster Autoscaler image and Reduce the Delta between autoscaler docs [@StevenACoffman](https://github.com/StevenACoffman) [#4182](https://github.com/kubernetes/kops/pull/4182)
* Fix wrong backticks markdown. [@Antiarchitect](https://github.com/Antiarchitect) [#4436](https://github.com/kubernetes/kops/pull/4436)
* Add live-restore flag to docker config [@marciorodrigues87](https://github.com/marciorodrigues87) [#4169](https://github.com/kubernetes/kops/pull/4169)
* Fixing problems in dev build script example [@chrislovecnm](https://github.com/chrislovecnm) [#4438](https://github.com/kubernetes/kops/pull/4438)
* Add max-requests-inflight parameter [@ihoegen](https://github.com/ihoegen) [#4395](https://github.com/kubernetes/kops/pull/4395)
* Updates for x1 instance family [@manabusakai](https://github.com/manabusakai) [#4437](https://github.com/kubernetes/kops/pull/4437)
* Fix instange groups docs [@klaus993](https://github.com/klaus993) [#4440](https://github.com/kubernetes/kops/pull/4440)
* Kubernetes Calico TLS [@gambol99](https://github.com/gambol99) [#4240](https://github.com/kubernetes/kops/pull/4240)
* Add  to aws-china.md to prevent Etag not match the HASH of file. [@leeeboo](https://github.com/leeeboo) [#4384](https://github.com/kubernetes/kops/pull/4384)
* add storageclasses permissions for cluster-autoscaler:v1.1.0 [@mikesimos](https://github.com/mikesimos) [#4456](https://github.com/kubernetes/kops/pull/4456)
* Fixing ExistsAndWarnIfChanges so that it will allow a user to pass [@chrislovecnm](https://github.com/chrislovecnm) [#4459](https://github.com/kubernetes/kops/pull/4459)
* updating bazel BUILD file [@chrislovecnm](https://github.com/chrislovecnm) [#4457](https://github.com/kubernetes/kops/pull/4457)
* Lifecycle overrides [@chrislovecnm](https://github.com/chrislovecnm) [#4445](https://github.com/kubernetes/kops/pull/4445)
* Remove submodules [@chrislovecnm](https://github.com/chrislovecnm) [#4435](https://github.com/kubernetes/kops/pull/4435)
* Updating variables to use Camel Case [@chrislovecnm](https://github.com/chrislovecnm) [#4467](https://github.com/kubernetes/kops/pull/4467)
* Updating missed BUILD files for gazelle [@chrislovecnm](https://github.com/chrislovecnm) [#4468](https://github.com/kubernetes/kops/pull/4468)
* Fixing deleting of shared IGW and DHCPOptions [@chrislovecnm](https://github.com/chrislovecnm) [#4460](https://github.com/kubernetes/kops/pull/4460)
* Support updating autoscaling metrics [@justinsb](https://github.com/justinsb) [#4469](https://github.com/kubernetes/kops/pull/4469)
* Convert registry to k8s.gcr.io [@thockin](https://github.com/thockin) [#4137](https://github.com/kubernetes/kops/pull/4137)
* Updating kops version when using bazel [@chrislovecnm](https://github.com/chrislovecnm) [#4475](https://github.com/kubernetes/kops/pull/4475)
* Update apimachinery & ensure we always run goimports [@justinsb](https://github.com/justinsb) [#4473](https://github.com/kubernetes/kops/pull/4473)
* Update kube-dns to 1.14.8 [@justinsb](https://github.com/justinsb) [#4478](https://github.com/kubernetes/kops/pull/4478)
* kube-dns: turn off negcache [@justinsb](https://github.com/justinsb) [#4479](https://github.com/kubernetes/kops/pull/4479)
* Initial support for standalone etcd-manager backups [@justinsb](https://github.com/justinsb) [#4465](https://github.com/kubernetes/kops/pull/4465)
* Require kops 1.7.1 (with the CVE fix), recommend kops 1.8.1 [@justinsb](https://github.com/justinsb) [#3592](https://github.com/kubernetes/kops/pull/3592)
* Build docker images through bazel [@justinsb](https://github.com/justinsb) [#3561](https://github.com/kubernetes/kops/pull/3561)
* Update ingress versions and fix to quay registry [@mikesplain](https://github.com/mikesplain) [#4485](https://github.com/kubernetes/kops/pull/4485)
* Update AWS Logo In Docs [@christopherhein](https://github.com/christopherhein) [#4481](https://github.com/kubernetes/kops/pull/4481)
* Change FeatureGates to omitempty under KubeProxyConfig [@argais](https://github.com/argais) [#4500](https://github.com/kubernetes/kops/pull/4500)
* Use k8s.gcr.io alias only for 1.10 [@christopherhein](https://github.com/christopherhein),[@justinsb](https://github.com/justinsb) [#4494](https://github.com/kubernetes/kops/pull/4494)
* Fix -ldflags incompatibility in go1.10 [@tvi](https://github.com/tvi) [#4502](https://github.com/kubernetes/kops/pull/4502)
* Adding additional tags and shared to various AWS components [@chrislovecnm](https://github.com/chrislovecnm) [#4489](https://github.com/kubernetes/kops/pull/4489)
* Bazel docker, cross builds and uploading to s3 [@mikesplain](https://github.com/mikesplain) [#4477](https://github.com/kubernetes/kops/pull/4477)
* Verify bazel files [@chrislovecnm](https://github.com/chrislovecnm) [#4504](https://github.com/kubernetes/kops/pull/4504)
* Build protokube tar in bazel [@justinsb](https://github.com/justinsb) [#4510](https://github.com/kubernetes/kops/pull/4510)
* Add cidr-allocator-type flag to kcm and ccm [@justinsb](https://github.com/justinsb) [#4512](https://github.com/kubernetes/kops/pull/4512)
* Bazel follow up [@mikesplain](https://github.com/mikesplain) [#4515](https://github.com/kubernetes/kops/pull/4515)
* dns-controller: support digitalocean [@andrewsykim](https://github.com/andrewsykim) [#4508](https://github.com/kubernetes/kops/pull/4508)
* Add Instance Group Suspend Processes [@mikesplain](https://github.com/mikesplain) [#3829](https://github.com/kubernetes/kops/pull/3829)
* DockerConfig Order [@gambol99](https://github.com/gambol99) [#4505](https://github.com/kubernetes/kops/pull/4505)
* Fix bazel deprecation notice [@mikesplain](https://github.com/mikesplain) [#4518](https://github.com/kubernetes/kops/pull/4518)
* Experimental kops set cluster command [@justinsb](https://github.com/justinsb) [#4381](https://github.com/kubernetes/kops/pull/4381)
* docker: Adds hosts configuration option [@jaipradeesh](https://github.com/jaipradeesh) [#4497](https://github.com/kubernetes/kops/pull/4497)
* Fixing verify bazel [@chrislovecnm](https://github.com/chrislovecnm) [#4522](https://github.com/kubernetes/kops/pull/4522)
* Fix snake case [@chrislovecnm](https://github.com/chrislovecnm) [#4520](https://github.com/kubernetes/kops/pull/4520)
* VFS: WriteFile takes an io.ReadSeeker [@justinsb](https://github.com/justinsb) [#4493](https://github.com/kubernetes/kops/pull/4493)
* Update rules go [@mikesplain](https://github.com/mikesplain) [#4530](https://github.com/kubernetes/kops/pull/4530)
* Add node monitor flags [@so0k](https://github.com/so0k) [#4525](https://github.com/kubernetes/kops/pull/4525)
* Clarify few things in Running an existing VPC [@syndbg](https://github.com/syndbg) [#4519](https://github.com/kubernetes/kops/pull/4519)
* Set the default docker for kubernetes 1.9 to 17.03.2 [@zacblazic](https://github.com/zacblazic) [#4443](https://github.com/kubernetes/kops/pull/4443)
* Add option for using existing EIP's [@sethpollack](https://github.com/sethpollack) [#4302](https://github.com/kubernetes/kops/pull/4302)
* Etcd TLS Peer & CLient Auth [@gambol99](https://github.com/gambol99) [#4010](https://github.com/kubernetes/kops/pull/4010)
* Fix suspicious space in struct tag value [@tvi](https://github.com/tvi) [#4535](https://github.com/kubernetes/kops/pull/4535)
* Add support for bastion aws user-data [@duboisf](https://github.com/duboisf) [#4452](https://github.com/kubernetes/kops/pull/4452)
* Moving from one IG w multiple AZs to one IG per AZ [@Globegitter](https://github.com/Globegitter) [#4528](https://github.com/kubernetes/kops/pull/4528)
* Make addon specification into an object [@polarbizzle](https://github.com/polarbizzle),[@justinsb](https://github.com/justinsb) [#4538](https://github.com/kubernetes/kops/pull/4538)
* Fixing integration tests [@chrislovecnm](https://github.com/chrislovecnm) [#4539](https://github.com/kubernetes/kops/pull/4539)
* Increase key size in GeneratePrivateKey() to 3072 [@snelson-pp](https://github.com/snelson-pp) [#4354](https://github.com/kubernetes/kops/pull/4354)
* Kube-proxy API to accept cpu: limit, memory: request and limit [@horaceheaven](https://github.com/horaceheaven) [#4476](https://github.com/kubernetes/kops/pull/4476)
* Expose Felix metrics [@atopuzov](https://github.com/atopuzov) [#4529](https://github.com/kubernetes/kops/pull/4529)
* Add (proposed) roadmap for etcd [@justinsb](https://github.com/justinsb) [#4474](https://github.com/kubernetes/kops/pull/4474)
* Update Calico and Canal to use calico node v2.6.7 [@tmjd](https://github.com/tmjd),[@justinsb](https://github.com/justinsb) [#4447](https://github.com/kubernetes/kops/pull/4447)
* Update aws-sdk-go to v1.12.79 [@justinsb](https://github.com/justinsb) [#4541](https://github.com/kubernetes/kops/pull/4541)
* Add route53 max changeset batch size flag [@pwillie](https://github.com/pwillie) [#4496](https://github.com/kubernetes/kops/pull/4496)
* Add kubernetes 1.9.3 into alpha & stable channels [@justinsb](https://github.com/justinsb) [#4542](https://github.com/kubernetes/kops/pull/4542)
* custom ca new implementation of #2924 [@mad01](https://github.com/mad01) [#4526](https://github.com/kubernetes/kops/pull/4526)
* Cherry pick to update apimachinery for 1.9 release [@chrislovecnm](https://github.com/chrislovecnm) [#4556](https://github.com/kubernetes/kops/pull/4556)
* Verify apimachinery [@chrislovecnm](https://github.com/chrislovecnm) [#4555](https://github.com/kubernetes/kops/pull/4555)
* Updates for Bazel tests and cleaning up go sdk [@chrislovecnm](https://github.com/chrislovecnm) [#4554](https://github.com/kubernetes/kops/pull/4554)
* Kube Proxy IPVS Kernel Module [@gambol99](https://github.com/gambol99) [#4550](https://github.com/kubernetes/kops/pull/4550)
* Bumping gazelle version on bazel scripts [@chrislovecnm](https://github.com/chrislovecnm) [#4561](https://github.com/kubernetes/kops/pull/4561)
* Bind the kubelet to the local ipv4 address [@dezmodue](https://github.com/dezmodue) [#4417](https://github.com/kubernetes/kops/pull/4417)
* Recognize AWS Availability Zone EU-WEST-2C [@KashifSaadat](https://github.com/KashifSaadat) [#4558](https://github.com/kubernetes/kops/pull/4558)
* removing old target in Makefile for copying the deps [@chrislovecnm](https://github.com/chrislovecnm) [#4563](https://github.com/kubernetes/kops/pull/4563)
* Update find logic for newly shared objects [@justinsb](https://github.com/justinsb) [#4572](https://github.com/kubernetes/kops/pull/4572)
* Updating bazel kops versions so that it matches the Makefile [@chrislovecnm](https://github.com/chrislovecnm) [#4583](https://github.com/kubernetes/kops/pull/4583)
* Add comprehensive horizontal pod autoscaling documentation [@itskingori](https://github.com/itskingori) [#3942](https://github.com/kubernetes/kops/pull/3942)
* Adding support for new Paris region  [@naveensrinivasan](https://github.com/naveensrinivasan) [#4552](https://github.com/kubernetes/kops/pull/4552)
* Update Compatibility Matrix [@mikesplain](https://github.com/mikesplain) [#4580](https://github.com/kubernetes/kops/pull/4580)
* Typo fix "NAT Gateways" -> "NAT gateways" [@AdamDang](https://github.com/AdamDang) [#4576](https://github.com/kubernetes/kops/pull/4576)
* Force bazel builds to be pure. [@mikesplain](https://github.com/mikesplain) [#4602](https://github.com/kubernetes/kops/pull/4602)
* Update getting_started/aws.md [@sanketjpatel](https://github.com/sanketjpatel) [#4605](https://github.com/kubernetes/kops/pull/4605)
* Typo delete duplicated word [@AdamDang](https://github.com/AdamDang) [#4600](https://github.com/kubernetes/kops/pull/4600)
* Typo fix "kubernetes"->"Kubernetes" [@AdamDang](https://github.com/AdamDang) [#4577](https://github.com/kubernetes/kops/pull/4577)
* Fix distroless error [@mikesplain](https://github.com/mikesplain) [#4597](https://github.com/kubernetes/kops/pull/4597)
* fix docs regarding security group tagging [@mariusv](https://github.com/mariusv) [#4594](https://github.com/kubernetes/kops/pull/4594)
* Create readme.ES.md [@UlisesTJ](https://github.com/UlisesTJ) [#4592](https://github.com/kubernetes/kops/pull/4592)
* Bazel: Add more pure builds [@mikesplain](https://github.com/mikesplain) [#4616](https://github.com/kubernetes/kops/pull/4616)
* Tag nat gateways [@mikesplain](https://github.com/mikesplain) [#4606](https://github.com/kubernetes/kops/pull/4606)
* Typo fix "failes"->"fails" [@AdamDang](https://github.com/AdamDang) [#4610](https://github.com/kubernetes/kops/pull/4610)
* Typo delete duplicated "a a" [@AdamDang](https://github.com/AdamDang) [#4609](https://github.com/kubernetes/kops/pull/4609)
* Fix-typo-in-toolbox_template.go [@yank1](https://github.com/yank1) [#4613](https://github.com/kubernetes/kops/pull/4613)
* Add cluster name environment variable [@rocktavious](https://github.com/rocktavious) [#4560](https://github.com/kubernetes/kops/pull/4560)
* Typo fix "etcd manager"->"etcd-manager" [@AdamDang](https://github.com/AdamDang) [#4628](https://github.com/kubernetes/kops/pull/4628)
* Typo fix "provides"->"provide" [@AdamDang](https://github.com/AdamDang) [#4622](https://github.com/kubernetes/kops/pull/4622)
* Typo instance group ->"InstanceGroup" [@AdamDang](https://github.com/AdamDang) [#4621](https://github.com/kubernetes/kops/pull/4621)
* Typo "official"->"official" [@AdamDang](https://github.com/AdamDang) [#4637](https://github.com/kubernetes/kops/pull/4637)
* Typo delete duplicated "our", fix "reacheable"->"reachable" [@AdamDang](https://github.com/AdamDang) [#4636](https://github.com/kubernetes/kops/pull/4636)
* Fixed typo, us-central should be eu-central [@peterkuiper](https://github.com/peterkuiper) [#4631](https://github.com/kubernetes/kops/pull/4631)
* Typo fix "need"->"needs", delete duplicated "." [@AdamDang](https://github.com/AdamDang) [#4626](https://github.com/kubernetes/kops/pull/4626)
* Typo delete duplicated "is ", "utilty"->"utility" [@AdamDang](https://github.com/AdamDang) [#4638](https://github.com/kubernetes/kops/pull/4638)
* Typo fix "previouslly"->"previously" [@AdamDang](https://github.com/AdamDang) [#4625](https://github.com/kubernetes/kops/pull/4625)
* Updating comment so we do not have gofmt issues with go 1.9 and go 1.10 [@chrislovecnm](https://github.com/chrislovecnm) [#4635](https://github.com/kubernetes/kops/pull/4635)
* Creating the keyset.yaml file if it does not exist [@chrislovecnm](https://github.com/chrislovecnm) [#4582](https://github.com/kubernetes/kops/pull/4582)
* Reduce log levels: parsing pem block [@justinsb](https://github.com/justinsb) [#4646](https://github.com/kubernetes/kops/pull/4646)
* Updating K8s API calls to use CoreV1 kops node adapter [@chrislovecnm](https://github.com/chrislovecnm) [#4644](https://github.com/kubernetes/kops/pull/4644)
* Typo fix "Kubernetes 1.9"->"Kubernetes v1.9" [@AdamDang](https://github.com/AdamDang) [#4624](https://github.com/kubernetes/kops/pull/4624)
* Protokube Channel and RBAC [@gambol99](https://github.com/gambol99) [#4651](https://github.com/kubernetes/kops/pull/4651)
* Add AWS x1e instances to the instance type supported by kops [@ChienHuey](https://github.com/ChienHuey),[@justinsb](https://github.com/justinsb) [#4593](https://github.com/kubernetes/kops/pull/4593)
* Updating verify scripts so that output is highlighted [@chrislovecnm](https://github.com/chrislovecnm) [#4633](https://github.com/kubernetes/kops/pull/4633)
* keypair integration test: print diffs [@justinsb](https://github.com/justinsb) [#4648](https://github.com/kubernetes/kops/pull/4648)
* Updating to use CoreV1 in unit tests [@chrislovecnm](https://github.com/chrislovecnm) [#4645](https://github.com/kubernetes/kops/pull/4645)
* Move ssh key functions to pkg/pki [@justinsb](https://github.com/justinsb) [#4653](https://github.com/kubernetes/kops/pull/4653)
* typo: anmed -> named [@justinsb](https://github.com/justinsb) [#4652](https://github.com/kubernetes/kops/pull/4652)
* Keypair: tweak Render logic [@justinsb](https://github.com/justinsb) [#4649](https://github.com/kubernetes/kops/pull/4649)
* Create lifecycle test against AWS mocks [@justinsb](https://github.com/justinsb) [#4569](https://github.com/kubernetes/kops/pull/4569)
* New images for alpha channel: 4.4.121 kernel [@justinsb](https://github.com/justinsb) [#4657](https://github.com/kubernetes/kops/pull/4657)
* alpha channel: k8s 1.7.13 & 1.8.8 [@justinsb](https://github.com/justinsb) [#4658](https://github.com/kubernetes/kops/pull/4658)
* alpha: bump to latest (64) COS image for GCE [@justinsb](https://github.com/justinsb) [#4659](https://github.com/kubernetes/kops/pull/4659)
* Promote alpha channel to stable [@justinsb](https://github.com/justinsb) [#4656](https://github.com/kubernetes/kops/pull/4656)
* Misc task code cleanups [@justinsb](https://github.com/justinsb) [#4660](https://github.com/kubernetes/kops/pull/4660)
* Add README to say what cloudmock is [@justinsb](https://github.com/justinsb) [#4655](https://github.com/kubernetes/kops/pull/4655)
* Bump alpha channels for CVE [@mikesplain](https://github.com/mikesplain) [#4666](https://github.com/kubernetes/kops/pull/4666)
* More mocks - sufficient for privatecalico to roundtrip [@justinsb](https://github.com/justinsb) [#4654](https://github.com/kubernetes/kops/pull/4654)
* Typo fix "DNS wil be"->"DNS will be" [@AdamDang](https://github.com/AdamDang) [#4667](https://github.com/kubernetes/kops/pull/4667)
* Unset certain environment variables before testing [@rifelpet](https://github.com/rifelpet) [#4595](https://github.com/kubernetes/kops/pull/4595)
* Fix a mistake in componentconfig.go [@AdamDang](https://github.com/AdamDang) [#4670](https://github.com/kubernetes/kops/pull/4670)
* Update status.go [@AdamDang](https://github.com/AdamDang) [#4676](https://github.com/kubernetes/kops/pull/4676)
* Fix names of CloudFormation-created AutoScalingGroups [@gwkunze](https://github.com/gwkunze) [#4669](https://github.com/kubernetes/kops/pull/4669)
* Fix error accompanying note in node_api_adapter.go [@AdamDang](https://github.com/AdamDang) [#4671](https://github.com/kubernetes/kops/pull/4671)
* Update instancegroups.go [@AdamDang](https://github.com/AdamDang) [#4681](https://github.com/kubernetes/kops/pull/4681)
* Fix routetable detection [@justinsb](https://github.com/justinsb) [#4661](https://github.com/kubernetes/kops/pull/4661)
* Define KeysetFormat type, embed into keyset [@justinsb](https://github.com/justinsb) [#4650](https://github.com/kubernetes/kops/pull/4650)
* Typo fix "command"->"command" [@AdamDang](https://github.com/AdamDang) [#4682](https://github.com/kubernetes/kops/pull/4682)
* fix 'confimap'->'configmap' [@muhongwei](https://github.com/muhongwei) [#4686](https://github.com/kubernetes/kops/pull/4686)
* Correct spelling mistake [@muhongwei](https://github.com/muhongwei) [#4685](https://github.com/kubernetes/kops/pull/4685)
* [Calico] Fix delay setting up ip routes in new nodes [@felipejfc](https://github.com/felipejfc) [#4589](https://github.com/kubernetes/kops/pull/4589)
* Typo fix in route53-mapper/README.md [@AdamDang](https://github.com/AdamDang) [#4706](https://github.com/kubernetes/kops/pull/4706)
* Typo fix in kube-ingress-aws-controller/README.md [@AdamDang](https://github.com/AdamDang) [#4707](https://github.com/kubernetes/kops/pull/4707)
* Centos: add selinux package dependencies [@justinsb](https://github.com/justinsb) [#4715](https://github.com/kubernetes/kops/pull/4715)
* Fix boilerplate scripts [@justinsb](https://github.com/justinsb) [#4713](https://github.com/kubernetes/kops/pull/4713)
* Add more logging around ELB attribute modification [@justinsb](https://github.com/justinsb) [#4705](https://github.com/kubernetes/kops/pull/4705)
* Move AWS resources into its own subpackage [@justinsb](https://github.com/justinsb) [#4708](https://github.com/kubernetes/kops/pull/4708)
* Fix shared network objects [@justinsb](https://github.com/justinsb) [#4711](https://github.com/kubernetes/kops/pull/4711)
* Don't tag shared VPCs [@justinsb](https://github.com/justinsb) [#4710](https://github.com/kubernetes/kops/pull/4710)
* Update boilerplate year [@justinsb](https://github.com/justinsb) [#4714](https://github.com/kubernetes/kops/pull/4714)
* cloudmock: fix locking around vpcs and subnets [@justinsb](https://github.com/justinsb) [#4704](https://github.com/kubernetes/kops/pull/4704)
* Typo fix in README.md [@AdamDang](https://github.com/AdamDang) [#4716](https://github.com/kubernetes/kops/pull/4716)
* Fix kubeScheduler.usePolicyConfigMap - missing namespace flag [@waldman](https://github.com/waldman) [#4726](https://github.com/kubernetes/kops/pull/4726)
* Improve logic around VPC detection [@justinsb](https://github.com/justinsb) [#4709](https://github.com/kubernetes/kops/pull/4709)
* cloudmock: fix prefix for RouteTableAssociation [@justinsb](https://github.com/justinsb) [#4712](https://github.com/kubernetes/kops/pull/4712)
* Validation: start to differentiate between validation failure and errors during validation [@justinsb](https://github.com/justinsb) [#4732](https://github.com/kubernetes/kops/pull/4732)
* Update kopeio-networking to 1.0.20180319 [@justinsb](https://github.com/justinsb) [#4731](https://github.com/kubernetes/kops/pull/4731)
* Validation: clean up unused node status functions [@justinsb](https://github.com/justinsb) [#4733](https://github.com/kubernetes/kops/pull/4733)
* Validation: Take a cluster object, not just the name [@justinsb](https://github.com/justinsb) [#4734](https://github.com/kubernetes/kops/pull/4734)
* Move DNS validation into validation [@justinsb](https://github.com/justinsb) [#4735](https://github.com/kubernetes/kops/pull/4735)
* Mount the iptables lock file [@justinsb](https://github.com/justinsb) [#4742](https://github.com/kubernetes/kops/pull/4742)
* add system:masters group to admin user in static token file [@erks](https://github.com/erks) [#4575](https://github.com/kubernetes/kops/pull/4575)
* Validation: simplify output rendering [@justinsb](https://github.com/justinsb) [#4736](https://github.com/kubernetes/kops/pull/4736)
* mockec2: more missing locking [@justinsb](https://github.com/justinsb) [#4743](https://github.com/kubernetes/kops/pull/4743)
* Validation: treat as error if insufficient nodes [@justinsb](https://github.com/justinsb) [#4703](https://github.com/kubernetes/kops/pull/4703)
* Fixed typos [@szemek](https://github.com/szemek) [#4739](https://github.com/kubernetes/kops/pull/4739)
* Don't use ELB DNS name for internal ELBs [@justinsb](https://github.com/justinsb) [#4748](https://github.com/kubernetes/kops/pull/4748)
* use the primary cert from the ca cert bundle [@polarbizzle](https://github.com/polarbizzle) [#4744](https://github.com/kubernetes/kops/pull/4744)
* Release 1.9.0-alpha.2 [@justinsb](https://github.com/justinsb) [#4750](https://github.com/kubernetes/kops/pull/4750)
* Update instance_groups.md [@AdamDang](https://github.com/AdamDang) [#4751](https://github.com/kubernetes/kops/pull/4751)
* Update cluster_upgrades_and_migrations.md [@AdamDang](https://github.com/AdamDang) [#4756](https://github.com/kubernetes/kops/pull/4756)
* Update getting_started/aws.md [@kmaris](https://github.com/kmaris) [#4755](https://github.com/kubernetes/kops/pull/4755)
* Update networking.md [@AdamDang](https://github.com/AdamDang) [#4754](https://github.com/kubernetes/kops/pull/4754)
* Update README.md [@AdamDang](https://github.com/AdamDang) [#4752](https://github.com/kubernetes/kops/pull/4752)
* Bump stable/alpha channels to 1.9.0-alpha.2 [@mikesplain](https://github.com/mikesplain) [#4757](https://github.com/kubernetes/kops/pull/4757)
* fix function comment error [@jonyhy96](https://github.com/jonyhy96) [#4769](https://github.com/kubernetes/kops/pull/4769)
* Update addon_manager.md [@AdamDang](https://github.com/AdamDang) [#4774](https://github.com/kubernetes/kops/pull/4774)
* fix some grammar mistakes [@jonyhy96](https://github.com/jonyhy96) [#4773](https://github.com/kubernetes/kops/pull/4773)
* fix a grammar mistake [@jonyhy96](https://github.com/jonyhy96) [#4771](https://github.com/kubernetes/kops/pull/4771)
* Validation: don't expect bastion nodes to join [@justinsb](https://github.com/justinsb) [#4775](https://github.com/kubernetes/kops/pull/4775)
* fix some grammar mistakes [@jonyhy96](https://github.com/jonyhy96) [#4772](https://github.com/kubernetes/kops/pull/4772)
* intersectTags: return nil if comparing against nil [@justinsb](https://github.com/justinsb) [#4780](https://github.com/kubernetes/kops/pull/4780)
* Deletion: check if VPC is shared [@justinsb](https://github.com/justinsb) [#4776](https://github.com/kubernetes/kops/pull/4776)
* Add deletion to lifecycle test [@justinsb](https://github.com/justinsb) [#4777](https://github.com/kubernetes/kops/pull/4777)
* ElasticIP: Collect tags [@justinsb](https://github.com/justinsb) [#4782](https://github.com/kubernetes/kops/pull/4782)
* ElasticIP: Always tag [@justinsb](https://github.com/justinsb) [#4779](https://github.com/kubernetes/kops/pull/4779)
* Move routetable detection to new logic [@justinsb](https://github.com/justinsb) [#4778](https://github.com/kubernetes/kops/pull/4778)
* SecurityGroups: ensure owned security groups are tagged [@justinsb](https://github.com/justinsb) [#4785](https://github.com/kubernetes/kops/pull/4785)
* Tag InternetGateways with consistent tags [@justinsb](https://github.com/justinsb) [#4788](https://github.com/kubernetes/kops/pull/4788)
* Tag ElasticIP when owned [@justinsb](https://github.com/justinsb) [#4781](https://github.com/kubernetes/kops/pull/4781)
* Make sure volumes are tagged [@justinsb](https://github.com/justinsb) [#4784](https://github.com/kubernetes/kops/pull/4784)
* SecurityGroup deletion: recognize shared tags [@justinsb](https://github.com/justinsb) [#4786](https://github.com/kubernetes/kops/pull/4786)
* ElasticIP tags for cloudformation & terraform [@justinsb](https://github.com/justinsb) [#4789](https://github.com/kubernetes/kops/pull/4789)
* Add support for instance monitoring [@vendrov](https://github.com/vendrov) [#4695](https://github.com/kubernetes/kops/pull/4695)
* Check tags in lifecycle tests [@justinsb](https://github.com/justinsb) [#4787](https://github.com/kubernetes/kops/pull/4787)
* Support for auth plugins in channels [@atopuzov](https://github.com/atopuzov) [#4765](https://github.com/kubernetes/kops/pull/4765)
* Dashboard : Fix CrashLoopBackOff (from K8S >= 1.8.10) [@schweizerbolzonello](https://github.com/schweizerbolzonello) [#4783](https://github.com/kubernetes/kops/pull/4783)
* etcd-quorum-read flag: explicitly default to off for v2 [@justinsb](https://github.com/justinsb) [#4792](https://github.com/kubernetes/kops/pull/4792)
* ElasticIP deletion: Honor shared tags [@justinsb](https://github.com/justinsb) [#4790](https://github.com/kubernetes/kops/pull/4790)
* NAT gateway deletion: honor shared tag [@justinsb](https://github.com/justinsb) [#4791](https://github.com/kubernetes/kops/pull/4791)
* Add simple sanity check for 4758 [@justinsb](https://github.com/justinsb) [#4794](https://github.com/kubernetes/kops/pull/4794)
* Add Cilium as CNI plugin [@nebril](https://github.com/nebril) [#4224](https://github.com/kubernetes/kops/pull/4224)
* Warn on VPC AdditionalCIDR changes [@justinsb](https://github.com/justinsb) [#4796](https://github.com/kubernetes/kops/pull/4796)
* kops release 1.9.0 alpha.3 [@justinsb](https://github.com/justinsb) [#4802](https://github.com/kubernetes/kops/pull/4802)
* fix some grammar mistakes [@jonyhy96](https://github.com/jonyhy96) [#4803](https://github.com/kubernetes/kops/pull/4803)
* fix some grammar mistakes [@jonyhy96](https://github.com/jonyhy96) [#4804](https://github.com/kubernetes/kops/pull/4804)
* kops toolbox dump: Add Subnets to dump [@justinsb](https://github.com/justinsb) [#4806](https://github.com/kubernetes/kops/pull/4806)
* apimachinery run to update generated files for EtcdQuorumRead flag [@KashifSaadat](https://github.com/KashifSaadat) [#4810](https://github.com/kubernetes/kops/pull/4810)
* Bump channels to 1.9.0-alpha.3 [@mikesplain](https://github.com/mikesplain) [#4812](https://github.com/kubernetes/kops/pull/4812)
* Typo fix defailt->default [@AdamDang](https://github.com/AdamDang) [#4811](https://github.com/kubernetes/kops/pull/4811)
* correct some small mistake [@sunlintong](https://github.com/sunlintong) [#4820](https://github.com/kubernetes/kops/pull/4820)
* fix a grammar mistake [@jonyhy96](https://github.com/jonyhy96) [#4829](https://github.com/kubernetes/kops/pull/4829)
* resolve conflict [@sunlintong](https://github.com/sunlintong) [#4841](https://github.com/kubernetes/kops/pull/4841)
* Bump ingress-nginx version to 0.12.0 [@tossmilestone](https://github.com/tossmilestone) [#4840](https://github.com/kubernetes/kops/pull/4840)
* Add AfterFiles dependencies to File tasks [@louismunro](https://github.com/louismunro) [#4760](https://github.com/kubernetes/kops/pull/4760)
* Update addon.go [@AdamDang](https://github.com/AdamDang) [#4846](https://github.com/kubernetes/kops/pull/4846)
* typo fix [@jonyhy96](https://github.com/jonyhy96) [#4845](https://github.com/kubernetes/kops/pull/4845)
* protokube: match device /root/dev/X as /dev/X [@justinsb](https://github.com/justinsb) [#4849](https://github.com/kubernetes/kops/pull/4849)
* Fix toolbox dump bug: store subnet in resource [@justinsb](https://github.com/justinsb) [#4848](https://github.com/kubernetes/kops/pull/4848)
* Add VPC to kops toolbox dump [@justinsb](https://github.com/justinsb) [#4805](https://github.com/kubernetes/kops/pull/4805)
* Typo fix in err messages [@AdamDang](https://github.com/AdamDang) [#4850](https://github.com/kubernetes/kops/pull/4850)
* Export kubernetes client metrics from dns-controller. [@tomwilkie](https://github.com/tomwilkie) [#4612](https://github.com/kubernetes/kops/pull/4612)
* AWS: etcd volume provisioned IOPS support [@sergeylanzman](https://github.com/sergeylanzman) [#4852](https://github.com/kubernetes/kops/pull/4852)
* digitalocean: external cloud controller addon [@andrewsykim](https://github.com/andrewsykim) [#4698](https://github.com/kubernetes/kops/pull/4698)
* Docs/update kube ingress aws controller security group walkthrough [@Jberlinsky](https://github.com/Jberlinsky) [#4843](https://github.com/kubernetes/kops/pull/4843)
* digitalocean: nodeup & protokube support [@andrewsykim](https://github.com/andrewsykim) [#4697](https://github.com/kubernetes/kops/pull/4697)
* Add DigitalOcean VFS  [@andrewsykim](https://github.com/andrewsykim) [#4858](https://github.com/kubernetes/kops/pull/4858)
* implement network task for OpenStack platform [@zengchen1024](https://github.com/zengchen1024) [#4830](https://github.com/kubernetes/kops/pull/4830)
* Add metrics-server addon [@itskingori](https://github.com/itskingori) [#4581](https://github.com/kubernetes/kops/pull/4581)
* Validation around IOPS fields [@sergeylanzman](https://github.com/sergeylanzman) [#4859](https://github.com/kubernetes/kops/pull/4859)
* add output support to terraform & cloudformation for iops volume [@sergeylanzman](https://github.com/sergeylanzman) [#4860](https://github.com/kubernetes/kops/pull/4860)
* add network builder [@zengchen1024](https://github.com/zengchen1024) [#4842](https://github.com/kubernetes/kops/pull/4842)
* update basic-requirements.md [@sunlintong](https://github.com/sunlintong) [#4864](https://github.com/kubernetes/kops/pull/4864)
* Typo fix in err message [@AdamDang](https://github.com/AdamDang) [#4870](https://github.com/kubernetes/kops/pull/4870)
* two spell mistake [@sunlintong](https://github.com/sunlintong) [#4865](https://github.com/kubernetes/kops/pull/4865)
* Typo fix in error message [@AdamDang](https://github.com/AdamDang) [#4869](https://github.com/kubernetes/kops/pull/4869)
* implement router task for OpenStack platform [@zengchen1024](https://github.com/zengchen1024) [#4868](https://github.com/kubernetes/kops/pull/4868)
* add proxy mode flag to kube-proxy [@sergeylanzman](https://github.com/sergeylanzman) [#4863](https://github.com/kubernetes/kops/pull/4863)
* Release 1.9.0-beta.1 [@justinsb](https://github.com/justinsb) [#4871](https://github.com/kubernetes/kops/pull/4871)
* spell dependencies --> dependencies [@sunlintong](https://github.com/sunlintong) [#4861](https://github.com/kubernetes/kops/pull/4861)
* Implement vfs with AlibabaCloud OSS [@ihac](https://github.com/ihac),[@xh4n3](https://github.com/xh4n3) [#4719](https://github.com/kubernetes/kops/pull/4719)
* Adding Mike and myself as reviewers [@robinpercy](https://github.com/robinpercy) [#4874](https://github.com/kubernetes/kops/pull/4874)
* Fix some info errors [@AdamDang](https://github.com/AdamDang) [#4876](https://github.com/kubernetes/kops/pull/4876)
* Typo fix in info message [@AdamDang](https://github.com/AdamDang) [#4872](https://github.com/kubernetes/kops/pull/4872)
* Fixes port collision between dns-controller metrics and gossip. [@tvi](https://github.com/tvi) [#4878](https://github.com/kubernetes/kops/pull/4878)
* removed sed from command to get AMI images [@roffe](https://github.com/roffe) [#4888](https://github.com/kubernetes/kops/pull/4888)
* spell correct [@sunlintong](https://github.com/sunlintong) [#4887](https://github.com/kubernetes/kops/pull/4887)
* correct spell in the code and the relative doc [@sunlintong](https://github.com/sunlintong) [#4886](https://github.com/kubernetes/kops/pull/4886)
* Don't enable dns-controller prometheus metrics by default [@justinsb](https://github.com/justinsb) [#4892](https://github.com/kubernetes/kops/pull/4892)
* Document the ports we use, to avoid conflicts [@justinsb](https://github.com/justinsb) [#4891](https://github.com/kubernetes/kops/pull/4891)
* update download_config.md [@sunlintong](https://github.com/sunlintong) [#4885](https://github.com/kubernetes/kops/pull/4885)
* fix spell mistakes in cluster_spec.md [@sunlintong](https://github.com/sunlintong) [#4884](https://github.com/kubernetes/kops/pull/4884)
* update two file [@sunlintong](https://github.com/sunlintong) [#4883](https://github.com/kubernetes/kops/pull/4883)
* digitalocean: support multiple droplets [@andrewsykim](https://github.com/andrewsykim) [#4881](https://github.com/kubernetes/kops/pull/4881)
* digitalocean: add kubelet hostname override [@andrewsykim](https://github.com/andrewsykim) [#4880](https://github.com/kubernetes/kops/pull/4880)
* typo fix [@jonyhy96](https://github.com/jonyhy96) [#4879](https://github.com/kubernetes/kops/pull/4879)
* fix go vet error from util/pkg/vfs/ossfs.go [@andrewsykim](https://github.com/andrewsykim) [#4898](https://github.com/kubernetes/kops/pull/4898)
* Fix LDFLAGS for all future go1.10.* versions [@mikesplain](https://github.com/mikesplain) [#4896](https://github.com/kubernetes/kops/pull/4896)
* digitalocean: dns operations should be idempotent [@andrewsykim](https://github.com/andrewsykim) [#4882](https://github.com/kubernetes/kops/pull/4882)
* coreos/containeros: restart kops-configuration service after docker drop-in is loaded [@andrewsykim](https://github.com/andrewsykim) [#4894](https://github.com/kubernetes/kops/pull/4894)
* update vsphere-development-status.md [@sunlintong](https://github.com/sunlintong) [#4905](https://github.com/kubernetes/kops/pull/4905)
* three spell mistakes [@sunlintong](https://github.com/sunlintong) [#4904](https://github.com/kubernetes/kops/pull/4904)
* add String method for OSSFS to fix go vet issue [@xh4n3](https://github.com/xh4n3) [#4901](https://github.com/kubernetes/kops/pull/4901)
* three spell mistakes [@sunlintong](https://github.com/sunlintong) [#4902](https://github.com/kubernetes/kops/pull/4902)
* Release 1.9.0-beta.2 [@justinsb](https://github.com/justinsb) [#4907](https://github.com/kubernetes/kops/pull/4907)
* Updating API Machinery [@chrislovecnm](https://github.com/chrislovecnm) [#4911](https://github.com/kubernetes/kops/pull/4911)
* protokube: also check for device symlinks [@andrewsykim](https://github.com/andrewsykim) [#4915](https://github.com/kubernetes/kops/pull/4915)
* digitalocean: list/delete resources [@andrewsykim](https://github.com/andrewsykim) [#4916](https://github.com/kubernetes/kops/pull/4916)
* Update channels to 1.9.0-beta.2 [@mikesplain](https://github.com/mikesplain) [#4933](https://github.com/kubernetes/kops/pull/4933)
* Fix typo in api_updates [@mikesplain](https://github.com/mikesplain) [#4932](https://github.com/kubernetes/kops/pull/4932)
* Typo fix an->and [@AdamDang](https://github.com/AdamDang) [#4930](https://github.com/kubernetes/kops/pull/4930)
* Add go 1.10 testing to travis CI [@tvi](https://github.com/tvi) [#4926](https://github.com/kubernetes/kops/pull/4926)
* digitalocean: use pagination for all list requests [@andrewsykim](https://github.com/andrewsykim) [#4923](https://github.com/kubernetes/kops/pull/4923)
* Fix spelling [@inthecloud247](https://github.com/inthecloud247) [#4939](https://github.com/kubernetes/kops/pull/4939)
* Fix grammar mistake [@mycapatin](https://github.com/mycapatin) [#4936](https://github.com/kubernetes/kops/pull/4936)
* Update the recommended Ubuntu Image [@ofersadgat](https://github.com/ofersadgat) [#4934](https://github.com/kubernetes/kops/pull/4934)
* Typo fix dont'->don't [@AdamDang](https://github.com/AdamDang) [#4929](https://github.com/kubernetes/kops/pull/4929)
* Update rules go and use more recent debian snapshot [@mikesplain](https://github.com/mikesplain) [#4948](https://github.com/kubernetes/kops/pull/4948)
* fix typo [@mycapatin](https://github.com/mycapatin) [#4943](https://github.com/kubernetes/kops/pull/4943)
* digitalocean: external cloud controller manager avoid circular dependencies [@andrewsykim](https://github.com/andrewsykim) [#4947](https://github.com/kubernetes/kops/pull/4947)
* implement subnet task for OpenStack platform [@zengchen1024](https://github.com/zengchen1024) [#4945](https://github.com/kubernetes/kops/pull/4945)
* Add warning about google cloud repository versions [@tombull](https://github.com/tombull) [#4944](https://github.com/kubernetes/kops/pull/4944)
* fix version of kube-router at v0.1.0 [@andrewsykim](https://github.com/andrewsykim) [#4935](https://github.com/kubernetes/kops/pull/4935)
* Configurable log level for calico [@edmeister](https://github.com/edmeister) [#4928](https://github.com/kubernetes/kops/pull/4928)
* addons/cluster-autoscaler: Added healthchecks. [@jpds](https://github.com/jpds) [#4925](https://github.com/kubernetes/kops/pull/4925)
* addons/cluster-autoscaler: Annotate for Prometheus by default. [@jpds](https://github.com/jpds) [#4922](https://github.com/kubernetes/kops/pull/4922)
* Feature/4920 add authorization mode flag [@chrisz100](https://github.com/chrisz100) [#4924](https://github.com/kubernetes/kops/pull/4924)
* Add configurable dnsmasq params to KubeDNS [@jamesmcminn96](https://github.com/jamesmcminn96) [#4919](https://github.com/kubernetes/kops/pull/4919)
* Update kube-dns to 1.14.9 [@sergeylanzman](https://github.com/sergeylanzman) [#4851](https://github.com/kubernetes/kops/pull/4851)
* Avoid collisions in IAM ids [@justinsb](https://github.com/justinsb) [#4952](https://github.com/kubernetes/kops/pull/4952)
* Disable locksmithd on CoreOS if UpdatePolicy set [@KashifSaadat](https://github.com/KashifSaadat) [#4909](https://github.com/kubernetes/kops/pull/4909)
* Pod Security Policies [@gambol99](https://github.com/gambol99) [#3498](https://github.com/kubernetes/kops/pull/3498)
* Fix etcd Keypair change showing on every kops update when TLS enabled [@KashifSaadat](https://github.com/KashifSaadat) [#4957](https://github.com/kubernetes/kops/pull/4957)
* Only do etcd backups on main [@justinsb](https://github.com/justinsb) [#4959](https://github.com/kubernetes/kops/pull/4959)
* Bump Weave Net to 2.3.0 [@brb](https://github.com/brb) [#4954](https://github.com/kubernetes/kops/pull/4954)
* Ignore shared-ownership tags on volumes [@justinsb](https://github.com/justinsb) [#4960](https://github.com/kubernetes/kops/pull/4960)
