## Release notes for kops 1.15 series

(The kops 1.15 release has not been released yet, this is a document to gather the notes prior to the release).

# Breaking changes

The kops apiGroup is changing from `kops` to `kops.k8s.io`, which means that
downgrading to kops 1.14 after upgrading to kops 1.15 will not recognize the
newer objects.  (In general it's better not to mix kops versions, but it is more
visible here.)  Please back up your manifest files using `kops get <clustername>
-oyaml` before upgrading, if the need arises these can later be restored with
kops 1.14 with `kops replace -f`.

It should also be possibe to rewrite the apiGroup fom `kops` to `kops.k8s.io` on
a yaml backup using `sed` or a similar tool, but taking a precautionary backup
is safer.


# Significant changes

* kops now supports running with objects as CRDs, stored in a kubernetes apiserver.
* The apiGroup for kops objects has changed from `kops` to `kops.k8s.io`, to
  support CRDs.  You can continue to provide either apiGroup as input (but you
  should ideally move to `kops.k8s.io`), but the output will always be of the
  `kops.k8s.io` form.
* Rolling updates are much faster by default.  A lot of the time-padding that
  was in previous versions has been replaced with reliance on validation.  The
  `--cloudonly` case is much faster than previously, which we believe to be
  correct because we expect this is normally for disaster-recovery scenarios,
  but you may want to specify longer timings via flags if you are relying on
  time-based delays.

# Required Actions

* If checking the output as a string (yaml or json), please note that the
  apiGroup will now be kops.k8s.io, not kops.  If performing strict string
  comparison you will need to update your expected values.

* Kubernetes 1.9 users will need to enable the PodPriority feature gate. This is required for newer versions of Kops.

  To enable the Pod priority feature, follow these steps:
  ```
  kops edit cluster
  # Add the following section
  spec:
    kubelet:
      featureGates:
        PodPriority: "true"
  ```
 
# Full change list since 1.14.0 release

## kops 1.14.0-beta.2 to 1.15.0-alpha.1

* Release 1.14.0-alpha.1 [@justinsb](https://github.com/justinsb) [#6772](https://github.com/kubernetes/kops/pull/6772)
* Put 1.13 and 1.14 into channels [@justinsb](https://github.com/justinsb) [#6781](https://github.com/kubernetes/kops/pull/6781)
* 1.12 release notes: populate list of PRs [@justinsb](https://github.com/justinsb) [#6780](https://github.com/kubernetes/kops/pull/6780)
* Carry Provisioned IOPS to Terraform and CloudFormation templates [@mmailhos](https://github.com/mmailhos) [#6776](https://github.com/kubernetes/kops/pull/6776)
* pin nvidia-docker2 version to avoid installation failure [@adrianlyjak](https://github.com/adrianlyjak) [#6768](https://github.com/kubernetes/kops/pull/6768)
* pkg/model: Fix dropped error [@alrs](https://github.com/alrs) [#6769](https://github.com/kubernetes/kops/pull/6769)
* Using const() defines constants together (part:1) [@alrs](https://github.com/alrs),[@xichengliudui](https://github.com/xichengliudui) [#6789](https://github.com/kubernetes/kops/pull/6789)
* Using const() defines constants together (part:3) [@xichengliudui](https://github.com/xichengliudui) [#6791](https://github.com/kubernetes/kops/pull/6791)
* Update rules go [@mikesplain](https://github.com/mikesplain) [#6766](https://github.com/kubernetes/kops/pull/6766)
* Update etcd3-migration.md doc [@bksteiny](https://github.com/bksteiny),[@mikesplain](https://github.com/mikesplain) [#6774](https://github.com/kubernetes/kops/pull/6774)
* KubeAPIServer HTTP2 Stream Parameter [@gambol99](https://github.com/gambol99) [#6787](https://github.com/kubernetes/kops/pull/6787)
* Refactor names of URLs in assets to clarify their purpose [@justinsb](https://github.com/justinsb) [#6420](https://github.com/kubernetes/kops/pull/6420)
* Update docker README.md file, delete `$` [@xichengliudui](https://github.com/xichengliudui) [#6802](https://github.com/kubernetes/kops/pull/6802)
* Switch to golang 1.11.5 [@justinsb](https://github.com/justinsb) [#6798](https://github.com/kubernetes/kops/pull/6798)
* Switch to golang 1.12.1 [@justinsb](https://github.com/justinsb) [#6799](https://github.com/kubernetes/kops/pull/6799)
* Using const() defines constants together (part:3) [@xichengliudui](https://github.com/xichengliudui) [#6809](https://github.com/kubernetes/kops/pull/6809)
* Using const() defines constants together (part:4) [@xichengliudui](https://github.com/xichengliudui) [#6810](https://github.com/kubernetes/kops/pull/6810)
* [docs] Use env var for state store examples [@elithrar](https://github.com/elithrar) [#6278](https://github.com/kubernetes/kops/pull/6278)
* Update README.md [@wangxy518](https://github.com/wangxy518) [#6820](https://github.com/kubernetes/kops/pull/6820)
* set kubernetes version to 1.12.8 to match current release [@chrisz100](https://github.com/chrisz100) [#6833](https://github.com/kubernetes/kops/pull/6833)
* Canal manifest updates for k8s v1.12+ [@KashifSaadat](https://github.com/KashifSaadat) [#6823](https://github.com/kubernetes/kops/pull/6823)
* Update readme chart given alphas and betas [@mikesplain](https://github.com/mikesplain) [#6836](https://github.com/kubernetes/kops/pull/6836)
* Fix typo in aws-iam-authenticator image field name [@rifelpet](https://github.com/rifelpet) [#6840](https://github.com/kubernetes/kops/pull/6840)
* Remove verify bazel and expose error [@mikesplain](https://github.com/mikesplain) [#6841](https://github.com/kubernetes/kops/pull/6841)
* Add t3a family [@mikesplain](https://github.com/mikesplain) [#6837](https://github.com/kubernetes/kops/pull/6837)
* Add support for AWS ap-east-1 region [@wxdao](https://github.com/wxdao) [#6835](https://github.com/kubernetes/kops/pull/6835)
* update tolerations to openstack external cloud provider [@zetaab](https://github.com/zetaab) [#6821](https://github.com/kubernetes/kops/pull/6821)
* [Unit Tests] Add unit tests for create_kubecfg file [@srikiz](https://github.com/srikiz) [#6826](https://github.com/kubernetes/kops/pull/6826)
* Protect against nil derefence [@justinsb](https://github.com/justinsb) [#6859](https://github.com/kubernetes/kops/pull/6859)
* Support Scale from 0 with Lauch Templates [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#6861](https://github.com/kubernetes/kops/pull/6861)
* Remove spurious cadvisor dependency [@justinsb](https://github.com/justinsb) [#6860](https://github.com/kubernetes/kops/pull/6860)
* makefile: add gazelle alias for bazel-gazelle [@justinsb](https://github.com/justinsb) [#6876](https://github.com/kubernetes/kops/pull/6876)
* bazel: fix distroless imports for latest bazel [@justinsb](https://github.com/justinsb) [#6877](https://github.com/kubernetes/kops/pull/6877)
* Update kubernetes dependencies to k8s 1.13.5 [@justinsb](https://github.com/justinsb) [#6857](https://github.com/kubernetes/kops/pull/6857)
* Switch from glog to klog [@justinsb](https://github.com/justinsb) [#6878](https://github.com/kubernetes/kops/pull/6878)
* travis: Remove go-vet and boilerplate checking [@justinsb](https://github.com/justinsb) [#6882](https://github.com/kubernetes/kops/pull/6882)
* Use existing SSHKeyName if no public key is created. [@rralcala](https://github.com/rralcala) [#6886](https://github.com/kubernetes/kops/pull/6886)
* Start CRDification: Change apigroup to kops.k8s.io [@justinsb](https://github.com/justinsb) [#6887](https://github.com/kubernetes/kops/pull/6887)
* Simply bazel test using exclude pattern [@justinsb](https://github.com/justinsb) [#6896](https://github.com/kubernetes/kops/pull/6896)
* Include aws-cloud-provider roles in 1.15 [@justinsb](https://github.com/justinsb) [#6899](https://github.com/kubernetes/kops/pull/6899)
* Fix machine types with klog [@mikesplain](https://github.com/mikesplain) [#6890](https://github.com/kubernetes/kops/pull/6890)
* Avoid concurrent write corruption to /etc/hosts [@justinsb](https://github.com/justinsb) [#6893](https://github.com/kubernetes/kops/pull/6893)
* Add i3en instance types [@mikesplain](https://github.com/mikesplain) [#6898](https://github.com/kubernetes/kops/pull/6898)
* Fix typo in docker healthcheck [@TristanPeers](https://github.com/TristanPeers) [#6901](https://github.com/kubernetes/kops/pull/6901)
* Update to etcd-manager 1.0.20190509 [@justinsb](https://github.com/justinsb) [#6917](https://github.com/kubernetes/kops/pull/6917)
* Call klog.InitFlags in dns-controller [@justinsb](https://github.com/justinsb) [#6925](https://github.com/kubernetes/kops/pull/6925)
* Use klog logging from 1.15 [@justinsb](https://github.com/justinsb) [#6924](https://github.com/kubernetes/kops/pull/6924)
* S3 VFS: Default to current region from metadata service [@justinsb](https://github.com/justinsb) [#6943](https://github.com/kubernetes/kops/pull/6943)
* Canal v3.7.2 for k8s v1.12+ [@KashifSaadat](https://github.com/KashifSaadat) [#6950](https://github.com/kubernetes/kops/pull/6950)
* Subnet Update Consistency [@drekle](https://github.com/drekle) [#6941](https://github.com/kubernetes/kops/pull/6941)
* Configure AMIs for 1.12 [@justinsb](https://github.com/justinsb) [#6963](https://github.com/kubernetes/kops/pull/6963)
* Fix Docker not being installed on Ubuntu 16.04 [@mfrister](https://github.com/mfrister) [#6965](https://github.com/kubernetes/kops/pull/6965)
* bumped k8s 1.11 versions to 1.11.10 in alpha channel [@idealhack](https://github.com/idealhack) [#6969](https://github.com/kubernetes/kops/pull/6969)
* Issue #6945 [@pkutishch](https://github.com/pkutishch) [#6951](https://github.com/kubernetes/kops/pull/6951)
* Generate CRDs for kops API types [@justinsb](https://github.com/justinsb) [#6891](https://github.com/kubernetes/kops/pull/6891)
* etcd-manager: Update to 3.0.20190513 [@justinsb](https://github.com/justinsb) [#6959](https://github.com/kubernetes/kops/pull/6959)
* add node-exporter to allowed ports [@zetaab](https://github.com/zetaab) [#6944](https://github.com/kubernetes/kops/pull/6944)
* Make gofmt fails find usage [@drekle](https://github.com/drekle) [#6954](https://github.com/kubernetes/kops/pull/6954)
* Update commitlog relnotes for 1.12.0 [@justinsb](https://github.com/justinsb) [#6981](https://github.com/kubernetes/kops/pull/6981)
* 1.12 highlight changelog [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#6982](https://github.com/kubernetes/kops/pull/6982)
* Mention version of Kops that introduced new features [@rifelpet](https://github.com/rifelpet) [#6983](https://github.com/kubernetes/kops/pull/6983)
* Terraform: fix options field, should be spot_options [@kimxogus](https://github.com/kimxogus) [#6988](https://github.com/kubernetes/kops/pull/6988)
* Add shortNames and columns to InstanceGroup CRD [@justinsb](https://github.com/justinsb) [#6995](https://github.com/kubernetes/kops/pull/6995)
* Add script to verify CRD generation [@justinsb](https://github.com/justinsb) [#6996](https://github.com/kubernetes/kops/pull/6996)
* Update README.md to reflect 1.12 release [@natebwangsut](https://github.com/natebwangsut) [#7002](https://github.com/kubernetes/kops/pull/7002)
* add kops instancegroup tag to metadata [@zetaab](https://github.com/zetaab) [#6991](https://github.com/kubernetes/kops/pull/6991)
* Don't panic when deleting instancegroups [@justinsb](https://github.com/justinsb) [#7000](https://github.com/kubernetes/kops/pull/7000)
* Support using kops CLI with CRDs [@justinsb](https://github.com/justinsb) [#7006](https://github.com/kubernetes/kops/pull/7006)
* etcd-manager: update to 3.0.20190516 [@justinsb](https://github.com/justinsb) [#7007](https://github.com/kubernetes/kops/pull/7007)
* VPC cleanup: recognize the error code for concurrent VPC deletion [@justinsb](https://github.com/justinsb) [#7008](https://github.com/kubernetes/kops/pull/7008)
* Recommend kops 1.12.1 [@justinsb](https://github.com/justinsb) [#7023](https://github.com/kubernetes/kops/pull/7023)
* Add relnotes list for 1.12.1 [@justinsb](https://github.com/justinsb) [#7022](https://github.com/kubernetes/kops/pull/7022)
* Makefile: keep go vet simple [@justinsb](https://github.com/justinsb) [#7030](https://github.com/kubernetes/kops/pull/7030)
* Update go_version to 1.12.5 [@justinsb](https://github.com/justinsb) [#7035](https://github.com/kubernetes/kops/pull/7035)
* Start relnotes for 1.13 and 1.14 [@justinsb](https://github.com/justinsb) [#7037](https://github.com/kubernetes/kops/pull/7037)
* Speed up rolling-update - longer timeout on validation, less scheduled holds [@justinsb](https://github.com/justinsb) [#6747](https://github.com/kubernetes/kops/pull/6747)
* Update stretch dependencies and kubeup [@mikesplain](https://github.com/mikesplain) [#7041](https://github.com/kubernetes/kops/pull/7041)
* Bump alpha-channel of k8s [@justinsb](https://github.com/justinsb) [#7038](https://github.com/kubernetes/kops/pull/7038)
* Fix machine empheral disks [@mikesplain](https://github.com/mikesplain) [#7062](https://github.com/kubernetes/kops/pull/7062)
* Add docs for cpuCFSQuota / cpuCFSQuotaPeriod [@thomaspeitz](https://github.com/thomaspeitz) [#7074](https://github.com/kubernetes/kops/pull/7074)
* implement append admission controllers [@zetaab](https://github.com/zetaab) [#7070](https://github.com/kubernetes/kops/pull/7070)
* Add documentation for etcd-manager backup/restore procedures [@dzoeteman](https://github.com/dzoeteman) [#7072](https://github.com/kubernetes/kops/pull/7072)
* Fix typo on node-authorizer prometheus metric [@KashifSaadat](https://github.com/KashifSaadat) [#7080](https://github.com/kubernetes/kops/pull/7080)
* Openstack delete dynamic floating ip in delete cluster  [@drekle](https://github.com/drekle) [#7045](https://github.com/kubernetes/kops/pull/7045)
* Updated docs for openstack cloud provider. [@prankul88](https://github.com/prankul88) [#7092](https://github.com/kubernetes/kops/pull/7092)
* Change versions to fix memory.limit_in_bytes: device or resource busy [@flouthoc](https://github.com/flouthoc) [#7067](https://github.com/kubernetes/kops/pull/7067)
* K8s 1.12.8 to stable 1.12.9 to alpha [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#7090](https://github.com/kubernetes/kops/pull/7090)
* Fix link to Calico route reflectors documentation + typo [@Misdre](https://github.com/Misdre) [#7088](https://github.com/kubernetes/kops/pull/7088)
* Mark ENI 0 as delete_on_termination for LaunchTemplates [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#7094](https://github.com/kubernetes/kops/pull/7094)
* Add Debian 10 (buster) support [@zetaab](https://github.com/zetaab) [#7071](https://github.com/kubernetes/kops/pull/7071)
* Openstack support for rolling-update status [@drekle](https://github.com/drekle) [#7050](https://github.com/kubernetes/kops/pull/7050)
* Upgrade AWS VPC CNI provider to 1.5.0 [@rifelpet](https://github.com/rifelpet) [#7122](https://github.com/kubernetes/kops/pull/7122)
* Documentation Cleanup [@rifelpet](https://github.com/rifelpet) [#7123](https://github.com/kubernetes/kops/pull/7123)
* Adding affinity and PDB to dns. [@michalschott](https://github.com/michalschott) [#7077](https://github.com/kubernetes/kops/pull/7077)
* bumped k8s 1.11 versions to 1.11.10 in stable channel [@idealhack](https://github.com/idealhack) [#6984](https://github.com/kubernetes/kops/pull/6984)
* Add support for SpotPrice and Mixed Instance ASGs [@rifelpet](https://github.com/rifelpet) [#7066](https://github.com/kubernetes/kops/pull/7066)
* support apiserver admission-control-config-file flag [@r0fls](https://github.com/r0fls) [#7109](https://github.com/kubernetes/kops/pull/7109)
* updated link to kubernetes bot commands [@opowbow](https://github.com/opowbow) [#7144](https://github.com/kubernetes/kops/pull/7144)
* typo fix: fix kops-server-push -> make kops-server-push [@Sn0rt](https://github.com/Sn0rt) [#7150](https://github.com/kubernetes/kops/pull/7150)
* Add rdrgmnzs to the approvers list in OWNERS [@rdrgmnzs](https://github.com/rdrgmnzs) [#7154](https://github.com/kubernetes/kops/pull/7154)
* Flatcar support [@mazzy89](https://github.com/mazzy89) [#7084](https://github.com/kubernetes/kops/pull/7084)
* Don't precreate etcd DNS records if we're using etcd-manager [@rifelpet](https://github.com/rifelpet) [#7141](https://github.com/kubernetes/kops/pull/7141)
* Update Docs for Calico Backend for kops 1.12 [@gjtempleton](https://github.com/gjtempleton) [#7164](https://github.com/kubernetes/kops/pull/7164)
* Update Canal to v3.7.3 [@KashifSaadat](https://github.com/KashifSaadat) [#7169](https://github.com/kubernetes/kops/pull/7169)
* Improve docs on labels [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#7139](https://github.com/kubernetes/kops/pull/7139)
* Allow user to set the --kube-api-qps and --kube-api-burst flags on KubeControllerManager [@rdrgmnzs](https://github.com/rdrgmnzs) [#7153](https://github.com/kubernetes/kops/pull/7153)
* Egress proxy for etcd manager [@austinmoore-](https://github.com/austinmoore-) [#7103](https://github.com/kubernetes/kops/pull/7103)
* [Unit Tests] Added unit test for kube proxy builder [@srikiz](https://github.com/srikiz) [#7124](https://github.com/kubernetes/kops/pull/7124)
* add c5.12xlarge, c5.24xlarge, c5.metal, i3en.metal [@rekcah78](https://github.com/rekcah78) [#7166](https://github.com/kubernetes/kops/pull/7166)
* Simplify `go test` command [@justinsb](https://github.com/justinsb) [#7003](https://github.com/kubernetes/kops/pull/7003)
* Spotinst: New instance group type: Ocean [@liranp](https://github.com/liranp) [#7040](https://github.com/kubernetes/kops/pull/7040)
* Fix the link to the Prow commands. [@cjwagner](https://github.com/cjwagner) [#7162](https://github.com/kubernetes/kops/pull/7162)
* add masterPublicName support in kops set cluster [@camilosantana](https://github.com/camilosantana) [#7160](https://github.com/kubernetes/kops/pull/7160)
* Update aws-iam-authenticator image to 0.4.0 [@rifelpet](https://github.com/rifelpet) [#6803](https://github.com/kubernetes/kops/pull/6803)
* Added some changes to openstack.md file [@prankul88](https://github.com/prankul88) [#6985](https://github.com/kubernetes/kops/pull/6985)
* Relnotes for 1.12.2 [@justinsb](https://github.com/justinsb) [#7174](https://github.com/kubernetes/kops/pull/7174)
* Add updated 1.12 image to the alpha channel [@justinsb](https://github.com/justinsb) [#7176](https://github.com/kubernetes/kops/pull/7176)
* Instance protection [@mikesplain](https://github.com/mikesplain) [#7177](https://github.com/kubernetes/kops/pull/7177)
* Remove kube-proxy resource-container flag [@justinsb](https://github.com/justinsb) [#7224](https://github.com/kubernetes/kops/pull/7224)
* Drop missing sources when building utils image [@KashifSaadat](https://github.com/KashifSaadat) [#7217](https://github.com/kubernetes/kops/pull/7217)
* goimports update [@KashifSaadat](https://github.com/KashifSaadat) [#7218](https://github.com/kubernetes/kops/pull/7218)
* Add more debug info for when cluster path doesnt match [@jayunit100](https://github.com/jayunit100) [#7202](https://github.com/kubernetes/kops/pull/7202)
* Canal v3.7.4 [@KashifSaadat](https://github.com/KashifSaadat) [#7206](https://github.com/kubernetes/kops/pull/7206)
* Upgrade Calico to 3.7.2 [@asincu](https://github.com/asincu) [#7051](https://github.com/kubernetes/kops/pull/7051)
* Spotinst: Ocean's Strategy object is optional [@liranp](https://github.com/liranp) [#7183](https://github.com/kubernetes/kops/pull/7183)
* update instances list with make update-machine-types [@rekcah78](https://github.com/rekcah78) [#7195](https://github.com/kubernetes/kops/pull/7195)
* Possibility to use OpenStack without lbaas (loadbalancer) [@zetaab](https://github.com/zetaab) [#7178](https://github.com/kubernetes/kops/pull/7178)
* Clear append admission plugins before inserting flags to kube-apiserver [@zetaab](https://github.com/zetaab) [#7182](https://github.com/kubernetes/kops/pull/7182)
* Use NodeAuthorizer config options instead of soely hard-codes [@jacksontj](https://github.com/jacksontj) [#7211](https://github.com/kubernetes/kops/pull/7211)
* doc: support to debug kops-apiserver [@Sn0rt](https://github.com/Sn0rt) [#7151](https://github.com/kubernetes/kops/pull/7151)
* GCE tutorial markdown formatting [@flaviamissi](https://github.com/flaviamissi) [#7188](https://github.com/kubernetes/kops/pull/7188)
* Make an actual deep-copy of the state [@jacksontj](https://github.com/jacksontj) [#7219](https://github.com/kubernetes/kops/pull/7219)
* Set priority for static pods [@vainu-arto](https://github.com/vainu-arto) [#6897](https://github.com/kubernetes/kops/pull/6897)
* Allow setting Limit & Request for aws-iam-authenticator [@rdrgmnzs](https://github.com/rdrgmnzs) [#7260](https://github.com/kubernetes/kops/pull/7260)
* Delete the function keyword to prevent shellcheck from failing [@xichengliudui](https://github.com/xichengliudui) [#6811](https://github.com/kubernetes/kops/pull/6811)
* Bumping calico to 3.7.4. [@michalschott](https://github.com/michalschott) [#7249](https://github.com/kubernetes/kops/pull/7249)
* Update metrics server image [@elisiano](https://github.com/elisiano) [#6871](https://github.com/kubernetes/kops/pull/6871)
* Use readinessProbe for weave-net instead of livenessProbe [@ReillyProcentive](https://github.com/ReillyProcentive) [#7102](https://github.com/kubernetes/kops/pull/7102)
* Add some permissions to cluster-autoscaler clusterrole [@Coolknight](https://github.com/Coolknight) [#7248](https://github.com/kubernetes/kops/pull/7248)
* Spotinst: Rolling update always reports NeedsUpdate [@liranp](https://github.com/liranp) [#7251](https://github.com/kubernetes/kops/pull/7251)
* Add documentation example for running Kops in a CI environment [@rifelpet](https://github.com/rifelpet) [#7256](https://github.com/kubernetes/kops/pull/7256)
* Calico -> 3.7.4 for older versions [@justinsb](https://github.com/justinsb) [#7282](https://github.com/kubernetes/kops/pull/7282)
* [Issue-7148] Legacyetcd support for Digital Ocean [@srikiz](https://github.com/srikiz) [#7221](https://github.com/kubernetes/kops/pull/7221)
* Stop .gitignoring all files named go-bindata [@justinsb](https://github.com/justinsb) [#7288](https://github.com/kubernetes/kops/pull/7288)
* Create hack/update-expected.sh to update test output [@justinsb](https://github.com/justinsb) [#7291](https://github.com/kubernetes/kops/pull/7291)
* replace behavior for @aws hostnameOverride [@jacksontj](https://github.com/jacksontj) [#7185](https://github.com/kubernetes/kops/pull/7185)
* Rhel8 support [@cassandracomar](https://github.com/cassandracomar) [#7287](https://github.com/kubernetes/kops/pull/7287)
* Update DigitalOcean CCM to v0.1.16 [@timoreimann](https://github.com/timoreimann) [#7293](https://github.com/kubernetes/kops/pull/7293)
* Replace use of cmdutil IsFilenameSliceEmpty [@justinsb](https://github.com/justinsb) [#7289](https://github.com/kubernetes/kops/pull/7289)
* GCE: support ipalias networking mode, named "gce" [@justinsb](https://github.com/justinsb) [#6229](https://github.com/kubernetes/kops/pull/6229)
* Move NTP and misc packages initialization to code [@justinsb](https://github.com/justinsb) [#6236](https://github.com/kubernetes/kops/pull/6236)
* Machine types fix [@mikesplain](https://github.com/mikesplain) [#7300](https://github.com/kubernetes/kops/pull/7300)
* Improve channel updates [@granular-ryanbonham](https://github.com/granular-ryanbonham),[@justinsb](https://github.com/justinsb) [#7133](https://github.com/kubernetes/kops/pull/7133)
* Rationalize golden-output comparison [@justinsb](https://github.com/justinsb) [#7290](https://github.com/kubernetes/kops/pull/7290)
* hack/update-expected: regenerate gobindata [@justinsb](https://github.com/justinsb) [#7311](https://github.com/kubernetes/kops/pull/7311)
* Add me as reviewer [@granular-ryanbonham](https://github.com/granular-ryanbonham) [#7313](https://github.com/kubernetes/kops/pull/7313)
* Update Calico to v3.8.0 [@tmjd](https://github.com/tmjd) [#7257](https://github.com/kubernetes/kops/pull/7257)
* Manifest hashing: move trimming out of hash function [@justinsb](https://github.com/justinsb) [#7312](https://github.com/kubernetes/kops/pull/7312)
* Adding documentation to mitigate workload outages on AWS [@endzyme](https://github.com/endzyme) [#7292](https://github.com/kubernetes/kops/pull/7292)
* Mount FlexVolume directory in kube-controller-manager pod [@kellanburket](https://github.com/kellanburket) [#6874](https://github.com/kubernetes/kops/pull/6874)
* remove code: remove kops-server chart [@Sn0rt](https://github.com/Sn0rt) [#7324](https://github.com/kubernetes/kops/pull/7324)
* Bump alpha channel with latest kubernetes versions [@justinsb](https://github.com/justinsb) [#7338](https://github.com/kubernetes/kops/pull/7338)
* Default etcd-version to 3.3.10 for >= 1.14 [@justinsb](https://github.com/justinsb) [#7341](https://github.com/kubernetes/kops/pull/7341)
* Warn/prevent if the version of etcd is unsupported with etcd-manager [@justinsb](https://github.com/justinsb) [#7340](https://github.com/kubernetes/kops/pull/7340)
* Update Image version and RBAC for Citrix Ingress Controller [@christus02](https://github.com/christus02) [#7335](https://github.com/kubernetes/kops/pull/7335)
* Promote k8s 1.12.9 from alpha -> stable [@justinsb](https://github.com/justinsb) [#7337](https://github.com/kubernetes/kops/pull/7337)
* Update repo-infra and distroless for bazel fixes [@rifelpet](https://github.com/rifelpet) [#7348](https://github.com/kubernetes/kops/pull/7348)
* Cross-Zone Load Balancing for API ELB [@austinmoore-](https://github.com/austinmoore-) [#6958](https://github.com/kubernetes/kops/pull/6958)
* stop kubelet to prevent orphan containers [@qqshfox](https://github.com/qqshfox) [#7345](https://github.com/kubernetes/kops/pull/7345)
* Update default flexvolumepath for COS [@justinsb](https://github.com/justinsb) [#7339](https://github.com/kubernetes/kops/pull/7339)
* Promote 1.12 image from alpha to stable [@idealhack](https://github.com/idealhack) [#7343](https://github.com/kubernetes/kops/pull/7343)
* Update kube-router to 0.3.1 [@combor](https://github.com/combor) [#7317](https://github.com/kubernetes/kops/pull/7317)
* Enable scraping of weave metrics [@zacblazic](https://github.com/zacblazic) [#7326](https://github.com/kubernetes/kops/pull/7326)
* Bump etcd-manager to 3.0.20190801 [@justinsb](https://github.com/justinsb) [#7349](https://github.com/kubernetes/kops/pull/7349)
* Add mappings for Webhook authorization mode. [@anderseknert](https://github.com/anderseknert) [#7344](https://github.com/kubernetes/kops/pull/7344)
* Set and mount the correct volume plugin dir based on OS [@KashifSaadat](https://github.com/KashifSaadat) [#7355](https://github.com/kubernetes/kops/pull/7355)
*  Don't default adding MIMEBOUNDARY headers when a mixed instances policy is set [@KashifSaadat](https://github.com/KashifSaadat) [#7370](https://github.com/kubernetes/kops/pull/7370)
* Add release notes for 1.13.0 beta.2 -> 1.13.0 [@justinsb](https://github.com/justinsb) [#7372](https://github.com/kubernetes/kops/pull/7372)
* Release notes for 1.12.2 -> 1.12.3 [@justinsb](https://github.com/justinsb) [#7373](https://github.com/kubernetes/kops/pull/7373)
* correct typo in output message [@beautytiger](https://github.com/beautytiger) [#7380](https://github.com/kubernetes/kops/pull/7380)
* Remove extraneous note in 1.13 release notes [@rifelpet](https://github.com/rifelpet) [#7374](https://github.com/kubernetes/kops/pull/7374)
* protokube/gce_volume.go: error info correction [@beautytiger](https://github.com/beautytiger) [#7382](https://github.com/kubernetes/kops/pull/7382)
* cleanup: client.go error message words correction [@beautytiger](https://github.com/beautytiger) [#7394](https://github.com/kubernetes/kops/pull/7394)
* awstasks: fix misspelled words in logging. [@beautytiger](https://github.com/beautytiger) [#7412](https://github.com/kubernetes/kops/pull/7412)
* AWS SDK v1.23.0 [@gjtempleton](https://github.com/gjtempleton) [#7404](https://github.com/kubernetes/kops/pull/7404)
* Update Compatibility Table in Readme [@austinorth](https://github.com/austinorth) [#7408](https://github.com/kubernetes/kops/pull/7408)
* Add maxPersistentVolumes to support the KUBE_MAX_PD_VOLS scheduler setting [@ripta](https://github.com/ripta) [#7346](https://github.com/kubernetes/kops/pull/7346)
* add zetaab as reviewer [@zetaab](https://github.com/zetaab) [#7403](https://github.com/kubernetes/kops/pull/7403)
* Support mirroring for nodeup also [@justinsb](https://github.com/justinsb) [#7377](https://github.com/kubernetes/kops/pull/7377)
* Use Cluster Proportional Autoscaler for CoreDNS 1.12+ [@gjtempleton](https://github.com/gjtempleton) [#7400](https://github.com/kubernetes/kops/pull/7400)
* Upgrading k8s-srcdst to v0.2.2 [@michalschott](https://github.com/michalschott) [#7388](https://github.com/kubernetes/kops/pull/7388)
* add OpenStack etcd-manager support [@zetaab](https://github.com/zetaab) [#7395](https://github.com/kubernetes/kops/pull/7395)
* Bump k8s versions in alpha channel [@justinsb](https://github.com/justinsb) [#7422](https://github.com/kubernetes/kops/pull/7422)
* Update AMIs in alpha channels [@justinsb](https://github.com/justinsb) [#7420](https://github.com/kubernetes/kops/pull/7420)
* skip verification when the file already installed [@qqshfox](https://github.com/qqshfox) [#7387](https://github.com/kubernetes/kops/pull/7387)
* cleanup: fix error message typos [@beautytiger](https://github.com/beautytiger) [#7425](https://github.com/kubernetes/kops/pull/7425)
* fix Typo 'the the' -> 'the' [@xichengliudui](https://github.com/xichengliudui) [#7441](https://github.com/kubernetes/kops/pull/7441)
* ali.go: cleanup error words in messages [@beautytiger](https://github.com/beautytiger) [#7433](https://github.com/kubernetes/kops/pull/7433)
* promote k8s versions [@zetaab](https://github.com/zetaab) [#7437](https://github.com/kubernetes/kops/pull/7437)
* Dont set ExperimentalCriticalPodAnnotation feature gate in k8s 1.16 [@rifelpet](https://github.com/rifelpet) [#7430](https://github.com/kubernetes/kops/pull/7430)
* fix typo "specifiction" -> "specification" [@928234269](https://github.com/928234269) [#7440](https://github.com/kubernetes/kops/pull/7440)
* Add relnotes for 1.14.0-beta.1 [@justinsb](https://github.com/justinsb) [#7443](https://github.com/kubernetes/kops/pull/7443)
* bash script: don't assume nodeup filename [@justinsb](https://github.com/justinsb) [#7448](https://github.com/kubernetes/kops/pull/7448)
* Add doc for using custom CA [@joshbranham](https://github.com/joshbranham) [#7434](https://github.com/kubernetes/kops/pull/7434)
* nodeup download should try all mirrors [@justinsb](https://github.com/justinsb) [#7447](https://github.com/kubernetes/kops/pull/7447)
* Add nodeup to shipbot targets for release upload [@justinsb](https://github.com/justinsb) [#7449](https://github.com/kubernetes/kops/pull/7449)
* Update channel recommended versions for kops versions [@justinsb](https://github.com/justinsb) [#7446](https://github.com/kubernetes/kops/pull/7446)
* fix typo "in ingards to" -> "in regard to" [@928234269](https://github.com/928234269) [#7451](https://github.com/kubernetes/kops/pull/7451)
* Update weave to 2.5.2 [@while1eq1](https://github.com/while1eq1) [#7444](https://github.com/kubernetes/kops/pull/7444)
* cloudformation tests: use standard file comparison [@justinsb](https://github.com/justinsb) [#7450](https://github.com/kubernetes/kops/pull/7450)
* Relnotes for 1.14.0-beta.2 [@justinsb](https://github.com/justinsb) [#7461](https://github.com/kubernetes/kops/pull/7461)
* Look for sha256 and sha1 files for artifacts [@justinsb](https://github.com/justinsb) [#7468](https://github.com/kubernetes/kops/pull/7468)
* [Digital Ocean] DO-7442  upgrade godo client to latest version [@srikiz](https://github.com/srikiz) [#7467](https://github.com/kubernetes/kops/pull/7467)
* Fix Flatcar distro [@mazzy89](https://github.com/mazzy89) [#7464](https://github.com/kubernetes/kops/pull/7464)
* fix typo "new" -> "newer" [@928234269](https://github.com/928234269) [#7462](https://github.com/kubernetes/kops/pull/7462)
* print all failure messages [@zetaab](https://github.com/zetaab) [#7465](https://github.com/kubernetes/kops/pull/7465)
* [DO-7148] Digital Ocean support for etcd-manager [@srikiz](https://github.com/srikiz) [#7435](https://github.com/kubernetes/kops/pull/7435)
* Publish sha256 artifacts for kops itself [@justinsb](https://github.com/justinsb) [#7471](https://github.com/kubernetes/kops/pull/7471)
* Ignore empty hashfiles [@justinsb](https://github.com/justinsb) [#7472](https://github.com/kubernetes/kops/pull/7472)
* Update to kubernetes 1.15 [@justinsb](https://github.com/justinsb) [#7470](https://github.com/kubernetes/kops/pull/7470)
* util/pkg/vfs: Fix swallowed errors [@alrs](https://github.com/alrs) [#7483](https://github.com/kubernetes/kops/pull/7483)
* Set GOPROXY in travis builds [@justinsb](https://github.com/justinsb) [#7485](https://github.com/kubernetes/kops/pull/7485)
* Allow configure ip to ip mode in calico [@zetaab](https://github.com/zetaab) [#7481](https://github.com/kubernetes/kops/pull/7481)
* Add exec-opts options to dockerconfig [@tvi](https://github.com/tvi) [#7460](https://github.com/kubernetes/kops/pull/7460)
* move OpenStack from alpha to beta [@zetaab](https://github.com/zetaab) [#7488](https://github.com/kubernetes/kops/pull/7488)
* Add support for netExtraArgs [@ReillyProcentive](https://github.com/ReillyProcentive) [#7429](https://github.com/kubernetes/kops/pull/7429)
* Cleanup versions, deprecate kops 1.10, remove k8s 1.8 [@mikesplain](https://github.com/mikesplain) [#7491](https://github.com/kubernetes/kops/pull/7491)
* Create verify-gomod script [@justinsb](https://github.com/justinsb) [#7498](https://github.com/kubernetes/kops/pull/7498)
* Update to golang 1.12.9 [@justinsb](https://github.com/justinsb) [#7499](https://github.com/kubernetes/kops/pull/7499)
* Corrected spelling of 'we' in the documentation [@ashishbharthi](https://github.com/ashishbharthi) [#7495](https://github.com/kubernetes/kops/pull/7495)
* fix-up docs/releases/1.11-NOTE.md spelling mistake [@tanjunchen](https://github.com/tanjunchen) [#7501](https://github.com/kubernetes/kops/pull/7501)
* Copy well-known users from apiserver [@justinsb](https://github.com/justinsb) [#7497](https://github.com/kubernetes/kops/pull/7497)
* Replace resource.FilenameOptions with []string [@justinsb](https://github.com/justinsb) [#7500](https://github.com/kubernetes/kops/pull/7500)
* Configure calico MTU [@zetaab](https://github.com/zetaab) [#7480](https://github.com/kubernetes/kops/pull/7480)
* Create env-var helper function [@justinsb](https://github.com/justinsb) [#7505](https://github.com/kubernetes/kops/pull/7505)
* Label AWS ASGs with kops.k8s.io/instancegroup [@justinsb](https://github.com/justinsb) [#7504](https://github.com/kubernetes/kops/pull/7504)
* Support for using hostPort when using flannel [@shamil](https://github.com/shamil) [#7295](https://github.com/kubernetes/kops/pull/7295)
* Remove unused ClientGetter from Drain code [@justinsb](https://github.com/justinsb) [#7509](https://github.com/kubernetes/kops/pull/7509)
* DeleteLocalData on drain [@justinsb](https://github.com/justinsb) [#7510](https://github.com/kubernetes/kops/pull/7510)
* Updating the vendored gazelle to match workspace. [@mikesplain](https://github.com/mikesplain) [#7511](https://github.com/kubernetes/kops/pull/7511)
* Add verbosity [@mikesplain](https://github.com/mikesplain) [#7514](https://github.com/kubernetes/kops/pull/7514)
* fix(addons/coredns.addons.k8s.io) Workaound to stop coredns crashing on 1.3.1 version [@phspagiari](https://github.com/phspagiari) [#7492](https://github.com/kubernetes/kops/pull/7492)
* Update rules_docker with python2 workaround [@rifelpet](https://github.com/rifelpet) [#7508](https://github.com/kubernetes/kops/pull/7508)
* Update and add back some sizes [@mikesplain](https://github.com/mikesplain) [#7515](https://github.com/kubernetes/kops/pull/7515)
* Don't try to delete ElasticIPs of NatGateway is shared [@dzoeteman](https://github.com/dzoeteman) [#7525](https://github.com/kubernetes/kops/pull/7525)
* fix(addons/networking.projectcalico.org) calico kube-controllers is needed in CRD mode [@phspagiari](https://github.com/phspagiari) [#7517](https://github.com/kubernetes/kops/pull/7517)
* remove default insecure from openstack [@zetaab](https://github.com/zetaab) [#7524](https://github.com/kubernetes/kops/pull/7524)
* docs: fix link to Metrics Server user guide [@ruxandrafed](https://github.com/ruxandrafed) [#7479](https://github.com/kubernetes/kops/pull/7479)
* fix static check error in vfssync.go [@beautytiger](https://github.com/beautytiger) [#7482](https://github.com/kubernetes/kops/pull/7482)
* fix(upup/models/cloudup/resources/addons/coredns.addons.k8s.io) missing resourceVersion [@phspagiari](https://github.com/phspagiari) [#7477](https://github.com/kubernetes/kops/pull/7477)
* modify-doc-small-mistake [@tanjunchen](https://github.com/tanjunchen) [#7519](https://github.com/kubernetes/kops/pull/7519)

## kops 1.15.0-alpha.1 to 1.15.0-beta.1

* Calico update and typha [@gjtempleton](https://github.com/gjtempleton),[@mikesplain](https://github.com/mikesplain) [#7528](https://github.com/kubernetes/kops/pull/7528)
* [Feature] CoreDNS: External CoreFile option [@gjtempleton](https://github.com/gjtempleton) [#7376](https://github.com/kubernetes/kops/pull/7376)
* Fix gomod errors [@mikesplain](https://github.com/mikesplain) [#7571](https://github.com/kubernetes/kops/pull/7571)
* Log more sensibly when we can't get sha256 [@justinsb](https://github.com/justinsb) [#7555](https://github.com/kubernetes/kops/pull/7555)
* Add horizontalPodAutoscalerDownscaleStabilization [@mikesplain](https://github.com/mikesplain) [#7573](https://github.com/kubernetes/kops/pull/7573)
* Fix kops for us-gov-east-1 #7564 [@ibrf](https://github.com/ibrf) [#7565](https://github.com/kubernetes/kops/pull/7565)
* Fix Dropped Errors in upup [@alrs](https://github.com/alrs) [#7586](https://github.com/kubernetes/kops/pull/7586)
* add cilium in error message [@PascalBourdier](https://github.com/PascalBourdier) [#7601](https://github.com/kubernetes/kops/pull/7601)
* [DO-7442] Digital Ocean add consistent volume and droplet tags for multi master feature [@srikiz](https://github.com/srikiz) [#7566](https://github.com/kubernetes/kops/pull/7566)
* Expose API Server flags needed for AWS pod identities [@rifelpet](https://github.com/rifelpet) [#7610](https://github.com/kubernetes/kops/pull/7610)
* Add logrotate for etcd/etcd-events.log [@mikesplain](https://github.com/mikesplain) [#7614](https://github.com/kubernetes/kops/pull/7614)
* Updated container-selinux url to point to the right path [@igarcia-sugarcrm](https://github.com/igarcia-sugarcrm),[@mikesplain](https://github.com/mikesplain) [#7609](https://github.com/kubernetes/kops/pull/7609)
* Check the HTTP response code when downloading URLs [@rifelpet](https://github.com/rifelpet) [#7611](https://github.com/kubernetes/kops/pull/7611)
* Clean security groups if api/ssh ips are removed from config [@zetaab](https://github.com/zetaab) [#7561](https://github.com/kubernetes/kops/pull/7561)
* Skip Docker install [@austinmoore-](https://github.com/austinmoore-) [#6957](https://github.com/kubernetes/kops/pull/6957)
* Add --wait argument to kops validate [@justinsb](https://github.com/justinsb) [#7371](https://github.com/kubernetes/kops/pull/7371)
* Fixed "NeedsUpdate" status of nodes in mixedinstancegroups after rolling update [@hippolin](https://github.com/hippolin) [#7445](https://github.com/kubernetes/kops/pull/7445)
* Associate subnets to port within OpenStack [@mitch000001](https://github.com/mitch000001) [#7578](https://github.com/kubernetes/kops/pull/7578)
* fix instance name [@zetaab](https://github.com/zetaab) [#7641](https://github.com/kubernetes/kops/pull/7641)
* Use without external router (OpenStack) [@zetaab](https://github.com/zetaab) [#7644](https://github.com/kubernetes/kops/pull/7644)
* Updating master IAM policies. [@michalschott](https://github.com/michalschott) [#7580](https://github.com/kubernetes/kops/pull/7580)
* Cherrypick #7581 into release 1.15 [@mitch000001](https://github.com/mitch000001) [#7671](https://github.com/kubernetes/kops/pull/7671)
* Pull centos.org packages from the vault [@justinsb](https://github.com/justinsb) [#7674](https://github.com/kubernetes/kops/pull/7674)
* Align AWS and kops validation for spot allocation strategy [@coufalja](https://github.com/coufalja) [#7660](https://github.com/kubernetes/kops/pull/7660)
* Limit calico cpu request to 100m [@justinsb](https://github.com/justinsb) [#7688](https://github.com/kubernetes/kops/pull/7688)
* Cherrypick #7690 onto release 1.15 [@mitch000001](https://github.com/mitch000001) [#7693](https://github.com/kubernetes/kops/pull/7693)
* Update etcd-manager with OpenStack fixes [@justinsb](https://github.com/justinsb) [#7710](https://github.com/kubernetes/kops/pull/7710)
* Change Cilium templates to standalone version [@nebril](https://github.com/nebril),[@olemarkus](https://github.com/olemarkus) [#7474](https://github.com/kubernetes/kops/pull/7474)
* Update DigitalOcean CCM to v0.1.20 [@timoreimann](https://github.com/timoreimann) [#7714](https://github.com/kubernetes/kops/pull/7714)
* Cilium standalone continuation [@olemarkus](https://github.com/olemarkus) [#7646](https://github.com/kubernetes/kops/pull/7646)
* Add calico 3.9.1 [@mikesplain](https://github.com/mikesplain) [#7694](https://github.com/kubernetes/kops/pull/7694)
* Fix some bugs reported by staticcheck [@rifelpet](https://github.com/rifelpet) [#7663](https://github.com/kubernetes/kops/pull/7663)
* Add arg min-port=1024 to dnsmasq container in kube-dns [@nr17](https://github.com/nr17) [#7020](https://github.com/kubernetes/kops/pull/7020)
* Add artifacts.k8s.io to mirror list [@justinsb](https://github.com/justinsb) [#7378](https://github.com/kubernetes/kops/pull/7378)
* Upgrade Amazon VPC CNI plugin to 1.5.4 [@rifelpet](https://github.com/rifelpet) [#7398](https://github.com/kubernetes/kops/pull/7398)
* Add event ttl flag [@tioxy](https://github.com/tioxy) [#7487](https://github.com/kubernetes/kops/pull/7487)
* Kubelet configuration: Maximum pods flag is miscalculated when using Amazon VPC CNI [@liranp](https://github.com/liranp) [#7539](https://github.com/kubernetes/kops/pull/7539)
* fix(apiserver): allow multiple service-account-key-file [@hatappi](https://github.com/hatappi) [#7781](https://github.com/kubernetes/kops/pull/7781)
* Openstack: value if spec does not associate public ips [@mitch000001](https://github.com/mitch000001) [#7649](https://github.com/kubernetes/kops/pull/7649)
