# API machinery

Kops uses the Kubernetes API machinery.  It is well designed, and very powerful, but you have to
jump through some hoops to use it.

Recommended reading: [kubernetes API changes doc](https://github.com/kubernetes/community/blob/master/contributors/devel/api_changes.md)

The kops APIs live in [pkg/apis/kops](https://github.com/kubernetes/kops/tree/master/pkg/apis/kops), both in
that directory directly (the unversioned API) and in the versioned subdirectories (`v1alpha1`, `v1alpha2`).

## Updating the generated API code

To generate the API code simply run `make apimachinery && make crds && make` to update the generated API machinery code (conversion functions).  Note
that `make apimachinery` and `make crds` (currently) only update the autogenerated code; it does not trigger a rebuild, hence the
need for `&& make`.

## Adding a field

The most common task you will do will be to add a new field.  This is relatively straightforward, because
it is backwards compatible (you have to make sure that the field is optional).

* Add the field to pkg/apis/kops, and then also to each versioned copy: pkg/apis/kops/v1alpha1, pkg/apis/kops/v1alpha2, etc
* Run the apimachinery update as above (`make apimachinery && make crds && make`)
* You likely want to update the validation logic
* You likely want to update the defaulting logic

Currently, the apimachinery code we check in is relatively stable.  However, when the generated code is large,
it is often considered good manners to your code reviewer to split a PR into multiple commits: one with the
actual changes, and then a second commit with the autogenerated code.
