## Release notes for kops 1.16 series

(The kops 1.16 release has not been released yet, this is a document to gather
the notes prior to the release).

# Breaking changes

* Please see the notes in the 1.15 release about the apiGroup changing from kops
  to kops.k8s.io

* A controller is now used to apply labels to nodes.  If you are not using AWS,
  GCE or OpenStack your (non-master) nodes may not have labels applied
  correctly.

# Significant changes

* If upgrading from 1.11 or earlier, please see the notes in previous releases
  about upgrading through kubernetes 1.12, with the etcd3 upgrade.

* A new component runs on the master nodes now: kops-controller.
  kops-controller currently labels nodes, but will likely perform additional
  functionality in future releases.

# Required Actions

* If either a Kops 1.16 alpha release or a custom Kops build was used on a cluster,
  a kops-controller Deployment may have been created that should get deleted.
  Run `kubectl -n kube-system delete deployment kops-controller` after upgrading to Kops 1.16.0-beta.1 or later.

* Kubernetes 1.9 users will need to enable the PodPriority feature gate. This is required for newer versions of Kops.

  To enable the Pod priority feature, follow these steps:
  ```
  kops edit cluster
  # Add the following section
  spec:
    kubelet:
      featureGates:
        PodPriority: "true"
  ```
 
# Deprecations

* The `kops/v1alpha1` API is deprecated and will be removed in kops 1.18. Users of `kops replace` will need to supply v1alpha2 resources.

# Full change list since 1.15.0 release

## 1.15.0-alpha.1 to 1.16.0-alpha.1

* Update release notes for 1.15.0-alpha.1 [@justinsb](https://github.com/justinsb) [#7535](https://github.com/kubernetes/kops/pull/7535)
*  When fast-building, copy a newer version of utils.tar.gz [@justinsb](https://github.com/justinsb) [#7536](https://github.com/kubernetes/kops/pull/7536)
* Bootstrap: protokube labels its own node with node-role label [@justinsb](https://github.com/justinsb) [#7537](https://github.com/kubernetes/kops/pull/7537)
* Update copyright notices [@mikesplain](https://github.com/mikesplain) [#7542](https://github.com/kubernetes/kops/pull/7542)
* Add a few docs comments on gomod and bazel [@mikesplain](https://github.com/mikesplain) [#7541](https://github.com/kubernetes/kops/pull/7541)
* Calico update and typha [@gjtempleton](https://github.com/gjtempleton),[@mikesplain](https://github.com/mikesplain) [#7528](https://github.com/kubernetes/kops/pull/7528)
* "Force" k8s 1.11.10 [@justinsb](https://github.com/justinsb) [#7423](https://github.com/kubernetes/kops/pull/7423)
* Log more sensibly when we can't get sha256 [@justinsb](https://github.com/justinsb) [#7555](https://github.com/kubernetes/kops/pull/7555)
* [Feature] CoreDNS: External CoreFile option [@gjtempleton](https://github.com/gjtempleton),[@mikesplain](https://github.com/mikesplain) [#7376](https://github.com/kubernetes/kops/pull/7376)
* Fix gomod errors [@mikesplain](https://github.com/mikesplain) [#7571](https://github.com/kubernetes/kops/pull/7571)
* Add horizontalPodAutoscalerDownscaleStabilization [@mikesplain](https://github.com/mikesplain) [#7573](https://github.com/kubernetes/kops/pull/7573)
* Associate subnets to port within OpenStack [@mitch000001](https://github.com/mitch000001) [#7578](https://github.com/kubernetes/kops/pull/7578)
* Fix kops for us-gov-east-1 #7564 [@ibrf](https://github.com/ibrf) [#7565](https://github.com/kubernetes/kops/pull/7565)
* Promote 1.13 AMI from alpha to stable [@rifelpet](https://github.com/rifelpet) [#7590](https://github.com/kubernetes/kops/pull/7590)
* Add myself @rifelpet as a reviewer [@rifelpet](https://github.com/rifelpet) [#7587](https://github.com/kubernetes/kops/pull/7587)
* Fix mkdocs [@mikesplain](https://github.com/mikesplain) [#7591](https://github.com/kubernetes/kops/pull/7591)
* Add missing OpenStack reference [@marsavela](https://github.com/marsavela) [#7567](https://github.com/kubernetes/kops/pull/7567)
* Fix Dropped Errors in upup [@alrs](https://github.com/alrs) [#7586](https://github.com/kubernetes/kops/pull/7586)
* Promote 2019-08-16 AMIs from alpha -> stable [@justinsb](https://github.com/justinsb) [#7594](https://github.com/kubernetes/kops/pull/7594)
* hack/update-expected.sh: mask development env vars [@justinsb](https://github.com/justinsb) [#7595](https://github.com/kubernetes/kops/pull/7595)
* "Force" k8s 1.11.10 in stable channel [@justinsb](https://github.com/justinsb) [#7596](https://github.com/kubernetes/kops/pull/7596)
* add cilium in error message [@PascalBourdier](https://github.com/PascalBourdier) [#7601](https://github.com/kubernetes/kops/pull/7601)
* Clean security groups if api/ssh ips are removed from config [@zetaab](https://github.com/zetaab) [#7561](https://github.com/kubernetes/kops/pull/7561)
* [DO-7442] Digital Ocean add consistent volume and droplet tags for multi master feature [@srikiz](https://github.com/srikiz) [#7566](https://github.com/kubernetes/kops/pull/7566)
* Expose API Server flags needed for AWS pod identities [@rifelpet](https://github.com/rifelpet) [#7610](https://github.com/kubernetes/kops/pull/7610)
* Add logrotate for etcd/etcd-events.log [@mikesplain](https://github.com/mikesplain) [#7614](https://github.com/kubernetes/kops/pull/7614)
* Updated container-selinux url to point to the right path [@igarcia-sugarcrm](https://github.com/igarcia-sugarcrm),[@mikesplain](https://github.com/mikesplain) [#7609](https://github.com/kubernetes/kops/pull/7609)
* Check the HTTP response code when downloading URLs [@rifelpet](https://github.com/rifelpet) [#7611](https://github.com/kubernetes/kops/pull/7611)
* Update rules_go with some fixes [@mikesplain](https://github.com/mikesplain) [#7625](https://github.com/kubernetes/kops/pull/7625)
* Change Cilium templates to standalone version [@nebril](https://github.com/nebril),[@olemarkus](https://github.com/olemarkus) [#7474](https://github.com/kubernetes/kops/pull/7474)
* Skip Docker install [@austinmoore-](https://github.com/austinmoore-) [#6957](https://github.com/kubernetes/kops/pull/6957)
* Add --wait argument to kops validate [@justinsb](https://github.com/justinsb) [#7371](https://github.com/kubernetes/kops/pull/7371)
* Fixed "NeedsUpdate" status of nodes in mixedinstancegroups after rolling update [@hippolin](https://github.com/hippolin) [#7445](https://github.com/kubernetes/kops/pull/7445)
* fix instance name [@zetaab](https://github.com/zetaab) [#7641](https://github.com/kubernetes/kops/pull/7641)
* Use without external router (OpenStack) [@zetaab](https://github.com/zetaab) [#7644](https://github.com/kubernetes/kops/pull/7644)
* Openstack: value if spec does not associate public ips [@mitch000001](https://github.com/mitch000001) [#7649](https://github.com/kubernetes/kops/pull/7649)
* Updating master IAM policies. [@michalschott](https://github.com/michalschott) [#7580](https://github.com/kubernetes/kops/pull/7580)
* Machine types g4dn [@mikesplain](https://github.com/mikesplain) [#7653](https://github.com/kubernetes/kops/pull/7653)
* OpenStack: Additional security groups for instances [@mitch000001](https://github.com/mitch000001) [#7581](https://github.com/kubernetes/kops/pull/7581)
* Add arg min-port=1024 to dnsmasq container in kube-dns [@nr17](https://github.com/nr17) [#7020](https://github.com/kubernetes/kops/pull/7020)
* Release notes for 1.13.1 [@justinsb](https://github.com/justinsb) [#7666](https://github.com/kubernetes/kops/pull/7666)
* Pull centos.org packages from the vault [@justinsb](https://github.com/justinsb) [#7674](https://github.com/kubernetes/kops/pull/7674)
* fix-typo [@tanjunchen](https://github.com/tanjunchen) [#7669](https://github.com/kubernetes/kops/pull/7669)
* Align AWS and kops validation for spot allocation strategy [@coufalja](https://github.com/coufalja) [#7660](https://github.com/kubernetes/kops/pull/7660)
* Add relnotes for 1.13.2 [@justinsb](https://github.com/justinsb) [#7681](https://github.com/kubernetes/kops/pull/7681)
* Fix some bugs reported by staticcheck [@rifelpet](https://github.com/rifelpet) [#7663](https://github.com/kubernetes/kops/pull/7663)
* Bump k8s versions in alpha channel [@olemarkus](https://github.com/olemarkus) [#7647](https://github.com/kubernetes/kops/pull/7647)
* Misleading description for KubeProxy MetricsBindAddress [@RmMsr](https://github.com/RmMsr) [#7672](https://github.com/kubernetes/kops/pull/7672)
* Fix for tarball image names after 1.16 [@justinsb](https://github.com/justinsb) [#7686](https://github.com/kubernetes/kops/pull/7686)
* Cilium standalone continuation [@olemarkus](https://github.com/olemarkus) [#7646](https://github.com/kubernetes/kops/pull/7646)
* Limit calico cpu request to 100m [@justinsb](https://github.com/justinsb) [#7688](https://github.com/kubernetes/kops/pull/7688)
* fix-up some spelling mistakes in /pkg [@tanjunchen](https://github.com/tanjunchen) [#7684](https://github.com/kubernetes/kops/pull/7684)
* kops-controller [@justinsb](https://github.com/justinsb) [#7496](https://github.com/kubernetes/kops/pull/7496)
* OpenStack: use InstanceGroup zones to populate availability zone [@mitch000001](https://github.com/mitch000001) [#7690](https://github.com/kubernetes/kops/pull/7690)
* alpha channel: image for 1.15 and general update [@justinsb](https://github.com/justinsb) [#7665](https://github.com/kubernetes/kops/pull/7665)
* Calico: upgrade pod2daemon (only) [@justinsb](https://github.com/justinsb) [#7689](https://github.com/kubernetes/kops/pull/7689)
* Add verify-staticcheck script [@rifelpet](https://github.com/rifelpet) [#7687](https://github.com/kubernetes/kops/pull/7687)
* Create tools/sha1 and sha256 helpers, simply Makefile [@justinsb](https://github.com/justinsb) [#7702](https://github.com/kubernetes/kops/pull/7702)
* kops-controller version should match version of kops [@justinsb](https://github.com/justinsb) [#7700](https://github.com/kubernetes/kops/pull/7700)
* Publish kops-controller container dump to S3/GCS [@justinsb](https://github.com/justinsb) [#7701](https://github.com/kubernetes/kops/pull/7701)
* Change from float -> resource.Quantity [@justinsb](https://github.com/justinsb) [#7708](https://github.com/kubernetes/kops/pull/7708)
* More staticcheck bugfixes and cleanup [@rifelpet](https://github.com/rifelpet) [#7696](https://github.com/kubernetes/kops/pull/7696)
* Correct word misspelling [@yuxiaobo96](https://github.com/yuxiaobo96) [#7705](https://github.com/kubernetes/kops/pull/7705)
* fix-up some spelling mistakes [@tanjunchen](https://github.com/tanjunchen) [#7704](https://github.com/kubernetes/kops/pull/7704)
* Add calico 3.9.1 [@mikesplain](https://github.com/mikesplain) [#7694](https://github.com/kubernetes/kops/pull/7694)
* Allow to use custom rootCAs [@zetaab](https://github.com/zetaab) [#7643](https://github.com/kubernetes/kops/pull/7643)
* cleanup code to cancel some staticcheck warnings [@beautytiger](https://github.com/beautytiger) [#7661](https://github.com/kubernetes/kops/pull/7661)
* Use helpers to move gzip & sha from makefile to bazel [@justinsb](https://github.com/justinsb) [#7703](https://github.com/kubernetes/kops/pull/7703)
* Update etcd-manager with OpenStack fixes [@justinsb](https://github.com/justinsb) [#7710](https://github.com/kubernetes/kops/pull/7710)
* Update etcd-manager backup image [@justinsb](https://github.com/justinsb) [#7713](https://github.com/kubernetes/kops/pull/7713)
* Update DigitalOcean CCM to v0.1.20 [@timoreimann](https://github.com/timoreimann) [#7714](https://github.com/kubernetes/kops/pull/7714)
* ineffectual assignment to [@tanjunchen](https://github.com/tanjunchen) [#7560](https://github.com/kubernetes/kops/pull/7560)
* remove duplicated entry in notes [@beautytiger](https://github.com/beautytiger) [#7715](https://github.com/kubernetes/kops/pull/7715)
* docs: fix spelling mistakes [@hwdef](https://github.com/hwdef) [#7709](https://github.com/kubernetes/kops/pull/7709)
* Docs: Adding a doc on how to propose a cherry-pick [@justinsb](https://github.com/justinsb) [#7717](https://github.com/kubernetes/kops/pull/7717)
* relnotes for 1.14.0 [@justinsb](https://github.com/justinsb) [#7725](https://github.com/kubernetes/kops/pull/7725)
* bazel: fix hashes rule to generate outputs [@justinsb](https://github.com/justinsb) [#7724](https://github.com/kubernetes/kops/pull/7724)
* remove the repeat word in docs/authentication.md b/docs/authentication.md [@tanjunchen](https://github.com/tanjunchen) [#7729](https://github.com/kubernetes/kops/pull/7729)
* Rollback alpha channels 1.14.7 [@mikesplain](https://github.com/mikesplain) [#7734](https://github.com/kubernetes/kops/pull/7734)
* Openstack block device mapping support [@Shonei](https://github.com/Shonei) [#7652](https://github.com/kubernetes/kops/pull/7652)
* Update controller-tools and CRDs [@rifelpet](https://github.com/rifelpet) [#7634](https://github.com/kubernetes/kops/pull/7634)
* Upgrade bazel's rules_go and rules_docker [@rifelpet](https://github.com/rifelpet) [#7727](https://github.com/kubernetes/kops/pull/7727)
* simplfy code [@tanjunchen](https://github.com/tanjunchen) [#7745](https://github.com/kubernetes/kops/pull/7745)
* fix-up some staticcheck error [@tanjunchen](https://github.com/tanjunchen) [#7744](https://github.com/kubernetes/kops/pull/7744)
* nodeup download: try to use compression [@justinsb](https://github.com/justinsb) [#7751](https://github.com/kubernetes/kops/pull/7751)
* Add optional RBE support for kops [@fejta](https://github.com/fejta) [#7756](https://github.com/kubernetes/kops/pull/7756)
* Update readme for 1.14 [@mikesplain](https://github.com/mikesplain) [#7757](https://github.com/kubernetes/kops/pull/7757)
* Add a BAZEL_CONFIG Makefile arg to bazel commands [@fejta](https://github.com/fejta) [#7758](https://github.com/kubernetes/kops/pull/7758)
* Memberlist gossip implementation [@jacksontj](https://github.com/jacksontj) [#7521](https://github.com/kubernetes/kops/pull/7521)
* bazel: comment out shallow_since as fails to build with bazel 1.0 [@justinsb](https://github.com/justinsb) [#7771](https://github.com/kubernetes/kops/pull/7771)
* Kops controller support for OpenStack [@zetaab](https://github.com/zetaab) [#7692](https://github.com/kubernetes/kops/pull/7692)
* Upgrade Amazon VPC CNI plugin to 1.5.4 [@rifelpet](https://github.com/rifelpet) [#7398](https://github.com/kubernetes/kops/pull/7398)
* Add documentation for updating CRDs when making API changes [@rifelpet](https://github.com/rifelpet) [#7728](https://github.com/kubernetes/kops/pull/7728)
* Kubelet configuration: Maximum pods flag is miscalculated when using Amazon VPC CNI [@liranp](https://github.com/liranp) [#7539](https://github.com/kubernetes/kops/pull/7539)
* Add event ttl flag [@tioxy](https://github.com/tioxy) [#7487](https://github.com/kubernetes/kops/pull/7487)
* docs: document state store configuration [@mitch000001](https://github.com/mitch000001) [#7750](https://github.com/kubernetes/kops/pull/7750)
* Add artifacts.k8s.io to mirror list [@justinsb](https://github.com/justinsb) [#7378](https://github.com/kubernetes/kops/pull/7378)
* fix-up gosimple check error [@tanjunchen](https://github.com/tanjunchen) [#7754](https://github.com/kubernetes/kops/pull/7754)
* fix-up staticcheck error [@tanjunchen](https://github.com/tanjunchen) [#7755](https://github.com/kubernetes/kops/pull/7755)
* remove the unnecessary newline and unused vars [@tanjunchen](https://github.com/tanjunchen) [#7760](https://github.com/kubernetes/kops/pull/7760)
* Upload dns-controller archive, use in KOPS_BASE_URL [@justinsb](https://github.com/justinsb) [#7777](https://github.com/kubernetes/kops/pull/7777)
* Move kops-controller to use a yaml configuration file [@justinsb](https://github.com/justinsb) [#7774](https://github.com/kubernetes/kops/pull/7774)
* fix(apiserver): allow multiple service-account-key-file [@hatappi](https://github.com/hatappi) [#7781](https://github.com/kubernetes/kops/pull/7781)
* Move kops-controller to daemonset [@justinsb](https://github.com/justinsb) [#7783](https://github.com/kubernetes/kops/pull/7783)
* Change default port for memberlist from 3997 [@justinsb](https://github.com/justinsb) [#7778](https://github.com/kubernetes/kops/pull/7778)
* bazel: remove deprecated stamp attribute from container building [@justinsb](https://github.com/justinsb) [#7779](https://github.com/kubernetes/kops/pull/7779)
* Promote alpha to stable, bump alpha [@mikesplain](https://github.com/mikesplain) [#7795](https://github.com/kubernetes/kops/pull/7795)
* Fix network changed in openstack ports [@zetaab](https://github.com/zetaab) [#7807](https://github.com/kubernetes/kops/pull/7807)
* Upgrade go version to 1.12.11 [@rifelpet](https://github.com/rifelpet) [#7811](https://github.com/kubernetes/kops/pull/7811)
* Rename upload command variable in Makefile [@bittopaz](https://github.com/bittopaz) [#7798](https://github.com/kubernetes/kops/pull/7798)
* fix-up bug in nodeup/pkg/model [@tanjunchen](https://github.com/tanjunchen) [#7793](https://github.com/kubernetes/kops/pull/7793)
* fix string trim func in main [@beautytiger](https://github.com/beautytiger) [#7801](https://github.com/kubernetes/kops/pull/7801)
* Alicloud: add OSS as upload dest [@bittopaz](https://github.com/bittopaz) [#7802](https://github.com/kubernetes/kops/pull/7802)
* Alicloud: fix status discovery [@bittopaz](https://github.com/bittopaz) [#7804](https://github.com/kubernetes/kops/pull/7804)
* Alicloud: add hostname override [@bittopaz](https://github.com/bittopaz) [#7803](https://github.com/kubernetes/kops/pull/7803)
* Alicloud: fix error msg when check hostname [@bittopaz](https://github.com/bittopaz) [#7814](https://github.com/kubernetes/kops/pull/7814)
* replace slice loop with append for simple and clear [@beautytiger](https://github.com/beautytiger) [#7759](https://github.com/kubernetes/kops/pull/7759)
* dnsprovider,nodeup: fix static check [@hwdef](https://github.com/hwdef) [#7818](https://github.com/kubernetes/kops/pull/7818)
* pkg: fix static check [@hwdef](https://github.com/hwdef) [#7819](https://github.com/kubernetes/kops/pull/7819)
* Add relnotes for 1.15.0-beta.1 [@justinsb](https://github.com/justinsb) [#7797](https://github.com/kubernetes/kops/pull/7797)
* Docs cleanup / mkdocs migration [@mikesplain](https://github.com/mikesplain) [#7593](https://github.com/kubernetes/kops/pull/7593)
* Allow for override of CoreDNS version [@gjtempleton](https://github.com/gjtempleton) [#7794](https://github.com/kubernetes/kops/pull/7794)
* Add netlify config [@mikesplain](https://github.com/mikesplain) [#7823](https://github.com/kubernetes/kops/pull/7823)
* Update etcd-manager to 3.0.20191025 [@justinsb](https://github.com/justinsb) [#7822](https://github.com/kubernetes/kops/pull/7822)
* Document eventTTL [@tioxy](https://github.com/tioxy) [#7826](https://github.com/kubernetes/kops/pull/7826)
* use existing network and subnet in OpenStack [@zetaab](https://github.com/zetaab) [#7699](https://github.com/kubernetes/kops/pull/7699)
* fix static check [@hwdef](https://github.com/hwdef) [#7831](https://github.com/kubernetes/kops/pull/7831)
* fix firewalls for OpenStack [@zetaab](https://github.com/zetaab) [#7829](https://github.com/kubernetes/kops/pull/7829)
* Set default image for OpenStack CCM [@zetaab](https://github.com/zetaab) [#7773](https://github.com/kubernetes/kops/pull/7773)
* Add protocol rules to master as well [@zetaab](https://github.com/zetaab) [#7834](https://github.com/kubernetes/kops/pull/7834)
* Fix permalink [@mikesplain](https://github.com/mikesplain) [#7836](https://github.com/kubernetes/kops/pull/7836)
* Remove extraneous document separator causing failures applying addons [@ripta](https://github.com/ripta) [#7857](https://github.com/kubernetes/kops/pull/7857)
* docs(addons): fix broken links [@mitch000001](https://github.com/mitch000001) [#7846](https://github.com/kubernetes/kops/pull/7846)
* Fix extraneous whitespace in warning message [@johngmyers](https://github.com/johngmyers) [#7869](https://github.com/kubernetes/kops/pull/7869)
* Revert "Upgrade Amazon VPC CNI plugin to 1.5.4" [@rifelpet](https://github.com/rifelpet) [#7847](https://github.com/kubernetes/kops/pull/7847)
* mark weavenet-pod as system-critical [@jochen42](https://github.com/jochen42) [#7874](https://github.com/kubernetes/kops/pull/7874)
* increase retry count [@zetaab](https://github.com/zetaab) [#7881](https://github.com/kubernetes/kops/pull/7881)
* awsup: fix shadowed var when looking for etcd cluster name [@diversario](https://github.com/diversario) [#7868](https://github.com/kubernetes/kops/pull/7868)
* Add back calico metrics options [@mikesplain](https://github.com/mikesplain) [#7885](https://github.com/kubernetes/kops/pull/7885)
* Fix kops upgrade cluster link [@flackdl](https://github.com/flackdl) [#7887](https://github.com/kubernetes/kops/pull/7887)
* Fix doc linkages to addons [@s3than](https://github.com/s3than),[@justinsb](https://github.com/justinsb) [#7830](https://github.com/kubernetes/kops/pull/7830)
* Alicloud: remove unnecessary if when evaluateHostnameOverride [@bittopaz](https://github.com/bittopaz) [#7850](https://github.com/kubernetes/kops/pull/7850)
* Alicloud: split ProviderID with "." [@bittopaz](https://github.com/bittopaz) [#7852](https://github.com/kubernetes/kops/pull/7852)
* Fix behavior of mock DescribeAutoScalingGroups when no names supplied [@johngmyers](https://github.com/johngmyers) [#7867](https://github.com/kubernetes/kops/pull/7867)
* Update "Guide" links for DigitalOcean & OpenStack [@jcodybaker](https://github.com/jcodybaker) [#7884](https://github.com/kubernetes/kops/pull/7884)
* Add ci postsubmit script for pushing images to staging [@justinsb](https://github.com/justinsb) [#7697](https://github.com/kubernetes/kops/pull/7697)
* remove the unnecessary break [@tanjunchen](https://github.com/tanjunchen) [#7791](https://github.com/kubernetes/kops/pull/7791)
* [DO-7442] Add gossip cluster implementation for Digital Ocean cloud provider [@srikiz](https://github.com/srikiz) [#7838](https://github.com/kubernetes/kops/pull/7838)
* fix-up static-check [@tanjunchen](https://github.com/tanjunchen) [#7841](https://github.com/kubernetes/kops/pull/7841)
* remove myself from OWNERS [@andrewsykim](https://github.com/andrewsykim) [#7888](https://github.com/kubernetes/kops/pull/7888)
* Cleanup make targets [@rifelpet](https://github.com/rifelpet) [#7863](https://github.com/kubernetes/kops/pull/7863)
* fix golint failures [@FayerZhang](https://github.com/FayerZhang) [#7854](https://github.com/kubernetes/kops/pull/7854)
* Recommend kops 1.11.1 [@justinsb](https://github.com/justinsb) [#7892](https://github.com/kubernetes/kops/pull/7892)
* fix-up staticcheck problems [@tanjunchen](https://github.com/tanjunchen) [#7839](https://github.com/kubernetes/kops/pull/7839)
* Add hint how to determine mount path of etcd data [@FuriKuri](https://github.com/FuriKuri) [#7735](https://github.com/kubernetes/kops/pull/7735)
* stable channel: promote default AMIs from alpha -> stable [@justinsb](https://github.com/justinsb) [#7893](https://github.com/kubernetes/kops/pull/7893)
* Release notes for 1.14.1 [@justinsb](https://github.com/justinsb) [#7895](https://github.com/kubernetes/kops/pull/7895)
