This document describes changes in the kops 1.7 release (compared to the 1.6 release)

# Significant changes

* Manifests are rewritten by default, which includes a normalization phase.
  This can make it hard to understand the actual changes (as opposed to just the formatting changes).
  A feature flag has been added, `export KOPS_FEATURE_FLAGS="-RewriteManifests"` which can be used
  to disable manifest rewriting.  A recommendation: you can run `kops update` twice, once without
  manifest formatting to show the real changes, and then immediately afterwards with manifest changes,
  which will be just formatting changes.  Run `KOPS_FEATURE_FLAGS="-RewriteManifests" kops update cluster`,
  to show the real changes, apply them with `KOPS_FEATURE_FLAGS="-RewriteManifests" kops update cluster --yes`,
  then run `kops update cluster` to show the formatting changes, followed by `kops update cluster --yes`

* Default disk size increased to 64GB (masters) and 128GB (nodes).  This does have a higher cost, but also gives us more inodes & more iops (and more disk space, of course!)
* Calico now configured with the correct pod CIDR: #2768. Please refer to the *Required Actions* section for details regarding this.

# Required Actions

* Existing Calico users on clusters that were created prior to kops 1.7 are susceptible to IP conflict between Pods and Services due to an overlap of the two IP ranges. Migration to a new Pod CIDR is recommended, and is a manual procedure due to risk of potential downtime during this operation. For the migration procedure, please refer to [this document](../upgrade_from_kops_1.6_to_1.7_calico_cidr_migration.md).



# Full changelist

* alpha channel: Bump k8s version to 1.6.6 [@justinsb](https://github.com/justinsb) [#2788](https://github.com/kubernetes/kops/pull/2788)
* Add release notes for 1.6.2 [@justinsb](https://github.com/justinsb) [#2786](https://github.com/kubernetes/kops/pull/2786)
* Support generated clientset as alternative to vfs clientset [@justinsb](https://github.com/justinsb) [#2622](https://github.com/kubernetes/kops/pull/2622)
* Change to EtcdBuilder in ETCD model [@shamil](https://github.com/shamil) [#2813](https://github.com/kubernetes/kops/pull/2813)
* fixing govet issues and adding test directory [@chrislovecnm](https://github.com/chrislovecnm) [#2805](https://github.com/kubernetes/kops/pull/2805)
* removing comments that are not longer generated [@chrislovecnm](https://github.com/chrislovecnm) [#2799](https://github.com/kubernetes/kops/pull/2799)
* single-to-multi-master doc: Create all master instances groups at first [@dtan4](https://github.com/dtan4) [#2774](https://github.com/kubernetes/kops/pull/2774)
* Bump canal addon version [@trthomps](https://github.com/trthomps) [#2823](https://github.com/kubernetes/kops/pull/2823)
* fixing bug with using shell flag [@chrislovecnm](https://github.com/chrislovecnm) [#2843](https://github.com/kubernetes/kops/pull/2843)
* Fix missing ids in a few log messages [@justinsb](https://github.com/justinsb) [#2836](https://github.com/kubernetes/kops/pull/2836)
* Documentation updates including using YAML and API [@chrislovecnm](https://github.com/chrislovecnm) [#2795](https://github.com/kubernetes/kops/pull/2795)
* Change logrotate compress to delaycompress to prevent fluentd log tailing from getting stuck [@r4j4h](https://github.com/r4j4h) [#2835](https://github.com/kubernetes/kops/pull/2835)
* Setting versions for go and kubectl in protokube [@chrislovecnm](https://github.com/chrislovecnm) [#2814](https://github.com/kubernetes/kops/pull/2814)
* Kubelet / Master Authentication Options [@gambol99](https://github.com/gambol99) [#2831](https://github.com/kubernetes/kops/pull/2831)
* Lock kubectl version [@justinsb](https://github.com/justinsb) [#2849](https://github.com/kubernetes/kops/pull/2849)
* Add field to enable EBS Volume Optimization [@austinmoore-](https://github.com/austinmoore-) [#2822](https://github.com/kubernetes/kops/pull/2822)
* Added documentation for vSphere support status. [@prashima](https://github.com/prashima) [#2850](https://github.com/kubernetes/kops/pull/2850)
* Propose awsudo as a workaround for kops mfa [@max-lobur](https://github.com/max-lobur) [#2791](https://github.com/kubernetes/kops/pull/2791)
* Have kops 1.7 use k8s 1.7 [@justinsb](https://github.com/justinsb) [#2838](https://github.com/kubernetes/kops/pull/2838)
* Upgrade kube-dns for 1.7 [@justinsb](https://github.com/justinsb) [#2839](https://github.com/kubernetes/kops/pull/2839)
* Update our dependencies to the release-1.7 branch versions [@justinsb](https://github.com/justinsb) [#2840](https://github.com/kubernetes/kops/pull/2840)
* instructions for gossip-based cluster [@arun-gupta](https://github.com/arun-gupta) [#2853](https://github.com/kubernetes/kops/pull/2853)
* fixing a typo [@arun-gupta](https://github.com/arun-gupta) [#2854](https://github.com/kubernetes/kops/pull/2854)
* Fix typos in kops_upgrade.md [@aknuds1](https://github.com/aknuds1) [#2815](https://github.com/kubernetes/kops/pull/2815)
* Makefile targets for go 1.8 & 1.9 [@justinsb](https://github.com/justinsb) [#2848](https://github.com/kubernetes/kops/pull/2848)
* review doc on creating instance group [@gianrubio](https://github.com/gianrubio) [#2872](https://github.com/kubernetes/kops/pull/2872)
* increase default instance root volume size [@chrislovecnm](https://github.com/chrislovecnm) [#2847](https://github.com/kubernetes/kops/pull/2847)
* Add comment for Subnets field [@justinsb](https://github.com/justinsb) [#2874](https://github.com/kubernetes/kops/pull/2874)
* Update docs for new volume sizes [@justinsb](https://github.com/justinsb) [#2873](https://github.com/kubernetes/kops/pull/2873)
* Doc fixes [@chrislovecnm](https://github.com/chrislovecnm) [#2865](https://github.com/kubernetes/kops/pull/2865)
* Initial support for authentication (kopeio) [@justinsb](https://github.com/justinsb) [#2773](https://github.com/kubernetes/kops/pull/2773)
* Add SG parameter into AWS cloud-config [@alexandrst88](https://github.com/alexandrst88) [#2808](https://github.com/kubernetes/kops/pull/2808)
* Update calico to use the correct CIDR for pods [@ottoyiu](https://github.com/ottoyiu) [#2768](https://github.com/kubernetes/kops/pull/2768)
* Bump dns-controller & kops for 1.7.0-alpha.1 [@justinsb](https://github.com/justinsb) [#2880](https://github.com/kubernetes/kops/pull/2880)
* Properly set IAM prefix for GovCloud #2887 [@amdonov](https://github.com/amdonov) [#2888](https://github.com/kubernetes/kops/pull/2888)
* vendor github.com/digitalocean/godo [@andrewsykim](https://github.com/andrewsykim) [#2891](https://github.com/kubernetes/kops/pull/2891)
* vendor github.com/google/go-querystring and github.com/tent/http-link-go [@andrewsykim](https://github.com/andrewsykim) [#2892](https://github.com/kubernetes/kops/pull/2892)
* Corrected spelling of ClusterSpec in README.md. [@jburnham](https://github.com/jburnham) [#2898](https://github.com/kubernetes/kops/pull/2898)
* Asset redirection via manifest parsing [@justinsb](https://github.com/justinsb) [#2769](https://github.com/kubernetes/kops/pull/2769)
* bump kubernetes dashboard version [@gianrubio](https://github.com/gianrubio) [#2789](https://github.com/kubernetes/kops/pull/2789)
* fixing remapping, as it was not returning the remapped data [@chrislovecnm](https://github.com/chrislovecnm) [#2905](https://github.com/kubernetes/kops/pull/2905)
* Add omitempty json tag to resolvConf fields [@austinmoore-](https://github.com/austinmoore-) [#2916](https://github.com/kubernetes/kops/pull/2916)
* Fix a documentation instance group doc typo [@erickt](https://github.com/erickt) [#2910](https://github.com/kubernetes/kops/pull/2910)
* Fixing wrong brackets on links [@chrislovecnm](https://github.com/chrislovecnm) [#2884](https://github.com/kubernetes/kops/pull/2884)
* add registryMirrors [@qqshfox](https://github.com/qqshfox) [#2893](https://github.com/kubernetes/kops/pull/2893)
* Add instructions for deleting cluster [@danielbryantuk](https://github.com/danielbryantuk) [#2902](https://github.com/kubernetes/kops/pull/2902)
* Start 1.7 release notes [@justinsb](https://github.com/justinsb) [#2875](https://github.com/kubernetes/kops/pull/2875)
* Increase fs.inotify.max_user_instances limit. Fixes #2912 [@steelecliftonberry](https://github.com/steelecliftonberry) [#2913](https://github.com/kubernetes/kops/pull/2913)
* fix cniAsset from env var [@qqshfox](https://github.com/qqshfox) [#2897](https://github.com/kubernetes/kops/pull/2897)
* Trivial doc tidying. [@rk295](https://github.com/rk295) [#2686](https://github.com/kubernetes/kops/pull/2686)
* kube-proxy: set hostname-override on AWS [@justinsb](https://github.com/justinsb) [#2936](https://github.com/kubernetes/kops/pull/2936)
* correct misspelling "device" for vsphere/vsphere_cloud.go [@fate-grand-order](https://github.com/fate-grand-order) [#2932](https://github.com/kubernetes/kops/pull/2932)
* Doc fixes [@mrtyler](https://github.com/mrtyler) [#2931](https://github.com/kubernetes/kops/pull/2931)
* Fix typos in create cluster docs [@benhartley](https://github.com/benhartley) [#2935](https://github.com/kubernetes/kops/pull/2935)
* fix delete_cluster for those regions don't have route53 [@qqshfox](https://github.com/qqshfox) [#2940](https://github.com/kubernetes/kops/pull/2940)
* Update weave to 2.0.1 [@marccarre](https://github.com/marccarre) [#2829](https://github.com/kubernetes/kops/pull/2829)
* Query for available instance types [@justinsb](https://github.com/justinsb) [#2837](https://github.com/kubernetes/kops/pull/2837)
* digitalocean feature flag [@andrewsykim](https://github.com/andrewsykim) [#2929](https://github.com/kubernetes/kops/pull/2929)
* Updating ingress-controller, default-backend and fixing permission for ClusterRole [@BradErz](https://github.com/BradErz) [#2896](https://github.com/kubernetes/kops/pull/2896)
* Dedent weave manifest, for easier diffing [@justinsb](https://github.com/justinsb) [#2945](https://github.com/kubernetes/kops/pull/2945)
* Typos and add note about need for --dns-zone [@deinspanjer](https://github.com/deinspanjer) [#2817](https://github.com/kubernetes/kops/pull/2817)
* digitalocean support -- dns provider [@andrewsykim](https://github.com/andrewsykim) [#2864](https://github.com/kubernetes/kops/pull/2864)
* Reduce size of images using debian-base [@aledbf](https://github.com/aledbf) [#2885](https://github.com/kubernetes/kops/pull/2885)
* Fix test breakage by PRs that crossed [@justinsb](https://github.com/justinsb) [#2948](https://github.com/kubernetes/kops/pull/2948)
* Fixes #2708 broken kubernetes-dashboard due to RBAC [@BradErz](https://github.com/BradErz) [#2949](https://github.com/kubernetes/kops/pull/2949)
* Restore removed submodules [@justinsb](https://github.com/justinsb) [#2946](https://github.com/kubernetes/kops/pull/2946)
* support china region [@qqshfox](https://github.com/qqshfox) [#2947](https://github.com/kubernetes/kops/pull/2947)
* Fix swallowed errors in upup subdirectory. [@alrs](https://github.com/alrs) [#2951](https://github.com/kubernetes/kops/pull/2951)
* Fix swallowed errors under pkg subdirectory. [@alrs](https://github.com/alrs) [#2957](https://github.com/kubernetes/kops/pull/2957)
* Fix swallowed err in federation. [@alrs](https://github.com/alrs) [#2952](https://github.com/kubernetes/kops/pull/2952)
* Try adding header to generated CLI docs [@justinsb](https://github.com/justinsb) [#2944](https://github.com/kubernetes/kops/pull/2944)
* Fixed unused import in tests. [@alrs](https://github.com/alrs) [#2953](https://github.com/kubernetes/kops/pull/2953)
* Example of how to do bash in our CLI help [@justinsb](https://github.com/justinsb) [#2943](https://github.com/kubernetes/kops/pull/2943)
* Add back integration tests into CI [@justinsb](https://github.com/justinsb) [#2958](https://github.com/kubernetes/kops/pull/2958)
* Unsetting the variable in the Make file [@BradErz](https://github.com/BradErz) [#2962](https://github.com/kubernetes/kops/pull/2962)
* Fixes #2535. [@rdtr](https://github.com/rdtr) [#2549](https://github.com/kubernetes/kops/pull/2549)
* Update generated apimachinery [@justinsb](https://github.com/justinsb) [#2965](https://github.com/kubernetes/kops/pull/2965)
* Cleaner yaml formatting [@justinsb](https://github.com/justinsb) [#2967](https://github.com/kubernetes/kops/pull/2967)
* Release notes for Calico Pod CIDR changes made in #2768 [@ottoyiu](https://github.com/ottoyiu) [#2911](https://github.com/kubernetes/kops/pull/2911)
* Initial work on kops-server [@justinsb](https://github.com/justinsb) [#2766](https://github.com/kubernetes/kops/pull/2766)
* Issue #2977: Improve Manifest documentation [@StevenACoffman](https://github.com/StevenACoffman) [#2981](https://github.com/kubernetes/kops/pull/2981)
* Add a feature flag for formatting assets [@justinsb](https://github.com/justinsb) [#2968](https://github.com/kubernetes/kops/pull/2968)
* protokube changes for allowing running a custom etcd container [@chrislovecnm](https://github.com/chrislovecnm) [#2966](https://github.com/kubernetes/kops/pull/2966)
* versioning kops-server container, and changing container  [@chrislovecnm](https://github.com/chrislovecnm) [#2985](https://github.com/kubernetes/kops/pull/2985)
* Add reserve compute resources kubelet flags [@itskingori](https://github.com/itskingori) [#2982](https://github.com/kubernetes/kops/pull/2982)
* Add full changelist (so far) for the 1.7 release to the release notes [@justinsb](https://github.com/justinsb) [#2991](https://github.com/kubernetes/kops/pull/2991)
* Fix swallowed err variable in vfs package [@alrs](https://github.com/alrs) [#2995](https://github.com/kubernetes/kops/pull/2995)
* Mark kops 1.7.0-beta.1 [@justinsb](https://github.com/justinsb) [#3005](https://github.com/kubernetes/kops/pull/3005)
* Add missing step to pull template file; correct kops option. [@j14s](https://github.com/j14s) [#3006](https://github.com/kubernetes/kops/pull/3006)
* Test kops submit-queue [@cjwagner](https://github.com/cjwagner) [#3012](https://github.com/kubernetes/kops/pull/3012)
* Kops apiserver support for openapi and generated API docs [@pwittrock](https://github.com/pwittrock) [#3001](https://github.com/kubernetes/kops/pull/3001)
* Fix for the instructions about using KOPS_FEATURE_FLAGS for drain and… [@FrederikNS](https://github.com/FrederikNS) [#2934](https://github.com/kubernetes/kops/pull/2934)
* populate cloud labels with cluster autoscaler tags [@sethpollack](https://github.com/sethpollack) [#3017](https://github.com/kubernetes/kops/pull/3017)
* Support for lifecycles [@justinsb](https://github.com/justinsb) [#2763](https://github.com/kubernetes/kops/pull/2763)
* Map pod-infra-container-image flag [@justinsb](https://github.com/justinsb) [#3021](https://github.com/kubernetes/kops/pull/3021)
* New inventory assets API [@chrislovecnm](https://github.com/chrislovecnm) [#2964](https://github.com/kubernetes/kops/pull/2964)
* Copy docker images when they are redirected [@justinsb](https://github.com/justinsb) [#3016](https://github.com/kubernetes/kops/pull/3016)
* Updates for g3 machine type [@chrislovecnm](https://github.com/chrislovecnm) [#2986](https://github.com/kubernetes/kops/pull/2986)
* Adding ssh access flag  [@BradErz](https://github.com/BradErz) [#3014](https://github.com/kubernetes/kops/pull/3014)
* Add gen-api-docs target to makefile [@justinsb](https://github.com/justinsb) [#3004](https://github.com/kubernetes/kops/pull/3004)
* Remap pause image through our AssetBuilder [@justinsb](https://github.com/justinsb) [#3026](https://github.com/kubernetes/kops/pull/3026)
* removing dead code [@chrislovecnm](https://github.com/chrislovecnm) [#3030](https://github.com/kubernetes/kops/pull/3030)
* Handle the case where GetCluster returns nil [@justinsb](https://github.com/justinsb) [#3038](https://github.com/kubernetes/kops/pull/3038)
* Create labels.yaml file to define the 'lgtm' and 'approved' labels. [@cjwagner](https://github.com/cjwagner) [#3042](https://github.com/kubernetes/kops/pull/3042)
* Fix migration script to take ipip mode into account [@ottoyiu](https://github.com/ottoyiu) [#3043](https://github.com/kubernetes/kops/pull/3043)
* Updating flannel to use RBAC in 1.6 so its not broken when deploying [@BradErz](https://github.com/BradErz) [#3033](https://github.com/kubernetes/kops/pull/3033)
* Honor shared tags when deleting subnets/vpcs [@justinsb](https://github.com/justinsb) [#2960](https://github.com/kubernetes/kops/pull/2960)
* Create test for ssh-access [@justinsb](https://github.com/justinsb) [#3027](https://github.com/kubernetes/kops/pull/3027)
* Fixing "dederation" [@craigmonson](https://github.com/craigmonson) [#3050](https://github.com/kubernetes/kops/pull/3050)
