## 1.6.0-alpha.1

1.6.0-alpha.1 is a prerelease early-access of kops 1.6, which is the release with full support for kubernetes 1.6.
This version of kops & kubernetes has not yet undergone extensive validation, and there will be improvements
made before release of kops 1.6.0.

This is not a full set of release notes, but rather a summary of the highest impact changes in the 1.6 release:

* RBAC can be enabled by passing the `--authorization=rbac` parameter to `kops create cluster`,
or via `kops edit cluster` and change `authorization` from `alwaysAllow: {}` to `rbac: {}`

* The standard RBAC policy for 1.6 means that all access to the Kubernetes API using the default
service account method will be denied.

* The taints & tolerations have changed as part of their graduation from alpha.  The taint is now a field on the node:

```yaml
spec:
  taints:
  - effect: NoSchedule
    key: node-role.kubernetes.io/master
```

An example toleration (as used in dns-controller) is:

```yaml
spec:
  tolerations:
  - effect: NoSchedule
    key: node-role.kubernetes.io/master
```

Note that the annotation form is ignored.  To schedule a pod on the master, the toleration must be updated
and moved from an annotation to the field.

* A new label for nodes, mirroring the toleration, is added and is now preferred: `node-role.kubernetes.io/master=`
(`node-role.kubernetes.io/master` with an empty value).  `kubernetes.io/role=master` is still present, but
the `node-role.kubernetes.io/<role>=` form is preferred.  `kubernetes.io/role=node` and `node-role.kubernetes.io/node=`
are also present.

Workaround: create the configmap with `kubectl create configmap -n kube-system kube-dns` before updating.

## Known Issues

##### Rolling updates

Rolling update to 1.6 does not succeed because new kube-dns pods mount a configmap with an optional volume map,
but that is enforced by the kubelets, which are upgraded after the master.

##### etcd3

`kops` is not yet recommending etcd3. We do however support a **run at your own risk** option. Right now we are working on resolving issues such as HA upgrade support.