## Release notes for kops 1.15 series

(The kops 1.15 release has not been released yet, this is a document to gather the notes prior to the release).

# Significant changes

* kops now supports running with objects as CRDs, stored in a kubernetes apiserver.
* The apiGroup for kops objects has changed from `kops` to `kops.k8s.io`, to
  support CRDs.  You can continue to provide either apiGroup as input (but you
  should ideally move to `kops.k8s.io`), but the output will always be of the
  `kops.k8s.io` form.
* Rolling updates are much faster by default.  A lot of the time-padding that
  was in previous versions has been replaced with reliance on validation.  The
  `--cloudonly` case is much faster than previously, which we believe to be
  correct because we expect this is normally for disaster-recovery scenarios,
  but you may want to specify longer timings via flags if you are relying on
  time-based delays.

# Required Actions

* If checking the output as a string (yaml or json), please note that the
  apiGroup will now be kops.k8s.io, not kops.  If performing strict string
  comparison you will need to update your expected values.

* Kubernetes 1.9 users will need to enable the PodPriority feature gate. This is required for newer versions of Kops.

  To enable the Pod priority feature, follow these steps:
  ```
  kops edit cluster
  # Add the following section
  spec:
    kubelet:
      featureGates:
        PodPriority: "true"
  ```
 
# Full change list since 1.14.0 release

